// java wrapper for vtkVoxelGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVoxelGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVoxelGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVoxelGrid",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelGrid_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelGrid_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVoxelGrid_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVoxelGrid_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetConfigurationStyle_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConfigurationStyle(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelGrid_GetConfigurationStyle_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConfigurationStyle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetConfigurationStyleToManual_16(JNIEnv* env, jobject obj)
{

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConfigurationStyleToManual();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetConfigurationStyleToLeafSize_17(JNIEnv* env, jobject obj)
{

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConfigurationStyleToLeafSize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetConfigurationStyleToAutomatic_18(JNIEnv* env, jobject obj)
{

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConfigurationStyleToAutomatic();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetDivisions_19(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDivisions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetDivisions_110(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDivisions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVoxelGrid_GetDivisions_111(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDivisions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetLeafSize_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeafSize(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetLeafSize_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeafSize(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkVoxelGrid_GetLeafSize_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeafSize();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetNumberOfPointsPerBin_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPointsPerBin(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelGrid_GetNumberOfPointsPerBinMinValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBinMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelGrid_GetNumberOfPointsPerBinMaxValue_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBinMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelGrid_GetNumberOfPointsPerBin_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBin();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelGrid_SetKernel_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInterpolationKernel * temp0;
  temp0 = static_cast<vtkInterpolationKernel*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKernel(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVoxelGrid_GetKernel_120(JNIEnv* env, jobject obj)
{
  vtkInterpolationKernel * temp20;

  vtkVoxelGrid* op = static_cast<vtkVoxelGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKernel();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVoxelGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVoxelGrid::New());
}
