// java wrapper for vtkPTSReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPTSReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPTSReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPTSReader",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPTSReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPTSReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPTSReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPTSReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPTSReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_LimitReadToBoundsOn_16(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LimitReadToBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_LimitReadToBoundsOff_17(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LimitReadToBoundsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetLimitReadToBounds_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLimitReadToBounds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPTSReader_GetLimitReadToBounds_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLimitReadToBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetReadBounds_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetReadBounds_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPTSReader_GetReadBounds_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_OutputDataTypeIsDoubleOn_113(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutputDataTypeIsDoubleOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_OutputDataTypeIsDoubleOff_114(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutputDataTypeIsDoubleOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetOutputDataTypeIsDouble_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputDataTypeIsDouble(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPTSReader_GetOutputDataTypeIsDouble_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputDataTypeIsDouble();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_LimitToMaxNumberOfPointsOn_117(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LimitToMaxNumberOfPointsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_LimitToMaxNumberOfPointsOff_118(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->LimitToMaxNumberOfPointsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetLimitToMaxNumberOfPoints_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLimitToMaxNumberOfPoints(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPTSReader_GetLimitToMaxNumberOfPoints_120(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLimitToMaxNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetMaxNumberOfPoints_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxNumberOfPoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPTSReader_GetMaxNumberOfPointsMinValue_122(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNumberOfPointsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPTSReader_GetMaxNumberOfPointsMaxValue_123(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNumberOfPointsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPTSReader_GetMaxNumberOfPoints_124(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_CreateCellsOn_125(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateCellsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_CreateCellsOff_126(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateCellsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetCreateCells_127(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCreateCells(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPTSReader_GetCreateCells_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCreateCells();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_IncludeColorAndLuminanceOn_129(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeColorAndLuminanceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_IncludeColorAndLuminanceOff_130(JNIEnv* env, jobject obj)
{

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeColorAndLuminanceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPTSReader_SetIncludeColorAndLuminance_131(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIncludeColorAndLuminance(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPTSReader_GetIncludeColorAndLuminance_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPTSReader* op = static_cast<vtkPTSReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncludeColorAndLuminance();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPTSReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPTSReader::New());
}
