// java wrapper for vtkAssembly object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAssembly.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAssembly_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAssembly",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAssembly_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAssembly_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAssembly_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAssembly_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_AddPart_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp3D * temp0;
  temp0 = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddPart(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_RemovePart_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp3D * temp0;
  temp0 = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemovePart(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAssembly_GetParts_16(JNIEnv* env, jobject obj)
{
  vtkProp3DCollection * temp20;

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParts();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_GetActors_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_GetVolumes_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVolumes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAssembly_RenderOpaqueGeometry_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAssembly_RenderTranslucentPolygonalGeometry_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAssembly_RenderVolumetricGeometry_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderVolumetricGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAssembly_HasTranslucentPolygonalGeometry_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_ReleaseGraphicsResources_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_InitPathTraversal_114(JNIEnv* env, jobject obj)
{

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitPathTraversal();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAssembly_GetNextPath_115(JNIEnv* env, jobject obj)
{
  vtkAssemblyPath * temp20;

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextPath();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAssembly_GetNumberOfPaths_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPaths();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_GetBounds_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAssembly_GetBounds_118(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAssembly_GetMTime_119(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_ShallowCopy_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAssembly_BuildPaths_121(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkAssemblyPaths * temp0;
  vtkAssemblyPath * temp1;
  temp0 = static_cast<vtkAssemblyPaths*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAssemblyPath*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAssembly* op = static_cast<vtkAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildPaths(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAssembly_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAssembly::New());
}
