// java wrapper for vtkImageProperty object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageProperty.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageProperty_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageProperty",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageProperty_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageProperty_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageProperty * temp0;
  temp0 = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetColorWindow_15(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorWindow(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetColorWindow_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorWindow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetColorLevel_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorLevel(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetColorLevel_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetLookupTable_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageProperty_GetLookupTable_110(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetUseLookupTableScalarRange_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseLookupTableScalarRange(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_GetUseLookupTableScalarRange_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseLookupTableScalarRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_UseLookupTableScalarRangeOn_113(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLookupTableScalarRangeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_UseLookupTableScalarRangeOff_114(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLookupTableScalarRangeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetOpacity_115(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetOpacityMinValue_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetOpacityMaxValue_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetOpacity_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetAmbient_119(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbient(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetAmbientMinValue_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbientMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetAmbientMaxValue_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbientMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetAmbient_122(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbient();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetDiffuse_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuse(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetDiffuseMinValue_124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuseMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetDiffuseMaxValue_125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuseMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageProperty_GetDiffuse_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuse();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetInterpolationType_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_GetInterpolationTypeMinValue_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_GetInterpolationTypeMaxValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_GetInterpolationType_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetInterpolationTypeToNearest_131(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationTypeToNearest();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetInterpolationTypeToLinear_132(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationTypeToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetInterpolationTypeToCubic_133(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationTypeToCubic();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageProperty_GetInterpolationTypeAsString_134(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetLayerNumber_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayerNumber(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_GetLayerNumber_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayerNumber();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetCheckerboard_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCheckerboard(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_CheckerboardOn_138(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->CheckerboardOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_CheckerboardOff_139(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->CheckerboardOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_GetCheckerboard_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCheckerboard();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetCheckerboardSpacing_141(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCheckerboardSpacing(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetCheckerboardSpacing_142(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCheckerboardSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageProperty_GetCheckerboardSpacing_143(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCheckerboardSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetCheckerboardOffset_144(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCheckerboardOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetCheckerboardOffset_145(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCheckerboardOffset(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageProperty_GetCheckerboardOffset_146(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCheckerboardOffset();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetBacking_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBacking(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_BackingOn_148(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_BackingOff_149(JNIEnv* env, jobject obj)
{

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackingOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageProperty_GetBacking_150(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBacking();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetBackingColor_151(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackingColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageProperty_SetBackingColor_152(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackingColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageProperty_GetBackingColor_153(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackingColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageProperty_GetMTime_154(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImageProperty* op = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageProperty_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageProperty::New());
}
