// java wrapper for vtkLODProp3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLODProp3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLODProp3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLODProp3D",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODProp3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODProp3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLODProp3D_GetBounds_14(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_GetBounds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_16(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3,jdouble id4)
{
  vtkMapper * temp0;
  vtkProperty * temp1;
  vtkProperty * temp2;
  vtkTexture * temp3;
  double   temp4;
  int   temp20;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = id4;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_17(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jdouble id3)
{
  vtkMapper * temp0;
  vtkProperty * temp1;
  vtkTexture * temp2;
  double   temp3;
  int   temp20;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_18(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jdouble id3)
{
  vtkMapper * temp0;
  vtkProperty * temp1;
  vtkProperty * temp2;
  double   temp3;
  int   temp20;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_19(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2)
{
  vtkMapper * temp0;
  vtkProperty * temp1;
  double   temp2;
  int   temp20;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_110(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2)
{
  vtkMapper * temp0;
  vtkTexture * temp1;
  double   temp2;
  int   temp20;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_111(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkMapper * temp0;
  double   temp1;
  int   temp20;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_112(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2)
{
  vtkAbstractVolumeMapper * temp0;
  vtkVolumeProperty * temp1;
  double   temp2;
  int   temp20;
  temp0 = static_cast<vtkAbstractVolumeMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_113(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkAbstractVolumeMapper * temp0;
  double   temp1;
  int   temp20;
  temp0 = static_cast<vtkAbstractVolumeMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_114(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2)
{
  vtkImageMapper3D * temp0;
  vtkImageProperty * temp1;
  double   temp2;
  int   temp20;
  temp0 = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_AddLOD_115(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkImageMapper3D * temp0;
  double   temp1;
  int   temp20;
  temp0 = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddLOD(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetNumberOfLODs_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLODs();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetCurrentIndex_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentIndex();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_RemoveLOD_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveLOD(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODProperty_119(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODProperty(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODProperty_120(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkVolumeProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODProperty(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODProperty_121(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkImageProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkImageProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODProperty(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODMapper_122(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkMapper * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODMapper(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODMapper_123(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAbstractVolumeMapper * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAbstractVolumeMapper*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODMapper(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODMapper_124(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkImageMapper3D * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODMapper(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODProp3D_GetLODMapper_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAbstractMapper3D * temp20;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLODMapper(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODBackfaceProperty_126(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODBackfaceProperty(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODTexture_127(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkTexture * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODTexture(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_EnableLOD_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableLOD(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_DisableLOD_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableLOD(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_IsLODEnabled_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsLODEnabled(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetLODLevel_131(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLODLevel(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLODProp3D_GetLODLevel_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLODLevel(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLODProp3D_GetLODIndexLevel_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLODIndexLevel(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLODProp3D_GetLODEstimatedRenderTime_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLODEstimatedRenderTime(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLODProp3D_GetLODIndexEstimatedRenderTime_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLODIndexEstimatedRenderTime(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetAutomaticLODSelection_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutomaticLODSelection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetAutomaticLODSelectionMinValue_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticLODSelectionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetAutomaticLODSelectionMaxValue_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticLODSelectionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetAutomaticLODSelection_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticLODSelection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_AutomaticLODSelectionOn_140(JNIEnv* env, jobject obj)
{

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticLODSelectionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_AutomaticLODSelectionOff_141(JNIEnv* env, jobject obj)
{

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticLODSelectionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetSelectedLODID_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectedLODID(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetSelectedLODID_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedLODID();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetLastRenderedLODID_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRenderedLODID();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetPickLODID_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickLODID();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_GetActors_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_GetVolumes_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVolumes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetSelectedPickLODID_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectedPickLODID(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetSelectedPickLODID_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedPickLODID();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetAutomaticPickLODSelection_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutomaticPickLODSelection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetAutomaticPickLODSelectionMinValue_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticPickLODSelectionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetAutomaticPickLODSelectionMaxValue_152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticPickLODSelectionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_GetAutomaticPickLODSelection_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticPickLODSelection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_AutomaticPickLODSelectionOn_154(JNIEnv* env, jobject obj)
{

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticPickLODSelectionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_AutomaticPickLODSelectionOff_155(JNIEnv* env, jobject obj)
{

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticPickLODSelectionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_ShallowCopy_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_RenderOpaqueGeometry_157(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_RenderTranslucentPolygonalGeometry_158(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_RenderVolumetricGeometry_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderVolumetricGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODProp3D_HasTranslucentPolygonalGeometry_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_ReleaseGraphicsResources_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_SetAllocatedRenderTime_162(JNIEnv* env, jobject obj,jdouble id0,jobject id1)
{
  double   temp0;
  vtkViewport * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllocatedRenderTime(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_RestoreEstimatedRenderTime_163(JNIEnv* env, jobject obj)
{

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestoreEstimatedRenderTime();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODProp3D_AddEstimatedRenderTime_164(JNIEnv* env, jobject obj,jdouble id0,jobject id1)
{
  double   temp0;
  vtkViewport * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODProp3D* op = static_cast<vtkLODProp3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddEstimatedRenderTime(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLODProp3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLODProp3D::New());
}
