// java wrapper for vtkTextureObject object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTextureObject.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTextureObject_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTextureObject",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextureObject_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextureObject_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetContext_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContext(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextureObject_GetContext_15(JNIEnv* env, jobject obj)
{
  vtkOpenGLRenderWindow * temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContext();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetWidth_16(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWidth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetHeight_17(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeight();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetDepth_18(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetSamples_19(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSamples();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetComponents_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponents();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetTuples_111(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTuples();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetNumberOfDimensions_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDimensions();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetSamples_113(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSamples(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetTarget_114(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTarget();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetHandle_115(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandle();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetTextureUnit_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureUnit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_Bind_117(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Bind();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_Activate_118(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Activate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_Deactivate_119(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Deactivate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_ReleaseGraphicsResources_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_IsBound_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsBound();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SendParameters_122(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SendParameters();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetAutoParameters_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoParameters(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetAutoParameters_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoParameters();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_AutoParametersOn_125(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoParametersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_AutoParametersOff_126(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoParametersOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_CreateTextureBuffer_127(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jobject id3)
{
   unsigned int   temp0;
  int   temp1;
  int   temp2;
  vtkOpenGLBufferObject * temp3;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, id3));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateTextureBuffer(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_EmulateTextureBufferWith2DTextures_128(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jobject id3)
{
   unsigned int   temp0;
  int   temp1;
  int   temp2;
  vtkOpenGLBufferObject * temp3;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, id3));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EmulateTextureBufferWith2DTextures(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Create1D_129(JNIEnv* env, jobject obj,jint id0,jobject id1,jboolean id2)
{
  int   temp0;
  vtkPixelBufferObject * temp1;
  bool   temp2;
  bool   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkPixelBufferObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = (id2 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Create1D(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Create2D_130(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jobject id3,jboolean id4)
{
   unsigned int   temp0;
   unsigned int   temp1;
  int   temp2;
  vtkPixelBufferObject * temp3;
  bool   temp4;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkPixelBufferObject*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = (id4 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Create2D(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Create3D_131(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jboolean id5)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
  int   temp3;
  vtkPixelBufferObject * temp4;
  bool   temp5;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkPixelBufferObject*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = (id5 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Create3D(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_AllocateProxyTexture3D_132(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
  int   temp3;
  int   temp4;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateProxyTexture3D(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextureObject_Download_133(JNIEnv* env, jobject obj)
{
  vtkPixelBufferObject * temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Download();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextureObject_Download_134(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
   unsigned int   temp1;
  vtkPixelBufferObject * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Download(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_CreateDepth_135(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jobject id3)
{
   unsigned int   temp0;
   unsigned int   temp1;
  int   temp2;
  vtkPixelBufferObject * temp3;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkPixelBufferObject*>(vtkJavaGetPointerFromObject(env, id3));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateDepth(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_AllocateDepth_136(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
   unsigned int   temp0;
   unsigned int   temp1;
  int   temp2;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateDepth(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_AllocateDepthStencil_137(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
   unsigned int   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateDepthStencil(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Allocate1D_138(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
   unsigned int   temp0;
  int   temp1;
  int   temp2;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate1D(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Allocate2D_139(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4)
{
   unsigned int   temp0;
   unsigned int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate2D(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Allocate3D_140(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
  int   temp3;
  int   temp4;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate3D(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Create2D_141(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jboolean id4)
{
   unsigned int   temp0;
   unsigned int   temp1;
  int   temp2;
  int   temp3;
  bool   temp4;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = (id4 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Create2D(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_Create3D_142(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jboolean id5)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
  int   temp3;
  int   temp4;
  bool   temp5;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = (id5 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Create3D(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetVTKDataType_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKDataType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetDataType_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetDataType_145(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetDefaultDataType_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultDataType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetInternalFormat_147(JNIEnv* env, jobject obj,jint id0,jint id1,jboolean id2)
{
  int   temp0;
  int   temp1;
  bool   temp2;
   unsigned int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalFormat(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetInternalFormat_148(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInternalFormat(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetDefaultInternalFormat_149(JNIEnv* env, jobject obj,jint id0,jint id1,jboolean id2)
{
  int   temp0;
  int   temp1;
  bool   temp2;
   unsigned int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultInternalFormat(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetFormat_150(JNIEnv* env, jobject obj,jint id0,jint id1,jboolean id2)
{
  int   temp0;
  int   temp1;
  bool   temp2;
   unsigned int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFormat(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetFormat_151(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFormat(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetDefaultFormat_152(JNIEnv* env, jobject obj,jint id0,jint id1,jboolean id2)
{
  int   temp0;
  int   temp1;
  bool   temp2;
   unsigned int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultFormat(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_ResetFormatAndType_153(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetFormatAndType();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMinificationFilterMode_154(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinificationFilterMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMagnificationFilterMode_155(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMagnificationFilterMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetWrapSMode_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapSMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetWrapTMode_157(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapTMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetWrapRMode_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapRMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetRequireDepthBufferFloat_159(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequireDepthBufferFloat(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetRequireDepthBufferFloat_160(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequireDepthBufferFloat();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetSupportsDepthBufferFloat_161(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSupportsDepthBufferFloat();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetRequireTextureFloat_162(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequireTextureFloat(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetRequireTextureFloat_163(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequireTextureFloat();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetSupportsTextureFloat_164(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSupportsTextureFloat();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetRequireTextureInteger_165(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequireTextureInteger(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetRequireTextureInteger_166(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequireTextureInteger();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetSupportsTextureInteger_167(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSupportsTextureInteger();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetWrapS_168(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapS();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetWrapS_169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWrapS(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetWrapT_170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapT();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetWrapT_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWrapT(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetWrapR_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapR();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetWrapR_173(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWrapR(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMinificationFilter_174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinificationFilter();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetMinificationFilter_175(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinificationFilter(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMagnificationFilter_176(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMagnificationFilter();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetMagnificationFilter_177(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMagnificationFilter(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetLinearMagnification_178(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLinearMagnification(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetLinearMagnification_179(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinearMagnification();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetBorderColor_180(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetBorderColor_181(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderColor(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkTextureObject_GetBorderColor_182(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderColor();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetMinLOD_183(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinLOD(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkTextureObject_GetMinLOD_184(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinLOD();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetMaxLOD_185(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxLOD(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkTextureObject_GetMaxLOD_186(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxLOD();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetBaseLevel_187(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBaseLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetBaseLevel_188(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetMaxLevel_189(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMaxLevel_190(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxLevel();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetDepthTextureCompare_191(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepthTextureCompare();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetDepthTextureCompare_192(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDepthTextureCompare(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetDepthTextureCompareFunction_193(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepthTextureCompareFunction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetDepthTextureCompareFunction_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDepthTextureCompareFunction(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetGenerateMipmap_195(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateMipmap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetGenerateMipmap_196(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateMipmap(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetMaximumAnisotropicFiltering_197(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumAnisotropicFiltering(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkTextureObject_GetMaximumAnisotropicFiltering_198(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumAnisotropicFiltering();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMaximumTextureSize_199(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  int   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumTextureSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMaximumTextureSize3D_1100(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  int   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumTextureSize3D(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextureObject_GetMaximumTextureSize3D_1101(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumTextureSize3D();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_IsSupported_1102(JNIEnv* env, jobject obj,jobject id0,jboolean id1,jboolean id2,jboolean id3)
{
  vtkOpenGLRenderWindow * temp0;
  bool   temp1;
  bool   temp2;
  bool   temp3;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;
  temp2 = (id2 != 0) ? true : false;
  temp3 = (id3 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_IsSupported_1103(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_CopyToFrameBuffer_1104(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkShaderProgram * temp0;
  vtkOpenGLVertexArrayObject * temp1;
  temp0 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyToFrameBuffer(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_CopyToFrameBuffer_1105(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5,jint id6,jint id7,jint id8,jint id9,jobject id10,jobject id11)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp8;
  int   temp9;
  vtkShaderProgram * temp10;
  vtkOpenGLVertexArrayObject * temp11;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;
  temp9 = id9;
  temp10 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id10));
  temp11 = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, id11));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyToFrameBuffer(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10,temp11);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_CopyToFrameBuffer_1106(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5,jint id6,jint id7,jobject id8,jobject id9)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  vtkShaderProgram * temp8;
  vtkOpenGLVertexArrayObject * temp9;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, id9));

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyToFrameBuffer(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_CopyFromFrameBuffer_1107(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyFromFrameBuffer(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_Resize_1108(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
   unsigned int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Resize(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextureObject_GetUseSRGBColorSpace_1109(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseSRGBColorSpace();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_SetUseSRGBColorSpace_1110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseSRGBColorSpace(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_UseSRGBColorSpaceOn_1111(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSRGBColorSpaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_UseSRGBColorSpaceOff_1112(JNIEnv* env, jobject obj)
{

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSRGBColorSpaceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextureObject_AssignToExistingTexture_1113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
   unsigned int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTextureObject* op = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AssignToExistingTexture(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTextureObject_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTextureObject::New());
}
