// java wrapper for vtkUnstructuredGridPreIntegration object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUnstructuredGridPreIntegration.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkUnstructuredGridVolumeRayIntegrator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUnstructuredGridPreIntegration_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUnstructuredGridPreIntegration",dType)) { return me; }
  if ((res= vtkUnstructuredGridVolumeRayIntegrator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_Initialize_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkVolume * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_Integrate_15(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jfloatArray id3)
{
  vtkDoubleArray * temp0;
  vtkDataArray * temp1;
  vtkDataArray * temp2;
  float temp3[4];
  temp0 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetFloatArrayRegion(id3, 0, 4, &temp3[0]);

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->Integrate(temp0,temp1,temp2,temp3);
  env->SetFloatArrayRegion(id3, 0, 4, &temp3[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetIntegrator_16(JNIEnv* env, jobject obj)
{
  vtkUnstructuredGridVolumeRayIntegrator * temp20;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_SetIntegrator_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkUnstructuredGridVolumeRayIntegrator * temp0;
  temp0 = static_cast<vtkUnstructuredGridVolumeRayIntegrator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrator(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_SetIntegrationTableScalarResolution_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationTableScalarResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetIntegrationTableScalarResolution_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationTableScalarResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_SetIntegrationTableLengthResolution_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationTableLengthResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetIntegrationTableLengthResolution_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationTableLengthResolution();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetIntegrationTableScalarShift_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationTableScalarShift(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetIntegrationTableScalarScale_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationTableScalarScale(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetIntegrationTableLengthScale_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationTableLengthScale();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_GetIncrementalPreIntegration_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncrementalPreIntegration();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_SetIncrementalPreIntegration_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIncrementalPreIntegration(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_IncrementalPreIntegrationOn_117(JNIEnv* env, jobject obj)
{

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncrementalPreIntegrationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_IncrementalPreIntegrationOff_118(JNIEnv* env, jobject obj)
{

  vtkUnstructuredGridPreIntegration* op = static_cast<vtkUnstructuredGridPreIntegration*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncrementalPreIntegrationOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUnstructuredGridPreIntegration_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUnstructuredGridPreIntegration::New());
}
