/* imap-client-connection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-client-connection.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2018-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_CLIENT_CONNECTION_0_PROPERTY,
	GEARY_IMAP_CLIENT_CONNECTION_IDLE_WHEN_QUIET_PROPERTY,
	GEARY_IMAP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY,
	GEARY_IMAP_CLIENT_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* geary_imap_client_connection_properties[GEARY_IMAP_CLIENT_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapClientConnectionConnectAsyncData GearyImapClientConnectionConnectAsyncData;
typedef struct _GearyImapClientConnectionDisconnectAsyncData GearyImapClientConnectionDisconnectAsyncData;
typedef struct _GearyImapClientConnectionStarttlsAsyncData GearyImapClientConnectionStarttlsAsyncData;
typedef struct _GearyImapClientConnectionOpenChannelsAsyncData GearyImapClientConnectionOpenChannelsAsyncData;
typedef struct _GearyImapClientConnectionCloseChannelsAsyncData GearyImapClientConnectionCloseChannelsAsyncData;
typedef struct _GearyImapClientConnectionSendLoopData GearyImapClientConnectionSendLoopData;
typedef struct _GearyImapClientConnectionFlushCommandData GearyImapClientConnectionFlushCommandData;
enum  {
	GEARY_IMAP_CLIENT_CONNECTION_SENT_COMMAND_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_STATUS_RESPONSE_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_SERVER_DATA_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_CONTINUATION_RESPONSE_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_BYTES_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_BAD_RESPONSE_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_SEND_FAILURE_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_RECEIVE_FAILURE_SIGNAL,
	GEARY_IMAP_CLIENT_CONNECTION_NUM_SIGNALS
};
static guint geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_NUM_SIGNALS] = {0};

struct _GearyImapClientConnectionPrivate {
	gboolean _idle_when_quiet;
	GearyLoggingSource* _logging_parent;
	GearyEndpoint* endpoint;
	gint cx_id;
	GearyImapQuirks* quirks;
	GIOStream* cx;
	GearyImapDeserializer* deserializer;
	GearyImapSerializer* serializer;
	gint tag_counter;
	gchar tag_prefix;
	gint64 last_seen;
	gsize bytes_accumulator;
	GearyNonblockingQueue* pending_queue;
	GeeQueue* sent_queue;
	GearyImapCommand* current_command;
	guint command_timeout;
	GearyTimeoutManager* idle_timer;
	GCancellable* open_cancellable;
};

struct _GearyImapClientConnectionConnectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientConnection* self;
	GCancellable* cancellable;
	GIOStream* _tmp0_;
	GError* _tmp1_;
	GSocketConnection* _tmp2_;
	GearyEndpoint* _tmp3_;
	GSocketConnection* _tmp4_;
	GSocketConnection* _tmp5_;
	GearyNonblockingQueue* _tmp6_;
	GeeQueue* _tmp7_;
	GError* err;
	GIOStream* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	gboolean _tmp11_;
	GearyTimeoutManager* _tmp12_;
	GError* _inner_error0_;
};

struct _GearyImapClientConnectionDisconnectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientConnection* self;
	GCancellable* cancellable;
	GIOStream* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	GIOStream* old_cx;
	GIOStream* _tmp2_;
	GIOStream* _tmp3_;
	GeeIterator* _pending_it;
	GearyNonblockingQueue* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GearyImapCommand* pending;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	GearyImapCommand* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GearyImapCommand* _tmp15_;
	GearyNonblockingQueue* _tmp16_;
	GIOStream* _tmp17_;
	GTlsConnection* tls_cx;
	GIOStream* _tmp18_;
	GTlsConnection* _tmp19_;
	gboolean _tmp20_;
	GTlsConnection* _tmp21_;
	GTlsConnection* _tmp22_;
	GIOStream* _tmp23_;
	GIOStream* _tmp24_;
	GIOStream* _tmp25_;
	GTlsConnection* _tmp26_;
	GIOStream* _tmp27_;
	GIOStream* _tmp28_;
	GIOStream* _tmp29_;
	GError* _inner_error0_;
};

struct _GearyImapClientConnectionStarttlsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientConnection* self;
	GCancellable* cancellable;
	GIOStream* _tmp0_;
	GError* _tmp1_;
	GIOStream* _tmp2_;
	GError* _tmp3_;
	GTlsClientConnection* _tmp4_;
	GearyEndpoint* _tmp5_;
	GIOStream* _tmp6_;
	GTlsClientConnection* _tmp7_;
	GTlsClientConnection* _tmp8_;
	GError* _inner_error0_;
};

struct _GearyImapClientConnectionOpenChannelsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientConnection* self;
	GCancellable* _tmp0_;
	gchar* id;
	gchar* _tmp1_;
	GBufferedOutputStream* serializer_buffer;
	GIOStream* _tmp2_;
	GOutputStream* _tmp3_;
	GOutputStream* _tmp4_;
	GBufferedOutputStream* _tmp5_;
	GearyImapSerializer* _tmp6_;
	GIOStream* _tmp7_;
	GInputStream* _tmp8_;
	GInputStream* _tmp9_;
	GearyImapQuirks* _tmp10_;
	GearyImapDeserializer* _tmp11_;
	GearyImapDeserializer* _tmp12_;
	GearyImapDeserializer* _tmp13_;
	GearyImapDeserializer* _tmp14_;
	GearyImapDeserializer* _tmp15_;
	GearyImapDeserializer* _tmp16_;
	GearyImapDeserializer* _tmp17_;
	GearyImapDeserializer* _tmp18_;
	GError* _inner_error0_;
};

struct _GearyImapClientConnectionCloseChannelsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientConnection* self;
	GCancellable* cancellable;
	GCancellable* _tmp0_;
	GeeIterator* _sent_it;
	GeeQueue* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GearyImapCommand* sent;
	GeeIterator* _tmp4_;
	gpointer _tmp5_;
	GearyImapCommand* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GearyImapCommand* _tmp9_;
	GeeQueue* _tmp10_;
	GearyImapSerializer* _tmp11_;
	GearyImapSerializer* _tmp12_;
	GearyImapDeserializer* deserializer;
	GearyImapDeserializer* _tmp13_;
	GearyImapDeserializer* _tmp14_;
	GearyImapDeserializer* _tmp15_;
	GearyImapDeserializer* _tmp16_;
	guint _tmp17_;
	GearyImapDeserializer* _tmp18_;
	guint _tmp19_;
	GearyImapDeserializer* _tmp20_;
	guint _tmp21_;
	GearyImapDeserializer* _tmp22_;
	guint _tmp23_;
	GearyImapDeserializer* _tmp24_;
	guint _tmp25_;
	GearyImapDeserializer* _tmp26_;
	GError* _inner_error0_;
};

struct _GearyImapClientConnectionSendLoopData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientConnection* self;
	GCancellable* _tmp0_;
	GCancellable* cancellable;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GearyImapCommand* pending;
	GearyNonblockingQueue* _tmp3_;
	GCancellable* _tmp4_;
	gpointer _tmp5_;
	gboolean _tmp6_;
	GearyImapCommand* _tmp7_;
	GearyNonblockingQueue* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GearyImapCommand* _tmp11_;
	GCancellable* _tmp12_;
	GearyNonblockingQueue* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GearyImapSerializer* _tmp16_;
	GCancellable* _tmp17_;
	GError* err;
	GError* _tmp18_;
	GError* _tmp19_;
	GError* _inner_error0_;
};

struct _GearyImapClientConnectionFlushCommandData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientConnection* self;
	GearyImapCommand* command;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* ser_error;
	GearyImapTag* _tmp9_;
	GearyImapTag* _tmp10_;
	GearyImapCommand* _tmp11_;
	GeeQueue* _tmp12_;
	GearyImapSerializer* _tmp13_;
	GearyImapSerializer* _tmp14_;
	GError* err;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GeeQueue* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	GError* _inner_error0_;
};

static gint GearyImapClientConnection_private_offset;
static gpointer geary_imap_client_connection_parent_class = NULL;
static gint geary_imap_client_connection_next_cx_id;
static gint geary_imap_client_connection_next_cx_id = 0;
static GearyLoggingSourceIface * geary_imap_client_connection_geary_logging_source_parent_iface = NULL;

static void geary_imap_client_connection_set_idle_when_quiet (GearyImapClientConnection* self,
                                                       gboolean value);
static void geary_imap_client_connection_real_sent_command (GearyImapClientConnection* self,
                                                     GearyImapCommand* cmd);
static void geary_imap_client_connection_real_received_status_response (GearyImapClientConnection* self,
                                                                 GearyImapStatusResponse* status_response);
static void geary_imap_client_connection_real_received_server_data (GearyImapClientConnection* self,
                                                             GearyImapServerData* server_data);
static void geary_imap_client_connection_real_received_continuation_response (GearyImapClientConnection* self,
                                                                       GearyImapContinuationResponse* continuation_response);
static void g_cclosure_user_marshal_VOID__OBJECT_BOXED (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static void geary_imap_client_connection_on_idle_timeout (GearyImapClientConnection* self);
static void _geary_imap_client_connection_on_idle_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                       gpointer self);
static GTcpConnection* geary_imap_client_connection_getTcpConnection (GearyImapClientConnection* self);
static inline void geary_imap_client_connection_cancel_idle (GearyImapClientConnection* self);
static void geary_imap_client_connection_connect_async_data_free (gpointer _data);
static gboolean geary_imap_client_connection_connect_async_co (GearyImapClientConnectionConnectAsyncData* _data_);
static void geary_imap_client_connection_connect_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void geary_imap_client_connection_open_channels_async (GearyImapClientConnection* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void geary_imap_client_connection_open_channels_finish (GearyImapClientConnection* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void geary_imap_client_connection_disconnect_async_data_free (gpointer _data);
static gboolean geary_imap_client_connection_disconnect_async_co (GearyImapClientConnectionDisconnectAsyncData* _data_);
VALA_EXTERN gchar* geary_imap_command_to_brief_string (GearyImapCommand* self);
VALA_EXTERN void geary_imap_command_disconnected (GearyImapCommand* self,
                                      const gchar* reason);
static void geary_imap_client_connection_close_channels_async (GearyImapClientConnection* self,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void geary_imap_client_connection_close_channels_finish (GearyImapClientConnection* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void geary_imap_client_connection_disconnect_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void geary_imap_client_connection_starttls_async_data_free (gpointer _data);
static gboolean geary_imap_client_connection_starttls_async_co (GearyImapClientConnectionStarttlsAsyncData* _data_);
static void geary_imap_client_connection_starttls_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void geary_imap_client_connection_check_connection (GearyImapClientConnection* self,
                                                    GError** error);
VALA_EXTERN void geary_imap_command_cancelled_before_send (GearyImapCommand* self);
static GearyLoggingState* geary_imap_client_connection_real_to_logging_state (GearyLoggingSource* base);
VALA_EXTERN GearyImapCommand* geary_imap_client_connection_get_sent_command (GearyImapClientConnection* self,
                                                                 GearyImapTag* tag);
VALA_EXTERN void geary_imap_client_connection_set_logging_parent (GearyImapClientConnection* self,
                                                      GearyLoggingSource* parent);
static void geary_imap_client_connection_open_channels_async_data_free (gpointer _data);
static gboolean geary_imap_client_connection_open_channels_async_co (GearyImapClientConnectionOpenChannelsAsyncData* _data_);
static void geary_imap_client_connection_on_bytes_received (GearyImapClientConnection* self,
                                                     gsize bytes);
static void _geary_imap_client_connection_on_bytes_received_geary_imap_deserializer_bytes_received (GearyImapDeserializer* _sender,
                                                                                             gsize bytes,
                                                                                             gpointer self);
static void geary_imap_client_connection_on_deserialize_failure (GearyImapClientConnection* self);
static void _geary_imap_client_connection_on_deserialize_failure_geary_imap_deserializer_deserialize_failure (GearyImapDeserializer* _sender,
                                                                                                       gpointer self);
static void geary_imap_client_connection_on_eos (GearyImapClientConnection* self);
static void _geary_imap_client_connection_on_eos_geary_imap_deserializer_end_of_stream (GearyImapDeserializer* _sender,
                                                                                 gpointer self);
static void geary_imap_client_connection_on_parameters_ready (GearyImapClientConnection* self,
                                                       GearyImapRootParameters* root);
static void _geary_imap_client_connection_on_parameters_ready_geary_imap_deserializer_parameters_ready (GearyImapDeserializer* _sender,
                                                                                                 GearyImapRootParameters* root,
                                                                                                 gpointer self);
static void geary_imap_client_connection_on_receive_failure (GearyImapClientConnection* self,
                                                      GError* err);
static void _geary_imap_client_connection_on_receive_failure_geary_imap_deserializer_receive_failure (GearyImapDeserializer* _sender,
                                                                                               GError* err,
                                                                                               gpointer self);
VALA_EXTERN void geary_imap_deserializer_set_logging_parent (GearyImapDeserializer* self,
                                                 GearyLoggingSource* parent);
static void geary_imap_client_connection_open_channels_async_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void geary_imap_client_connection_send_loop (GearyImapClientConnection* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void geary_imap_client_connection_send_loop_finish (GearyImapClientConnection* self,
                                                    GAsyncResult* _res_);
static void geary_imap_client_connection_close_channels_async_data_free (gpointer _data);
static gboolean geary_imap_client_connection_close_channels_async_co (GearyImapClientConnectionCloseChannelsAsyncData* _data_);
static void geary_imap_client_connection_close_channels_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static GearyImapTag* geary_imap_client_connection_generate_tag (GearyImapClientConnection* self);
static void geary_imap_client_connection_send_loop_data_free (gpointer _data);
static gboolean geary_imap_client_connection_send_loop_co (GearyImapClientConnectionSendLoopData* _data_);
static void geary_imap_client_connection_send_loop_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void geary_imap_client_connection_flush_command (GearyImapClientConnection* self,
                                                 GearyImapCommand* command,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void geary_imap_client_connection_flush_command_finish (GearyImapClientConnection* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void geary_imap_client_connection_flush_command_data_free (gpointer _data);
static gboolean geary_imap_client_connection_flush_command_co (GearyImapClientConnectionFlushCommandData* _data_);
VALA_EXTERN void geary_imap_command_assign_tag (GearyImapCommand* self,
                                    GearyImapTag* new_tag,
                                    GError** error);
static void geary_imap_client_connection_on_command_timeout (GearyImapClientConnection* self,
                                                      GearyImapCommand* command);
static void _geary_imap_client_connection_on_command_timeout_geary_imap_command_response_timed_out (GearyImapCommand* _sender,
                                                                                             gpointer self);
VALA_EXTERN void geary_imap_command_send (GearyImapCommand* self,
                              GearyImapSerializer* ser,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_finish (GearyImapCommand* self,
                                     GAsyncResult* _res_,
                                     GError** error);
static void geary_imap_client_connection_flush_command_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_wait (GearyImapCommand* self,
                                   GearyImapSerializer* ser,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_wait_finish (GearyImapCommand* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void geary_imap_client_connection_on_continuation_response (GearyImapClientConnection* self,
                                                            GearyImapContinuationResponse* continuation,
                                                            GError** error);
static void geary_imap_client_connection_on_status_response (GearyImapClientConnection* self,
                                                      GearyImapStatusResponse* status,
                                                      GError** error);
static void geary_imap_client_connection_on_server_data (GearyImapClientConnection* self,
                                                  GearyImapServerData* data,
                                                  GError** error);
VALA_EXTERN void geary_imap_command_completed (GearyImapCommand* self,
                                   GearyImapStatusResponse* new_status,
                                   GError** error);
VALA_EXTERN void geary_imap_command_data_received (GearyImapCommand* self,
                                       GearyImapServerData* data,
                                       GError** error);
VALA_EXTERN void geary_imap_command_continuation_requested (GearyImapCommand* self,
                                                GearyImapContinuationResponse* continuation,
                                                GError** error);
VALA_EXTERN void geary_imap_command_update_response_timer (GearyImapCommand* self);
static void geary_imap_client_connection_finalize (GObject * obj);
static GType geary_imap_client_connection_get_type_once (void);
static void _vala_geary_imap_client_connection_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_geary_imap_client_connection_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
geary_imap_client_connection_get_instance_private (GearyImapClientConnection* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapClientConnection_private_offset);
}

gboolean
geary_imap_client_connection_get_idle_when_quiet (GearyImapClientConnection* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self), FALSE);
	result = self->priv->_idle_when_quiet;
	return result;
}

static void
geary_imap_client_connection_set_idle_when_quiet (GearyImapClientConnection* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	old_value = geary_imap_client_connection_get_idle_when_quiet (self);
	if (old_value != value) {
		self->priv->_idle_when_quiet = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_client_connection_properties[GEARY_IMAP_CLIENT_CONNECTION_IDLE_WHEN_QUIET_PROPERTY]);
	}
}

static const gchar*
geary_imap_client_connection_real_get_logging_domain (GearyLoggingSource* base)
{
	const gchar* result;
	GearyImapClientConnection* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_CONNECTION, GearyImapClientConnection);
	result = GEARY_IMAP_CLIENT_SERVICE_PROTOCOL_LOGGING_DOMAIN;
	return result;
}

static GearyLoggingSource*
geary_imap_client_connection_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyImapClientConnection* self;
	GearyLoggingSource* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_CONNECTION, GearyImapClientConnection);
	_tmp0_ = self->priv->_logging_parent;
	result = _tmp0_;
	return result;
}

static void
geary_imap_client_connection_real_sent_command (GearyImapClientConnection* self,
                                                GearyImapCommand* cmd)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (cmd));
	_tmp0_ = geary_imap_command_to_string (cmd);
	_tmp1_ = _tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SEND: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
geary_imap_client_connection_real_received_status_response (GearyImapClientConnection* self,
                                                            GearyImapStatusResponse* status_response)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (status_response));
	_tmp0_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (status_response, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp1_ = _tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "RECV: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
geary_imap_client_connection_real_received_server_data (GearyImapClientConnection* self,
                                                        GearyImapServerData* server_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_SERVER_DATA (server_data));
	_tmp0_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp1_ = _tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "RECV: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
geary_imap_client_connection_real_received_continuation_response (GearyImapClientConnection* self,
                                                                  GearyImapContinuationResponse* continuation_response)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CONTINUATION_RESPONSE (continuation_response));
	_tmp0_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (continuation_response, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp1_ = _tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "RECV: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOXED (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_geary_imap_client_connection_on_idle_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                  gpointer self)
{
	geary_imap_client_connection_on_idle_timeout ((GearyImapClientConnection*) self);
}

GearyImapClientConnection*
geary_imap_client_connection_construct (GType object_type,
                                        GearyEndpoint* endpoint,
                                        GearyImapQuirks* quirks,
                                        guint command_timeout,
                                        guint idle_timeout_sec)
{
	GearyImapClientConnection * self = NULL;
	GearyEndpoint* _tmp0_;
	GearyImapQuirks* _tmp1_;
	gint _tmp2_;
	GearyTimeoutManager* _tmp3_;
	g_return_val_if_fail (GEARY_IS_ENDPOINT (endpoint), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapClientConnection*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (endpoint);
	_g_object_unref0 (self->priv->endpoint);
	self->priv->endpoint = _tmp0_;
	_tmp1_ = _g_object_ref0 (quirks);
	_g_object_unref0 (self->priv->quirks);
	self->priv->quirks = _tmp1_;
	_tmp2_ = geary_imap_client_connection_next_cx_id;
	geary_imap_client_connection_next_cx_id = _tmp2_ + 1;
	self->priv->cx_id = _tmp2_;
	self->priv->command_timeout = command_timeout;
	_tmp3_ = geary_timeout_manager_new_seconds (idle_timeout_sec, _geary_imap_client_connection_on_idle_timeout_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->idle_timer);
	self->priv->idle_timer = _tmp3_;
	return self;
}

GearyImapClientConnection*
geary_imap_client_connection_new (GearyEndpoint* endpoint,
                                  GearyImapQuirks* quirks,
                                  guint command_timeout,
                                  guint idle_timeout_sec)
{
	return geary_imap_client_connection_construct (GEARY_IMAP_TYPE_CLIENT_CONNECTION, endpoint, quirks, command_timeout, idle_timeout_sec);
}

/** Returns the remote address of this connection, if any. */
GSocketAddress*
geary_imap_client_connection_get_remote_address (GearyImapClientConnection* self,
                                                 GError** error)
{
	GSocketAddress* addr = NULL;
	GTcpConnection* tcp_cx = NULL;
	GTcpConnection* _tmp0_;
	GTcpConnection* _tmp1_;
	GError* _inner_error0_ = NULL;
	GSocketAddress* result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self), NULL);
	addr = NULL;
	_tmp0_ = geary_imap_client_connection_getTcpConnection (self);
	tcp_cx = _tmp0_;
	_tmp1_ = tcp_cx;
	if (_tmp1_ != NULL) {
		GSocketAddress* _tmp2_ = NULL;
		GTcpConnection* _tmp3_;
		GSocketAddress* _tmp4_;
		GSocketAddress* _tmp5_;
		_tmp3_ = tcp_cx;
		_tmp4_ = g_socket_connection_get_remote_address (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_socket_connection_get_type (), GSocketConnection), &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (tcp_cx);
			_g_object_unref0 (addr);
			return NULL;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (addr);
		addr = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	result = addr;
	_g_object_unref0 (tcp_cx);
	return result;
}

/** Returns the local address of this connection, if any. */
GSocketAddress*
geary_imap_client_connection_get_local_address (GearyImapClientConnection* self,
                                                GError** error)
{
	GSocketAddress* addr = NULL;
	GTcpConnection* tcp_cx = NULL;
	GTcpConnection* _tmp0_;
	GTcpConnection* _tmp1_;
	GError* _inner_error0_ = NULL;
	GSocketAddress* result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self), NULL);
	addr = NULL;
	_tmp0_ = geary_imap_client_connection_getTcpConnection (self);
	tcp_cx = _tmp0_;
	_tmp1_ = tcp_cx;
	if (_tmp1_ != NULL) {
		GSocketAddress* _tmp2_ = NULL;
		GTcpConnection* _tmp3_;
		GSocketAddress* _tmp4_;
		GSocketAddress* _tmp5_;
		_tmp3_ = tcp_cx;
		_tmp4_ = g_socket_connection_get_local_address (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_socket_connection_get_type (), GSocketConnection), &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (tcp_cx);
			_g_object_unref0 (addr);
			return NULL;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (addr);
		addr = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	result = addr;
	_g_object_unref0 (tcp_cx);
	return result;
}

/**
     * Determines if the connection has an outstanding IDLE command.
     */
gboolean
geary_imap_client_connection_is_in_idle (GearyImapClientConnection* self)
{
	GearyImapCommand* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self), FALSE);
	_tmp0_ = self->priv->current_command;
	result = GEARY_IMAP_IS_IDLE_COMMAND (_tmp0_);
	return result;
}

/**
     * Sets whether this connection should automatically IDLE.
     *
     * If true, this will cause the connection to send an IDLE command
     * when no other commands have been sent after a short period of
     * time
     *
     * If false, any existing IDLE command will be cancelled, and the
     * connection will no longer be automatically sent.
     */
void
geary_imap_client_connection_enable_idle_when_quiet (GearyImapClientConnection* self,
                                                     gboolean do_idle)
{
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	geary_imap_client_connection_set_idle_when_quiet (self, do_idle);
	if (do_idle) {
		GearyTimeoutManager* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->idle_timer;
		_tmp1_ = geary_timeout_manager_get_is_running (_tmp0_);
		_tmp2_ = _tmp1_;
		if (!_tmp2_) {
			GearyTimeoutManager* _tmp3_;
			_tmp3_ = self->priv->idle_timer;
			geary_timeout_manager_start (_tmp3_);
		}
	} else {
		geary_imap_client_connection_cancel_idle (self);
	}
}

static void
geary_imap_client_connection_connect_async_data_free (gpointer _data)
{
	GearyImapClientConnectionConnectAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientConnectionConnectAsyncData, _data_);
}

void
geary_imap_client_connection_connect_async (GearyImapClientConnection* self,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyImapClientConnectionConnectAsyncData* _data_;
	GearyImapClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapClientConnectionConnectAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_connection_connect_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_connection_connect_async_co (_data_);
}

void
geary_imap_client_connection_connect_finish (GearyImapClientConnection* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearyImapClientConnectionConnectAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Establishes a connection to the connection's endpoint.
     */
static void
geary_imap_client_connection_connect_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearyImapClientConnectionConnectAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_connection_connect_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_imap_client_connection_connect_async_co (GearyImapClientConnectionConnectAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cx;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_ALREADY_CONNECTED, "Client already connected");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->endpoint;
	_data_->_state_ = 1;
	geary_endpoint_connect_async (_data_->_tmp3_, _data_->cancellable, geary_imap_client_connection_connect_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = geary_endpoint_connect_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_g_object_unref0 (_data_->self->priv->cx);
	_data_->self->priv->cx = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, g_io_stream_get_type (), GIOStream);
	_data_->_tmp6_ = _data_->self->priv->pending_queue;
	geary_nonblocking_queue_clear (_data_->_tmp6_);
	_data_->_tmp7_ = _data_->self->priv->sent_queue;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
	{
		_data_->_state_ = 2;
		geary_imap_client_connection_open_channels_async (_data_->self, geary_imap_client_connection_connect_async_ready, _data_);
		return FALSE;
		_state_2:
		geary_imap_client_connection_open_channels_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		{
			_data_->_tmp8_ = _data_->self->priv->cx;
			_data_->_state_ = 3;
			g_io_stream_close_async (_data_->_tmp8_, G_PRIORITY_DEFAULT, NULL, geary_imap_client_connection_connect_async_ready, _data_);
			return FALSE;
			_state_3:
			g_io_stream_close_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_error_free0 (_data_->err);
			_g_object_unref0 (_data_->_tmp2_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->self->priv->cx);
		_data_->self->priv->cx = NULL;
		_data_->_tmp9_ = _data_->err;
		_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
		_data_->_inner_error0_ = _data_->_tmp10_;
		_g_error_free0 (_data_->err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp2_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->self->priv->_idle_when_quiet;
	if (_data_->_tmp11_) {
		_data_->_tmp12_ = _data_->self->priv->idle_timer;
		geary_timeout_manager_start (_data_->_tmp12_);
	}
	_g_object_unref0 (_data_->_tmp2_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_connection_disconnect_async_data_free (gpointer _data)
{
	GearyImapClientConnectionDisconnectAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientConnectionDisconnectAsyncData, _data_);
}

void
geary_imap_client_connection_disconnect_async (GearyImapClientConnection* self,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GearyImapClientConnectionDisconnectAsyncData* _data_;
	GearyImapClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapClientConnectionDisconnectAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_connection_disconnect_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_connection_disconnect_async_co (_data_);
}

void
geary_imap_client_connection_disconnect_finish (GearyImapClientConnection* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GearyImapClientConnectionDisconnectAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_client_connection_disconnect_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GearyImapClientConnectionDisconnectAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_connection_disconnect_async_co (_data_);
}

static gboolean
geary_imap_client_connection_disconnect_async_co (GearyImapClientConnectionDisconnectAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cx;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->idle_timer;
	geary_timeout_manager_reset (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->cx;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->old_cx = _data_->_tmp3_;
	_g_object_unref0 (_data_->self->priv->cx);
	_data_->self->priv->cx = NULL;
	{
		_data_->_tmp4_ = _data_->self->priv->pending_queue;
		_data_->_tmp5_ = geary_nonblocking_queue_get_all (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp6_);
		_data_->_pending_it = _data_->_tmp8_;
		while (TRUE) {
			_data_->_tmp9_ = _data_->_pending_it;
			if (!gee_iterator_next (_data_->_tmp9_)) {
				break;
			}
			_data_->_tmp10_ = _data_->_pending_it;
			_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
			_data_->pending = (GearyImapCommand*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->pending;
			_data_->_tmp13_ = geary_imap_command_to_brief_string (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Cancelling pending command: %s", _data_->_tmp14_);
			_g_free0 (_data_->_tmp14_);
			_data_->_tmp15_ = _data_->pending;
			geary_imap_command_disconnected (_data_->_tmp15_, "Disconnected");
			_g_object_unref0 (_data_->pending);
		}
		_g_object_unref0 (_data_->_pending_it);
	}
	_data_->_tmp16_ = _data_->self->priv->pending_queue;
	geary_nonblocking_queue_clear (_data_->_tmp16_);
	_data_->_state_ = 1;
	geary_imap_client_connection_close_channels_async (_data_->self, _data_->cancellable, geary_imap_client_connection_disconnect_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_client_connection_close_channels_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->old_cx);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->old_cx;
	_data_->_state_ = 2;
	g_io_stream_close_async (_data_->_tmp17_, G_PRIORITY_DEFAULT, _data_->cancellable, geary_imap_client_connection_disconnect_async_ready, _data_);
	return FALSE;
	_state_2:
	g_io_stream_close_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->old_cx);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->old_cx;
	_data_->_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, g_tls_connection_get_type ()) ? ((GTlsConnection*) _data_->_tmp18_) : NULL);
	_data_->tls_cx = _data_->_tmp19_;
	_data_->_tmp21_ = _data_->tls_cx;
	if (_data_->_tmp21_ != NULL) {
		_data_->_tmp22_ = _data_->tls_cx;
		g_object_get (_data_->_tmp22_, "base-io-stream", &_data_->_tmp23_, NULL);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp20_ = !g_io_stream_is_closed (_data_->_tmp25_);
		_g_object_unref0 (_data_->_tmp25_);
	} else {
		_data_->_tmp20_ = FALSE;
	}
	if (_data_->_tmp20_) {
		_data_->_tmp26_ = _data_->tls_cx;
		g_object_get (_data_->_tmp26_, "base-io-stream", &_data_->_tmp27_, NULL);
		_data_->_tmp28_ = _data_->_tmp27_;
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_state_ = 3;
		g_io_stream_close_async (_data_->_tmp29_, G_PRIORITY_DEFAULT, _data_->cancellable, geary_imap_client_connection_disconnect_async_ready, _data_);
		return FALSE;
		_state_3:
		g_io_stream_close_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp29_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->tls_cx);
			_g_object_unref0 (_data_->old_cx);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->tls_cx);
	_g_object_unref0 (_data_->old_cx);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_connection_starttls_async_data_free (gpointer _data)
{
	GearyImapClientConnectionStarttlsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientConnectionStarttlsAsyncData, _data_);
}

void
geary_imap_client_connection_starttls_async (GearyImapClientConnection* self,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GearyImapClientConnectionStarttlsAsyncData* _data_;
	GearyImapClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapClientConnectionStarttlsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_connection_starttls_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_connection_starttls_async_co (_data_);
}

void
geary_imap_client_connection_starttls_finish (GearyImapClientConnection* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GearyImapClientConnectionStarttlsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_client_connection_starttls_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	GearyImapClientConnectionStarttlsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_connection_starttls_async_co (_data_);
}

static gboolean
geary_imap_client_connection_starttls_async_co (GearyImapClientConnectionStarttlsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cx;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_CONNECTED, "Cannot start TLS when not connected");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->cx;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, g_tls_client_connection_get_type ())) {
		_data_->_tmp3_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_SUPPORTED, "Cannot start TLS when already established");
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Closing serializer to switch to TLS");
	_data_->_state_ = 1;
	geary_imap_client_connection_close_channels_async (_data_->self, _data_->cancellable, geary_imap_client_connection_starttls_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_client_connection_close_channels_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->endpoint;
	_data_->_tmp6_ = _data_->self->priv->cx;
	_data_->_state_ = 2;
	geary_endpoint_starttls_handshake_async (_data_->_tmp5_, _data_->_tmp6_, _data_->cancellable, geary_imap_client_connection_starttls_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp7_ = geary_endpoint_starttls_handshake_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp4_ = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->_tmp4_;
	_data_->_tmp4_ = NULL;
	_g_object_unref0 (_data_->self->priv->cx);
	_data_->self->priv->cx = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, g_io_stream_get_type (), GIOStream);
	_data_->_state_ = 3;
	geary_imap_client_connection_open_channels_async (_data_->self, geary_imap_client_connection_starttls_async_ready, _data_);
	return FALSE;
	_state_3:
	geary_imap_client_connection_open_channels_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp4_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->_tmp4_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_client_connection_send_command (GearyImapClientConnection* self,
                                           GearyImapCommand* new_command,
                                           GError** error)
{
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GearyNonblockingQueue* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (new_command));
	geary_imap_client_connection_check_connection (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == GEARY_IMAP_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = geary_imap_command_get_should_send (new_command);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		_tmp3_ = geary_imap_command_get_should_send (new_command);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_cancellable_is_cancelled (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		geary_imap_command_cancelled_before_send (new_command);
		_tmp5_ = geary_imap_command_to_brief_string (new_command);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Not queuing command, sending is cancelled: %s", _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error0_ = _tmp8_;
		if ((_inner_error0_->domain == GEARY_IMAP_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = self->priv->pending_queue;
	geary_nonblocking_queue_send (_tmp9_, new_command);
	geary_imap_client_connection_cancel_idle (self);
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_imap_client_connection_real_to_logging_state (GearyLoggingSource* base)
{
	GearyImapClientConnection * self;
	const gchar* _tmp0_ = NULL;
	GIOStream* _tmp1_;
	GearyEndpoint* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GearyLoggingState* _tmp5_;
	GearyLoggingState* _tmp6_;
	GearyLoggingState* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_CONNECTION, GearyImapClientConnection);
	_tmp1_ = self->priv->cx;
	if (_tmp1_ != NULL) {
		_tmp0_ = "up";
	} else {
		_tmp0_ = "down";
	}
	_tmp2_ = self->priv->endpoint;
	_tmp3_ = geary_endpoint_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%04X/%s/%s", (guint) self->priv->cx_id, _tmp4_, _tmp0_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}

/**
     * Returns the command that has been sent with the given tag.
     *
     * This should be private, but is internal for the
     * ClientSession.on_received_status_response IDLE workaround.
     */
GearyImapCommand*
geary_imap_client_connection_get_sent_command (GearyImapClientConnection* self,
                                               GearyImapTag* tag)
{
	GearyImapCommand* sent = NULL;
	GearyImapCommand* result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (tag), NULL);
	sent = NULL;
	if (geary_imap_tag_is_tagged (tag)) {
		{
			GeeIterator* _queued_it = NULL;
			GeeQueue* _tmp0_;
			GeeIterator* _tmp1_;
			_tmp0_ = self->priv->sent_queue;
			_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
			_queued_it = _tmp1_;
			while (TRUE) {
				GeeIterator* _tmp2_;
				GearyImapCommand* queued = NULL;
				GeeIterator* _tmp3_;
				gpointer _tmp4_;
				GearyImapCommand* _tmp5_;
				GearyImapTag* _tmp6_;
				GearyImapTag* _tmp7_;
				_tmp2_ = _queued_it;
				if (!gee_iterator_next (_tmp2_)) {
					break;
				}
				_tmp3_ = _queued_it;
				_tmp4_ = gee_iterator_get (_tmp3_);
				queued = (GearyImapCommand*) _tmp4_;
				_tmp5_ = queued;
				_tmp6_ = geary_imap_command_get_tag (_tmp5_);
				_tmp7_ = _tmp6_;
				if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (tag, GEE_TYPE_HASHABLE, GeeHashable), _tmp7_)) {
					GearyImapCommand* _tmp8_;
					GearyImapCommand* _tmp9_;
					_tmp8_ = queued;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (sent);
					sent = _tmp9_;
					_g_object_unref0 (queued);
					break;
				}
				_g_object_unref0 (queued);
			}
			_g_object_unref0 (_queued_it);
		}
	}
	result = sent;
	return result;
}

/** Sets the connection's logging parent. */
void
geary_imap_client_connection_set_logging_parent (GearyImapClientConnection* self,
                                                 GearyLoggingSource* parent)
{
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_LOGGING_IS_SOURCE (parent));
	self->priv->_logging_parent = parent;
}

static GTcpConnection*
geary_imap_client_connection_getTcpConnection (GearyImapClientConnection* self)
{
	GIOStream* cx = NULL;
	GIOStream* _tmp0_;
	GIOStream* _tmp1_;
	GTlsConnection* tls_cx = NULL;
	GIOStream* _tmp2_;
	GTlsConnection* _tmp3_;
	GTlsConnection* _tmp4_;
	GIOStream* _tmp8_;
	GTcpConnection* _tmp9_;
	GTcpConnection* result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self), NULL);
	_tmp0_ = self->priv->cx;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	cx = _tmp1_;
	_tmp2_ = cx;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_tls_connection_get_type ()) ? ((GTlsConnection*) _tmp2_) : NULL);
	tls_cx = _tmp3_;
	_tmp4_ = tls_cx;
	if (_tmp4_ != NULL) {
		GTlsConnection* _tmp5_;
		GIOStream* _tmp6_;
		GIOStream* _tmp7_;
		_tmp5_ = tls_cx;
		g_object_get (_tmp5_, "base-io-stream", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (cx);
		cx = _tmp7_;
	}
	_tmp8_ = cx;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_tcp_connection_get_type ()) ? ((GTcpConnection*) _tmp8_) : NULL);
	result = _tmp9_;
	_g_object_unref0 (tls_cx);
	_g_object_unref0 (cx);
	return result;
}

static void
geary_imap_client_connection_open_channels_async_data_free (gpointer _data)
{
	GearyImapClientConnectionOpenChannelsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientConnectionOpenChannelsAsyncData, _data_);
}

static void
geary_imap_client_connection_open_channels_async (GearyImapClientConnection* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GearyImapClientConnectionOpenChannelsAsyncData* _data_;
	GearyImapClientConnection* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	_data_ = g_slice_new0 (GearyImapClientConnectionOpenChannelsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_connection_open_channels_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_client_connection_open_channels_async_co (_data_);
}

static void
geary_imap_client_connection_open_channels_finish (GearyImapClientConnection* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GearyImapClientConnectionOpenChannelsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_geary_imap_client_connection_on_bytes_received_geary_imap_deserializer_bytes_received (GearyImapDeserializer* _sender,
                                                                                        gsize bytes,
                                                                                        gpointer self)
{
	geary_imap_client_connection_on_bytes_received ((GearyImapClientConnection*) self, bytes);
}

static void
_geary_imap_client_connection_on_deserialize_failure_geary_imap_deserializer_deserialize_failure (GearyImapDeserializer* _sender,
                                                                                                  gpointer self)
{
	geary_imap_client_connection_on_deserialize_failure ((GearyImapClientConnection*) self);
}

static void
_geary_imap_client_connection_on_eos_geary_imap_deserializer_end_of_stream (GearyImapDeserializer* _sender,
                                                                            gpointer self)
{
	geary_imap_client_connection_on_eos ((GearyImapClientConnection*) self);
}

static void
_geary_imap_client_connection_on_parameters_ready_geary_imap_deserializer_parameters_ready (GearyImapDeserializer* _sender,
                                                                                            GearyImapRootParameters* root,
                                                                                            gpointer self)
{
	geary_imap_client_connection_on_parameters_ready ((GearyImapClientConnection*) self, root);
}

static void
_geary_imap_client_connection_on_receive_failure_geary_imap_deserializer_receive_failure (GearyImapDeserializer* _sender,
                                                                                          GError* err,
                                                                                          gpointer self)
{
	geary_imap_client_connection_on_receive_failure ((GearyImapClientConnection*) self, err);
}

static void
geary_imap_client_connection_open_channels_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	GearyImapClientConnectionOpenChannelsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_connection_open_channels_async_co (_data_);
}

static gboolean
geary_imap_client_connection_open_channels_async_co (GearyImapClientConnectionOpenChannelsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->open_cancellable);
	_data_->self->priv->open_cancellable = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup_printf ("%04d", _data_->self->priv->cx_id);
	_data_->id = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->cx;
	_data_->_tmp3_ = g_io_stream_get_output_stream (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = (GBufferedOutputStream*) g_buffered_output_stream_new (_data_->_tmp4_);
	_data_->serializer_buffer = _data_->_tmp5_;
	g_filter_output_stream_set_close_base_stream (G_TYPE_CHECK_INSTANCE_CAST (_data_->serializer_buffer, g_filter_output_stream_get_type (), GFilterOutputStream), FALSE);
	_data_->_tmp6_ = geary_imap_serializer_new (G_TYPE_CHECK_INSTANCE_CAST (_data_->serializer_buffer, g_output_stream_get_type (), GOutputStream));
	_g_object_unref0 (_data_->self->priv->serializer);
	_data_->self->priv->serializer = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->self->priv->cx;
	_data_->_tmp8_ = g_io_stream_get_input_stream (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->self->priv->quirks;
	_data_->_tmp11_ = geary_imap_deserializer_new (_data_->id, _data_->_tmp9_, _data_->_tmp10_);
	_g_object_unref0 (_data_->self->priv->deserializer);
	_data_->self->priv->deserializer = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->self->priv->deserializer;
	g_signal_connect_object (_data_->_tmp12_, "bytes-received", (GCallback) _geary_imap_client_connection_on_bytes_received_geary_imap_deserializer_bytes_received, _data_->self, 0);
	_data_->_tmp13_ = _data_->self->priv->deserializer;
	g_signal_connect_object (_data_->_tmp13_, "deserialize-failure", (GCallback) _geary_imap_client_connection_on_deserialize_failure_geary_imap_deserializer_deserialize_failure, _data_->self, 0);
	_data_->_tmp14_ = _data_->self->priv->deserializer;
	g_signal_connect_object (_data_->_tmp14_, "end-of-stream", (GCallback) _geary_imap_client_connection_on_eos_geary_imap_deserializer_end_of_stream, _data_->self, 0);
	_data_->_tmp15_ = _data_->self->priv->deserializer;
	g_signal_connect_object (_data_->_tmp15_, "parameters-ready", (GCallback) _geary_imap_client_connection_on_parameters_ready_geary_imap_deserializer_parameters_ready, _data_->self, 0);
	_data_->_tmp16_ = _data_->self->priv->deserializer;
	g_signal_connect_object (_data_->_tmp16_, "receive-failure", (GCallback) _geary_imap_client_connection_on_receive_failure_geary_imap_deserializer_receive_failure, _data_->self, 0);
	_data_->_tmp17_ = _data_->self->priv->deserializer;
	geary_imap_deserializer_set_logging_parent (_data_->_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp18_ = _data_->self->priv->deserializer;
	_data_->_state_ = 1;
	geary_imap_deserializer_start_async (_data_->_tmp18_, G_PRIORITY_DEFAULT_IDLE, geary_imap_client_connection_open_channels_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_deserializer_start_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->serializer_buffer);
		_g_free0 (_data_->id);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_imap_client_connection_send_loop (_data_->self, NULL, NULL);
	_g_object_unref0 (_data_->serializer_buffer);
	_g_free0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_connection_close_channels_async_data_free (gpointer _data)
{
	GearyImapClientConnectionCloseChannelsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientConnectionCloseChannelsAsyncData, _data_);
}

static void
geary_imap_client_connection_close_channels_async (GearyImapClientConnection* self,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GearyImapClientConnectionCloseChannelsAsyncData* _data_;
	GearyImapClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapClientConnectionCloseChannelsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_connection_close_channels_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_connection_close_channels_async_co (_data_);
}

static void
geary_imap_client_connection_close_channels_finish (GearyImapClientConnection* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GearyImapClientConnectionCloseChannelsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Disconnect and deallocates the Serializer and Deserializer. */
static void
geary_imap_client_connection_close_channels_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GearyImapClientConnectionCloseChannelsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_connection_close_channels_async_co (_data_);
}

static gboolean
geary_imap_client_connection_close_channels_async_co (GearyImapClientConnectionCloseChannelsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->open_cancellable;
	g_cancellable_cancel (_data_->_tmp0_);
	{
		_data_->_tmp1_ = _data_->self->priv->sent_queue;
		_data_->_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_sent_it = _data_->_tmp2_;
		while (TRUE) {
			_data_->_tmp3_ = _data_->_sent_it;
			if (!gee_iterator_next (_data_->_tmp3_)) {
				break;
			}
			_data_->_tmp4_ = _data_->_sent_it;
			_data_->_tmp5_ = gee_iterator_get (_data_->_tmp4_);
			_data_->sent = (GearyImapCommand*) _data_->_tmp5_;
			_data_->_tmp6_ = _data_->sent;
			_data_->_tmp7_ = geary_imap_command_to_brief_string (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Cancelling sent command: %s", _data_->_tmp8_);
			_g_free0 (_data_->_tmp8_);
			_data_->_tmp9_ = _data_->sent;
			geary_imap_command_disconnected (_data_->_tmp9_, "Connection channels closed");
			_g_object_unref0 (_data_->sent);
		}
		_g_object_unref0 (_data_->_sent_it);
	}
	_data_->_tmp10_ = _data_->self->priv->sent_queue;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp11_ = _data_->self->priv->serializer;
	if (_data_->_tmp11_ != NULL) {
		_data_->_tmp12_ = _data_->self->priv->serializer;
		_data_->_state_ = 1;
		geary_imap_serializer_close_stream (_data_->_tmp12_, _data_->cancellable, geary_imap_client_connection_close_channels_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_imap_serializer_close_stream_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->self->priv->serializer);
		_data_->self->priv->serializer = NULL;
	}
	_data_->_tmp13_ = _data_->self->priv->deserializer;
	_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
	_data_->deserializer = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->deserializer;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = _data_->deserializer;
		g_signal_parse_name ("bytes-received", GEARY_IMAP_TYPE_DESERIALIZER, &_data_->_tmp17_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp17_, 0, NULL, (GCallback) _geary_imap_client_connection_on_bytes_received_geary_imap_deserializer_bytes_received, _data_->self);
		_data_->_tmp18_ = _data_->deserializer;
		g_signal_parse_name ("deserialize-failure", GEARY_IMAP_TYPE_DESERIALIZER, &_data_->_tmp19_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp19_, 0, NULL, (GCallback) _geary_imap_client_connection_on_deserialize_failure_geary_imap_deserializer_deserialize_failure, _data_->self);
		_data_->_tmp20_ = _data_->deserializer;
		g_signal_parse_name ("end-of-stream", GEARY_IMAP_TYPE_DESERIALIZER, &_data_->_tmp21_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp21_, 0, NULL, (GCallback) _geary_imap_client_connection_on_eos_geary_imap_deserializer_end_of_stream, _data_->self);
		_data_->_tmp22_ = _data_->deserializer;
		g_signal_parse_name ("parameters-ready", GEARY_IMAP_TYPE_DESERIALIZER, &_data_->_tmp23_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp23_, 0, NULL, (GCallback) _geary_imap_client_connection_on_parameters_ready_geary_imap_deserializer_parameters_ready, _data_->self);
		_data_->_tmp24_ = _data_->deserializer;
		g_signal_parse_name ("receive-failure", GEARY_IMAP_TYPE_DESERIALIZER, &_data_->_tmp25_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp24_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp25_, 0, NULL, (GCallback) _geary_imap_client_connection_on_receive_failure_geary_imap_deserializer_receive_failure, _data_->self);
		_data_->_tmp26_ = _data_->deserializer;
		_data_->_state_ = 2;
		geary_imap_deserializer_stop_async (_data_->_tmp26_, geary_imap_client_connection_close_channels_async_ready, _data_);
		return FALSE;
		_state_2:
		geary_imap_deserializer_stop_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->deserializer);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->self->priv->deserializer);
		_data_->self->priv->deserializer = NULL;
	}
	_g_object_unref0 (_data_->deserializer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline void
geary_imap_client_connection_cancel_idle (GearyImapClientConnection* self)
{
	GearyTimeoutManager* _tmp0_;
	GearyImapIdleCommand* idle = NULL;
	GearyImapCommand* _tmp1_;
	GearyImapIdleCommand* _tmp2_;
	GearyImapIdleCommand* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	_tmp0_ = self->priv->idle_timer;
	geary_timeout_manager_reset (_tmp0_);
	_tmp1_ = self->priv->current_command;
	_tmp2_ = _g_object_ref0 (GEARY_IMAP_IS_IDLE_COMMAND (_tmp1_) ? ((GearyImapIdleCommand*) _tmp1_) : NULL);
	idle = _tmp2_;
	_tmp3_ = idle;
	if (_tmp3_ != NULL) {
		GearyImapIdleCommand* _tmp4_;
		_tmp4_ = idle;
		geary_imap_idle_command_exit_idle (_tmp4_);
	}
	_g_object_unref0 (idle);
}

static GearyImapTag*
geary_imap_client_connection_generate_tag (GearyImapClientConnection* self)
{
	gint _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GearyImapTag* _tmp4_;
	GearyImapTag* _tmp5_;
	GearyImapTag* result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self), NULL);
	self->priv->tag_counter = self->priv->tag_counter + 1;
	_tmp0_ = self->priv->tag_counter;
	if (_tmp0_ >= 1000) {
		gint _tmp1_ = 0;
		self->priv->tag_counter = 0;
		if (self->priv->tag_prefix != 'z') {
			_tmp1_ = self->priv->tag_prefix + 1;
		} else {
			_tmp1_ = (gint) 'a';
		}
		self->priv->tag_prefix = (gchar) _tmp1_;
	}
	_tmp2_ = g_strdup_printf ("%c%03d", (gint) self->priv->tag_prefix, self->priv->tag_counter);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_imap_tag_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static void
geary_imap_client_connection_send_loop_data_free (gpointer _data)
{
	GearyImapClientConnectionSendLoopData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientConnectionSendLoopData, _data_);
}

static void
geary_imap_client_connection_send_loop (GearyImapClientConnection* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearyImapClientConnectionSendLoopData* _data_;
	GearyImapClientConnection* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	_data_ = g_slice_new0 (GearyImapClientConnectionSendLoopData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_connection_send_loop_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_client_connection_send_loop_co (_data_);
}

static void
geary_imap_client_connection_send_loop_finish (GearyImapClientConnection* self,
                                               GAsyncResult* _res_)
{
	GearyImapClientConnectionSendLoopData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/** Long lived method to send commands as they are queued. */
static void
geary_imap_client_connection_send_loop_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearyImapClientConnectionSendLoopData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_connection_send_loop_co (_data_);
}

static gboolean
geary_imap_client_connection_send_loop_co (GearyImapClientConnectionSendLoopData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		_data_->_tmp0_ = _data_->self->priv->open_cancellable;
		if (!(!g_cancellable_is_cancelled (_data_->_tmp0_))) {
			break;
		}
		{
			_data_->_tmp1_ = _data_->self->priv->open_cancellable;
			_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
			_data_->cancellable = _data_->_tmp2_;
			_data_->_tmp3_ = _data_->self->priv->pending_queue;
			_data_->_tmp4_ = _data_->self->priv->open_cancellable;
			_data_->_state_ = 1;
			geary_nonblocking_queue_receive (_data_->_tmp3_, _data_->_tmp4_, geary_imap_client_connection_send_loop_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp5_ = geary_nonblocking_queue_receive_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
			_data_->pending = (GearyImapCommand*) _data_->_tmp5_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->cancellable);
				goto __catch0_g_error;
			}
			_data_->_tmp7_ = _data_->pending;
			if (!GEARY_IMAP_IS_IDLE_COMMAND (_data_->_tmp7_)) {
				_data_->_tmp6_ = TRUE;
			} else {
				_data_->_tmp8_ = _data_->self->priv->pending_queue;
				_data_->_tmp9_ = geary_nonblocking_queue_get_is_empty (_data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				_data_->_tmp6_ = _data_->_tmp10_;
			}
			if (_data_->_tmp6_) {
				_data_->_tmp11_ = _data_->pending;
				_data_->_tmp12_ = _data_->cancellable;
				_data_->_state_ = 2;
				geary_imap_client_connection_flush_command (_data_->self, _data_->_tmp11_, _data_->_tmp12_, geary_imap_client_connection_send_loop_ready, _data_);
				return FALSE;
				_state_2:
				geary_imap_client_connection_flush_command_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->pending);
					_g_object_unref0 (_data_->cancellable);
					goto __catch0_g_error;
				}
			}
			_data_->_tmp13_ = _data_->self->priv->pending_queue;
			_data_->_tmp14_ = geary_nonblocking_queue_get_is_empty (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			if (_data_->_tmp15_) {
				_data_->_tmp16_ = _data_->self->priv->serializer;
				_data_->_tmp17_ = _data_->cancellable;
				_data_->_state_ = 3;
				geary_imap_serializer_flush_stream (_data_->_tmp16_, _data_->_tmp17_, geary_imap_client_connection_send_loop_ready, _data_);
				return FALSE;
				_state_3:
				geary_imap_serializer_flush_stream_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->pending);
					_g_object_unref0 (_data_->cancellable);
					goto __catch0_g_error;
				}
			}
			_g_object_unref0 (_data_->pending);
			_g_object_unref0 (_data_->cancellable);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp18_ = _data_->err;
			if (!g_error_matches (_data_->_tmp18_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp19_ = _data_->err;
				g_signal_emit (_data_->self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_SEND_FAILURE_SIGNAL], 0, _data_->_tmp19_);
			}
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_connection_flush_command_data_free (gpointer _data)
{
	GearyImapClientConnectionFlushCommandData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->command);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientConnectionFlushCommandData, _data_);
}

static void
geary_imap_client_connection_flush_command (GearyImapClientConnection* self,
                                            GearyImapCommand* command,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyImapClientConnectionFlushCommandData* _data_;
	GearyImapClientConnection* _tmp0_;
	GearyImapCommand* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (command));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapClientConnectionFlushCommandData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_connection_flush_command_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (command);
	_g_object_unref0 (_data_->command);
	_data_->command = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_client_connection_flush_command_co (_data_);
}

static void
geary_imap_client_connection_flush_command_finish (GearyImapClientConnection* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GearyImapClientConnectionFlushCommandData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_geary_imap_client_connection_on_command_timeout_geary_imap_command_response_timed_out (GearyImapCommand* _sender,
                                                                                        gpointer self)
{
	geary_imap_client_connection_on_command_timeout ((GearyImapClientConnection*) self, _sender);
}

static void
geary_imap_client_connection_flush_command_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearyImapClientConnectionFlushCommandData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_connection_flush_command_co (_data_);
}

static gboolean
geary_imap_client_connection_flush_command_co (GearyImapClientConnectionFlushCommandData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = geary_imap_command_get_should_send (_data_->command);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = geary_imap_command_get_should_send (_data_->command);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->_tmp4_);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		geary_imap_command_cancelled_before_send (_data_->command);
		_data_->_tmp5_ = geary_imap_command_to_brief_string (_data_->command);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = g_error_new (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Not sending command, sending is cancelled: %s", _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_free0 (_data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp8_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->ser_error = NULL;
	{
		_data_->_tmp9_ = geary_imap_client_connection_generate_tag (_data_->self);
		_data_->_tmp10_ = _data_->_tmp9_;
		geary_imap_command_assign_tag (_data_->command, _data_->_tmp10_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp10_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		geary_imap_command_set_response_timeout (_data_->command, _data_->self->priv->command_timeout);
		g_signal_connect_object (_data_->command, "response-timed-out", (GCallback) _geary_imap_client_connection_on_command_timeout_geary_imap_command_response_timed_out, _data_->self, 0);
		_data_->_tmp11_ = _g_object_ref0 (_data_->command);
		_g_object_unref0 (_data_->self->priv->current_command);
		_data_->self->priv->current_command = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->self->priv->sent_queue;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), _data_->command);
		_data_->_tmp13_ = _data_->self->priv->serializer;
		_data_->_state_ = 1;
		geary_imap_command_send (_data_->command, _data_->_tmp13_, _data_->cancellable, geary_imap_client_connection_flush_command_ready, _data_);
		return FALSE;
		_state_1:
		geary_imap_command_send_finish (_data_->command, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (_data_->self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_SENT_COMMAND_SIGNAL], 0, _data_->command);
		_data_->_tmp14_ = _data_->self->priv->serializer;
		_data_->_state_ = 2;
		geary_imap_command_send_wait (_data_->command, _data_->_tmp14_, _data_->cancellable, geary_imap_client_connection_flush_command_ready, _data_);
		return FALSE;
		_state_2:
		geary_imap_command_send_wait_finish (_data_->command, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->err;
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
		_g_error_free0 (_data_->ser_error);
		_data_->ser_error = _data_->_tmp16_;
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->ser_error);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->current_command);
	_data_->self->priv->current_command = NULL;
	_data_->_tmp17_ = _data_->ser_error;
	if (_data_->_tmp17_ != NULL) {
		_data_->_tmp18_ = _data_->self->priv->sent_queue;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), _data_->command);
		_data_->_tmp19_ = _data_->ser_error;
		_data_->_tmp20_ = _g_error_copy0 (_data_->_tmp19_);
		_data_->_inner_error0_ = _data_->_tmp20_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->ser_error);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_error_free0 (_data_->ser_error);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_connection_check_connection (GearyImapClientConnection* self,
                                               GError** error)
{
	GIOStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	_tmp0_ = self->priv->cx;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_CONNECTED, "Not connected to %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
geary_imap_client_connection_on_parameters_ready (GearyImapClientConnection* self,
                                                  GearyImapRootParameters* root)
{
	gboolean _tmp14_ = FALSE;
	GearyNonblockingQueue* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root));
	{
		if (geary_imap_continuation_response_is_continuation_response (root)) {
			GearyImapContinuationResponse* _tmp0_ = NULL;
			GearyImapQuirks* _tmp1_;
			GearyImapContinuationResponse* _tmp2_;
			_tmp1_ = self->priv->quirks;
			_tmp2_ = geary_imap_continuation_response_new_migrate (root, _tmp1_, &_inner_error0_);
			_tmp0_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					goto __catch0_geary_imap_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			geary_imap_client_connection_on_continuation_response (self, _tmp0_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp0_);
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					goto __catch0_geary_imap_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (_tmp0_);
		} else {
			if (geary_imap_status_response_is_status_response (root)) {
				GearyImapStatusResponse* _tmp3_ = NULL;
				GearyImapQuirks* _tmp4_;
				GearyImapStatusResponse* _tmp5_;
				_tmp4_ = self->priv->quirks;
				_tmp5_ = geary_imap_status_response_new_migrate (root, _tmp4_, &_inner_error0_);
				_tmp3_ = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						goto __catch0_geary_imap_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				geary_imap_client_connection_on_status_response (self, _tmp3_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp3_);
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						goto __catch0_geary_imap_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_object_unref0 (_tmp3_);
			} else {
				if (geary_imap_server_data_is_server_data (root)) {
					GearyImapServerData* _tmp6_ = NULL;
					GearyImapQuirks* _tmp7_;
					GearyImapServerData* _tmp8_;
					_tmp7_ = self->priv->quirks;
					_tmp8_ = geary_imap_server_data_new_migrate (root, _tmp7_, &_inner_error0_);
					_tmp6_ = _tmp8_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							goto __catch0_geary_imap_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					geary_imap_client_connection_on_server_data (self, _tmp6_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (_tmp6_);
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							goto __catch0_geary_imap_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_object_unref0 (_tmp6_);
				} else {
					gchar* _tmp9_;
					gchar* _tmp10_;
					GError* _tmp11_;
					GError* _tmp12_;
					_tmp9_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
					_tmp10_ = _tmp9_;
					_tmp11_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Unknown server response: %s", _tmp10_);
					_tmp12_ = _tmp11_;
					_g_free0 (_tmp10_);
					_inner_error0_ = _tmp12_;
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						goto __catch0_geary_imap_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	goto __finally0;
	__catch0_geary_imap_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_BAD_RESPONSE_SIGNAL], 0, root, _tmp13_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp15_ = self->priv->pending_queue;
	_tmp16_ = geary_nonblocking_queue_get_is_empty (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		GeeQueue* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->sent_queue;
		_tmp19_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp20_ = _tmp19_;
		_tmp14_ = _tmp20_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gboolean _tmp21_;
		_tmp21_ = self->priv->_idle_when_quiet;
		if (_tmp21_) {
			GearyTimeoutManager* _tmp22_;
			_tmp22_ = self->priv->idle_timer;
			geary_timeout_manager_start (_tmp22_);
		}
	}
}

static void
geary_imap_client_connection_on_status_response (GearyImapClientConnection* self,
                                                 GearyImapStatusResponse* status,
                                                 GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (status));
	g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_STATUS_RESPONSE_SIGNAL], 0, status);
	_tmp0_ = geary_imap_status_response_get_is_completion (status);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GearyImapCommand* sent = NULL;
		GearyImapTag* _tmp2_;
		GearyImapTag* _tmp3_;
		GearyImapCommand* _tmp4_;
		GearyImapCommand* _tmp5_;
		GeeQueue* _tmp10_;
		GearyImapCommand* _tmp11_;
		GearyImapCommand* _tmp12_;
		guint _tmp13_;
		GearyImapCommand* _tmp14_;
		_tmp2_ = geary_imap_server_response_get_tag (G_TYPE_CHECK_INSTANCE_CAST (status, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse));
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_imap_client_connection_get_sent_command (self, _tmp3_);
		sent = _tmp4_;
		_tmp5_ = sent;
		if (_tmp5_ == NULL) {
			gchar* _tmp6_;
			gchar* _tmp7_;
			GError* _tmp8_;
			GError* _tmp9_;
			_tmp6_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (status, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
			_tmp7_ = _tmp6_;
			_tmp8_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "Unexpected status response: %s", _tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp7_);
			_inner_error0_ = _tmp9_;
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sent);
				return;
			} else {
				_g_object_unref0 (sent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp10_ = self->priv->sent_queue;
		_tmp11_ = sent;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
		_tmp12_ = sent;
		g_signal_parse_name ("response-timed-out", GEARY_IMAP_TYPE_COMMAND, &_tmp13_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _geary_imap_client_connection_on_command_timeout_geary_imap_command_response_timed_out, self);
		_tmp14_ = sent;
		geary_imap_command_completed (_tmp14_, status, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sent);
				return;
			} else {
				_g_object_unref0 (sent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_object_unref0 (sent);
	}
}

static void
geary_imap_client_connection_on_server_data (GearyImapClientConnection* self,
                                             GearyImapServerData* data,
                                             GError** error)
{
	GearyImapCommand* sent = NULL;
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp1_;
	GearyImapCommand* _tmp2_;
	GearyImapCommand* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_IMAP_IS_SERVER_DATA (data));
	_tmp0_ = geary_imap_server_response_get_tag (G_TYPE_CHECK_INSTANCE_CAST (data, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_client_connection_get_sent_command (self, _tmp1_);
	sent = _tmp2_;
	_tmp3_ = sent;
	if (_tmp3_ != NULL) {
		GearyImapCommand* _tmp4_;
		_tmp4_ = sent;
		geary_imap_command_data_received (_tmp4_, data, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sent);
				return;
			} else {
				_g_object_unref0 (sent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_SERVER_DATA_SIGNAL], 0, data);
	_g_object_unref0 (sent);
}

static void
geary_imap_client_connection_on_continuation_response (GearyImapClientConnection* self,
                                                       GearyImapContinuationResponse* continuation,
                                                       GError** error)
{
	GearyImapCommand* current = NULL;
	GearyImapCommand* _tmp0_;
	GearyImapCommand* _tmp1_;
	GearyImapCommand* _tmp2_;
	GearyImapCommand* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_IMAP_IS_CONTINUATION_RESPONSE (continuation));
	_tmp0_ = self->priv->current_command;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp3_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (continuation, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "Unexpected continuation request response: %s", _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (current);
			return;
		} else {
			_g_object_unref0 (current);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = current;
	geary_imap_command_continuation_requested (_tmp7_, continuation, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (current);
			return;
		} else {
			_g_object_unref0 (current);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_CONTINUATION_RESPONSE_SIGNAL], 0, continuation);
	_g_object_unref0 (current);
}

static void
geary_imap_client_connection_on_bytes_received (GearyImapClientConnection* self,
                                                gsize bytes)
{
	gint64 now = 0LL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	self->priv->bytes_accumulator = self->priv->bytes_accumulator + bytes;
	now = g_get_real_time ();
	if ((self->priv->last_seen + 1000000) <= now) {
		{
			GeeIterator* _command_it = NULL;
			GeeQueue* _tmp0_;
			GeeIterator* _tmp1_;
			_tmp0_ = self->priv->sent_queue;
			_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
			_command_it = _tmp1_;
			while (TRUE) {
				GeeIterator* _tmp2_;
				GearyImapCommand* command = NULL;
				GeeIterator* _tmp3_;
				gpointer _tmp4_;
				GearyImapCommand* _tmp5_;
				_tmp2_ = _command_it;
				if (!gee_iterator_next (_tmp2_)) {
					break;
				}
				_tmp3_ = _command_it;
				_tmp4_ = gee_iterator_get (_tmp3_);
				command = (GearyImapCommand*) _tmp4_;
				_tmp5_ = command;
				geary_imap_command_update_response_timer (_tmp5_);
				_g_object_unref0 (command);
			}
			_g_object_unref0 (_command_it);
		}
		g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_BYTES_SIGNAL], 0, self->priv->bytes_accumulator);
		self->priv->bytes_accumulator = (gsize) 0;
		self->priv->last_seen = now;
	}
}

static void
geary_imap_client_connection_on_eos (GearyImapClientConnection* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	_tmp0_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_CONNECTED, "End of stream reading from %s", _tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVE_FAILURE_SIGNAL], 0, _tmp3_);
	_g_error_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static void
geary_imap_client_connection_on_receive_failure (GearyImapClientConnection* self,
                                                 GError* err)
{
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (err != NULL);
	g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVE_FAILURE_SIGNAL], 0, err);
}

static void
geary_imap_client_connection_on_deserialize_failure (GearyImapClientConnection* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	_tmp0_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Unable to deserialize from %s", _tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVE_FAILURE_SIGNAL], 0, _tmp3_);
	_g_error_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static void
geary_imap_client_connection_on_command_timeout (GearyImapClientConnection* self,
                                                 GearyImapCommand* command)
{
	GeeQueue* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (command));
	_tmp0_ = self->priv->sent_queue;
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), command);
	g_signal_parse_name ("response-timed-out", GEARY_IMAP_TYPE_COMMAND, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (command, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _geary_imap_client_connection_on_command_timeout_geary_imap_command_response_timed_out, self);
	_tmp2_ = geary_imap_command_get_response_timeout (command);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_imap_command_to_string (command);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TIMED_OUT, "No response to command after %u seconds: %s", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_emit (self, geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVE_FAILURE_SIGNAL], 0, _tmp7_);
	_g_error_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}

static void
geary_imap_client_connection_on_idle_timeout (GearyImapClientConnection* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_CONNECTION (self));
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Initiating IDLE");
	{
		GCancellable* _tmp0_;
		GearyImapIdleCommand* _tmp1_;
		GearyImapIdleCommand* _tmp2_;
		_tmp0_ = self->priv->open_cancellable;
		_tmp1_ = geary_imap_idle_command_new (_tmp0_);
		_tmp2_ = _tmp1_;
		geary_imap_client_connection_send_command (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error sending IDLE: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
geary_imap_client_connection_class_init (GearyImapClientConnectionClass * klass,
                                         gpointer klass_data)
{
	geary_imap_client_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapClientConnection_private_offset);
	((GearyImapClientConnectionClass *) klass)->sent_command = geary_imap_client_connection_real_sent_command;
	((GearyImapClientConnectionClass *) klass)->received_status_response = geary_imap_client_connection_real_received_status_response;
	((GearyImapClientConnectionClass *) klass)->received_server_data = geary_imap_client_connection_real_received_server_data;
	((GearyImapClientConnectionClass *) klass)->received_continuation_response = geary_imap_client_connection_real_received_continuation_response;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_client_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_client_connection_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_client_connection_finalize;
	/**
	     * Determines if the connection will use IMAP IDLE when idle.
	     *
	     * If //true//, when the connection is not sending commands
	     * ("quiet"), it will issue an IDLE command to enter a state where
	     * unsolicited server data may be sent from the server without
	     * resorting to NOOP keepalives.  (Note that keepalives are still
	     * required to hold the connection open, according to the IMAP
	     * specification.)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_CONNECTION_IDLE_WHEN_QUIET_PROPERTY, geary_imap_client_connection_properties[GEARY_IMAP_CLIENT_CONNECTION_IDLE_WHEN_QUIET_PROPERTY] = g_param_spec_boolean ("idle-when-quiet", "idle-when-quiet", "idle-when-quiet", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY, geary_imap_client_connection_properties[GEARY_IMAP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_SENT_COMMAND_SIGNAL] = g_signal_new ("sent-command", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearyImapClientConnectionClass, sent_command), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_IMAP_TYPE_COMMAND);
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_STATUS_RESPONSE_SIGNAL] = g_signal_new ("received-status-response", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearyImapClientConnectionClass, received_status_response), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_IMAP_TYPE_STATUS_RESPONSE);
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_SERVER_DATA_SIGNAL] = g_signal_new ("received-server-data", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearyImapClientConnectionClass, received_server_data), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_IMAP_TYPE_SERVER_DATA);
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_CONTINUATION_RESPONSE_SIGNAL] = g_signal_new ("received-continuation-response", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearyImapClientConnectionClass, received_continuation_response), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_IMAP_TYPE_CONTINUATION_RESPONSE);
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_BYTES_SIGNAL] = g_signal_new ("received-bytes", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ULONG, G_TYPE_NONE, 1, G_TYPE_ULONG);
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVED_BAD_RESPONSE_SIGNAL] = g_signal_new ("received-bad-response", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOXED, G_TYPE_NONE, 2, GEARY_IMAP_TYPE_ROOT_PARAMETERS, G_TYPE_ERROR);
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_SEND_FAILURE_SIGNAL] = g_signal_new ("send-failure", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_ERROR);
	geary_imap_client_connection_signals[GEARY_IMAP_CLIENT_CONNECTION_RECEIVE_FAILURE_SIGNAL] = g_signal_new ("receive-failure", GEARY_IMAP_TYPE_CLIENT_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_ERROR);
}

static void
geary_imap_client_connection_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                                  gpointer iface_data)
{
	geary_imap_client_connection_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_imap_client_connection_real_to_logging_state;
	iface->get_logging_domain = geary_imap_client_connection_real_get_logging_domain;
	iface->get_logging_parent = geary_imap_client_connection_real_get_logging_parent;
}

static void
geary_imap_client_connection_instance_init (GearyImapClientConnection * self,
                                            gpointer klass)
{
	GearyNonblockingQueue* _tmp0_;
	GeeLinkedList* _tmp1_;
	self->priv = geary_imap_client_connection_get_instance_private (self);
	self->priv->_idle_when_quiet = FALSE;
	self->priv->_logging_parent = NULL;
	self->priv->cx = NULL;
	self->priv->deserializer = NULL;
	self->priv->serializer = NULL;
	self->priv->tag_counter = 0;
	self->priv->tag_prefix = 'a';
	self->priv->last_seen = (gint64) 0;
	self->priv->bytes_accumulator = (gsize) 0;
	_tmp0_ = geary_nonblocking_queue_new_fifo (GEARY_IMAP_TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->pending_queue = _tmp0_;
	_tmp1_ = gee_linked_list_new (GEARY_IMAP_TYPE_COMMAND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->sent_queue = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_QUEUE, GeeQueue);
	self->priv->current_command = NULL;
	self->priv->open_cancellable = NULL;
}

static void
geary_imap_client_connection_finalize (GObject * obj)
{
	GearyImapClientConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_CLIENT_CONNECTION, GearyImapClientConnection);
	_g_object_unref0 (self->priv->endpoint);
	_g_object_unref0 (self->priv->quirks);
	_g_object_unref0 (self->priv->cx);
	_g_object_unref0 (self->priv->deserializer);
	_g_object_unref0 (self->priv->serializer);
	_g_object_unref0 (self->priv->pending_queue);
	_g_object_unref0 (self->priv->sent_queue);
	_g_object_unref0 (self->priv->current_command);
	_g_object_unref0 (self->priv->idle_timer);
	_g_object_unref0 (self->priv->open_cancellable);
	G_OBJECT_CLASS (geary_imap_client_connection_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_client_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapClientConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_client_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapClientConnection), 0, (GInstanceInitFunc) geary_imap_client_connection_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_imap_client_connection_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_client_connection_type_id;
	geary_imap_client_connection_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapClientConnection", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_client_connection_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearyImapClientConnection_private_offset = g_type_add_instance_private (geary_imap_client_connection_type_id, sizeof (GearyImapClientConnectionPrivate));
	return geary_imap_client_connection_type_id;
}

GType
geary_imap_client_connection_get_type (void)
{
	static gsize geary_imap_client_connection_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_client_connection_type_id__once)) {
		GType geary_imap_client_connection_type_id;
		geary_imap_client_connection_type_id = geary_imap_client_connection_get_type_once ();
		g_once_init_leave (&geary_imap_client_connection_type_id__once, geary_imap_client_connection_type_id);
	}
	return geary_imap_client_connection_type_id__once;
}

static void
_vala_geary_imap_client_connection_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapClientConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CLIENT_CONNECTION, GearyImapClientConnection);
	switch (property_id) {
		case GEARY_IMAP_CLIENT_CONNECTION_IDLE_WHEN_QUIET_PROPERTY:
		g_value_set_boolean (value, geary_imap_client_connection_get_idle_when_quiet (self));
		break;
		case GEARY_IMAP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_client_connection_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapClientConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CLIENT_CONNECTION, GearyImapClientConnection);
	switch (property_id) {
		case GEARY_IMAP_CLIENT_CONNECTION_IDLE_WHEN_QUIET_PROPERTY:
		geary_imap_client_connection_set_idle_when_quiet (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

