/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <stdbool.h>
/************ Begin %include sections from the grammar ************************/
#line 56 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

#include "sqlInt.h"

/*
** Disable all error recovery processing in the parser push-down
** automaton.
*/
#define YYNOERRORRECOVERY 1

/*
** Indicate that sqlParserFree() will never be called with a null
** pointer.
*/
#define YYPARSEFREENEVERNULL 1

/*
 * Stop the parser if an error occurs. This macro adds an
 * additional check that allows the parser to be stopped if any
 * error was noticed.
 */
#define PARSER_ERROR_CHECK && ! pParse->is_aborted

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** Disable lookaside memory allocation for objects that might be
** shared across database connections.
*/
static void disableLookaside(Parse *pParse){
  pParse->disableLookaside++;
  sql_get()->lookaside.bDisable++;
}

#line 429 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  /**
   * For a compound SELECT statement, make sure
   * p->pPrior->pNext==p for all elements in the list. And make
   * sure list length does not exceed SQL_MAX_COMPOUND_SELECT.
   */
  static void parserDoubleLinkSelect(Parse *pParse, Select *p){
    if( p->pPrior ){
      Select *pNext = 0, *pLoop;
      int mxSelect, cnt = 0;
      for(pLoop=p; pLoop; pNext=pLoop, pLoop=pLoop->pPrior, cnt++){
        pLoop->pNext = pNext;
        pLoop->selFlags |= SF_Compound;
      }
      if((p->selFlags & SF_MultiValue) == 0 &&
         (mxSelect = sql_get()->aLimit[SQL_LIMIT_COMPOUND_SELECT]) > 0 &&
         cnt > mxSelect) {
          diag_set(ClientError, ER_SQL_PARSER_LIMIT, "The number of UNION or "\
                   "EXCEPT or INTERSECT operations", cnt,
                   sql_get()->aLimit[SQL_LIMIT_COMPOUND_SELECT]);
         pParse->is_aborted = true;
      }
    }
  }
#line 889 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  /* This is a utility routine used to set the ExprSpan.zStart and
  ** ExprSpan.zEnd values of pOut so that the span covers the complete
  ** range of text beginning with pStart and going to the end of pEnd.
  */
  static void spanSet(ExprSpan *pOut, Token *pStart, Token *pEnd){
    pOut->zStart = pStart->z;
    pOut->zEnd = &pEnd->z[pEnd->n];
  }

  /* Construct a new Expr object from a single identifier.  Use the
  ** new Expr to populate pOut.  Set the span of pOut to be the identifier
  ** that created the expression.
  */
  static void spanExpr(struct ExprSpan *pOut, int op, Token t){
    struct Expr *p = NULL;
    int name_sz = t.n + 1;
    p = sql_xmalloc(sizeof(Expr) + name_sz);
    memset(p, 0, sizeof(Expr));
    switch (op) {
    case TK_STRING:
      p->type = FIELD_TYPE_STRING;
      break;
    case TK_BLOB:
      p->type = FIELD_TYPE_VARBINARY;
      break;
    case TK_INTEGER:
      p->type = FIELD_TYPE_INTEGER;
      break;
    case TK_FLOAT:
      p->type = FIELD_TYPE_DOUBLE;
      break;
    case TK_DECIMAL:
      p->type = FIELD_TYPE_DECIMAL;
      break;
    case TK_TRUE:
    case TK_FALSE:
    case TK_UNKNOWN:
      p->type = FIELD_TYPE_BOOLEAN;
      break;
    default:
      p->type = FIELD_TYPE_SCALAR;
      break;
    }
    p->op = (u8)op;
    p->flags = EP_Leaf;
    p->iAgg = -1;
    p->u.zToken = (char*)&p[1];
    int rc = sql_normalize_name(p->u.zToken, name_sz, t.z, t.n);
    if (rc > name_sz) {
      name_sz = rc;
      p = sql_xrealloc(p, sizeof(*p) + name_sz);
      p->u.zToken = (char *)&p[1];
      sql_normalize_name(p->u.zToken, name_sz, t.z, t.n);
    }
#if SQL_MAX_EXPR_DEPTH>0
    p->nHeight = 1;
#endif  
    pOut->pExpr = p;
    pOut->zStart = t.z;
    pOut->zEnd = &t.z[t.n];
    return;
  }
#line 1153 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  /* This routine constructs a binary expression node out of two ExprSpan
  ** objects and uses the result to populate a new ExprSpan object.
  */
  static void spanBinaryExpr(
    Parse *pParse,      /* The parsing context.  Errors accumulate here */
    int op,             /* The binary operation */
    ExprSpan *pLeft,    /* The left operand, and output */
    ExprSpan *pRight    /* The right operand */
  ){
    pLeft->pExpr = sqlPExpr(pParse, op, pLeft->pExpr, pRight->pExpr);
    pLeft->zEnd = pRight->zEnd;
  }

  /* If doNot is true, then add a TK_NOT Expr-node wrapper around the
  ** outside of *ppExpr.
  */
  static void exprNot(Parse *pParse, int doNot, ExprSpan *pSpan){
    if( doNot ){
      pSpan->pExpr = sqlPExpr(pParse, TK_NOT, pSpan->pExpr, 0);
    }
  }
#line 1227 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  /* Construct an expression node for a unary postfix operator
  */
  static void spanUnaryPostfix(
    Parse *pParse,         /* Parsing context to record errors */
    int op,                /* The operator */
    ExprSpan *pOperand,    /* The operand, and output */
    Token *pPostOp         /* The operand token for setting the span */
  ){
    pOperand->pExpr = sqlPExpr(pParse, op, pOperand->pExpr, 0);
    pOperand->zEnd = &pPostOp->z[pPostOp->n];
  }                           
#line 1248 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  /* Construct an expression node for a unary prefix operator
  */
  static void spanUnaryPrefix(
    ExprSpan *pOut,        /* Write the new expression node here */
    Parse *pParse,         /* Parsing context to record errors */
    int op,                /* The operator */
    ExprSpan *pOperand,    /* The operand */
    Token *pPreOp         /* The operand token for setting the span */
  ){
    pOut->zStart = pPreOp->z;
    pOut->pExpr = sqlPExpr(pParse, op, pOperand->pExpr, 0);
    pOut->zEnd = pOperand->zEnd;
  }
#line 1439 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  /* Add a single new term to an ExprList that is used to store a
  ** list of identifiers.  Report an error if the ID list contains
  ** a COLLATE clause or an ASC or DESC keyword, except ignore the
  ** error while parsing a legacy schema.
  */
  static ExprList *parserAddExprIdListTerm(
    Parse *pParse,
    ExprList *pPrior,
    Token *pIdToken
  ){
    ExprList *p = sql_expr_list_append(pPrior, NULL);
    sqlExprListSetName(pParse, p, pIdToken, 1);
    return p;
  }
#line 1649 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  struct alter_args {
    struct SrcList *table_name;
    /** Name of constraint OR new name of table in case of RENAME. */
    struct Token name;
  };
#line 244 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    sqlParserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is sqlParserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_MIN_REDUCE      Maximum value for reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 273
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 77
#define sqlParserTOKENTYPE Token
typedef union {
  int yyinit;
  sqlParserTOKENTYPE yy0;
  int yy60;
  struct SrcList * yy184;
  ExprList * yy190;
  struct LimitVal yy212;
  ExprSpan yy214;
  struct ExprList * yy215;
  With* yy227;
  TriggerStep* yy251;
  IdList* yy272;
  SrcList* yy291;
  enum trim_side_mask yy301;
  Select* yy331;
  struct type_def yy338;
  Expr* yy386;
  struct alter_args yy394;
  ExprList* yy402;
  struct TrigEvent yy403;
  struct Expr * yy407;
  struct Token yy487;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlParserARG_SDECL Parse *pParse;
#define sqlParserARG_PDECL ,Parse *pParse
#define sqlParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlParserARG_STORE yypParser->pParse = pParse
#define YYFALLBACK 1
#define YYNSTATE             440
#define YYNRULE              309
#define YY_MAX_SHIFT         439
#define YY_MIN_SHIFTREDUCE   648
#define YY_MAX_SHIFTREDUCE   956
#define YY_MIN_REDUCE        957
#define YY_MAX_REDUCE        1265
#define YY_ERROR_ACTION      1266
#define YY_ACCEPT_ACTION     1267
#define YY_NO_ACTION         1268
/************* End control #defines *******************************************/

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if:
**    (1)  The yy_shift_ofst[S]+X value is out of range, or
**    (2)  yy_lookahead[yy_shift_ofst[S]+X] is not equal to X, or
**    (3)  yy_shift_ofst[S] equal YY_SHIFT_USE_DFLT.
** (Implementation note: YY_SHIFT_USE_DFLT is chosen so that
** YY_SHIFT_USE_DFLT+X will be out of range for all possible lookaheads X.
** Hence only tests (1) and (2) need to be evaluated.)
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1777)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    59,   70,   70,   70,   70,   69,   69,   68,   68,   68,
 /*    10 */    67,  317,  149,   21,  166,  438,  438,   56,   57,  290,
 /*    20 */   666,  666,  740,  146,   58,   10,  777,   69,   69,   68,
 /*    30 */    68,   68,   67,  317,  854,   21,  423,    3,  317,  140,
 /*    40 */    21,  777,  433,  318,  318,  864,  319,  863,  319,  176,
 /*    50 */   697,  294,  893,   81,  710,  343,  297,  892,  772,  302,
 /*    60 */   116,  116,  412,   68,   68,   68,   67,  317,  359,   21,
 /*    70 */    66,   64,  201,  772,   66,   64,  201,  379,   72,   72,
 /*    80 */    72,   72,   65,   70,   70,   70,   70,   69,   69,   68,
 /*    90 */    68,   68,   67,  317,  774,   21,  776,  776,  778,  779,
 /*   100 */   780,  781,  782,  303,  187,  139,  770,  293,   21,  279,
 /*   110 */   425,  776,  776,  778,  779,  780,  781,  782,  783,  300,
 /*   120 */   300,  431,   59,    9,  353,  426,  803,  804,  805,  950,
 /*   130 */    20,  893,  140,  377,  681,  433,  945,  739,  945,   56,
 /*   140 */    57,  934,  180,  707,  294,  890,   58,   10,  706,  297,
 /*   150 */   433,  218,  254,  119,  119,   59,  312,  707,  423,    3,
 /*   160 */  1152,  149,  706,  777,  344,  318,  318,  402,   96,   96,
 /*   170 */   135, 1246,   56,   57,  881, 1246,  742,  135,  233,   58,
 /*   180 */    10,  407,  403,  213,  412,   66,   64,  201,  280,  433,
 /*   190 */   389,  423,    3,  135,  149,  772,  777,  353,  318,  318,
 /*   200 */   669,  253,  351,  425,  243,  183,  269,   95,   95,  188,
 /*   210 */   235, 1246,  763,  405,  404,  135,  774,  412,  425,   82,
 /*   220 */   666,  666,  666,  666,  349,  649,  321,  741,  772,  856,
 /*   230 */    66,   64,  201,  776,  776,  778,  779,  780,  781,  782,
 /*   240 */   783,  300,  300,  431,  388,    9,  433,  426,  207,  774,
 /*   250 */   243,  950,   20,  252,  406,   26,  219,  425,  251, 1267,
 /*   260 */   439,    1,   24,   24,   92,   92,  776,  776,  778,  779,
 /*   270 */   780,  781,  782,  783,  300,  300,  431,  672,    9,  421,
 /*   280 */   426,   66,   64,  201,  950,   20,   73,   74,  299,  316,
 /*   290 */   818,  818,  828,  831,   71,   71,   72,   72,   72,   72,
 /*   300 */    59,   70,   70,   70,   70,   69,   69,   68,   68,   68,
 /*   310 */    67,  317,  425,   21,  425,  202,  202,   56,   57,  711,
 /*   320 */   989,  433,  206,  391,   58,   10,  377,  387,  433,  945,
 /*   330 */   770,  945,  383,   59,  702,  702,  423,    3,  766,   85,
 /*   340 */    85,  777,  338,  318,  318,  671,   98,   98,  955,  312,
 /*   350 */    56,   57,  665,  939,  298,    6,  712,   58,   10,  945,
 /*   360 */   149,  945,  412,  242,  384,  323,   59,  392,  433,  423,
 /*   370 */     3,  233,  867,  772,  777,  345,  318,  318,  867,  340,
 /*   380 */   666,  666,  249,   56,   57,  261,   41,   41,  305,  425,
 /*   390 */    58,   10,  301,  337,  774,  412,  425,  243,  183,  269,
 /*   400 */   725,  233,  423,    3,  681,  879,  772,  777,  135,  318,
 /*   410 */   318,  776,  776,  778,  779,  780,  781,  782,  783,  300,
 /*   420 */   300,  431,  433,    9,  433,  426,   48,  774,  412,  950,
 /*   430 */    20,  330,  322,  897,  324,  696,  425,  327,  135,  772,
 /*   440 */   119,  119,  119,  119,  776,  776,  778,  779,  780,  781,
 /*   450 */   782,  783,  300,  300,  431,  433,    9,  725,  426,  719,
 /*   460 */   774,  699,  950,   20,  376,  676,  375,  228,  407,  385,
 /*   470 */   407,  390,  387,   99,   99,  242,  384,  776,  776,  778,
 /*   480 */   779,  780,  781,  782,  783,  300,  300,  431,  755,    9,
 /*   490 */   425,  426,  425,  939,  298,  950,   20,   73,   74,  299,
 /*   500 */   316,  818,  818,  828,  831,   71,   71,   72,   72,   72,
 /*   510 */    72,  232,   70,   70,   70,   70,   69,   69,   68,   68,
 /*   520 */    68,   67,  317,  425,   21,   73,   74,  299,  316,  818,
 /*   530 */   818,  828,  831,   71,   71,   72,   72,   72,   72,  394,
 /*   540 */    70,   70,   70,   70,   69,   69,   68,   68,   68,   67,
 /*   550 */   317,  359,   21,  689,  689,   73,   74,  299,  316,  818,
 /*   560 */   818,  828,  831,   71,   71,   72,   72,   72,   72,   44,
 /*   570 */    70,   70,   70,   70,   69,   69,   68,   68,   68,   67,
 /*   580 */   317,  198,   21,  687,  687,  726,  364,  361,   75,  946,
 /*   590 */   946,  374,  372,  371,  946,  946,  370,  664,  743,  744,
 /*   600 */   819,  819,  829,  832,   73,   74,  299,  316,  818,  818,
 /*   610 */   828,  831,   71,   71,   72,   72,   72,   72,  149,   70,
 /*   620 */    70,   70,   70,   69,   69,   68,   68,   68,   67,  317,
 /*   630 */   770,   21,  149,  861,  259,  681,  770,  191,  726,  190,
 /*   640 */   947,  728,  766,  430,  895,  947,  727,   66,   64,  201,
 /*   650 */    73,   74,  299,  316,  818,  818,  828,  831,   71,   71,
 /*   660 */    72,   72,   72,   72,  725,   70,   70,   70,   70,   69,
 /*   670 */    69,   68,   68,   68,   67,  317,  664,   21,  726,  202,
 /*   680 */   202, 1210, 1210,  350,   67,  317,  260,   21,  306,  261,
 /*   690 */   684,  387,  666,  666,  307,  248,   73,   74,  299,  316,
 /*   700 */   818,  818,  828,  831,   71,   71,   72,   72,   72,   72,
 /*   710 */   433,   70,   70,   70,   70,   69,   69,   68,   68,   68,
 /*   720 */    67,  317,  430,   21,  666,  666,  167,  357,   41,   41,
 /*   730 */   191,  726,  666,  666,  308,  280,  677,  725,  410,  359,
 /*   740 */   784,  784,   73,   74,  299,  316,  818,  818,  828,  831,
 /*   750 */    71,   71,   72,   72,   72,   72,  433,   70,   70,   70,
 /*   760 */    70,   69,   69,   68,   68,   68,   67,  317,  214,   21,
 /*   770 */     2,  358,  770,  348,   41,   41,  666,  666,  425,  936,
 /*   780 */   310,  414,  670,  665,  135,  725,  725,  725,   73,   74,
 /*   790 */   299,  316,  818,  818,  828,  831,   71,   71,   72,   72,
 /*   800 */    72,   72,  433,   70,   70,   70,   70,   69,   69,   68,
 /*   810 */    68,   68,   67,  317,  785,   21,  215,  887,  855,  935,
 /*   820 */    78,   78,  221,  665,  425,  311,  417,  171,  809,  725,
 /*   830 */   314,  725,  725,  432,   73,   74,  299,  316,  818,  818,
 /*   840 */   828,  831,   71,   71,   72,   72,   72,   72,  854,   70,
 /*   850 */    70,   70,   70,   69,   69,   68,   68,   68,   67,  317,
 /*   860 */   693,   21,  692,  256,  200,  235,  418,   83,  422,  135,
 /*   870 */   425,  135,  193,  309,  771,  743,  744,  679,  679,  355,
 /*   880 */    73,   74,  299,  316,  818,  818,  828,  831,   71,   71,
 /*   890 */    72,   72,   72,   72,  775,   70,   70,   70,   70,   69,
 /*   900 */    69,   68,   68,   68,   67,  317,  822,   21,   73,   74,
 /*   910 */   299,  316,  818,  818,  828,  831,   71,   71,   72,   72,
 /*   920 */    72,   72,  715,   70,   70,   70,   70,   69,   69,   68,
 /*   930 */    68,   68,   67,  317,  195,   21,   73,   74,  299,  316,
 /*   940 */   818,  818,  828,  831,   71,   71,   72,   72,   72,   72,
 /*   950 */   271,   70,   70,   70,   70,   69,   69,   68,   68,   68,
 /*   960 */    67,  317,  273,   21,   73,   74,  299,  316,  818,  818,
 /*   970 */   828,  831,   71,   71,   72,   72,   72,   72,  884,   70,
 /*   980 */    70,   70,   70,   69,   69,   68,   68,   68,   67,  317,
 /*   990 */    55,   21,   53,  896,  885,  325,  854,   43,   39,  237,
 /*  1000 */   275,   46,  912,   49,  886,  411,  278,   73,   74,  299,
 /*  1010 */   316,  818,  818,  828,  831,   71,   71,   72,   72,   72,
 /*  1020 */    72,  315,   70,   70,   70,   70,   69,   69,   68,   68,
 /*  1030 */    68,   67,  317,  173,   21,   73,   74,  299,  316,  818,
 /*  1040 */   818,  828,  831,   71,   71,   72,   72,   72,   72,  924,
 /*  1050 */    70,   70,   70,   70,   69,   69,   68,   68,   68,   67,
 /*  1060 */   317,  241,   21,   11,  768,  352,  247,  944,  231,  231,
 /*  1070 */    51,   25,  354,  899,  848,  891,  231,  858,   43,  145,
 /*  1080 */   906,  907,  908,  909,  910,  911,  913,  914,  915,  916,
 /*  1090 */   917,  282,  920,  921,  922,  922,  923,  328,   54,  368,
 /*  1100 */   786,  786,   60,  237,   73,   74,  299,  316,  818,  818,
 /*  1110 */   828,  831,   71,   71,   72,   72,   72,   72,  181,   70,
 /*  1120 */    70,   70,   70,   69,   69,   68,   68,   68,   67,  317,
 /*  1130 */   209,   21,  299,  316,  818,  818,  828,  831,   71,   71,
 /*  1140 */    72,   72,   72,   72,  889,   70,   70,   70,   70,   69,
 /*  1150 */    69,   68,   68,   68,   67,  317,   61,   21,   72,   72,
 /*  1160 */    72,   72,  900,   70,   70,   70,   70,   69,   69,   68,
 /*  1170 */    68,   68,   67,  317,  332,   21,  683,  682,  704,  735,
 /*  1180 */    43,   35,   50,  231,  852,  304,  931,  333,  237,  141,
 /*  1190 */    23,  334,  758,  339,  250,   73,   74,  299,  316,  818,
 /*  1200 */   818,  828,  831,   71,   71,   72,   72,   72,   72,  341,
 /*  1210 */    70,   70,   70,   70,   69,   69,   68,   68,   68,   67,
 /*  1220 */   317,  194,   21,   73,   63,  299,  316,  818,  818,  828,
 /*  1230 */   831,   71,   71,   72,   72,   72,   72,  258,   70,   70,
 /*  1240 */    70,   70,   69,   69,   68,   68,   68,   67,  317,  876,
 /*  1250 */    21,   74,  299,  316,  818,  818,  828,  831,   71,   71,
 /*  1260 */    72,   72,   72,   72,  878,   70,   70,   70,   70,   69,
 /*  1270 */    69,   68,   68,   68,   67,  317,  437,   21,  653,  436,
 /*  1280 */   245,  291,  186,  185,  659,  356,  433,  875,  362,  149,
 /*  1290 */   363,  433,  263,  433,  265,  433,  203,  658,  433,  266,
 /*  1300 */   267,  433,   77,  149,   90,   90,  777,  433,  733,  119,
 /*  1310 */   119,  119,  119,  119,  119,  675,  119,  119,  381,  119,
 /*  1320 */   119,  135,  769,  277,  713,  119,  119,  766,  189,  234,
 /*  1330 */   413,  296,  382,  433,  853,  281,  849,  313,  772,  407,
 /*  1340 */   401,  407,  424,  264,  407,  427,  433,  407,  380,  667,
 /*  1350 */   975,   41,   41,  395,  425,  336,  656,  397,  335,  425,
 /*  1360 */     8,  425,  182,  425,  121,  121,  425,  655,  350,  425,
 /*  1370 */   287,  260,  657,  172,  261,  425,  776,  776,  778,  779,
 /*  1380 */   780,  781,  782,  884,  433,  894,  211,   28,  164,  143,
 /*  1390 */   153,  155,  754,  433,  331,  342,   39,  433,   29,  885,
 /*  1400 */   257,  425,  100,  100,  433,  157,  433,  216,  400,  886,
 /*  1410 */   690,  101,  101,  433,  425,  102,  102,  691,  433,  159,
 /*  1420 */   433,  160,  103,  103,   86,   86,  433,  367,  862,  433,
 /*  1430 */   255,   79,   79,  347,  217,  880,   87,   87,   89,   89,
 /*  1440 */   433,  174,  168,  765,  104,  104,  365,  105,  105,  433,
 /*  1450 */   224,  433,  425,  225,  226,  685,  678,  433,  106,  106,
 /*  1460 */   433,  425,  378,  674,  393,  425,  673,   42,   42,  107,
 /*  1470 */   107,    7,  425,  723,  425,  108,  108,  433,  109,  109,
 /*  1480 */   433,  425,  433,   38,  433,  236,  425,  724,  425,   52,
 /*  1490 */   416,  433,  270,  433,  425,   91,   91,  425,  110,  110,
 /*  1500 */   111,  111,  112,  112,  433,  272,  429,  274,  425,  113,
 /*  1510 */   113,   93,   93,  836,  722,  721,  433,  425,  433,  425,
 /*  1520 */   433,  276,  114,  114,  433,  425,   76,  420,  425,  703,
 /*  1530 */   398,  919,  283,  285,  115,  115,   94,   94,  136,  136,
 /*  1540 */    40,  284,  137,  137,  433,  425,  286,  433,  425,  396,
 /*  1550 */   425,  435,  425,  932,  288,  433,   12,  433,  289,  425,
 /*  1560 */   433,  425,  138,  138,  295,  124,  124,  928,  244,  246,
 /*  1570 */   930,   80,  425,  117,  117,  118,  118,  142,   97,   97,
 /*  1580 */   433,  651,  433,  320,  425,  433,  425,  433,  425,  433,
 /*  1590 */   898,  433,  425,   13,   27,  433,  150,  204,  127,  127,
 /*  1600 */   120,  120,  433,  128,  128,  126,  126,  134,  134,  133,
 /*  1610 */   133,  433,  425,  132,  132,  425,  433,  205,  433,  208,
 /*  1620 */   131,  131,  326,  425,  433,  425,  433,  329,  425,  129,
 /*  1630 */   129,  151,  859,  210,  130,  130,  123,  123,  184,  212,
 /*  1640 */   152,  764,  125,  125,  122,  122,  433,  154,  425,  433,
 /*  1650 */   425,  147,  158,  425,  156,  425,  694,  425,  865,  425,
 /*  1660 */   231,  161,  162,  425,   84,   84,  952,   88,   88,  881,
 /*  1670 */   425,  346,  135,  874,  163,  165,   30,   31,   32,  425,
 /*  1680 */    33,  148,  877,  222,  425,  220,  425,  873,   22,   14,
 /*  1690 */   223,  175,  425,  661,  425,  366,  227,  351,  262,  169,
 /*  1700 */   369,   34,   15,   16,  373,   36,  229,  268,  144,   37,
 /*  1710 */   808,  701,  806,  834,  425,   17,  196,  425,  705,  360,
 /*  1720 */     5,  734,  197,  386,  199,  230,  170,  729,   45,   50,
 /*  1730 */    43,   18,   19,  399,  847,  835,  833,  792,  796,  883,
 /*  1740 */   428,   47,  192,  408,  882,  838,  409,  904,  177,  238,
 /*  1750 */   905,  178,  791,  837,  179,  434,  807,  239,    4,  415,
 /*  1760 */   918,  787,   62,  823,  292,  419,  652,  662,  648, 1234,
 /*  1770 */   959,  959,  959,  959,  959,  959,  240,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     7,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*    10 */    29,   30,   46,   32,   44,  175,  176,   24,   25,  179,
 /*    20 */    50,   51,  199,  183,   31,   32,   48,   24,   25,   26,
 /*    30 */    27,   28,   29,   30,  178,   32,   43,   44,   30,  178,
 /*    40 */    32,   48,  178,   50,   51,   55,  185,   57,  187,  188,
 /*    50 */   210,  190,  192,  213,  227,   65,  195,  178,   80,  203,
 /*    60 */   196,  197,   69,   26,   27,   28,   29,   30,  178,   32,
 /*    70 */   247,  248,  249,   80,  247,  248,  249,   26,   15,   16,
 /*    80 */    17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
 /*    90 */    27,   28,   29,   30,  101,   32,  118,  119,  120,  121,
 /*   100 */   122,  123,  124,  263,  264,  265,  178,  267,   32,  245,
 /*   110 */   246,  118,  119,  120,  121,  122,  123,  124,  125,  126,
 /*   120 */   127,  128,    7,  130,  178,  132,  133,  134,  135,  136,
 /*   130 */   137,  271,  178,    7,   85,  178,   48,  199,   50,   24,
 /*   140 */    25,  187,  188,   92,  190,  266,   31,   32,   97,  195,
 /*   150 */   178,  261,   40,  196,  197,    7,   30,   92,   43,   44,
 /*   160 */    45,   46,   97,   48,  236,   50,   51,  210,  196,  197,
 /*   170 */   213,   45,   24,   25,  210,   49,  193,  213,   90,   31,
 /*   180 */    32,  224,  225,  237,   69,  247,  248,  249,  178,  178,
 /*   190 */   210,   43,   44,  213,   46,   80,   48,  178,   50,   51,
 /*   200 */   196,   89,  238,  246,   78,   79,   80,  196,  197,  229,
 /*   210 */   230,   85,  210,  241,  242,  213,  101,   69,  246,  255,
 /*   220 */    50,   51,   50,   51,  260,    1,    2,  193,   80,  196,
 /*   230 */   247,  248,  249,  118,  119,  120,  121,  122,  123,  124,
 /*   240 */   125,  126,  127,  128,  178,  130,  178,  132,   78,  101,
 /*   250 */    78,  136,  137,  141,  243,  244,  237,  246,  146,  172,
 /*   260 */   173,  174,  196,  197,  196,  197,  118,  119,  120,  121,
 /*   270 */   122,  123,  124,  125,  126,  127,  128,  196,  130,  269,
 /*   280 */   132,  247,  248,  249,  136,  137,    5,    6,    7,    8,
 /*   290 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   300 */     7,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   310 */    29,   30,  246,   32,  246,  211,  212,   24,   25,   26,
 /*   320 */     1,  178,  152,    7,   31,   32,    7,  223,  178,   48,
 /*   330 */   178,   50,   91,    7,   93,   94,   43,   44,   70,  196,
 /*   340 */   197,   48,  238,   50,   51,  196,  196,  197,  189,   30,
 /*   350 */    24,   25,  193,  194,  195,   44,   26,   31,   32,   48,
 /*   360 */    46,   50,   69,   95,   96,  268,    7,   51,  178,   43,
 /*   370 */    44,   90,  111,   80,   48,  114,   50,   51,  117,  111,
 /*   380 */    50,   51,  114,   24,   25,  117,  196,  197,  236,  246,
 /*   390 */    31,   32,  202,   79,  101,   69,  246,   78,   79,   80,
 /*   400 */   178,   90,   43,   44,   85,  210,   80,   48,  213,   50,
 /*   410 */    51,  118,  119,  120,  121,  122,  123,  124,  125,  126,
 /*   420 */   127,  128,  178,  130,  178,  132,  100,  101,   69,  136,
 /*   430 */   137,  209,   81,   82,   83,  210,  246,   86,  213,   80,
 /*   440 */   196,  197,  196,  197,  118,  119,  120,  121,  122,  123,
 /*   450 */   124,  125,  126,  127,  128,  178,  130,  178,  132,  231,
 /*   460 */   101,  212,  136,  137,   81,   82,   83,   84,  224,  225,
 /*   470 */   224,  225,  223,  196,  197,   95,   96,  118,  119,  120,
 /*   480 */   121,  122,  123,  124,  125,  126,  127,  128,  209,  130,
 /*   490 */   246,  132,  246,  194,  195,  136,  137,    5,    6,    7,
 /*   500 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   510 */    18,  227,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   520 */    28,   29,   30,  246,   32,    5,    6,    7,    8,    9,
 /*   530 */    10,   11,   12,   13,   14,   15,   16,   17,   18,  235,
 /*   540 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   550 */    30,  178,   32,  206,  207,    5,    6,    7,    8,    9,
 /*   560 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   49,
 /*   570 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   580 */    30,   45,   32,  206,  207,   49,  253,  254,   68,   50,
 /*   590 */    51,   81,   82,   83,   50,   51,   86,  192,  106,  107,
 /*   600 */     9,   10,   11,   12,    5,    6,    7,    8,    9,   10,
 /*   610 */    11,   12,   13,   14,   15,   16,   17,   18,   46,   20,
 /*   620 */    21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
 /*   630 */   178,   32,   46,   61,  261,   85,  178,  101,  102,  235,
 /*   640 */   101,  102,   70,  192,   45,  101,  102,  247,  248,  249,
 /*   650 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   660 */    15,   16,   17,   18,  178,   20,   21,   22,   23,   24,
 /*   670 */    25,   26,   27,   28,   29,   30,  271,   32,   49,  211,
 /*   680 */   212,   95,   96,  111,   29,   30,  114,   32,  236,  117,
 /*   690 */    45,  223,   50,   51,  236,  209,    5,    6,    7,    8,
 /*   700 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   710 */   178,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   720 */    29,   30,  271,   32,   50,   51,   44,    7,  196,  197,
 /*   730 */   101,  102,   50,   51,  202,  178,   45,  178,  207,  178,
 /*   740 */    50,   51,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   750 */    13,   14,   15,   16,   17,   18,  178,   20,   21,   22,
 /*   760 */    23,   24,   25,   26,   27,   28,   29,   30,  209,   32,
 /*   770 */    44,   51,  178,  257,  196,  197,   50,   51,  246,  189,
 /*   780 */   202,  210,   45,  193,  213,  178,  178,  178,    5,    6,
 /*   790 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   800 */    17,   18,  178,   20,   21,   22,   23,   24,   25,   26,
 /*   810 */    27,   28,   29,   30,  124,   32,  209,  209,  209,  189,
 /*   820 */   196,  197,  261,  193,  246,  201,  269,  153,   45,  178,
 /*   830 */   236,  178,  178,    7,    5,    6,    7,    8,    9,   10,
 /*   840 */    11,   12,   13,   14,   15,   16,   17,   18,  178,   20,
 /*   850 */    21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
 /*   860 */   209,   32,  209,  209,  229,  230,  210,   44,  210,  213,
 /*   870 */   246,  213,  256,  203,   45,  106,  107,   50,   51,  178,
 /*   880 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   890 */    15,   16,   17,   18,  178,   20,   21,   22,   23,   24,
 /*   900 */    25,   26,   27,   28,   29,   30,   80,   32,    5,    6,
 /*   910 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   920 */    17,   18,   99,   20,   21,   22,   23,   24,   25,   26,
 /*   930 */    27,   28,   29,   30,   49,   32,    5,    6,    7,    8,
 /*   940 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   950 */   227,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   960 */    29,   30,  227,   32,    5,    6,    7,    8,    9,   10,
 /*   970 */    11,   12,   13,   14,   15,   16,   17,   18,   36,   20,
 /*   980 */    21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
 /*   990 */   138,   32,  140,   45,   52,   45,  178,   49,  113,   49,
 /*  1000 */   227,  126,   76,  100,   62,   63,  178,    5,    6,    7,
 /*  1010 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*  1020 */    18,  203,   20,   21,   22,   23,   24,   25,   26,   27,
 /*  1030 */    28,   29,   30,  214,   32,    5,    6,    7,    8,    9,
 /*  1040 */    10,   11,   12,   13,   14,   15,   16,   17,   18,  123,
 /*  1050 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*  1060 */    30,  216,   32,  215,   45,   45,  178,   49,   49,   49,
 /*  1070 */   139,  226,   45,  178,   45,  178,   49,   45,   49,   54,
 /*  1080 */   154,  155,  156,  157,  158,  159,  160,  161,  162,  163,
 /*  1090 */   164,  165,  166,  167,  168,  169,  170,   72,  139,   45,
 /*  1100 */    50,   51,  100,   49,    5,    6,    7,    8,    9,   10,
 /*  1110 */    11,   12,   13,   14,   15,   16,   17,   18,  100,   20,
 /*  1120 */    21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
 /*  1130 */    98,   32,    7,    8,    9,   10,   11,   12,   13,   14,
 /*  1140 */    15,   16,   17,   18,  178,   20,   21,   22,   23,   24,
 /*  1150 */    25,   26,   27,   28,   29,   30,  126,   32,   15,   16,
 /*  1160 */    17,   18,  178,   20,   21,   22,   23,   24,   25,   26,
 /*  1170 */    27,   28,   29,   30,  178,   32,   45,   45,   45,   45,
 /*  1180 */    49,   49,   49,   49,   45,  178,   45,  178,   49,   90,
 /*  1190 */    49,  178,  218,  232,  232,    5,    6,    7,    8,    9,
 /*  1200 */    10,   11,   12,   13,   14,   15,   16,   17,   18,  178,
 /*  1210 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*  1220 */    30,  178,   32,    5,    6,    7,    8,    9,   10,   11,
 /*  1230 */    12,   13,   14,   15,   16,   17,   18,  262,   20,   21,
 /*  1240 */    22,   23,   24,   25,   26,   27,   28,   29,   30,  178,
 /*  1250 */    32,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*  1260 */    15,   16,   17,   18,  218,   20,   21,   22,   23,   24,
 /*  1270 */    25,   26,   27,   28,   29,   30,   33,   32,   35,   36,
 /*  1280 */    37,   38,   24,   25,   41,  262,  178,  178,  178,   46,
 /*  1290 */   178,  178,  178,  178,   40,  178,   44,  178,  178,  178,
 /*  1300 */   178,  178,   44,   46,  196,  197,   48,  178,  178,  196,
 /*  1310 */   197,  196,  197,  196,  197,  199,  196,  197,  210,  196,
 /*  1320 */   197,  213,  178,  232,  178,  196,  197,   70,  178,  228,
 /*  1330 */   252,   88,  224,  178,  178,  178,   82,  224,   80,  224,
 /*  1340 */   225,  224,  225,   89,  224,  225,  178,  224,  225,  178,
 /*  1350 */    98,  196,  197,  224,  246,  112,  178,  202,  115,  246,
 /*  1360 */   215,  246,  215,  246,  196,  197,  246,  178,  111,  246,
 /*  1370 */   217,  114,  178,   44,  117,  246,  118,  119,  120,  121,
 /*  1380 */   122,  123,  124,   36,  178,  200,  143,  144,   44,    5,
 /*  1390 */   239,  205,  218,  178,  151,   42,  113,  178,  138,   52,
 /*  1400 */   146,  246,  196,  197,  178,  208,  178,  208,  240,   62,
 /*  1410 */    63,  196,  197,  178,  246,  196,  197,   70,  178,  208,
 /*  1420 */   178,  208,  196,  197,  196,  197,  178,   42,  259,  178,
 /*  1430 */   258,  196,  197,  148,  184,  218,  196,  197,  196,  197,
 /*  1440 */   178,  239,  205,  205,  196,  197,  200,  196,  197,  178,
 /*  1450 */   184,  178,  246,  184,  184,  200,  200,  178,  196,  197,
 /*  1460 */   178,  246,   87,  198,  104,  246,  198,  196,  197,  196,
 /*  1470 */   197,   44,  246,  234,  246,  196,  197,  178,  196,  197,
 /*  1480 */   178,  246,  178,   87,  178,  251,  246,  234,  246,  138,
 /*  1490 */   200,  178,  233,  178,  246,  196,  197,  246,  196,  197,
 /*  1500 */   196,  197,  196,  197,  178,  233,   44,  233,  246,  196,
 /*  1510 */   197,  196,  197,  250,  234,  234,  178,  246,  178,  246,
 /*  1520 */   178,  233,  196,  197,  178,  246,  110,  200,  246,  222,
 /*  1530 */   105,  270,  221,  219,  196,  197,  196,  197,  196,  197,
 /*  1540 */   109,  220,  196,  197,  178,  246,  218,  178,  246,  108,
 /*  1550 */   246,   47,  246,  186,   46,  178,   44,  178,  180,  246,
 /*  1560 */   178,  246,  196,  197,  181,  196,  197,   37,  177,  177,
 /*  1570 */   182,  191,  246,  196,  197,  196,  197,  191,  196,  197,
 /*  1580 */   178,    4,  178,    3,  246,  178,  246,  178,  246,  178,
 /*  1590 */    67,  178,  246,   44,   44,  178,   44,   84,  196,  197,
 /*  1600 */   196,  197,  178,  196,  197,  196,  197,  196,  197,  196,
 /*  1610 */   197,  178,  246,  196,  197,  246,  178,   39,  178,   78,
 /*  1620 */   196,  197,   67,  246,  178,  246,  178,   88,  246,  196,
 /*  1630 */   197,   40,   45,   44,  196,  197,  196,  197,   14,  142,
 /*  1640 */    40,   96,  196,  197,  196,  197,  178,  116,  246,  178,
 /*  1650 */   246,  115,   87,  246,  100,  246,   43,  246,  147,  246,
 /*  1660 */    49,  147,   87,  246,  196,  197,  150,  196,  197,  210,
 /*  1670 */   246,  149,  213,    1,  100,  116,   14,   14,   14,  246,
 /*  1680 */    14,  115,   51,   98,  246,  103,  246,    1,  145,   44,
 /*  1690 */    87,   90,  246,   43,  246,    7,   84,  238,  141,   44,
 /*  1700 */    67,   44,   44,   44,   67,   44,   67,   80,   59,   49,
 /*  1710 */    45,   92,   45,   45,  246,   44,   98,  246,   45,  260,
 /*  1720 */    44,   51,   45,   49,   45,  103,   44,  102,   32,   49,
 /*  1730 */    49,  103,  103,  129,   45,   45,   45,  131,   45,   45,
 /*  1740 */   124,   49,   44,   48,   45,   61,   49,   45,   44,   49,
 /*  1750 */    45,   44,  129,   45,   44,   14,   45,   44,   44,   90,
 /*  1760 */    45,   45,   44,   80,   39,   90,   34,   48,    1,    0,
 /*  1770 */   272,  272,  272,  272,  272,  272,   98,
};
#define YY_SHIFT_USE_DFLT (1777)
#define YY_SHIFT_COUNT    (439)
#define YY_SHIFT_MIN      (-34)
#define YY_SHIFT_MAX      (1769)
static const short yy_shift_ofst[] = {
 /*     0 */   224, 1243,  115,  148,   -7,  359,  359,  359,  359,  359,
 /*    10 */   359,  359,  172,  359,  359,  359,  359,  359,  359,  359,
 /*    20 */   359,  359, 1257,  172,  281,  293,  326,  359,  359,  359,
 /*    30 */   359,  359,  359,  359,  359,  359,  359,  359,  359,  359,
 /*    40 */   359,  492,  492,  359,  359,  359,  359,  359,  359,  359,
 /*    50 */   359,  359,  359,  359,  359,  359,  359,  359,  359,  359,
 /*    60 */   359,  359,  359,  359,  359,  359,  359,  359,  359,  359,
 /*    70 */   359,  359,  359,  359,  359,  359,  359,  359,  550,  550,
 /*    80 */   319,  268,  572,  586,  520,  599,  645,  691,  737,  783,
 /*    90 */   829,  875,  903,  931,  959, 1002, 1030, 1099, 1190, 1190,
 /*   100 */  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190,
 /*   110 */  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190,
 /*   120 */  1218, 1190, 1190, 1245, 1125, 1125,   63, 1143, 1143, 1143,
 /*   130 */   -19,    3,   37,  655,    8,  380,   76,   76,   76,  926,
 /*   140 */   926,  926,  126, 1347, 1347,  170, 1254,  -30,  -30,  674,
 /*   150 */   642,  642,  642,  314,  642,  642,  642,  642,  642,  642,
 /*   160 */   642,  642,  642,  642,  642,  642,  642,  642,  642,  642,
 /*   170 */   642,  642,  642,  380,  -34,  -34,   49,  -34,  -34,  -34,
 /*   180 */    49, 1777, 1777, 1258,  -22,  -22,  -22,  351,  536,  311,
 /*   190 */   539,  544,  942,  261,  -10,  682,  330,   88,   88,   88,
 /*   200 */   629,  726,  241,   51,  642,  642,  642,  642,  642,  642,
 /*   210 */   642,  642,  642,  885,  316,  316,  642,  642,  720,  885,
 /*   220 */   642,  720,  642,  642,  642,  642,  642,  642,  642,  769,
 /*   230 */   642,  642,  316,  642,  642,  823,  852,  642,  642,   65,
 /*   240 */   642, 1018,   65,  642,  642,  642,  642, 1329, 1344, 1384,
 /*   250 */  1283, 1353, 1353, 1353, 1353, 1260, 1285, 1385, 1283, 1344,
 /*   260 */  1384, 1384, 1385, 1329, 1385, 1385, 1329, 1329, 1375, 1375,
 /*   270 */  1360, 1396, 1360, 1396, 1360, 1396, 1360, 1396, 1427, 1351,
 /*   280 */  1329, 1329, 1462, 1416, 1425, 1431, 1441, 1283, 1504, 1508,
 /*   290 */  1512, 1530, 1530, 1777, 1777, 1777,  112,  510,  383,  591,
 /*   300 */   690,  948,  950, 1025, 1032, 1019, 1020, 1027, 1029, 1054,
 /*   310 */  1131, 1132,  827, 1133, 1134, 1139,  826, 1050, 1252, 1141,
 /*   320 */  1577, 1580, 1523, 1549, 1550, 1513, 1552, 1555, 1578, 1541,
 /*   330 */  1539, 1591, 1587, 1589, 1624, 1497, 1600, 1545, 1531, 1536,
 /*   340 */  1554, 1565, 1613, 1511, 1611, 1514, 1516, 1522, 1575, 1672,
 /*   350 */  1574, 1559, 1662, 1663, 1664, 1666, 1566, 1631, 1582, 1585,
 /*   360 */  1686, 1543, 1645, 1603, 1557, 1601, 1650, 1688, 1612, 1655,
 /*   370 */  1633, 1657, 1658, 1659, 1637, 1661, 1639, 1627, 1649, 1665,
 /*   380 */  1667, 1668, 1660, 1619, 1671, 1673, 1676, 1674, 1618, 1677,
 /*   390 */  1679, 1670, 1622, 1682, 1625, 1680, 1628, 1681, 1629, 1696,
 /*   400 */  1604, 1689, 1690, 1691, 1692, 1606, 1693, 1680, 1694, 1695,
 /*   410 */  1697, 1699, 1698, 1684, 1702, 1704, 1669, 1700, 1705, 1707,
 /*   420 */  1675, 1700, 1708, 1710, 1711, 1713, 1714, 1623, 1715, 1616,
 /*   430 */  1716, 1718, 1683, 1678, 1719, 1741, 1725, 1732, 1767, 1769,
};
#define YY_REDUCE_USE_DFLT (-178)
#define YY_REDUCE_COUNT (295)
#define YY_REDUCE_MIN   (-177)
#define YY_REDUCE_MAX   (1471)
static const short yy_reduce_ofst[] = {
 /*     0 */    87, -160,  -43, 1108,   11,  244,  246, 1115, 1117,  -28,
 /*    10 */  1120, 1123, -139,  190,  532,  578,  624, 1113, 1129, 1155,
 /*    20 */  -136, 1168,  -36,  -46, -173,   66,   68,  143,  150,  277,
 /*    30 */  1206, 1215, 1219, 1226, 1228, 1235, 1240, 1242, 1248, 1251,
 /*    40 */  1262, -177,  -62, 1271, 1273, 1279, 1282, 1299, 1302, 1304,
 /*    50 */  1306, 1313, 1315, 1326, 1338, 1340, 1342, 1346, 1366, 1369,
 /*    60 */  1377, 1379, 1382, 1402, 1404, 1407, 1409, 1411, 1413, 1417,
 /*    70 */  1424, 1433, 1438, 1440, 1446, 1448, 1468, 1471,  -17,   34,
 /*    80 */   159,  104, 1459,  -20,  400,  400,  400,  400,  400,  400,
 /*    90 */   400,  400,  400,  400,  400,  400,  400,  400,  400,  400,
 /*   100 */   400,  400,  400,  400,  400,  400,  400,  400,  400,  400,
 /*   110 */   400,  400,  400,  400,  400,  400,  400,  400,  400,  400,
 /*   120 */   400,  400,  400,  400,  400,  400,  400,  400,  400,  400,
 /*   130 */   400,  400,  400,  400,  400,  468,  400,  400,  400, -140,
 /*   140 */   405,  451,  299,  347,  377, -121,  333,  -54,   19,   10,
 /*   150 */  -144,  222,  279,    2,  486,  559,  607,  608,  609,  651,
 /*   160 */   653,  -72,  654, -110,  152,  373,  452,  458,  561,  670,
 /*   170 */   594,  557,  818,  249,  195,  225,  590,  571,  656,  658,
 /*   180 */   630,  635,  845,    4,   33,   81,  149,   97,  228,  284,
 /*   190 */   304,  404,  531,  516,  616,  701,  716,  723,  735,  773,
 /*   200 */   228,  828,  819,  848,  888,  895,  897,  966,  984,  996,
 /*   210 */  1007, 1009, 1013,  974,  961,  962, 1031, 1043,  975, 1046,
 /*   220 */  1071, 1023, 1109, 1110, 1112, 1114, 1119, 1121, 1122, 1116,
 /*   230 */  1130, 1144, 1091, 1146, 1150, 1101, 1078, 1156, 1157, 1145,
 /*   240 */   716, 1153, 1147, 1171, 1178, 1189, 1194, 1185, 1151, 1186,
 /*   250 */  1174, 1197, 1199, 1211, 1213, 1169, 1172, 1250, 1217, 1202,
 /*   260 */  1237, 1238, 1266, 1246, 1269, 1270, 1255, 1256, 1265, 1268,
 /*   270 */  1239, 1259, 1253, 1272, 1280, 1274, 1281, 1288, 1263, 1234,
 /*   280 */  1290, 1327, 1261, 1307, 1311, 1321, 1314, 1328, 1367, 1383,
 /*   290 */  1378, 1391, 1392, 1380, 1386, 1388,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1235, 1210, 1210, 1210, 1266, 1152, 1152, 1152, 1152, 1102,
 /*    10 */  1152, 1152,  977, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*    20 */  1110, 1266, 1210,  977, 1023, 1266, 1266, 1266, 1266, 1266,
 /*    30 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*    40 */  1266, 1054, 1054, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*    50 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*    60 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*    70 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,  989,  989,
 /*    80 */   977, 1266, 1210, 1029, 1060, 1266, 1266, 1266, 1266, 1153,
 /*    90 */  1154, 1266, 1266, 1266, 1266, 1109, 1266, 1266, 1169, 1181,
 /*   100 */  1071, 1070, 1069, 1068, 1039, 1066, 1058, 1062, 1098, 1103,
 /*   110 */  1107, 1106, 1153, 1149, 1150, 1148, 1111, 1108, 1104, 1154,
 /*   120 */  1266, 1099, 1061, 1120, 1133, 1119, 1129, 1139, 1130, 1122,
 /*   130 */  1121, 1123, 1124, 1125, 1126, 1266, 1136, 1135, 1134, 1266,
 /*   140 */  1266, 1266,  977, 1266, 1266, 1266, 1159, 1266, 1266, 1266,
 /*   150 */  1266, 1266, 1266, 1210, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   160 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   170 */  1266, 1266, 1266, 1266, 1210, 1210,  989, 1210, 1210, 1210,
 /*   180 */   989, 1029, 1018, 1266, 1266, 1266, 1266, 1266, 1266, 1023,
 /*   190 */  1266, 1266, 1266, 1266, 1175, 1266, 1266, 1023, 1023, 1023,
 /*   200 */  1027, 1266, 1007, 1017, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   210 */  1266, 1266, 1266, 1065, 1041, 1041, 1266, 1266, 1263, 1065,
 /*   220 */  1266, 1263, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1054,
 /*   230 */  1266, 1266, 1041, 1266, 1266, 1025, 1151, 1266, 1266, 1017,
 /*   240 */  1266, 1026, 1017, 1266, 1266, 1266, 1266, 1160, 1076,  997,
 /*   250 */  1065, 1004, 1004, 1004, 1004, 1180, 1179,  969, 1065, 1076,
 /*   260 */   997,  997,  969, 1160,  969,  969, 1160, 1160,  995,  995,
 /*   270 */  1045, 1040, 1045, 1040, 1045, 1040, 1045, 1040, 1155, 1266,
 /*   280 */  1160, 1160, 1266, 1059, 1046, 1057, 1055, 1065, 1266, 1242,
 /*   290 */  1266, 1238, 1238, 1249, 1249,  972, 1266, 1266, 1266, 1266,
 /*   300 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   310 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1082, 1266,
 /*   320 */  1266,  959, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   330 */  1197, 1266, 1266, 1166, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   340 */  1266, 1266, 1266, 1266, 1178, 1177, 1266, 1266, 1266, 1266,
 /*   350 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1262,
 /*   360 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   370 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   380 */  1266, 1266, 1266, 1009, 1266, 1266, 1266, 1252, 1266, 1266,
 /*   390 */  1266, 1266, 1266, 1266, 1266, 1056, 1266, 1047, 1266, 1097,
 /*   400 */  1266, 1266, 1266, 1266, 1258, 1266, 1266, 1260, 1266, 1266,
 /*   410 */  1266, 1266, 1266, 1266, 1266, 1266, 1266, 1212, 1266, 1266,
 /*   420 */  1266, 1211, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
 /*   430 */  1266, 1266, 1266, 1266, 1266, 1266,  963, 1266, 1266, 1266,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
    0,  /*    EXPLAIN => nothing */
   50,  /*      QUERY => ID */
   50,  /*       PLAN => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
   50,  /*      MATCH => ID */
    0,  /*    LIKE_KW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*         LB => nothing */
    0,  /*      START => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*     COMMIT => nothing */
    0,  /*   ROLLBACK => nothing */
    0,  /*  SAVEPOINT => nothing */
   50,  /*    RELEASE => ID */
    0,  /*         TO => nothing */
    0,  /*      TABLE => nothing */
    0,  /*     CREATE => nothing */
   50,  /*         IF => ID */
    0,  /*     EXISTS => nothing */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*       WITH => nothing */
   50,  /*     ENGINE => ID */
    0,  /*     STRING => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
    0,  /*    INDEXED => nothing */
   50,  /*      ABORT => ID */
   50,  /*     ACTION => ID */
   50,  /*        ADD => ID */
   50,  /*      AFTER => ID */
   50,  /* AUTOINCREMENT => ID */
   50,  /*     BEFORE => ID */
   50,  /*    CASCADE => ID */
   50,  /*   CONFLICT => ID */
   50,  /*   DEFERRED => ID */
   50,  /*        END => ID */
   50,  /*       FAIL => ID */
   50,  /*     IGNORE => ID */
   50,  /*  INITIALLY => ID */
   50,  /*    INSTEAD => ID */
   50,  /*         NO => ID */
   50,  /*        KEY => ID */
   50,  /*     OFFSET => ID */
   50,  /*      RAISE => ID */
   50,  /*    REPLACE => ID */
   50,  /*   RESTRICT => ID */
   50,  /*     RENAME => ID */
   50,  /*   CTIME_KW => ID */
   50,  /*     ENABLE => ID */
   50,  /*    DISABLE => ID */
   50,  /*       UUID => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  bool is_fallback_failed;      /* Shows if fallback failed or not */
  sqlParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "OR",            "AND",           "NOT",         
  "IS",            "MATCH",         "LIKE_KW",       "BETWEEN",     
  "IN",            "NE",            "EQ",            "GT",          
  "LE",            "LT",            "GE",            "ESCAPE",      
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "COLLATE",       "BITNOT",      
  "LB",            "START",         "TRANSACTION",   "COMMIT",      
  "ROLLBACK",      "SAVEPOINT",     "RELEASE",       "TO",          
  "TABLE",         "CREATE",        "IF",            "EXISTS",      
  "LP",            "RP",            "WITH",          "ENGINE",      
  "STRING",        "COMMA",         "ID",            "INDEXED",     
  "ABORT",         "ACTION",        "ADD",           "AFTER",       
  "AUTOINCREMENT",  "BEFORE",        "CASCADE",       "CONFLICT",    
  "DEFERRED",      "END",           "FAIL",          "IGNORE",      
  "INITIALLY",     "INSTEAD",       "NO",            "KEY",         
  "OFFSET",        "RAISE",         "REPLACE",       "RESTRICT",    
  "RENAME",        "CTIME_KW",      "ENABLE",        "DISABLE",     
  "UUID",          "WILDCARD",      "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "FOREIGN",       "ON",          
  "DROP",          "VIEW",          "AS",            "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "VALUES",        "DISTINCT",      "DOT",           "SEQSCAN",     
  "FROM",          "JOIN_KW",       "JOIN",          "BY",          
  "USING",         "ORDER",         "ASC",           "DESC",        
  "GROUP",         "HAVING",        "LIMIT",         "DELETE",      
  "TRUNCATE",      "WHERE",         "UPDATE",        "SET",         
  "INTO",          "INSERT",        "FLOAT",         "BLOB",        
  "FALSE",         "TRUE",          "UNKNOWN",       "DECIMAL",     
  "INTEGER",       "VARNUM",        "COLON",         "VARIABLE",    
  "CAST",          "RB",            "LCB",           "RCB",         
  "TRIM",          "LEADING",       "TRAILING",      "BOTH",        
  "CHAR",          "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "SESSION",       "PRAGMA",      
  "FUNCTION_KW",   "BEGIN",         "TRIGGER",       "OF",          
  "FOR",           "EACH",          "ROW",           "ALTER",       
  "COLUMN",        "RECURSIVE",     "TEXT",          "STRING_KW",   
  "SCALAR",        "BOOL",          "BOOLEAN",       "VARBINARY",   
  "ANY",           "ARRAY",         "MAP",           "DATETIME",    
  "INTERVAL",      "VARCHAR",       "NUMBER",        "DOUBLE",      
  "INT",           "INTEGER_KW",    "UNSIGNED",      "error",       
  "input",         "ecmd",          "explain",       "cmdx",        
  "cmd",           "savepoint_opt",  "nm",            "create_table",
  "create_table_args",  "with_opts",     "create_table_end",  "createkw",    
  "ifnotexists",   "columnlist",    "engine_opts",   "tcons",       
  "column_def",    "create_column_end",  "column_name_and_type",  "carglist",    
  "typedef",       "autoinc",       "ccons",         "cconsname",   
  "term",          "expr",          "onconf",        "sortorder",   
  "eidlist_opt",   "col_list_with_autoinc",  "sortlist",      "eidlist",     
  "index_onconf",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "select",        "selectnowith",
  "oneselect",     "with",          "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "values",      
  "nexprlist",     "exprlist",      "sclp",          "as",          
  "seqscan",       "seltablist",    "stl_prefix",    "joinop",      
  "indexed_opt",   "on_opt",        "using_opt",     "join_nm",     
  "idlist",        "setlist",       "insert_cmd",    "idlist_opt",  
  "getlist",       "maplist",       "nmaplist",      "trim_operands",
  "trim_specification",  "expr_optional",  "type_func",     "likeop",      
  "between_op",    "in_op",         "paren_exprlist",  "case_exprlist",
  "case_else",     "uniqueflag",    "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "trnm",          "tridxby",       "alter_table_start",
  "alter_add_constraint",  "alter_add_column",  "column_name",   "alter_column_def",
  "unique_spec",   "wqlist",        "char_len",      "number_typedef",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "ecmd ::= explain cmdx SEMI",
 /*   1 */ "ecmd ::= SEMI",
 /*   2 */ "explain ::= EXPLAIN",
 /*   3 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   4 */ "cmd ::= START TRANSACTION",
 /*   5 */ "cmd ::= COMMIT",
 /*   6 */ "cmd ::= ROLLBACK",
 /*   7 */ "cmd ::= SAVEPOINT nm",
 /*   8 */ "cmd ::= RELEASE savepoint_opt nm",
 /*   9 */ "cmd ::= ROLLBACK TO savepoint_opt nm",
 /*  10 */ "create_table ::= createkw TABLE ifnotexists nm",
 /*  11 */ "createkw ::= CREATE",
 /*  12 */ "ifnotexists ::=",
 /*  13 */ "ifnotexists ::= IF NOT EXISTS",
 /*  14 */ "engine_opts ::= ENGINE EQ STRING",
 /*  15 */ "create_table_end ::=",
 /*  16 */ "column_name_and_type ::= nm typedef",
 /*  17 */ "create_column_end ::= autoinc",
 /*  18 */ "nm ::= ID|INDEXED",
 /*  19 */ "cconsname ::= CONSTRAINT nm",
 /*  20 */ "cconsname ::=",
 /*  21 */ "ccons ::= DEFAULT term",
 /*  22 */ "ccons ::= DEFAULT LP expr RP",
 /*  23 */ "ccons ::= DEFAULT PLUS term",
 /*  24 */ "ccons ::= DEFAULT MINUS term",
 /*  25 */ "ccons ::= NULL onconf",
 /*  26 */ "ccons ::= NOT NULL onconf",
 /*  27 */ "ccons ::= cconsname PRIMARY KEY sortorder",
 /*  28 */ "ccons ::= cconsname UNIQUE",
 /*  29 */ "ccons ::= cconsname CHECK LP expr RP",
 /*  30 */ "ccons ::= cconsname REFERENCES nm eidlist_opt",
 /*  31 */ "ccons ::= COLLATE ID|INDEXED",
 /*  32 */ "autoinc ::=",
 /*  33 */ "autoinc ::= AUTOINCR",
 /*  34 */ "tcons ::= cconsname PRIMARY KEY LP col_list_with_autoinc RP",
 /*  35 */ "tcons ::= cconsname UNIQUE LP sortlist RP",
 /*  36 */ "tcons ::= cconsname CHECK LP expr RP",
 /*  37 */ "tcons ::= cconsname FOREIGN KEY LP eidlist RP REFERENCES nm eidlist_opt",
 /*  38 */ "onconf ::=",
 /*  39 */ "onconf ::= ON CONFLICT resolvetype",
 /*  40 */ "orconf ::=",
 /*  41 */ "orconf ::= OR resolvetype",
 /*  42 */ "resolvetype ::= IGNORE",
 /*  43 */ "resolvetype ::= REPLACE",
 /*  44 */ "cmd ::= DROP TABLE ifexists fullname",
 /*  45 */ "cmd ::= DROP VIEW ifexists fullname",
 /*  46 */ "ifexists ::= IF EXISTS",
 /*  47 */ "ifexists ::=",
 /*  48 */ "cmd ::= createkw VIEW ifnotexists nm eidlist_opt AS select",
 /*  49 */ "cmd ::= select",
 /*  50 */ "select ::= with selectnowith",
 /*  51 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /*  52 */ "multiselect_op ::= UNION",
 /*  53 */ "multiselect_op ::= UNION ALL",
 /*  54 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /*  55 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  56 */ "values ::= VALUES LP nexprlist RP",
 /*  57 */ "values ::= values COMMA LP exprlist RP",
 /*  58 */ "distinct ::= DISTINCT",
 /*  59 */ "distinct ::= ALL",
 /*  60 */ "distinct ::=",
 /*  61 */ "sclp ::=",
 /*  62 */ "selcollist ::= sclp expr as",
 /*  63 */ "selcollist ::= sclp STAR",
 /*  64 */ "selcollist ::= sclp nm DOT STAR",
 /*  65 */ "as ::= AS nm",
 /*  66 */ "as ::=",
 /*  67 */ "seqscan ::= SEQSCAN",
 /*  68 */ "seqscan ::=",
 /*  69 */ "from ::=",
 /*  70 */ "from ::= FROM seltablist",
 /*  71 */ "stl_prefix ::= seltablist joinop",
 /*  72 */ "stl_prefix ::=",
 /*  73 */ "seltablist ::= stl_prefix seqscan nm as indexed_opt on_opt using_opt",
 /*  74 */ "seltablist ::= stl_prefix seqscan nm LP exprlist RP as on_opt using_opt",
 /*  75 */ "seltablist ::= stl_prefix LP select RP as on_opt using_opt",
 /*  76 */ "seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt",
 /*  77 */ "fullname ::= nm",
 /*  78 */ "joinop ::= COMMA|JOIN",
 /*  79 */ "joinop ::= JOIN_KW JOIN",
 /*  80 */ "joinop ::= JOIN_KW join_nm JOIN",
 /*  81 */ "joinop ::= JOIN_KW join_nm join_nm JOIN",
 /*  82 */ "on_opt ::= ON expr",
 /*  83 */ "on_opt ::=",
 /*  84 */ "indexed_opt ::=",
 /*  85 */ "indexed_opt ::= INDEXED BY nm",
 /*  86 */ "indexed_opt ::= NOT INDEXED",
 /*  87 */ "using_opt ::= USING LP idlist RP",
 /*  88 */ "using_opt ::=",
 /*  89 */ "orderby_opt ::=",
 /*  90 */ "orderby_opt ::= ORDER BY sortlist",
 /*  91 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  92 */ "sortlist ::= expr sortorder",
 /*  93 */ "col_list_with_autoinc ::= col_list_with_autoinc COMMA expr autoinc",
 /*  94 */ "col_list_with_autoinc ::= expr autoinc",
 /*  95 */ "sortorder ::= ASC",
 /*  96 */ "sortorder ::= DESC",
 /*  97 */ "sortorder ::=",
 /*  98 */ "groupby_opt ::=",
 /*  99 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 100 */ "having_opt ::=",
 /* 101 */ "having_opt ::= HAVING expr",
 /* 102 */ "limit_opt ::=",
 /* 103 */ "limit_opt ::= LIMIT expr",
 /* 104 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 105 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 106 */ "cmd ::= with DELETE FROM fullname indexed_opt where_opt",
 /* 107 */ "cmd ::= TRUNCATE TABLE fullname",
 /* 108 */ "where_opt ::=",
 /* 109 */ "where_opt ::= WHERE expr",
 /* 110 */ "cmd ::= with UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 111 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 112 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 113 */ "setlist ::= nm EQ expr",
 /* 114 */ "setlist ::= LP idlist RP EQ expr",
 /* 115 */ "cmd ::= with insert_cmd INTO fullname idlist_opt select",
 /* 116 */ "cmd ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES",
 /* 117 */ "insert_cmd ::= INSERT orconf",
 /* 118 */ "insert_cmd ::= REPLACE",
 /* 119 */ "idlist_opt ::=",
 /* 120 */ "idlist_opt ::= LP idlist RP",
 /* 121 */ "idlist ::= idlist COMMA nm",
 /* 122 */ "idlist ::= nm",
 /* 123 */ "expr ::= LP expr RP",
 /* 124 */ "term ::= NULL",
 /* 125 */ "expr ::= ID|INDEXED",
 /* 126 */ "expr ::= JOIN_KW",
 /* 127 */ "expr ::= nm DOT nm",
 /* 128 */ "term ::= FLOAT|BLOB",
 /* 129 */ "term ::= STRING",
 /* 130 */ "term ::= FALSE",
 /* 131 */ "term ::= TRUE",
 /* 132 */ "term ::= UNKNOWN",
 /* 133 */ "term ::= DECIMAL",
 /* 134 */ "term ::= INTEGER",
 /* 135 */ "expr ::= VARNUM",
 /* 136 */ "expr ::= COLON|VARIABLE ID|INDEXED",
 /* 137 */ "expr ::= COLON|VARIABLE INTEGER",
 /* 138 */ "expr ::= expr COLLATE ID|INDEXED",
 /* 139 */ "expr ::= CAST LP expr AS typedef RP",
 /* 140 */ "expr ::= expr LB getlist RB",
 /* 141 */ "getlist ::= getlist RB LB expr",
 /* 142 */ "getlist ::= expr",
 /* 143 */ "expr ::= LB exprlist RB",
 /* 144 */ "expr ::= LCB maplist RCB",
 /* 145 */ "maplist ::=",
 /* 146 */ "nmaplist ::= nmaplist COMMA expr COLON expr",
 /* 147 */ "nmaplist ::= expr COLON expr",
 /* 148 */ "expr ::= TRIM LP trim_operands RP",
 /* 149 */ "trim_operands ::= trim_specification expr FROM expr",
 /* 150 */ "trim_operands ::= trim_specification FROM expr",
 /* 151 */ "trim_operands ::= expr FROM expr",
 /* 152 */ "trim_operands ::= expr",
 /* 153 */ "expr_optional ::=",
 /* 154 */ "expr_optional ::= expr",
 /* 155 */ "trim_specification ::= LEADING",
 /* 156 */ "trim_specification ::= TRAILING",
 /* 157 */ "trim_specification ::= BOTH",
 /* 158 */ "expr ::= ID|INDEXED LP distinct exprlist RP",
 /* 159 */ "expr ::= type_func LP distinct exprlist RP",
 /* 160 */ "expr ::= ID|INDEXED LP STAR RP",
 /* 161 */ "expr ::= LP nexprlist COMMA expr RP",
 /* 162 */ "expr ::= expr AND expr",
 /* 163 */ "expr ::= expr OR expr",
 /* 164 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 165 */ "expr ::= expr EQ|NE expr",
 /* 166 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 167 */ "expr ::= expr PLUS|MINUS expr",
 /* 168 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 169 */ "expr ::= expr CONCAT expr",
 /* 170 */ "likeop ::= LIKE_KW|MATCH",
 /* 171 */ "likeop ::= NOT LIKE_KW|MATCH",
 /* 172 */ "expr ::= expr likeop expr",
 /* 173 */ "expr ::= expr likeop expr ESCAPE expr",
 /* 174 */ "expr ::= expr IS NULL",
 /* 175 */ "expr ::= expr IS NOT NULL",
 /* 176 */ "expr ::= NOT expr",
 /* 177 */ "expr ::= BITNOT expr",
 /* 178 */ "expr ::= MINUS expr",
 /* 179 */ "expr ::= PLUS expr",
 /* 180 */ "between_op ::= BETWEEN",
 /* 181 */ "between_op ::= NOT BETWEEN",
 /* 182 */ "expr ::= expr between_op expr AND expr",
 /* 183 */ "in_op ::= IN",
 /* 184 */ "in_op ::= NOT IN",
 /* 185 */ "expr ::= expr in_op LP exprlist RP",
 /* 186 */ "expr ::= LP select RP",
 /* 187 */ "expr ::= expr in_op LP select RP",
 /* 188 */ "expr ::= expr in_op nm paren_exprlist",
 /* 189 */ "expr ::= EXISTS LP select RP",
 /* 190 */ "expr ::= CASE expr_optional case_exprlist case_else END",
 /* 191 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 192 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 193 */ "case_else ::= ELSE expr",
 /* 194 */ "case_else ::=",
 /* 195 */ "exprlist ::=",
 /* 196 */ "nexprlist ::= nexprlist COMMA expr",
 /* 197 */ "nexprlist ::= expr",
 /* 198 */ "paren_exprlist ::=",
 /* 199 */ "paren_exprlist ::= LP exprlist RP",
 /* 200 */ "cmd ::= createkw uniqueflag INDEX ifnotexists nm ON nm LP sortlist RP",
 /* 201 */ "uniqueflag ::= UNIQUE",
 /* 202 */ "uniqueflag ::=",
 /* 203 */ "eidlist_opt ::=",
 /* 204 */ "eidlist_opt ::= LP eidlist RP",
 /* 205 */ "eidlist ::= eidlist COMMA nm",
 /* 206 */ "eidlist ::= nm",
 /* 207 */ "cmd ::= DROP INDEX ifexists nm ON fullname",
 /* 208 */ "cmd ::= SET SESSION nm EQ term",
 /* 209 */ "cmd ::= PRAGMA nm",
 /* 210 */ "cmd ::= PRAGMA nm LP nm RP",
 /* 211 */ "cmd ::= PRAGMA nm LP nm DOT nm RP",
 /* 212 */ "cmd ::= FUNCTION_KW expr",
 /* 213 */ "cmd ::= createkw trigger_decl BEGIN trigger_cmd_list END",
 /* 214 */ "trigger_decl ::= TRIGGER ifnotexists nm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 215 */ "trigger_time ::= BEFORE",
 /* 216 */ "trigger_time ::= AFTER",
 /* 217 */ "trigger_time ::= INSTEAD OF",
 /* 218 */ "trigger_time ::=",
 /* 219 */ "trigger_event ::= DELETE|INSERT",
 /* 220 */ "trigger_event ::= UPDATE",
 /* 221 */ "trigger_event ::= UPDATE OF idlist",
 /* 222 */ "foreach_clause ::=",
 /* 223 */ "when_clause ::=",
 /* 224 */ "when_clause ::= WHEN expr",
 /* 225 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 226 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 227 */ "trnm ::= nm DOT nm",
 /* 228 */ "tridxby ::= INDEXED BY nm",
 /* 229 */ "tridxby ::= NOT INDEXED",
 /* 230 */ "trigger_cmd ::= UPDATE orconf trnm tridxby SET setlist where_opt",
 /* 231 */ "trigger_cmd ::= insert_cmd INTO trnm idlist_opt select",
 /* 232 */ "trigger_cmd ::= DELETE FROM trnm tridxby where_opt",
 /* 233 */ "trigger_cmd ::= select",
 /* 234 */ "expr ::= RAISE LP IGNORE RP",
 /* 235 */ "expr ::= RAISE LP raisetype COMMA STRING RP",
 /* 236 */ "raisetype ::= ROLLBACK",
 /* 237 */ "raisetype ::= ABORT",
 /* 238 */ "raisetype ::= FAIL",
 /* 239 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 240 */ "alter_table_start ::= ALTER TABLE fullname",
 /* 241 */ "alter_add_constraint ::= alter_table_start ADD CONSTRAINT nm",
 /* 242 */ "alter_add_column ::= alter_table_start ADD column_name",
 /* 243 */ "column_name ::= COLUMN nm",
 /* 244 */ "column_name ::= nm",
 /* 245 */ "alter_column_def ::= alter_add_column typedef",
 /* 246 */ "cmd ::= alter_add_constraint FOREIGN KEY LP eidlist RP REFERENCES nm eidlist_opt",
 /* 247 */ "cmd ::= alter_add_constraint CHECK LP expr RP",
 /* 248 */ "cmd ::= alter_add_constraint unique_spec LP sortlist RP",
 /* 249 */ "unique_spec ::= UNIQUE",
 /* 250 */ "unique_spec ::= PRIMARY KEY",
 /* 251 */ "cmd ::= alter_table_start RENAME TO nm",
 /* 252 */ "cmd ::= ALTER TABLE fullname DROP CONSTRAINT nm",
 /* 253 */ "with ::=",
 /* 254 */ "with ::= WITH wqlist",
 /* 255 */ "with ::= WITH RECURSIVE wqlist",
 /* 256 */ "wqlist ::= nm eidlist_opt AS LP select RP",
 /* 257 */ "wqlist ::= wqlist COMMA nm eidlist_opt AS LP select RP",
 /* 258 */ "typedef ::= TEXT",
 /* 259 */ "typedef ::= STRING_KW",
 /* 260 */ "typedef ::= SCALAR",
 /* 261 */ "typedef ::= BOOL",
 /* 262 */ "typedef ::= BOOLEAN",
 /* 263 */ "typedef ::= VARBINARY",
 /* 264 */ "typedef ::= UUID",
 /* 265 */ "typedef ::= ANY",
 /* 266 */ "typedef ::= ARRAY",
 /* 267 */ "typedef ::= MAP",
 /* 268 */ "typedef ::= DATETIME",
 /* 269 */ "typedef ::= INTERVAL",
 /* 270 */ "char_len ::= LP INTEGER RP",
 /* 271 */ "typedef ::= VARCHAR char_len",
 /* 272 */ "number_typedef ::= NUMBER",
 /* 273 */ "number_typedef ::= DOUBLE",
 /* 274 */ "number_typedef ::= INT|INTEGER_KW",
 /* 275 */ "number_typedef ::= UNSIGNED",
 /* 276 */ "number_typedef ::= DECIMAL",
 /* 277 */ "input ::= ecmd",
 /* 278 */ "explain ::=",
 /* 279 */ "cmdx ::= cmd",
 /* 280 */ "savepoint_opt ::= SAVEPOINT",
 /* 281 */ "savepoint_opt ::=",
 /* 282 */ "cmd ::= create_table create_table_args with_opts create_table_end",
 /* 283 */ "create_table_args ::= LP columnlist RP",
 /* 284 */ "with_opts ::= WITH engine_opts",
 /* 285 */ "with_opts ::=",
 /* 286 */ "columnlist ::= columnlist COMMA tcons",
 /* 287 */ "columnlist ::= columnlist COMMA column_def create_column_end",
 /* 288 */ "columnlist ::= column_def create_column_end",
 /* 289 */ "column_def ::= column_name_and_type carglist",
 /* 290 */ "columnlist ::= tcons",
 /* 291 */ "carglist ::= carglist ccons",
 /* 292 */ "carglist ::=",
 /* 293 */ "resolvetype ::= raisetype",
 /* 294 */ "selectnowith ::= oneselect",
 /* 295 */ "oneselect ::= values",
 /* 296 */ "sclp ::= selcollist COMMA",
 /* 297 */ "as ::= ID|STRING",
 /* 298 */ "join_nm ::= ID|INDEXED",
 /* 299 */ "join_nm ::= JOIN_KW",
 /* 300 */ "expr ::= term",
 /* 301 */ "maplist ::= nmaplist",
 /* 302 */ "type_func ::= CHAR",
 /* 303 */ "exprlist ::= nexprlist",
 /* 304 */ "foreach_clause ::= FOR EACH ROW",
 /* 305 */ "trnm ::= nm",
 /* 306 */ "tridxby ::=",
 /* 307 */ "cmd ::= alter_column_def carglist create_column_end",
 /* 308 */ "typedef ::= number_typedef",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to sqlParserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlParser and sqlParserFree.
*/
void *sqlParserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( pParser ){
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyhwm = 0;
#endif
    pParser->is_fallback_failed = false;
#if YYSTACKDEPTH<=0
    pParser->yytos = NULL;
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    if( yyGrowStack(pParser) ){
      pParser->yystack = &pParser->yystk0;
      pParser->yystksz = 1;
    }
#endif
#ifndef YYNOERRORRECOVERY
    pParser->yyerrcnt = -1;
#endif
    pParser->yytos = pParser->yystack;
    pParser->yystack[0].stateno = 0;
    pParser->yystack[0].major = 0;
  }
  return pParser;
}

/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 196: /* term */
    case 197: /* expr */
{
#line 887 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sql_expr_delete((yypminor->yy214).pExpr);
#line 1591 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 200: /* eidlist_opt */
    case 201: /* col_list_with_autoinc */
    case 202: /* sortlist */
    case 203: /* eidlist */
    case 216: /* selcollist */
    case 219: /* groupby_opt */
    case 221: /* orderby_opt */
    case 224: /* nexprlist */
    case 225: /* exprlist */
    case 226: /* sclp */
    case 237: /* setlist */
    case 250: /* paren_exprlist */
    case 251: /* case_exprlist */
{
#line 1437 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sql_expr_list_delete((yypminor->yy402));
#line 1610 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 209: /* fullname */
    case 217: /* from */
    case 229: /* seltablist */
    case 230: /* stl_prefix */
{
#line 652 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sqlSrcListDelete((yypminor->yy291));
#line 1620 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 210: /* select */
    case 211: /* selectnowith */
    case 212: /* oneselect */
    case 223: /* values */
{
#line 423 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sql_select_delete((yypminor->yy331));
#line 1630 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 213: /* with */
    case 269: /* wqlist */
{
#line 1722 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sqlWithDelete((yypminor->yy227));
#line 1638 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 218: /* where_opt */
    case 220: /* having_opt */
    case 233: /* on_opt */
    case 252: /* case_else */
    case 259: /* when_clause */
{
#line 804 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sql_expr_delete((yypminor->yy386));
#line 1649 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 234: /* using_opt */
    case 236: /* idlist */
    case 239: /* idlist_opt */
{
#line 691 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sqlIdListDelete((yypminor->yy272));
#line 1658 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 240: /* getlist */
    case 241: /* maplist */
    case 242: /* nmaplist */
{
#line 1023 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sql_expr_list_delete((yypminor->yy190));
#line 1667 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 243: /* trim_operands */
{
#line 1067 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sql_expr_list_delete((yypminor->yy215));
#line 1674 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 245: /* expr_optional */
{
#line 1096 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sql_expr_delete((yypminor->yy407));
#line 1681 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 255: /* trigger_cmd_list */
    case 260: /* trigger_cmd */
{
#line 1546 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sqlDeleteTriggerStep((yypminor->yy251));
#line 1689 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
    case 257: /* trigger_event */
{
#line 1527 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
sqlIdListDelete((yypminor->yy403).b);
#line 1696 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(yytos->major, &yytos->minor);
}

/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void sqlParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
#ifndef YYPARSEFREENEVERNULL
  if( pParser==0 ) return;
#endif
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static unsigned int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yytos->stateno;
 
  if( stateno>=YY_MIN_REDUCE ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
  do{
    i = yy_shift_ofst[stateno];
    assert( iLookAhead!=YYNOCODE );
    i += iLookAhead;
    if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback = -1;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      } else if ( iFallback==0 ) {
        pParser->is_fallback_failed = true;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   sqlParserARG_FETCH;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
#line 44 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  diag_set(ClientError, ER_SQL_STACK_OVERFLOW);
  pParse->is_aborted = true;
#line 1872 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
/******** End %stack_overflow code ********************************************/
   sqlParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%sShift '%s', go to state %d\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%sShift '%s'\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major]);
    }
  }
}
#else
# define yyTraceShift(X,Y)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  sqlParserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>=&yypParser->yystack[YYSTACKDEPTH] ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState);
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 173, 3 },
  { 173, 1 },
  { 174, 1 },
  { 174, 3 },
  { 176, 2 },
  { 176, 1 },
  { 176, 1 },
  { 176, 2 },
  { 176, 3 },
  { 176, 4 },
  { 179, 4 },
  { 183, 1 },
  { 184, 0 },
  { 184, 3 },
  { 186, 3 },
  { 182, 0 },
  { 190, 2 },
  { 189, 1 },
  { 178, 1 },
  { 195, 2 },
  { 195, 0 },
  { 194, 2 },
  { 194, 4 },
  { 194, 3 },
  { 194, 3 },
  { 194, 2 },
  { 194, 3 },
  { 194, 4 },
  { 194, 2 },
  { 194, 5 },
  { 194, 4 },
  { 194, 2 },
  { 193, 0 },
  { 193, 1 },
  { 187, 6 },
  { 187, 5 },
  { 187, 5 },
  { 187, 9 },
  { 198, 0 },
  { 198, 3 },
  { 205, 0 },
  { 205, 2 },
  { 206, 1 },
  { 206, 1 },
  { 176, 4 },
  { 176, 4 },
  { 208, 2 },
  { 208, 0 },
  { 176, 7 },
  { 176, 1 },
  { 210, 2 },
  { 211, 3 },
  { 214, 1 },
  { 214, 2 },
  { 214, 1 },
  { 212, 9 },
  { 223, 4 },
  { 223, 5 },
  { 215, 1 },
  { 215, 1 },
  { 215, 0 },
  { 226, 0 },
  { 216, 3 },
  { 216, 2 },
  { 216, 4 },
  { 227, 2 },
  { 227, 0 },
  { 228, 1 },
  { 228, 0 },
  { 217, 0 },
  { 217, 2 },
  { 230, 2 },
  { 230, 0 },
  { 229, 7 },
  { 229, 9 },
  { 229, 7 },
  { 229, 7 },
  { 209, 1 },
  { 231, 1 },
  { 231, 2 },
  { 231, 3 },
  { 231, 4 },
  { 233, 2 },
  { 233, 0 },
  { 232, 0 },
  { 232, 3 },
  { 232, 2 },
  { 234, 4 },
  { 234, 0 },
  { 221, 0 },
  { 221, 3 },
  { 202, 4 },
  { 202, 2 },
  { 201, 4 },
  { 201, 2 },
  { 199, 1 },
  { 199, 1 },
  { 199, 0 },
  { 219, 0 },
  { 219, 3 },
  { 220, 0 },
  { 220, 2 },
  { 222, 0 },
  { 222, 2 },
  { 222, 4 },
  { 222, 4 },
  { 176, 6 },
  { 176, 3 },
  { 218, 0 },
  { 218, 2 },
  { 176, 8 },
  { 237, 5 },
  { 237, 7 },
  { 237, 3 },
  { 237, 5 },
  { 176, 6 },
  { 176, 7 },
  { 238, 2 },
  { 238, 1 },
  { 239, 0 },
  { 239, 3 },
  { 236, 3 },
  { 236, 1 },
  { 197, 3 },
  { 196, 1 },
  { 197, 1 },
  { 197, 1 },
  { 197, 3 },
  { 196, 1 },
  { 196, 1 },
  { 196, 1 },
  { 196, 1 },
  { 196, 1 },
  { 196, 1 },
  { 196, 1 },
  { 197, 1 },
  { 197, 2 },
  { 197, 2 },
  { 197, 3 },
  { 197, 6 },
  { 197, 4 },
  { 240, 4 },
  { 240, 1 },
  { 197, 3 },
  { 197, 3 },
  { 241, 0 },
  { 242, 5 },
  { 242, 3 },
  { 197, 4 },
  { 243, 4 },
  { 243, 3 },
  { 243, 3 },
  { 243, 1 },
  { 245, 0 },
  { 245, 1 },
  { 244, 1 },
  { 244, 1 },
  { 244, 1 },
  { 197, 5 },
  { 197, 5 },
  { 197, 4 },
  { 197, 5 },
  { 197, 3 },
  { 197, 3 },
  { 197, 3 },
  { 197, 3 },
  { 197, 3 },
  { 197, 3 },
  { 197, 3 },
  { 197, 3 },
  { 247, 1 },
  { 247, 2 },
  { 197, 3 },
  { 197, 5 },
  { 197, 3 },
  { 197, 4 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 248, 1 },
  { 248, 2 },
  { 197, 5 },
  { 249, 1 },
  { 249, 2 },
  { 197, 5 },
  { 197, 3 },
  { 197, 5 },
  { 197, 4 },
  { 197, 4 },
  { 197, 5 },
  { 251, 5 },
  { 251, 4 },
  { 252, 2 },
  { 252, 0 },
  { 225, 0 },
  { 224, 3 },
  { 224, 1 },
  { 250, 0 },
  { 250, 3 },
  { 176, 10 },
  { 253, 1 },
  { 253, 0 },
  { 200, 0 },
  { 200, 3 },
  { 203, 3 },
  { 203, 1 },
  { 176, 6 },
  { 176, 5 },
  { 176, 2 },
  { 176, 5 },
  { 176, 7 },
  { 176, 2 },
  { 176, 5 },
  { 254, 9 },
  { 256, 1 },
  { 256, 1 },
  { 256, 2 },
  { 256, 0 },
  { 257, 1 },
  { 257, 1 },
  { 257, 3 },
  { 258, 0 },
  { 259, 0 },
  { 259, 2 },
  { 255, 3 },
  { 255, 2 },
  { 261, 3 },
  { 262, 3 },
  { 262, 2 },
  { 260, 7 },
  { 260, 5 },
  { 260, 5 },
  { 260, 1 },
  { 197, 4 },
  { 197, 6 },
  { 207, 1 },
  { 207, 1 },
  { 207, 1 },
  { 176, 4 },
  { 263, 3 },
  { 264, 4 },
  { 265, 3 },
  { 266, 2 },
  { 266, 1 },
  { 267, 2 },
  { 176, 9 },
  { 176, 5 },
  { 176, 5 },
  { 268, 1 },
  { 268, 2 },
  { 176, 4 },
  { 176, 6 },
  { 213, 0 },
  { 213, 2 },
  { 213, 3 },
  { 269, 6 },
  { 269, 8 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 270, 3 },
  { 192, 2 },
  { 271, 1 },
  { 271, 1 },
  { 271, 1 },
  { 271, 1 },
  { 271, 1 },
  { 172, 1 },
  { 174, 0 },
  { 175, 1 },
  { 177, 1 },
  { 177, 0 },
  { 176, 4 },
  { 180, 3 },
  { 181, 2 },
  { 181, 0 },
  { 185, 3 },
  { 185, 4 },
  { 185, 2 },
  { 188, 2 },
  { 185, 1 },
  { 191, 2 },
  { 191, 0 },
  { 206, 1 },
  { 211, 1 },
  { 212, 1 },
  { 226, 2 },
  { 227, 1 },
  { 235, 1 },
  { 235, 1 },
  { 197, 1 },
  { 241, 1 },
  { 246, 1 },
  { 225, 1 },
  { 258, 3 },
  { 261, 1 },
  { 262, 0 },
  { 176, 3 },
  { 192, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno        /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlParserARG_FETCH;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    fprintf(yyTraceFILE, "%sReduce [%s], go to state %d.\n", yyTracePrompt,
      yyRuleName[yyruleno], yymsp[-yysize].stateno);
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=&yypParser->yystack[YYSTACKDEPTH-1] ){
      yyStackOverflow(yypParser);
      return;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        return;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* ecmd ::= explain cmdx SEMI */
#line 111 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
	if (!pParse->parse_only)
		sql_finish_coding(pParse);
}
#line 2324 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 1: /* ecmd ::= SEMI */
#line 115 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  diag_set(ClientError, ER_SQL_STATEMENT_EMPTY);
  pParse->is_aborted = true;
}
#line 2332 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 2: /* explain ::= EXPLAIN */
#line 120 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ pParse->explain = 1; }
#line 2337 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 3: /* explain ::= EXPLAIN QUERY PLAN */
#line 121 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ pParse->explain = 2; }
#line 2342 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 4: /* cmd ::= START TRANSACTION */
#line 152 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{sql_transaction_begin(pParse);}
#line 2347 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 5: /* cmd ::= COMMIT */
#line 153 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{sql_transaction_commit(pParse);}
#line 2352 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 6: /* cmd ::= ROLLBACK */
#line 154 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{sql_transaction_rollback(pParse);}
#line 2357 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 7: /* cmd ::= SAVEPOINT nm */
#line 158 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  sqlSavepoint(pParse, SAVEPOINT_BEGIN, &yymsp[0].minor.yy0);
}
#line 2364 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 8: /* cmd ::= RELEASE savepoint_opt nm */
#line 161 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  sqlSavepoint(pParse, SAVEPOINT_RELEASE, &yymsp[0].minor.yy0);
}
#line 2371 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 9: /* cmd ::= ROLLBACK TO savepoint_opt nm */
#line 164 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  sqlSavepoint(pParse, SAVEPOINT_ROLLBACK, &yymsp[0].minor.yy0);
}
#line 2378 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 10: /* create_table ::= createkw TABLE ifnotexists nm */
#line 171 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_table_def_init(&pParse->create_table_def, &yymsp[0].minor.yy0, yymsp[-1].minor.yy60);
  create_ck_constraint_parse_def_init(&pParse->create_ck_constraint_parse_def);
  create_fk_constraint_parse_def_init(&pParse->create_fk_constraint_parse_def);
  pParse->create_table_def.new_space = sqlStartTable(pParse, &yymsp[0].minor.yy0);
  pParse->initiateTTrans = true;
}
#line 2389 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 11: /* createkw ::= CREATE */
#line 178 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{disableLookaside(pParse);}
#line 2394 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 12: /* ifnotexists ::= */
      case 32: /* autoinc ::= */ yytestcase(yyruleno==32);
      case 47: /* ifexists ::= */ yytestcase(yyruleno==47);
      case 60: /* distinct ::= */ yytestcase(yyruleno==60);
#line 181 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy60 = 0;}
#line 2402 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 13: /* ifnotexists ::= IF NOT EXISTS */
#line 182 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy60 = 1;}
#line 2407 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 14: /* engine_opts ::= ENGINE EQ STRING */
#line 189 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  /* Note that specifying engine clause overwrites default engine. */
  if (yymsp[0].minor.yy0.n > ENGINE_NAME_MAX) {
    diag_set(ClientError, ER_CREATE_SPACE,
             pParse->create_table_def.new_space->def->name,
             "space engine name is too long");
    pParse->is_aborted = true;
    return;
  }
  /* Need to dequote name. */
  char *normalized_name = sql_name_from_token(&yymsp[0].minor.yy0);
  memcpy(pParse->create_table_def.new_space->def->engine_name, normalized_name,
         strlen(normalized_name) + 1);
  sql_xfree(normalized_name);
}
#line 2426 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 15: /* create_table_end ::= */
#line 205 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ sqlEndTable(pParse); }
#line 2431 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 16: /* column_name_and_type ::= nm typedef */
#line 223 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_column_def_init(&pParse->create_column_def, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy338);
  sql_create_column_start(pParse);
}
#line 2439 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 17: /* create_column_end ::= autoinc */
#line 228 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  uint32_t fieldno = pParse->create_column_def.space->def->field_count - 1;
  if (yymsp[0].minor.yy60 == 1 && sql_add_autoincrement(pParse, fieldno) != 0)
    return;
  if (pParse->create_table_def.new_space == NULL)
    sql_create_column_end(pParse);
}
#line 2450 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 18: /* nm ::= ID|INDEXED */
#line 270 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  if(yymsp[0].minor.yy0.isReserved) {
    diag_set(ClientError, ER_SQL_KEYWORD_IS_RESERVED, pParse->line_count,
             pParse->line_pos, yymsp[0].minor.yy0.n, yymsp[0].minor.yy0.z, yymsp[0].minor.yy0.n, yymsp[0].minor.yy0.z);
    pParse->is_aborted = true;
  }
}
#line 2461 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 19: /* cconsname ::= CONSTRAINT nm */
#line 286 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-1].minor.yy487 = yymsp[0].minor.yy0; }
#line 2466 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 20: /* cconsname ::= */
#line 287 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[1].minor.yy487 = Token_nil; }
#line 2471 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 21: /* ccons ::= DEFAULT term */
      case 23: /* ccons ::= DEFAULT PLUS term */ yytestcase(yyruleno==23);
#line 288 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{sqlAddDefaultValue(pParse,&yymsp[0].minor.yy214);}
#line 2477 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 22: /* ccons ::= DEFAULT LP expr RP */
#line 289 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{sqlAddDefaultValue(pParse,&yymsp[-1].minor.yy214);}
#line 2482 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 24: /* ccons ::= DEFAULT MINUS term */
#line 291 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  ExprSpan v;
  v.pExpr = sqlPExpr(pParse, TK_UMINUS, yymsp[0].minor.yy214.pExpr, 0);
  v.zStart = yymsp[-1].minor.yy0.z;
  v.zEnd = yymsp[0].minor.yy214.zEnd;
  sqlAddDefaultValue(pParse,&v);
}
#line 2493 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 25: /* ccons ::= NULL onconf */
#line 302 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
    sql_column_add_nullable_action(pParse, ON_CONFLICT_ACTION_NONE);
    /* Trigger nullability mismatch error if required. */
    if (yymsp[0].minor.yy60 != ON_CONFLICT_ACTION_ABORT)
        sql_column_add_nullable_action(pParse, yymsp[0].minor.yy60);
}
#line 2503 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 26: /* ccons ::= NOT NULL onconf */
#line 308 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{sql_column_add_nullable_action(pParse, yymsp[0].minor.yy60);}
#line 2508 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 27: /* ccons ::= cconsname PRIMARY KEY sortorder */
#line 309 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_index_def_init(&pParse->create_index_def, NULL, &yymsp[-3].minor.yy487, NULL,
                        SQL_INDEX_TYPE_CONSTRAINT_PK, yymsp[0].minor.yy60, false);
  sqlAddPrimaryKey(pParse);
}
#line 2517 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 28: /* ccons ::= cconsname UNIQUE */
#line 314 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_index_def_init(&pParse->create_index_def, NULL, &yymsp[-1].minor.yy487, NULL,
                        SQL_INDEX_TYPE_CONSTRAINT_UNIQUE, SORT_ORDER_ASC,
                        false);
  sql_create_index(pParse);
}
#line 2527 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 29: /* ccons ::= cconsname CHECK LP expr RP */
#line 321 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_ck_def_init(&pParse->create_ck_def, NULL, &yymsp[-4].minor.yy487, &yymsp[-1].minor.yy214);
  sql_create_check_contraint(pParse, true);
}
#line 2535 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 30: /* ccons ::= cconsname REFERENCES nm eidlist_opt */
#line 326 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_fk_def_init(&pParse->create_fk_def, NULL, &yymsp[-3].minor.yy487, NULL, &yymsp[-1].minor.yy0, yymsp[0].minor.yy402);
  sql_create_foreign_key(pParse);
}
#line 2543 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 31: /* ccons ::= COLLATE ID|INDEXED */
#line 330 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{sqlAddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2548 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 33: /* autoinc ::= AUTOINCR */
#line 335 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = 1;}
#line 2553 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 34: /* tcons ::= cconsname PRIMARY KEY LP col_list_with_autoinc RP */
#line 338 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_index_def_init(&pParse->create_index_def, NULL, &yymsp[-5].minor.yy487, yymsp[-1].minor.yy402,
                        SQL_INDEX_TYPE_CONSTRAINT_PK, SORT_ORDER_ASC, false);
  sqlAddPrimaryKey(pParse);
}
#line 2562 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 35: /* tcons ::= cconsname UNIQUE LP sortlist RP */
#line 343 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_index_def_init(&pParse->create_index_def, NULL, &yymsp[-4].minor.yy487, yymsp[-1].minor.yy402,
                        SQL_INDEX_TYPE_CONSTRAINT_UNIQUE, SORT_ORDER_ASC,
                        false);
  sql_create_index(pParse);
}
#line 2572 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 36: /* tcons ::= cconsname CHECK LP expr RP */
#line 349 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_ck_def_init(&pParse->create_ck_def, NULL, &yymsp[-4].minor.yy487, &yymsp[-1].minor.yy214);
  sql_create_check_contraint(pParse, false);
}
#line 2580 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 37: /* tcons ::= cconsname FOREIGN KEY LP eidlist RP REFERENCES nm eidlist_opt */
#line 354 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_fk_def_init(&pParse->create_fk_def, NULL, &yymsp[-8].minor.yy487, yymsp[-4].minor.yy402, &yymsp[-1].minor.yy0, yymsp[0].minor.yy402);
  sql_create_foreign_key(pParse);
}
#line 2588 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 38: /* onconf ::= */
#line 366 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy60 = ON_CONFLICT_ACTION_ABORT;}
#line 2593 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 39: /* onconf ::= ON CONFLICT resolvetype */
#line 367 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy60 = yymsp[0].minor.yy60;}
#line 2598 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 40: /* orconf ::= */
#line 368 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy60 = ON_CONFLICT_ACTION_DEFAULT;}
#line 2603 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 41: /* orconf ::= OR resolvetype */
      case 117: /* insert_cmd ::= INSERT orconf */ yytestcase(yyruleno==117);
#line 369 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy60 = yymsp[0].minor.yy60;}
#line 2609 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 42: /* resolvetype ::= IGNORE */
#line 371 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = ON_CONFLICT_ACTION_IGNORE;}
#line 2614 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 43: /* resolvetype ::= REPLACE */
      case 118: /* insert_cmd ::= REPLACE */ yytestcase(yyruleno==118);
#line 372 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = ON_CONFLICT_ACTION_REPLACE;}
#line 2620 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 44: /* cmd ::= DROP TABLE ifexists fullname */
#line 377 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Token t = Token_nil;
  drop_table_def_init(&pParse->drop_table_def, yymsp[0].minor.yy291, &t, yymsp[-1].minor.yy60);
  pParse->initiateTTrans = true;
  sql_drop_table(pParse);
}
#line 2630 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 45: /* cmd ::= DROP VIEW ifexists fullname */
#line 384 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Token t = Token_nil;
  drop_view_def_init(&pParse->drop_view_def, yymsp[0].minor.yy291, &t, yymsp[-1].minor.yy60);
  pParse->initiateTTrans = true;
  sql_drop_table(pParse);
}
#line 2640 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 46: /* ifexists ::= IF EXISTS */
      case 181: /* between_op ::= NOT BETWEEN */ yytestcase(yyruleno==181);
      case 184: /* in_op ::= NOT IN */ yytestcase(yyruleno==184);
#line 392 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy60 = 1;}
#line 2647 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 48: /* cmd ::= createkw VIEW ifnotexists nm eidlist_opt AS select */
#line 398 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  if (!pParse->parse_only) {
    create_view_def_init(&pParse->create_view_def, &yymsp[-3].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-2].minor.yy402, yymsp[0].minor.yy331, yymsp[-4].minor.yy60);
    pParse->initiateTTrans = true;
    sql_create_view(pParse);
  } else {
    sql_store_select(pParse, yymsp[0].minor.yy331);
  }
}
#line 2660 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 49: /* cmd ::= select */
#line 410 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  SelectDest dest = {SRT_Output, 0, 0, 0, 0, 0, 0};
  if(pParse->parse_only) {
    diag_set(ClientError, ER_SQL_PARSER_GENERIC,
             "Failed to parse SQL expression");
    pParse->is_aborted = true;
    return;
  }
  sqlSelect(pParse, yymsp[0].minor.yy331, &dest);
  sql_select_delete(yymsp[0].minor.yy331);
}
#line 2675 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 50: /* select ::= with selectnowith */
#line 455 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  Select *p = yymsp[0].minor.yy331;
  if( p ){
    p->pWith = yymsp[-1].minor.yy227;
    parserDoubleLinkSelect(pParse, p);
  }else{
    sqlWithDelete(yymsp[-1].minor.yy227);
  }
  yymsp[-1].minor.yy331 = p; /*A-overwrites-W*/
}
#line 2689 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 51: /* selectnowith ::= selectnowith multiselect_op oneselect */
#line 468 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  Select *pRhs = yymsp[0].minor.yy331;
  Select *pLhs = yymsp[-2].minor.yy331;
  if( pRhs && pRhs->pPrior ){
    SrcList *pFrom;
    Token x;
    x.n = 0;
    parserDoubleLinkSelect(pParse, pRhs);
    pFrom = sqlSrcListAppendFromTerm(pParse,0,0,&x,pRhs,0,0,false);
    pRhs = sqlSelectNew(pParse,0,pFrom,0,0,0,0,0,0,0);
  }
  if( pRhs ){
    pRhs->op = (u8)yymsp[-1].minor.yy60;
    pRhs->pPrior = pLhs;
    if( ALWAYS(pLhs) ) pLhs->selFlags &= ~SF_MultiValue;
    pRhs->selFlags &= ~SF_MultiValue;
    if( yymsp[-1].minor.yy60!=TK_ALL ) pParse->hasCompound = 1;
  }else{
    sql_select_delete(pLhs);
  }
  yymsp[-2].minor.yy331 = pRhs;
}
#line 2715 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 52: /* multiselect_op ::= UNION */
      case 54: /* multiselect_op ::= EXCEPT|INTERSECT */ yytestcase(yyruleno==54);
#line 491 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = yymsp[0].major; /*A-overwrites-OP*/}
#line 2721 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 53: /* multiselect_op ::= UNION ALL */
#line 492 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy60 = TK_ALL;}
#line 2726 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 55: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 496 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
#ifdef SQL_DEBUG
  Token s = yymsp[-8].minor.yy0; /*A-overwrites-S*/
#endif
  yymsp[-8].minor.yy331 = sqlSelectNew(pParse,yymsp[-6].minor.yy402,yymsp[-5].minor.yy291,yymsp[-4].minor.yy386,yymsp[-3].minor.yy402,yymsp[-2].minor.yy386,yymsp[-1].minor.yy402,yymsp[-7].minor.yy60,yymsp[0].minor.yy212.pLimit,yymsp[0].minor.yy212.pOffset);
#ifdef SQL_DEBUG
  /* Populate the Select.zSelName[] string that is used to help with
  ** query planner debugging, to differentiate between multiple Select
  ** objects in a complex query.
  **
  ** If the SELECT keyword is immediately followed by a C-style comment
  ** then extract the first few alphanumeric characters from within that
  ** comment to be the zSelName value.  Otherwise, the label is #N where
  ** is an integer that is incremented with each SELECT statement seen.
  */
  if( yymsp[-8].minor.yy331!=0 ){
    const char *z = s.z+6;
    int i;
    sql_snprintf(sizeof(yymsp[-8].minor.yy331->zSelName), yymsp[-8].minor.yy331->zSelName, "#%d",
                     ++pParse->nSelect);
    while( z[0]==' ' ) z++;
    if( z[0]=='/' && z[1]=='*' ){
      z += 2;
      while( z[0]==' ' ) z++;
      for(i=0; sqlIsalnum(z[i]); i++){}
      sql_snprintf(sizeof(yymsp[-8].minor.yy331->zSelName), yymsp[-8].minor.yy331->zSelName, "%.*s", i, z);
    }
  }
#endif /* SQL_DEBUG */
}
#line 2760 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 56: /* values ::= VALUES LP nexprlist RP */
#line 530 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-3].minor.yy331 = sqlSelectNew(pParse,yymsp[-1].minor.yy402,0,0,0,0,0,SF_Values,0,0);
}
#line 2767 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 57: /* values ::= values COMMA LP exprlist RP */
#line 533 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  Select *pRight, *pLeft = yymsp[-4].minor.yy331;
  pRight = sqlSelectNew(pParse,yymsp[-1].minor.yy402,0,0,0,0,0,SF_Values|SF_MultiValue,0,0);
  if( ALWAYS(pLeft) ) pLeft->selFlags &= ~SF_MultiValue;
  if( pRight ){
    pRight->op = TK_ALL;
    pRight->pPrior = pLeft;
    yymsp[-4].minor.yy331 = pRight;
  }else{
    yymsp[-4].minor.yy331 = pLeft;
  }
}
#line 2783 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 58: /* distinct ::= DISTINCT */
#line 550 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = SF_Distinct;}
#line 2788 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 59: /* distinct ::= ALL */
#line 551 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = SF_All;}
#line 2793 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 61: /* sclp ::= */
      case 89: /* orderby_opt ::= */ yytestcase(yyruleno==89);
      case 98: /* groupby_opt ::= */ yytestcase(yyruleno==98);
      case 195: /* exprlist ::= */ yytestcase(yyruleno==195);
      case 198: /* paren_exprlist ::= */ yytestcase(yyruleno==198);
      case 203: /* eidlist_opt ::= */ yytestcase(yyruleno==203);
#line 564 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy402 = 0;}
#line 2803 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 62: /* selcollist ::= sclp expr as */
#line 565 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
   yymsp[-2].minor.yy402 = sql_expr_list_append(yymsp[-2].minor.yy402, yymsp[-1].minor.yy214.pExpr);
   if( yymsp[0].minor.yy0.n>0 ) sqlExprListSetName(pParse, yymsp[-2].minor.yy402, &yymsp[0].minor.yy0, 1);
   sqlExprListSetSpan(yymsp[-2].minor.yy402, &yymsp[-1].minor.yy214);
}
#line 2812 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 63: /* selcollist ::= sclp STAR */
#line 570 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-1].minor.yy402 = sql_expr_list_append(yymsp[-1].minor.yy402, sql_expr_new_anon(TK_ASTERISK));
}
#line 2819 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 64: /* selcollist ::= sclp nm DOT STAR */
#line 573 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Expr *pLeft = sql_expr_new_dequoted(TK_ID, &yymsp[-2].minor.yy0);
  Expr *pRight = sqlPExpr(pParse, TK_ASTERISK, 0, 0);
  Expr *pDot = sqlPExpr(pParse, TK_DOT, pLeft, pRight);
  yymsp[-3].minor.yy402 = sql_expr_list_append(yymsp[-3].minor.yy402, pDot);
}
#line 2829 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 65: /* as ::= AS nm */
#line 584 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy0 = yymsp[0].minor.yy0;}
#line 2834 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 66: /* as ::= */
#line 586 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy0.n = 0; yymsp[1].minor.yy0.z = 0;}
#line 2839 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 67: /* seqscan ::= SEQSCAN */
      case 180: /* between_op ::= BETWEEN */ yytestcase(yyruleno==180);
      case 183: /* in_op ::= IN */ yytestcase(yyruleno==183);
#line 589 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = 0;}
#line 2846 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 68: /* seqscan ::= */
#line 590 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy60 = 1;}
#line 2851 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 69: /* from ::= */
#line 601 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy291 = sql_xmalloc0(sizeof(*yymsp[1].minor.yy291));}
#line 2856 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 70: /* from ::= FROM seltablist */
#line 602 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-1].minor.yy291 = yymsp[0].minor.yy291;
  sqlSrcListShiftJoinType(yymsp[-1].minor.yy291);
}
#line 2864 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 71: /* stl_prefix ::= seltablist joinop */
#line 610 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
   if( ALWAYS(yymsp[-1].minor.yy291 && yymsp[-1].minor.yy291->nSrc>0) ) yymsp[-1].minor.yy291->a[yymsp[-1].minor.yy291->nSrc-1].fg.jointype = (u8)yymsp[0].minor.yy60;
}
#line 2871 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 72: /* stl_prefix ::= */
#line 613 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy291 = 0;}
#line 2876 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 73: /* seltablist ::= stl_prefix seqscan nm as indexed_opt on_opt using_opt */
#line 615 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-6].minor.yy291 = sqlSrcListAppendFromTerm(pParse,yymsp[-6].minor.yy291,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,0,yymsp[-1].minor.yy386,yymsp[0].minor.yy272,yymsp[-5].minor.yy60);
  sqlSrcListIndexedBy(yymsp[-6].minor.yy291, &yymsp[-2].minor.yy0);
}
#line 2884 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 74: /* seltablist ::= stl_prefix seqscan nm LP exprlist RP as on_opt using_opt */
#line 620 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-8].minor.yy291 = sqlSrcListAppendFromTerm(pParse,yymsp[-8].minor.yy291,&yymsp[-6].minor.yy0,&yymsp[-2].minor.yy0,0,yymsp[-1].minor.yy386,yymsp[0].minor.yy272,yymsp[-7].minor.yy60);
  sqlSrcListFuncArgs(yymsp[-8].minor.yy291, yymsp[-4].minor.yy402);
}
#line 2892 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 75: /* seltablist ::= stl_prefix LP select RP as on_opt using_opt */
#line 625 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-6].minor.yy291 = sqlSrcListAppendFromTerm(pParse,yymsp[-6].minor.yy291,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy331,yymsp[-1].minor.yy386,yymsp[0].minor.yy272,false);
}
#line 2899 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 76: /* seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt */
#line 629 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  if( yymsp[-6].minor.yy291==0 && yymsp[-2].minor.yy0.n==0 && yymsp[-1].minor.yy386==0 && yymsp[0].minor.yy272==0 ){
    yymsp[-6].minor.yy291 = yymsp[-4].minor.yy291;
  }else if( yymsp[-4].minor.yy291->nSrc==1 ){
    yymsp[-6].minor.yy291 = sqlSrcListAppendFromTerm(pParse,yymsp[-6].minor.yy291,0,&yymsp[-2].minor.yy0,0,yymsp[-1].minor.yy386,yymsp[0].minor.yy272,false);
    if( yymsp[-6].minor.yy291 ){
      struct SrcList_item *pNew = &yymsp[-6].minor.yy291->a[yymsp[-6].minor.yy291->nSrc-1];
      struct SrcList_item *pOld = yymsp[-4].minor.yy291->a;
      pNew->zName = pOld->zName;
      pNew->pSelect = pOld->pSelect;
      pOld->zName =  0;
      pOld->pSelect = 0;
    }
    sqlSrcListDelete(yymsp[-4].minor.yy291);
  }else{
    Select *pSubquery;
    sqlSrcListShiftJoinType(yymsp[-4].minor.yy291);
    pSubquery = sqlSelectNew(pParse,0,yymsp[-4].minor.yy291,0,0,0,0,SF_NestedFrom,0,0);
    yymsp[-6].minor.yy291 = sqlSrcListAppendFromTerm(pParse,yymsp[-6].minor.yy291,0,&yymsp[-2].minor.yy0,pSubquery,yymsp[-1].minor.yy386,yymsp[0].minor.yy272,false);
  }
}
#line 2924 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 77: /* fullname ::= nm */
#line 653 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  /* yylhsminor.yy291-overwrites-yymsp[0].minor.yy0. */
  yylhsminor.yy291 = sql_src_list_append(NULL ,&yymsp[0].minor.yy0);
}
#line 2932 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy291 = yylhsminor.yy291;
        break;
      case 78: /* joinop ::= COMMA|JOIN */
#line 662 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy60 = JT_INNER; }
#line 2938 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 79: /* joinop ::= JOIN_KW JOIN */
#line 664 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy60 = sqlJoinType(pParse,&yymsp[-1].minor.yy0,0,0);  /*X-overwrites-A*/}
#line 2943 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 80: /* joinop ::= JOIN_KW join_nm JOIN */
#line 666 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy60 = sqlJoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); /*X-overwrites-A*/}
#line 2948 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 81: /* joinop ::= JOIN_KW join_nm join_nm JOIN */
#line 668 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-3].minor.yy60 = sqlJoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0);/*X-overwrites-A*/}
#line 2953 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 82: /* on_opt ::= ON expr */
      case 101: /* having_opt ::= HAVING expr */ yytestcase(yyruleno==101);
      case 109: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==109);
      case 193: /* case_else ::= ELSE expr */ yytestcase(yyruleno==193);
#line 672 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy386 = yymsp[0].minor.yy214.pExpr;}
#line 2961 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 83: /* on_opt ::= */
      case 100: /* having_opt ::= */ yytestcase(yyruleno==100);
      case 108: /* where_opt ::= */ yytestcase(yyruleno==108);
      case 194: /* case_else ::= */ yytestcase(yyruleno==194);
#line 673 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy386 = 0;}
#line 2969 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 84: /* indexed_opt ::= */
#line 686 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy0.z=0; yymsp[1].minor.yy0.n=0;}
#line 2974 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 85: /* indexed_opt ::= INDEXED BY nm */
#line 687 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy0 = yymsp[0].minor.yy0;}
#line 2979 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 86: /* indexed_opt ::= NOT INDEXED */
#line 688 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy0.z=0; yymsp[-1].minor.yy0.n=1;}
#line 2984 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 87: /* using_opt ::= USING LP idlist RP */
#line 692 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-3].minor.yy272 = yymsp[-1].minor.yy272;}
#line 2989 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 88: /* using_opt ::= */
      case 119: /* idlist_opt ::= */ yytestcase(yyruleno==119);
#line 693 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy272 = 0;}
#line 2995 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 90: /* orderby_opt ::= ORDER BY sortlist */
      case 99: /* groupby_opt ::= GROUP BY nexprlist */ yytestcase(yyruleno==99);
#line 707 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy402 = yymsp[0].minor.yy402;}
#line 3001 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 91: /* sortlist ::= sortlist COMMA expr sortorder */
#line 708 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-3].minor.yy402 = sql_expr_list_append(yymsp[-3].minor.yy402, yymsp[-1].minor.yy214.pExpr);
  sqlExprListSetSortOrder(yymsp[-3].minor.yy402,yymsp[0].minor.yy60);
}
#line 3009 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 92: /* sortlist ::= expr sortorder */
#line 712 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  /* yylhsminor.yy402-overwrites-yymsp[-1].minor.yy214. */
  yylhsminor.yy402 = sql_expr_list_append(NULL, yymsp[-1].minor.yy214.pExpr);
  sqlExprListSetSortOrder(yylhsminor.yy402,yymsp[0].minor.yy60);
}
#line 3018 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-1].minor.yy402 = yylhsminor.yy402;
        break;
      case 93: /* col_list_with_autoinc ::= col_list_with_autoinc COMMA expr autoinc */
#line 726 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  uint32_t fieldno;
  if (yymsp[0].minor.yy60 == 1) {
    if (sql_fieldno_by_name(pParse, yymsp[-1].minor.yy214.pExpr, &fieldno) != 0)
      return;
    if (sql_add_autoincrement(pParse, fieldno) != 0)
      return;
  }
  yymsp[-3].minor.yy402 = sql_expr_list_append(yymsp[-3].minor.yy402, yymsp[-1].minor.yy214.pExpr);
}
#line 3033 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 94: /* col_list_with_autoinc ::= expr autoinc */
#line 737 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  if (yymsp[0].minor.yy60 == 1) {
    uint32_t fieldno = 0;
    if (sql_fieldno_by_name(pParse, yymsp[-1].minor.yy214.pExpr, &fieldno) != 0)
      return;
    if (sql_add_autoincrement(pParse, fieldno) != 0)
      return;
  }
  /* yylhsminor.yy402-overwrites-yymsp[-1].minor.yy214. */
  yylhsminor.yy402 = sql_expr_list_append(NULL, yymsp[-1].minor.yy214.pExpr);
}
#line 3048 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-1].minor.yy402 = yylhsminor.yy402;
        break;
      case 95: /* sortorder ::= ASC */
#line 751 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = SORT_ORDER_ASC;}
#line 3054 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 96: /* sortorder ::= DESC */
#line 752 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = SORT_ORDER_DESC;}
#line 3059 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 97: /* sortorder ::= */
#line 753 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy60 = SORT_ORDER_UNDEF;}
#line 3064 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 102: /* limit_opt ::= */
#line 778 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy212.pLimit = 0; yymsp[1].minor.yy212.pOffset = 0;}
#line 3069 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 103: /* limit_opt ::= LIMIT expr */
#line 779 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy212.pLimit = yymsp[0].minor.yy214.pExpr; yymsp[-1].minor.yy212.pOffset = 0;}
#line 3074 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 104: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 781 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-3].minor.yy212.pLimit = yymsp[-2].minor.yy214.pExpr; yymsp[-3].minor.yy212.pOffset = yymsp[0].minor.yy214.pExpr;}
#line 3079 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 105: /* limit_opt ::= LIMIT expr COMMA expr */
#line 783 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-3].minor.yy212.pOffset = yymsp[-2].minor.yy214.pExpr; yymsp[-3].minor.yy212.pLimit = yymsp[0].minor.yy214.pExpr;}
#line 3084 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 106: /* cmd ::= with DELETE FROM fullname indexed_opt where_opt */
#line 787 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  sqlWithPush(pParse, yymsp[-5].minor.yy227, 1);
  sqlSrcListIndexedBy(yymsp[-2].minor.yy291, &yymsp[-1].minor.yy0);
  sqlSubProgramsRemaining = SQL_MAX_COMPILING_TRIGGERS;
  /* Instruct SQL to initate Tarantool's transaction.  */
  pParse->initiateTTrans = true;
  sql_table_delete_from(pParse,yymsp[-2].minor.yy291,yymsp[0].minor.yy386);
}
#line 3096 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 107: /* cmd ::= TRUNCATE TABLE fullname */
#line 798 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  pParse->initiateTTrans = true;
  sql_table_truncate(pParse, yymsp[0].minor.yy291);
}
#line 3104 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 110: /* cmd ::= with UPDATE orconf fullname indexed_opt SET setlist where_opt */
#line 812 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  sqlWithPush(pParse, yymsp[-7].minor.yy227, 1);
  sqlSrcListIndexedBy(yymsp[-4].minor.yy291, &yymsp[-3].minor.yy0);
  if (yymsp[-1].minor.yy402 != NULL && yymsp[-1].minor.yy402->nExpr > SQL_MAX_COLUMN) {
    diag_set(ClientError, ER_SQL_PARSER_LIMIT, "The number of columns in set "\
             "list", yymsp[-1].minor.yy402->nExpr, SQL_MAX_COLUMN);
    pParse->is_aborted = true;
  }
  sqlSubProgramsRemaining = SQL_MAX_COMPILING_TRIGGERS;
  /* Instruct SQL to initate Tarantool's transaction.  */
  pParse->initiateTTrans = true;
  sqlUpdate(pParse,yymsp[-4].minor.yy291,yymsp[-1].minor.yy402,yymsp[0].minor.yy386,yymsp[-5].minor.yy60);
}
#line 3121 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 111: /* setlist ::= setlist COMMA nm EQ expr */
#line 829 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-4].minor.yy402 = sql_expr_list_append(yymsp[-4].minor.yy402, yymsp[0].minor.yy214.pExpr);
  sqlExprListSetName(pParse, yymsp[-4].minor.yy402, &yymsp[-2].minor.yy0, 1);
}
#line 3129 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 112: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
#line 833 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-6].minor.yy402 = sqlExprListAppendVector(pParse, yymsp[-6].minor.yy402, yymsp[-3].minor.yy272, yymsp[0].minor.yy214.pExpr);
}
#line 3136 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 113: /* setlist ::= nm EQ expr */
#line 836 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy402 = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr);
  sqlExprListSetName(pParse, yylhsminor.yy402, &yymsp[-2].minor.yy0, 1);
}
#line 3144 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-2].minor.yy402 = yylhsminor.yy402;
        break;
      case 114: /* setlist ::= LP idlist RP EQ expr */
#line 840 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-4].minor.yy402 = sqlExprListAppendVector(pParse, 0, yymsp[-3].minor.yy272, yymsp[0].minor.yy214.pExpr);
}
#line 3152 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 115: /* cmd ::= with insert_cmd INTO fullname idlist_opt select */
#line 846 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  sqlWithPush(pParse, yymsp[-5].minor.yy227, 1);
  sqlSubProgramsRemaining = SQL_MAX_COMPILING_TRIGGERS;
  /* Instruct SQL to initate Tarantool's transaction.  */
  pParse->initiateTTrans = true;
  sqlInsert(pParse, yymsp[-2].minor.yy291, yymsp[0].minor.yy331, yymsp[-1].minor.yy272, yymsp[-4].minor.yy60);
}
#line 3163 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 116: /* cmd ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES */
#line 854 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  sqlWithPush(pParse, yymsp[-6].minor.yy227, 1);
  sqlSubProgramsRemaining = SQL_MAX_COMPILING_TRIGGERS;
  /* Instruct SQL to initate Tarantool's transaction.  */
  pParse->initiateTTrans = true;
  sqlInsert(pParse, yymsp[-3].minor.yy291, 0, yymsp[-2].minor.yy272, yymsp[-5].minor.yy60);
}
#line 3174 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 120: /* idlist_opt ::= LP idlist RP */
#line 872 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy272 = yymsp[-1].minor.yy272;}
#line 3179 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 121: /* idlist ::= idlist COMMA nm */
#line 873 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-2].minor.yy272 = sql_id_list_append(yymsp[-2].minor.yy272, &yymsp[0].minor.yy0);
}
#line 3186 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 122: /* idlist ::= nm */
#line 876 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  /* yylhsminor.yy272-overwrites-yymsp[0].minor.yy0. */
  yylhsminor.yy272 = sql_id_list_append(NULL, &yymsp[0].minor.yy0);
}
#line 3194 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy272 = yylhsminor.yy272;
        break;
      case 123: /* expr ::= LP expr RP */
#line 956 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanSet(&yymsp[-2].minor.yy214,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); /*A-overwrites-B*/  yymsp[-2].minor.yy214.pExpr = yymsp[-1].minor.yy214.pExpr;}
#line 3200 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 124: /* term ::= NULL */
      case 128: /* term ::= FLOAT|BLOB */ yytestcase(yyruleno==128);
      case 129: /* term ::= STRING */ yytestcase(yyruleno==129);
      case 130: /* term ::= FALSE */ yytestcase(yyruleno==130);
      case 131: /* term ::= TRUE */ yytestcase(yyruleno==131);
      case 132: /* term ::= UNKNOWN */ yytestcase(yyruleno==132);
      case 133: /* term ::= DECIMAL */ yytestcase(yyruleno==133);
#line 957 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanExpr(&yymsp[0].minor.yy214, yymsp[0].major, yymsp[0].minor.yy0);/*A-overwrites-X*/}
#line 3211 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 125: /* expr ::= ID|INDEXED */
      case 126: /* expr ::= JOIN_KW */ yytestcase(yyruleno==126);
#line 958 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanExpr(&yymsp[0].minor.yy214, TK_ID, yymsp[0].minor.yy0); /*A-overwrites-X*/}
#line 3217 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 127: /* expr ::= nm DOT nm */
#line 960 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Expr *temp1 = sql_expr_new_dequoted(TK_ID, &yymsp[-2].minor.yy0);
  struct Expr *temp2 = sql_expr_new_dequoted(TK_ID, &yymsp[0].minor.yy0);
  spanSet(&yymsp[-2].minor.yy214,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); /*A-overwrites-X*/
  yymsp[-2].minor.yy214.pExpr = sqlPExpr(pParse, TK_DOT, temp1, temp2);
}
#line 3227 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 134: /* term ::= INTEGER */
#line 973 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy214.pExpr = sql_expr_new_dequoted(TK_INTEGER, &yymsp[0].minor.yy0);
  yylhsminor.yy214.pExpr->type = FIELD_TYPE_INTEGER;
  yylhsminor.yy214.zStart = yymsp[0].minor.yy0.z;
  yylhsminor.yy214.zEnd = yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n;
  if( yylhsminor.yy214.pExpr ) yylhsminor.yy214.pExpr->flags |= EP_Leaf;
}
#line 3238 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy214 = yylhsminor.yy214;
        break;
      case 135: /* expr ::= VARNUM */
#line 980 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy214.pExpr = expr_new_variable(pParse, &yymsp[0].minor.yy0, NULL);
  spanSet(&yylhsminor.yy214, &yymsp[0].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3247 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy214 = yylhsminor.yy214;
        break;
      case 136: /* expr ::= COLON|VARIABLE ID|INDEXED */
      case 137: /* expr ::= COLON|VARIABLE INTEGER */ yytestcase(yyruleno==137);
#line 984 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy214.pExpr = expr_new_variable(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);
  spanSet(&yylhsminor.yy214, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3257 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-1].minor.yy214 = yylhsminor.yy214;
        break;
      case 138: /* expr ::= expr COLLATE ID|INDEXED */
#line 992 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-2].minor.yy214.pExpr = sqlExprAddCollateToken(yymsp[-2].minor.yy214.pExpr, &yymsp[0].minor.yy0, 1);
  yymsp[-2].minor.yy214.zEnd = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n];
}
#line 3266 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 139: /* expr ::= CAST LP expr AS typedef RP */
#line 997 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  spanSet(&yymsp[-5].minor.yy214,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0); /*A-overwrites-X*/
  yymsp[-5].minor.yy214.pExpr = sql_expr_new_dequoted(TK_CAST, NULL);
  yymsp[-5].minor.yy214.pExpr->type = yymsp[-1].minor.yy338.type;
  sqlExprAttachSubtrees(yymsp[-5].minor.yy214.pExpr, yymsp[-3].minor.yy214.pExpr, 0);
}
#line 3276 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 140: /* expr ::= expr LB getlist RB */
#line 1004 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Expr *expr = sql_expr_new_anon(TK_GETITEM);
  yymsp[-1].minor.yy190 = sql_expr_list_append(yymsp[-1].minor.yy190, yymsp[-3].minor.yy214.pExpr);
  expr->x.pList = yymsp[-1].minor.yy190;
  expr->type = FIELD_TYPE_ANY;
  sqlExprSetHeightAndFlags(pParse, expr);
  yylhsminor.yy214.pExpr = expr;
  yylhsminor.yy214.zStart = yymsp[-3].minor.yy214.zStart;
  yylhsminor.yy214.zEnd = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n];
}
#line 3290 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-3].minor.yy214 = yylhsminor.yy214;
        break;
      case 141: /* getlist ::= getlist RB LB expr */
#line 1015 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-3].minor.yy190 = sql_expr_list_append(yymsp[-3].minor.yy190, yymsp[0].minor.yy214.pExpr);
}
#line 3298 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 142: /* getlist ::= expr */
#line 1018 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy190 = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr);
}
#line 3305 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy190 = yylhsminor.yy190;
        break;
      case 143: /* expr ::= LB exprlist RB */
#line 1025 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Expr *expr = sql_expr_new_anon(TK_ARRAY);
  expr->x.pList = yymsp[-1].minor.yy402;
  expr->type = FIELD_TYPE_ARRAY;
  sqlExprSetHeightAndFlags(pParse, expr);
  yylhsminor.yy214.pExpr = expr;
  spanSet(&yylhsminor.yy214, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3318 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-2].minor.yy214 = yylhsminor.yy214;
        break;
      case 144: /* expr ::= LCB maplist RCB */
#line 1034 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Expr *expr = sql_expr_new_anon(TK_MAP);
  expr->x.pList = yymsp[-1].minor.yy190;
  expr->type = FIELD_TYPE_MAP;
  sqlExprSetHeightAndFlags(pParse, expr);
  yylhsminor.yy214.pExpr = expr;
  spanSet(&yylhsminor.yy214, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3331 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-2].minor.yy214 = yylhsminor.yy214;
        break;
      case 145: /* maplist ::= */
#line 1044 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[1].minor.yy190 = NULL;
}
#line 3339 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 146: /* nmaplist ::= nmaplist COMMA expr COLON expr */
#line 1047 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-4].minor.yy190 = sql_expr_list_append(yymsp[-4].minor.yy190, yymsp[-2].minor.yy214.pExpr);
  yymsp[-4].minor.yy190 = sql_expr_list_append(yymsp[-4].minor.yy190, yymsp[0].minor.yy214.pExpr);
}
#line 3347 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 147: /* nmaplist ::= expr COLON expr */
#line 1051 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy190 = sql_expr_list_append(NULL, yymsp[-2].minor.yy214.pExpr);
  yylhsminor.yy190 = sql_expr_list_append(yylhsminor.yy190, yymsp[0].minor.yy214.pExpr);
}
#line 3355 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-2].minor.yy190 = yylhsminor.yy190;
        break;
      case 148: /* expr ::= TRIM LP trim_operands RP */
#line 1061 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy214.pExpr = sqlExprFunction(pParse, yymsp[-1].minor.yy215, &yymsp[-3].minor.yy0);
  spanSet(&yylhsminor.yy214, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3364 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-3].minor.yy214 = yylhsminor.yy214;
        break;
      case 149: /* trim_operands ::= trim_specification expr FROM expr */
#line 1069 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy215 = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr);
  struct Expr *p = sql_expr_new_dequoted(TK_INTEGER, &sqlIntTokens[yymsp[-3].minor.yy301]);
  yylhsminor.yy215 = sql_expr_list_append(yylhsminor.yy215, p);
  yylhsminor.yy215 = sql_expr_list_append(yylhsminor.yy215, yymsp[-2].minor.yy214.pExpr);
}
#line 3375 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-3].minor.yy215 = yylhsminor.yy215;
        break;
      case 150: /* trim_operands ::= trim_specification FROM expr */
#line 1076 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy215 = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr);
  struct Expr *p = sql_expr_new_dequoted(TK_INTEGER, &sqlIntTokens[yymsp[-2].minor.yy301]);
  yylhsminor.yy215 = sql_expr_list_append(yylhsminor.yy215, p);
}
#line 3385 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-2].minor.yy215 = yylhsminor.yy215;
        break;
      case 151: /* trim_operands ::= expr FROM expr */
#line 1082 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy215 = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr);
  struct Expr *p = sql_expr_new_dequoted(TK_INTEGER, &sqlIntTokens[TRIM_BOTH]);
  yylhsminor.yy215 = sql_expr_list_append(yylhsminor.yy215, p);
  yylhsminor.yy215 = sql_expr_list_append(yylhsminor.yy215, yymsp[-2].minor.yy214.pExpr);
}
#line 3396 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-2].minor.yy215 = yylhsminor.yy215;
        break;
      case 152: /* trim_operands ::= expr */
#line 1089 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy215 = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr);
  struct Expr *p = sql_expr_new_dequoted(TK_INTEGER, &sqlIntTokens[TRIM_BOTH]);
  yylhsminor.yy215 = sql_expr_list_append(yylhsminor.yy215, p);
}
#line 3406 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy215 = yylhsminor.yy215;
        break;
      case 153: /* expr_optional ::= */
#line 1098 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[1].minor.yy407 = NULL; }
#line 3412 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 154: /* expr_optional ::= expr */
#line 1099 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yylhsminor.yy407 = yymsp[0].minor.yy214.pExpr; }
#line 3417 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy407 = yylhsminor.yy407;
        break;
      case 155: /* trim_specification ::= LEADING */
#line 1103 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy301 = TRIM_LEADING; }
#line 3423 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 156: /* trim_specification ::= TRAILING */
#line 1104 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy301 = TRIM_TRAILING; }
#line 3428 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 157: /* trim_specification ::= BOTH */
#line 1105 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy301 = TRIM_BOTH; }
#line 3433 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 158: /* expr ::= ID|INDEXED LP distinct exprlist RP */
      case 159: /* expr ::= type_func LP distinct exprlist RP */ yytestcase(yyruleno==159);
#line 1107 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  if (yymsp[-1].minor.yy402 != NULL && yymsp[-1].minor.yy402->nExpr > SQL_MAX_FUNCTION_ARG){
    const char *err =
      tt_sprintf("Number of arguments to function %.*s", yymsp[-4].minor.yy0.n, yymsp[-4].minor.yy0.z);
    diag_set(ClientError, ER_SQL_PARSER_LIMIT, err, yymsp[-1].minor.yy402->nExpr,
             SQL_MAX_FUNCTION_ARG);
    pParse->is_aborted = true;
  }
  yylhsminor.yy214.pExpr = sqlExprFunction(pParse, yymsp[-1].minor.yy402, &yymsp[-4].minor.yy0);
  spanSet(&yylhsminor.yy214,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy60==SF_Distinct && yylhsminor.yy214.pExpr ){
    yylhsminor.yy214.pExpr->flags |= EP_Distinct;
  }
}
#line 3452 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-4].minor.yy214 = yylhsminor.yy214;
        break;
      case 160: /* expr ::= ID|INDEXED LP STAR RP */
#line 1142 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy214.pExpr = sqlExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  spanSet(&yylhsminor.yy214,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3461 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-3].minor.yy214 = yylhsminor.yy214;
        break;
      case 161: /* expr ::= LP nexprlist COMMA expr RP */
#line 1177 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  ExprList *pList = sql_expr_list_append(yymsp[-3].minor.yy402, yymsp[-1].minor.yy214.pExpr);
  yylhsminor.yy214.pExpr = sqlPExpr(pParse, TK_VECTOR, 0, 0);
  if( yylhsminor.yy214.pExpr ){
    yylhsminor.yy214.pExpr->x.pList = pList;
    spanSet(&yylhsminor.yy214, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
  }else{
    sql_expr_list_delete(pList);
  }
}
#line 3476 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-4].minor.yy214 = yylhsminor.yy214;
        break;
      case 162: /* expr ::= expr AND expr */
      case 163: /* expr ::= expr OR expr */ yytestcase(yyruleno==163);
      case 164: /* expr ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==164);
      case 165: /* expr ::= expr EQ|NE expr */ yytestcase(yyruleno==165);
      case 166: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==166);
      case 167: /* expr ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==167);
      case 168: /* expr ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==168);
      case 169: /* expr ::= expr CONCAT expr */ yytestcase(yyruleno==169);
#line 1188 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanBinaryExpr(pParse,yymsp[-1].major,&yymsp[-2].minor.yy214,&yymsp[0].minor.yy214);}
#line 3489 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 170: /* likeop ::= LIKE_KW|MATCH */
#line 1201 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy0=yymsp[0].minor.yy0;/*A-overwrites-X*/}
#line 3494 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 171: /* likeop ::= NOT LIKE_KW|MATCH */
#line 1202 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-1].minor.yy0=yymsp[0].minor.yy0; yymsp[-1].minor.yy0.n|=0x80000000; /*yymsp[-1].minor.yy0-overwrite-yymsp[0].minor.yy0*/}
#line 3499 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 172: /* expr ::= expr likeop expr */
#line 1203 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  ExprList *pList;
  int bNot = yymsp[-1].minor.yy0.n & 0x80000000;
  yymsp[-1].minor.yy0.n &= 0x7fffffff;
  pList = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr);
  pList = sql_expr_list_append(pList, yymsp[-2].minor.yy214.pExpr);
  yymsp[-2].minor.yy214.pExpr = sqlExprFunction(pParse, pList, &yymsp[-1].minor.yy0);
  exprNot(pParse, bNot, &yymsp[-2].minor.yy214);
  yymsp[-2].minor.yy214.zEnd = yymsp[0].minor.yy214.zEnd;
  if( yymsp[-2].minor.yy214.pExpr ) yymsp[-2].minor.yy214.pExpr->flags |= EP_InfixFunc;
}
#line 3514 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 173: /* expr ::= expr likeop expr ESCAPE expr */
#line 1214 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  ExprList *pList;
  int bNot = yymsp[-3].minor.yy0.n & 0x80000000;
  yymsp[-3].minor.yy0.n &= 0x7fffffff;
  pList = sql_expr_list_append(NULL, yymsp[-2].minor.yy214.pExpr);
  pList = sql_expr_list_append(pList, yymsp[-4].minor.yy214.pExpr);
  pList = sql_expr_list_append(pList, yymsp[0].minor.yy214.pExpr);
  yymsp[-4].minor.yy214.pExpr = sqlExprFunction(pParse, pList, &yymsp[-3].minor.yy0);
  exprNot(pParse, bNot, &yymsp[-4].minor.yy214);
  yymsp[-4].minor.yy214.zEnd = yymsp[0].minor.yy214.zEnd;
  if( yymsp[-4].minor.yy214.pExpr ) yymsp[-4].minor.yy214.pExpr->flags |= EP_InfixFunc;
}
#line 3530 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 174: /* expr ::= expr IS NULL */
#line 1244 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanUnaryPostfix(pParse,TK_ISNULL,&yymsp[-2].minor.yy214,&yymsp[0].minor.yy0);}
#line 3535 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 175: /* expr ::= expr IS NOT NULL */
#line 1245 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanUnaryPostfix(pParse,TK_NOTNULL,&yymsp[-3].minor.yy214,&yymsp[0].minor.yy0);}
#line 3540 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 176: /* expr ::= NOT expr */
      case 177: /* expr ::= BITNOT expr */ yytestcase(yyruleno==177);
#line 1267 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanUnaryPrefix(&yymsp[-1].minor.yy214,pParse,yymsp[-1].major,&yymsp[0].minor.yy214,&yymsp[-1].minor.yy0);/*A-overwrites-B*/}
#line 3546 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 178: /* expr ::= MINUS expr */
#line 1271 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanUnaryPrefix(&yymsp[-1].minor.yy214,pParse,TK_UMINUS,&yymsp[0].minor.yy214,&yymsp[-1].minor.yy0);/*A-overwrites-B*/}
#line 3551 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 179: /* expr ::= PLUS expr */
#line 1273 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{spanUnaryPrefix(&yymsp[-1].minor.yy214,pParse,TK_UPLUS,&yymsp[0].minor.yy214,&yymsp[-1].minor.yy0);/*A-overwrites-B*/}
#line 3556 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 182: /* expr ::= expr between_op expr AND expr */
#line 1278 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  ExprList *pList = sql_expr_list_append(NULL, yymsp[-2].minor.yy214.pExpr);
  pList = sql_expr_list_append(pList, yymsp[0].minor.yy214.pExpr);
  yymsp[-4].minor.yy214.pExpr = sqlPExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy214.pExpr, 0);
  if( yymsp[-4].minor.yy214.pExpr ){
    yymsp[-4].minor.yy214.pExpr->x.pList = pList;
  }else{
    sql_expr_list_delete(pList);
  } 
  exprNot(pParse, yymsp[-3].minor.yy60, &yymsp[-4].minor.yy214);
  yymsp[-4].minor.yy214.zEnd = yymsp[0].minor.yy214.zEnd;
}
#line 3572 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 185: /* expr ::= expr in_op LP exprlist RP */
#line 1293 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  if( yymsp[-1].minor.yy402==0 ){
    /* Expressions of the form
    **
    **      expr1 IN ()
    **      expr1 NOT IN ()
    **
    ** simplify to constants 0 (false) and 1 (true), respectively,
    ** regardless of the value of expr1.
    */
    sql_expr_delete(yymsp[-4].minor.yy214.pExpr);
    int tk = yymsp[-3].minor.yy60 == 0 ? TK_FALSE : TK_TRUE;
    yymsp[-4].minor.yy214.pExpr = sql_expr_new_anon(tk);
    yymsp[-4].minor.yy214.pExpr->type = FIELD_TYPE_BOOLEAN;
  }else if( yymsp[-1].minor.yy402->nExpr==1 ){
    /* Expressions of the form:
    **
    **      expr1 IN (?1)
    **      expr1 NOT IN (?2)
    **
    ** with exactly one value on the RHS can be simplified to something
    ** like this:
    **
    **      expr1 == ?1
    **      expr1 <> ?2
    */
    Expr *pRHS = yymsp[-1].minor.yy402->a[0].pExpr;
    yymsp[-1].minor.yy402->a[0].pExpr = 0;
    sql_expr_list_delete(yymsp[-1].minor.yy402);
    yymsp[-4].minor.yy214.pExpr = sqlPExpr(pParse, yymsp[-3].minor.yy60 ? TK_NE : TK_EQ, yymsp[-4].minor.yy214.pExpr, pRHS);
  }else{
    yymsp[-4].minor.yy214.pExpr = sqlPExpr(pParse, TK_IN, yymsp[-4].minor.yy214.pExpr, 0);
    if( yymsp[-4].minor.yy214.pExpr ){
      yymsp[-4].minor.yy214.pExpr->x.pList = yymsp[-1].minor.yy402;
      sqlExprSetHeightAndFlags(pParse, yymsp[-4].minor.yy214.pExpr);
    }else{
      sql_expr_list_delete(yymsp[-1].minor.yy402);
    }
    exprNot(pParse, yymsp[-3].minor.yy60, &yymsp[-4].minor.yy214);
  }
  yymsp[-4].minor.yy214.zEnd = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n];
}
#line 3618 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 186: /* expr ::= LP select RP */
#line 1335 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  spanSet(&yymsp[-2].minor.yy214,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); /*A-overwrites-B*/
  yymsp[-2].minor.yy214.pExpr = sqlPExpr(pParse, TK_SELECT, 0, 0);
  sqlPExprAddSelect(pParse, yymsp[-2].minor.yy214.pExpr, yymsp[-1].minor.yy331);
}
#line 3627 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 187: /* expr ::= expr in_op LP select RP */
#line 1340 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-4].minor.yy214.pExpr = sqlPExpr(pParse, TK_IN, yymsp[-4].minor.yy214.pExpr, 0);
  sqlPExprAddSelect(pParse, yymsp[-4].minor.yy214.pExpr, yymsp[-1].minor.yy331);
  exprNot(pParse, yymsp[-3].minor.yy60, &yymsp[-4].minor.yy214);
  yymsp[-4].minor.yy214.zEnd = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n];
}
#line 3637 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 188: /* expr ::= expr in_op nm paren_exprlist */
#line 1346 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct SrcList *pSrc = sql_src_list_append(NULL, &yymsp[-1].minor.yy0);
  Select *pSelect = sqlSelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
  if(yymsp[0].minor.yy402 != NULL)
    sqlSrcListFuncArgs(pSelect != NULL ? pSrc : NULL, yymsp[0].minor.yy402);
  yymsp[-3].minor.yy214.pExpr = sqlPExpr(pParse, TK_IN, yymsp[-3].minor.yy214.pExpr, 0);
  sqlPExprAddSelect(pParse, yymsp[-3].minor.yy214.pExpr, pSelect);
  exprNot(pParse, yymsp[-2].minor.yy60, &yymsp[-3].minor.yy214);
  yymsp[-3].minor.yy214.zEnd = &yymsp[-1].minor.yy0.z[yymsp[-1].minor.yy0.n];
}
#line 3651 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 189: /* expr ::= EXISTS LP select RP */
#line 1356 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  Expr *p;
  spanSet(&yymsp[-3].minor.yy214,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0); /*A-overwrites-B*/
  p = yymsp[-3].minor.yy214.pExpr = sqlPExpr(pParse, TK_EXISTS, 0, 0);
  sqlPExprAddSelect(pParse, p, yymsp[-1].minor.yy331);
}
#line 3661 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 190: /* expr ::= CASE expr_optional case_exprlist case_else END */
#line 1364 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  spanSet(&yymsp[-4].minor.yy214,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);  /*A-overwrites-C*/
  yymsp[-4].minor.yy214.pExpr = sqlPExpr(pParse, TK_CASE, yymsp[-3].minor.yy407, 0);
  if( yymsp[-4].minor.yy214.pExpr ){
    yymsp[-4].minor.yy214.pExpr->x.pList = yymsp[-1].minor.yy386 ? sql_expr_list_append(yymsp[-2].minor.yy402, yymsp[-1].minor.yy386) : yymsp[-2].minor.yy402;
    sqlExprSetHeightAndFlags(pParse, yymsp[-4].minor.yy214.pExpr);
  }else{
    sql_expr_list_delete(yymsp[-2].minor.yy402);
    sql_expr_delete(yymsp[-1].minor.yy386);
  }
}
#line 3676 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 191: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 1377 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-4].minor.yy402 = sql_expr_list_append(yymsp[-4].minor.yy402, yymsp[-2].minor.yy214.pExpr);
  yymsp[-4].minor.yy402 = sql_expr_list_append(yymsp[-4].minor.yy402, yymsp[0].minor.yy214.pExpr);
}
#line 3684 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 192: /* case_exprlist ::= WHEN expr THEN expr */
#line 1381 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-3].minor.yy402 = sql_expr_list_append(NULL, yymsp[-2].minor.yy214.pExpr);
  yymsp[-3].minor.yy402 = sql_expr_list_append(yymsp[-3].minor.yy402, yymsp[0].minor.yy214.pExpr);
}
#line 3692 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 196: /* nexprlist ::= nexprlist COMMA expr */
#line 1398 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy402 = sql_expr_list_append(yymsp[-2].minor.yy402, yymsp[0].minor.yy214.pExpr);}
#line 3697 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 197: /* nexprlist ::= expr */
#line 1400 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy402 = sql_expr_list_append(NULL, yymsp[0].minor.yy214.pExpr); /*A-overwrites-Y*/}
#line 3702 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 199: /* paren_exprlist ::= LP exprlist RP */
      case 204: /* eidlist_opt ::= LP eidlist RP */ yytestcase(yyruleno==204);
#line 1407 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy402 = yymsp[-1].minor.yy402;}
#line 3708 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 200: /* cmd ::= createkw uniqueflag INDEX ifnotexists nm ON nm LP sortlist RP */
#line 1413 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct SrcList *src_list = sql_src_list_append(NULL ,&yymsp[-3].minor.yy0);
  create_index_def_init(&pParse->create_index_def, src_list, &yymsp[-5].minor.yy0, yymsp[-1].minor.yy402, yymsp[-8].minor.yy60,
                        SORT_ORDER_ASC, yymsp[-6].minor.yy60);
  pParse->initiateTTrans = true;
  sql_create_index(pParse);
}
#line 3719 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 201: /* uniqueflag ::= UNIQUE */
#line 1422 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = SQL_INDEX_TYPE_UNIQUE;}
#line 3724 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 202: /* uniqueflag ::= */
#line 1423 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy60 = SQL_INDEX_TYPE_NON_UNIQUE;}
#line 3729 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 205: /* eidlist ::= eidlist COMMA nm */
#line 1458 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-2].minor.yy402 = parserAddExprIdListTerm(pParse, yymsp[-2].minor.yy402, &yymsp[0].minor.yy0);
}
#line 3736 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 206: /* eidlist ::= nm */
#line 1461 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[0].minor.yy402 = parserAddExprIdListTerm(pParse, 0, &yymsp[0].minor.yy0); /*A-overwrites-Y*/
}
#line 3743 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 207: /* cmd ::= DROP INDEX ifexists nm ON fullname */
#line 1468 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  drop_index_def_init(&pParse->drop_index_def, yymsp[0].minor.yy291, &yymsp[-2].minor.yy0, yymsp[-3].minor.yy60);
  pParse->initiateTTrans = true;
  sql_drop_index(pParse);
}
#line 3752 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 208: /* cmd ::= SET SESSION nm EQ term */
#line 1476 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
    sql_setting_set(pParse,&yymsp[-2].minor.yy0,yymsp[0].minor.yy214.pExpr);
}
#line 3759 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 209: /* cmd ::= PRAGMA nm */
#line 1482 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
    sqlPragma(pParse,&yymsp[0].minor.yy0,0,0);
}
#line 3766 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 210: /* cmd ::= PRAGMA nm LP nm RP */
#line 1485 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
    sqlPragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);
}
#line 3773 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 211: /* cmd ::= PRAGMA nm LP nm DOT nm RP */
#line 1488 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
    sqlPragma(pParse,&yymsp[-5].minor.yy0,&yymsp[-1].minor.yy0,&yymsp[-3].minor.yy0);
}
#line 3780 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 212: /* cmd ::= FUNCTION_KW expr */
#line 1491 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  if (!pParse->is_expr) {
    diag_set(ClientError, ER_SQL_SYNTAX_NEAR_TOKEN, pParse->line_count, yymsp[-1].minor.yy0.n,
             yymsp[-1].minor.yy0.z);
    pParse->is_aborted = true;
    return;
  }
  pParse->parsed_ast_type = AST_TYPE_EXPR;
  pParse->parsed_ast.expr = yymsp[0].minor.yy214.pExpr;
}
#line 3794 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 213: /* cmd ::= createkw trigger_decl BEGIN trigger_cmd_list END */
#line 1503 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (int)(yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  pParse->initiateTTrans = true;
  sql_trigger_finish(pParse, yymsp[-1].minor.yy251, &all);
}
#line 3805 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 214: /* trigger_decl ::= TRIGGER ifnotexists nm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 1513 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_trigger_def_init(&pParse->create_trigger_def, yymsp[-2].minor.yy291, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy60, yymsp[-4].minor.yy403.a, yymsp[-4].minor.yy403.b, yymsp[0].minor.yy386,
                          yymsp[-7].minor.yy60);
  sql_trigger_begin(pParse);
  yymsp[-8].minor.yy0 = yymsp[-6].minor.yy0; /*yymsp[-8].minor.yy0-overwrites-T*/
}
#line 3815 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 215: /* trigger_time ::= BEFORE */
#line 1521 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy60 = TK_BEFORE; }
#line 3820 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 216: /* trigger_time ::= AFTER */
#line 1522 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy60 = TK_AFTER;  }
#line 3825 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 217: /* trigger_time ::= INSTEAD OF */
#line 1523 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-1].minor.yy60 = TK_INSTEAD;}
#line 3830 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 218: /* trigger_time ::= */
#line 1524 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[1].minor.yy60 = TK_BEFORE; }
#line 3835 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 219: /* trigger_event ::= DELETE|INSERT */
      case 220: /* trigger_event ::= UPDATE */ yytestcase(yyruleno==220);
#line 1528 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy403.a = yymsp[0].major; /*A-overwrites-X*/ yymsp[0].minor.yy403.b = 0;}
#line 3841 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 221: /* trigger_event ::= UPDATE OF idlist */
#line 1530 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[-2].minor.yy403.a = TK_UPDATE; yymsp[-2].minor.yy403.b = yymsp[0].minor.yy272;}
#line 3846 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 222: /* foreach_clause ::= */
#line 1532 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  diag_set(ClientError, ER_SQL_PARSER_GENERIC_WITH_POS, pParse->line_count,
           pParse->line_pos, "FOR EACH STATEMENT triggers are not implemented, "
           "please supply FOR EACH ROW clause");
  pParse->is_aborted = true;
}
#line 3856 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 223: /* when_clause ::= */
#line 1542 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[1].minor.yy386 = 0; }
#line 3861 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 224: /* when_clause ::= WHEN expr */
#line 1543 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-1].minor.yy386 = yymsp[0].minor.yy214.pExpr; }
#line 3866 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 225: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 1547 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  assert( yymsp[-2].minor.yy251!=0 );
  yymsp[-2].minor.yy251->pLast->pNext = yymsp[-1].minor.yy251;
  yymsp[-2].minor.yy251->pLast = yymsp[-1].minor.yy251;
}
#line 3875 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 226: /* trigger_cmd_list ::= trigger_cmd SEMI */
#line 1552 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ 
  assert( yymsp[-1].minor.yy251!=0 );
  yymsp[-1].minor.yy251->pLast = yymsp[-1].minor.yy251;
}
#line 3883 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 227: /* trnm ::= nm DOT nm */
#line 1563 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-2].minor.yy0 = yymsp[0].minor.yy0;
  diag_set(ClientError, ER_SQL_PARSER_GENERIC_WITH_POS, pParse->line_count,
           pParse->line_pos, "qualified table names are not allowed on INSERT, "
           "UPDATE, and DELETE statements within triggers");
  pParse->is_aborted = true;
}
#line 3894 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 228: /* tridxby ::= INDEXED BY nm */
#line 1576 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  diag_set(ClientError, ER_SQL_SYNTAX_WITH_POS, pParse->line_count,
           pParse->line_pos, "the INDEXED BY clause is not allowed on UPDATE "\
           "or DELETE statements within triggers");
  pParse->is_aborted = true;
}
#line 3904 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 229: /* tridxby ::= NOT INDEXED */
#line 1582 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  diag_set(ClientError, ER_SQL_SYNTAX_WITH_POS, pParse->line_count,
           pParse->line_pos, "the NOT INDEXED BY clause is not allowed on "\
           "UPDATE or DELETE statements within triggers");
  pParse->is_aborted = true;
}
#line 3914 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 230: /* trigger_cmd ::= UPDATE orconf trnm tridxby SET setlist where_opt */
#line 1595 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
     yymsp[-6].minor.yy251 = sql_trigger_update_step(&yymsp[-4].minor.yy0, yymsp[-1].minor.yy402, yymsp[0].minor.yy386, yymsp[-5].minor.yy60);
     if (yymsp[-6].minor.yy251 == NULL) {
        pParse->is_aborted = true;
        return;
     }
   }
#line 3925 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 231: /* trigger_cmd ::= insert_cmd INTO trnm idlist_opt select */
#line 1604 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  /*yylhsminor.yy251-overwrites-yymsp[-4].minor.yy60. */
  yylhsminor.yy251 = sql_trigger_insert_step(&yymsp[-2].minor.yy0, yymsp[-1].minor.yy272, yymsp[0].minor.yy331, yymsp[-4].minor.yy60);
}
#line 3933 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-4].minor.yy251 = yylhsminor.yy251;
        break;
      case 232: /* trigger_cmd ::= DELETE FROM trnm tridxby where_opt */
#line 1610 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-4].minor.yy251 = sql_trigger_delete_step(&yymsp[-2].minor.yy0, yymsp[0].minor.yy386);
}
#line 3941 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 233: /* trigger_cmd ::= select */
#line 1615 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  /* yylhsminor.yy251-overwrites-yymsp[0].minor.yy331. */
  yylhsminor.yy251 = sql_trigger_select_step(yymsp[0].minor.yy331);
}
#line 3949 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy251 = yylhsminor.yy251;
        break;
      case 234: /* expr ::= RAISE LP IGNORE RP */
#line 1621 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  spanSet(&yymsp[-3].minor.yy214,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);  /*A-overwrites-X*/
  yymsp[-3].minor.yy214.pExpr = sqlPExpr(pParse, TK_RAISE, 0, 0);
  if( yymsp[-3].minor.yy214.pExpr ){
    yymsp[-3].minor.yy214.pExpr->on_conflict_action = ON_CONFLICT_ACTION_IGNORE;
  }
}
#line 3961 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 235: /* expr ::= RAISE LP raisetype COMMA STRING RP */
#line 1628 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  spanSet(&yymsp[-5].minor.yy214,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);  /*A-overwrites-X*/
  yymsp[-5].minor.yy214.pExpr = sql_expr_new_dequoted(TK_RAISE, &yymsp[-1].minor.yy0);
  yymsp[-5].minor.yy214.pExpr->on_conflict_action = (enum on_conflict_action) yymsp[-3].minor.yy60;
}
#line 3970 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 236: /* raisetype ::= ROLLBACK */
#line 1635 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = ON_CONFLICT_ACTION_ROLLBACK;}
#line 3975 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 237: /* raisetype ::= ABORT */
#line 1636 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = ON_CONFLICT_ACTION_ABORT;}
#line 3980 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 238: /* raisetype ::= FAIL */
#line 1637 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[0].minor.yy60 = ON_CONFLICT_ACTION_FAIL;}
#line 3985 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 239: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1641 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  struct Token t = Token_nil;
  drop_trigger_def_init(&pParse->drop_trigger_def, yymsp[0].minor.yy291, &t, yymsp[-1].minor.yy60);
  pParse->initiateTTrans = true;
  sql_drop_trigger(pParse);
}
#line 3995 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 240: /* alter_table_start ::= ALTER TABLE fullname */
#line 1658 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-2].minor.yy184 = yymsp[0].minor.yy291; }
#line 4000 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 241: /* alter_add_constraint ::= alter_table_start ADD CONSTRAINT nm */
#line 1661 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
   yylhsminor.yy394.table_name = yymsp[-3].minor.yy184;
   yylhsminor.yy394.name = yymsp[0].minor.yy0;
   pParse->initiateTTrans = true;
 }
#line 4009 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-3].minor.yy394 = yylhsminor.yy394;
        break;
      case 242: /* alter_add_column ::= alter_table_start ADD column_name */
#line 1668 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yylhsminor.yy394.table_name = yymsp[-2].minor.yy184;
  yylhsminor.yy394.name = yymsp[0].minor.yy0;
  pParse->initiateTTrans = true;
}
#line 4019 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[-2].minor.yy394 = yylhsminor.yy394;
        break;
      case 243: /* column_name ::= COLUMN nm */
#line 1674 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-1].minor.yy0 = yymsp[0].minor.yy0; }
#line 4025 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 244: /* column_name ::= nm */
#line 1675 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yylhsminor.yy0 = yymsp[0].minor.yy0; }
#line 4030 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 245: /* alter_column_def ::= alter_add_column typedef */
#line 1679 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_column_def_init(&pParse->create_column_def, yymsp[-1].minor.yy394.table_name, &yymsp[-1].minor.yy394.name, &yymsp[0].minor.yy338);
  create_ck_constraint_parse_def_init(&pParse->create_ck_constraint_parse_def);
  create_fk_constraint_parse_def_init(&pParse->create_fk_constraint_parse_def);
  sql_create_column_start(pParse);
}
#line 4041 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 246: /* cmd ::= alter_add_constraint FOREIGN KEY LP eidlist RP REFERENCES nm eidlist_opt */
#line 1687 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_fk_def_init(&pParse->create_fk_def, yymsp[-8].minor.yy394.table_name, &yymsp[-8].minor.yy394.name, yymsp[-4].minor.yy402, &yymsp[-1].minor.yy0, yymsp[0].minor.yy402);
  sql_create_foreign_key(pParse);
}
#line 4049 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 247: /* cmd ::= alter_add_constraint CHECK LP expr RP */
#line 1692 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
    create_ck_def_init(&pParse->create_ck_def, yymsp[-4].minor.yy394.table_name, &yymsp[-4].minor.yy394.name, &yymsp[-1].minor.yy214);
    sql_create_check_contraint(pParse, false);
}
#line 4057 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 248: /* cmd ::= alter_add_constraint unique_spec LP sortlist RP */
#line 1697 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  create_index_def_init(&pParse->create_index_def, yymsp[-4].minor.yy394.table_name, &yymsp[-4].minor.yy394.name, yymsp[-1].minor.yy402, yymsp[-3].minor.yy60,
                        SORT_ORDER_ASC, false);
  sql_create_index(pParse);
}
#line 4066 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 249: /* unique_spec ::= UNIQUE */
#line 1704 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy60 = SQL_INDEX_TYPE_CONSTRAINT_UNIQUE; }
#line 4071 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 250: /* unique_spec ::= PRIMARY KEY */
#line 1705 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-1].minor.yy60 = SQL_INDEX_TYPE_CONSTRAINT_PK; }
#line 4076 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 251: /* cmd ::= alter_table_start RENAME TO nm */
#line 1707 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
    rename_entity_def_init(&pParse->rename_entity_def, yymsp[-3].minor.yy184, &yymsp[0].minor.yy0);
    pParse->initiateTTrans = true;
    sql_alter_table_rename(pParse);
}
#line 4085 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 252: /* cmd ::= ALTER TABLE fullname DROP CONSTRAINT nm */
#line 1713 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  drop_constraint_def_init(&pParse->drop_constraint_def, yymsp[-3].minor.yy291, &yymsp[0].minor.yy0, false);
  pParse->initiateTTrans = true;
  sql_drop_constraint(pParse);
}
#line 4094 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 253: /* with ::= */
#line 1725 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{yymsp[1].minor.yy227 = 0;}
#line 4099 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 254: /* with ::= WITH wqlist */
#line 1726 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-1].minor.yy227 = yymsp[0].minor.yy227; }
#line 4104 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 255: /* with ::= WITH RECURSIVE wqlist */
#line 1727 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[-2].minor.yy227 = yymsp[0].minor.yy227; }
#line 4109 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 256: /* wqlist ::= nm eidlist_opt AS LP select RP */
#line 1729 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-5].minor.yy227 = sqlWithAdd(pParse, 0, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy402, yymsp[-1].minor.yy331); /*A-overwrites-X*/
}
#line 4116 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 257: /* wqlist ::= wqlist COMMA nm eidlist_opt AS LP select RP */
#line 1732 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-7].minor.yy227 = sqlWithAdd(pParse, yymsp[-7].minor.yy227, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy402, yymsp[-1].minor.yy331);
}
#line 4123 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 258: /* typedef ::= TEXT */
      case 259: /* typedef ::= STRING_KW */ yytestcase(yyruleno==259);
#line 1738 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_STRING; }
#line 4129 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 260: /* typedef ::= SCALAR */
#line 1740 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_SCALAR; }
#line 4134 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 261: /* typedef ::= BOOL */
      case 262: /* typedef ::= BOOLEAN */ yytestcase(yyruleno==262);
#line 1742 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_BOOLEAN; }
#line 4140 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 263: /* typedef ::= VARBINARY */
#line 1744 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_VARBINARY; }
#line 4145 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 264: /* typedef ::= UUID */
#line 1745 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_UUID; }
#line 4150 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 265: /* typedef ::= ANY */
#line 1746 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_ANY; }
#line 4155 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 266: /* typedef ::= ARRAY */
#line 1747 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_ARRAY; }
#line 4160 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 267: /* typedef ::= MAP */
#line 1748 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_MAP; }
#line 4165 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 268: /* typedef ::= DATETIME */
#line 1749 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_DATETIME; }
#line 4170 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 269: /* typedef ::= INTERVAL */
#line 1750 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_INTERVAL; }
#line 4175 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 270: /* char_len ::= LP INTEGER RP */
#line 1762 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  (void) yymsp[-2].minor.yy60;
  (void) yymsp[-1].minor.yy0;
}
#line 4183 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 271: /* typedef ::= VARCHAR char_len */
#line 1768 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{
  yymsp[-1].minor.yy338.type = FIELD_TYPE_STRING;
  (void) yymsp[0].minor.yy60;
}
#line 4191 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 272: /* number_typedef ::= NUMBER */
#line 1775 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_NUMBER; }
#line 4196 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 273: /* number_typedef ::= DOUBLE */
#line 1776 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_DOUBLE; }
#line 4201 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 274: /* number_typedef ::= INT|INTEGER_KW */
#line 1777 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_INTEGER; }
#line 4206 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 275: /* number_typedef ::= UNSIGNED */
#line 1778 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_UNSIGNED; }
#line 4211 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      case 276: /* number_typedef ::= DECIMAL */
#line 1779 "/build/tarantool/src/tarantool/src/box/sql/parse.y"
{ yymsp[0].minor.yy338.type = FIELD_TYPE_DECIMAL; }
#line 4216 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
        break;
      default:
      /* (277) input ::= ecmd */ yytestcase(yyruleno==277);
      /* (278) explain ::= */ yytestcase(yyruleno==278);
      /* (279) cmdx ::= cmd (OPTIMIZED OUT) */ assert(yyruleno!=279);
      /* (280) savepoint_opt ::= SAVEPOINT */ yytestcase(yyruleno==280);
      /* (281) savepoint_opt ::= */ yytestcase(yyruleno==281);
      /* (282) cmd ::= create_table create_table_args with_opts create_table_end */ yytestcase(yyruleno==282);
      /* (283) create_table_args ::= LP columnlist RP */ yytestcase(yyruleno==283);
      /* (284) with_opts ::= WITH engine_opts */ yytestcase(yyruleno==284);
      /* (285) with_opts ::= */ yytestcase(yyruleno==285);
      /* (286) columnlist ::= columnlist COMMA tcons */ yytestcase(yyruleno==286);
      /* (287) columnlist ::= columnlist COMMA column_def create_column_end */ yytestcase(yyruleno==287);
      /* (288) columnlist ::= column_def create_column_end */ yytestcase(yyruleno==288);
      /* (289) column_def ::= column_name_and_type carglist */ yytestcase(yyruleno==289);
      /* (290) columnlist ::= tcons (OPTIMIZED OUT) */ assert(yyruleno!=290);
      /* (291) carglist ::= carglist ccons */ yytestcase(yyruleno==291);
      /* (292) carglist ::= */ yytestcase(yyruleno==292);
      /* (293) resolvetype ::= raisetype (OPTIMIZED OUT) */ assert(yyruleno!=293);
      /* (294) selectnowith ::= oneselect (OPTIMIZED OUT) */ assert(yyruleno!=294);
      /* (295) oneselect ::= values */ yytestcase(yyruleno==295);
      /* (296) sclp ::= selcollist COMMA */ yytestcase(yyruleno==296);
      /* (297) as ::= ID|STRING */ yytestcase(yyruleno==297);
      /* (298) join_nm ::= ID|INDEXED */ yytestcase(yyruleno==298);
      /* (299) join_nm ::= JOIN_KW */ yytestcase(yyruleno==299);
      /* (300) expr ::= term (OPTIMIZED OUT) */ assert(yyruleno!=300);
      /* (301) maplist ::= nmaplist */ yytestcase(yyruleno==301);
      /* (302) type_func ::= CHAR */ yytestcase(yyruleno==302);
      /* (303) exprlist ::= nexprlist */ yytestcase(yyruleno==303);
      /* (304) foreach_clause ::= FOR EACH ROW */ yytestcase(yyruleno==304);
      /* (305) trnm ::= nm */ yytestcase(yyruleno==305);
      /* (306) tridxby ::= */ yytestcase(yyruleno==306);
      /* (307) cmd ::= alter_column_def carglist create_column_end */ yytestcase(yyruleno==307);
      /* (308) typedef ::= number_typedef (OPTIMIZED OUT) */ assert(yyruleno!=308);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact <= YY_MAX_SHIFTREDUCE ){
    if( yyact>YY_MAX_SHIFT ){
      yyact += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
    }
    yymsp -= yysize-1;
    yypParser->yytos = yymsp;
    yymsp->stateno = (YYACTIONTYPE)yyact;
    yymsp->major = (YYCODETYPE)yygoto;
    yyTraceShift(yypParser, yyact);
  }else{
    assert( yyact == YY_ACCEPT_ACTION );
    yypParser->yytos -= yysize;
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  sqlParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  sqlParserTOKENTYPE yyminor         /* The minor type of the error token */
){
  sqlParserARG_FETCH;
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 32 "/build/tarantool/src/tarantool/src/box/sql/parse.y"

  UNUSED_PARAMETER(yymajor);  /* Silence some compiler warnings */
  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  if (yypParser->is_fallback_failed && TOKEN.isReserved) {
    diag_set(ClientError, ER_SQL_KEYWORD_IS_RESERVED, pParse->line_count,
             pParse->line_pos, TOKEN.n, TOKEN.z, TOKEN.n, TOKEN.z);
  } else {
    diag_set(ClientError, ER_SQL_SYNTAX_NEAR_TOKEN, pParse->line_count, TOKEN.n,
             TOKEN.z);
  }
  pParse->is_aborted = true;
#line 4319 "/build/tarantool/src/tarantool/src/box/sql/parse.c"
/************ End %syntax_error code ******************************************/
  sqlParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  sqlParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlParserTOKENTYPE yyminor       /* The value for the token */
  sqlParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  unsigned int yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  yypParser = (yyParser*)yyp;
  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput '%s'\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      yymajor = YYNOCODE;
    }else if( yyact <= YY_MAX_REDUCE ){
      yy_reduce(yypParser,yyact-YY_MIN_REDUCE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor((YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && yymx != YYERRORSYMBOL
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) >= YY_MIN_REDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor((YYCODETYPE)yymajor, &yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor((YYCODETYPE)yymajor, &yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor((YYCODETYPE)yymajor, &yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yytos>yypParser->yystack
         PARSER_ERROR_CHECK);
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}
