﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/connectcases/model/LayoutSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ConnectCases {
namespace Model {
class ListLayoutsResult {
 public:
  AWS_CONNECTCASES_API ListLayoutsResult() = default;
  AWS_CONNECTCASES_API ListLayoutsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECTCASES_API ListLayoutsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The layouts for the domain.</p>
   */
  inline const Aws::Vector<LayoutSummary>& GetLayouts() const { return m_layouts; }
  template <typename LayoutsT = Aws::Vector<LayoutSummary>>
  void SetLayouts(LayoutsT&& value) {
    m_layoutsHasBeenSet = true;
    m_layouts = std::forward<LayoutsT>(value);
  }
  template <typename LayoutsT = Aws::Vector<LayoutSummary>>
  ListLayoutsResult& WithLayouts(LayoutsT&& value) {
    SetLayouts(std::forward<LayoutsT>(value));
    return *this;
  }
  template <typename LayoutsT = LayoutSummary>
  ListLayoutsResult& AddLayouts(LayoutsT&& value) {
    m_layoutsHasBeenSet = true;
    m_layouts.emplace_back(std::forward<LayoutsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next set of results. This is null if there are no more
   * results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListLayoutsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListLayoutsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<LayoutSummary> m_layouts;
  bool m_layoutsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCases
}  // namespace Aws
