/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Bits;
import jogamp.graph.font.typecast.ot.Fixed_2_14;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;

public class GlyfCompositeComp {
    private static final short ARG_1_AND_2_ARE_WORDS = 1;
    private static final short ARGS_ARE_XY_VALUES = 2;
    public static final short ROUND_XY_TO_GRID = 4;
    private static final short WE_HAVE_A_SCALE = 8;
    public static final short MORE_COMPONENTS = 32;
    private static final short WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final short WE_HAVE_A_TWO_BY_TWO = 128;
    public static final short WE_HAVE_INSTRUCTIONS = 256;
    public static final short USE_MY_METRICS = 512;
    public static final short OVERLAP_COMPOUND = 1024;
    public static final short SCALED_COMPONENT_OFFSET = 2048;
    public static final short UNSCALED_COMPONENT_OFFSET = 4096;
    private final int _firstIndex;
    private final int _firstContour;
    private int _flags;
    private int _glyphIndex;
    private double _xscale = 1.0;
    private double _scale01 = 0.0;
    private double _scale10 = 0.0;
    private double _yscale = 1.0;
    private int _xtranslate = 0;
    private int _ytranslate = 0;
    private int _point1 = 0;
    private int _point2 = 0;

    GlyfCompositeComp(int n, int n2, DataInput dataInput) throws IOException {
        boolean bl;
        this._firstIndex = n;
        this._firstContour = n2;
        this._flags = dataInput.readUnsignedShort();
        this._glyphIndex = dataInput.readUnsignedShort();
        boolean bl2 = bl = (this._flags & 1) != 0;
        if ((this._flags & 2) != 0) {
            if (bl) {
                this._xtranslate = dataInput.readShort();
                this._ytranslate = dataInput.readShort();
            } else {
                this._xtranslate = dataInput.readByte();
                this._ytranslate = dataInput.readByte();
            }
        } else if (bl) {
            this._point1 = dataInput.readUnsignedShort();
            this._point2 = dataInput.readUnsignedShort();
        } else {
            this._point1 = dataInput.readUnsignedByte();
            this._point2 = dataInput.readUnsignedByte();
        }
        if ((this._flags & 8) != 0) {
            this._xscale = this._yscale = Fixed_2_14.read(dataInput);
        } else if ((this._flags & 0x40) != 0) {
            this._xscale = Fixed_2_14.read(dataInput);
            this._yscale = Fixed_2_14.read(dataInput);
        } else if ((this._flags & 0x80) != 0) {
            this._xscale = Fixed_2_14.read(dataInput);
            this._scale01 = Fixed_2_14.read(dataInput);
            this._scale10 = Fixed_2_14.read(dataInput);
            this._yscale = Fixed_2_14.read(dataInput);
        }
    }

    public int getFirstIndex() {
        return this._firstIndex;
    }

    public int getFirstContour() {
        return this._firstContour;
    }

    public int getFlags() {
        return this._flags;
    }

    public int getGlyphIndex() {
        return this._glyphIndex;
    }

    public double getXScale() {
        return this._xscale;
    }

    public double getScale01() {
        return this._scale01;
    }

    public double getScale10() {
        return this._scale10;
    }

    public double getYScale() {
        return this._yscale;
    }

    public int getXTranslate() {
        return this._xtranslate;
    }

    public int getYTranslate() {
        return this._ytranslate;
    }

    public int getPoint1() {
        return this._point1;
    }

    public int getPoint2() {
        return this._point2;
    }

    public int scaleX(int n, int n2) {
        return (int)((double)n * this._xscale + (double)n2 * this._scale10);
    }

    public int scaleY(int n, int n2) {
        return (int)((double)n * this._scale01 + (double)n2 * this._yscale);
    }

    public short transformX(int n, int n2) {
        return (short)(this.scaleX(n, n2) + this.getXTranslate());
    }

    public short transformY(int n, int n2) {
        return (short)(this.scaleY(n, n2) + this.getYTranslate());
    }

    public GlyfDescript getReferencedGlyph(GlyfTable glyfTable) {
        return glyfTable.getDescription(this.getGlyphIndex());
    }

    public String toString() {
        return "            glyphIndex: " + this.getGlyphIndex() + "\n            firstIndex: " + this.getFirstIndex() + "\n            firstContour: " + this.getFirstContour() + "\n            flags: " + (Bits.isSet(this._flags, 512) ? "USE_MY_METRICS " : "") + (Bits.isSet(this._flags, 1024) ? "OVERLAP_COMPOUND " : "") + (Bits.isSet(this._flags, 2048) ? "SCALED_COMPONENT_OFFSET " : "") + (Bits.isSet(this._flags, 4096) ? "UNSCALED_COMPONENT_OFFSET" : "") + "\n            transform:\n                " + this.getXScale() + "  " + this.getScale01() + "  " + this.getXTranslate() + "\n                " + this.getScale10() + "  " + this.getYScale() + "  " + this.getYTranslate() + "\n            point1: " + this.getPoint1() + "\n            point2: " + this.getPoint2();
    }
}

