/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.ChildMapFactory;
import org.gradle.internal.snapshot.VfsRelativePath;

public abstract class AbstractStorePathRelationshipHandler<T>
implements ChildMap.Entry.PathRelationshipHandler<ChildMap<T>, T> {
    private final CaseSensitivity caseSensitivity;
    private final ChildMap.StoreHandler<T> handler;

    public AbstractStorePathRelationshipHandler(CaseSensitivity caseSensitivity, ChildMap.StoreHandler<T> handler) {
        this.caseSensitivity = caseSensitivity;
        this.handler = handler;
    }

    public abstract ChildMap<T> withReplacedChild(T var1);

    public abstract ChildMap<T> withReplacedChild(String var1, T var2);

    public abstract ChildMap<T> withNewChild(String var1, T var2);

    @Override
    public ChildMap<T> handleAsDescendantOfChild(VfsRelativePath targetPath, String childPath, T child) {
        T newChild = this.handler.handleAsDescendantOfChild(targetPath.pathFromChild(childPath), child);
        return this.withReplacedChild(newChild);
    }

    @Override
    public ChildMap<T> handleAsAncestorOfChild(VfsRelativePath targetPath, String childPath, T child) {
        T newChild = this.handler.handleAsAncestorOfChild(childPath, child);
        return this.withReplacedChild(targetPath.getAsString(), newChild);
    }

    @Override
    public ChildMap<T> handleExactMatchWithChild(VfsRelativePath targetPath, String childPath, T child) {
        T newChild = this.handler.mergeWithExisting(child);
        return this.withReplacedChild(newChild);
    }

    @Override
    public ChildMap<T> handleSiblingOfChild(VfsRelativePath targetPath, String childPath, T child, int commonPrefixLength) {
        String commonPrefix = childPath.substring(0, commonPrefixLength);
        String newChildPath = childPath.substring(commonPrefixLength + 1);
        ChildMap.Entry<T> newChild = new ChildMap.Entry<T>(newChildPath, child);
        String siblingPath = targetPath.pathFromChild(commonPrefix).getAsString();
        ChildMap.Entry<T> sibling = new ChildMap.Entry<T>(siblingPath, this.handler.createChild());
        ChildMap<T> newChildren = ChildMapFactory.childMap(this.caseSensitivity, newChild, sibling);
        return this.withReplacedChild(commonPrefix, this.handler.createNodeFromChildren(newChildren));
    }

    @Override
    public ChildMap<T> handleUnrelatedToAnyChild(VfsRelativePath targetPath) {
        String path = targetPath.getAsString();
        T newNode = this.handler.createChild();
        return this.withNewChild(path, newNode);
    }
}

