const char *BEES_USAGE = 
"Usage: %s [options] fs-root-path\n"
"Performs best-effort extent-same deduplication on btrfs.\n"
"\n"
"fs-root-path MUST be the root of a btrfs filesystem tree (subvol id 5).\n"
"Other directories will be rejected.\n"
"\n"
"Options:\n"
"    -h, --help            Show this help\n"
"\n"
"Load management options:\n"
"    -c, --thread-count    Worker thread count (default CPU count * factor)\n"
"    -C, --thread-factor   Worker thread factor (default 1)\n"
"    -G, --thread-min      Minimum worker thread count (default 0)\n"
"    -g, --loadavg-target  Target load average for worker threads (default none)\n"
"        --throttle-factor Idle time between operations (default 1.0)\n"
"\n"
"Filesystem tree traversal options:\n"
"    -m, --scan-mode       Scanning mode (0..4, default 4)\n"
"\n"
"Workarounds:\n"
"    -a, --workaround-btrfs-send    Workaround for btrfs send\n"
"                                   (ignore RO snapshots)\n"
"\n"
"Logging options:\n"
"    -t, --timestamps      Show timestamps in log output (default)\n"
"    -T, --no-timestamps   Omit timestamps in log output\n"
"    -p, --absolute-paths  Show absolute paths (default)\n"
"    -P, --strip-paths     Strip $CWD from beginning of all paths in the log\n"
"    -v, --verbose         Set maximum log level (0..8, default 8)\n"
"\n"
"Optional environment variables:\n"
"    BEESHOME    Path to hash table and configuration files\n"
"                (default is .beeshome/ in the root of the filesystem).\n"
"\n"
"    BEESSTATUS  File to write status to (tmpfs recommended, e.g. /run).\n"
"                No status is written if this variable is unset.\n"
;
