/* LabelTool.c generated by valac 0.56.17, the Vala compiler
 * generated from LabelTool.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LABEL_TOOL_0_PROPERTY,
	BIRD_FONT_LABEL_TOOL_LABEL_PROPERTY,
	BIRD_FONT_LABEL_TOOL_NUMBER_PROPERTY,
	BIRD_FONT_LABEL_TOOL_HAS_COUNTER_PROPERTY,
	BIRD_FONT_LABEL_TOOL_HAS_DELETE_BUTTON_PROPERTY,
	BIRD_FONT_LABEL_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
enum  {
	BIRD_FONT_LABEL_TOOL_DELETE_ACTION_SIGNAL,
	BIRD_FONT_LABEL_TOOL_NUM_SIGNALS
};
static guint bird_font_label_tool_signals[BIRD_FONT_LABEL_TOOL_NUM_SIGNALS] = {0};

struct _BirdFontLabelToolPrivate {
	gchar* counter_number;
	gboolean _has_counter;
	gboolean _has_delete_button;
	gdouble counter_box_width;
	gdouble counter_box_height;
	BirdFontText* label_text;
	cairo_surface_t* selected_cache;
	cairo_surface_t* deselected_cache;
};

static gint BirdFontLabelTool_private_offset;
static gpointer bird_font_label_tool_parent_class = NULL;

static void __lambda88_ (BirdFontLabelTool* self,
                  BirdFontTool* selected,
                  guint button,
                  gdouble tx,
                  gdouble ty);
static void ___lambda88__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                     BirdFontTool* selected,
                                                     guint button,
                                                     gdouble x,
                                                     gdouble y,
                                                     gpointer self);
static void bird_font_label_tool_clear_cache (BirdFontLabelTool* self);
static void bird_font_label_tool_real_draw_tool (BirdFontTool* base,
                                          cairo_t* cr,
                                          gdouble px,
                                          gdouble py);
static void bird_font_label_tool_finalize (GObject * obj);
static GType bird_font_label_tool_get_type_once (void);
static void _vala_bird_font_label_tool_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_bird_font_label_tool_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
bird_font_label_tool_get_instance_private (BirdFontLabelTool* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLabelTool_private_offset);
}

static void
__lambda88_ (BirdFontLabelTool* self,
             BirdFontTool* selected,
             guint button,
             gdouble tx,
             gdouble ty)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_if_fail (selected != NULL);
	_tmp2_ = self->priv->_has_delete_button;
	if (_tmp2_) {
		gdouble _tmp3_;
		_tmp3_ = ty;
		_tmp1_ = (((BirdFontTool*) self)->y <= _tmp3_) && (_tmp3_ <= (((BirdFontTool*) self)->y + ((BirdFontTool*) self)->h));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = tx >= (((BirdFontTool*) self)->w - (30 * bird_font_toolbox_get_scale ()));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, bird_font_label_tool_signals[BIRD_FONT_LABEL_TOOL_DELETE_ACTION_SIGNAL], 0, self);
	}
}

static void
___lambda88__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                guint button,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	__lambda88_ ((BirdFontLabelTool*) self, selected, button, x, y);
}

BirdFontLabelTool*
bird_font_label_tool_construct (GType object_type,
                                const gchar* label)
{
	BirdFontLabelTool * self = NULL;
	gdouble text_height = 0.0;
	BirdFontText* _tmp0_;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp2_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (BirdFontLabelTool*) bird_font_tool_construct (object_type, NULL, "");
	_tmp0_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->label_text);
	self->priv->label_text = _tmp0_;
	_tmp1_ = self->priv->label_text;
	bird_font_text_set_text (_tmp1_, label);
	bird_font_label_tool_set_label (self, label);
	bird_font_label_tool_set_number (self, "-");
	text_height = 17 * bird_font_toolbox_get_scale ();
	_tmp2_ = self->priv->label_text;
	bird_font_text_set_font_size (_tmp2_, text_height);
	bird_font_label_tool_set_has_delete_button (self, FALSE);
	bird_font_label_tool_set_has_counter (self, FALSE);
	g_signal_connect_object ((BirdFontTool*) self, "panel-press-action", (GCallback) ___lambda88__bird_font_tool_panel_press_action, self, 0);
	return self;
}

BirdFontLabelTool*
bird_font_label_tool_new (const gchar* label)
{
	return bird_font_label_tool_construct (BIRD_FONT_TYPE_LABEL_TOOL, label);
}

static void
bird_font_label_tool_clear_cache (BirdFontLabelTool* self)
{
	g_return_if_fail (self != NULL);
	_cairo_surface_destroy0 (self->priv->selected_cache);
	self->priv->selected_cache = NULL;
	_cairo_surface_destroy0 (self->priv->deselected_cache);
	self->priv->deselected_cache = NULL;
}

static void
bird_font_label_tool_real_draw_tool (BirdFontTool* base,
                                     cairo_t* cr,
                                     gdouble px,
                                     gdouble py)
{
	BirdFontLabelTool * self;
	gdouble x = 0.0;
	gdouble y = 0.0;
	self = (BirdFontLabelTool*) base;
	g_return_if_fail (cr != NULL);
	x = ((BirdFontTool*) self)->x - px;
	y = ((BirdFontTool*) self)->y - py;
	if (bird_font_tool_is_selected ((BirdFontTool*) self)) {
		cairo_surface_t* _tmp0_;
		cairo_surface_t* _tmp6_;
		_tmp0_ = self->priv->selected_cache;
		if (_tmp0_ == NULL) {
			cairo_surface_t* _tmp1_;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp2_;
			cairo_t* _tmp3_;
			cairo_t* _tmp4_;
			cairo_t* _tmp5_;
			_tmp1_ = bird_font_screen_create_background_surface ((gint) (((BirdFontTool*) self)->w * bird_font_screen_get_scale ()), (gint) ((((BirdFontTool*) self)->h + 2) * bird_font_screen_get_scale ()));
			_cairo_surface_destroy0 (self->priv->selected_cache);
			self->priv->selected_cache = _tmp1_;
			_tmp2_ = self->priv->selected_cache;
			_tmp3_ = cairo_create ((cairo_surface_t*) _tmp2_);
			c = _tmp3_;
			_tmp4_ = c;
			cairo_scale (_tmp4_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
			_tmp5_ = c;
			bird_font_label_tool_draw_tool_surface (self, _tmp5_, x, (gdouble) 2, TRUE);
			_cairo_destroy0 (c);
		}
		cairo_save (cr);
		cairo_scale (cr, 1 / bird_font_screen_get_scale (), 1 / bird_font_screen_get_scale ());
		cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
		_tmp6_ = self->priv->selected_cache;
		cairo_set_source_surface (cr, (cairo_surface_t*) _tmp6_, (gdouble) 0, (gdouble) ((gint) ((y - 2) * bird_font_screen_get_scale ())));
		cairo_paint (cr);
		cairo_restore (cr);
	} else {
		cairo_surface_t* _tmp7_;
		cairo_surface_t* _tmp13_;
		_tmp7_ = self->priv->deselected_cache;
		if (_tmp7_ == NULL) {
			cairo_surface_t* _tmp8_;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp9_;
			cairo_t* _tmp10_;
			cairo_t* _tmp11_;
			cairo_t* _tmp12_;
			_tmp8_ = bird_font_screen_create_background_surface ((gint) (((BirdFontTool*) self)->w * bird_font_screen_get_scale ()), (gint) ((((BirdFontTool*) self)->h + 2) * bird_font_screen_get_scale ()));
			_cairo_surface_destroy0 (self->priv->deselected_cache);
			self->priv->deselected_cache = _tmp8_;
			_tmp9_ = self->priv->deselected_cache;
			_tmp10_ = cairo_create ((cairo_surface_t*) _tmp9_);
			c = _tmp10_;
			_tmp11_ = c;
			cairo_scale (_tmp11_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
			_tmp12_ = c;
			bird_font_label_tool_draw_tool_surface (self, _tmp12_, x, (gdouble) 2, FALSE);
			_cairo_destroy0 (c);
		}
		cairo_save (cr);
		cairo_scale (cr, 1 / bird_font_screen_get_scale (), 1 / bird_font_screen_get_scale ());
		cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
		_tmp13_ = self->priv->deselected_cache;
		cairo_set_source_surface (cr, (cairo_surface_t*) _tmp13_, (gdouble) 0, (gdouble) ((gint) ((y - 2) * bird_font_screen_get_scale ())));
		cairo_paint (cr);
		cairo_restore (cr);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_label_tool_draw_tool_surface (BirdFontLabelTool* self,
                                        cairo_t* cr,
                                        gdouble px,
                                        gdouble py,
                                        gboolean selected)
{
	BirdFontText* glyph_count = NULL;
	gdouble bgx = 0.0;
	gdouble bgy = 0.0;
	gdouble center_x = 0.0;
	gdouble center_y = 0.0;
	gdouble text_height = 0.0;
	gdouble text_width = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BirdFontText* _tmp3_;
	BirdFontText* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	x = px;
	y = py;
	if (selected) {
		cairo_save (cr);
		bird_font_theme_color (cr, "Menu Background");
		cairo_rectangle (cr, (gdouble) 0, y - (2 * bird_font_toolbox_get_scale ()), ((BirdFontTool*) self)->w, ((BirdFontTool*) self)->h);
		cairo_fill (cr);
		cairo_restore (cr);
	}
	cairo_save (cr);
	_tmp0_ = self->priv->label_text;
	bird_font_theme_text_color (_tmp0_, "Text Tool Box");
	text_width = (gdouble) bird_font_toolbox_allocation_width;
	_tmp1_ = self->priv->_has_counter;
	if (_tmp1_) {
		text_width -= self->priv->counter_box_width - 15;
	}
	_tmp2_ = self->priv->_has_delete_button;
	if (_tmp2_) {
		text_width -= (gdouble) 30;
	}
	_tmp3_ = self->priv->label_text;
	bird_font_text_truncate (_tmp3_, text_width);
	_tmp4_ = self->priv->label_text;
	bird_font_text_draw_at_top (_tmp4_, cr, x, y, "");
	cairo_restore (cr);
	_tmp5_ = self->priv->_has_counter;
	if (_tmp5_) {
		BirdFontText* _tmp6_;
		BirdFontText* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		BirdFontText* _tmp11_;
		BirdFontText* _tmp12_;
		BirdFontText* _tmp15_;
		BirdFontText* _tmp16_;
		cairo_save (cr);
		bgx = (bird_font_toolbox_allocation_width - self->priv->counter_box_width) - 9;
		bgy = y + 2;
		if (bird_font_tool_is_selected ((BirdFontTool*) self)) {
			bird_font_theme_color (cr, "Glyph Count Background 1");
		} else {
			bird_font_theme_color (cr, "Glyph Count Background 2");
		}
		bird_font_widget_draw_rounded_rectangle (cr, bgx, bgy, self->priv->counter_box_width, self->priv->counter_box_height, (gdouble) 3);
		cairo_fill (cr);
		cairo_restore (cr);
		_tmp6_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
		_g_object_unref0 (glyph_count);
		glyph_count = _tmp6_;
		_tmp7_ = glyph_count;
		_tmp8_ = bird_font_label_tool_get_number (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_to_string (_tmp9_);
		bird_font_text_set_text (_tmp7_, _tmp10_);
		text_height = (gdouble) 12;
		_tmp11_ = glyph_count;
		bird_font_text_set_font_size (_tmp11_, text_height);
		_tmp12_ = glyph_count;
		center_x = bgx + ((self->priv->counter_box_width / 2.0) - (bird_font_text_get_extent (_tmp12_) / 2.0));
		center_y = bgy + ((self->priv->counter_box_height / 2.0) + 5);
		if (bird_font_tool_is_selected ((BirdFontTool*) self)) {
			BirdFontText* _tmp13_;
			_tmp13_ = glyph_count;
			bird_font_theme_text_color (_tmp13_, "Text Foreground");
		} else {
			BirdFontText* _tmp14_;
			_tmp14_ = glyph_count;
			bird_font_theme_text_color (_tmp14_, "Text Foreground");
		}
		_tmp15_ = glyph_count;
		bird_font_text_set_font_size (_tmp15_, text_height);
		_tmp16_ = glyph_count;
		bird_font_text_draw_at_baseline (_tmp16_, cr, center_x, center_y, "");
	}
	_tmp17_ = self->priv->_has_delete_button;
	if (_tmp17_) {
		cairo_save (cr);
		bird_font_theme_color (cr, "Text Foreground");
		cairo_set_line_width (cr, (gdouble) 1);
		cairo_move_to (cr, ((BirdFontTool*) self)->w - 20, ((y + (((BirdFontTool*) self)->h / 2)) - 2.5) - 2);
		cairo_line_to (cr, ((BirdFontTool*) self)->w - 25, ((y + (((BirdFontTool*) self)->h / 2)) + 2.5) - 2);
		cairo_move_to (cr, ((BirdFontTool*) self)->w - 20, ((y + (((BirdFontTool*) self)->h / 2)) + 2.5) - 2);
		cairo_line_to (cr, ((BirdFontTool*) self)->w - 25, ((y + (((BirdFontTool*) self)->h / 2)) - 2.5) - 2);
		cairo_stroke (cr);
		cairo_restore (cr);
	}
	_g_object_unref0 (glyph_count);
}

const gchar*
bird_font_label_tool_get_label (BirdFontLabelTool* self)
{
	const gchar* result;
	BirdFontText* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label_text;
	_tmp1_ = _tmp0_->text;
	result = _tmp1_;
	return result;
}

void
bird_font_label_tool_set_label (BirdFontLabelTool* self,
                                const gchar* value)
{
	BirdFontText* _tmp0_;
	g_return_if_fail (self != NULL);
	bird_font_label_tool_clear_cache (self);
	_tmp0_ = self->priv->label_text;
	bird_font_text_set_text (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_LABEL_PROPERTY]);
}

const gchar*
bird_font_label_tool_get_number (BirdFontLabelTool* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->counter_number;
	result = _tmp0_;
	return result;
}

void
bird_font_label_tool_set_number (BirdFontLabelTool* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	bird_font_label_tool_clear_cache (self);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->counter_number);
	self->priv->counter_number = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_NUMBER_PROPERTY]);
}

gboolean
bird_font_label_tool_get_has_counter (BirdFontLabelTool* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_counter;
	return result;
}

void
bird_font_label_tool_set_has_counter (BirdFontLabelTool* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bird_font_label_tool_get_has_counter (self);
	if (old_value != value) {
		self->priv->_has_counter = value;
		g_object_notify_by_pspec ((GObject *) self, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_HAS_COUNTER_PROPERTY]);
	}
}

gboolean
bird_font_label_tool_get_has_delete_button (BirdFontLabelTool* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_delete_button;
	return result;
}

void
bird_font_label_tool_set_has_delete_button (BirdFontLabelTool* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bird_font_label_tool_get_has_delete_button (self);
	if (old_value != value) {
		self->priv->_has_delete_button = value;
		g_object_notify_by_pspec ((GObject *) self, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_HAS_DELETE_BUTTON_PROPERTY]);
	}
}

static void
bird_font_label_tool_class_init (BirdFontLabelToolClass * klass,
                                 gpointer klass_data)
{
	bird_font_label_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLabelTool_private_offset);
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_label_tool_real_draw_tool;
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_label_tool_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_label_tool_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_label_tool_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_LABEL_TOOL_LABEL_PROPERTY, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_LABEL_TOOL_NUMBER_PROPERTY, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_NUMBER_PROPERTY] = g_param_spec_string ("number", "number", "number", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_LABEL_TOOL_HAS_COUNTER_PROPERTY, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_HAS_COUNTER_PROPERTY] = g_param_spec_boolean ("has-counter", "has-counter", "has-counter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_LABEL_TOOL_HAS_DELETE_BUTTON_PROPERTY, bird_font_label_tool_properties[BIRD_FONT_LABEL_TOOL_HAS_DELETE_BUTTON_PROPERTY] = g_param_spec_boolean ("has-delete-button", "has-delete-button", "has-delete-button", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	bird_font_label_tool_signals[BIRD_FONT_LABEL_TOOL_DELETE_ACTION_SIGNAL] = g_signal_new ("delete-action", BIRD_FONT_TYPE_LABEL_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_LABEL_TOOL);
}

static void
bird_font_label_tool_instance_init (BirdFontLabelTool * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = bird_font_label_tool_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->counter_number = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->data = _tmp1_;
	self->priv->counter_box_width = 24 * bird_font_toolbox_get_scale ();
	self->priv->counter_box_height = 11 * bird_font_toolbox_get_scale ();
	self->priv->selected_cache = NULL;
	self->priv->deselected_cache = NULL;
}

static void
bird_font_label_tool_finalize (GObject * obj)
{
	BirdFontLabelTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LABEL_TOOL, BirdFontLabelTool);
	_g_free0 (self->priv->counter_number);
	_g_free0 (self->data);
	_g_object_unref0 (self->priv->label_text);
	_cairo_surface_destroy0 (self->priv->selected_cache);
	_cairo_surface_destroy0 (self->priv->deselected_cache);
	G_OBJECT_CLASS (bird_font_label_tool_parent_class)->finalize (obj);
}

static GType
bird_font_label_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLabelToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_label_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLabelTool), 0, (GInstanceInitFunc) bird_font_label_tool_instance_init, NULL };
	GType bird_font_label_tool_type_id;
	bird_font_label_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontLabelTool", &g_define_type_info, 0);
	BirdFontLabelTool_private_offset = g_type_add_instance_private (bird_font_label_tool_type_id, sizeof (BirdFontLabelToolPrivate));
	return bird_font_label_tool_type_id;
}

GType
bird_font_label_tool_get_type (void)
{
	static volatile gsize bird_font_label_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_label_tool_type_id__once)) {
		GType bird_font_label_tool_type_id;
		bird_font_label_tool_type_id = bird_font_label_tool_get_type_once ();
		g_once_init_leave (&bird_font_label_tool_type_id__once, bird_font_label_tool_type_id);
	}
	return bird_font_label_tool_type_id__once;
}

static void
_vala_bird_font_label_tool_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BirdFontLabelTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_LABEL_TOOL, BirdFontLabelTool);
	switch (property_id) {
		case BIRD_FONT_LABEL_TOOL_LABEL_PROPERTY:
		g_value_set_string (value, bird_font_label_tool_get_label (self));
		break;
		case BIRD_FONT_LABEL_TOOL_NUMBER_PROPERTY:
		g_value_set_string (value, bird_font_label_tool_get_number (self));
		break;
		case BIRD_FONT_LABEL_TOOL_HAS_COUNTER_PROPERTY:
		g_value_set_boolean (value, bird_font_label_tool_get_has_counter (self));
		break;
		case BIRD_FONT_LABEL_TOOL_HAS_DELETE_BUTTON_PROPERTY:
		g_value_set_boolean (value, bird_font_label_tool_get_has_delete_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_label_tool_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BirdFontLabelTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_LABEL_TOOL, BirdFontLabelTool);
	switch (property_id) {
		case BIRD_FONT_LABEL_TOOL_LABEL_PROPERTY:
		bird_font_label_tool_set_label (self, g_value_get_string (value));
		break;
		case BIRD_FONT_LABEL_TOOL_NUMBER_PROPERTY:
		bird_font_label_tool_set_number (self, g_value_get_string (value));
		break;
		case BIRD_FONT_LABEL_TOOL_HAS_COUNTER_PROPERTY:
		bird_font_label_tool_set_has_counter (self, g_value_get_boolean (value));
		break;
		case BIRD_FONT_LABEL_TOOL_HAS_DELETE_BUTTON_PROPERTY:
		bird_font_label_tool_set_has_delete_button (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

