/* bookinfo.c generated by valac 0.56.18, the Vala compiler
 * generated from bookinfo.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and serves as the UI for Book metadata
* information like Table of Contents, Bookmarks
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gee.h>
#include <gio/gio.h>

#define BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS 12
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_CONTENTS _ ("Contents")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_BOOKMARKS _ ("Bookmarks")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_SEARCHRESULTS _ ("Search Results")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_ANNOTATIONS _ ("Annotations")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_DICTIONARY_LOOKUP_TEXT _ ("Select a word in the book and right click for looking up its meaning")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_DICTRESULTS _ ("Word Meaning")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATIONS_FOUND _ ("Click on a link to jump to an annotated section")
#define BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_ANNOTATION_TAB 50
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATIONS_NOT_FOUND _ ("No annotations set in BBB, right click the page of a book and choose a" \
"nnotation from the context menu to add annotations")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOKMARKS_FOUND _ ("Click on a link to jump to bookmarked section")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOKMARKS _ ("Bookmark #NNN for Section PPP")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOKMARKS_NOT_FOUND _ ("No bookmarks set in BBB, click the bookmark icon on the header bar to " \
"bookmark the page")
#define BOOKWORM_APP_CONSTANTS_INSTALL_TASKS_DIR "/usr/share/com.github.babluboy.bookworm/scripts/tasks"
#define BOOKWORM_APP_CONSTANTS_DICTIONARY_SCRIPT_LOCATION BOOKWORM_APP_CONSTANTS_INSTALL_TASKS_DIR "/com.github.babluboy.bookworm.dictionary.sh"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_SEARCH_RESULTS_PROCESSING _ ("Searching for '$$$' in &&&:")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_SEARCH_RESULTS_FOUND _ ("Found the following matches for '$$$' in &&&:")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_SEARCH_RESULTS_NOT_FOUND _ ("No matches found for '$$$' in &&&")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_CONTENT_PREFIX _ ("Content #")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_INFO (bookworm_app_info_get_type ())
#define BOOKWORM_APP_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_INFO, BookwormAppInfo))
#define BOOKWORM_APP_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_INFO, BookwormAppInfoClass))
#define BOOKWORM_APP_IS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_INFO))
#define BOOKWORM_APP_IS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_INFO))
#define BOOKWORM_APP_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_INFO, BookwormAppInfoClass))

typedef struct _BookwormAppInfo BookwormAppInfo;
typedef struct _BookwormAppInfoClass BookwormAppInfoClass;
typedef struct _BookwormAppInfoPrivate BookwormAppInfoPrivate;
enum  {
	BOOKWORM_APP_INFO_0_PROPERTY,
	BOOKWORM_APP_INFO_NUM_PROPERTIES
};
static GParamSpec* bookworm_app_info_properties[BOOKWORM_APP_INFO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _bookworm_app_info_populateSearchResultsData bookworm_app_info_populateSearchResultsData;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;

struct _BookwormAppInfo {
	GtkWindow parent_instance;
	BookwormAppInfoPrivate * priv;
};

struct _BookwormAppInfoClass {
	GtkWindowClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	BookwormAppBook* aBook;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkLinkButton* annotationLinkButton;
};

struct _Block7Data {
	int _ref_count_;
	BookwormAppBook* aBook;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	GtkLinkButton* bookmarkLinkButton;
};

struct _Block9Data {
	int _ref_count_;
	BookwormAppBook* aBook;
	gpointer _async_data_;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	GtkLinkButton* searchResultLinkButton;
};

struct _bookworm_app_info_populateSearchResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BookwormAppBook* result;
	Block9Data* _data9_;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	GtkBox* searchresults_box;
	GtkBox* _tmp3_;
	gboolean hasResultsBeenFound;
	gboolean isSearchResultFocussed;
	GtkLabel* searchLabel;
	GtkSearchEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	BookwormAppBook* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkBox* _tmp19_;
	GtkLabel* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkWidget* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkBox* _tmp24_;
	GeeArrayList* _aBookContentFile_list;
	BookwormAppBook* _tmp25_;
	GeeArrayList* _tmp26_;
	gint _aBookContentFile_size;
	GeeArrayList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _aBookContentFile_index;
	gint _tmp30_;
	gint _tmp31_;
	gchar* aBookContentFile;
	GeeArrayList* _tmp32_;
	gpointer _tmp33_;
	GString* _tmp34_;
	const gchar* _tmp35_;
	GeeTreeMap* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GeeIterator* _entry_it;
	GeeTreeMap* _tmp39_;
	GeeSortedSet* _tmp40_;
	GeeSortedSet* _tmp41_;
	GeeSortedSet* _tmp42_;
	GeeIterator* _tmp43_;
	GeeIterator* _tmp44_;
	Block10Data* _data10_;
	GeeIterator* _tmp45_;
	GeeMapEntry* entry;
	GeeIterator* _tmp46_;
	gpointer _tmp47_;
	gchar* pageNumber;
	GeeMapEntry* _tmp48_;
	gconstpointer _tmp49_;
	gconstpointer _tmp50_;
	GeeMapEntry* _tmp51_;
	gconstpointer _tmp52_;
	gconstpointer _tmp53_;
	GeeMapEntry* _tmp54_;
	gconstpointer _tmp55_;
	gconstpointer _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GeeMapEntry* _tmp69_;
	gconstpointer _tmp70_;
	gconstpointer _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	GtkLinkButton* _tmp78_;
	GtkLinkButton* _tmp79_;
	GtkLinkButton* _tmp80_;
	GtkBox* _tmp81_;
	GtkLinkButton* _tmp82_;
	GtkLinkButton* _tmp83_;
	GtkLinkButton* _tmp84_;
	GtkLinkButton* _tmp85_;
	GtkLinkButton* _tmp86_;
	GtkBox* _tmp87_;
	GtkLabel* _tmp88_;
	GtkSearchEntry* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	BookwormAppBook* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	GtkLabel* _tmp102_;
	GtkSearchEntry* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	BookwormAppBook* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	BookwormAppBook* _tmp116_;
	BookwormAppBook* _tmp117_;
};

struct _Block11Data {
	int _ref_count_;
	BookwormAppBook* aBook;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	GtkLinkButton* contentLinkButton;
};

struct _Block13Data {
	int _ref_count_;
	Block11Data * _data11_;
	GtkLinkButton* contentLinkButton;
};

static gpointer bookworm_app_info_parent_class = NULL;
VALA_EXTERN GtkBox* bookworm_app_info_info_box;
GtkBox* bookworm_app_info_info_box = NULL;
VALA_EXTERN GtkStack* bookworm_app_info_stack;
GtkStack* bookworm_app_info_stack = NULL;
VALA_EXTERN GtkBox* bookworm_app_info_content_box;
GtkBox* bookworm_app_info_content_box = NULL;
VALA_EXTERN GtkScrolledWindow* bookworm_app_info_content_scroll;
GtkScrolledWindow* bookworm_app_info_content_scroll = NULL;
VALA_EXTERN GtkBox* bookworm_app_info_bookmarks_box;
GtkBox* bookworm_app_info_bookmarks_box = NULL;
VALA_EXTERN GtkScrolledWindow* bookworm_app_info_bookmarks_scroll;
GtkScrolledWindow* bookworm_app_info_bookmarks_scroll = NULL;
VALA_EXTERN GtkBox* bookworm_app_info_searchresults_box;
GtkBox* bookworm_app_info_searchresults_box = NULL;
VALA_EXTERN GtkScrolledWindow* bookworm_app_info_searchresults_scroll;
GtkScrolledWindow* bookworm_app_info_searchresults_scroll = NULL;
VALA_EXTERN GtkBox* bookworm_app_info_annotations_box;
GtkBox* bookworm_app_info_annotations_box = NULL;
VALA_EXTERN GtkScrolledWindow* bookworm_app_info_annotations_scroll;
GtkScrolledWindow* bookworm_app_info_annotations_scroll = NULL;
VALA_EXTERN GtkBox* bookworm_app_info_dictionary_box;
GtkBox* bookworm_app_info_dictionary_box = NULL;
VALA_EXTERN GtkLabel* bookworm_app_info_dictionaryResultsLabel;
GtkLabel* bookworm_app_info_dictionaryResultsLabel = NULL;
VALA_EXTERN GtkScrolledWindow* bookworm_app_info_dictionary_scroll;
GtkScrolledWindow* bookworm_app_info_dictionary_scroll = NULL;
VALA_EXTERN GtkLinkButton* bookworm_app_info_firstSearchResultLinkButton;
GtkLinkButton* bookworm_app_info_firstSearchResultLinkButton = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;
VALA_EXTERN gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
VALA_EXTERN GtkSearchEntry* bookworm_app_app_header_bar_headerSearchBar;
VALA_EXTERN GString* bookworm_app_bookworm_aContentFileToBeSearched;
VALA_EXTERN GeeTreeMap* bookworm_app_bookworm_searchResultsMap;
VALA_EXTERN gchar* bookworm_app_bookworm_bookTextSearchString;
VALA_EXTERN gboolean bookworm_app_bookworm_isPageScrollRequired;

VALA_EXTERN GType bookworm_app_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppInfo, g_object_unref)
VALA_EXTERN GtkBox* bookworm_app_info_createBookInfo (void);
static void __lambda5_ (GObject* sender,
                 GParamSpec* property);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_info_createTableOfContents (void);
VALA_EXTERN void bookworm_app_info_populateBookmarks (void);
VALA_EXTERN void bookworm_app_info_populateAnnotations (void);
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN void bookworm_app_settings_set_current_info_tab (BookwormAppSettings* self,
                                                 const gchar* value);
static void ___lambda5__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN GeeTreeMap* bookworm_app_book_getAnnotationList (BookwormAppBook* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN gchar* bookworm_app_utils_minimizeStringLength (const gchar* originalString,
                                                gint maxLength);
static gboolean _____lambda43_ (Block6Data* _data6_);
VALA_EXTERN void bookworm_app_book_setBookPageNumber (BookwormAppBook* self,
                                          gint aBookPageNumber);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                                          gchar* direction);
VALA_EXTERN void bookworm_app_bookworm_toggleUIState (void);
static gboolean ______lambda43__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                        gpointer self);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
VALA_EXTERN gchar* bookworm_app_book_getBookmark (BookwormAppBook* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean ______lambda42_ (Block8Data* _data8_);
static gboolean _______lambda42__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                         gpointer self);
VALA_EXTERN void bookworm_app_info_populateDictionaryResults (const gchar* word);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
static void bookworm_app_info_populateSearchResults_data_free (gpointer _data);
VALA_EXTERN void bookworm_app_info_populateSearchResults (GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN BookwormAppBook* bookworm_app_info_populateSearchResults_finish (GAsyncResult* _res_);
static gboolean bookworm_app_info_populateSearchResults_co (bookworm_app_info_populateSearchResultsData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
static gboolean _bookworm_app_info_populateSearchResults_co_gsource_func (gpointer self);
VALA_EXTERN void bookworm_app_content_handler_searchHTMLContents (void);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
VALA_EXTERN gchar* bookworm_app_utils_parseMarkUp (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_info_getChapterNameFromPage (const gchar* pageNumber);
static gboolean _______lambda44_ (Block10Data* _data10_);
static gboolean ________lambda44__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                          gpointer self);
VALA_EXTERN GeeArrayList* bookworm_app_book_getTOC (BookwormAppBook* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN GtkWidget* bookworm_app_book_getBookWidget (BookwormAppBook* self,
                                            const gchar* name);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean _________lambda6_ (Block12Data* _data12_);
VALA_EXTERN void bookworm_app_book_setAnchor (BookwormAppBook* self,
                                  const gchar* aBookAnchor);
static gboolean __________lambda6__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                           gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
VALA_EXTERN void bookworm_app_book_setTOC (BookwormAppBook* self,
                               GeeHashMap* toc);
static gboolean _______lambda41_ (Block13Data* _data13_);
static gboolean ________lambda41__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                          gpointer self);
VALA_EXTERN void bookworm_app_book_setBookWidget (BookwormAppBook* self,
                                      const gchar* name,
                                      GtkWidget* aWidget);
VALA_EXTERN BookwormAppInfo* bookworm_app_info_new (void);
VALA_EXTERN BookwormAppInfo* bookworm_app_info_construct (GType object_type);
static void bookworm_app_info_finalize (GObject * obj);
static GType bookworm_app_info_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[8];

static void
__lambda5_ (GObject* sender,
            GParamSpec* property)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GtkStack* _tmp4_;
	const gchar* _tmp5_;
	GtkStack* _tmp6_;
	const gchar* _tmp7_;
	GtkStack* _tmp8_;
	const gchar* _tmp9_;
	GtkStack* _tmp12_;
	const gchar* _tmp13_;
	BookwormAppSettings* _tmp14_;
	GtkStack* _tmp15_;
	const gchar* _tmp16_;
#line 88 "../src/bookinfo.vala"
	g_return_if_fail (sender != NULL);
#line 88 "../src/bookinfo.vala"
	g_return_if_fail (property != NULL);
#line 89 "../src/bookinfo.vala"
	_tmp0_ = bookworm_app_info_stack;
#line 89 "../src/bookinfo.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 89 "../src/bookinfo.vala"
	if (g_strcmp0 ("content-list", _tmp1_) == 0) {
#line 495 "bookinfo.c"
		BookwormAppBook* _tmp2_;
		BookwormAppBook* _tmp3_;
#line 90 "../src/bookinfo.vala"
		_tmp2_ = bookworm_app_info_createTableOfContents ();
#line 90 "../src/bookinfo.vala"
		_tmp3_ = _tmp2_;
#line 90 "../src/bookinfo.vala"
		_bookworm_app_book_unref0 (_tmp3_);
#line 504 "bookinfo.c"
	}
#line 92 "../src/bookinfo.vala"
	_tmp4_ = bookworm_app_info_stack;
#line 92 "../src/bookinfo.vala"
	_tmp5_ = gtk_stack_get_visible_child_name (_tmp4_);
#line 92 "../src/bookinfo.vala"
	if (g_strcmp0 ("bookmark-list", _tmp5_) == 0) {
#line 93 "../src/bookinfo.vala"
		bookworm_app_info_populateBookmarks ();
#line 514 "bookinfo.c"
	}
#line 95 "../src/bookinfo.vala"
	_tmp6_ = bookworm_app_info_stack;
#line 95 "../src/bookinfo.vala"
	_tmp7_ = gtk_stack_get_visible_child_name (_tmp6_);
#line 95 "../src/bookinfo.vala"
	if (g_strcmp0 ("annotations-list", _tmp7_) == 0) {
#line 96 "../src/bookinfo.vala"
		bookworm_app_info_populateAnnotations ();
#line 524 "bookinfo.c"
	}
#line 98 "../src/bookinfo.vala"
	_tmp8_ = bookworm_app_info_stack;
#line 98 "../src/bookinfo.vala"
	_tmp9_ = gtk_stack_get_visible_child_name (_tmp8_);
#line 98 "../src/bookinfo.vala"
	if (g_strcmp0 ("searchresults-list", _tmp9_) == 0) {
#line 532 "bookinfo.c"
		GtkLinkButton* _tmp10_;
#line 100 "../src/bookinfo.vala"
		_tmp10_ = bookworm_app_info_firstSearchResultLinkButton;
#line 100 "../src/bookinfo.vala"
		if (_tmp10_ != NULL) {
#line 538 "bookinfo.c"
			GtkLinkButton* _tmp11_;
#line 101 "../src/bookinfo.vala"
			_tmp11_ = bookworm_app_info_firstSearchResultLinkButton;
#line 101 "../src/bookinfo.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp11_);
#line 544 "bookinfo.c"
		}
	}
#line 104 "../src/bookinfo.vala"
	_tmp12_ = bookworm_app_info_stack;
#line 104 "../src/bookinfo.vala"
	_tmp13_ = gtk_stack_get_visible_child_name (_tmp12_);
#line 104 "../src/bookinfo.vala"
	if (g_strcmp0 ("dictionary-list", _tmp13_) == 0) {
#line 553 "bookinfo.c"
	}
#line 108 "../src/bookinfo.vala"
	_tmp14_ = bookworm_app_bookworm_settings;
#line 108 "../src/bookinfo.vala"
	_tmp15_ = bookworm_app_info_stack;
#line 108 "../src/bookinfo.vala"
	_tmp16_ = gtk_stack_get_visible_child_name (_tmp15_);
#line 108 "../src/bookinfo.vala"
	bookworm_app_settings_set_current_info_tab (_tmp14_, _tmp16_);
#line 563 "bookinfo.c"
}

static void
___lambda5__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
#line 88 "../src/bookinfo.vala"
	__lambda5_ (_sender, pspec);
#line 573 "bookinfo.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 111 "../src/bookinfo.vala"
	return self ? g_object_ref (self) : NULL;
#line 581 "bookinfo.c"
}

GtkBox*
bookworm_app_info_createBookInfo (void)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	GtkStack* _tmp4_;
	GtkStackSwitcher* switcher = NULL;
	GtkStackSwitcher* _tmp5_;
	GtkStack* _tmp6_;
	GtkBox* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	GtkBox* _tmp11_;
	GtkStack* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkBox* _tmp14_;
	GtkScrolledWindow* _tmp15_;
	GtkScrolledWindow* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkBox* _tmp18_;
	GtkStack* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkBox* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkBox* _tmp25_;
	GtkStack* _tmp26_;
	GtkScrolledWindow* _tmp27_;
	GtkBox* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkBox* _tmp32_;
	GtkStack* _tmp33_;
	GtkScrolledWindow* _tmp34_;
	GtkLabel* _tmp35_;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	GtkLabel* _tmp38_;
	GtkScrolledWindow* _tmp39_;
	GtkScrolledWindow* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkBox* _tmp42_;
	GtkStack* _tmp43_;
	GtkScrolledWindow* _tmp44_;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GtkStack* _tmp47_;
	GtkStack* _tmp48_;
	GtkBox* _tmp49_;
	GtkBox* _tmp50_;
	GtkBox* result;
#line 38 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:38: [START] [FUNCTION:createBookInfo]");
#line 39 "../src/bookinfo.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 39 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp0_);
#line 39 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_info_box);
#line 39 "../src/bookinfo.vala"
	bookworm_app_info_info_box = _tmp0_;
#line 40 "../src/bookinfo.vala"
	_tmp1_ = bookworm_app_info_info_box;
#line 40 "../src/bookinfo.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp1_, (guint) BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 43 "../src/bookinfo.vala"
	_tmp2_ = (GtkStack*) gtk_stack_new ();
#line 43 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp2_);
#line 43 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_stack);
#line 43 "../src/bookinfo.vala"
	bookworm_app_info_stack = _tmp2_;
#line 44 "../src/bookinfo.vala"
	_tmp3_ = bookworm_app_info_stack;
#line 44 "../src/bookinfo.vala"
	gtk_stack_set_transition_type (_tmp3_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
#line 45 "../src/bookinfo.vala"
	_tmp4_ = bookworm_app_info_stack;
#line 45 "../src/bookinfo.vala"
	gtk_stack_set_transition_duration (_tmp4_, (guint) 1000);
#line 48 "../src/bookinfo.vala"
	_tmp5_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
#line 48 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp5_);
#line 48 "../src/bookinfo.vala"
	switcher = _tmp5_;
#line 49 "../src/bookinfo.vala"
	gtk_widget_set_halign ((GtkWidget*) switcher, GTK_ALIGN_CENTER);
#line 50 "../src/bookinfo.vala"
	_tmp6_ = bookworm_app_info_stack;
#line 50 "../src/bookinfo.vala"
	gtk_stack_switcher_set_stack (switcher, _tmp6_);
#line 52 "../src/bookinfo.vala"
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 52 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp7_);
#line 52 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_content_box);
#line 52 "../src/bookinfo.vala"
	bookworm_app_info_content_box = _tmp7_;
#line 53 "../src/bookinfo.vala"
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 53 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp8_);
#line 53 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_content_scroll);
#line 53 "../src/bookinfo.vala"
	bookworm_app_info_content_scroll = _tmp8_;
#line 54 "../src/bookinfo.vala"
	_tmp9_ = bookworm_app_info_content_scroll;
#line 54 "../src/bookinfo.vala"
	gtk_scrolled_window_set_policy (_tmp9_, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 55 "../src/bookinfo.vala"
	_tmp10_ = bookworm_app_info_content_scroll;
#line 55 "../src/bookinfo.vala"
	_tmp11_ = bookworm_app_info_content_box;
#line 55 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
#line 56 "../src/bookinfo.vala"
	_tmp12_ = bookworm_app_info_stack;
#line 56 "../src/bookinfo.vala"
	_tmp13_ = bookworm_app_info_content_scroll;
#line 56 "../src/bookinfo.vala"
	gtk_stack_add_titled (_tmp12_, (GtkWidget*) _tmp13_, "content-list", BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_CONTENTS);
#line 58 "../src/bookinfo.vala"
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 58 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp14_);
#line 58 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_bookmarks_box);
#line 58 "../src/bookinfo.vala"
	bookworm_app_info_bookmarks_box = _tmp14_;
#line 59 "../src/bookinfo.vala"
	_tmp15_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 59 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp15_);
#line 59 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_bookmarks_scroll);
#line 59 "../src/bookinfo.vala"
	bookworm_app_info_bookmarks_scroll = _tmp15_;
#line 60 "../src/bookinfo.vala"
	_tmp16_ = bookworm_app_info_bookmarks_scroll;
#line 60 "../src/bookinfo.vala"
	gtk_scrolled_window_set_policy (_tmp16_, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 61 "../src/bookinfo.vala"
	_tmp17_ = bookworm_app_info_bookmarks_scroll;
#line 61 "../src/bookinfo.vala"
	_tmp18_ = bookworm_app_info_bookmarks_box;
#line 61 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
#line 62 "../src/bookinfo.vala"
	_tmp19_ = bookworm_app_info_stack;
#line 62 "../src/bookinfo.vala"
	_tmp20_ = bookworm_app_info_bookmarks_scroll;
#line 62 "../src/bookinfo.vala"
	gtk_stack_add_titled (_tmp19_, (GtkWidget*) _tmp20_, "bookmark-list", BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_BOOKMARKS);
#line 64 "../src/bookinfo.vala"
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 64 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp21_);
#line 64 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_searchresults_box);
#line 64 "../src/bookinfo.vala"
	bookworm_app_info_searchresults_box = _tmp21_;
#line 65 "../src/bookinfo.vala"
	_tmp22_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 65 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp22_);
#line 65 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_searchresults_scroll);
#line 65 "../src/bookinfo.vala"
	bookworm_app_info_searchresults_scroll = _tmp22_;
#line 66 "../src/bookinfo.vala"
	_tmp23_ = bookworm_app_info_searchresults_scroll;
#line 66 "../src/bookinfo.vala"
	gtk_scrolled_window_set_policy (_tmp23_, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 67 "../src/bookinfo.vala"
	_tmp24_ = bookworm_app_info_searchresults_scroll;
#line 67 "../src/bookinfo.vala"
	_tmp25_ = bookworm_app_info_searchresults_box;
#line 67 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
#line 68 "../src/bookinfo.vala"
	_tmp26_ = bookworm_app_info_stack;
#line 68 "../src/bookinfo.vala"
	_tmp27_ = bookworm_app_info_searchresults_scroll;
#line 68 "../src/bookinfo.vala"
	gtk_stack_add_titled (_tmp26_, (GtkWidget*) _tmp27_, "searchresults-list", BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_SEARCHRESULTS);
#line 70 "../src/bookinfo.vala"
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 70 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp28_);
#line 70 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_annotations_box);
#line 70 "../src/bookinfo.vala"
	bookworm_app_info_annotations_box = _tmp28_;
#line 71 "../src/bookinfo.vala"
	_tmp29_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 71 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp29_);
#line 71 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_annotations_scroll);
#line 71 "../src/bookinfo.vala"
	bookworm_app_info_annotations_scroll = _tmp29_;
#line 72 "../src/bookinfo.vala"
	_tmp30_ = bookworm_app_info_annotations_scroll;
#line 72 "../src/bookinfo.vala"
	gtk_scrolled_window_set_policy (_tmp30_, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 73 "../src/bookinfo.vala"
	_tmp31_ = bookworm_app_info_annotations_scroll;
#line 73 "../src/bookinfo.vala"
	_tmp32_ = bookworm_app_info_annotations_box;
#line 73 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
#line 74 "../src/bookinfo.vala"
	_tmp33_ = bookworm_app_info_stack;
#line 74 "../src/bookinfo.vala"
	_tmp34_ = bookworm_app_info_annotations_scroll;
#line 74 "../src/bookinfo.vala"
	gtk_stack_add_titled (_tmp33_, (GtkWidget*) _tmp34_, "annotations-list", BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_ANNOTATIONS);
#line 76 "../src/bookinfo.vala"
	_tmp35_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_DICTIONARY_LOOKUP_TEXT);
#line 76 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp35_);
#line 76 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_dictionaryResultsLabel);
#line 76 "../src/bookinfo.vala"
	bookworm_app_info_dictionaryResultsLabel = _tmp35_;
#line 77 "../src/bookinfo.vala"
	_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 77 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp36_);
#line 77 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_dictionary_box);
#line 77 "../src/bookinfo.vala"
	bookworm_app_info_dictionary_box = _tmp36_;
#line 78 "../src/bookinfo.vala"
	_tmp37_ = bookworm_app_info_dictionary_box;
#line 78 "../src/bookinfo.vala"
	_tmp38_ = bookworm_app_info_dictionaryResultsLabel;
#line 78 "../src/bookinfo.vala"
	gtk_box_pack_start (_tmp37_, (GtkWidget*) _tmp38_, FALSE, FALSE, (guint) 0);
#line 79 "../src/bookinfo.vala"
	_tmp39_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 79 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp39_);
#line 79 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_dictionary_scroll);
#line 79 "../src/bookinfo.vala"
	bookworm_app_info_dictionary_scroll = _tmp39_;
#line 80 "../src/bookinfo.vala"
	_tmp40_ = bookworm_app_info_dictionary_scroll;
#line 80 "../src/bookinfo.vala"
	gtk_scrolled_window_set_policy (_tmp40_, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 81 "../src/bookinfo.vala"
	_tmp41_ = bookworm_app_info_dictionary_scroll;
#line 81 "../src/bookinfo.vala"
	_tmp42_ = bookworm_app_info_dictionary_box;
#line 81 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
#line 82 "../src/bookinfo.vala"
	_tmp43_ = bookworm_app_info_stack;
#line 82 "../src/bookinfo.vala"
	_tmp44_ = bookworm_app_info_dictionary_scroll;
#line 82 "../src/bookinfo.vala"
	gtk_stack_add_titled (_tmp43_, (GtkWidget*) _tmp44_, "dictionary-list", BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_DICTRESULTS);
#line 84 "../src/bookinfo.vala"
	_tmp45_ = bookworm_app_info_info_box;
#line 84 "../src/bookinfo.vala"
	gtk_box_pack_start (_tmp45_, (GtkWidget*) switcher, FALSE, TRUE, (guint) 0);
#line 85 "../src/bookinfo.vala"
	_tmp46_ = bookworm_app_info_info_box;
#line 85 "../src/bookinfo.vala"
	_tmp47_ = bookworm_app_info_stack;
#line 85 "../src/bookinfo.vala"
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, TRUE, TRUE, (guint) 0);
#line 88 "../src/bookinfo.vala"
	_tmp48_ = bookworm_app_info_stack;
#line 88 "../src/bookinfo.vala"
	g_signal_connect ((GObject*) _tmp48_, "notify::visible-child", (GCallback) ___lambda5__g_object_notify, NULL);
#line 110 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:110: [END] [FUNCTION:createBookInfo]");
#line 111 "../src/bookinfo.vala"
	_tmp49_ = bookworm_app_info_info_box;
#line 111 "../src/bookinfo.vala"
	_tmp50_ = _g_object_ref0 (_tmp49_);
#line 111 "../src/bookinfo.vala"
	result = _tmp50_;
#line 111 "../src/bookinfo.vala"
	_g_object_unref0 (switcher);
#line 111 "../src/bookinfo.vala"
	return result;
#line 882 "bookinfo.c"
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 114 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 114 "../src/bookinfo.vala"
	return _data5_;
#line 892 "bookinfo.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 114 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 114 "../src/bookinfo.vala"
		_bookworm_app_book_unref0 (_data5_->aBook);
#line 114 "../src/bookinfo.vala"
		g_slice_free (Block5Data, _data5_);
#line 906 "bookinfo.c"
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 123 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 123 "../src/bookinfo.vala"
	return _data6_;
#line 917 "bookinfo.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 123 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 123 "../src/bookinfo.vala"
		_g_object_unref0 (_data6_->annotationLinkButton);
#line 123 "../src/bookinfo.vala"
		block5_data_unref (_data6_->_data5_);
#line 123 "../src/bookinfo.vala"
		_data6_->_data5_ = NULL;
#line 123 "../src/bookinfo.vala"
		g_slice_free (Block6Data, _data6_);
#line 935 "bookinfo.c"
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 957 "bookinfo.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 979 "bookinfo.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 983 "bookinfo.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 989 "bookinfo.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 993 "bookinfo.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 997 "bookinfo.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1005 "bookinfo.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1033 "bookinfo.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1042 "bookinfo.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1056 "bookinfo.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1065 "bookinfo.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1079 "bookinfo.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1088 "bookinfo.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1097 "bookinfo.c"
}

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 139 "../src/bookinfo.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 1105 "bookinfo.c"
}

static gboolean
_____lambda43_ (Block6Data* _data6_)
{
	Block5Data* _data5_;
	BookwormAppBook* _tmp0_;
	GtkLinkButton* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeHashMap* _tmp5_;
	BookwormAppBook* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BookwormAppBook* _tmp9_;
	BookwormAppBook* _tmp10_;
	BookwormAppBook* _tmp11_;
	gchar* _tmp12_;
	BookwormAppBook* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean result;
#line 135 "../src/bookinfo.vala"
	_data5_ = _data6_->_data5_;
#line 136 "../src/bookinfo.vala"
	_tmp0_ = _data5_->aBook;
#line 136 "../src/bookinfo.vala"
	_tmp1_ = _data6_->annotationLinkButton;
#line 136 "../src/bookinfo.vala"
	_tmp2_ = gtk_link_button_get_uri (_tmp1_);
#line 136 "../src/bookinfo.vala"
	_tmp3_ = string_strip (_tmp2_);
#line 136 "../src/bookinfo.vala"
	_tmp4_ = _tmp3_;
#line 136 "../src/bookinfo.vala"
	bookworm_app_book_setBookPageNumber (_tmp0_, atoi (_tmp4_));
#line 136 "../src/bookinfo.vala"
	_g_free0 (_tmp4_);
#line 138 "../src/bookinfo.vala"
	_tmp5_ = bookworm_app_bookworm_libraryViewMap;
#line 138 "../src/bookinfo.vala"
	_tmp6_ = _data5_->aBook;
#line 138 "../src/bookinfo.vala"
	_tmp7_ = bookworm_app_book_getBookLocation (_tmp6_);
#line 138 "../src/bookinfo.vala"
	_tmp8_ = _tmp7_;
#line 138 "../src/bookinfo.vala"
	_tmp9_ = _data5_->aBook;
#line 138 "../src/bookinfo.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp8_, _tmp9_);
#line 138 "../src/bookinfo.vala"
	_g_free0 (_tmp8_);
#line 139 "../src/bookinfo.vala"
	_tmp10_ = _data5_->aBook;
#line 139 "../src/bookinfo.vala"
	_tmp11_ = _bookworm_app_book_ref0 (_tmp10_);
#line 139 "../src/bookinfo.vala"
	_tmp12_ = g_strdup ("");
#line 139 "../src/bookinfo.vala"
	_tmp13_ = bookworm_app_content_handler_renderPage (_tmp11_, _tmp12_);
#line 139 "../src/bookinfo.vala"
	_bookworm_app_book_unref0 (_data5_->aBook);
#line 139 "../src/bookinfo.vala"
	_data5_->aBook = _tmp13_;
#line 141 "../src/bookinfo.vala"
	_tmp14_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 141 "../src/bookinfo.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 141 "../src/bookinfo.vala"
	_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 141 "../src/bookinfo.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp15_;
#line 142 "../src/bookinfo.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 143 "../src/bookinfo.vala"
	result = TRUE;
#line 143 "../src/bookinfo.vala"
	return result;
#line 1185 "bookinfo.c"
}

static gboolean
______lambda43__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                               gpointer self)
{
	gboolean result;
	result = _____lambda43_ (self);
#line 135 "../src/bookinfo.vala"
	return result;
#line 1196 "bookinfo.c"
}

void
bookworm_app_info_populateAnnotations (void)
{
	Block5Data* _data5_;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	GtkLabel* annotationsLabel = NULL;
	GtkLabel* _tmp3_;
	GtkBox* annotations_box = NULL;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	GeeTreeMap* aAnnotationMap = NULL;
	BookwormAppBook* _tmp7_;
	GeeTreeMap* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeTreeMap* _tmp10_;
	GtkScrolledWindow* _tmp85_;
	GtkWidget* _tmp86_;
	GtkScrolledWindow* _tmp87_;
	GtkBox* _tmp88_;
	GtkBox* _tmp89_;
#line 114 "../src/bookinfo.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 114 "../src/bookinfo.vala"
	_data5_->_ref_count_ = 1;
#line 115 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:115: [START] [FUNCTION:populateAnnotations]");
#line 117 "../src/bookinfo.vala"
	_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 117 "../src/bookinfo.vala"
	_tmp1_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 117 "../src/bookinfo.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 117 "../src/bookinfo.vala"
	_data5_->aBook = (BookwormAppBook*) _tmp2_;
#line 118 "../src/bookinfo.vala"
	_tmp3_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATIONS_FOUND);
#line 118 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp3_);
#line 118 "../src/bookinfo.vala"
	annotationsLabel = _tmp3_;
#line 119 "../src/bookinfo.vala"
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 119 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp4_);
#line 119 "../src/bookinfo.vala"
	annotations_box = _tmp4_;
#line 120 "../src/bookinfo.vala"
	_tmp5_ = annotations_box;
#line 120 "../src/bookinfo.vala"
	_tmp6_ = annotationsLabel;
#line 120 "../src/bookinfo.vala"
	gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
#line 121 "../src/bookinfo.vala"
	_tmp7_ = _data5_->aBook;
#line 121 "../src/bookinfo.vala"
	_tmp8_ = bookworm_app_book_getAnnotationList (_tmp7_);
#line 121 "../src/bookinfo.vala"
	aAnnotationMap = _tmp8_;
#line 122 "../src/bookinfo.vala"
	_tmp10_ = aAnnotationMap;
#line 122 "../src/bookinfo.vala"
	if (_tmp10_ != NULL) {
#line 1264 "bookinfo.c"
		GeeTreeMap* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 122 "../src/bookinfo.vala"
		_tmp11_ = aAnnotationMap;
#line 122 "../src/bookinfo.vala"
		_tmp12_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp11_);
#line 122 "../src/bookinfo.vala"
		_tmp13_ = _tmp12_;
#line 122 "../src/bookinfo.vala"
		_tmp9_ = _tmp13_ > 0;
#line 1276 "bookinfo.c"
	} else {
#line 122 "../src/bookinfo.vala"
		_tmp9_ = FALSE;
#line 1280 "bookinfo.c"
	}
#line 122 "../src/bookinfo.vala"
	if (_tmp9_) {
#line 1284 "bookinfo.c"
		{
			GeeIterator* _entry_it = NULL;
			GeeTreeMap* _tmp14_;
			GeeSortedSet* _tmp15_;
			GeeSortedSet* _tmp16_;
			GeeSortedSet* _tmp17_;
			GeeIterator* _tmp18_;
			GeeIterator* _tmp19_;
#line 123 "../src/bookinfo.vala"
			_tmp14_ = aAnnotationMap;
#line 123 "../src/bookinfo.vala"
			_tmp15_ = gee_abstract_sorted_map_get_ascending_entries ((GeeAbstractSortedMap*) _tmp14_);
#line 123 "../src/bookinfo.vala"
			_tmp16_ = _tmp15_;
#line 123 "../src/bookinfo.vala"
			_tmp17_ = _tmp16_;
#line 123 "../src/bookinfo.vala"
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
#line 123 "../src/bookinfo.vala"
			_tmp19_ = _tmp18_;
#line 123 "../src/bookinfo.vala"
			_g_object_unref0 (_tmp17_);
#line 123 "../src/bookinfo.vala"
			_entry_it = _tmp19_;
#line 123 "../src/bookinfo.vala"
			while (TRUE) {
#line 1311 "bookinfo.c"
				Block6Data* _data6_;
				GeeIterator* _tmp20_;
				GeeMapEntry* entry = NULL;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				GeeMapEntry* _tmp23_;
				gconstpointer _tmp24_;
				gconstpointer _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar** _tmp28_;
				gchar** _tmp29_;
				gchar** _tmp30_;
				gint _tmp30__length1;
				const gchar* _tmp31_;
				GeeMapEntry* _tmp32_;
				gconstpointer _tmp33_;
				gconstpointer _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar** _tmp37_;
				gchar** _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				GeeMapEntry* _tmp45_;
				gconstpointer _tmp46_;
				gconstpointer _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar** _tmp50_;
				gchar** _tmp51_;
				gchar** _tmp52_;
				gint _tmp52__length1;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				GeeMapEntry* _tmp62_;
				gconstpointer _tmp63_;
				gconstpointer _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				GtkLinkButton* _tmp73_;
				GtkLinkButton* _tmp74_;
				GtkLinkButton* _tmp75_;
				GtkBox* _tmp76_;
				GtkLinkButton* _tmp77_;
				GtkLinkButton* _tmp78_;
#line 123 "../src/bookinfo.vala"
				_data6_ = g_slice_new0 (Block6Data);
#line 123 "../src/bookinfo.vala"
				_data6_->_ref_count_ = 1;
#line 123 "../src/bookinfo.vala"
				_data6_->_data5_ = block5_data_ref (_data5_);
#line 123 "../src/bookinfo.vala"
				_tmp20_ = _entry_it;
#line 123 "../src/bookinfo.vala"
				if (!gee_iterator_next (_tmp20_)) {
#line 123 "../src/bookinfo.vala"
					block6_data_unref (_data6_);
#line 123 "../src/bookinfo.vala"
					_data6_ = NULL;
#line 123 "../src/bookinfo.vala"
					break;
#line 1392 "bookinfo.c"
				}
#line 123 "../src/bookinfo.vala"
				_tmp21_ = _entry_it;
#line 123 "../src/bookinfo.vala"
				_tmp22_ = gee_iterator_get (_tmp21_);
#line 123 "../src/bookinfo.vala"
				entry = (GeeMapEntry*) _tmp22_;
#line 124 "../src/bookinfo.vala"
				_tmp23_ = entry;
#line 124 "../src/bookinfo.vala"
				_tmp24_ = gee_map_entry_get_key (_tmp23_);
#line 124 "../src/bookinfo.vala"
				_tmp25_ = _tmp24_;
#line 124 "../src/bookinfo.vala"
				_tmp26_ = string_strip ((const gchar*) _tmp25_);
#line 124 "../src/bookinfo.vala"
				_tmp27_ = _tmp26_;
#line 124 "../src/bookinfo.vala"
				_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "#~~#", 0);
#line 124 "../src/bookinfo.vala"
				_tmp30_ = _tmp29_;
#line 124 "../src/bookinfo.vala"
				_tmp30__length1 = _vala_array_length (_tmp28_);
#line 124 "../src/bookinfo.vala"
				_tmp31_ = _tmp30_[0];
#line 124 "../src/bookinfo.vala"
				_tmp32_ = entry;
#line 124 "../src/bookinfo.vala"
				_tmp33_ = gee_map_entry_get_key (_tmp32_);
#line 124 "../src/bookinfo.vala"
				_tmp34_ = _tmp33_;
#line 124 "../src/bookinfo.vala"
				_tmp35_ = string_strip ((const gchar*) _tmp34_);
#line 124 "../src/bookinfo.vala"
				_tmp36_ = _tmp35_;
#line 124 "../src/bookinfo.vala"
				_tmp38_ = _tmp37_ = g_strsplit (_tmp36_, "#~~#", 0);
#line 124 "../src/bookinfo.vala"
				_tmp39_ = _tmp38_;
#line 124 "../src/bookinfo.vala"
				_tmp39__length1 = _vala_array_length (_tmp37_);
#line 124 "../src/bookinfo.vala"
				_tmp40_ = _tmp39_[0];
#line 124 "../src/bookinfo.vala"
				_tmp41_ = g_strconcat ("Section ", _tmp40_, NULL);
#line 124 "../src/bookinfo.vala"
				_tmp42_ = _tmp41_;
#line 124 "../src/bookinfo.vala"
				_tmp43_ = g_strconcat (_tmp42_, " [", NULL);
#line 124 "../src/bookinfo.vala"
				_tmp44_ = _tmp43_;
#line 124 "../src/bookinfo.vala"
				_tmp45_ = entry;
#line 124 "../src/bookinfo.vala"
				_tmp46_ = gee_map_entry_get_key (_tmp45_);
#line 124 "../src/bookinfo.vala"
				_tmp47_ = _tmp46_;
#line 124 "../src/bookinfo.vala"
				_tmp48_ = string_strip ((const gchar*) _tmp47_);
#line 124 "../src/bookinfo.vala"
				_tmp49_ = _tmp48_;
#line 124 "../src/bookinfo.vala"
				_tmp51_ = _tmp50_ = g_strsplit (_tmp49_, "#~~#", 0);
#line 124 "../src/bookinfo.vala"
				_tmp52_ = _tmp51_;
#line 124 "../src/bookinfo.vala"
				_tmp52__length1 = _vala_array_length (_tmp50_);
#line 124 "../src/bookinfo.vala"
				_tmp53_ = _tmp52_[1];
#line 124 "../src/bookinfo.vala"
				_tmp54_ = string_replace (_tmp53_, "\n", " ");
#line 124 "../src/bookinfo.vala"
				_tmp55_ = _tmp54_;
#line 124 "../src/bookinfo.vala"
				_tmp56_ = bookworm_app_utils_minimizeStringLength (_tmp55_, BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_ANNOTATION_TAB);
#line 124 "../src/bookinfo.vala"
				_tmp57_ = _tmp56_;
#line 124 "../src/bookinfo.vala"
				_tmp58_ = g_strconcat (_tmp44_, _tmp57_, NULL);
#line 124 "../src/bookinfo.vala"
				_tmp59_ = _tmp58_;
#line 124 "../src/bookinfo.vala"
				_tmp60_ = g_strconcat (_tmp59_, "] : ", NULL);
#line 124 "../src/bookinfo.vala"
				_tmp61_ = _tmp60_;
#line 124 "../src/bookinfo.vala"
				_tmp62_ = entry;
#line 124 "../src/bookinfo.vala"
				_tmp63_ = gee_map_entry_get_value (_tmp62_);
#line 124 "../src/bookinfo.vala"
				_tmp64_ = _tmp63_;
#line 124 "../src/bookinfo.vala"
				_tmp65_ = string_strip ((const gchar*) _tmp64_);
#line 124 "../src/bookinfo.vala"
				_tmp66_ = _tmp65_;
#line 124 "../src/bookinfo.vala"
				_tmp67_ = string_replace (_tmp66_, "\n", " ");
#line 124 "../src/bookinfo.vala"
				_tmp68_ = _tmp67_;
#line 124 "../src/bookinfo.vala"
				_tmp69_ = bookworm_app_utils_minimizeStringLength (_tmp68_, BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_ANNOTATION_TAB);
#line 124 "../src/bookinfo.vala"
				_tmp70_ = _tmp69_;
#line 124 "../src/bookinfo.vala"
				_tmp71_ = g_strconcat (_tmp61_, _tmp70_, NULL);
#line 124 "../src/bookinfo.vala"
				_tmp72_ = _tmp71_;
#line 124 "../src/bookinfo.vala"
				_tmp73_ = (GtkLinkButton*) gtk_link_button_new_with_label (_tmp31_, _tmp72_);
#line 124 "../src/bookinfo.vala"
				g_object_ref_sink (_tmp73_);
#line 124 "../src/bookinfo.vala"
				_tmp74_ = _tmp73_;
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp72_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp70_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp68_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp66_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp61_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp59_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp57_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp55_);
#line 124 "../src/bookinfo.vala"
				_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp49_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp44_);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp42_);
#line 124 "../src/bookinfo.vala"
				_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp36_);
#line 124 "../src/bookinfo.vala"
				_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 124 "../src/bookinfo.vala"
				_g_free0 (_tmp27_);
#line 124 "../src/bookinfo.vala"
				_data6_->annotationLinkButton = _tmp74_;
#line 133 "../src/bookinfo.vala"
				_tmp75_ = _data6_->annotationLinkButton;
#line 133 "../src/bookinfo.vala"
				gtk_widget_set_halign ((GtkWidget*) _tmp75_, GTK_ALIGN_START);
#line 134 "../src/bookinfo.vala"
				_tmp76_ = annotations_box;
#line 134 "../src/bookinfo.vala"
				_tmp77_ = _data6_->annotationLinkButton;
#line 134 "../src/bookinfo.vala"
				gtk_box_pack_start (_tmp76_, (GtkWidget*) _tmp77_, FALSE, FALSE, (guint) 0);
#line 135 "../src/bookinfo.vala"
				_tmp78_ = _data6_->annotationLinkButton;
#line 135 "../src/bookinfo.vala"
				g_signal_connect_data (_tmp78_, "activate-link", (GCallback) ______lambda43__gtk_link_button_activate_link, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 123 "../src/bookinfo.vala"
				_g_object_unref0 (entry);
#line 123 "../src/bookinfo.vala"
				block6_data_unref (_data6_);
#line 123 "../src/bookinfo.vala"
				_data6_ = NULL;
#line 1560 "bookinfo.c"
			}
#line 123 "../src/bookinfo.vala"
			_g_object_unref0 (_entry_it);
#line 1564 "bookinfo.c"
		}
	} else {
		GtkLabel* _tmp79_;
		BookwormAppBook* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
#line 147 "../src/bookinfo.vala"
		_tmp79_ = annotationsLabel;
#line 147 "../src/bookinfo.vala"
		_tmp80_ = _data5_->aBook;
#line 147 "../src/bookinfo.vala"
		_tmp81_ = bookworm_app_book_getBookTitle (_tmp80_);
#line 147 "../src/bookinfo.vala"
		_tmp82_ = _tmp81_;
#line 147 "../src/bookinfo.vala"
		_tmp83_ = string_replace (BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATIONS_NOT_FOUND, "BBB", _tmp82_);
#line 147 "../src/bookinfo.vala"
		_tmp84_ = _tmp83_;
#line 147 "../src/bookinfo.vala"
		gtk_label_set_text (_tmp79_, _tmp84_);
#line 147 "../src/bookinfo.vala"
		_g_free0 (_tmp84_);
#line 147 "../src/bookinfo.vala"
		_g_free0 (_tmp82_);
#line 1591 "bookinfo.c"
	}
#line 150 "../src/bookinfo.vala"
	_tmp85_ = bookworm_app_info_annotations_scroll;
#line 150 "../src/bookinfo.vala"
	_tmp86_ = gtk_bin_get_child ((GtkBin*) _tmp85_);
#line 150 "../src/bookinfo.vala"
	gtk_widget_destroy (_tmp86_);
#line 151 "../src/bookinfo.vala"
	_tmp87_ = bookworm_app_info_annotations_scroll;
#line 151 "../src/bookinfo.vala"
	_tmp88_ = annotations_box;
#line 151 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp87_, (GtkWidget*) _tmp88_);
#line 152 "../src/bookinfo.vala"
	_tmp89_ = annotations_box;
#line 152 "../src/bookinfo.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp89_);
#line 153 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:153: [END] [FUNCTION:populateAnnotations]");
#line 114 "../src/bookinfo.vala"
	_g_object_unref0 (aAnnotationMap);
#line 114 "../src/bookinfo.vala"
	_g_object_unref0 (annotations_box);
#line 114 "../src/bookinfo.vala"
	_g_object_unref0 (annotationsLabel);
#line 114 "../src/bookinfo.vala"
	block5_data_unref (_data5_);
#line 114 "../src/bookinfo.vala"
	_data5_ = NULL;
#line 1621 "bookinfo.c"
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 156 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 156 "../src/bookinfo.vala"
	return _data7_;
#line 1631 "bookinfo.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 156 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 156 "../src/bookinfo.vala"
		_bookworm_app_book_unref0 (_data7_->aBook);
#line 156 "../src/bookinfo.vala"
		g_slice_free (Block7Data, _data7_);
#line 1645 "bookinfo.c"
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1670 "bookinfo.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1678 "bookinfo.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1684 "bookinfo.c"
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 167 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 167 "../src/bookinfo.vala"
	return _data8_;
#line 1695 "bookinfo.c"
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 167 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 167 "../src/bookinfo.vala"
		_g_object_unref0 (_data8_->bookmarkLinkButton);
#line 167 "../src/bookinfo.vala"
		block7_data_unref (_data8_->_data7_);
#line 167 "../src/bookinfo.vala"
		_data8_->_data7_ = NULL;
#line 167 "../src/bookinfo.vala"
		g_slice_free (Block8Data, _data8_);
#line 1713 "bookinfo.c"
	}
}

static gboolean
______lambda42_ (Block8Data* _data8_)
{
	Block7Data* _data7_;
	BookwormAppBook* _tmp0_;
	GtkLinkButton* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeHashMap* _tmp5_;
	BookwormAppBook* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BookwormAppBook* _tmp9_;
	BookwormAppBook* _tmp10_;
	BookwormAppBook* _tmp11_;
	gchar* _tmp12_;
	BookwormAppBook* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean result;
#line 175 "../src/bookinfo.vala"
	_data7_ = _data8_->_data7_;
#line 176 "../src/bookinfo.vala"
	_tmp0_ = _data7_->aBook;
#line 176 "../src/bookinfo.vala"
	_tmp1_ = _data8_->bookmarkLinkButton;
#line 176 "../src/bookinfo.vala"
	_tmp2_ = gtk_link_button_get_uri (_tmp1_);
#line 176 "../src/bookinfo.vala"
	_tmp3_ = string_strip (_tmp2_);
#line 176 "../src/bookinfo.vala"
	_tmp4_ = _tmp3_;
#line 176 "../src/bookinfo.vala"
	bookworm_app_book_setBookPageNumber (_tmp0_, atoi (_tmp4_));
#line 176 "../src/bookinfo.vala"
	_g_free0 (_tmp4_);
#line 178 "../src/bookinfo.vala"
	_tmp5_ = bookworm_app_bookworm_libraryViewMap;
#line 178 "../src/bookinfo.vala"
	_tmp6_ = _data7_->aBook;
#line 178 "../src/bookinfo.vala"
	_tmp7_ = bookworm_app_book_getBookLocation (_tmp6_);
#line 178 "../src/bookinfo.vala"
	_tmp8_ = _tmp7_;
#line 178 "../src/bookinfo.vala"
	_tmp9_ = _data7_->aBook;
#line 178 "../src/bookinfo.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp8_, _tmp9_);
#line 178 "../src/bookinfo.vala"
	_g_free0 (_tmp8_);
#line 179 "../src/bookinfo.vala"
	_tmp10_ = _data7_->aBook;
#line 179 "../src/bookinfo.vala"
	_tmp11_ = _bookworm_app_book_ref0 (_tmp10_);
#line 179 "../src/bookinfo.vala"
	_tmp12_ = g_strdup ("");
#line 179 "../src/bookinfo.vala"
	_tmp13_ = bookworm_app_content_handler_renderPage (_tmp11_, _tmp12_);
#line 179 "../src/bookinfo.vala"
	_bookworm_app_book_unref0 (_data7_->aBook);
#line 179 "../src/bookinfo.vala"
	_data7_->aBook = _tmp13_;
#line 181 "../src/bookinfo.vala"
	_tmp14_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 181 "../src/bookinfo.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 181 "../src/bookinfo.vala"
	_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 181 "../src/bookinfo.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp15_;
#line 182 "../src/bookinfo.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 183 "../src/bookinfo.vala"
	result = TRUE;
#line 183 "../src/bookinfo.vala"
	return result;
#line 1794 "bookinfo.c"
}

static gboolean
_______lambda42__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                gpointer self)
{
	gboolean result;
	result = ______lambda42_ (self);
#line 175 "../src/bookinfo.vala"
	return result;
#line 1805 "bookinfo.c"
}

void
bookworm_app_info_populateBookmarks (void)
{
	Block7Data* _data7_;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	GtkBox* bookmarks_box = NULL;
	GtkBox* _tmp3_;
	GtkLabel* bookmarksLabel = NULL;
	GtkLabel* _tmp4_;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	BookwormAppBook* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	GtkScrolledWindow* _tmp47_;
	GtkWidget* _tmp48_;
	GtkScrolledWindow* _tmp49_;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
#line 156 "../src/bookinfo.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 156 "../src/bookinfo.vala"
	_data7_->_ref_count_ = 1;
#line 157 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:157: [START] [FUNCTION:populateBookmarks]");
#line 159 "../src/bookinfo.vala"
	_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 159 "../src/bookinfo.vala"
	_tmp1_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 159 "../src/bookinfo.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 159 "../src/bookinfo.vala"
	_data7_->aBook = (BookwormAppBook*) _tmp2_;
#line 160 "../src/bookinfo.vala"
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 160 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp3_);
#line 160 "../src/bookinfo.vala"
	bookmarks_box = _tmp3_;
#line 161 "../src/bookinfo.vala"
	_tmp4_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOKMARKS_FOUND);
#line 161 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp4_);
#line 161 "../src/bookinfo.vala"
	bookmarksLabel = _tmp4_;
#line 162 "../src/bookinfo.vala"
	_tmp5_ = bookmarks_box;
#line 162 "../src/bookinfo.vala"
	_tmp6_ = bookmarksLabel;
#line 162 "../src/bookinfo.vala"
	gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
#line 163 "../src/bookinfo.vala"
	_tmp7_ = _data7_->aBook;
#line 163 "../src/bookinfo.vala"
	_tmp8_ = bookworm_app_book_getBookmark (_tmp7_);
#line 163 "../src/bookinfo.vala"
	_tmp9_ = _tmp8_;
#line 163 "../src/bookinfo.vala"
	_tmp10_ = string_index_of (_tmp9_, "**", 0) != -1;
#line 163 "../src/bookinfo.vala"
	_g_free0 (_tmp9_);
#line 163 "../src/bookinfo.vala"
	if (_tmp10_) {
#line 1874 "bookinfo.c"
		gchar** bookmarkList = NULL;
		BookwormAppBook* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gint bookmarkList_length1;
		gint _bookmarkList_size_;
		gint bookmarkNumber = 0;
		gchar** _tmp17_;
		gint _tmp17__length1;
#line 164 "../src/bookinfo.vala"
		_tmp11_ = _data7_->aBook;
#line 164 "../src/bookinfo.vala"
		_tmp12_ = bookworm_app_book_getBookmark (_tmp11_);
#line 164 "../src/bookinfo.vala"
		_tmp13_ = _tmp12_;
#line 164 "../src/bookinfo.vala"
		_tmp15_ = _tmp14_ = g_strsplit_set (_tmp13_, "**", -1);
#line 164 "../src/bookinfo.vala"
		_tmp16_ = _tmp15_;
#line 164 "../src/bookinfo.vala"
		_tmp16__length1 = _vala_array_length (_tmp14_);
#line 164 "../src/bookinfo.vala"
		_g_free0 (_tmp13_);
#line 164 "../src/bookinfo.vala"
		bookmarkList = _tmp16_;
#line 164 "../src/bookinfo.vala"
		bookmarkList_length1 = _tmp16__length1;
#line 164 "../src/bookinfo.vala"
		_bookmarkList_size_ = bookmarkList_length1;
#line 165 "../src/bookinfo.vala"
		bookmarkNumber = 1;
#line 166 "../src/bookinfo.vala"
		_tmp17_ = bookmarkList;
#line 166 "../src/bookinfo.vala"
		_tmp17__length1 = bookmarkList_length1;
#line 1914 "bookinfo.c"
		{
			gchar** bookmarkedPage_collection = NULL;
			gint bookmarkedPage_collection_length1 = 0;
			gint _bookmarkedPage_collection_size_ = 0;
			gint bookmarkedPage_it = 0;
#line 166 "../src/bookinfo.vala"
			bookmarkedPage_collection = _tmp17_;
#line 166 "../src/bookinfo.vala"
			bookmarkedPage_collection_length1 = _tmp17__length1;
#line 166 "../src/bookinfo.vala"
			for (bookmarkedPage_it = 0; bookmarkedPage_it < bookmarkedPage_collection_length1; bookmarkedPage_it = bookmarkedPage_it + 1) {
#line 1926 "bookinfo.c"
				gchar* _tmp18_;
				gchar* bookmarkedPage = NULL;
#line 166 "../src/bookinfo.vala"
				_tmp18_ = g_strdup (bookmarkedPage_collection[bookmarkedPage_it]);
#line 166 "../src/bookinfo.vala"
				bookmarkedPage = _tmp18_;
#line 1933 "bookinfo.c"
				{
					gboolean _tmp19_ = FALSE;
					const gchar* _tmp20_;
#line 167 "../src/bookinfo.vala"
					_tmp20_ = bookmarkedPage;
#line 167 "../src/bookinfo.vala"
					if (_tmp20_ != NULL) {
#line 1941 "bookinfo.c"
						const gchar* _tmp21_;
						gint _tmp22_;
						gint _tmp23_;
#line 167 "../src/bookinfo.vala"
						_tmp21_ = bookmarkedPage;
#line 167 "../src/bookinfo.vala"
						_tmp22_ = strlen (_tmp21_);
#line 167 "../src/bookinfo.vala"
						_tmp23_ = _tmp22_;
#line 167 "../src/bookinfo.vala"
						_tmp19_ = _tmp23_ > 0;
#line 1953 "bookinfo.c"
					} else {
#line 167 "../src/bookinfo.vala"
						_tmp19_ = FALSE;
#line 1957 "bookinfo.c"
					}
#line 167 "../src/bookinfo.vala"
					if (_tmp19_) {
#line 1961 "bookinfo.c"
						Block8Data* _data8_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						GtkLinkButton* _tmp34_;
						GtkLinkButton* _tmp35_;
						gint _tmp36_;
						GtkLinkButton* _tmp37_;
						GtkBox* _tmp38_;
						GtkLinkButton* _tmp39_;
						GtkLinkButton* _tmp40_;
#line 167 "../src/bookinfo.vala"
						_data8_ = g_slice_new0 (Block8Data);
#line 167 "../src/bookinfo.vala"
						_data8_->_ref_count_ = 1;
#line 167 "../src/bookinfo.vala"
						_data8_->_data7_ = block7_data_ref (_data7_);
#line 168 "../src/bookinfo.vala"
						_tmp24_ = bookmarkedPage;
#line 168 "../src/bookinfo.vala"
						_tmp25_ = g_strdup_printf ("%i", bookmarkNumber);
#line 168 "../src/bookinfo.vala"
						_tmp26_ = _tmp25_;
#line 168 "../src/bookinfo.vala"
						_tmp27_ = string_replace (BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOKMARKS, "NNN", _tmp26_);
#line 168 "../src/bookinfo.vala"
						_tmp28_ = _tmp27_;
#line 168 "../src/bookinfo.vala"
						_tmp29_ = bookmarkedPage;
#line 168 "../src/bookinfo.vala"
						_tmp30_ = g_strdup_printf ("%i", atoi (_tmp29_) + 1);
#line 168 "../src/bookinfo.vala"
						_tmp31_ = _tmp30_;
#line 168 "../src/bookinfo.vala"
						_tmp32_ = string_replace (_tmp28_, "PPP", _tmp31_);
#line 168 "../src/bookinfo.vala"
						_tmp33_ = _tmp32_;
#line 168 "../src/bookinfo.vala"
						_tmp34_ = (GtkLinkButton*) gtk_link_button_new_with_label (_tmp24_, _tmp33_);
#line 168 "../src/bookinfo.vala"
						g_object_ref_sink (_tmp34_);
#line 168 "../src/bookinfo.vala"
						_tmp35_ = _tmp34_;
#line 168 "../src/bookinfo.vala"
						_g_free0 (_tmp33_);
#line 168 "../src/bookinfo.vala"
						_g_free0 (_tmp31_);
#line 168 "../src/bookinfo.vala"
						_g_free0 (_tmp28_);
#line 168 "../src/bookinfo.vala"
						_g_free0 (_tmp26_);
#line 168 "../src/bookinfo.vala"
						_data8_->bookmarkLinkButton = _tmp35_;
#line 172 "../src/bookinfo.vala"
						_tmp36_ = bookmarkNumber;
#line 172 "../src/bookinfo.vala"
						bookmarkNumber = _tmp36_ + 1;
#line 173 "../src/bookinfo.vala"
						_tmp37_ = _data8_->bookmarkLinkButton;
#line 173 "../src/bookinfo.vala"
						gtk_widget_set_halign ((GtkWidget*) _tmp37_, GTK_ALIGN_START);
#line 174 "../src/bookinfo.vala"
						_tmp38_ = bookmarks_box;
#line 174 "../src/bookinfo.vala"
						_tmp39_ = _data8_->bookmarkLinkButton;
#line 174 "../src/bookinfo.vala"
						gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
#line 175 "../src/bookinfo.vala"
						_tmp40_ = _data8_->bookmarkLinkButton;
#line 175 "../src/bookinfo.vala"
						g_signal_connect_data (_tmp40_, "activate-link", (GCallback) _______lambda42__gtk_link_button_activate_link, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 167 "../src/bookinfo.vala"
						block8_data_unref (_data8_);
#line 167 "../src/bookinfo.vala"
						_data8_ = NULL;
#line 2044 "bookinfo.c"
					}
#line 166 "../src/bookinfo.vala"
					_g_free0 (bookmarkedPage);
#line 2048 "bookinfo.c"
				}
			}
		}
#line 163 "../src/bookinfo.vala"
		bookmarkList = (_vala_array_free (bookmarkList, bookmarkList_length1, (GDestroyNotify) g_free), NULL);
#line 2054 "bookinfo.c"
	} else {
		GtkLabel* _tmp41_;
		BookwormAppBook* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
#line 188 "../src/bookinfo.vala"
		_tmp41_ = bookmarksLabel;
#line 188 "../src/bookinfo.vala"
		_tmp42_ = _data7_->aBook;
#line 188 "../src/bookinfo.vala"
		_tmp43_ = bookworm_app_book_getBookTitle (_tmp42_);
#line 188 "../src/bookinfo.vala"
		_tmp44_ = _tmp43_;
#line 188 "../src/bookinfo.vala"
		_tmp45_ = string_replace (BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOKMARKS_NOT_FOUND, "BBB", _tmp44_);
#line 188 "../src/bookinfo.vala"
		_tmp46_ = _tmp45_;
#line 188 "../src/bookinfo.vala"
		gtk_label_set_text (_tmp41_, _tmp46_);
#line 188 "../src/bookinfo.vala"
		_g_free0 (_tmp46_);
#line 188 "../src/bookinfo.vala"
		_g_free0 (_tmp44_);
#line 2080 "bookinfo.c"
	}
#line 191 "../src/bookinfo.vala"
	_tmp47_ = bookworm_app_info_bookmarks_scroll;
#line 191 "../src/bookinfo.vala"
	_tmp48_ = gtk_bin_get_child ((GtkBin*) _tmp47_);
#line 191 "../src/bookinfo.vala"
	gtk_widget_destroy (_tmp48_);
#line 192 "../src/bookinfo.vala"
	_tmp49_ = bookworm_app_info_bookmarks_scroll;
#line 192 "../src/bookinfo.vala"
	_tmp50_ = bookmarks_box;
#line 192 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
#line 193 "../src/bookinfo.vala"
	_tmp51_ = bookworm_app_info_info_box;
#line 193 "../src/bookinfo.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp51_);
#line 194 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:194: [END] [FUNCTION:populateBookmarks]");
#line 156 "../src/bookinfo.vala"
	_g_object_unref0 (bookmarksLabel);
#line 156 "../src/bookinfo.vala"
	_g_object_unref0 (bookmarks_box);
#line 156 "../src/bookinfo.vala"
	block7_data_unref (_data7_);
#line 156 "../src/bookinfo.vala"
	_data7_ = NULL;
#line 2108 "bookinfo.c"
}

void
bookworm_app_info_populateDictionaryResults (const gchar* word)
{
	GtkBox* dictionary_box = NULL;
	GtkBox* _tmp0_;
	GtkLabel* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkWidget* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkBox* _tmp7_;
	gchar* dictionaryResults = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GtkBox* _tmp30_;
#line 197 "../src/bookinfo.vala"
	g_return_if_fail (word != NULL);
#line 198 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:198: [START] [FUNCTION:populateDictionaryResults]");
#line 200 "../src/bookinfo.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 200 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp0_);
#line 200 "../src/bookinfo.vala"
	dictionary_box = _tmp0_;
#line 201 "../src/bookinfo.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
#line 201 "../src/bookinfo.vala"
	g_object_ref_sink (_tmp1_);
#line 201 "../src/bookinfo.vala"
	_g_object_unref0 (bookworm_app_info_dictionaryResultsLabel);
#line 201 "../src/bookinfo.vala"
	bookworm_app_info_dictionaryResultsLabel = _tmp1_;
#line 202 "../src/bookinfo.vala"
	_tmp2_ = dictionary_box;
#line 202 "../src/bookinfo.vala"
	_tmp3_ = bookworm_app_info_dictionaryResultsLabel;
#line 202 "../src/bookinfo.vala"
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
#line 204 "../src/bookinfo.vala"
	_tmp4_ = bookworm_app_info_dictionary_scroll;
#line 204 "../src/bookinfo.vala"
	_tmp5_ = gtk_bin_get_child ((GtkBin*) _tmp4_);
#line 204 "../src/bookinfo.vala"
	gtk_widget_destroy (_tmp5_);
#line 205 "../src/bookinfo.vala"
	_tmp6_ = bookworm_app_info_dictionary_scroll;
#line 205 "../src/bookinfo.vala"
	_tmp7_ = dictionary_box;
#line 205 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
#line 206 "../src/bookinfo.vala"
	_tmp8_ = g_strdup ("");
#line 206 "../src/bookinfo.vala"
	dictionaryResults = _tmp8_;
#line 208 "../src/bookinfo.vala"
	if (word == NULL) {
#line 208 "../src/bookinfo.vala"
		_tmp9_ = TRUE;
#line 2171 "bookinfo.c"
	} else {
		gchar* _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 208 "../src/bookinfo.vala"
		_tmp10_ = string_strip (word);
#line 208 "../src/bookinfo.vala"
		_tmp11_ = _tmp10_;
#line 208 "../src/bookinfo.vala"
		_tmp12_ = strlen (_tmp11_);
#line 208 "../src/bookinfo.vala"
		_tmp13_ = _tmp12_;
#line 208 "../src/bookinfo.vala"
		_tmp9_ = _tmp13_ < 1;
#line 208 "../src/bookinfo.vala"
		_g_free0 (_tmp11_);
#line 2189 "bookinfo.c"
	}
#line 208 "../src/bookinfo.vala"
	if (_tmp9_) {
#line 2193 "bookinfo.c"
		GtkLabel* _tmp14_;
#line 209 "../src/bookinfo.vala"
		_tmp14_ = bookworm_app_info_dictionaryResultsLabel;
#line 209 "../src/bookinfo.vala"
		gtk_label_set_text (_tmp14_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_DICTIONARY_LOOKUP_TEXT);
#line 2199 "bookinfo.c"
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GtkLabel* _tmp28_;
		const gchar* _tmp29_;
#line 212 "../src/bookinfo.vala"
		_tmp15_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 212 "../src/bookinfo.vala"
		_tmp16_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 212 "../src/bookinfo.vala"
		if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
#line 2217 "bookinfo.c"
			const gchar* _tmp17_;
			gchar* _tmp18_;
			GtkStack* _tmp19_;
			GtkStack* _tmp20_;
			GtkWidget* _tmp21_;
#line 216 "../src/bookinfo.vala"
			_tmp17_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 216 "../src/bookinfo.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 216 "../src/bookinfo.vala"
			_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 216 "../src/bookinfo.vala"
			bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp18_;
#line 217 "../src/bookinfo.vala"
			bookworm_app_bookworm_toggleUIState ();
#line 219 "../src/bookinfo.vala"
			_tmp19_ = bookworm_app_info_stack;
#line 219 "../src/bookinfo.vala"
			_tmp20_ = bookworm_app_info_stack;
#line 219 "../src/bookinfo.vala"
			_tmp21_ = gtk_stack_get_child_by_name (_tmp20_, "dictionary-list");
#line 219 "../src/bookinfo.vala"
			gtk_stack_set_visible_child (_tmp19_, _tmp21_);
#line 2241 "bookinfo.c"
		}
#line 224 "../src/bookinfo.vala"
		_tmp22_ = g_strconcat (BOOKWORM_APP_CONSTANTS_DICTIONARY_SCRIPT_LOCATION " ", word, NULL);
#line 224 "../src/bookinfo.vala"
		_tmp23_ = _tmp22_;
#line 224 "../src/bookinfo.vala"
		_tmp24_ = bookworm_app_utils_execute_sync_command (_tmp23_);
#line 224 "../src/bookinfo.vala"
		_g_free0 (dictionaryResults);
#line 224 "../src/bookinfo.vala"
		dictionaryResults = _tmp24_;
#line 224 "../src/bookinfo.vala"
		_g_free0 (_tmp23_);
#line 227 "../src/bookinfo.vala"
		_tmp25_ = dictionaryResults;
#line 227 "../src/bookinfo.vala"
		_tmp26_ = g_strconcat ("Dictionary Search Results:", _tmp25_, NULL);
#line 227 "../src/bookinfo.vala"
		_tmp27_ = _tmp26_;
#line 227 "../src/bookinfo.vala"
		g_debug ("bookinfo.vala:227: %s", _tmp27_);
#line 227 "../src/bookinfo.vala"
		_g_free0 (_tmp27_);
#line 228 "../src/bookinfo.vala"
		_tmp28_ = bookworm_app_info_dictionaryResultsLabel;
#line 228 "../src/bookinfo.vala"
		_tmp29_ = dictionaryResults;
#line 228 "../src/bookinfo.vala"
		gtk_label_set_text (_tmp28_, _tmp29_);
#line 2271 "bookinfo.c"
	}
#line 230 "../src/bookinfo.vala"
	_tmp30_ = bookworm_app_info_info_box;
#line 230 "../src/bookinfo.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp30_);
#line 231 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:231: [END] [FUNCTION:populateDictionaryResults]");
#line 197 "../src/bookinfo.vala"
	_g_free0 (dictionaryResults);
#line 197 "../src/bookinfo.vala"
	_g_object_unref0 (dictionary_box);
#line 2283 "bookinfo.c"
}

static void
bookworm_app_info_populateSearchResults_data_free (gpointer _data)
{
	bookworm_app_info_populateSearchResultsData* _data_;
	_data_ = _data;
#line 21 "../src/bookinfo.vala"
	_bookworm_app_book_unref0 (_data_->result);
#line 21 "../src/bookinfo.vala"
	g_slice_free (bookworm_app_info_populateSearchResultsData, _data_);
#line 2295 "bookinfo.c"
}

void
bookworm_app_info_populateSearchResults (GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	bookworm_app_info_populateSearchResultsData* _data_;
#line 21 "../src/bookinfo.vala"
	_data_ = g_slice_new0 (bookworm_app_info_populateSearchResultsData);
#line 21 "../src/bookinfo.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 21 "../src/bookinfo.vala"
	g_task_set_task_data (_data_->_async_result, _data_, bookworm_app_info_populateSearchResults_data_free);
#line 21 "../src/bookinfo.vala"
	bookworm_app_info_populateSearchResults_co (_data_);
#line 2311 "bookinfo.c"
}

BookwormAppBook*
bookworm_app_info_populateSearchResults_finish (GAsyncResult* _res_)
{
	BookwormAppBook* result;
	bookworm_app_info_populateSearchResultsData* _data_;
#line 21 "../src/bookinfo.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 21 "../src/bookinfo.vala"
	result = _data_->result;
#line 21 "../src/bookinfo.vala"
	_data_->result = NULL;
#line 21 "../src/bookinfo.vala"
	return result;
#line 2327 "bookinfo.c"
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 234 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 234 "../src/bookinfo.vala"
	return _data9_;
#line 2337 "bookinfo.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 234 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 234 "../src/bookinfo.vala"
		_bookworm_app_book_unref0 (_data9_->aBook);
#line 234 "../src/bookinfo.vala"
		g_slice_free (Block9Data, _data9_);
#line 2351 "bookinfo.c"
	}
}

static gboolean
_bookworm_app_info_populateSearchResults_co_gsource_func (gpointer self)
{
	gboolean result;
	result = bookworm_app_info_populateSearchResults_co (self);
#line 260 "../src/bookinfo.vala"
	return result;
#line 2362 "bookinfo.c"
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
#line 267 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 267 "../src/bookinfo.vala"
	return _data10_;
#line 2372 "bookinfo.c"
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 267 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 267 "../src/bookinfo.vala"
		_g_object_unref0 (_data10_->searchResultLinkButton);
#line 267 "../src/bookinfo.vala"
		block9_data_unref (_data10_->_data9_);
#line 267 "../src/bookinfo.vala"
		_data10_->_data9_ = NULL;
#line 267 "../src/bookinfo.vala"
		g_slice_free (Block10Data, _data10_);
#line 2390 "bookinfo.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 2418 "bookinfo.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 2424 "bookinfo.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 2430 "bookinfo.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 2434 "bookinfo.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 2442 "bookinfo.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 2446 "bookinfo.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 2458 "bookinfo.c"
}

static gboolean
_______lambda44_ (Block10Data* _data10_)
{
	Block9Data* _data9_;
	BookwormAppBook* _tmp0_;
	BookwormAppBook* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GtkLinkButton* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	BookwormAppBook* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	BookwormAppBook* _tmp12_;
	GtkSearchEntry* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkLinkButton* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	BookwormAppBook* _tmp20_;
	BookwormAppBook* _tmp21_;
	gchar* _tmp22_;
	BookwormAppBook* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean result;
#line 280 "../src/bookinfo.vala"
	_data9_ = _data10_->_data9_;
#line 281 "../src/bookinfo.vala"
	_tmp0_ = _data9_->aBook;
#line 281 "../src/bookinfo.vala"
	_tmp1_ = _data9_->aBook;
#line 281 "../src/bookinfo.vala"
	_tmp2_ = bookworm_app_book_getBookContentList (_tmp1_);
#line 281 "../src/bookinfo.vala"
	_tmp3_ = _tmp2_;
#line 281 "../src/bookinfo.vala"
	_tmp4_ = _data10_->searchResultLinkButton;
#line 281 "../src/bookinfo.vala"
	_tmp5_ = gtk_link_button_get_uri (_tmp4_);
#line 281 "../src/bookinfo.vala"
	_tmp6_ = string_strip (_tmp5_);
#line 281 "../src/bookinfo.vala"
	_tmp7_ = _tmp6_;
#line 281 "../src/bookinfo.vala"
	bookworm_app_book_setBookPageNumber (_tmp0_, gee_abstract_list_index_of ((GeeAbstractList*) _tmp3_, _tmp7_));
#line 281 "../src/bookinfo.vala"
	_g_free0 (_tmp7_);
#line 281 "../src/bookinfo.vala"
	_g_object_unref0 (_tmp3_);
#line 283 "../src/bookinfo.vala"
	_tmp8_ = bookworm_app_bookworm_libraryViewMap;
#line 283 "../src/bookinfo.vala"
	_tmp9_ = _data9_->aBook;
#line 283 "../src/bookinfo.vala"
	_tmp10_ = bookworm_app_book_getBookLocation (_tmp9_);
#line 283 "../src/bookinfo.vala"
	_tmp11_ = _tmp10_;
#line 283 "../src/bookinfo.vala"
	_tmp12_ = _data9_->aBook;
#line 283 "../src/bookinfo.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 283 "../src/bookinfo.vala"
	_g_free0 (_tmp11_);
#line 284 "../src/bookinfo.vala"
	_tmp13_ = bookworm_app_app_header_bar_headerSearchBar;
#line 284 "../src/bookinfo.vala"
	_tmp14_ = gtk_entry_get_text ((GtkEntry*) _tmp13_);
#line 284 "../src/bookinfo.vala"
	_tmp15_ = g_strconcat (_tmp14_, "#~~#", NULL);
#line 284 "../src/bookinfo.vala"
	_tmp16_ = _tmp15_;
#line 284 "../src/bookinfo.vala"
	_tmp17_ = _data10_->searchResultLinkButton;
#line 284 "../src/bookinfo.vala"
	_tmp18_ = gtk_button_get_label ((GtkButton*) _tmp17_);
#line 284 "../src/bookinfo.vala"
	_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
#line 284 "../src/bookinfo.vala"
	_g_free0 (bookworm_app_bookworm_bookTextSearchString);
#line 284 "../src/bookinfo.vala"
	bookworm_app_bookworm_bookTextSearchString = _tmp19_;
#line 284 "../src/bookinfo.vala"
	_g_free0 (_tmp16_);
#line 286 "../src/bookinfo.vala"
	_tmp20_ = _data9_->aBook;
#line 286 "../src/bookinfo.vala"
	_tmp21_ = _bookworm_app_book_ref0 (_tmp20_);
#line 286 "../src/bookinfo.vala"
	_tmp22_ = g_strdup ("SEARCH");
#line 286 "../src/bookinfo.vala"
	_tmp23_ = bookworm_app_content_handler_renderPage (_tmp21_, _tmp22_);
#line 286 "../src/bookinfo.vala"
	_bookworm_app_book_unref0 (_data9_->aBook);
#line 286 "../src/bookinfo.vala"
	_data9_->aBook = _tmp23_;
#line 288 "../src/bookinfo.vala"
	_tmp24_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 288 "../src/bookinfo.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 288 "../src/bookinfo.vala"
	_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 288 "../src/bookinfo.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp25_;
#line 289 "../src/bookinfo.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 290 "../src/bookinfo.vala"
	result = TRUE;
#line 290 "../src/bookinfo.vala"
	return result;
#line 2576 "bookinfo.c"
}

static gboolean
________lambda44__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                 gpointer self)
{
	gboolean result;
	result = _______lambda44_ (self);
#line 280 "../src/bookinfo.vala"
	return result;
#line 2587 "bookinfo.c"
}

static gboolean
bookworm_app_info_populateSearchResults_co (bookworm_app_info_populateSearchResultsData* _data_)
{
#line 234 "../src/bookinfo.vala"
	switch (_data_->_state_) {
#line 234 "../src/bookinfo.vala"
		case 0:
#line 2597 "bookinfo.c"
		goto _state_0;
#line 234 "../src/bookinfo.vala"
		case 1:
#line 2601 "bookinfo.c"
		goto _state_1;
		default:
#line 234 "../src/bookinfo.vala"
		g_assert_not_reached ();
#line 2606 "bookinfo.c"
	}
	_state_0:
#line 234 "../src/bookinfo.vala"
	_data_->_data9_ = g_slice_new0 (Block9Data);
#line 234 "../src/bookinfo.vala"
	_data_->_data9_->_ref_count_ = 1;
#line 234 "../src/bookinfo.vala"
	_data_->_data9_->_async_data_ = _data_;
#line 235 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:235: [START] [FUNCTION:populateSearchResults]");
#line 236 "../src/bookinfo.vala"
	_data_->_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 236 "../src/bookinfo.vala"
	_data_->_tmp1_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 236 "../src/bookinfo.vala"
	_data_->_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp0_, _data_->_tmp1_);
#line 236 "../src/bookinfo.vala"
	_data_->_data9_->aBook = (BookwormAppBook*) _data_->_tmp2_;
#line 237 "../src/bookinfo.vala"
	_data_->_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 237 "../src/bookinfo.vala"
	g_object_ref_sink (_data_->_tmp3_);
#line 237 "../src/bookinfo.vala"
	_data_->searchresults_box = _data_->_tmp3_;
#line 238 "../src/bookinfo.vala"
	_data_->hasResultsBeenFound = FALSE;
#line 239 "../src/bookinfo.vala"
	_data_->isSearchResultFocussed = FALSE;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp4_ = bookworm_app_app_header_bar_headerSearchBar;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp5_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp4_);
#line 241 "../src/bookinfo.vala"
	_data_->_tmp6_ = bookworm_app_utils_minimizeStringLength (_data_->_tmp5_, 50);
#line 241 "../src/bookinfo.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp8_ = string_replace (BOOKWORM_APP_CONSTANTS_TEXT_FOR_SEARCH_RESULTS_PROCESSING, "$$$", _data_->_tmp7_);
#line 241 "../src/bookinfo.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp10_ = _data_->_data9_->aBook;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp11_ = bookworm_app_book_getBookTitle (_data_->_tmp10_);
#line 241 "../src/bookinfo.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp13_ = bookworm_app_utils_minimizeStringLength (_data_->_tmp12_, 35);
#line 241 "../src/bookinfo.vala"
	_data_->_tmp14_ = _data_->_tmp13_;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp15_ = string_replace (_data_->_tmp9_, "&&&", _data_->_tmp14_);
#line 241 "../src/bookinfo.vala"
	_data_->_tmp16_ = _data_->_tmp15_;
#line 241 "../src/bookinfo.vala"
	_data_->_tmp17_ = (GtkLabel*) gtk_label_new (_data_->_tmp16_);
#line 241 "../src/bookinfo.vala"
	g_object_ref_sink (_data_->_tmp17_);
#line 241 "../src/bookinfo.vala"
	_data_->_tmp18_ = _data_->_tmp17_;
#line 241 "../src/bookinfo.vala"
	_g_free0 (_data_->_tmp16_);
#line 241 "../src/bookinfo.vala"
	_g_free0 (_data_->_tmp14_);
#line 241 "../src/bookinfo.vala"
	_g_free0 (_data_->_tmp12_);
#line 241 "../src/bookinfo.vala"
	_g_free0 (_data_->_tmp9_);
#line 241 "../src/bookinfo.vala"
	_g_free0 (_data_->_tmp7_);
#line 241 "../src/bookinfo.vala"
	_data_->searchLabel = _data_->_tmp18_;
#line 251 "../src/bookinfo.vala"
	_data_->_tmp19_ = _data_->searchresults_box;
#line 251 "../src/bookinfo.vala"
	_data_->_tmp20_ = _data_->searchLabel;
#line 251 "../src/bookinfo.vala"
	gtk_box_pack_start (_data_->_tmp19_, (GtkWidget*) _data_->_tmp20_, FALSE, FALSE, (guint) 0);
#line 254 "../src/bookinfo.vala"
	_data_->_tmp21_ = bookworm_app_info_searchresults_scroll;
#line 254 "../src/bookinfo.vala"
	_data_->_tmp22_ = gtk_bin_get_child ((GtkBin*) _data_->_tmp21_);
#line 254 "../src/bookinfo.vala"
	gtk_widget_destroy (_data_->_tmp22_);
#line 255 "../src/bookinfo.vala"
	_data_->_tmp23_ = bookworm_app_info_searchresults_scroll;
#line 255 "../src/bookinfo.vala"
	_data_->_tmp24_ = _data_->searchresults_box;
#line 255 "../src/bookinfo.vala"
	gtk_container_add ((GtkContainer*) _data_->_tmp23_, (GtkWidget*) _data_->_tmp24_);
#line 2697 "bookinfo.c"
	{
#line 258 "../src/bookinfo.vala"
		_data_->_tmp25_ = _data_->_data9_->aBook;
#line 258 "../src/bookinfo.vala"
		_data_->_tmp26_ = bookworm_app_book_getBookContentList (_data_->_tmp25_);
#line 258 "../src/bookinfo.vala"
		_data_->_aBookContentFile_list = _data_->_tmp26_;
#line 258 "../src/bookinfo.vala"
		_data_->_tmp27_ = _data_->_aBookContentFile_list;
#line 258 "../src/bookinfo.vala"
		_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp27_);
#line 258 "../src/bookinfo.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 258 "../src/bookinfo.vala"
		_data_->_aBookContentFile_size = _data_->_tmp29_;
#line 258 "../src/bookinfo.vala"
		_data_->_aBookContentFile_index = -1;
#line 258 "../src/bookinfo.vala"
		while (TRUE) {
#line 258 "../src/bookinfo.vala"
			_data_->_aBookContentFile_index = _data_->_aBookContentFile_index + 1;
#line 258 "../src/bookinfo.vala"
			_data_->_tmp30_ = _data_->_aBookContentFile_index;
#line 258 "../src/bookinfo.vala"
			_data_->_tmp31_ = _data_->_aBookContentFile_size;
#line 258 "../src/bookinfo.vala"
			if (!(_data_->_tmp30_ < _data_->_tmp31_)) {
#line 258 "../src/bookinfo.vala"
				break;
#line 2727 "bookinfo.c"
			}
#line 258 "../src/bookinfo.vala"
			_data_->_tmp32_ = _data_->_aBookContentFile_list;
#line 258 "../src/bookinfo.vala"
			_data_->_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp32_, _data_->_aBookContentFile_index);
#line 258 "../src/bookinfo.vala"
			_data_->aBookContentFile = (gchar*) _data_->_tmp33_;
#line 260 "../src/bookinfo.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _bookworm_app_info_populateSearchResults_co_gsource_func, _data_, NULL);
#line 262 "../src/bookinfo.vala"
			_data_->_tmp34_ = bookworm_app_bookworm_aContentFileToBeSearched;
#line 262 "../src/bookinfo.vala"
			_data_->_tmp35_ = _data_->aBookContentFile;
#line 262 "../src/bookinfo.vala"
			g_string_assign (_data_->_tmp34_, _data_->_tmp35_);
#line 263 "../src/bookinfo.vala"
			bookworm_app_content_handler_searchHTMLContents ();
#line 265 "../src/bookinfo.vala"
			_data_->_tmp36_ = bookworm_app_bookworm_searchResultsMap;
#line 265 "../src/bookinfo.vala"
			_data_->_tmp37_ = gee_abstract_map_get_size ((GeeAbstractMap*) _data_->_tmp36_);
#line 265 "../src/bookinfo.vala"
			_data_->_tmp38_ = _data_->_tmp37_;
#line 265 "../src/bookinfo.vala"
			if (_data_->_tmp38_ > 0) {
#line 266 "../src/bookinfo.vala"
				_data_->hasResultsBeenFound = TRUE;
#line 2755 "bookinfo.c"
				{
#line 267 "../src/bookinfo.vala"
					_data_->_tmp39_ = bookworm_app_bookworm_searchResultsMap;
#line 267 "../src/bookinfo.vala"
					_data_->_tmp40_ = gee_abstract_sorted_map_get_ascending_entries ((GeeAbstractSortedMap*) _data_->_tmp39_);
#line 267 "../src/bookinfo.vala"
					_data_->_tmp41_ = _data_->_tmp40_;
#line 267 "../src/bookinfo.vala"
					_data_->_tmp42_ = _data_->_tmp41_;
#line 267 "../src/bookinfo.vala"
					_data_->_tmp43_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp42_);
#line 267 "../src/bookinfo.vala"
					_data_->_tmp44_ = _data_->_tmp43_;
#line 267 "../src/bookinfo.vala"
					_g_object_unref0 (_data_->_tmp42_);
#line 267 "../src/bookinfo.vala"
					_data_->_entry_it = _data_->_tmp44_;
#line 267 "../src/bookinfo.vala"
					while (TRUE) {
#line 267 "../src/bookinfo.vala"
						_data_->_data10_ = g_slice_new0 (Block10Data);
#line 267 "../src/bookinfo.vala"
						_data_->_data10_->_ref_count_ = 1;
#line 267 "../src/bookinfo.vala"
						_data_->_data10_->_data9_ = block9_data_ref (_data_->_data9_);
#line 267 "../src/bookinfo.vala"
						_data_->_tmp45_ = _data_->_entry_it;
#line 267 "../src/bookinfo.vala"
						if (!gee_iterator_next (_data_->_tmp45_)) {
#line 267 "../src/bookinfo.vala"
							block10_data_unref (_data_->_data10_);
#line 267 "../src/bookinfo.vala"
							_data_->_data10_ = NULL;
#line 267 "../src/bookinfo.vala"
							break;
#line 2791 "bookinfo.c"
						}
#line 267 "../src/bookinfo.vala"
						_data_->_tmp46_ = _data_->_entry_it;
#line 267 "../src/bookinfo.vala"
						_data_->_tmp47_ = gee_iterator_get (_data_->_tmp46_);
#line 267 "../src/bookinfo.vala"
						_data_->entry = (GeeMapEntry*) _data_->_tmp47_;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp48_ = _data_->entry;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp49_ = gee_map_entry_get_key (_data_->_tmp48_);
#line 268 "../src/bookinfo.vala"
						_data_->_tmp50_ = _data_->_tmp49_;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp51_ = _data_->entry;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp52_ = gee_map_entry_get_key (_data_->_tmp51_);
#line 268 "../src/bookinfo.vala"
						_data_->_tmp53_ = _data_->_tmp52_;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp54_ = _data_->entry;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp55_ = gee_map_entry_get_key (_data_->_tmp54_);
#line 268 "../src/bookinfo.vala"
						_data_->_tmp56_ = _data_->_tmp55_;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp57_ = strlen ((const gchar*) _data_->_tmp56_);
#line 268 "../src/bookinfo.vala"
						_data_->_tmp58_ = _data_->_tmp57_;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp59_ = string_slice ((const gchar*) _data_->_tmp50_, (glong) (string_index_of ((const gchar*) _data_->_tmp53_, "~~", 0) + 2), (glong) _data_->_tmp58_);
#line 268 "../src/bookinfo.vala"
						_data_->_tmp60_ = _data_->_tmp59_;
#line 268 "../src/bookinfo.vala"
						_data_->_tmp61_ = string_strip (_data_->_tmp60_);
#line 268 "../src/bookinfo.vala"
						_data_->_tmp62_ = _data_->_tmp61_;
#line 268 "../src/bookinfo.vala"
						_g_free0 (_data_->_tmp60_);
#line 268 "../src/bookinfo.vala"
						_data_->pageNumber = _data_->_tmp62_;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp63_ = _data_->pageNumber;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp64_ = _data_->pageNumber;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp65_ = bookworm_app_info_getChapterNameFromPage (_data_->_tmp64_);
#line 269 "../src/bookinfo.vala"
						_data_->_tmp66_ = _data_->_tmp65_;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp67_ = g_strconcat (_data_->_tmp66_, " : ", NULL);
#line 269 "../src/bookinfo.vala"
						_data_->_tmp68_ = _data_->_tmp67_;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp69_ = _data_->entry;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp70_ = gee_map_entry_get_value (_data_->_tmp69_);
#line 269 "../src/bookinfo.vala"
						_data_->_tmp71_ = _data_->_tmp70_;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp72_ = bookworm_app_utils_minimizeStringLength ((const gchar*) _data_->_tmp71_, 100);
#line 269 "../src/bookinfo.vala"
						_data_->_tmp73_ = _data_->_tmp72_;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp74_ = g_strconcat (_data_->_tmp68_, _data_->_tmp73_, NULL);
#line 269 "../src/bookinfo.vala"
						_data_->_tmp75_ = _data_->_tmp74_;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp76_ = bookworm_app_utils_parseMarkUp (_data_->_tmp75_);
#line 269 "../src/bookinfo.vala"
						_data_->_tmp77_ = _data_->_tmp76_;
#line 269 "../src/bookinfo.vala"
						_data_->_tmp78_ = (GtkLinkButton*) gtk_link_button_new_with_label (_data_->_tmp63_, _data_->_tmp77_);
#line 269 "../src/bookinfo.vala"
						g_object_ref_sink (_data_->_tmp78_);
#line 269 "../src/bookinfo.vala"
						_data_->_tmp79_ = _data_->_tmp78_;
#line 269 "../src/bookinfo.vala"
						_g_free0 (_data_->_tmp77_);
#line 269 "../src/bookinfo.vala"
						_g_free0 (_data_->_tmp75_);
#line 269 "../src/bookinfo.vala"
						_g_free0 (_data_->_tmp73_);
#line 269 "../src/bookinfo.vala"
						_g_free0 (_data_->_tmp68_);
#line 269 "../src/bookinfo.vala"
						_g_free0 (_data_->_tmp66_);
#line 269 "../src/bookinfo.vala"
						_data_->_data10_->searchResultLinkButton = _data_->_tmp79_;
#line 272 "../src/bookinfo.vala"
						_data_->_tmp80_ = _data_->_data10_->searchResultLinkButton;
#line 272 "../src/bookinfo.vala"
						gtk_widget_set_halign ((GtkWidget*) _data_->_tmp80_, GTK_ALIGN_START);
#line 273 "../src/bookinfo.vala"
						_data_->_tmp81_ = _data_->searchresults_box;
#line 273 "../src/bookinfo.vala"
						_data_->_tmp82_ = _data_->_data10_->searchResultLinkButton;
#line 273 "../src/bookinfo.vala"
						gtk_box_pack_start (_data_->_tmp81_, (GtkWidget*) _data_->_tmp82_, FALSE, FALSE, (guint) 0);
#line 275 "../src/bookinfo.vala"
						if (!_data_->isSearchResultFocussed) {
#line 276 "../src/bookinfo.vala"
							_data_->_tmp83_ = _data_->_data10_->searchResultLinkButton;
#line 276 "../src/bookinfo.vala"
							gtk_widget_grab_focus ((GtkWidget*) _data_->_tmp83_);
#line 277 "../src/bookinfo.vala"
							_data_->isSearchResultFocussed = TRUE;
#line 278 "../src/bookinfo.vala"
							_data_->_tmp84_ = _data_->_data10_->searchResultLinkButton;
#line 278 "../src/bookinfo.vala"
							_data_->_tmp85_ = _g_object_ref0 (_data_->_tmp84_);
#line 278 "../src/bookinfo.vala"
							_g_object_unref0 (bookworm_app_info_firstSearchResultLinkButton);
#line 278 "../src/bookinfo.vala"
							bookworm_app_info_firstSearchResultLinkButton = _data_->_tmp85_;
#line 2907 "bookinfo.c"
						}
#line 280 "../src/bookinfo.vala"
						_data_->_tmp86_ = _data_->_data10_->searchResultLinkButton;
#line 280 "../src/bookinfo.vala"
						g_signal_connect_data (_data_->_tmp86_, "activate-link", (GCallback) ________lambda44__gtk_link_button_activate_link, block10_data_ref (_data_->_data10_), (GClosureNotify) block10_data_unref, 0);
#line 267 "../src/bookinfo.vala"
						_g_free0 (_data_->pageNumber);
#line 267 "../src/bookinfo.vala"
						_g_object_unref0 (_data_->entry);
#line 267 "../src/bookinfo.vala"
						block10_data_unref (_data_->_data10_);
#line 267 "../src/bookinfo.vala"
						_data_->_data10_ = NULL;
#line 2921 "bookinfo.c"
					}
#line 267 "../src/bookinfo.vala"
					_g_object_unref0 (_data_->_entry_it);
#line 2925 "bookinfo.c"
				}
			}
#line 294 "../src/bookinfo.vala"
			_data_->_tmp87_ = _data_->searchresults_box;
#line 294 "../src/bookinfo.vala"
			gtk_widget_show_all ((GtkWidget*) _data_->_tmp87_);
#line 296 "../src/bookinfo.vala"
			_data_->_state_ = 1;
#line 296 "../src/bookinfo.vala"
			return FALSE;
#line 2936 "bookinfo.c"
			_state_1:
			;
#line 258 "../src/bookinfo.vala"
			_g_free0 (_data_->aBookContentFile);
#line 2941 "bookinfo.c"
		}
#line 258 "../src/bookinfo.vala"
		_g_object_unref0 (_data_->_aBookContentFile_list);
#line 2945 "bookinfo.c"
	}
#line 299 "../src/bookinfo.vala"
	if (_data_->hasResultsBeenFound) {
#line 300 "../src/bookinfo.vala"
		_data_->_tmp88_ = _data_->searchLabel;
#line 300 "../src/bookinfo.vala"
		_data_->_tmp89_ = bookworm_app_app_header_bar_headerSearchBar;
#line 300 "../src/bookinfo.vala"
		_data_->_tmp90_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp89_);
#line 300 "../src/bookinfo.vala"
		_data_->_tmp91_ = bookworm_app_utils_minimizeStringLength (_data_->_tmp90_, 50);
#line 300 "../src/bookinfo.vala"
		_data_->_tmp92_ = _data_->_tmp91_;
#line 300 "../src/bookinfo.vala"
		_data_->_tmp93_ = string_replace (BOOKWORM_APP_CONSTANTS_TEXT_FOR_SEARCH_RESULTS_FOUND, "$$$", _data_->_tmp92_);
#line 300 "../src/bookinfo.vala"
		_data_->_tmp94_ = _data_->_tmp93_;
#line 300 "../src/bookinfo.vala"
		_data_->_tmp95_ = _data_->_data9_->aBook;
#line 300 "../src/bookinfo.vala"
		_data_->_tmp96_ = bookworm_app_book_getBookTitle (_data_->_tmp95_);
#line 300 "../src/bookinfo.vala"
		_data_->_tmp97_ = _data_->_tmp96_;
#line 300 "../src/bookinfo.vala"
		_data_->_tmp98_ = bookworm_app_utils_minimizeStringLength (_data_->_tmp97_, 35);
#line 300 "../src/bookinfo.vala"
		_data_->_tmp99_ = _data_->_tmp98_;
#line 300 "../src/bookinfo.vala"
		_data_->_tmp100_ = string_replace (_data_->_tmp94_, "&&&", _data_->_tmp99_);
#line 300 "../src/bookinfo.vala"
		_data_->_tmp101_ = _data_->_tmp100_;
#line 300 "../src/bookinfo.vala"
		gtk_label_set_text (_data_->_tmp88_, _data_->_tmp101_);
#line 300 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp101_);
#line 300 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp99_);
#line 300 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp97_);
#line 300 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp94_);
#line 300 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp92_);
#line 2989 "bookinfo.c"
	} else {
#line 305 "../src/bookinfo.vala"
		_data_->_tmp102_ = _data_->searchLabel;
#line 305 "../src/bookinfo.vala"
		_data_->_tmp103_ = bookworm_app_app_header_bar_headerSearchBar;
#line 305 "../src/bookinfo.vala"
		_data_->_tmp104_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp103_);
#line 305 "../src/bookinfo.vala"
		_data_->_tmp105_ = bookworm_app_utils_minimizeStringLength (_data_->_tmp104_, 50);
#line 305 "../src/bookinfo.vala"
		_data_->_tmp106_ = _data_->_tmp105_;
#line 305 "../src/bookinfo.vala"
		_data_->_tmp107_ = string_replace (BOOKWORM_APP_CONSTANTS_TEXT_FOR_SEARCH_RESULTS_NOT_FOUND, "$$$", _data_->_tmp106_);
#line 305 "../src/bookinfo.vala"
		_data_->_tmp108_ = _data_->_tmp107_;
#line 305 "../src/bookinfo.vala"
		_data_->_tmp109_ = _data_->_data9_->aBook;
#line 305 "../src/bookinfo.vala"
		_data_->_tmp110_ = bookworm_app_book_getBookTitle (_data_->_tmp109_);
#line 305 "../src/bookinfo.vala"
		_data_->_tmp111_ = _data_->_tmp110_;
#line 305 "../src/bookinfo.vala"
		_data_->_tmp112_ = bookworm_app_utils_minimizeStringLength (_data_->_tmp111_, 35);
#line 305 "../src/bookinfo.vala"
		_data_->_tmp113_ = _data_->_tmp112_;
#line 305 "../src/bookinfo.vala"
		_data_->_tmp114_ = string_replace (_data_->_tmp108_, "&&&", _data_->_tmp113_);
#line 305 "../src/bookinfo.vala"
		_data_->_tmp115_ = _data_->_tmp114_;
#line 305 "../src/bookinfo.vala"
		gtk_label_set_text (_data_->_tmp102_, _data_->_tmp115_);
#line 305 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp115_);
#line 305 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp113_);
#line 305 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp111_);
#line 305 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp108_);
#line 305 "../src/bookinfo.vala"
		_g_free0 (_data_->_tmp106_);
#line 3031 "bookinfo.c"
	}
#line 310 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:310: [END] [FUNCTION:populateSearchResults]");
#line 311 "../src/bookinfo.vala"
	_data_->_tmp116_ = _data_->_data9_->aBook;
#line 311 "../src/bookinfo.vala"
	_data_->_tmp117_ = _bookworm_app_book_ref0 (_data_->_tmp116_);
#line 311 "../src/bookinfo.vala"
	_data_->result = _data_->_tmp117_;
#line 311 "../src/bookinfo.vala"
	_g_object_unref0 (_data_->searchLabel);
#line 311 "../src/bookinfo.vala"
	_g_object_unref0 (_data_->searchresults_box);
#line 311 "../src/bookinfo.vala"
	block9_data_unref (_data_->_data9_);
#line 311 "../src/bookinfo.vala"
	_data_->_data9_ = NULL;
#line 311 "../src/bookinfo.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 311 "../src/bookinfo.vala"
	if (_data_->_state_ != 0) {
#line 311 "../src/bookinfo.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 311 "../src/bookinfo.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3057 "bookinfo.c"
		}
	}
#line 311 "../src/bookinfo.vala"
	g_object_unref (_data_->_async_result);
#line 311 "../src/bookinfo.vala"
	return FALSE;
#line 3064 "bookinfo.c"
}

gchar*
bookworm_app_info_getChapterNameFromPage (const gchar* pageNumber)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* chapterName = NULL;
	gchar* _tmp2_;
	BookwormAppBook* aBook = NULL;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_;
	BookwormAppBook* _tmp6_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* result;
#line 314 "../src/bookinfo.vala"
	g_return_val_if_fail (pageNumber != NULL, NULL);
#line 315 "../src/bookinfo.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:getChapterNameFromPage] pageNumber=", pageNumber, NULL);
#line 315 "../src/bookinfo.vala"
	_tmp1_ = _tmp0_;
#line 315 "../src/bookinfo.vala"
	g_debug ("bookinfo.vala:315: %s", _tmp1_);
#line 315 "../src/bookinfo.vala"
	_g_free0 (_tmp1_);
#line 316 "../src/bookinfo.vala"
	_tmp2_ = g_strdup ("");
#line 316 "../src/bookinfo.vala"
	chapterName = _tmp2_;
#line 318 "../src/bookinfo.vala"
	_tmp3_ = bookworm_app_bookworm_libraryViewMap;
#line 318 "../src/bookinfo.vala"
	_tmp4_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 318 "../src/bookinfo.vala"
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 318 "../src/bookinfo.vala"
	aBook = (BookwormAppBook*) _tmp5_;
#line 319 "../src/bookinfo.vala"
	_tmp6_ = aBook;
#line 319 "../src/bookinfo.vala"
	if (_tmp6_ != NULL) {
#line 3109 "bookinfo.c"
		gint indexOfPageInContentList = 0;
		BookwormAppBook* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint indexOfCurrentChapterInContentList = 0;
		gchar* previousChapterName = NULL;
		gchar* _tmp11_;
		GeeArrayList* tocList = NULL;
		BookwormAppBook* _tmp12_;
		GeeArrayList* _tmp13_;
		const gchar* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
#line 320 "../src/bookinfo.vala"
		_tmp7_ = aBook;
#line 320 "../src/bookinfo.vala"
		_tmp8_ = bookworm_app_book_getBookContentList (_tmp7_);
#line 320 "../src/bookinfo.vala"
		_tmp9_ = _tmp8_;
#line 320 "../src/bookinfo.vala"
		_tmp10_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp9_, pageNumber);
#line 320 "../src/bookinfo.vala"
		_g_object_unref0 (_tmp9_);
#line 320 "../src/bookinfo.vala"
		indexOfPageInContentList = _tmp10_;
#line 321 "../src/bookinfo.vala"
		indexOfCurrentChapterInContentList = 0;
#line 322 "../src/bookinfo.vala"
		_tmp11_ = g_strdup ("");
#line 322 "../src/bookinfo.vala"
		previousChapterName = _tmp11_;
#line 323 "../src/bookinfo.vala"
		_tmp12_ = aBook;
#line 323 "../src/bookinfo.vala"
		_tmp13_ = bookworm_app_book_getTOC (_tmp12_);
#line 323 "../src/bookinfo.vala"
		tocList = _tmp13_;
#line 3148 "bookinfo.c"
		{
			GeeArrayList* _tocListItemMap_list = NULL;
			GeeArrayList* _tmp14_;
			gint _tocListItemMap_size = 0;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tocListItemMap_index = 0;
#line 324 "../src/bookinfo.vala"
			_tmp14_ = tocList;
#line 324 "../src/bookinfo.vala"
			_tocListItemMap_list = _tmp14_;
#line 324 "../src/bookinfo.vala"
			_tmp15_ = _tocListItemMap_list;
#line 324 "../src/bookinfo.vala"
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
#line 324 "../src/bookinfo.vala"
			_tmp17_ = _tmp16_;
#line 324 "../src/bookinfo.vala"
			_tocListItemMap_size = _tmp17_;
#line 324 "../src/bookinfo.vala"
			_tocListItemMap_index = -1;
#line 324 "../src/bookinfo.vala"
			while (TRUE) {
#line 3173 "bookinfo.c"
				gint _tmp18_;
				gint _tmp19_;
				GeeHashMap* tocListItemMap = NULL;
				GeeArrayList* _tmp20_;
				gpointer _tmp21_;
				const gchar* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
#line 324 "../src/bookinfo.vala"
				_tocListItemMap_index = _tocListItemMap_index + 1;
#line 324 "../src/bookinfo.vala"
				_tmp18_ = _tocListItemMap_index;
#line 324 "../src/bookinfo.vala"
				_tmp19_ = _tocListItemMap_size;
#line 324 "../src/bookinfo.vala"
				if (!(_tmp18_ < _tmp19_)) {
#line 324 "../src/bookinfo.vala"
					break;
#line 3192 "bookinfo.c"
				}
#line 324 "../src/bookinfo.vala"
				_tmp20_ = _tocListItemMap_list;
#line 324 "../src/bookinfo.vala"
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tocListItemMap_index);
#line 324 "../src/bookinfo.vala"
				tocListItemMap = (GeeHashMap*) _tmp21_;
#line 3200 "bookinfo.c"
				{
					GeeIterator* _entry_it = NULL;
					GeeHashMap* _tmp22_;
					GeeSet* _tmp23_;
					GeeSet* _tmp24_;
					GeeSet* _tmp25_;
					GeeIterator* _tmp26_;
					GeeIterator* _tmp27_;
#line 325 "../src/bookinfo.vala"
					_tmp22_ = tocListItemMap;
#line 325 "../src/bookinfo.vala"
					_tmp23_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp22_);
#line 325 "../src/bookinfo.vala"
					_tmp24_ = _tmp23_;
#line 325 "../src/bookinfo.vala"
					_tmp25_ = _tmp24_;
#line 325 "../src/bookinfo.vala"
					_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
#line 325 "../src/bookinfo.vala"
					_tmp27_ = _tmp26_;
#line 325 "../src/bookinfo.vala"
					_g_object_unref0 (_tmp25_);
#line 325 "../src/bookinfo.vala"
					_entry_it = _tmp27_;
#line 325 "../src/bookinfo.vala"
					while (TRUE) {
#line 3227 "bookinfo.c"
						GeeIterator* _tmp28_;
						GeeMapEntry* entry = NULL;
						GeeIterator* _tmp29_;
						gpointer _tmp30_;
						BookwormAppBook* _tmp31_;
						GeeArrayList* _tmp32_;
						GeeArrayList* _tmp33_;
						GeeMapEntry* _tmp34_;
						gconstpointer _tmp35_;
						gconstpointer _tmp36_;
						GeeMapEntry* _tmp37_;
						gconstpointer _tmp38_;
						gconstpointer _tmp39_;
						GeeMapEntry* _tmp46_;
						gconstpointer _tmp47_;
						gconstpointer _tmp48_;
						gchar* _tmp49_;
#line 325 "../src/bookinfo.vala"
						_tmp28_ = _entry_it;
#line 325 "../src/bookinfo.vala"
						if (!gee_iterator_next (_tmp28_)) {
#line 325 "../src/bookinfo.vala"
							break;
#line 3251 "bookinfo.c"
						}
#line 325 "../src/bookinfo.vala"
						_tmp29_ = _entry_it;
#line 325 "../src/bookinfo.vala"
						_tmp30_ = gee_iterator_get (_tmp29_);
#line 325 "../src/bookinfo.vala"
						entry = (GeeMapEntry*) _tmp30_;
#line 326 "../src/bookinfo.vala"
						_tmp31_ = aBook;
#line 326 "../src/bookinfo.vala"
						_tmp32_ = bookworm_app_book_getBookContentList (_tmp31_);
#line 326 "../src/bookinfo.vala"
						_tmp33_ = _tmp32_;
#line 326 "../src/bookinfo.vala"
						_tmp34_ = entry;
#line 326 "../src/bookinfo.vala"
						_tmp35_ = gee_map_entry_get_key (_tmp34_);
#line 326 "../src/bookinfo.vala"
						_tmp36_ = _tmp35_;
#line 326 "../src/bookinfo.vala"
						indexOfCurrentChapterInContentList = gee_abstract_list_index_of ((GeeAbstractList*) _tmp33_, (const gchar*) _tmp36_);
#line 326 "../src/bookinfo.vala"
						_g_object_unref0 (_tmp33_);
#line 327 "../src/bookinfo.vala"
						_tmp37_ = entry;
#line 327 "../src/bookinfo.vala"
						_tmp38_ = gee_map_entry_get_key (_tmp37_);
#line 327 "../src/bookinfo.vala"
						_tmp39_ = _tmp38_;
#line 327 "../src/bookinfo.vala"
						if (g_strcmp0 ((const gchar*) _tmp39_, pageNumber) == 0) {
#line 3283 "bookinfo.c"
							GeeMapEntry* _tmp40_;
							gconstpointer _tmp41_;
							gconstpointer _tmp42_;
							gchar* _tmp43_;
#line 328 "../src/bookinfo.vala"
							_tmp40_ = entry;
#line 328 "../src/bookinfo.vala"
							_tmp41_ = gee_map_entry_get_value (_tmp40_);
#line 328 "../src/bookinfo.vala"
							_tmp42_ = _tmp41_;
#line 328 "../src/bookinfo.vala"
							_tmp43_ = g_strdup ((const gchar*) _tmp42_);
#line 328 "../src/bookinfo.vala"
							_g_free0 (chapterName);
#line 328 "../src/bookinfo.vala"
							chapterName = _tmp43_;
#line 329 "../src/bookinfo.vala"
							_g_object_unref0 (entry);
#line 329 "../src/bookinfo.vala"
							break;
#line 3304 "bookinfo.c"
						} else {
#line 331 "../src/bookinfo.vala"
							if (indexOfCurrentChapterInContentList > indexOfPageInContentList) {
#line 3308 "bookinfo.c"
								const gchar* _tmp44_;
								gchar* _tmp45_;
#line 332 "../src/bookinfo.vala"
								_tmp44_ = previousChapterName;
#line 332 "../src/bookinfo.vala"
								_tmp45_ = g_strdup (_tmp44_);
#line 332 "../src/bookinfo.vala"
								_g_free0 (chapterName);
#line 332 "../src/bookinfo.vala"
								chapterName = _tmp45_;
#line 333 "../src/bookinfo.vala"
								_g_object_unref0 (entry);
#line 333 "../src/bookinfo.vala"
								break;
#line 3323 "bookinfo.c"
							}
						}
#line 336 "../src/bookinfo.vala"
						_tmp46_ = entry;
#line 336 "../src/bookinfo.vala"
						_tmp47_ = gee_map_entry_get_value (_tmp46_);
#line 336 "../src/bookinfo.vala"
						_tmp48_ = _tmp47_;
#line 336 "../src/bookinfo.vala"
						_tmp49_ = g_strdup ((const gchar*) _tmp48_);
#line 336 "../src/bookinfo.vala"
						_g_free0 (previousChapterName);
#line 336 "../src/bookinfo.vala"
						previousChapterName = _tmp49_;
#line 325 "../src/bookinfo.vala"
						_g_object_unref0 (entry);
#line 3340 "bookinfo.c"
					}
#line 325 "../src/bookinfo.vala"
					_g_object_unref0 (_entry_it);
#line 3344 "bookinfo.c"
				}
#line 338 "../src/bookinfo.vala"
				_tmp50_ = chapterName;
#line 338 "../src/bookinfo.vala"
				_tmp51_ = strlen (_tmp50_);
#line 338 "../src/bookinfo.vala"
				_tmp52_ = _tmp51_;
#line 338 "../src/bookinfo.vala"
				if (_tmp52_ > 0) {
#line 339 "../src/bookinfo.vala"
					_g_object_unref0 (tocListItemMap);
#line 339 "../src/bookinfo.vala"
					break;
#line 3358 "bookinfo.c"
				}
#line 324 "../src/bookinfo.vala"
				_g_object_unref0 (tocListItemMap);
#line 3362 "bookinfo.c"
			}
		}
#line 343 "../src/bookinfo.vala"
		_tmp53_ = chapterName;
#line 343 "../src/bookinfo.vala"
		_tmp54_ = strlen (_tmp53_);
#line 343 "../src/bookinfo.vala"
		_tmp55_ = _tmp54_;
#line 343 "../src/bookinfo.vala"
		if (_tmp55_ < 1) {
#line 3373 "bookinfo.c"
			gchar* _tmp56_;
#line 344 "../src/bookinfo.vala"
			_tmp56_ = g_strconcat ("Section ", pageNumber, NULL);
#line 344 "../src/bookinfo.vala"
			_g_free0 (chapterName);
#line 344 "../src/bookinfo.vala"
			chapterName = _tmp56_;
#line 3381 "bookinfo.c"
		}
#line 319 "../src/bookinfo.vala"
		_g_object_unref0 (tocList);
#line 319 "../src/bookinfo.vala"
		_g_free0 (previousChapterName);
#line 3387 "bookinfo.c"
	}
#line 347 "../src/bookinfo.vala"
	_tmp57_ = chapterName;
#line 347 "../src/bookinfo.vala"
	_tmp58_ = g_strconcat ("[END] [FUNCTION:getChapterNameFromPage] chapterName=", _tmp57_, NULL);
#line 347 "../src/bookinfo.vala"
	_tmp59_ = _tmp58_;
#line 347 "../src/bookinfo.vala"
	g_debug ("bookinfo.vala:347: %s", _tmp59_);
#line 347 "../src/bookinfo.vala"
	_g_free0 (_tmp59_);
#line 348 "../src/bookinfo.vala"
	result = chapterName;
#line 348 "../src/bookinfo.vala"
	_bookworm_app_book_unref0 (aBook);
#line 348 "../src/bookinfo.vala"
	return result;
#line 3405 "bookinfo.c"
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
#line 351 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 351 "../src/bookinfo.vala"
	return _data11_;
#line 3415 "bookinfo.c"
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 351 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 351 "../src/bookinfo.vala"
		_bookworm_app_book_unref0 (_data11_->aBook);
#line 351 "../src/bookinfo.vala"
		g_slice_free (Block11Data, _data11_);
#line 3429 "bookinfo.c"
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
#line 367 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data12_->_ref_count_);
#line 367 "../src/bookinfo.vala"
	return _data12_;
#line 3440 "bookinfo.c"
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
#line 367 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
#line 367 "../src/bookinfo.vala"
		_g_object_unref0 (_data12_->contentLinkButton);
#line 367 "../src/bookinfo.vala"
		block11_data_unref (_data12_->_data11_);
#line 367 "../src/bookinfo.vala"
		_data12_->_data11_ = NULL;
#line 367 "../src/bookinfo.vala"
		g_slice_free (Block12Data, _data12_);
#line 3458 "bookinfo.c"
	}
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 3483 "bookinfo.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 3491 "bookinfo.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 3497 "bookinfo.c"
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 3511 "bookinfo.c"
}

static gboolean
_________lambda6_ (Block12Data* _data12_)
{
	Block11Data* _data11_;
	gchar* linkURI = NULL;
	GtkLinkButton* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	BookwormAppBook* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GeeHashMap* _tmp36_;
	BookwormAppBook* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	BookwormAppBook* _tmp40_;
	BookwormAppBook* _tmp41_;
	BookwormAppBook* _tmp42_;
	gchar* _tmp43_;
	BookwormAppBook* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean result;
#line 371 "../src/bookinfo.vala"
	_data11_ = _data12_->_data11_;
#line 372 "../src/bookinfo.vala"
	_tmp0_ = _data12_->contentLinkButton;
#line 372 "../src/bookinfo.vala"
	_tmp1_ = gtk_link_button_get_uri (_tmp0_);
#line 372 "../src/bookinfo.vala"
	_tmp2_ = string_strip (_tmp1_);
#line 372 "../src/bookinfo.vala"
	linkURI = _tmp2_;
#line 374 "../src/bookinfo.vala"
	_tmp3_ = linkURI;
#line 374 "../src/bookinfo.vala"
	if (string_index_of (_tmp3_, "#", 0) != -1) {
#line 3560 "bookinfo.c"
		gchar* URIWithoutBookmark = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		BookwormAppBook* _tmp7_;
		BookwormAppBook* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		const gchar* _tmp11_;
		BookwormAppBook* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
#line 375 "../src/bookinfo.vala"
		_tmp4_ = linkURI;
#line 375 "../src/bookinfo.vala"
		_tmp5_ = linkURI;
#line 375 "../src/bookinfo.vala"
		_tmp6_ = string_slice (_tmp4_, (glong) 0, (glong) string_last_index_of (_tmp5_, "#", 0));
#line 375 "../src/bookinfo.vala"
		URIWithoutBookmark = _tmp6_;
#line 376 "../src/bookinfo.vala"
		_tmp7_ = _data11_->aBook;
#line 376 "../src/bookinfo.vala"
		_tmp8_ = _data11_->aBook;
#line 376 "../src/bookinfo.vala"
		_tmp9_ = bookworm_app_book_getBookContentList (_tmp8_);
#line 376 "../src/bookinfo.vala"
		_tmp10_ = _tmp9_;
#line 376 "../src/bookinfo.vala"
		_tmp11_ = URIWithoutBookmark;
#line 376 "../src/bookinfo.vala"
		bookworm_app_book_setBookPageNumber (_tmp7_, gee_abstract_list_index_of ((GeeAbstractList*) _tmp10_, _tmp11_));
#line 376 "../src/bookinfo.vala"
		_g_object_unref0 (_tmp10_);
#line 377 "../src/bookinfo.vala"
		_tmp12_ = _data11_->aBook;
#line 377 "../src/bookinfo.vala"
		_tmp13_ = linkURI;
#line 377 "../src/bookinfo.vala"
		_tmp14_ = linkURI;
#line 377 "../src/bookinfo.vala"
		_tmp15_ = linkURI;
#line 377 "../src/bookinfo.vala"
		_tmp16_ = strlen (_tmp15_);
#line 377 "../src/bookinfo.vala"
		_tmp17_ = _tmp16_;
#line 377 "../src/bookinfo.vala"
		_tmp18_ = string_slice (_tmp13_, (glong) (string_last_index_of (_tmp14_, "#", 0) + 1), (glong) _tmp17_);
#line 377 "../src/bookinfo.vala"
		_tmp19_ = _tmp18_;
#line 377 "../src/bookinfo.vala"
		bookworm_app_book_setAnchor (_tmp12_, _tmp19_);
#line 377 "../src/bookinfo.vala"
		_g_free0 (_tmp19_);
#line 378 "../src/bookinfo.vala"
		bookworm_app_bookworm_isPageScrollRequired = TRUE;
#line 374 "../src/bookinfo.vala"
		_g_free0 (URIWithoutBookmark);
#line 3624 "bookinfo.c"
	} else {
		BookwormAppBook* _tmp20_;
		BookwormAppBook* _tmp21_;
		GeeArrayList* _tmp22_;
		GeeArrayList* _tmp23_;
		const gchar* _tmp24_;
#line 380 "../src/bookinfo.vala"
		_tmp20_ = _data11_->aBook;
#line 380 "../src/bookinfo.vala"
		_tmp21_ = _data11_->aBook;
#line 380 "../src/bookinfo.vala"
		_tmp22_ = bookworm_app_book_getBookContentList (_tmp21_);
#line 380 "../src/bookinfo.vala"
		_tmp23_ = _tmp22_;
#line 380 "../src/bookinfo.vala"
		_tmp24_ = linkURI;
#line 380 "../src/bookinfo.vala"
		bookworm_app_book_setBookPageNumber (_tmp20_, gee_abstract_list_index_of ((GeeAbstractList*) _tmp23_, _tmp24_));
#line 380 "../src/bookinfo.vala"
		_g_object_unref0 (_tmp23_);
#line 3645 "bookinfo.c"
	}
#line 382 "../src/bookinfo.vala"
	_tmp25_ = linkURI;
#line 382 "../src/bookinfo.vala"
	_tmp26_ = g_strconcat ("Selected link from Table of Contents with URI [", _tmp25_, NULL);
#line 382 "../src/bookinfo.vala"
	_tmp27_ = _tmp26_;
#line 382 "../src/bookinfo.vala"
	_tmp28_ = g_strconcat (_tmp27_, "] and page location:", NULL);
#line 382 "../src/bookinfo.vala"
	_tmp29_ = _tmp28_;
#line 382 "../src/bookinfo.vala"
	_tmp30_ = _data11_->aBook;
#line 382 "../src/bookinfo.vala"
	_tmp31_ = bookworm_app_book_getBookLocation (_tmp30_);
#line 382 "../src/bookinfo.vala"
	_tmp32_ = _tmp31_;
#line 382 "../src/bookinfo.vala"
	_tmp33_ = string_to_string (_tmp32_);
#line 382 "../src/bookinfo.vala"
	_tmp34_ = g_strconcat (_tmp29_, _tmp33_, NULL);
#line 382 "../src/bookinfo.vala"
	_tmp35_ = _tmp34_;
#line 382 "../src/bookinfo.vala"
	g_debug ("bookinfo.vala:382: %s", _tmp35_);
#line 382 "../src/bookinfo.vala"
	_g_free0 (_tmp35_);
#line 382 "../src/bookinfo.vala"
	_g_free0 (_tmp32_);
#line 382 "../src/bookinfo.vala"
	_g_free0 (_tmp29_);
#line 382 "../src/bookinfo.vala"
	_g_free0 (_tmp27_);
#line 384 "../src/bookinfo.vala"
	_tmp36_ = bookworm_app_bookworm_libraryViewMap;
#line 384 "../src/bookinfo.vala"
	_tmp37_ = _data11_->aBook;
#line 384 "../src/bookinfo.vala"
	_tmp38_ = bookworm_app_book_getBookLocation (_tmp37_);
#line 384 "../src/bookinfo.vala"
	_tmp39_ = _tmp38_;
#line 384 "../src/bookinfo.vala"
	_tmp40_ = _data11_->aBook;
#line 384 "../src/bookinfo.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, _tmp39_, _tmp40_);
#line 384 "../src/bookinfo.vala"
	_g_free0 (_tmp39_);
#line 385 "../src/bookinfo.vala"
	_tmp41_ = _data11_->aBook;
#line 385 "../src/bookinfo.vala"
	_tmp42_ = _bookworm_app_book_ref0 (_tmp41_);
#line 385 "../src/bookinfo.vala"
	_tmp43_ = g_strdup ("");
#line 385 "../src/bookinfo.vala"
	_tmp44_ = bookworm_app_content_handler_renderPage (_tmp42_, _tmp43_);
#line 385 "../src/bookinfo.vala"
	_bookworm_app_book_unref0 (_data11_->aBook);
#line 385 "../src/bookinfo.vala"
	_data11_->aBook = _tmp44_;
#line 387 "../src/bookinfo.vala"
	_tmp45_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 387 "../src/bookinfo.vala"
	_tmp46_ = g_strdup (_tmp45_);
#line 387 "../src/bookinfo.vala"
	_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 387 "../src/bookinfo.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp46_;
#line 388 "../src/bookinfo.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 389 "../src/bookinfo.vala"
	result = TRUE;
#line 389 "../src/bookinfo.vala"
	_g_free0 (linkURI);
#line 389 "../src/bookinfo.vala"
	return result;
#line 3721 "bookinfo.c"
}

static gboolean
__________lambda6__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                  gpointer self)
{
	gboolean result;
	result = _________lambda6_ (self);
#line 371 "../src/bookinfo.vala"
	return result;
#line 3732 "bookinfo.c"
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
#line 396 "../src/bookinfo.vala"
	g_atomic_int_inc (&_data13_->_ref_count_);
#line 396 "../src/bookinfo.vala"
	return _data13_;
#line 3742 "bookinfo.c"
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
#line 396 "../src/bookinfo.vala"
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
#line 396 "../src/bookinfo.vala"
		_g_object_unref0 (_data13_->contentLinkButton);
#line 396 "../src/bookinfo.vala"
		block11_data_unref (_data13_->_data11_);
#line 396 "../src/bookinfo.vala"
		_data13_->_data11_ = NULL;
#line 396 "../src/bookinfo.vala"
		g_slice_free (Block13Data, _data13_);
#line 3760 "bookinfo.c"
	}
}

static gboolean
_______lambda41_ (Block13Data* _data13_)
{
	Block11Data* _data11_;
	BookwormAppBook* _tmp0_;
	BookwormAppBook* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GtkLinkButton* _tmp4_;
	const gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	BookwormAppBook* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	BookwormAppBook* _tmp10_;
	BookwormAppBook* _tmp11_;
	BookwormAppBook* _tmp12_;
	gchar* _tmp13_;
	BookwormAppBook* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean result;
#line 407 "../src/bookinfo.vala"
	_data11_ = _data13_->_data11_;
#line 408 "../src/bookinfo.vala"
	_tmp0_ = _data11_->aBook;
#line 408 "../src/bookinfo.vala"
	_tmp1_ = _data11_->aBook;
#line 408 "../src/bookinfo.vala"
	_tmp2_ = bookworm_app_book_getBookContentList (_tmp1_);
#line 408 "../src/bookinfo.vala"
	_tmp3_ = _tmp2_;
#line 408 "../src/bookinfo.vala"
	_tmp4_ = _data13_->contentLinkButton;
#line 408 "../src/bookinfo.vala"
	_tmp5_ = gtk_link_button_get_uri (_tmp4_);
#line 408 "../src/bookinfo.vala"
	bookworm_app_book_setBookPageNumber (_tmp0_, gee_abstract_list_index_of ((GeeAbstractList*) _tmp3_, _tmp5_));
#line 408 "../src/bookinfo.vala"
	_g_object_unref0 (_tmp3_);
#line 410 "../src/bookinfo.vala"
	_tmp6_ = bookworm_app_bookworm_libraryViewMap;
#line 410 "../src/bookinfo.vala"
	_tmp7_ = _data11_->aBook;
#line 410 "../src/bookinfo.vala"
	_tmp8_ = bookworm_app_book_getBookLocation (_tmp7_);
#line 410 "../src/bookinfo.vala"
	_tmp9_ = _tmp8_;
#line 410 "../src/bookinfo.vala"
	_tmp10_ = _data11_->aBook;
#line 410 "../src/bookinfo.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp9_, _tmp10_);
#line 410 "../src/bookinfo.vala"
	_g_free0 (_tmp9_);
#line 411 "../src/bookinfo.vala"
	_tmp11_ = _data11_->aBook;
#line 411 "../src/bookinfo.vala"
	_tmp12_ = _bookworm_app_book_ref0 (_tmp11_);
#line 411 "../src/bookinfo.vala"
	_tmp13_ = g_strdup ("");
#line 411 "../src/bookinfo.vala"
	_tmp14_ = bookworm_app_content_handler_renderPage (_tmp12_, _tmp13_);
#line 411 "../src/bookinfo.vala"
	_bookworm_app_book_unref0 (_data11_->aBook);
#line 411 "../src/bookinfo.vala"
	_data11_->aBook = _tmp14_;
#line 413 "../src/bookinfo.vala"
	_tmp15_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 413 "../src/bookinfo.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 413 "../src/bookinfo.vala"
	_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 413 "../src/bookinfo.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp16_;
#line 414 "../src/bookinfo.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 415 "../src/bookinfo.vala"
	result = TRUE;
#line 415 "../src/bookinfo.vala"
	return result;
#line 3844 "bookinfo.c"
}

static gboolean
________lambda41__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                 gpointer self)
{
	gboolean result;
	result = _______lambda41_ (self);
#line 407 "../src/bookinfo.vala"
	return result;
#line 3855 "bookinfo.c"
}

BookwormAppBook*
bookworm_app_info_createTableOfContents (void)
{
	Block11Data* _data11_;
	GtkBox* content_box = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	BookwormAppBook* _tmp3_;
	BookwormAppBook* _tmp94_;
	BookwormAppBook* _tmp95_;
	BookwormAppBook* result;
#line 351 "../src/bookinfo.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 351 "../src/bookinfo.vala"
	_data11_->_ref_count_ = 1;
#line 352 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:352: [START] [FUNCTION:createTableOfContents]");
#line 355 "../src/bookinfo.vala"
	_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 355 "../src/bookinfo.vala"
	_tmp1_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 355 "../src/bookinfo.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 355 "../src/bookinfo.vala"
	_data11_->aBook = (BookwormAppBook*) _tmp2_;
#line 356 "../src/bookinfo.vala"
	_tmp3_ = _data11_->aBook;
#line 356 "../src/bookinfo.vala"
	if (_tmp3_ != NULL) {
#line 3888 "bookinfo.c"
		BookwormAppBook* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		gboolean _tmp7_;
		GtkBox* _tmp82_;
		GtkScrolledWindow* _tmp83_;
		GtkWidget* _tmp84_;
#line 358 "../src/bookinfo.vala"
		_tmp4_ = _data11_->aBook;
#line 358 "../src/bookinfo.vala"
		_tmp5_ = bookworm_app_book_getBookWidget (_tmp4_, "TABLE_OF_CONTENTS_WIDGET");
#line 358 "../src/bookinfo.vala"
		_tmp6_ = _tmp5_;
#line 358 "../src/bookinfo.vala"
		_tmp7_ = _tmp6_ != NULL;
#line 358 "../src/bookinfo.vala"
		_g_object_unref0 (_tmp6_);
#line 358 "../src/bookinfo.vala"
		if (_tmp7_) {
#line 3908 "bookinfo.c"
			BookwormAppBook* _tmp8_;
			GtkWidget* _tmp9_;
#line 359 "../src/bookinfo.vala"
			_tmp8_ = _data11_->aBook;
#line 359 "../src/bookinfo.vala"
			_tmp9_ = bookworm_app_book_getBookWidget (_tmp8_, "TABLE_OF_CONTENTS_WIDGET");
#line 359 "../src/bookinfo.vala"
			_g_object_unref0 (content_box);
#line 359 "../src/bookinfo.vala"
			content_box = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_box_get_type (), GtkBox);
#line 360 "../src/bookinfo.vala"
			g_debug ("bookinfo.vala:360: found TABLE_OF_CONTENTS_WIDGET");
#line 3921 "bookinfo.c"
		} else {
			GtkBox* _tmp10_;
			BookwormAppBook* _tmp11_;
			GeeArrayList* _tmp12_;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gboolean _tmp16_;
			BookwormAppBook* _tmp80_;
			GtkBox* _tmp81_;
#line 362 "../src/bookinfo.vala"
			_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 362 "../src/bookinfo.vala"
			g_object_ref_sink (_tmp10_);
#line 362 "../src/bookinfo.vala"
			_g_object_unref0 (content_box);
#line 362 "../src/bookinfo.vala"
			content_box = _tmp10_;
#line 364 "../src/bookinfo.vala"
			_tmp11_ = _data11_->aBook;
#line 364 "../src/bookinfo.vala"
			_tmp12_ = bookworm_app_book_getTOC (_tmp11_);
#line 364 "../src/bookinfo.vala"
			_tmp13_ = _tmp12_;
#line 364 "../src/bookinfo.vala"
			_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
#line 364 "../src/bookinfo.vala"
			_tmp15_ = _tmp14_;
#line 364 "../src/bookinfo.vala"
			_tmp16_ = _tmp15_ > 0;
#line 364 "../src/bookinfo.vala"
			_g_object_unref0 (_tmp13_);
#line 364 "../src/bookinfo.vala"
			if (_tmp16_) {
#line 3956 "bookinfo.c"
				GeeArrayList* tocList = NULL;
				BookwormAppBook* _tmp17_;
				GeeArrayList* _tmp18_;
#line 365 "../src/bookinfo.vala"
				_tmp17_ = _data11_->aBook;
#line 365 "../src/bookinfo.vala"
				_tmp18_ = bookworm_app_book_getTOC (_tmp17_);
#line 365 "../src/bookinfo.vala"
				tocList = _tmp18_;
#line 3966 "bookinfo.c"
				{
					GeeArrayList* _tocListItemMap_list = NULL;
					GeeArrayList* _tmp19_;
					gint _tocListItemMap_size = 0;
					GeeArrayList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _tocListItemMap_index = 0;
#line 366 "../src/bookinfo.vala"
					_tmp19_ = tocList;
#line 366 "../src/bookinfo.vala"
					_tocListItemMap_list = _tmp19_;
#line 366 "../src/bookinfo.vala"
					_tmp20_ = _tocListItemMap_list;
#line 366 "../src/bookinfo.vala"
					_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
#line 366 "../src/bookinfo.vala"
					_tmp22_ = _tmp21_;
#line 366 "../src/bookinfo.vala"
					_tocListItemMap_size = _tmp22_;
#line 366 "../src/bookinfo.vala"
					_tocListItemMap_index = -1;
#line 366 "../src/bookinfo.vala"
					while (TRUE) {
#line 3991 "bookinfo.c"
						gint _tmp23_;
						gint _tmp24_;
						GeeHashMap* tocListItemMap = NULL;
						GeeArrayList* _tmp25_;
						gpointer _tmp26_;
#line 366 "../src/bookinfo.vala"
						_tocListItemMap_index = _tocListItemMap_index + 1;
#line 366 "../src/bookinfo.vala"
						_tmp23_ = _tocListItemMap_index;
#line 366 "../src/bookinfo.vala"
						_tmp24_ = _tocListItemMap_size;
#line 366 "../src/bookinfo.vala"
						if (!(_tmp23_ < _tmp24_)) {
#line 366 "../src/bookinfo.vala"
							break;
#line 4007 "bookinfo.c"
						}
#line 366 "../src/bookinfo.vala"
						_tmp25_ = _tocListItemMap_list;
#line 366 "../src/bookinfo.vala"
						_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tocListItemMap_index);
#line 366 "../src/bookinfo.vala"
						tocListItemMap = (GeeHashMap*) _tmp26_;
#line 4015 "bookinfo.c"
						{
							GeeIterator* _entry_it = NULL;
							GeeHashMap* _tmp27_;
							GeeSet* _tmp28_;
							GeeSet* _tmp29_;
							GeeSet* _tmp30_;
							GeeIterator* _tmp31_;
							GeeIterator* _tmp32_;
#line 367 "../src/bookinfo.vala"
							_tmp27_ = tocListItemMap;
#line 367 "../src/bookinfo.vala"
							_tmp28_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp27_);
#line 367 "../src/bookinfo.vala"
							_tmp29_ = _tmp28_;
#line 367 "../src/bookinfo.vala"
							_tmp30_ = _tmp29_;
#line 367 "../src/bookinfo.vala"
							_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
#line 367 "../src/bookinfo.vala"
							_tmp32_ = _tmp31_;
#line 367 "../src/bookinfo.vala"
							_g_object_unref0 (_tmp30_);
#line 367 "../src/bookinfo.vala"
							_entry_it = _tmp32_;
#line 367 "../src/bookinfo.vala"
							while (TRUE) {
#line 4042 "bookinfo.c"
								Block12Data* _data12_;
								GeeIterator* _tmp33_;
								GeeMapEntry* entry = NULL;
								GeeIterator* _tmp34_;
								gpointer _tmp35_;
								GeeMapEntry* _tmp36_;
								gconstpointer _tmp37_;
								gconstpointer _tmp38_;
								GeeMapEntry* _tmp39_;
								gconstpointer _tmp40_;
								gconstpointer _tmp41_;
								gchar* _tmp42_;
								gchar* _tmp43_;
								GtkLinkButton* _tmp44_;
								GtkLinkButton* _tmp45_;
								GtkLinkButton* _tmp46_;
								GtkBox* _tmp47_;
								GtkLinkButton* _tmp48_;
								GtkLinkButton* _tmp49_;
#line 367 "../src/bookinfo.vala"
								_data12_ = g_slice_new0 (Block12Data);
#line 367 "../src/bookinfo.vala"
								_data12_->_ref_count_ = 1;
#line 367 "../src/bookinfo.vala"
								_data12_->_data11_ = block11_data_ref (_data11_);
#line 367 "../src/bookinfo.vala"
								_tmp33_ = _entry_it;
#line 367 "../src/bookinfo.vala"
								if (!gee_iterator_next (_tmp33_)) {
#line 367 "../src/bookinfo.vala"
									block12_data_unref (_data12_);
#line 367 "../src/bookinfo.vala"
									_data12_ = NULL;
#line 367 "../src/bookinfo.vala"
									break;
#line 4078 "bookinfo.c"
								}
#line 367 "../src/bookinfo.vala"
								_tmp34_ = _entry_it;
#line 367 "../src/bookinfo.vala"
								_tmp35_ = gee_iterator_get (_tmp34_);
#line 367 "../src/bookinfo.vala"
								entry = (GeeMapEntry*) _tmp35_;
#line 368 "../src/bookinfo.vala"
								_tmp36_ = entry;
#line 368 "../src/bookinfo.vala"
								_tmp37_ = gee_map_entry_get_key (_tmp36_);
#line 368 "../src/bookinfo.vala"
								_tmp38_ = _tmp37_;
#line 368 "../src/bookinfo.vala"
								_tmp39_ = entry;
#line 368 "../src/bookinfo.vala"
								_tmp40_ = gee_map_entry_get_value (_tmp39_);
#line 368 "../src/bookinfo.vala"
								_tmp41_ = _tmp40_;
#line 368 "../src/bookinfo.vala"
								_tmp42_ = bookworm_app_utils_parseMarkUp ((const gchar*) _tmp41_);
#line 368 "../src/bookinfo.vala"
								_tmp43_ = _tmp42_;
#line 368 "../src/bookinfo.vala"
								_tmp44_ = (GtkLinkButton*) gtk_link_button_new_with_label ((const gchar*) _tmp38_, _tmp43_);
#line 368 "../src/bookinfo.vala"
								g_object_ref_sink (_tmp44_);
#line 368 "../src/bookinfo.vala"
								_tmp45_ = _tmp44_;
#line 368 "../src/bookinfo.vala"
								_g_free0 (_tmp43_);
#line 368 "../src/bookinfo.vala"
								_data12_->contentLinkButton = _tmp45_;
#line 369 "../src/bookinfo.vala"
								_tmp46_ = _data12_->contentLinkButton;
#line 369 "../src/bookinfo.vala"
								gtk_widget_set_halign ((GtkWidget*) _tmp46_, GTK_ALIGN_START);
#line 370 "../src/bookinfo.vala"
								_tmp47_ = content_box;
#line 370 "../src/bookinfo.vala"
								_tmp48_ = _data12_->contentLinkButton;
#line 370 "../src/bookinfo.vala"
								gtk_box_pack_start (_tmp47_, (GtkWidget*) _tmp48_, FALSE, FALSE, (guint) 0);
#line 371 "../src/bookinfo.vala"
								_tmp49_ = _data12_->contentLinkButton;
#line 371 "../src/bookinfo.vala"
								g_signal_connect_data (_tmp49_, "activate-link", (GCallback) __________lambda6__gtk_link_button_activate_link, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 367 "../src/bookinfo.vala"
								_g_object_unref0 (entry);
#line 367 "../src/bookinfo.vala"
								block12_data_unref (_data12_);
#line 367 "../src/bookinfo.vala"
								_data12_ = NULL;
#line 4132 "bookinfo.c"
							}
#line 367 "../src/bookinfo.vala"
							_g_object_unref0 (_entry_it);
#line 4136 "bookinfo.c"
						}
#line 366 "../src/bookinfo.vala"
						_g_object_unref0 (tocListItemMap);
#line 4140 "bookinfo.c"
					}
				}
#line 364 "../src/bookinfo.vala"
				_g_object_unref0 (tocList);
#line 4145 "bookinfo.c"
			} else {
				gint contentNumber = 0;
#line 395 "../src/bookinfo.vala"
				contentNumber = 1;
#line 4150 "bookinfo.c"
				{
					GeeArrayList* _contentPath_list = NULL;
					BookwormAppBook* _tmp50_;
					GeeArrayList* _tmp51_;
					gint _contentPath_size = 0;
					GeeArrayList* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					gint _contentPath_index = 0;
#line 396 "../src/bookinfo.vala"
					_tmp50_ = _data11_->aBook;
#line 396 "../src/bookinfo.vala"
					_tmp51_ = bookworm_app_book_getBookContentList (_tmp50_);
#line 396 "../src/bookinfo.vala"
					_contentPath_list = _tmp51_;
#line 396 "../src/bookinfo.vala"
					_tmp52_ = _contentPath_list;
#line 396 "../src/bookinfo.vala"
					_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
#line 396 "../src/bookinfo.vala"
					_tmp54_ = _tmp53_;
#line 396 "../src/bookinfo.vala"
					_contentPath_size = _tmp54_;
#line 396 "../src/bookinfo.vala"
					_contentPath_index = -1;
#line 396 "../src/bookinfo.vala"
					while (TRUE) {
#line 4178 "bookinfo.c"
						Block13Data* _data13_;
						gint _tmp55_;
						gint _tmp56_;
						gchar* contentPath = NULL;
						GeeArrayList* _tmp57_;
						gpointer _tmp58_;
						const gchar* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						GtkLinkButton* _tmp64_;
						GtkLinkButton* _tmp65_;
						GtkLinkButton* _tmp66_;
						GtkBox* _tmp67_;
						GtkLinkButton* _tmp68_;
						GeeHashMap* TOCMapItem = NULL;
						GeeHashMap* _tmp69_;
						GeeHashMap* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						BookwormAppBook* _tmp76_;
						GeeHashMap* _tmp77_;
						gint _tmp78_;
						GtkLinkButton* _tmp79_;
#line 396 "../src/bookinfo.vala"
						_data13_ = g_slice_new0 (Block13Data);
#line 396 "../src/bookinfo.vala"
						_data13_->_ref_count_ = 1;
#line 396 "../src/bookinfo.vala"
						_data13_->_data11_ = block11_data_ref (_data11_);
#line 396 "../src/bookinfo.vala"
						_contentPath_index = _contentPath_index + 1;
#line 396 "../src/bookinfo.vala"
						_tmp55_ = _contentPath_index;
#line 396 "../src/bookinfo.vala"
						_tmp56_ = _contentPath_size;
#line 396 "../src/bookinfo.vala"
						if (!(_tmp55_ < _tmp56_)) {
#line 396 "../src/bookinfo.vala"
							block13_data_unref (_data13_);
#line 396 "../src/bookinfo.vala"
							_data13_ = NULL;
#line 396 "../src/bookinfo.vala"
							break;
#line 4227 "bookinfo.c"
						}
#line 396 "../src/bookinfo.vala"
						_tmp57_ = _contentPath_list;
#line 396 "../src/bookinfo.vala"
						_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _contentPath_index);
#line 396 "../src/bookinfo.vala"
						contentPath = (gchar*) _tmp58_;
#line 397 "../src/bookinfo.vala"
						_tmp59_ = contentPath;
#line 397 "../src/bookinfo.vala"
						_tmp60_ = g_strdup_printf ("%i", contentNumber);
#line 397 "../src/bookinfo.vala"
						_tmp61_ = _tmp60_;
#line 397 "../src/bookinfo.vala"
						_tmp62_ = g_strconcat (BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_CONTENT_PREFIX, _tmp61_, NULL);
#line 397 "../src/bookinfo.vala"
						_tmp63_ = _tmp62_;
#line 397 "../src/bookinfo.vala"
						_tmp64_ = (GtkLinkButton*) gtk_link_button_new_with_label (_tmp59_, _tmp63_);
#line 397 "../src/bookinfo.vala"
						g_object_ref_sink (_tmp64_);
#line 397 "../src/bookinfo.vala"
						_tmp65_ = _tmp64_;
#line 397 "../src/bookinfo.vala"
						_g_free0 (_tmp63_);
#line 397 "../src/bookinfo.vala"
						_g_free0 (_tmp61_);
#line 397 "../src/bookinfo.vala"
						_data13_->contentLinkButton = _tmp65_;
#line 399 "../src/bookinfo.vala"
						_tmp66_ = _data13_->contentLinkButton;
#line 399 "../src/bookinfo.vala"
						gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_START);
#line 400 "../src/bookinfo.vala"
						_tmp67_ = content_box;
#line 400 "../src/bookinfo.vala"
						_tmp68_ = _data13_->contentLinkButton;
#line 400 "../src/bookinfo.vala"
						gtk_box_pack_start (_tmp67_, (GtkWidget*) _tmp68_, FALSE, FALSE, (guint) 0);
#line 402 "../src/bookinfo.vala"
						_tmp69_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 402 "../src/bookinfo.vala"
						TOCMapItem = _tmp69_;
#line 403 "../src/bookinfo.vala"
						_tmp70_ = TOCMapItem;
#line 403 "../src/bookinfo.vala"
						_tmp71_ = contentPath;
#line 403 "../src/bookinfo.vala"
						_tmp72_ = g_strdup_printf ("%i", contentNumber);
#line 403 "../src/bookinfo.vala"
						_tmp73_ = _tmp72_;
#line 403 "../src/bookinfo.vala"
						_tmp74_ = g_strconcat (BOOKWORM_APP_CONSTANTS_TEXT_FOR_INFO_TAB_CONTENT_PREFIX, _tmp73_, NULL);
#line 403 "../src/bookinfo.vala"
						_tmp75_ = _tmp74_;
#line 403 "../src/bookinfo.vala"
						gee_abstract_map_set ((GeeAbstractMap*) _tmp70_, _tmp71_, _tmp75_);
#line 403 "../src/bookinfo.vala"
						_g_free0 (_tmp75_);
#line 403 "../src/bookinfo.vala"
						_g_free0 (_tmp73_);
#line 404 "../src/bookinfo.vala"
						_tmp76_ = _data11_->aBook;
#line 404 "../src/bookinfo.vala"
						_tmp77_ = TOCMapItem;
#line 404 "../src/bookinfo.vala"
						bookworm_app_book_setTOC (_tmp76_, _tmp77_);
#line 405 "../src/bookinfo.vala"
						_tmp78_ = contentNumber;
#line 405 "../src/bookinfo.vala"
						contentNumber = _tmp78_ + 1;
#line 407 "../src/bookinfo.vala"
						_tmp79_ = _data13_->contentLinkButton;
#line 407 "../src/bookinfo.vala"
						g_signal_connect_data (_tmp79_, "activate-link", (GCallback) ________lambda41__gtk_link_button_activate_link, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
#line 396 "../src/bookinfo.vala"
						_g_object_unref0 (TOCMapItem);
#line 396 "../src/bookinfo.vala"
						_g_free0 (contentPath);
#line 396 "../src/bookinfo.vala"
						block13_data_unref (_data13_);
#line 396 "../src/bookinfo.vala"
						_data13_ = NULL;
#line 4311 "bookinfo.c"
					}
#line 396 "../src/bookinfo.vala"
					_g_object_unref0 (_contentPath_list);
#line 4315 "bookinfo.c"
				}
			}
#line 419 "../src/bookinfo.vala"
			_tmp80_ = _data11_->aBook;
#line 419 "../src/bookinfo.vala"
			_tmp81_ = content_box;
#line 419 "../src/bookinfo.vala"
			bookworm_app_book_setBookWidget (_tmp80_, "TABLE_OF_CONTENTS_WIDGET", (GtkWidget*) _tmp81_);
#line 4324 "bookinfo.c"
		}
#line 422 "../src/bookinfo.vala"
		_tmp82_ = content_box;
#line 422 "../src/bookinfo.vala"
		gtk_widget_unparent ((GtkWidget*) _tmp82_);
#line 423 "../src/bookinfo.vala"
		_tmp83_ = bookworm_app_info_content_scroll;
#line 423 "../src/bookinfo.vala"
		_tmp84_ = gtk_bin_get_child ((GtkBin*) _tmp83_);
#line 423 "../src/bookinfo.vala"
		if (_tmp84_ != NULL) {
#line 4336 "bookinfo.c"
			GtkScrolledWindow* _tmp85_;
			GtkWidget* _tmp86_;
			GtkScrolledWindow* _tmp87_;
			GtkScrolledWindow* _tmp88_;
			GtkWidget* _tmp89_;
			GtkScrolledWindow* _tmp90_;
			GtkBox* _tmp91_;
#line 425 "../src/bookinfo.vala"
			_tmp85_ = bookworm_app_info_content_scroll;
#line 425 "../src/bookinfo.vala"
			_tmp86_ = gtk_bin_get_child ((GtkBin*) _tmp85_);
#line 425 "../src/bookinfo.vala"
			g_object_ref ((GObject*) _tmp86_);
#line 427 "../src/bookinfo.vala"
			_tmp87_ = bookworm_app_info_content_scroll;
#line 427 "../src/bookinfo.vala"
			_tmp88_ = bookworm_app_info_content_scroll;
#line 427 "../src/bookinfo.vala"
			_tmp89_ = gtk_bin_get_child ((GtkBin*) _tmp88_);
#line 427 "../src/bookinfo.vala"
			gtk_container_remove ((GtkContainer*) _tmp87_, _tmp89_);
#line 429 "../src/bookinfo.vala"
			_tmp90_ = bookworm_app_info_content_scroll;
#line 429 "../src/bookinfo.vala"
			_tmp91_ = content_box;
#line 429 "../src/bookinfo.vala"
			gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
#line 4364 "bookinfo.c"
		} else {
			GtkScrolledWindow* _tmp92_;
			GtkBox* _tmp93_;
#line 432 "../src/bookinfo.vala"
			_tmp92_ = bookworm_app_info_content_scroll;
#line 432 "../src/bookinfo.vala"
			_tmp93_ = content_box;
#line 432 "../src/bookinfo.vala"
			gtk_container_add ((GtkContainer*) _tmp92_, (GtkWidget*) _tmp93_);
#line 4374 "bookinfo.c"
		}
	}
#line 435 "../src/bookinfo.vala"
	g_info ("bookinfo.vala:435: [END] [FUNCTION:createTableOfContents]");
#line 436 "../src/bookinfo.vala"
	_tmp94_ = _data11_->aBook;
#line 436 "../src/bookinfo.vala"
	_tmp95_ = _bookworm_app_book_ref0 (_tmp94_);
#line 436 "../src/bookinfo.vala"
	result = _tmp95_;
#line 436 "../src/bookinfo.vala"
	_g_object_unref0 (content_box);
#line 436 "../src/bookinfo.vala"
	block11_data_unref (_data11_);
#line 436 "../src/bookinfo.vala"
	_data11_ = NULL;
#line 436 "../src/bookinfo.vala"
	return result;
#line 4393 "bookinfo.c"
}

BookwormAppInfo*
bookworm_app_info_construct (GType object_type)
{
	BookwormAppInfo * self = NULL;
#line 21 "../src/bookinfo.vala"
	self = (BookwormAppInfo*) g_object_new (object_type, NULL);
#line 21 "../src/bookinfo.vala"
	return self;
#line 4404 "bookinfo.c"
}

BookwormAppInfo*
bookworm_app_info_new (void)
{
#line 21 "../src/bookinfo.vala"
	return bookworm_app_info_construct (BOOKWORM_APP_TYPE_INFO);
#line 4412 "bookinfo.c"
}

static void
bookworm_app_info_class_init (BookwormAppInfoClass * klass,
                              gpointer klass_data)
{
#line 21 "../src/bookinfo.vala"
	bookworm_app_info_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/bookinfo.vala"
	G_OBJECT_CLASS (klass)->finalize = bookworm_app_info_finalize;
#line 4423 "bookinfo.c"
}

static void
bookworm_app_info_instance_init (BookwormAppInfo * self,
                                 gpointer klass)
{
}

static void
bookworm_app_info_finalize (GObject * obj)
{
	BookwormAppInfo * self;
#line 21 "../src/bookinfo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_INFO, BookwormAppInfo);
#line 21 "../src/bookinfo.vala"
	G_OBJECT_CLASS (bookworm_app_info_parent_class)->finalize (obj);
#line 4440 "bookinfo.c"
}

static GType
bookworm_app_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppInfo), 0, (GInstanceInitFunc) bookworm_app_info_instance_init, NULL };
	GType bookworm_app_info_type_id;
	bookworm_app_info_type_id = g_type_register_static (gtk_window_get_type (), "BookwormAppInfo", &g_define_type_info, 0);
	return bookworm_app_info_type_id;
}

GType
bookworm_app_info_get_type (void)
{
	static volatile gsize bookworm_app_info_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_info_type_id__once)) {
		GType bookworm_app_info_type_id;
		bookworm_app_info_type_id = bookworm_app_info_get_type_once ();
		g_once_init_leave (&bookworm_app_info_type_id__once, bookworm_app_info_type_id);
	}
	return bookworm_app_info_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

