/* contentHandler.c generated by valac 0.56.18, the Vala compiler
 * generated from contentHandler.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for handling the eBook contents
* The prerequisite for the content handler is for the eBook contents to have
* been parsed into HTML format
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <webkit2/webkit2.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_PREFIX_FOR_FILE_URL "file:///"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_NAVIGATION_ISSUE _ ("Issue in page navigation, please move the pages forward or backward.")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_NOT_FOUND_ISSUE _ ("Requested content could not be fetched. Please remove and add the eBoo" \
"k file found here: ")
#define BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "/com/github/babluboy/bookworm/"
#define BOOKWORM_APP_CONSTANTS_BOOKWORM_HTML_SCRIPT "com.github.babluboy.bookworm.htmlscripts.txt"
#define BOOKWORM_APP_CONSTANTS_HTML_SCRIPT_RESOURCE_LOCATION "resource:///" BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX BOOKWORM_APP_CONSTANTS_BOOKWORM_HTML_SCRIPT
#define BOOKWORM_APP_CONSTANTS_INSTALL_TASKS_DIR "/usr/share/com.github.babluboy.bookworm/scripts/tasks"
#define BOOKWORM_APP_CONSTANTS_SEARCH_SCRIPT_LOCATION BOOKWORM_APP_CONSTANTS_INSTALL_TASKS_DIR "/com.github.babluboy.bookworm.search.sh"
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_CONTENT_HANDLER (bookworm_app_content_handler_get_type ())
#define BOOKWORM_APP_CONTENT_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_CONTENT_HANDLER, BookwormAppcontentHandler))
#define BOOKWORM_APP_CONTENT_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_CONTENT_HANDLER, BookwormAppcontentHandlerClass))
#define BOOKWORM_APP_IS_CONTENT_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_CONTENT_HANDLER))
#define BOOKWORM_APP_IS_CONTENT_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_CONTENT_HANDLER))
#define BOOKWORM_APP_CONTENT_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_CONTENT_HANDLER, BookwormAppcontentHandlerClass))

typedef struct _BookwormAppcontentHandler BookwormAppcontentHandler;
typedef struct _BookwormAppcontentHandlerClass BookwormAppcontentHandlerClass;
typedef struct _BookwormAppcontentHandlerPrivate BookwormAppcontentHandlerPrivate;

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _BookwormAppParamSpeccontentHandler BookwormAppParamSpeccontentHandler;

struct _BookwormAppcontentHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppcontentHandlerPrivate * priv;
};

struct _BookwormAppcontentHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppcontentHandler *self);
};

struct _BookwormAppParamSpeccontentHandler {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_content_handler_parent_class = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_content_handler_settings;
BookwormAppSettings* bookworm_app_content_handler_settings = NULL;
VALA_EXTERN WebKitWebView* bookworm_app_app_window_aWebView;
VALA_EXTERN GtkAdjustment* bookworm_app_app_window_pageAdjustment;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;
VALA_EXTERN GtkButton* bookworm_app_app_header_bar_bookmark_active_button;
VALA_EXTERN GtkButton* bookworm_app_app_header_bar_bookmark_inactive_button;
VALA_EXTERN gchar* bookworm_app_bookworm_bookwormScripts;
VALA_EXTERN GString* bookworm_app_bookworm_onLoadJavaScript;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN gchar** bookworm_app_bookworm_profileColorList;
VALA_EXTERN gint bookworm_app_bookworm_profileColorList_length1;
VALA_EXTERN gboolean bookworm_app_bookworm_isPageScrollRequired;
VALA_EXTERN gchar* bookworm_app_bookworm_bookTextSearchString;
VALA_EXTERN GeeTreeMap* bookworm_app_bookworm_searchResultsMap;
VALA_EXTERN GString* bookworm_app_bookworm_aContentFileToBeSearched;
VALA_EXTERN GtkSearchEntry* bookworm_app_app_header_bar_headerSearchBar;
VALA_EXTERN GtkButton* bookworm_app_app_window_back_button;
VALA_EXTERN GtkButton* bookworm_app_app_window_forward_button;
VALA_EXTERN gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
VALA_EXTERN gchar** bookworm_app_bookworm_pathsOfBooksToBeAdded;
VALA_EXTERN gint bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
VALA_EXTERN GString* bookworm_app_bookworm_pathsOfBooksNotAddedStr;
VALA_EXTERN GString* bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
VALA_EXTERN gchar** bookworm_app_bookworm_commandLineArgs;
VALA_EXTERN gint bookworm_app_bookworm_commandLineArgs_length1;
VALA_EXTERN GeeArrayList* bookworm_app_library_listOfBooksInLibraryOnLoad;

VALA_EXTERN gpointer bookworm_app_content_handler_ref (gpointer instance);
VALA_EXTERN void bookworm_app_content_handler_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_content_handler (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_content_handler (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_content_handler (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_content_handler (const GValue* value);
VALA_EXTERN GType bookworm_app_content_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppcontentHandler, bookworm_app_content_handler_unref)
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                                          gchar* direction);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN gint bookworm_app_book_getBookPageNumber (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIfPageForward (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookPageNumber (BookwormAppBook* self,
                                          gint aBookPageNumber);
VALA_EXTERN gboolean bookworm_app_book_getIfPageBackward (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_content_handler_provideContent (BookwormAppBook* aBook,
                                                    gint contentLocation,
                                                    const gchar* mode);
VALA_EXTERN void bookworm_app_content_handler_handleBookMark (const gchar* action);
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_controlNavigation (BookwormAppBook* aBook);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_decodeHTMLChars (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN gchar** bookworm_app_utils_multiExtractBetweenTwoStrings (const gchar* stringToBeSearched,
                                                          const gchar* startString,
                                                          const gchar* endString,
                                                          gint* result_length1);
VALA_EXTERN gchar* bookworm_app_utils_getFullPathFromFilename (const gchar* rootDirectoryToSearch,
                                                   const gchar* fileName);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_encodeHTMLChars (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_content_handler_adjustPageContent (BookwormAppBook* aBook,
                                                       gchar* pageContentStr,
                                                       const gchar* mode);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN void bookworm_app_app_window_showInfoBar (BookwormAppBook* aBook,
                                          GtkMessageType aMessageType);
VALA_EXTERN gchar* bookworm_app_book_getBookmark (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookmark (BookwormAppBook* self,
                                    gint pageNumber,
                                    const gchar* action);
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_profile (BookwormAppSettings* self);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_line_height (BookwormAppSettings* self);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_width (BookwormAppSettings* self);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_font_name_family (BookwormAppSettings* self);
VALA_EXTERN gint bookworm_app_settings_get_reading_font_size (BookwormAppSettings* self);
VALA_EXTERN const gchar* bookworm_app_settings_get_text_alignment (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_book_getAnchor (BookwormAppBook* self);
VALA_EXTERN gint bookworm_app_book_getBookScrollPos (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_settings_get_is_two_page_enabled (BookwormAppSettings* self);
VALA_EXTERN GeeTreeMap* bookworm_app_book_getAnnotationList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_content_handler_searchHTMLContents (void);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
VALA_EXTERN void bookworm_app_book_setIfPageBackward (BookwormAppBook* self,
                                          gboolean ifBookPageBackward);
VALA_EXTERN void bookworm_app_book_setIfPageForward (BookwormAppBook* self,
                                         gboolean ifBookPageForward);
VALA_EXTERN void bookworm_app_content_handler_refreshCurrentPage (void);
VALA_EXTERN gint bookworm_app_content_handler_getScrollPos (void);
VALA_EXTERN gchar* bookworm_app_utils_setWebViewTitle (const gchar* javascript);
VALA_EXTERN void bookworm_app_content_handler_performStartUpActions (void);
VALA_EXTERN void bookworm_app_bookworm_readSelectedBook (BookwormAppBook* aBook);
VALA_EXTERN gboolean bookworm_app_settings_get_is_show_library_on_start (BookwormAppSettings* self);
VALA_EXTERN const gchar* bookworm_app_settings_get_book_being_read (BookwormAppSettings* self);
VALA_EXTERN BookwormAppBook* bookworm_app_db_getBookFromDB (const gchar* book_location);
VALA_EXTERN BookwormAppcontentHandler* bookworm_app_content_handler_new (void);
VALA_EXTERN BookwormAppcontentHandler* bookworm_app_content_handler_construct (GType object_type);
static void bookworm_app_content_handler_finalize (BookwormAppcontentHandler * obj);
static GType bookworm_app_content_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_TAG_NAME_WITH_PATHS[3];
VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[5];
VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[8];

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 50 "../src/contentHandler.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 262 "contentHandler.c"
}

BookwormAppBook*
bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                         gchar* direction)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint currentContentLocation = 0;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
#line 31 "../src/contentHandler.vala"
	static GQuark _tmp9_label0 = 0;
#line 31 "../src/contentHandler.vala"
	static GQuark _tmp9_label1 = 0;
#line 31 "../src/contentHandler.vala"
	static GQuark _tmp9_label2 = 0;
#line 286 "contentHandler.c"
	gchar* bookContent = NULL;
	BookwormAppBook* _tmp13_;
	gchar* _tmp14_;
	WebKitWebView* _tmp15_;
	BookwormAppBook* _tmp16_;
	BookwormAppBook* _tmp17_;
	GtkAdjustment* _tmp18_;
	BookwormAppBook* _tmp19_;
	BookwormAppBook* result;
#line 25 "../src/contentHandler.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 25 "../src/contentHandler.vala"
	g_return_val_if_fail (direction != NULL, NULL);
#line 26 "../src/contentHandler.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 26 "../src/contentHandler.vala"
	_tmp1_ = _tmp0_;
#line 26 "../src/contentHandler.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:renderPage] book.location=", _tmp1_, NULL);
#line 26 "../src/contentHandler.vala"
	_tmp3_ = _tmp2_;
#line 26 "../src/contentHandler.vala"
	_tmp4_ = g_strconcat (_tmp3_, ", direction=", NULL);
#line 26 "../src/contentHandler.vala"
	_tmp5_ = _tmp4_;
#line 26 "../src/contentHandler.vala"
	_tmp6_ = g_strconcat (_tmp5_, direction, NULL);
#line 26 "../src/contentHandler.vala"
	_tmp7_ = _tmp6_;
#line 26 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:26: %s", _tmp7_);
#line 26 "../src/contentHandler.vala"
	_g_free0 (_tmp7_);
#line 26 "../src/contentHandler.vala"
	_g_free0 (_tmp5_);
#line 26 "../src/contentHandler.vala"
	_g_free0 (_tmp3_);
#line 26 "../src/contentHandler.vala"
	_g_free0 (_tmp1_);
#line 29 "../src/contentHandler.vala"
	currentContentLocation = bookworm_app_book_getBookPageNumber (aBook);
#line 31 "../src/contentHandler.vala"
	_tmp8_ = direction;
#line 31 "../src/contentHandler.vala"
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
#line 31 "../src/contentHandler.vala"
	if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("FORWARD")))) {
#line 31 "../src/contentHandler.vala"
		switch (0) {
#line 336 "contentHandler.c"
			default:
			{
#line 33 "../src/contentHandler.vala"
				if (bookworm_app_book_getIfPageForward (aBook)) {
#line 341 "contentHandler.c"
					gint _tmp11_;
#line 34 "../src/contentHandler.vala"
					_tmp11_ = currentContentLocation;
#line 34 "../src/contentHandler.vala"
					currentContentLocation = _tmp11_ + 1;
#line 35 "../src/contentHandler.vala"
					bookworm_app_book_setBookPageNumber (aBook, currentContentLocation);
#line 349 "contentHandler.c"
				}
#line 37 "../src/contentHandler.vala"
				break;
#line 353 "contentHandler.c"
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("BACKWARD")))) {
#line 31 "../src/contentHandler.vala"
		switch (0) {
#line 359 "contentHandler.c"
			default:
			{
#line 39 "../src/contentHandler.vala"
				if (bookworm_app_book_getIfPageBackward (aBook)) {
#line 364 "contentHandler.c"
					gint _tmp12_;
#line 40 "../src/contentHandler.vala"
					_tmp12_ = currentContentLocation;
#line 40 "../src/contentHandler.vala"
					currentContentLocation = _tmp12_ - 1;
#line 41 "../src/contentHandler.vala"
					bookworm_app_book_setBookPageNumber (aBook, currentContentLocation);
#line 372 "contentHandler.c"
				}
#line 43 "../src/contentHandler.vala"
				break;
#line 376 "contentHandler.c"
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("SEARCH")))) {
#line 31 "../src/contentHandler.vala"
		switch (0) {
#line 382 "contentHandler.c"
			default:
			{
#line 45 "../src/contentHandler.vala"
				break;
#line 387 "contentHandler.c"
			}
		}
	} else {
#line 31 "../src/contentHandler.vala"
		switch (0) {
#line 393 "contentHandler.c"
			default:
			{
#line 48 "../src/contentHandler.vala"
				break;
#line 398 "contentHandler.c"
			}
		}
	}
#line 50 "../src/contentHandler.vala"
	_tmp13_ = _bookworm_app_book_ref0 (aBook);
#line 50 "../src/contentHandler.vala"
	_tmp14_ = bookworm_app_content_handler_provideContent (_tmp13_, currentContentLocation, direction);
#line 50 "../src/contentHandler.vala"
	bookContent = _tmp14_;
#line 54 "../src/contentHandler.vala"
	_tmp15_ = bookworm_app_app_window_aWebView;
#line 54 "../src/contentHandler.vala"
	webkit_web_view_load_html (_tmp15_, bookContent, BOOKWORM_APP_CONSTANTS_PREFIX_FOR_FILE_URL);
#line 56 "../src/contentHandler.vala"
	bookworm_app_content_handler_handleBookMark ("DISPLAY");
#line 58 "../src/contentHandler.vala"
	_tmp16_ = _bookworm_app_book_ref0 (aBook);
#line 58 "../src/contentHandler.vala"
	_tmp17_ = bookworm_app_content_handler_controlNavigation (_tmp16_);
#line 58 "../src/contentHandler.vala"
	_bookworm_app_book_unref0 (aBook);
#line 58 "../src/contentHandler.vala"
	aBook = _tmp17_;
#line 60 "../src/contentHandler.vala"
	_tmp18_ = bookworm_app_app_window_pageAdjustment;
#line 60 "../src/contentHandler.vala"
	gtk_adjustment_set_value (_tmp18_, (gdouble) (currentContentLocation + 1));
#line 61 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:61: [END] [FUNCTION:renderPage]");
#line 62 "../src/contentHandler.vala"
	_tmp19_ = _bookworm_app_book_ref0 (aBook);
#line 62 "../src/contentHandler.vala"
	result = _tmp19_;
#line 62 "../src/contentHandler.vala"
	_g_free0 (bookContent);
#line 62 "../src/contentHandler.vala"
	_bookworm_app_book_unref0 (aBook);
#line 62 "../src/contentHandler.vala"
	_g_free0 (direction);
#line 62 "../src/contentHandler.vala"
	return result;
#line 440 "contentHandler.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 462 "contentHandler.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 466 "contentHandler.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 472 "contentHandler.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 476 "contentHandler.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 480 "contentHandler.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 488 "contentHandler.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 516 "contentHandler.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 525 "contentHandler.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 539 "contentHandler.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 548 "contentHandler.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 562 "contentHandler.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 571 "contentHandler.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 580 "contentHandler.c"
}

gchar*
bookworm_app_content_handler_provideContent (BookwormAppBook* aBook,
                                             gint contentLocation,
                                             const gchar* mode)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GString* contents = NULL;
	GString* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	gboolean _tmp17_;
	GString* _tmp82_;
	const gchar* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	GString* _tmp90_;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* result;
#line 65 "../src/contentHandler.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 65 "../src/contentHandler.vala"
	g_return_val_if_fail (mode != NULL, NULL);
#line 66 "../src/contentHandler.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 66 "../src/contentHandler.vala"
	_tmp1_ = _tmp0_;
#line 66 "../src/contentHandler.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:provideContent] book.location=", _tmp1_, NULL);
#line 66 "../src/contentHandler.vala"
	_tmp3_ = _tmp2_;
#line 66 "../src/contentHandler.vala"
	_tmp4_ = g_strconcat (_tmp3_, ", contentLocation=", NULL);
#line 66 "../src/contentHandler.vala"
	_tmp5_ = _tmp4_;
#line 66 "../src/contentHandler.vala"
	_tmp6_ = g_strdup_printf ("%i", contentLocation);
#line 66 "../src/contentHandler.vala"
	_tmp7_ = _tmp6_;
#line 66 "../src/contentHandler.vala"
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
#line 66 "../src/contentHandler.vala"
	_tmp9_ = _tmp8_;
#line 66 "../src/contentHandler.vala"
	_tmp10_ = g_strconcat (_tmp9_, ", mode=", NULL);
#line 66 "../src/contentHandler.vala"
	_tmp11_ = _tmp10_;
#line 66 "../src/contentHandler.vala"
	_tmp12_ = g_strconcat (_tmp11_, mode, NULL);
#line 66 "../src/contentHandler.vala"
	_tmp13_ = _tmp12_;
#line 66 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:66: %s", _tmp13_);
#line 66 "../src/contentHandler.vala"
	_g_free0 (_tmp13_);
#line 66 "../src/contentHandler.vala"
	_g_free0 (_tmp11_);
#line 66 "../src/contentHandler.vala"
	_g_free0 (_tmp9_);
#line 66 "../src/contentHandler.vala"
	_g_free0 (_tmp7_);
#line 66 "../src/contentHandler.vala"
	_g_free0 (_tmp5_);
#line 66 "../src/contentHandler.vala"
	_g_free0 (_tmp3_);
#line 66 "../src/contentHandler.vala"
	_g_free0 (_tmp1_);
#line 69 "../src/contentHandler.vala"
	_tmp14_ = g_string_new ("");
#line 69 "../src/contentHandler.vala"
	contents = _tmp14_;
#line 70 "../src/contentHandler.vala"
	_tmp15_ = bookworm_app_book_getBookContentList (aBook);
#line 70 "../src/contentHandler.vala"
	_tmp16_ = _tmp15_;
#line 70 "../src/contentHandler.vala"
	_tmp17_ = _tmp16_ != NULL;
#line 70 "../src/contentHandler.vala"
	_g_object_unref0 (_tmp16_);
#line 70 "../src/contentHandler.vala"
	if (_tmp17_) {
#line 681 "contentHandler.c"
		gboolean _tmp18_ = FALSE;
#line 71 "../src/contentHandler.vala"
		if (contentLocation > -1) {
#line 685 "contentHandler.c"
			GeeArrayList* _tmp19_;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
#line 71 "../src/contentHandler.vala"
			_tmp19_ = bookworm_app_book_getBookContentList (aBook);
#line 71 "../src/contentHandler.vala"
			_tmp20_ = _tmp19_;
#line 71 "../src/contentHandler.vala"
			_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
#line 71 "../src/contentHandler.vala"
			_tmp22_ = _tmp21_;
#line 71 "../src/contentHandler.vala"
			_tmp18_ = _tmp22_ > contentLocation;
#line 71 "../src/contentHandler.vala"
			_g_object_unref0 (_tmp20_);
#line 702 "contentHandler.c"
		} else {
#line 71 "../src/contentHandler.vala"
			_tmp18_ = FALSE;
#line 706 "contentHandler.c"
		}
#line 71 "../src/contentHandler.vala"
		if (_tmp18_) {
#line 710 "contentHandler.c"
			gchar* bookLocationToRead = NULL;
			GeeArrayList* _tmp23_;
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GString* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			GString* _tmp68_;
			GString* _tmp69_;
			const gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
#line 73 "../src/contentHandler.vala"
			_tmp23_ = bookworm_app_book_getBookContentList (aBook);
#line 73 "../src/contentHandler.vala"
			_tmp24_ = _tmp23_;
#line 73 "../src/contentHandler.vala"
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, contentLocation);
#line 73 "../src/contentHandler.vala"
			_tmp26_ = (gchar*) _tmp25_;
#line 73 "../src/contentHandler.vala"
			_tmp27_ = bookworm_app_utils_decodeHTMLChars (_tmp26_);
#line 73 "../src/contentHandler.vala"
			_tmp28_ = _tmp27_;
#line 73 "../src/contentHandler.vala"
			_g_free0 (_tmp26_);
#line 73 "../src/contentHandler.vala"
			_g_object_unref0 (_tmp24_);
#line 73 "../src/contentHandler.vala"
			bookLocationToRead = _tmp28_;
#line 75 "../src/contentHandler.vala"
			_tmp29_ = contents;
#line 75 "../src/contentHandler.vala"
			_tmp30_ = bookLocationToRead;
#line 75 "../src/contentHandler.vala"
			_tmp31_ = bookworm_app_utils_fileOperations ("READ_FILE", _tmp30_, "", "");
#line 75 "../src/contentHandler.vala"
			_tmp32_ = _tmp31_;
#line 75 "../src/contentHandler.vala"
			g_string_assign (_tmp29_, _tmp32_);
#line 75 "../src/contentHandler.vala"
			_g_free0 (_tmp32_);
#line 758 "contentHandler.c"
			{
				const gchar** tagname_collection = NULL;
				gint tagname_collection_length1 = 0;
				gint _tagname_collection_size_ = 0;
				gint tagname_it = 0;
#line 77 "../src/contentHandler.vala"
				tagname_collection = BOOKWORM_APP_CONSTANTS_TAG_NAME_WITH_PATHS;
#line 77 "../src/contentHandler.vala"
				tagname_collection_length1 = G_N_ELEMENTS (BOOKWORM_APP_CONSTANTS_TAG_NAME_WITH_PATHS);
#line 77 "../src/contentHandler.vala"
				for (tagname_it = 0; tagname_it < tagname_collection_length1; tagname_it = tagname_it + 1) {
#line 770 "contentHandler.c"
					gchar* _tmp33_;
					gchar* tagname = NULL;
#line 77 "../src/contentHandler.vala"
					_tmp33_ = g_strdup (tagname_collection[tagname_it]);
#line 77 "../src/contentHandler.vala"
					tagname = _tmp33_;
#line 777 "contentHandler.c"
					{
						gchar** srcList = NULL;
						GString* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						gint _tmp37_ = 0;
						gchar** _tmp38_;
						gint srcList_length1;
						gint _srcList_size_;
						GString* srcItemFullPath = NULL;
						GString* _tmp39_;
						gchar** _tmp40_;
						gint _tmp40__length1;
#line 78 "../src/contentHandler.vala"
						_tmp34_ = contents;
#line 78 "../src/contentHandler.vala"
						_tmp35_ = _tmp34_->str;
#line 78 "../src/contentHandler.vala"
						_tmp36_ = tagname;
#line 78 "../src/contentHandler.vala"
						_tmp38_ = bookworm_app_utils_multiExtractBetweenTwoStrings (_tmp35_, _tmp36_, "\"", &_tmp37_);
#line 78 "../src/contentHandler.vala"
						srcList = _tmp38_;
#line 78 "../src/contentHandler.vala"
						srcList_length1 = _tmp37_;
#line 78 "../src/contentHandler.vala"
						_srcList_size_ = srcList_length1;
#line 79 "../src/contentHandler.vala"
						_tmp39_ = g_string_new ("");
#line 79 "../src/contentHandler.vala"
						srcItemFullPath = _tmp39_;
#line 80 "../src/contentHandler.vala"
						_tmp40_ = srcList;
#line 80 "../src/contentHandler.vala"
						_tmp40__length1 = srcList_length1;
#line 813 "contentHandler.c"
						{
							gchar** srcItem_collection = NULL;
							gint srcItem_collection_length1 = 0;
							gint _srcItem_collection_size_ = 0;
							gint srcItem_it = 0;
#line 80 "../src/contentHandler.vala"
							srcItem_collection = _tmp40_;
#line 80 "../src/contentHandler.vala"
							srcItem_collection_length1 = _tmp40__length1;
#line 80 "../src/contentHandler.vala"
							for (srcItem_it = 0; srcItem_it < srcItem_collection_length1; srcItem_it = srcItem_it + 1) {
#line 825 "contentHandler.c"
								gchar* _tmp41_;
								gchar* srcItem = NULL;
#line 80 "../src/contentHandler.vala"
								_tmp41_ = g_strdup (srcItem_collection[srcItem_it]);
#line 80 "../src/contentHandler.vala"
								srcItem = _tmp41_;
#line 832 "contentHandler.c"
								{
									GString* _tmp42_;
									gchar* _tmp43_;
									gchar* _tmp44_;
									const gchar* _tmp45_;
									gchar* _tmp46_;
									gchar* _tmp47_;
									GString* _tmp48_;
									GString* _tmp49_;
									const gchar* _tmp50_;
									const gchar* _tmp51_;
									const gchar* _tmp52_;
									gchar* _tmp53_;
									gchar* _tmp54_;
									gchar* _tmp55_;
									gchar* _tmp56_;
									const gchar* _tmp57_;
									GString* _tmp58_;
									const gchar* _tmp59_;
									gchar* _tmp60_;
									gchar* _tmp61_;
									gchar* _tmp62_;
									gchar* _tmp63_;
									gchar* _tmp64_;
									gchar* _tmp65_;
									gchar* _tmp66_;
									gchar* _tmp67_;
#line 81 "../src/contentHandler.vala"
									_tmp42_ = srcItemFullPath;
#line 81 "../src/contentHandler.vala"
									_tmp43_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 81 "../src/contentHandler.vala"
									_tmp44_ = _tmp43_;
#line 81 "../src/contentHandler.vala"
									_tmp45_ = srcItem;
#line 81 "../src/contentHandler.vala"
									_tmp46_ = bookworm_app_utils_getFullPathFromFilename (_tmp44_, _tmp45_);
#line 81 "../src/contentHandler.vala"
									_tmp47_ = _tmp46_;
#line 81 "../src/contentHandler.vala"
									g_string_assign (_tmp42_, _tmp47_);
#line 81 "../src/contentHandler.vala"
									_g_free0 (_tmp47_);
#line 81 "../src/contentHandler.vala"
									_g_free0 (_tmp44_);
#line 84 "../src/contentHandler.vala"
									_tmp48_ = contents;
#line 84 "../src/contentHandler.vala"
									_tmp49_ = contents;
#line 84 "../src/contentHandler.vala"
									_tmp50_ = _tmp49_->str;
#line 84 "../src/contentHandler.vala"
									_tmp51_ = tagname;
#line 84 "../src/contentHandler.vala"
									_tmp52_ = srcItem;
#line 84 "../src/contentHandler.vala"
									_tmp53_ = g_strconcat (_tmp51_, _tmp52_, NULL);
#line 84 "../src/contentHandler.vala"
									_tmp54_ = _tmp53_;
#line 84 "../src/contentHandler.vala"
									_tmp55_ = g_strconcat (_tmp54_, "\"", NULL);
#line 84 "../src/contentHandler.vala"
									_tmp56_ = _tmp55_;
#line 84 "../src/contentHandler.vala"
									_tmp57_ = tagname;
#line 84 "../src/contentHandler.vala"
									_tmp58_ = srcItemFullPath;
#line 84 "../src/contentHandler.vala"
									_tmp59_ = _tmp58_->str;
#line 84 "../src/contentHandler.vala"
									_tmp60_ = g_strconcat (_tmp57_, _tmp59_, NULL);
#line 84 "../src/contentHandler.vala"
									_tmp61_ = _tmp60_;
#line 84 "../src/contentHandler.vala"
									_tmp62_ = bookworm_app_utils_encodeHTMLChars (_tmp61_);
#line 84 "../src/contentHandler.vala"
									_tmp63_ = _tmp62_;
#line 84 "../src/contentHandler.vala"
									_tmp64_ = g_strconcat (_tmp63_, "\"", NULL);
#line 84 "../src/contentHandler.vala"
									_tmp65_ = _tmp64_;
#line 84 "../src/contentHandler.vala"
									_tmp66_ = string_replace (_tmp50_, _tmp56_, _tmp65_);
#line 84 "../src/contentHandler.vala"
									_tmp67_ = _tmp66_;
#line 84 "../src/contentHandler.vala"
									g_string_assign (_tmp48_, _tmp67_);
#line 84 "../src/contentHandler.vala"
									_g_free0 (_tmp67_);
#line 84 "../src/contentHandler.vala"
									_g_free0 (_tmp65_);
#line 84 "../src/contentHandler.vala"
									_g_free0 (_tmp63_);
#line 84 "../src/contentHandler.vala"
									_g_free0 (_tmp61_);
#line 84 "../src/contentHandler.vala"
									_g_free0 (_tmp56_);
#line 84 "../src/contentHandler.vala"
									_g_free0 (_tmp54_);
#line 80 "../src/contentHandler.vala"
									_g_free0 (srcItem);
#line 934 "contentHandler.c"
								}
							}
						}
#line 77 "../src/contentHandler.vala"
						_g_string_free0 (srcItemFullPath);
#line 77 "../src/contentHandler.vala"
						srcList = (_vala_array_free (srcList, srcList_length1, (GDestroyNotify) g_free), NULL);
#line 77 "../src/contentHandler.vala"
						_g_free0 (tagname);
#line 944 "contentHandler.c"
					}
				}
			}
#line 91 "../src/contentHandler.vala"
			_tmp68_ = contents;
#line 91 "../src/contentHandler.vala"
			_tmp69_ = contents;
#line 91 "../src/contentHandler.vala"
			_tmp70_ = _tmp69_->str;
#line 91 "../src/contentHandler.vala"
			_tmp71_ = g_strdup (_tmp70_);
#line 91 "../src/contentHandler.vala"
			_tmp72_ = bookworm_app_content_handler_adjustPageContent (aBook, _tmp71_, mode);
#line 91 "../src/contentHandler.vala"
			_tmp73_ = _tmp72_;
#line 91 "../src/contentHandler.vala"
			g_string_assign (_tmp68_, _tmp73_);
#line 91 "../src/contentHandler.vala"
			_g_free0 (_tmp73_);
#line 71 "../src/contentHandler.vala"
			_g_free0 (bookLocationToRead);
#line 966 "contentHandler.c"
		} else {
			gboolean _tmp74_ = FALSE;
#line 93 "../src/contentHandler.vala"
			if (contentLocation == -1) {
#line 971 "contentHandler.c"
				GeeArrayList* _tmp75_;
				GeeArrayList* _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
#line 93 "../src/contentHandler.vala"
				_tmp75_ = bookworm_app_book_getBookContentList (aBook);
#line 93 "../src/contentHandler.vala"
				_tmp76_ = _tmp75_;
#line 93 "../src/contentHandler.vala"
				_tmp77_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp76_);
#line 93 "../src/contentHandler.vala"
				_tmp78_ = _tmp77_;
#line 93 "../src/contentHandler.vala"
				_tmp74_ = _tmp78_ > 0;
#line 93 "../src/contentHandler.vala"
				_g_object_unref0 (_tmp76_);
#line 988 "contentHandler.c"
			} else {
#line 93 "../src/contentHandler.vala"
				_tmp74_ = FALSE;
#line 992 "contentHandler.c"
			}
#line 93 "../src/contentHandler.vala"
			if (_tmp74_) {
#line 996 "contentHandler.c"
				BookwormAppBook* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
#line 94 "../src/contentHandler.vala"
				_tmp79_ = _bookworm_app_book_ref0 (aBook);
#line 94 "../src/contentHandler.vala"
				_tmp80_ = bookworm_app_content_handler_provideContent (_tmp79_, 0, mode);
#line 94 "../src/contentHandler.vala"
				_tmp81_ = _tmp80_;
#line 94 "../src/contentHandler.vala"
				_g_free0 (_tmp81_);
#line 1008 "contentHandler.c"
			} else {
#line 97 "../src/contentHandler.vala"
				bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_NAVIGATION_ISSUE);
#line 98 "../src/contentHandler.vala"
				bookworm_app_app_window_showInfoBar (aBook, GTK_MESSAGE_WARNING);
#line 1014 "contentHandler.c"
			}
		}
	} else {
#line 102 "../src/contentHandler.vala"
		bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_NOT_FOUND_ISSUE);
#line 103 "../src/contentHandler.vala"
		bookworm_app_app_window_showInfoBar (aBook, GTK_MESSAGE_WARNING);
#line 1022 "contentHandler.c"
	}
#line 105 "../src/contentHandler.vala"
	_tmp82_ = contents;
#line 105 "../src/contentHandler.vala"
	_tmp83_ = _tmp82_->str;
#line 105 "../src/contentHandler.vala"
	_tmp84_ = strlen (_tmp83_);
#line 105 "../src/contentHandler.vala"
	_tmp85_ = _tmp84_;
#line 105 "../src/contentHandler.vala"
	_tmp86_ = g_strdup_printf ("%i", _tmp85_);
#line 105 "../src/contentHandler.vala"
	_tmp87_ = _tmp86_;
#line 105 "../src/contentHandler.vala"
	_tmp88_ = g_strconcat ("[END] [FUNCTION:provideContent] contents.length=", _tmp87_, NULL);
#line 105 "../src/contentHandler.vala"
	_tmp89_ = _tmp88_;
#line 105 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:105: %s", _tmp89_);
#line 105 "../src/contentHandler.vala"
	_g_free0 (_tmp89_);
#line 105 "../src/contentHandler.vala"
	_g_free0 (_tmp87_);
#line 106 "../src/contentHandler.vala"
	_tmp90_ = contents;
#line 106 "../src/contentHandler.vala"
	_tmp91_ = _tmp90_->str;
#line 106 "../src/contentHandler.vala"
	_tmp92_ = g_strdup (_tmp91_);
#line 106 "../src/contentHandler.vala"
	result = _tmp92_;
#line 106 "../src/contentHandler.vala"
	_g_string_free0 (contents);
#line 106 "../src/contentHandler.vala"
	_bookworm_app_book_unref0 (aBook);
#line 106 "../src/contentHandler.vala"
	return result;
#line 1060 "contentHandler.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1084 "contentHandler.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1092 "contentHandler.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1098 "contentHandler.c"
	}
}

void
bookworm_app_content_handler_handleBookMark (const gchar* action)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	BookwormAppBook* aBook = NULL;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
#line 113 "../src/contentHandler.vala"
	static GQuark _tmp6_label0 = 0;
#line 113 "../src/contentHandler.vala"
	static GQuark _tmp6_label1 = 0;
#line 113 "../src/contentHandler.vala"
	static GQuark _tmp6_label2 = 0;
#line 1119 "contentHandler.c"
	BookwormAppBook* _tmp32_;
#line 109 "../src/contentHandler.vala"
	g_return_if_fail (action != NULL);
#line 110 "../src/contentHandler.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:handleBookMark] action=", action, NULL);
#line 110 "../src/contentHandler.vala"
	_tmp1_ = _tmp0_;
#line 110 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:110: %s", _tmp1_);
#line 110 "../src/contentHandler.vala"
	_g_free0 (_tmp1_);
#line 112 "../src/contentHandler.vala"
	_tmp2_ = bookworm_app_bookworm_libraryViewMap;
#line 112 "../src/contentHandler.vala"
	_tmp3_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 112 "../src/contentHandler.vala"
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 112 "../src/contentHandler.vala"
	aBook = (BookwormAppBook*) _tmp4_;
#line 113 "../src/contentHandler.vala"
	_tmp5_ = action;
#line 113 "../src/contentHandler.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 113 "../src/contentHandler.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("DISPLAY")))) {
#line 113 "../src/contentHandler.vala"
		switch (0) {
#line 1147 "contentHandler.c"
			default:
			{
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				BookwormAppBook* _tmp10_;
#line 115 "../src/contentHandler.vala"
				_tmp10_ = aBook;
#line 115 "../src/contentHandler.vala"
				if (_tmp10_ != NULL) {
#line 1157 "contentHandler.c"
					BookwormAppBook* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
#line 115 "../src/contentHandler.vala"
					_tmp11_ = aBook;
#line 115 "../src/contentHandler.vala"
					_tmp12_ = bookworm_app_book_getBookmark (_tmp11_);
#line 115 "../src/contentHandler.vala"
					_tmp13_ = _tmp12_;
#line 115 "../src/contentHandler.vala"
					_tmp9_ = _tmp13_ != NULL;
#line 115 "../src/contentHandler.vala"
					_g_free0 (_tmp13_);
#line 1171 "contentHandler.c"
				} else {
#line 115 "../src/contentHandler.vala"
					_tmp9_ = FALSE;
#line 1175 "contentHandler.c"
				}
#line 115 "../src/contentHandler.vala"
				if (_tmp9_) {
#line 1179 "contentHandler.c"
					BookwormAppBook* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					BookwormAppBook* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
#line 115 "../src/contentHandler.vala"
					_tmp14_ = aBook;
#line 115 "../src/contentHandler.vala"
					_tmp15_ = bookworm_app_book_getBookmark (_tmp14_);
#line 115 "../src/contentHandler.vala"
					_tmp16_ = _tmp15_;
#line 115 "../src/contentHandler.vala"
					_tmp17_ = aBook;
#line 115 "../src/contentHandler.vala"
					_tmp18_ = g_strdup_printf ("%i", bookworm_app_book_getBookPageNumber (_tmp17_));
#line 115 "../src/contentHandler.vala"
					_tmp19_ = _tmp18_;
#line 115 "../src/contentHandler.vala"
					_tmp8_ = string_index_of (_tmp16_, _tmp19_, 0) != -1;
#line 115 "../src/contentHandler.vala"
					_g_free0 (_tmp19_);
#line 115 "../src/contentHandler.vala"
					_g_free0 (_tmp16_);
#line 1204 "contentHandler.c"
				} else {
#line 115 "../src/contentHandler.vala"
					_tmp8_ = FALSE;
#line 1208 "contentHandler.c"
				}
#line 115 "../src/contentHandler.vala"
				if (_tmp8_) {
#line 1212 "contentHandler.c"
					GtkButton* _tmp20_;
					GtkButton* _tmp21_;
#line 117 "../src/contentHandler.vala"
					_tmp20_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 117 "../src/contentHandler.vala"
					gtk_widget_set_visible ((GtkWidget*) _tmp20_, TRUE);
#line 118 "../src/contentHandler.vala"
					_tmp21_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 118 "../src/contentHandler.vala"
					gtk_widget_set_visible ((GtkWidget*) _tmp21_, FALSE);
#line 1223 "contentHandler.c"
				} else {
					GtkButton* _tmp22_;
					GtkButton* _tmp23_;
#line 121 "../src/contentHandler.vala"
					_tmp22_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 121 "../src/contentHandler.vala"
					gtk_widget_set_visible ((GtkWidget*) _tmp22_, FALSE);
#line 122 "../src/contentHandler.vala"
					_tmp23_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 122 "../src/contentHandler.vala"
					gtk_widget_set_visible ((GtkWidget*) _tmp23_, TRUE);
#line 1235 "contentHandler.c"
				}
#line 124 "../src/contentHandler.vala"
				break;
#line 1239 "contentHandler.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("ACTIVE_CLICKED")))) {
#line 113 "../src/contentHandler.vala"
		switch (0) {
#line 1245 "contentHandler.c"
			default:
			{
				GtkButton* _tmp24_;
				GtkButton* _tmp25_;
				BookwormAppBook* _tmp26_;
				BookwormAppBook* _tmp27_;
#line 126 "../src/contentHandler.vala"
				_tmp24_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 126 "../src/contentHandler.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp24_, FALSE);
#line 127 "../src/contentHandler.vala"
				_tmp25_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 127 "../src/contentHandler.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp25_, TRUE);
#line 129 "../src/contentHandler.vala"
				_tmp26_ = aBook;
#line 129 "../src/contentHandler.vala"
				_tmp27_ = aBook;
#line 129 "../src/contentHandler.vala"
				bookworm_app_book_setBookmark (_tmp26_, bookworm_app_book_getBookPageNumber (_tmp27_), action);
#line 130 "../src/contentHandler.vala"
				break;
#line 1268 "contentHandler.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("INACTIVE_CLICKED")))) {
#line 113 "../src/contentHandler.vala"
		switch (0) {
#line 1274 "contentHandler.c"
			default:
			{
				GtkButton* _tmp28_;
				GtkButton* _tmp29_;
				BookwormAppBook* _tmp30_;
				BookwormAppBook* _tmp31_;
#line 132 "../src/contentHandler.vala"
				_tmp28_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 132 "../src/contentHandler.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp28_, TRUE);
#line 133 "../src/contentHandler.vala"
				_tmp29_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 133 "../src/contentHandler.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp29_, FALSE);
#line 135 "../src/contentHandler.vala"
				_tmp30_ = aBook;
#line 135 "../src/contentHandler.vala"
				_tmp31_ = aBook;
#line 135 "../src/contentHandler.vala"
				bookworm_app_book_setBookmark (_tmp30_, bookworm_app_book_getBookPageNumber (_tmp31_), action);
#line 136 "../src/contentHandler.vala"
				break;
#line 1297 "contentHandler.c"
			}
		}
	} else {
#line 113 "../src/contentHandler.vala"
		switch (0) {
#line 1303 "contentHandler.c"
			default:
			{
#line 138 "../src/contentHandler.vala"
				break;
#line 1308 "contentHandler.c"
			}
		}
	}
#line 141 "../src/contentHandler.vala"
	_tmp32_ = aBook;
#line 141 "../src/contentHandler.vala"
	if (_tmp32_ != NULL) {
#line 1316 "contentHandler.c"
		GeeHashMap* _tmp33_;
		const gchar* _tmp34_;
		BookwormAppBook* _tmp35_;
#line 142 "../src/contentHandler.vala"
		g_debug ("contentHandler.vala:142: updating libraryViewMap with bookmark info...");
#line 143 "../src/contentHandler.vala"
		_tmp33_ = bookworm_app_bookworm_libraryViewMap;
#line 143 "../src/contentHandler.vala"
		_tmp34_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 143 "../src/contentHandler.vala"
		_tmp35_ = aBook;
#line 143 "../src/contentHandler.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, _tmp34_, _tmp35_);
#line 1330 "contentHandler.c"
	}
#line 145 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:145: [END] [FUNCTION:handleBookMark]");
#line 109 "../src/contentHandler.vala"
	_bookworm_app_book_unref0 (aBook);
#line 1336 "contentHandler.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1355 "contentHandler.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1382 "contentHandler.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1388 "contentHandler.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1394 "contentHandler.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1398 "contentHandler.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1406 "contentHandler.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1410 "contentHandler.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1422 "contentHandler.c"
}

gchar*
bookworm_app_content_handler_adjustPageContent (BookwormAppBook* aBook,
                                                gchar* pageContentStr,
                                                const gchar* mode)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	GString* pageContent = NULL;
	GString* _tmp30_;
	BookwormAppSettings* _tmp31_;
	gchar* cssForTextAndBackgroundColor = NULL;
	gchar* _tmp32_;
	GString* _tmp33_;
	gchar* currentBookwormScripts = NULL;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GString* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gboolean _tmp39_ = FALSE;
	const gchar* _tmp43_;
	BookwormAppSettings* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp126_;
	BookwormAppSettings* _tmp127_;
	const gchar* _tmp128_;
	const gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	BookwormAppSettings* _tmp132_;
	const gchar* _tmp133_;
	const gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	gchar* _tmp138_;
	BookwormAppSettings* _tmp139_;
	const gchar* _tmp140_;
	const gchar* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	BookwormAppSettings* _tmp144_;
	gint _tmp145_;
	gint _tmp146_;
	gchar* _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	gchar* _tmp150_;
	BookwormAppSettings* _tmp151_;
	const gchar* _tmp152_;
	const gchar* _tmp153_;
	gchar* _tmp154_;
	gchar* _tmp155_;
	const gchar* _tmp156_;
	gchar* _tmp157_;
	BookwormAppSettings* _tmp181_;
	gboolean _tmp182_;
	gboolean _tmp183_;
	GString* _tmp269_;
	GString* _tmp270_;
	const gchar* _tmp271_;
	GString* _tmp314_;
	const gchar* _tmp315_;
	gint _tmp316_;
	gint _tmp317_;
	gchar* _tmp318_;
	gchar* _tmp319_;
	gchar* _tmp320_;
	gchar* _tmp321_;
	GString* _tmp322_;
	const gchar* _tmp323_;
	gchar* _tmp324_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 148 "../src/contentHandler.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 148 "../src/contentHandler.vala"
	g_return_val_if_fail (pageContentStr != NULL, NULL);
#line 148 "../src/contentHandler.vala"
	g_return_val_if_fail (mode != NULL, NULL);
#line 149 "../src/contentHandler.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 149 "../src/contentHandler.vala"
	_tmp1_ = _tmp0_;
#line 149 "../src/contentHandler.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:adjustPageContent] book.location=", _tmp1_, NULL);
#line 149 "../src/contentHandler.vala"
	_tmp3_ = _tmp2_;
#line 149 "../src/contentHandler.vala"
	_tmp4_ = g_strconcat (_tmp3_, ", pageContentStr.length=", NULL);
#line 149 "../src/contentHandler.vala"
	_tmp5_ = _tmp4_;
#line 149 "../src/contentHandler.vala"
	_tmp6_ = strlen (pageContentStr);
#line 149 "../src/contentHandler.vala"
	_tmp7_ = _tmp6_;
#line 149 "../src/contentHandler.vala"
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
#line 149 "../src/contentHandler.vala"
	_tmp9_ = _tmp8_;
#line 149 "../src/contentHandler.vala"
	_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
#line 149 "../src/contentHandler.vala"
	_tmp11_ = _tmp10_;
#line 149 "../src/contentHandler.vala"
	_tmp12_ = g_strconcat (_tmp11_, ", mode=", NULL);
#line 149 "../src/contentHandler.vala"
	_tmp13_ = _tmp12_;
#line 149 "../src/contentHandler.vala"
	_tmp14_ = g_strconcat (_tmp13_, mode, NULL);
#line 149 "../src/contentHandler.vala"
	_tmp15_ = _tmp14_;
#line 149 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:149: %s", _tmp15_);
#line 149 "../src/contentHandler.vala"
	_g_free0 (_tmp15_);
#line 149 "../src/contentHandler.vala"
	_g_free0 (_tmp13_);
#line 149 "../src/contentHandler.vala"
	_g_free0 (_tmp11_);
#line 149 "../src/contentHandler.vala"
	_g_free0 (_tmp9_);
#line 149 "../src/contentHandler.vala"
	_g_free0 (_tmp5_);
#line 149 "../src/contentHandler.vala"
	_g_free0 (_tmp3_);
#line 149 "../src/contentHandler.vala"
	_g_free0 (_tmp1_);
#line 152 "../src/contentHandler.vala"
	_tmp17_ = bookworm_app_bookworm_bookwormScripts;
#line 152 "../src/contentHandler.vala"
	if (_tmp17_ == NULL) {
#line 152 "../src/contentHandler.vala"
		_tmp16_ = TRUE;
#line 1576 "contentHandler.c"
	} else {
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
#line 152 "../src/contentHandler.vala"
		_tmp18_ = bookworm_app_bookworm_bookwormScripts;
#line 152 "../src/contentHandler.vala"
		_tmp19_ = strlen (_tmp18_);
#line 152 "../src/contentHandler.vala"
		_tmp20_ = _tmp19_;
#line 152 "../src/contentHandler.vala"
		_tmp16_ = _tmp20_ < 1;
#line 1589 "contentHandler.c"
	}
#line 152 "../src/contentHandler.vala"
	if (_tmp16_) {
#line 1593 "contentHandler.c"
		guint8* bookwormScriptsData = NULL;
		gint bookwormScriptsData_length1 = 0;
		gint _bookwormScriptsData_size_ = 0;
		GFile* _tmp21_;
		GFile* _tmp22_;
		guint8* _tmp23_ = NULL;
		gsize _tmp24_ = 0;
		guint8* _tmp25_;
		gint _tmp25__length1;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
#line 154 "../src/contentHandler.vala"
		_tmp21_ = g_file_new_for_uri (BOOKWORM_APP_CONSTANTS_HTML_SCRIPT_RESOURCE_LOCATION);
#line 154 "../src/contentHandler.vala"
		_tmp22_ = _tmp21_;
#line 154 "../src/contentHandler.vala"
		g_file_load_contents (_tmp22_, NULL, &_tmp23_, &_tmp24_, NULL, &_inner_error0_);
#line 154 "../src/contentHandler.vala"
		bookwormScriptsData = (g_free (bookwormScriptsData), NULL);
#line 154 "../src/contentHandler.vala"
		bookwormScriptsData = _tmp23_;
#line 154 "../src/contentHandler.vala"
		bookwormScriptsData_length1 = _tmp24_;
#line 154 "../src/contentHandler.vala"
		_bookwormScriptsData_size_ = bookwormScriptsData_length1;
#line 154 "../src/contentHandler.vala"
		_g_object_unref0 (_tmp22_);
#line 154 "../src/contentHandler.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 154 "../src/contentHandler.vala"
			bookwormScriptsData = (g_free (bookwormScriptsData), NULL);
#line 154 "../src/contentHandler.vala"
			_g_free0 (pageContentStr);
#line 154 "../src/contentHandler.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 154 "../src/contentHandler.vala"
			g_clear_error (&_inner_error0_);
#line 154 "../src/contentHandler.vala"
			return NULL;
#line 1635 "contentHandler.c"
		}
#line 156 "../src/contentHandler.vala"
		_tmp25_ = bookwormScriptsData;
#line 156 "../src/contentHandler.vala"
		_tmp25__length1 = bookwormScriptsData_length1;
#line 156 "../src/contentHandler.vala"
		_tmp26_ = g_strdup ((const gchar*) _tmp25_);
#line 156 "../src/contentHandler.vala"
		_g_free0 (bookworm_app_bookworm_bookwormScripts);
#line 156 "../src/contentHandler.vala"
		bookworm_app_bookworm_bookwormScripts = _tmp26_;
#line 157 "../src/contentHandler.vala"
		_tmp27_ = bookworm_app_bookworm_bookwormScripts;
#line 157 "../src/contentHandler.vala"
		_tmp28_ = g_strconcat ("Loaded javascript data from resource:\n", _tmp27_, NULL);
#line 157 "../src/contentHandler.vala"
		_tmp29_ = _tmp28_;
#line 157 "../src/contentHandler.vala"
		g_debug ("contentHandler.vala:157: %s", _tmp29_);
#line 157 "../src/contentHandler.vala"
		_g_free0 (_tmp29_);
#line 152 "../src/contentHandler.vala"
		bookwormScriptsData = (g_free (bookwormScriptsData), NULL);
#line 1659 "contentHandler.c"
	}
#line 159 "../src/contentHandler.vala"
	_tmp30_ = g_string_new (pageContentStr);
#line 159 "../src/contentHandler.vala"
	pageContent = _tmp30_;
#line 160 "../src/contentHandler.vala"
	_tmp31_ = bookworm_app_settings_get_instance ();
#line 160 "../src/contentHandler.vala"
	_g_object_unref0 (bookworm_app_content_handler_settings);
#line 160 "../src/contentHandler.vala"
	bookworm_app_content_handler_settings = _tmp31_;
#line 161 "../src/contentHandler.vala"
	_tmp32_ = g_strdup ("");
#line 161 "../src/contentHandler.vala"
	cssForTextAndBackgroundColor = _tmp32_;
#line 162 "../src/contentHandler.vala"
	_tmp33_ = bookworm_app_bookworm_onLoadJavaScript;
#line 162 "../src/contentHandler.vala"
	g_string_assign (_tmp33_, "onload=\"");
#line 163 "../src/contentHandler.vala"
	_tmp34_ = bookworm_app_bookworm_bookwormScripts;
#line 163 "../src/contentHandler.vala"
	_tmp35_ = g_strdup (_tmp34_);
#line 163 "../src/contentHandler.vala"
	currentBookwormScripts = _tmp35_;
#line 166 "../src/contentHandler.vala"
	_tmp36_ = pageContent;
#line 166 "../src/contentHandler.vala"
	_tmp37_ = string_replace (pageContentStr, "<title/>", "");
#line 166 "../src/contentHandler.vala"
	_tmp38_ = _tmp37_;
#line 166 "../src/contentHandler.vala"
	g_string_assign (_tmp36_, _tmp38_);
#line 166 "../src/contentHandler.vala"
	_g_free0 (_tmp38_);
#line 169 "../src/contentHandler.vala"
	if (bookworm_app_book_getBookPageNumber (aBook) < 2) {
#line 1697 "contentHandler.c"
		gboolean _tmp40_ = FALSE;
#line 170 "../src/contentHandler.vala"
		if (string_contains (pageContentStr, "<image")) {
#line 170 "../src/contentHandler.vala"
			_tmp40_ = TRUE;
#line 1703 "contentHandler.c"
		} else {
#line 170 "../src/contentHandler.vala"
			_tmp40_ = string_contains (pageContentStr, "<img");
#line 1707 "contentHandler.c"
		}
#line 170 "../src/contentHandler.vala"
		_tmp39_ = _tmp40_;
#line 1711 "contentHandler.c"
	} else {
#line 169 "../src/contentHandler.vala"
		_tmp39_ = FALSE;
#line 1715 "contentHandler.c"
	}
#line 169 "../src/contentHandler.vala"
	if (_tmp39_) {
#line 1719 "contentHandler.c"
		const gchar* _tmp41_;
		gchar* _tmp42_;
#line 172 "../src/contentHandler.vala"
		_tmp41_ = currentBookwormScripts;
#line 172 "../src/contentHandler.vala"
		_tmp42_ = string_replace (_tmp41_, "$TITLE_PAGE_IMAGE", "img, image");
#line 172 "../src/contentHandler.vala"
		_g_free0 (currentBookwormScripts);
#line 172 "../src/contentHandler.vala"
		currentBookwormScripts = _tmp42_;
#line 1730 "contentHandler.c"
	}
#line 175 "../src/contentHandler.vala"
	_tmp43_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[4];
#line 175 "../src/contentHandler.vala"
	_tmp44_ = bookworm_app_bookworm_settings;
#line 175 "../src/contentHandler.vala"
	_tmp45_ = bookworm_app_settings_get_reading_profile (_tmp44_);
#line 175 "../src/contentHandler.vala"
	_tmp46_ = _tmp45_;
#line 175 "../src/contentHandler.vala"
	if (g_strcmp0 (_tmp43_, _tmp46_) == 0) {
#line 1742 "contentHandler.c"
		gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
#line 177 "../src/contentHandler.vala"
		_tmp47_ = g_strdup (" background-color: #002b36" " !important; color: #93a1a1" " !important;");
#line 177 "../src/contentHandler.vala"
		_g_free0 (cssForTextAndBackgroundColor);
#line 177 "../src/contentHandler.vala"
		cssForTextAndBackgroundColor = _tmp47_;
#line 180 "../src/contentHandler.vala"
		_tmp48_ = currentBookwormScripts;
#line 180 "../src/contentHandler.vala"
		_tmp49_ = string_replace (_tmp48_, "$SCROLLBAR_BACKGROUND", "#002b36");
#line 180 "../src/contentHandler.vala"
		_tmp50_ = _tmp49_;
#line 180 "../src/contentHandler.vala"
		_tmp51_ = string_replace (_tmp50_, "$HIGHLIGHT_COLOR", "#3465A4");
#line 180 "../src/contentHandler.vala"
		_g_free0 (currentBookwormScripts);
#line 180 "../src/contentHandler.vala"
		currentBookwormScripts = _tmp51_;
#line 180 "../src/contentHandler.vala"
		_g_free0 (_tmp50_);
#line 1768 "contentHandler.c"
	} else {
		const gchar* _tmp52_;
		BookwormAppSettings* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
#line 183 "../src/contentHandler.vala"
		_tmp52_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[3];
#line 183 "../src/contentHandler.vala"
		_tmp53_ = bookworm_app_bookworm_settings;
#line 183 "../src/contentHandler.vala"
		_tmp54_ = bookworm_app_settings_get_reading_profile (_tmp53_);
#line 183 "../src/contentHandler.vala"
		_tmp55_ = _tmp54_;
#line 183 "../src/contentHandler.vala"
		if (g_strcmp0 (_tmp52_, _tmp55_) == 0) {
#line 1784 "contentHandler.c"
			gchar* _tmp56_;
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
#line 185 "../src/contentHandler.vala"
			_tmp56_ = g_strdup (" background-color: #fbfbfb" " !important; color: #000000" " !important;");
#line 185 "../src/contentHandler.vala"
			_g_free0 (cssForTextAndBackgroundColor);
#line 185 "../src/contentHandler.vala"
			cssForTextAndBackgroundColor = _tmp56_;
#line 188 "../src/contentHandler.vala"
			_tmp57_ = currentBookwormScripts;
#line 188 "../src/contentHandler.vala"
			_tmp58_ = string_replace (_tmp57_, "$SCROLLBAR_BACKGROUND", "#fbfbfb");
#line 188 "../src/contentHandler.vala"
			_tmp59_ = _tmp58_;
#line 188 "../src/contentHandler.vala"
			_tmp60_ = string_replace (_tmp59_, "$HIGHLIGHT_COLOR", "#E8ED00");
#line 188 "../src/contentHandler.vala"
			_g_free0 (currentBookwormScripts);
#line 188 "../src/contentHandler.vala"
			currentBookwormScripts = _tmp60_;
#line 188 "../src/contentHandler.vala"
			_g_free0 (_tmp59_);
#line 1810 "contentHandler.c"
		} else {
			const gchar* _tmp61_;
			BookwormAppSettings* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
#line 191 "../src/contentHandler.vala"
			_tmp61_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[2];
#line 191 "../src/contentHandler.vala"
			_tmp62_ = bookworm_app_bookworm_settings;
#line 191 "../src/contentHandler.vala"
			_tmp63_ = bookworm_app_settings_get_reading_profile (_tmp62_);
#line 191 "../src/contentHandler.vala"
			_tmp64_ = _tmp63_;
#line 191 "../src/contentHandler.vala"
			if (g_strcmp0 (_tmp61_, _tmp64_) == 0) {
#line 1826 "contentHandler.c"
				gchar** _tmp65_;
				gint _tmp65__length1;
				const gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar** _tmp71_;
				gint _tmp71__length1;
				const gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				const gchar* _tmp76_;
				gchar** _tmp77_;
				gint _tmp77__length1;
				const gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar** _tmp81_;
				gint _tmp81__length1;
				const gchar* _tmp82_;
				gchar* _tmp83_;
#line 192 "../src/contentHandler.vala"
				_tmp65_ = bookworm_app_bookworm_profileColorList;
#line 192 "../src/contentHandler.vala"
				_tmp65__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 192 "../src/contentHandler.vala"
				_tmp66_ = _tmp65_[7];
#line 192 "../src/contentHandler.vala"
				_tmp67_ = g_strconcat (" background-color: ", _tmp66_, NULL);
#line 192 "../src/contentHandler.vala"
				_tmp68_ = _tmp67_;
#line 192 "../src/contentHandler.vala"
				_tmp69_ = g_strconcat (_tmp68_, " !important; color: ", NULL);
#line 192 "../src/contentHandler.vala"
				_tmp70_ = _tmp69_;
#line 192 "../src/contentHandler.vala"
				_tmp71_ = bookworm_app_bookworm_profileColorList;
#line 192 "../src/contentHandler.vala"
				_tmp71__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 192 "../src/contentHandler.vala"
				_tmp72_ = _tmp71_[6];
#line 192 "../src/contentHandler.vala"
				_tmp73_ = g_strconcat (_tmp70_, _tmp72_, NULL);
#line 192 "../src/contentHandler.vala"
				_tmp74_ = _tmp73_;
#line 192 "../src/contentHandler.vala"
				_tmp75_ = g_strconcat (_tmp74_, " !important;", NULL);
#line 192 "../src/contentHandler.vala"
				_g_free0 (cssForTextAndBackgroundColor);
#line 192 "../src/contentHandler.vala"
				cssForTextAndBackgroundColor = _tmp75_;
#line 192 "../src/contentHandler.vala"
				_g_free0 (_tmp74_);
#line 192 "../src/contentHandler.vala"
				_g_free0 (_tmp70_);
#line 192 "../src/contentHandler.vala"
				_g_free0 (_tmp68_);
#line 197 "../src/contentHandler.vala"
				_tmp76_ = currentBookwormScripts;
#line 197 "../src/contentHandler.vala"
				_tmp77_ = bookworm_app_bookworm_profileColorList;
#line 197 "../src/contentHandler.vala"
				_tmp77__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 197 "../src/contentHandler.vala"
				_tmp78_ = _tmp77_[7];
#line 197 "../src/contentHandler.vala"
				_tmp79_ = string_replace (_tmp76_, "$SCROLLBAR_BACKGROUND", _tmp78_);
#line 197 "../src/contentHandler.vala"
				_tmp80_ = _tmp79_;
#line 197 "../src/contentHandler.vala"
				_tmp81_ = bookworm_app_bookworm_profileColorList;
#line 197 "../src/contentHandler.vala"
				_tmp81__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 197 "../src/contentHandler.vala"
				_tmp82_ = _tmp81_[8];
#line 197 "../src/contentHandler.vala"
				_tmp83_ = string_replace (_tmp80_, "$HIGHLIGHT_COLOR", _tmp82_);
#line 197 "../src/contentHandler.vala"
				_g_free0 (currentBookwormScripts);
#line 197 "../src/contentHandler.vala"
				currentBookwormScripts = _tmp83_;
#line 197 "../src/contentHandler.vala"
				_g_free0 (_tmp80_);
#line 1912 "contentHandler.c"
			} else {
				const gchar* _tmp84_;
				BookwormAppSettings* _tmp85_;
				const gchar* _tmp86_;
				const gchar* _tmp87_;
#line 200 "../src/contentHandler.vala"
				_tmp84_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[1];
#line 200 "../src/contentHandler.vala"
				_tmp85_ = bookworm_app_bookworm_settings;
#line 200 "../src/contentHandler.vala"
				_tmp86_ = bookworm_app_settings_get_reading_profile (_tmp85_);
#line 200 "../src/contentHandler.vala"
				_tmp87_ = _tmp86_;
#line 200 "../src/contentHandler.vala"
				if (g_strcmp0 (_tmp84_, _tmp87_) == 0) {
#line 1928 "contentHandler.c"
					gchar** _tmp88_;
					gint _tmp88__length1;
					const gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					gchar** _tmp94_;
					gint _tmp94__length1;
					const gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					const gchar* _tmp99_;
					gchar** _tmp100_;
					gint _tmp100__length1;
					const gchar* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					gchar** _tmp104_;
					gint _tmp104__length1;
					const gchar* _tmp105_;
					gchar* _tmp106_;
#line 201 "../src/contentHandler.vala"
					_tmp88_ = bookworm_app_bookworm_profileColorList;
#line 201 "../src/contentHandler.vala"
					_tmp88__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 201 "../src/contentHandler.vala"
					_tmp89_ = _tmp88_[4];
#line 201 "../src/contentHandler.vala"
					_tmp90_ = g_strconcat (" background-color: ", _tmp89_, NULL);
#line 201 "../src/contentHandler.vala"
					_tmp91_ = _tmp90_;
#line 201 "../src/contentHandler.vala"
					_tmp92_ = g_strconcat (_tmp91_, " !important; color: ", NULL);
#line 201 "../src/contentHandler.vala"
					_tmp93_ = _tmp92_;
#line 201 "../src/contentHandler.vala"
					_tmp94_ = bookworm_app_bookworm_profileColorList;
#line 201 "../src/contentHandler.vala"
					_tmp94__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 201 "../src/contentHandler.vala"
					_tmp95_ = _tmp94_[3];
#line 201 "../src/contentHandler.vala"
					_tmp96_ = g_strconcat (_tmp93_, _tmp95_, NULL);
#line 201 "../src/contentHandler.vala"
					_tmp97_ = _tmp96_;
#line 201 "../src/contentHandler.vala"
					_tmp98_ = g_strconcat (_tmp97_, " !important;", NULL);
#line 201 "../src/contentHandler.vala"
					_g_free0 (cssForTextAndBackgroundColor);
#line 201 "../src/contentHandler.vala"
					cssForTextAndBackgroundColor = _tmp98_;
#line 201 "../src/contentHandler.vala"
					_g_free0 (_tmp97_);
#line 201 "../src/contentHandler.vala"
					_g_free0 (_tmp93_);
#line 201 "../src/contentHandler.vala"
					_g_free0 (_tmp91_);
#line 206 "../src/contentHandler.vala"
					_tmp99_ = currentBookwormScripts;
#line 206 "../src/contentHandler.vala"
					_tmp100_ = bookworm_app_bookworm_profileColorList;
#line 206 "../src/contentHandler.vala"
					_tmp100__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 206 "../src/contentHandler.vala"
					_tmp101_ = _tmp100_[4];
#line 206 "../src/contentHandler.vala"
					_tmp102_ = string_replace (_tmp99_, "$SCROLLBAR_BACKGROUND", _tmp101_);
#line 206 "../src/contentHandler.vala"
					_tmp103_ = _tmp102_;
#line 206 "../src/contentHandler.vala"
					_tmp104_ = bookworm_app_bookworm_profileColorList;
#line 206 "../src/contentHandler.vala"
					_tmp104__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 206 "../src/contentHandler.vala"
					_tmp105_ = _tmp104_[5];
#line 206 "../src/contentHandler.vala"
					_tmp106_ = string_replace (_tmp103_, "$HIGHLIGHT_COLOR", _tmp105_);
#line 206 "../src/contentHandler.vala"
					_g_free0 (currentBookwormScripts);
#line 206 "../src/contentHandler.vala"
					currentBookwormScripts = _tmp106_;
#line 206 "../src/contentHandler.vala"
					_g_free0 (_tmp103_);
#line 2014 "contentHandler.c"
				} else {
					gchar** _tmp107_;
					gint _tmp107__length1;
					const gchar* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					gchar** _tmp113_;
					gint _tmp113__length1;
					const gchar* _tmp114_;
					gchar* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					const gchar* _tmp118_;
					gchar** _tmp119_;
					gint _tmp119__length1;
					const gchar* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					gchar** _tmp123_;
					gint _tmp123__length1;
					const gchar* _tmp124_;
					gchar* _tmp125_;
#line 210 "../src/contentHandler.vala"
					_tmp107_ = bookworm_app_bookworm_profileColorList;
#line 210 "../src/contentHandler.vala"
					_tmp107__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 210 "../src/contentHandler.vala"
					_tmp108_ = _tmp107_[1];
#line 210 "../src/contentHandler.vala"
					_tmp109_ = g_strconcat (" background-color: ", _tmp108_, NULL);
#line 210 "../src/contentHandler.vala"
					_tmp110_ = _tmp109_;
#line 210 "../src/contentHandler.vala"
					_tmp111_ = g_strconcat (_tmp110_, " !important; color: ", NULL);
#line 210 "../src/contentHandler.vala"
					_tmp112_ = _tmp111_;
#line 210 "../src/contentHandler.vala"
					_tmp113_ = bookworm_app_bookworm_profileColorList;
#line 210 "../src/contentHandler.vala"
					_tmp113__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 210 "../src/contentHandler.vala"
					_tmp114_ = _tmp113_[0];
#line 210 "../src/contentHandler.vala"
					_tmp115_ = g_strconcat (_tmp112_, _tmp114_, NULL);
#line 210 "../src/contentHandler.vala"
					_tmp116_ = _tmp115_;
#line 210 "../src/contentHandler.vala"
					_tmp117_ = g_strconcat (_tmp116_, " !important;", NULL);
#line 210 "../src/contentHandler.vala"
					_g_free0 (cssForTextAndBackgroundColor);
#line 210 "../src/contentHandler.vala"
					cssForTextAndBackgroundColor = _tmp117_;
#line 210 "../src/contentHandler.vala"
					_g_free0 (_tmp116_);
#line 210 "../src/contentHandler.vala"
					_g_free0 (_tmp112_);
#line 210 "../src/contentHandler.vala"
					_g_free0 (_tmp110_);
#line 215 "../src/contentHandler.vala"
					_tmp118_ = currentBookwormScripts;
#line 215 "../src/contentHandler.vala"
					_tmp119_ = bookworm_app_bookworm_profileColorList;
#line 215 "../src/contentHandler.vala"
					_tmp119__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 215 "../src/contentHandler.vala"
					_tmp120_ = _tmp119_[1];
#line 215 "../src/contentHandler.vala"
					_tmp121_ = string_replace (_tmp118_, "$SCROLLBAR_BACKGROUND", _tmp120_);
#line 215 "../src/contentHandler.vala"
					_tmp122_ = _tmp121_;
#line 215 "../src/contentHandler.vala"
					_tmp123_ = bookworm_app_bookworm_profileColorList;
#line 215 "../src/contentHandler.vala"
					_tmp123__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 215 "../src/contentHandler.vala"
					_tmp124_ = _tmp123_[2];
#line 215 "../src/contentHandler.vala"
					_tmp125_ = string_replace (_tmp122_, "$HIGHLIGHT_COLOR", _tmp124_);
#line 215 "../src/contentHandler.vala"
					_g_free0 (currentBookwormScripts);
#line 215 "../src/contentHandler.vala"
					currentBookwormScripts = _tmp125_;
#line 215 "../src/contentHandler.vala"
					_g_free0 (_tmp122_);
#line 2101 "contentHandler.c"
				}
			}
		}
	}
#line 220 "../src/contentHandler.vala"
	_tmp126_ = currentBookwormScripts;
#line 220 "../src/contentHandler.vala"
	_tmp127_ = bookworm_app_bookworm_settings;
#line 220 "../src/contentHandler.vala"
	_tmp128_ = bookworm_app_settings_get_reading_line_height (_tmp127_);
#line 220 "../src/contentHandler.vala"
	_tmp129_ = _tmp128_;
#line 220 "../src/contentHandler.vala"
	_tmp130_ = string_replace (_tmp126_, "$READING_LINE_HEIGHT", _tmp129_);
#line 220 "../src/contentHandler.vala"
	_tmp131_ = _tmp130_;
#line 220 "../src/contentHandler.vala"
	_tmp132_ = bookworm_app_bookworm_settings;
#line 220 "../src/contentHandler.vala"
	_tmp133_ = bookworm_app_settings_get_reading_width (_tmp132_);
#line 220 "../src/contentHandler.vala"
	_tmp134_ = _tmp133_;
#line 220 "../src/contentHandler.vala"
	_tmp135_ = g_strdup_printf ("%i", 100 - atoi (_tmp134_));
#line 220 "../src/contentHandler.vala"
	_tmp136_ = _tmp135_;
#line 220 "../src/contentHandler.vala"
	_tmp137_ = string_replace (_tmp131_, "$READING_WIDTH", _tmp136_);
#line 220 "../src/contentHandler.vala"
	_tmp138_ = _tmp137_;
#line 220 "../src/contentHandler.vala"
	_tmp139_ = bookworm_app_bookworm_settings;
#line 220 "../src/contentHandler.vala"
	_tmp140_ = bookworm_app_settings_get_reading_font_name_family (_tmp139_);
#line 220 "../src/contentHandler.vala"
	_tmp141_ = _tmp140_;
#line 220 "../src/contentHandler.vala"
	_tmp142_ = string_replace (_tmp138_, "$FONT_FAMILY", _tmp141_);
#line 220 "../src/contentHandler.vala"
	_tmp143_ = _tmp142_;
#line 220 "../src/contentHandler.vala"
	_tmp144_ = bookworm_app_bookworm_settings;
#line 220 "../src/contentHandler.vala"
	_tmp145_ = bookworm_app_settings_get_reading_font_size (_tmp144_);
#line 220 "../src/contentHandler.vala"
	_tmp146_ = _tmp145_;
#line 220 "../src/contentHandler.vala"
	_tmp147_ = g_strdup_printf ("%i", _tmp146_);
#line 220 "../src/contentHandler.vala"
	_tmp148_ = _tmp147_;
#line 220 "../src/contentHandler.vala"
	_tmp149_ = string_replace (_tmp143_, "$FONT_SIZE", _tmp148_);
#line 220 "../src/contentHandler.vala"
	_tmp150_ = _tmp149_;
#line 220 "../src/contentHandler.vala"
	_tmp151_ = bookworm_app_bookworm_settings;
#line 220 "../src/contentHandler.vala"
	_tmp152_ = bookworm_app_settings_get_text_alignment (_tmp151_);
#line 220 "../src/contentHandler.vala"
	_tmp153_ = _tmp152_;
#line 220 "../src/contentHandler.vala"
	_tmp154_ = string_replace (_tmp150_, "$READING_TEXT_ALIGN", _tmp153_);
#line 220 "../src/contentHandler.vala"
	_tmp155_ = _tmp154_;
#line 220 "../src/contentHandler.vala"
	_tmp156_ = cssForTextAndBackgroundColor;
#line 220 "../src/contentHandler.vala"
	_tmp157_ = string_replace (_tmp155_, "$TEXT_AND_BACKGROUND_COLOR", _tmp156_);
#line 220 "../src/contentHandler.vala"
	_g_free0 (currentBookwormScripts);
#line 220 "../src/contentHandler.vala"
	currentBookwormScripts = _tmp157_;
#line 220 "../src/contentHandler.vala"
	_g_free0 (_tmp155_);
#line 220 "../src/contentHandler.vala"
	_g_free0 (_tmp150_);
#line 220 "../src/contentHandler.vala"
	_g_free0 (_tmp148_);
#line 220 "../src/contentHandler.vala"
	_g_free0 (_tmp143_);
#line 220 "../src/contentHandler.vala"
	_g_free0 (_tmp138_);
#line 220 "../src/contentHandler.vala"
	_g_free0 (_tmp136_);
#line 220 "../src/contentHandler.vala"
	_g_free0 (_tmp131_);
#line 234 "../src/contentHandler.vala"
	if (bookworm_app_bookworm_isPageScrollRequired) {
#line 2190 "contentHandler.c"
		gchar* _tmp158_;
		gchar* _tmp159_;
		gint _tmp160_;
		gint _tmp161_;
		gboolean _tmp162_;
#line 236 "../src/contentHandler.vala"
		_tmp158_ = bookworm_app_book_getAnchor (aBook);
#line 236 "../src/contentHandler.vala"
		_tmp159_ = _tmp158_;
#line 236 "../src/contentHandler.vala"
		_tmp160_ = strlen (_tmp159_);
#line 236 "../src/contentHandler.vala"
		_tmp161_ = _tmp160_;
#line 236 "../src/contentHandler.vala"
		_tmp162_ = _tmp161_ > 0;
#line 236 "../src/contentHandler.vala"
		_g_free0 (_tmp159_);
#line 236 "../src/contentHandler.vala"
		if (_tmp162_) {
#line 2210 "contentHandler.c"
			GString* _tmp163_;
			gchar* _tmp164_;
			gchar* _tmp165_;
			gchar* _tmp166_;
			gchar* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
#line 237 "../src/contentHandler.vala"
			_tmp163_ = bookworm_app_bookworm_onLoadJavaScript;
#line 237 "../src/contentHandler.vala"
			_tmp164_ = bookworm_app_book_getAnchor (aBook);
#line 237 "../src/contentHandler.vala"
			_tmp165_ = _tmp164_;
#line 237 "../src/contentHandler.vala"
			_tmp166_ = g_strconcat (" document.getElementById('", _tmp165_, NULL);
#line 237 "../src/contentHandler.vala"
			_tmp167_ = _tmp166_;
#line 237 "../src/contentHandler.vala"
			_tmp168_ = g_strconcat (_tmp167_, "').scrollIntoView();", NULL);
#line 237 "../src/contentHandler.vala"
			_tmp169_ = _tmp168_;
#line 237 "../src/contentHandler.vala"
			g_string_append (_tmp163_, _tmp169_);
#line 237 "../src/contentHandler.vala"
			_g_free0 (_tmp169_);
#line 237 "../src/contentHandler.vala"
			_g_free0 (_tmp167_);
#line 237 "../src/contentHandler.vala"
			_g_free0 (_tmp165_);
#line 2240 "contentHandler.c"
		} else {
			GString* _tmp170_;
			GeeHashMap* _tmp171_;
			const gchar* _tmp172_;
			gpointer _tmp173_;
			BookwormAppBook* _tmp174_;
			gchar* _tmp175_;
			gchar* _tmp176_;
			gchar* _tmp177_;
			gchar* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
#line 241 "../src/contentHandler.vala"
			_tmp170_ = bookworm_app_bookworm_onLoadJavaScript;
#line 241 "../src/contentHandler.vala"
			_tmp171_ = bookworm_app_bookworm_libraryViewMap;
#line 241 "../src/contentHandler.vala"
			_tmp172_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 241 "../src/contentHandler.vala"
			_tmp173_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp171_, _tmp172_);
#line 241 "../src/contentHandler.vala"
			_tmp174_ = (BookwormAppBook*) _tmp173_;
#line 241 "../src/contentHandler.vala"
			_tmp175_ = g_strdup_printf ("%i", bookworm_app_book_getBookScrollPos (_tmp174_));
#line 241 "../src/contentHandler.vala"
			_tmp176_ = _tmp175_;
#line 241 "../src/contentHandler.vala"
			_tmp177_ = g_strconcat (" window.scrollTo(0,", _tmp176_, NULL);
#line 241 "../src/contentHandler.vala"
			_tmp178_ = _tmp177_;
#line 241 "../src/contentHandler.vala"
			_tmp179_ = g_strconcat (_tmp178_, ");", NULL);
#line 241 "../src/contentHandler.vala"
			_tmp180_ = _tmp179_;
#line 241 "../src/contentHandler.vala"
			g_string_append (_tmp170_, _tmp180_);
#line 241 "../src/contentHandler.vala"
			_g_free0 (_tmp180_);
#line 241 "../src/contentHandler.vala"
			_g_free0 (_tmp178_);
#line 241 "../src/contentHandler.vala"
			_g_free0 (_tmp176_);
#line 241 "../src/contentHandler.vala"
			_bookworm_app_book_unref0 (_tmp174_);
#line 2285 "contentHandler.c"
		}
#line 246 "../src/contentHandler.vala"
		bookworm_app_bookworm_isPageScrollRequired = FALSE;
#line 2289 "contentHandler.c"
	}
#line 249 "../src/contentHandler.vala"
	_tmp181_ = bookworm_app_bookworm_settings;
#line 249 "../src/contentHandler.vala"
	_tmp182_ = bookworm_app_settings_get_is_two_page_enabled (_tmp181_);
#line 249 "../src/contentHandler.vala"
	_tmp183_ = _tmp182_;
#line 249 "../src/contentHandler.vala"
	if (_tmp183_) {
#line 2299 "contentHandler.c"
		GString* _tmp184_;
#line 250 "../src/contentHandler.vala"
		_tmp184_ = bookworm_app_bookworm_onLoadJavaScript;
#line 250 "../src/contentHandler.vala"
		g_string_append (_tmp184_, " setTwoPageView();");
#line 2305 "contentHandler.c"
	}
	{
		GeeIterator* _entry_it = NULL;
		GeeTreeMap* _tmp185_;
		GeeTreeMap* _tmp186_;
		GeeSet* _tmp187_;
		GeeSet* _tmp188_;
		GeeSet* _tmp189_;
		GeeIterator* _tmp190_;
		GeeIterator* _tmp191_;
#line 253 "../src/contentHandler.vala"
		_tmp185_ = bookworm_app_book_getAnnotationList (aBook);
#line 253 "../src/contentHandler.vala"
		_tmp186_ = _tmp185_;
#line 253 "../src/contentHandler.vala"
		_tmp187_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp186_);
#line 253 "../src/contentHandler.vala"
		_tmp188_ = _tmp187_;
#line 253 "../src/contentHandler.vala"
		_tmp189_ = _tmp188_;
#line 253 "../src/contentHandler.vala"
		_tmp190_ = gee_iterable_iterator ((GeeIterable*) _tmp189_);
#line 253 "../src/contentHandler.vala"
		_tmp191_ = _tmp190_;
#line 253 "../src/contentHandler.vala"
		_g_object_unref0 (_tmp189_);
#line 253 "../src/contentHandler.vala"
		_g_object_unref0 (_tmp186_);
#line 253 "../src/contentHandler.vala"
		_entry_it = _tmp191_;
#line 253 "../src/contentHandler.vala"
		while (TRUE) {
#line 2338 "contentHandler.c"
			GeeIterator* _tmp192_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp193_;
			gpointer _tmp194_;
			gchar* _tmp195_;
			gchar* _tmp196_;
			GeeMapEntry* _tmp197_;
			gconstpointer _tmp198_;
			gconstpointer _tmp199_;
			gchar** _tmp200_;
			gchar** _tmp201_;
			gchar** _tmp202_;
			gint _tmp202__length1;
			const gchar* _tmp203_;
			gboolean _tmp204_;
#line 253 "../src/contentHandler.vala"
			_tmp192_ = _entry_it;
#line 253 "../src/contentHandler.vala"
			if (!gee_iterator_next (_tmp192_)) {
#line 253 "../src/contentHandler.vala"
				break;
#line 2360 "contentHandler.c"
			}
#line 253 "../src/contentHandler.vala"
			_tmp193_ = _entry_it;
#line 253 "../src/contentHandler.vala"
			_tmp194_ = gee_iterator_get (_tmp193_);
#line 253 "../src/contentHandler.vala"
			entry = (GeeMapEntry*) _tmp194_;
#line 254 "../src/contentHandler.vala"
			_tmp195_ = g_strdup_printf ("%i", bookworm_app_book_getBookPageNumber (aBook));
#line 254 "../src/contentHandler.vala"
			_tmp196_ = _tmp195_;
#line 254 "../src/contentHandler.vala"
			_tmp197_ = entry;
#line 254 "../src/contentHandler.vala"
			_tmp198_ = gee_map_entry_get_key (_tmp197_);
#line 254 "../src/contentHandler.vala"
			_tmp199_ = _tmp198_;
#line 254 "../src/contentHandler.vala"
			_tmp201_ = _tmp200_ = g_strsplit ((const gchar*) _tmp199_, "#~~#", 0);
#line 254 "../src/contentHandler.vala"
			_tmp202_ = _tmp201_;
#line 254 "../src/contentHandler.vala"
			_tmp202__length1 = _vala_array_length (_tmp200_);
#line 254 "../src/contentHandler.vala"
			_tmp203_ = _tmp202_[0];
#line 254 "../src/contentHandler.vala"
			_tmp204_ = g_strcmp0 (_tmp196_, _tmp203_) == 0;
#line 254 "../src/contentHandler.vala"
			_tmp202_ = (_vala_array_free (_tmp202_, _tmp202__length1, (GDestroyNotify) g_free), NULL);
#line 254 "../src/contentHandler.vala"
			_g_free0 (_tmp196_);
#line 254 "../src/contentHandler.vala"
			if (_tmp204_) {
#line 2394 "contentHandler.c"
				GString* _tmp205_;
				GeeMapEntry* _tmp206_;
				gconstpointer _tmp207_;
				gconstpointer _tmp208_;
				gchar** _tmp209_;
				gchar** _tmp210_;
				gchar** _tmp211_;
				gint _tmp211__length1;
				const gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				gchar* _tmp215_;
				gchar* _tmp216_;
#line 255 "../src/contentHandler.vala"
				_tmp205_ = bookworm_app_bookworm_onLoadJavaScript;
#line 255 "../src/contentHandler.vala"
				_tmp206_ = entry;
#line 255 "../src/contentHandler.vala"
				_tmp207_ = gee_map_entry_get_key (_tmp206_);
#line 255 "../src/contentHandler.vala"
				_tmp208_ = _tmp207_;
#line 255 "../src/contentHandler.vala"
				_tmp210_ = _tmp209_ = g_strsplit ((const gchar*) _tmp208_, "#~~#", 0);
#line 255 "../src/contentHandler.vala"
				_tmp211_ = _tmp210_;
#line 255 "../src/contentHandler.vala"
				_tmp211__length1 = _vala_array_length (_tmp209_);
#line 255 "../src/contentHandler.vala"
				_tmp212_ = _tmp211_[1];
#line 255 "../src/contentHandler.vala"
				_tmp213_ = g_strconcat (" overlayAnnotation('", _tmp212_, NULL);
#line 255 "../src/contentHandler.vala"
				_tmp214_ = _tmp213_;
#line 255 "../src/contentHandler.vala"
				_tmp215_ = g_strconcat (_tmp214_, "');", NULL);
#line 255 "../src/contentHandler.vala"
				_tmp216_ = _tmp215_;
#line 255 "../src/contentHandler.vala"
				g_string_append (_tmp205_, _tmp216_);
#line 255 "../src/contentHandler.vala"
				_g_free0 (_tmp216_);
#line 255 "../src/contentHandler.vala"
				_g_free0 (_tmp214_);
#line 255 "../src/contentHandler.vala"
				_tmp211_ = (_vala_array_free (_tmp211_, _tmp211__length1, (GDestroyNotify) g_free), NULL);
#line 2440 "contentHandler.c"
			}
#line 253 "../src/contentHandler.vala"
			_g_object_unref0 (entry);
#line 2444 "contentHandler.c"
		}
#line 253 "../src/contentHandler.vala"
		_g_object_unref0 (_entry_it);
#line 2448 "contentHandler.c"
	}
#line 262 "../src/contentHandler.vala"
	if (g_strcmp0 ("SEARCH", mode) == 0) {
#line 2452 "contentHandler.c"
		const gchar* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
#line 263 "../src/contentHandler.vala"
		_tmp217_ = bookworm_app_bookworm_bookTextSearchString;
#line 263 "../src/contentHandler.vala"
		_tmp218_ = strlen (_tmp217_);
#line 263 "../src/contentHandler.vala"
		_tmp219_ = _tmp218_;
#line 263 "../src/contentHandler.vala"
		if (_tmp219_ > 1) {
#line 2464 "contentHandler.c"
			gchar** searchTokens = NULL;
			const gchar* _tmp220_;
			gchar** _tmp221_;
			gchar** _tmp222_;
			gint searchTokens_length1;
			gint _searchTokens_size_;
			gchar** _tmp223_;
			gint _tmp223__length1;
#line 264 "../src/contentHandler.vala"
			_tmp220_ = bookworm_app_bookworm_bookTextSearchString;
#line 264 "../src/contentHandler.vala"
			_tmp222_ = _tmp221_ = g_strsplit (_tmp220_, "#~~#", 0);
#line 264 "../src/contentHandler.vala"
			searchTokens = _tmp222_;
#line 264 "../src/contentHandler.vala"
			searchTokens_length1 = _vala_array_length (_tmp221_);
#line 264 "../src/contentHandler.vala"
			_searchTokens_size_ = searchTokens_length1;
#line 265 "../src/contentHandler.vala"
			_tmp223_ = searchTokens;
#line 265 "../src/contentHandler.vala"
			_tmp223__length1 = searchTokens_length1;
#line 265 "../src/contentHandler.vala"
			if (_tmp223__length1 == 2) {
#line 2489 "contentHandler.c"
				gint startPosOfSearchString = 0;
				gchar** _tmp224_;
				gint _tmp224__length1;
				const gchar* _tmp225_;
				gchar** _tmp226_;
				gint _tmp226__length1;
				const gchar* _tmp227_;
				gint endPosOfSearchString = 0;
				gchar** _tmp228_;
				gint _tmp228__length1;
				const gchar* _tmp229_;
				gint _tmp230_;
				gint _tmp231_;
				gint lengthOfLineWithSearchString = 0;
				gchar** _tmp232_;
				gint _tmp232__length1;
				const gchar* _tmp233_;
				gint _tmp234_;
				gint _tmp235_;
				gint countSpaces = 0;
				gint startPosOfStringToBeHighlighted = 0;
				gint endPosOfStringToBeHighlighted = 0;
				gchar* stringToBeHighlighted = NULL;
				gchar* _tmp236_;
				const gchar* _tmp256_;
				gchar* _tmp257_;
				gchar* _tmp258_;
				gchar* _tmp259_;
				const gchar* _tmp260_;
				gchar* _tmp261_;
				gchar* _tmp262_;
				GString* _tmp263_;
				const gchar* _tmp264_;
				gchar* _tmp265_;
				gchar* _tmp266_;
				gchar* _tmp267_;
				gchar* _tmp268_;
#line 267 "../src/contentHandler.vala"
				_tmp224_ = searchTokens;
#line 267 "../src/contentHandler.vala"
				_tmp224__length1 = searchTokens_length1;
#line 267 "../src/contentHandler.vala"
				_tmp225_ = _tmp224_[1];
#line 267 "../src/contentHandler.vala"
				_tmp226_ = searchTokens;
#line 267 "../src/contentHandler.vala"
				_tmp226__length1 = searchTokens_length1;
#line 267 "../src/contentHandler.vala"
				_tmp227_ = _tmp226_[0];
#line 267 "../src/contentHandler.vala"
				startPosOfSearchString = string_index_of (_tmp225_, _tmp227_, 0);
#line 268 "../src/contentHandler.vala"
				_tmp228_ = searchTokens;
#line 268 "../src/contentHandler.vala"
				_tmp228__length1 = searchTokens_length1;
#line 268 "../src/contentHandler.vala"
				_tmp229_ = _tmp228_[0];
#line 268 "../src/contentHandler.vala"
				_tmp230_ = strlen (_tmp229_);
#line 268 "../src/contentHandler.vala"
				_tmp231_ = _tmp230_;
#line 268 "../src/contentHandler.vala"
				endPosOfSearchString = startPosOfSearchString + _tmp231_;
#line 269 "../src/contentHandler.vala"
				_tmp232_ = searchTokens;
#line 269 "../src/contentHandler.vala"
				_tmp232__length1 = searchTokens_length1;
#line 269 "../src/contentHandler.vala"
				_tmp233_ = _tmp232_[1];
#line 269 "../src/contentHandler.vala"
				_tmp234_ = strlen (_tmp233_);
#line 269 "../src/contentHandler.vala"
				_tmp235_ = _tmp234_;
#line 269 "../src/contentHandler.vala"
				lengthOfLineWithSearchString = _tmp235_;
#line 270 "../src/contentHandler.vala"
				countSpaces = 0;
#line 271 "../src/contentHandler.vala"
				startPosOfStringToBeHighlighted = 0;
#line 272 "../src/contentHandler.vala"
				endPosOfStringToBeHighlighted = 0;
#line 273 "../src/contentHandler.vala"
				_tmp236_ = g_strdup ("");
#line 273 "../src/contentHandler.vala"
				stringToBeHighlighted = _tmp236_;
#line 274 "../src/contentHandler.vala"
				if (startPosOfSearchString != -1) {
#line 2577 "contentHandler.c"
					{
						gint i = 0;
#line 276 "../src/contentHandler.vala"
						i = startPosOfSearchString;
#line 2582 "contentHandler.c"
						{
							gboolean _tmp237_ = FALSE;
#line 276 "../src/contentHandler.vala"
							_tmp237_ = TRUE;
#line 276 "../src/contentHandler.vala"
							while (TRUE) {
#line 2589 "contentHandler.c"
								gchar** _tmp239_;
								gint _tmp239__length1;
								const gchar* _tmp240_;
								gchar* _tmp241_;
								gchar* _tmp242_;
								gboolean _tmp243_;
#line 276 "../src/contentHandler.vala"
								if (!_tmp237_) {
#line 2598 "contentHandler.c"
									gint _tmp238_;
#line 276 "../src/contentHandler.vala"
									_tmp238_ = i;
#line 276 "../src/contentHandler.vala"
									i = _tmp238_ - 1;
#line 2604 "contentHandler.c"
								}
#line 276 "../src/contentHandler.vala"
								_tmp237_ = FALSE;
#line 276 "../src/contentHandler.vala"
								if (!(i > 1)) {
#line 276 "../src/contentHandler.vala"
									break;
#line 2612 "contentHandler.c"
								}
#line 278 "../src/contentHandler.vala"
								_tmp239_ = searchTokens;
#line 278 "../src/contentHandler.vala"
								_tmp239__length1 = searchTokens_length1;
#line 278 "../src/contentHandler.vala"
								_tmp240_ = _tmp239_[1];
#line 278 "../src/contentHandler.vala"
								_tmp241_ = string_slice (_tmp240_, (glong) i, (glong) (i + 1));
#line 278 "../src/contentHandler.vala"
								_tmp242_ = _tmp241_;
#line 278 "../src/contentHandler.vala"
								_tmp243_ = g_strcmp0 (" ", _tmp242_) == 0;
#line 278 "../src/contentHandler.vala"
								_g_free0 (_tmp242_);
#line 278 "../src/contentHandler.vala"
								if (_tmp243_) {
#line 2630 "contentHandler.c"
									gint _tmp244_;
#line 279 "../src/contentHandler.vala"
									_tmp244_ = countSpaces;
#line 279 "../src/contentHandler.vala"
									countSpaces = _tmp244_ + 1;
#line 2636 "contentHandler.c"
								}
#line 281 "../src/contentHandler.vala"
								if (countSpaces == 2) {
#line 282 "../src/contentHandler.vala"
									startPosOfStringToBeHighlighted = i + 1;
#line 283 "../src/contentHandler.vala"
									break;
#line 2644 "contentHandler.c"
								}
							}
						}
					}
#line 287 "../src/contentHandler.vala"
					countSpaces = 0;
#line 2651 "contentHandler.c"
					{
						gint j = 0;
#line 288 "../src/contentHandler.vala"
						j = endPosOfSearchString;
#line 2656 "contentHandler.c"
						{
							gboolean _tmp245_ = FALSE;
#line 288 "../src/contentHandler.vala"
							_tmp245_ = TRUE;
#line 288 "../src/contentHandler.vala"
							while (TRUE) {
#line 2663 "contentHandler.c"
								gchar** _tmp247_;
								gint _tmp247__length1;
								const gchar* _tmp248_;
								gchar* _tmp249_;
								gchar* _tmp250_;
								gboolean _tmp251_;
#line 288 "../src/contentHandler.vala"
								if (!_tmp245_) {
#line 2672 "contentHandler.c"
									gint _tmp246_;
#line 288 "../src/contentHandler.vala"
									_tmp246_ = j;
#line 288 "../src/contentHandler.vala"
									j = _tmp246_ + 1;
#line 2678 "contentHandler.c"
								}
#line 288 "../src/contentHandler.vala"
								_tmp245_ = FALSE;
#line 288 "../src/contentHandler.vala"
								if (!(j < lengthOfLineWithSearchString)) {
#line 288 "../src/contentHandler.vala"
									break;
#line 2686 "contentHandler.c"
								}
#line 290 "../src/contentHandler.vala"
								_tmp247_ = searchTokens;
#line 290 "../src/contentHandler.vala"
								_tmp247__length1 = searchTokens_length1;
#line 290 "../src/contentHandler.vala"
								_tmp248_ = _tmp247_[1];
#line 290 "../src/contentHandler.vala"
								_tmp249_ = string_slice (_tmp248_, (glong) j, (glong) (j + 1));
#line 290 "../src/contentHandler.vala"
								_tmp250_ = _tmp249_;
#line 290 "../src/contentHandler.vala"
								_tmp251_ = g_strcmp0 (" ", _tmp250_) == 0;
#line 290 "../src/contentHandler.vala"
								_g_free0 (_tmp250_);
#line 290 "../src/contentHandler.vala"
								if (_tmp251_) {
#line 2704 "contentHandler.c"
									gint _tmp252_;
#line 291 "../src/contentHandler.vala"
									_tmp252_ = countSpaces;
#line 291 "../src/contentHandler.vala"
									countSpaces = _tmp252_ + 1;
#line 2710 "contentHandler.c"
								}
#line 293 "../src/contentHandler.vala"
								if (countSpaces == 2) {
#line 294 "../src/contentHandler.vala"
									endPosOfStringToBeHighlighted = j;
#line 295 "../src/contentHandler.vala"
									break;
#line 2718 "contentHandler.c"
								}
							}
						}
					}
#line 299 "../src/contentHandler.vala"
					if (endPosOfStringToBeHighlighted > startPosOfStringToBeHighlighted) {
#line 2725 "contentHandler.c"
						gchar** _tmp253_;
						gint _tmp253__length1;
						const gchar* _tmp254_;
						gchar* _tmp255_;
#line 300 "../src/contentHandler.vala"
						_tmp253_ = searchTokens;
#line 300 "../src/contentHandler.vala"
						_tmp253__length1 = searchTokens_length1;
#line 300 "../src/contentHandler.vala"
						_tmp254_ = _tmp253_[1];
#line 300 "../src/contentHandler.vala"
						_tmp255_ = string_slice (_tmp254_, (glong) startPosOfStringToBeHighlighted, (glong) endPosOfStringToBeHighlighted);
#line 300 "../src/contentHandler.vala"
						_g_free0 (stringToBeHighlighted);
#line 300 "../src/contentHandler.vala"
						stringToBeHighlighted = _tmp255_;
#line 2742 "contentHandler.c"
					}
				}
#line 305 "../src/contentHandler.vala"
				_tmp256_ = stringToBeHighlighted;
#line 305 "../src/contentHandler.vala"
				_tmp257_ = string_replace (_tmp256_, "\"", "&quot;");
#line 305 "../src/contentHandler.vala"
				_tmp258_ = _tmp257_;
#line 305 "../src/contentHandler.vala"
				_tmp259_ = string_replace (_tmp258_, "'", "&#39;");
#line 305 "../src/contentHandler.vala"
				_g_free0 (stringToBeHighlighted);
#line 305 "../src/contentHandler.vala"
				stringToBeHighlighted = _tmp259_;
#line 305 "../src/contentHandler.vala"
				_g_free0 (_tmp258_);
#line 308 "../src/contentHandler.vala"
				_tmp260_ = stringToBeHighlighted;
#line 308 "../src/contentHandler.vala"
				_tmp261_ = g_strconcat ("Searching to highlight the phrase:", _tmp260_, NULL);
#line 308 "../src/contentHandler.vala"
				_tmp262_ = _tmp261_;
#line 308 "../src/contentHandler.vala"
				g_debug ("contentHandler.vala:308: %s", _tmp262_);
#line 308 "../src/contentHandler.vala"
				_g_free0 (_tmp262_);
#line 309 "../src/contentHandler.vala"
				_tmp263_ = bookworm_app_bookworm_onLoadJavaScript;
#line 309 "../src/contentHandler.vala"
				_tmp264_ = stringToBeHighlighted;
#line 309 "../src/contentHandler.vala"
				_tmp265_ = g_strconcat (" highlightText(encodeURIComponent('", _tmp264_, NULL);
#line 309 "../src/contentHandler.vala"
				_tmp266_ = _tmp265_;
#line 309 "../src/contentHandler.vala"
				_tmp267_ = g_strconcat (_tmp266_, "'));", NULL);
#line 309 "../src/contentHandler.vala"
				_tmp268_ = _tmp267_;
#line 309 "../src/contentHandler.vala"
				g_string_append (_tmp263_, _tmp268_);
#line 309 "../src/contentHandler.vala"
				_g_free0 (_tmp268_);
#line 309 "../src/contentHandler.vala"
				_g_free0 (_tmp266_);
#line 265 "../src/contentHandler.vala"
				_g_free0 (stringToBeHighlighted);
#line 2789 "contentHandler.c"
			}
#line 263 "../src/contentHandler.vala"
			searchTokens = (_vala_array_free (searchTokens, searchTokens_length1, (GDestroyNotify) g_free), NULL);
#line 2793 "contentHandler.c"
		}
	}
#line 315 "../src/contentHandler.vala"
	_tmp269_ = bookworm_app_bookworm_onLoadJavaScript;
#line 315 "../src/contentHandler.vala"
	g_string_append (_tmp269_, "\"");
#line 318 "../src/contentHandler.vala"
	_tmp270_ = pageContent;
#line 318 "../src/contentHandler.vala"
	_tmp271_ = _tmp270_->str;
#line 318 "../src/contentHandler.vala"
	if (string_index_of (_tmp271_, "<BODY", 0) != -1) {
#line 2806 "contentHandler.c"
		GString* _tmp272_;
		GString* _tmp273_;
		const gchar* _tmp274_;
		const gchar* _tmp275_;
		gchar* _tmp276_;
		gchar* _tmp277_;
		GString* _tmp278_;
		const gchar* _tmp279_;
		gchar* _tmp280_;
		gchar* _tmp281_;
		gchar* _tmp282_;
		gchar* _tmp283_;
#line 319 "../src/contentHandler.vala"
		_tmp272_ = pageContent;
#line 319 "../src/contentHandler.vala"
		_tmp273_ = pageContent;
#line 319 "../src/contentHandler.vala"
		_tmp274_ = _tmp273_->str;
#line 319 "../src/contentHandler.vala"
		_tmp275_ = currentBookwormScripts;
#line 319 "../src/contentHandler.vala"
		_tmp276_ = g_strconcat (_tmp275_, "<BODY ", NULL);
#line 319 "../src/contentHandler.vala"
		_tmp277_ = _tmp276_;
#line 319 "../src/contentHandler.vala"
		_tmp278_ = bookworm_app_bookworm_onLoadJavaScript;
#line 319 "../src/contentHandler.vala"
		_tmp279_ = _tmp278_->str;
#line 319 "../src/contentHandler.vala"
		_tmp280_ = g_strconcat (_tmp277_, _tmp279_, NULL);
#line 319 "../src/contentHandler.vala"
		_tmp281_ = _tmp280_;
#line 319 "../src/contentHandler.vala"
		_tmp282_ = string_replace (_tmp274_, "<BODY", _tmp281_);
#line 319 "../src/contentHandler.vala"
		_tmp283_ = _tmp282_;
#line 319 "../src/contentHandler.vala"
		g_string_assign (_tmp272_, _tmp283_);
#line 319 "../src/contentHandler.vala"
		_g_free0 (_tmp283_);
#line 319 "../src/contentHandler.vala"
		_g_free0 (_tmp281_);
#line 319 "../src/contentHandler.vala"
		_g_free0 (_tmp277_);
#line 2851 "contentHandler.c"
	} else {
		GString* _tmp284_;
		const gchar* _tmp285_;
#line 326 "../src/contentHandler.vala"
		_tmp284_ = pageContent;
#line 326 "../src/contentHandler.vala"
		_tmp285_ = _tmp284_->str;
#line 326 "../src/contentHandler.vala"
		if (string_index_of (_tmp285_, "<body", 0) != -1) {
#line 2861 "contentHandler.c"
			GString* _tmp286_;
			GString* _tmp287_;
			const gchar* _tmp288_;
			const gchar* _tmp289_;
			gchar* _tmp290_;
			gchar* _tmp291_;
			GString* _tmp292_;
			const gchar* _tmp293_;
			gchar* _tmp294_;
			gchar* _tmp295_;
			gchar* _tmp296_;
			gchar* _tmp297_;
#line 327 "../src/contentHandler.vala"
			_tmp286_ = pageContent;
#line 327 "../src/contentHandler.vala"
			_tmp287_ = pageContent;
#line 327 "../src/contentHandler.vala"
			_tmp288_ = _tmp287_->str;
#line 327 "../src/contentHandler.vala"
			_tmp289_ = currentBookwormScripts;
#line 327 "../src/contentHandler.vala"
			_tmp290_ = g_strconcat (_tmp289_, "<body ", NULL);
#line 327 "../src/contentHandler.vala"
			_tmp291_ = _tmp290_;
#line 327 "../src/contentHandler.vala"
			_tmp292_ = bookworm_app_bookworm_onLoadJavaScript;
#line 327 "../src/contentHandler.vala"
			_tmp293_ = _tmp292_->str;
#line 327 "../src/contentHandler.vala"
			_tmp294_ = g_strconcat (_tmp291_, _tmp293_, NULL);
#line 327 "../src/contentHandler.vala"
			_tmp295_ = _tmp294_;
#line 327 "../src/contentHandler.vala"
			_tmp296_ = string_replace (_tmp288_, "<body", _tmp295_);
#line 327 "../src/contentHandler.vala"
			_tmp297_ = _tmp296_;
#line 327 "../src/contentHandler.vala"
			g_string_assign (_tmp286_, _tmp297_);
#line 327 "../src/contentHandler.vala"
			_g_free0 (_tmp297_);
#line 327 "../src/contentHandler.vala"
			_g_free0 (_tmp295_);
#line 327 "../src/contentHandler.vala"
			_g_free0 (_tmp291_);
#line 2906 "contentHandler.c"
		} else {
			GString* _tmp298_;
			const gchar* _tmp299_;
			gchar* _tmp300_;
			gchar* _tmp301_;
			GString* _tmp302_;
			const gchar* _tmp303_;
			gchar* _tmp304_;
			gchar* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			GString* _tmp308_;
			const gchar* _tmp309_;
			gchar* _tmp310_;
			gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
#line 335 "../src/contentHandler.vala"
			_tmp298_ = pageContent;
#line 335 "../src/contentHandler.vala"
			_tmp299_ = currentBookwormScripts;
#line 335 "../src/contentHandler.vala"
			_tmp300_ = g_strconcat (_tmp299_, "<BODY ", NULL);
#line 335 "../src/contentHandler.vala"
			_tmp301_ = _tmp300_;
#line 335 "../src/contentHandler.vala"
			_tmp302_ = bookworm_app_bookworm_onLoadJavaScript;
#line 335 "../src/contentHandler.vala"
			_tmp303_ = _tmp302_->str;
#line 335 "../src/contentHandler.vala"
			_tmp304_ = g_strconcat (_tmp301_, _tmp303_, NULL);
#line 335 "../src/contentHandler.vala"
			_tmp305_ = _tmp304_;
#line 335 "../src/contentHandler.vala"
			_tmp306_ = g_strconcat (_tmp305_, ">", NULL);
#line 335 "../src/contentHandler.vala"
			_tmp307_ = _tmp306_;
#line 335 "../src/contentHandler.vala"
			_tmp308_ = pageContent;
#line 335 "../src/contentHandler.vala"
			_tmp309_ = _tmp308_->str;
#line 335 "../src/contentHandler.vala"
			_tmp310_ = g_strconcat (_tmp307_, _tmp309_, NULL);
#line 335 "../src/contentHandler.vala"
			_tmp311_ = _tmp310_;
#line 335 "../src/contentHandler.vala"
			_tmp312_ = g_strconcat (_tmp311_, "</BODY>", NULL);
#line 335 "../src/contentHandler.vala"
			_tmp313_ = _tmp312_;
#line 335 "../src/contentHandler.vala"
			g_string_assign (_tmp298_, _tmp313_);
#line 335 "../src/contentHandler.vala"
			_g_free0 (_tmp313_);
#line 335 "../src/contentHandler.vala"
			_g_free0 (_tmp311_);
#line 335 "../src/contentHandler.vala"
			_g_free0 (_tmp307_);
#line 335 "../src/contentHandler.vala"
			_g_free0 (_tmp305_);
#line 335 "../src/contentHandler.vala"
			_g_free0 (_tmp301_);
#line 2968 "contentHandler.c"
		}
	}
#line 341 "../src/contentHandler.vala"
	_tmp314_ = pageContent;
#line 341 "../src/contentHandler.vala"
	_tmp315_ = _tmp314_->str;
#line 341 "../src/contentHandler.vala"
	_tmp316_ = strlen (_tmp315_);
#line 341 "../src/contentHandler.vala"
	_tmp317_ = _tmp316_;
#line 341 "../src/contentHandler.vala"
	_tmp318_ = g_strdup_printf ("%i", _tmp317_);
#line 341 "../src/contentHandler.vala"
	_tmp319_ = _tmp318_;
#line 341 "../src/contentHandler.vala"
	_tmp320_ = g_strconcat ("[END] [FUNCTION:adjustPageContent] pageContent.length=", _tmp319_, NULL);
#line 341 "../src/contentHandler.vala"
	_tmp321_ = _tmp320_;
#line 341 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:341: %s", _tmp321_);
#line 341 "../src/contentHandler.vala"
	_g_free0 (_tmp321_);
#line 341 "../src/contentHandler.vala"
	_g_free0 (_tmp319_);
#line 343 "../src/contentHandler.vala"
	_tmp322_ = pageContent;
#line 343 "../src/contentHandler.vala"
	_tmp323_ = _tmp322_->str;
#line 343 "../src/contentHandler.vala"
	_tmp324_ = g_strdup (_tmp323_);
#line 343 "../src/contentHandler.vala"
	result = _tmp324_;
#line 343 "../src/contentHandler.vala"
	_g_free0 (currentBookwormScripts);
#line 343 "../src/contentHandler.vala"
	_g_free0 (cssForTextAndBackgroundColor);
#line 343 "../src/contentHandler.vala"
	_g_string_free0 (pageContent);
#line 343 "../src/contentHandler.vala"
	_g_free0 (pageContentStr);
#line 343 "../src/contentHandler.vala"
	return result;
#line 3011 "contentHandler.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 3032 "contentHandler.c"
}

void
bookworm_app_content_handler_searchHTMLContents (void)
{
	GString* bookSearchResults = NULL;
	GString* _tmp0_;
	gint searchResultCount = 0;
	GeeTreeMap* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkSearchEntry* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp24_;
#line 347 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:347: [START] [FUNCTION:searchHTMLContents]");
#line 348 "../src/contentHandler.vala"
	_tmp0_ = g_string_new ("");
#line 348 "../src/contentHandler.vala"
	bookSearchResults = _tmp0_;
#line 349 "../src/contentHandler.vala"
	searchResultCount = 1;
#line 350 "../src/contentHandler.vala"
	_tmp1_ = bookworm_app_bookworm_searchResultsMap;
#line 350 "../src/contentHandler.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
#line 352 "../src/contentHandler.vala"
	_tmp2_ = bookSearchResults;
#line 352 "../src/contentHandler.vala"
	_tmp3_ = bookworm_app_bookworm_aContentFileToBeSearched;
#line 352 "../src/contentHandler.vala"
	_tmp4_ = _tmp3_->str;
#line 352 "../src/contentHandler.vala"
	_tmp5_ = g_strconcat (BOOKWORM_APP_CONSTANTS_SEARCH_SCRIPT_LOCATION " \"", _tmp4_, NULL);
#line 352 "../src/contentHandler.vala"
	_tmp6_ = _tmp5_;
#line 352 "../src/contentHandler.vala"
	_tmp7_ = g_strconcat (_tmp6_, "\" \"", NULL);
#line 352 "../src/contentHandler.vala"
	_tmp8_ = _tmp7_;
#line 352 "../src/contentHandler.vala"
	_tmp9_ = bookworm_app_app_header_bar_headerSearchBar;
#line 352 "../src/contentHandler.vala"
	_tmp10_ = gtk_entry_get_text ((GtkEntry*) _tmp9_);
#line 352 "../src/contentHandler.vala"
	_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
#line 352 "../src/contentHandler.vala"
	_tmp12_ = _tmp11_;
#line 352 "../src/contentHandler.vala"
	_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
#line 352 "../src/contentHandler.vala"
	_tmp14_ = _tmp13_;
#line 352 "../src/contentHandler.vala"
	_tmp15_ = bookworm_app_utils_execute_sync_command (_tmp14_);
#line 352 "../src/contentHandler.vala"
	_tmp16_ = _tmp15_;
#line 352 "../src/contentHandler.vala"
	g_string_assign (_tmp2_, _tmp16_);
#line 352 "../src/contentHandler.vala"
	_g_free0 (_tmp16_);
#line 352 "../src/contentHandler.vala"
	_g_free0 (_tmp14_);
#line 352 "../src/contentHandler.vala"
	_g_free0 (_tmp12_);
#line 352 "../src/contentHandler.vala"
	_g_free0 (_tmp8_);
#line 352 "../src/contentHandler.vala"
	_g_free0 (_tmp6_);
#line 360 "../src/contentHandler.vala"
	_tmp18_ = bookSearchResults;
#line 360 "../src/contentHandler.vala"
	_tmp19_ = _tmp18_->str;
#line 360 "../src/contentHandler.vala"
	_tmp20_ = string_strip (_tmp19_);
#line 360 "../src/contentHandler.vala"
	_tmp21_ = _tmp20_;
#line 360 "../src/contentHandler.vala"
	_tmp22_ = strlen (_tmp21_);
#line 360 "../src/contentHandler.vala"
	_tmp23_ = _tmp22_;
#line 360 "../src/contentHandler.vala"
	_tmp24_ = _tmp23_ > 0;
#line 360 "../src/contentHandler.vala"
	_g_free0 (_tmp21_);
#line 360 "../src/contentHandler.vala"
	if (_tmp24_) {
#line 3137 "contentHandler.c"
		GString* _tmp25_;
		const gchar* _tmp26_;
#line 360 "../src/contentHandler.vala"
		_tmp25_ = bookSearchResults;
#line 360 "../src/contentHandler.vala"
		_tmp26_ = _tmp25_->str;
#line 360 "../src/contentHandler.vala"
		_tmp17_ = g_strcmp0 (_tmp26_, "false") != 0;
#line 3146 "contentHandler.c"
	} else {
#line 360 "../src/contentHandler.vala"
		_tmp17_ = FALSE;
#line 3150 "contentHandler.c"
	}
#line 360 "../src/contentHandler.vala"
	if (_tmp17_) {
#line 3154 "contentHandler.c"
		gchar** individualLines = NULL;
		GString* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar** _tmp31_;
		gchar** _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		gint individualLines_length1;
		gint _individualLines_size_;
		gchar** _tmp34_;
		gint _tmp34__length1;
#line 361 "../src/contentHandler.vala"
		_tmp27_ = bookSearchResults;
#line 361 "../src/contentHandler.vala"
		_tmp28_ = _tmp27_->str;
#line 361 "../src/contentHandler.vala"
		_tmp29_ = string_strip (_tmp28_);
#line 361 "../src/contentHandler.vala"
		_tmp30_ = _tmp29_;
#line 361 "../src/contentHandler.vala"
		_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, "\n", -1);
#line 361 "../src/contentHandler.vala"
		_tmp33_ = _tmp32_;
#line 361 "../src/contentHandler.vala"
		_tmp33__length1 = _vala_array_length (_tmp31_);
#line 361 "../src/contentHandler.vala"
		_g_free0 (_tmp30_);
#line 361 "../src/contentHandler.vala"
		individualLines = _tmp33_;
#line 361 "../src/contentHandler.vala"
		individualLines_length1 = _tmp33__length1;
#line 361 "../src/contentHandler.vala"
		_individualLines_size_ = individualLines_length1;
#line 362 "../src/contentHandler.vala"
		_tmp34_ = individualLines;
#line 362 "../src/contentHandler.vala"
		_tmp34__length1 = individualLines_length1;
#line 3194 "contentHandler.c"
		{
			gchar** individualLine_collection = NULL;
			gint individualLine_collection_length1 = 0;
			gint _individualLine_collection_size_ = 0;
			gint individualLine_it = 0;
#line 362 "../src/contentHandler.vala"
			individualLine_collection = _tmp34_;
#line 362 "../src/contentHandler.vala"
			individualLine_collection_length1 = _tmp34__length1;
#line 362 "../src/contentHandler.vala"
			for (individualLine_it = 0; individualLine_it < individualLine_collection_length1; individualLine_it = individualLine_it + 1) {
#line 3206 "contentHandler.c"
				gchar* _tmp35_;
				gchar* individualLine = NULL;
#line 362 "../src/contentHandler.vala"
				_tmp35_ = g_strdup (individualLine_collection[individualLine_it]);
#line 362 "../src/contentHandler.vala"
				individualLine = _tmp35_;
#line 3213 "contentHandler.c"
				{
					GeeTreeMap* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					GString* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					const gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gint _tmp48_;
#line 363 "../src/contentHandler.vala"
					_tmp36_ = bookworm_app_bookworm_searchResultsMap;
#line 363 "../src/contentHandler.vala"
					_tmp37_ = g_strdup_printf ("%i", searchResultCount);
#line 363 "../src/contentHandler.vala"
					_tmp38_ = _tmp37_;
#line 363 "../src/contentHandler.vala"
					_tmp39_ = g_strconcat (_tmp38_, "~~", NULL);
#line 363 "../src/contentHandler.vala"
					_tmp40_ = _tmp39_;
#line 363 "../src/contentHandler.vala"
					_tmp41_ = bookworm_app_bookworm_aContentFileToBeSearched;
#line 363 "../src/contentHandler.vala"
					_tmp42_ = _tmp41_->str;
#line 363 "../src/contentHandler.vala"
					_tmp43_ = g_strconcat (_tmp40_, _tmp42_, NULL);
#line 363 "../src/contentHandler.vala"
					_tmp44_ = _tmp43_;
#line 363 "../src/contentHandler.vala"
					_tmp45_ = individualLine;
#line 363 "../src/contentHandler.vala"
					_tmp46_ = string_strip (_tmp45_);
#line 363 "../src/contentHandler.vala"
					_tmp47_ = _tmp46_;
#line 363 "../src/contentHandler.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, _tmp44_, _tmp47_);
#line 363 "../src/contentHandler.vala"
					_g_free0 (_tmp47_);
#line 363 "../src/contentHandler.vala"
					_g_free0 (_tmp44_);
#line 363 "../src/contentHandler.vala"
					_g_free0 (_tmp40_);
#line 363 "../src/contentHandler.vala"
					_g_free0 (_tmp38_);
#line 368 "../src/contentHandler.vala"
					_tmp48_ = searchResultCount;
#line 368 "../src/contentHandler.vala"
					searchResultCount = _tmp48_ + 1;
#line 362 "../src/contentHandler.vala"
					_g_free0 (individualLine);
#line 3268 "contentHandler.c"
				}
			}
		}
#line 360 "../src/contentHandler.vala"
		individualLines = (_vala_array_free (individualLines, individualLines_length1, (GDestroyNotify) g_free), NULL);
#line 3274 "contentHandler.c"
	}
#line 371 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:371: [END] [FUNCTION:searchHTMLContents]");
#line 346 "../src/contentHandler.vala"
	_g_string_free0 (bookSearchResults);
#line 3280 "contentHandler.c"
}

BookwormAppBook*
bookworm_app_content_handler_controlNavigation (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint currentContentLocation = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	BookwormAppBook* _tmp21_;
	BookwormAppBook* result;
#line 374 "../src/contentHandler.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 375 "../src/contentHandler.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 375 "../src/contentHandler.vala"
	_tmp1_ = _tmp0_;
#line 375 "../src/contentHandler.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:controlNavigation] book.location=", _tmp1_, NULL);
#line 375 "../src/contentHandler.vala"
	_tmp3_ = _tmp2_;
#line 375 "../src/contentHandler.vala"
	g_info ("contentHandler.vala:375: %s", _tmp3_);
#line 375 "../src/contentHandler.vala"
	_g_free0 (_tmp3_);
#line 375 "../src/contentHandler.vala"
	_g_free0 (_tmp1_);
#line 376 "../src/contentHandler.vala"
	currentContentLocation = bookworm_app_book_getBookPageNumber (aBook);
#line 377 "../src/contentHandler.vala"
	_tmp4_ = g_strdup_printf ("%i", currentContentLocation);
#line 377 "../src/contentHandler.vala"
	_tmp5_ = _tmp4_;
#line 377 "../src/contentHandler.vala"
	_tmp6_ = g_strconcat ("In controlNavigation with currentContentLocation=", _tmp5_, NULL);
#line 377 "../src/contentHandler.vala"
	_tmp7_ = _tmp6_;
#line 377 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:377: %s", _tmp7_);
#line 377 "../src/contentHandler.vala"
	_g_free0 (_tmp7_);
#line 377 "../src/contentHandler.vala"
	_g_free0 (_tmp5_);
#line 379 "../src/contentHandler.vala"
	if (currentContentLocation > 0) {
#line 3340 "contentHandler.c"
		GtkButton* _tmp8_;
#line 380 "../src/contentHandler.vala"
		bookworm_app_book_setIfPageBackward (aBook, TRUE);
#line 381 "../src/contentHandler.vala"
		_tmp8_ = bookworm_app_app_window_back_button;
#line 381 "../src/contentHandler.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
#line 3348 "contentHandler.c"
	} else {
		GtkButton* _tmp9_;
#line 383 "../src/contentHandler.vala"
		bookworm_app_book_setIfPageBackward (aBook, FALSE);
#line 384 "../src/contentHandler.vala"
		_tmp9_ = bookworm_app_app_window_back_button;
#line 384 "../src/contentHandler.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
#line 3357 "contentHandler.c"
	}
#line 387 "../src/contentHandler.vala"
	_tmp10_ = bookworm_app_book_getBookContentList (aBook);
#line 387 "../src/contentHandler.vala"
	_tmp11_ = _tmp10_;
#line 387 "../src/contentHandler.vala"
	_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
#line 387 "../src/contentHandler.vala"
	_tmp13_ = _tmp12_;
#line 387 "../src/contentHandler.vala"
	_tmp14_ = currentContentLocation < (_tmp13_ - 1);
#line 387 "../src/contentHandler.vala"
	_g_object_unref0 (_tmp11_);
#line 387 "../src/contentHandler.vala"
	if (_tmp14_) {
#line 3373 "contentHandler.c"
		GtkButton* _tmp15_;
#line 388 "../src/contentHandler.vala"
		bookworm_app_book_setIfPageForward (aBook, TRUE);
#line 389 "../src/contentHandler.vala"
		_tmp15_ = bookworm_app_app_window_forward_button;
#line 389 "../src/contentHandler.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, TRUE);
#line 3381 "contentHandler.c"
	} else {
		GtkButton* _tmp16_;
#line 391 "../src/contentHandler.vala"
		bookworm_app_book_setIfPageForward (aBook, FALSE);
#line 392 "../src/contentHandler.vala"
		_tmp16_ = bookworm_app_app_window_forward_button;
#line 392 "../src/contentHandler.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, FALSE);
#line 3390 "contentHandler.c"
	}
#line 394 "../src/contentHandler.vala"
	_tmp17_ = bookworm_app_book_getBookLocation (aBook);
#line 394 "../src/contentHandler.vala"
	_tmp18_ = _tmp17_;
#line 394 "../src/contentHandler.vala"
	_tmp19_ = g_strconcat ("[END] [FUNCTION:controlNavigation] book.location=", _tmp18_, NULL);
#line 394 "../src/contentHandler.vala"
	_tmp20_ = _tmp19_;
#line 394 "../src/contentHandler.vala"
	g_info ("contentHandler.vala:394: %s", _tmp20_);
#line 394 "../src/contentHandler.vala"
	_g_free0 (_tmp20_);
#line 394 "../src/contentHandler.vala"
	_g_free0 (_tmp18_);
#line 395 "../src/contentHandler.vala"
	_tmp21_ = _bookworm_app_book_ref0 (aBook);
#line 395 "../src/contentHandler.vala"
	result = _tmp21_;
#line 395 "../src/contentHandler.vala"
	_bookworm_app_book_unref0 (aBook);
#line 395 "../src/contentHandler.vala"
	return result;
#line 3414 "contentHandler.c"
}

void
bookworm_app_content_handler_refreshCurrentPage (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 400 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:400: [START] [FUNCTION:refreshCurrentPage]");
#line 401 "../src/contentHandler.vala"
	_tmp0_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 401 "../src/contentHandler.vala"
	_tmp1_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 401 "../src/contentHandler.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 3430 "contentHandler.c"
		BookwormAppBook* currentBookForRefresh = NULL;
		GeeHashMap* _tmp2_;
		const gchar* _tmp3_;
		gpointer _tmp4_;
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_;
		gchar* _tmp8_;
		BookwormAppBook* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		BookwormAppBook* _tmp12_;
#line 402 "../src/contentHandler.vala"
		_tmp2_ = bookworm_app_bookworm_libraryViewMap;
#line 402 "../src/contentHandler.vala"
		_tmp3_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 402 "../src/contentHandler.vala"
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 402 "../src/contentHandler.vala"
		currentBookForRefresh = (BookwormAppBook*) _tmp4_;
#line 405 "../src/contentHandler.vala"
		bookworm_app_bookworm_isPageScrollRequired = TRUE;
#line 406 "../src/contentHandler.vala"
		_tmp5_ = bookworm_app_bookworm_libraryViewMap;
#line 406 "../src/contentHandler.vala"
		_tmp6_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 406 "../src/contentHandler.vala"
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 406 "../src/contentHandler.vala"
		_tmp8_ = g_strdup ("");
#line 406 "../src/contentHandler.vala"
		_tmp9_ = bookworm_app_content_handler_renderPage ((BookwormAppBook*) _tmp7_, _tmp8_);
#line 406 "../src/contentHandler.vala"
		_bookworm_app_book_unref0 (currentBookForRefresh);
#line 406 "../src/contentHandler.vala"
		currentBookForRefresh = _tmp9_;
#line 410 "../src/contentHandler.vala"
		_tmp10_ = bookworm_app_bookworm_libraryViewMap;
#line 410 "../src/contentHandler.vala"
		_tmp11_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 410 "../src/contentHandler.vala"
		_tmp12_ = currentBookForRefresh;
#line 410 "../src/contentHandler.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp11_, _tmp12_);
#line 401 "../src/contentHandler.vala"
		_bookworm_app_book_unref0 (currentBookForRefresh);
#line 3477 "contentHandler.c"
	}
#line 415 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:415: [END] [FUNCTION:refreshCurrentPage]");
#line 3481 "contentHandler.c"
}

gint
bookworm_app_content_handler_getScrollPos (void)
{
	gint scrollPos = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint result;
#line 419 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:419: [START] [FUNCTION:getScrollPos]");
#line 425 "../src/contentHandler.vala"
	scrollPos = -1;
#line 426 "../src/contentHandler.vala"
	_tmp0_ = bookworm_app_utils_setWebViewTitle ("document.title = window.scrollY;");
#line 426 "../src/contentHandler.vala"
	_tmp1_ = _tmp0_;
#line 426 "../src/contentHandler.vala"
	scrollPos = atoi (_tmp1_);
#line 426 "../src/contentHandler.vala"
	_g_free0 (_tmp1_);
#line 427 "../src/contentHandler.vala"
	_tmp2_ = g_strdup_printf ("%i", scrollPos);
#line 427 "../src/contentHandler.vala"
	_tmp3_ = _tmp2_;
#line 427 "../src/contentHandler.vala"
	_tmp4_ = g_strconcat ("[START] [FUNCTION:getScrollPos] scrollPos=", _tmp3_, NULL);
#line 427 "../src/contentHandler.vala"
	_tmp5_ = _tmp4_;
#line 427 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:427: %s", _tmp5_);
#line 427 "../src/contentHandler.vala"
	_g_free0 (_tmp5_);
#line 427 "../src/contentHandler.vala"
	_g_free0 (_tmp3_);
#line 428 "../src/contentHandler.vala"
	result = scrollPos;
#line 428 "../src/contentHandler.vala"
	return result;
#line 3525 "contentHandler.c"
}

void
bookworm_app_content_handler_performStartUpActions (void)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
#line 432 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:432: [START] [FUNCTION:performStartUpActions]");
#line 435 "../src/contentHandler.vala"
	_tmp2_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 435 "../src/contentHandler.vala"
	_tmp2__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 435 "../src/contentHandler.vala"
	if (_tmp2__length1 == 2) {
#line 3543 "contentHandler.c"
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
#line 437 "../src/contentHandler.vala"
		_tmp3_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 437 "../src/contentHandler.vala"
		_tmp3__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 437 "../src/contentHandler.vala"
		_tmp4_ = _tmp3_[0];
#line 437 "../src/contentHandler.vala"
		_tmp1_ = g_strcmp0 (BOOKWORM_APP_CONSTANTS_bookworm_id, _tmp4_) == 0;
#line 3555 "contentHandler.c"
	} else {
#line 435 "../src/contentHandler.vala"
		_tmp1_ = FALSE;
#line 3559 "contentHandler.c"
	}
#line 435 "../src/contentHandler.vala"
	if (_tmp1_) {
#line 3563 "contentHandler.c"
		GString* _tmp5_;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
#line 439 "../src/contentHandler.vala"
		_tmp5_ = bookworm_app_bookworm_pathsOfBooksNotAddedStr;
#line 439 "../src/contentHandler.vala"
		_tmp6_ = _tmp5_->str;
#line 439 "../src/contentHandler.vala"
		_tmp7_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 439 "../src/contentHandler.vala"
		_tmp7__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 439 "../src/contentHandler.vala"
		_tmp8_ = _tmp7_[1];
#line 439 "../src/contentHandler.vala"
		_tmp0_ = string_index_of (_tmp6_, _tmp8_, 0) == -1;
#line 3581 "contentHandler.c"
	} else {
#line 435 "../src/contentHandler.vala"
		_tmp0_ = FALSE;
#line 3585 "contentHandler.c"
	}
#line 435 "../src/contentHandler.vala"
	if (_tmp0_) {
#line 3589 "contentHandler.c"
		BookwormAppBook* requestedBook = NULL;
		GString* _tmp9_;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		BookwormAppBook* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		BookwormAppBook* _tmp47_;
#line 442 "../src/contentHandler.vala"
		requestedBook = NULL;
#line 444 "../src/contentHandler.vala"
		_tmp9_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 444 "../src/contentHandler.vala"
		_tmp10_ = _tmp9_->str;
#line 444 "../src/contentHandler.vala"
		_tmp11_ = bookworm_app_bookworm_commandLineArgs;
#line 444 "../src/contentHandler.vala"
		_tmp11__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 444 "../src/contentHandler.vala"
		_tmp12_ = _tmp11_[1];
#line 444 "../src/contentHandler.vala"
		_tmp13_ = string_strip (_tmp12_);
#line 444 "../src/contentHandler.vala"
		_tmp14_ = _tmp13_;
#line 444 "../src/contentHandler.vala"
		_tmp15_ = string_index_of (_tmp10_, _tmp14_, 0) != -1;
#line 444 "../src/contentHandler.vala"
		_g_free0 (_tmp14_);
#line 444 "../src/contentHandler.vala"
		if (_tmp15_) {
#line 3629 "contentHandler.c"
			{
				GeeArrayList* _aBook_list = NULL;
				GeeArrayList* _tmp16_;
				gint _aBook_size = 0;
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _aBook_index = 0;
#line 449 "../src/contentHandler.vala"
				_tmp16_ = bookworm_app_library_listOfBooksInLibraryOnLoad;
#line 449 "../src/contentHandler.vala"
				_aBook_list = _tmp16_;
#line 449 "../src/contentHandler.vala"
				_tmp17_ = _aBook_list;
#line 449 "../src/contentHandler.vala"
				_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
#line 449 "../src/contentHandler.vala"
				_tmp19_ = _tmp18_;
#line 449 "../src/contentHandler.vala"
				_aBook_size = _tmp19_;
#line 449 "../src/contentHandler.vala"
				_aBook_index = -1;
#line 449 "../src/contentHandler.vala"
				while (TRUE) {
#line 3654 "contentHandler.c"
					gint _tmp20_;
					gint _tmp21_;
					BookwormAppBook* aBook = NULL;
					GeeArrayList* _tmp22_;
					gpointer _tmp23_;
					gchar** _tmp24_;
					gint _tmp24__length1;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					BookwormAppBook* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gboolean _tmp31_;
#line 449 "../src/contentHandler.vala"
					_aBook_index = _aBook_index + 1;
#line 449 "../src/contentHandler.vala"
					_tmp20_ = _aBook_index;
#line 449 "../src/contentHandler.vala"
					_tmp21_ = _aBook_size;
#line 449 "../src/contentHandler.vala"
					if (!(_tmp20_ < _tmp21_)) {
#line 449 "../src/contentHandler.vala"
						break;
#line 3679 "contentHandler.c"
					}
#line 449 "../src/contentHandler.vala"
					_tmp22_ = _aBook_list;
#line 449 "../src/contentHandler.vala"
					_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _aBook_index);
#line 449 "../src/contentHandler.vala"
					aBook = (BookwormAppBook*) _tmp23_;
#line 450 "../src/contentHandler.vala"
					_tmp24_ = bookworm_app_bookworm_commandLineArgs;
#line 450 "../src/contentHandler.vala"
					_tmp24__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 450 "../src/contentHandler.vala"
					_tmp25_ = _tmp24_[1];
#line 450 "../src/contentHandler.vala"
					_tmp26_ = string_strip (_tmp25_);
#line 450 "../src/contentHandler.vala"
					_tmp27_ = _tmp26_;
#line 450 "../src/contentHandler.vala"
					_tmp28_ = aBook;
#line 450 "../src/contentHandler.vala"
					_tmp29_ = bookworm_app_book_getBookLocation (_tmp28_);
#line 450 "../src/contentHandler.vala"
					_tmp30_ = _tmp29_;
#line 450 "../src/contentHandler.vala"
					_tmp31_ = g_strcmp0 (_tmp27_, _tmp30_) == 0;
#line 450 "../src/contentHandler.vala"
					_g_free0 (_tmp30_);
#line 450 "../src/contentHandler.vala"
					_g_free0 (_tmp27_);
#line 450 "../src/contentHandler.vala"
					if (_tmp31_) {
#line 3711 "contentHandler.c"
						BookwormAppBook* _tmp32_;
						BookwormAppBook* _tmp33_;
#line 451 "../src/contentHandler.vala"
						_tmp32_ = aBook;
#line 451 "../src/contentHandler.vala"
						_tmp33_ = _bookworm_app_book_ref0 (_tmp32_);
#line 451 "../src/contentHandler.vala"
						_bookworm_app_book_unref0 (requestedBook);
#line 451 "../src/contentHandler.vala"
						requestedBook = _tmp33_;
#line 452 "../src/contentHandler.vala"
						_bookworm_app_book_unref0 (aBook);
#line 452 "../src/contentHandler.vala"
						break;
#line 3726 "contentHandler.c"
					}
#line 449 "../src/contentHandler.vala"
					_bookworm_app_book_unref0 (aBook);
#line 3730 "contentHandler.c"
				}
			}
		} else {
			GeeHashMap* _tmp34_;
			gchar** _tmp35_;
			gint _tmp35__length1;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gpointer _tmp39_;
#line 458 "../src/contentHandler.vala"
			_tmp34_ = bookworm_app_bookworm_libraryViewMap;
#line 458 "../src/contentHandler.vala"
			_tmp35_ = bookworm_app_bookworm_commandLineArgs;
#line 458 "../src/contentHandler.vala"
			_tmp35__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 458 "../src/contentHandler.vala"
			_tmp36_ = _tmp35_[1];
#line 458 "../src/contentHandler.vala"
			_tmp37_ = string_strip (_tmp36_);
#line 458 "../src/contentHandler.vala"
			_tmp38_ = _tmp37_;
#line 458 "../src/contentHandler.vala"
			_tmp39_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp34_, _tmp38_);
#line 458 "../src/contentHandler.vala"
			_bookworm_app_book_unref0 (requestedBook);
#line 458 "../src/contentHandler.vala"
			requestedBook = (BookwormAppBook*) _tmp39_;
#line 458 "../src/contentHandler.vala"
			_g_free0 (_tmp38_);
#line 3761 "contentHandler.c"
		}
#line 460 "../src/contentHandler.vala"
		_tmp40_ = requestedBook;
#line 460 "../src/contentHandler.vala"
		_tmp41_ = bookworm_app_book_getBookLocation (_tmp40_);
#line 460 "../src/contentHandler.vala"
		_tmp42_ = _tmp41_;
#line 460 "../src/contentHandler.vala"
		_tmp43_ = g_strconcat ("Bookworm opened for single book[", _tmp42_, NULL);
#line 460 "../src/contentHandler.vala"
		_tmp44_ = _tmp43_;
#line 460 "../src/contentHandler.vala"
		_tmp45_ = g_strconcat (_tmp44_, "] - proceed to reading view...", NULL);
#line 460 "../src/contentHandler.vala"
		_tmp46_ = _tmp45_;
#line 460 "../src/contentHandler.vala"
		g_debug ("contentHandler.vala:460: %s", _tmp46_);
#line 460 "../src/contentHandler.vala"
		_g_free0 (_tmp46_);
#line 460 "../src/contentHandler.vala"
		_g_free0 (_tmp44_);
#line 460 "../src/contentHandler.vala"
		_g_free0 (_tmp42_);
#line 461 "../src/contentHandler.vala"
		_tmp47_ = requestedBook;
#line 461 "../src/contentHandler.vala"
		if (_tmp47_ != NULL) {
#line 3789 "contentHandler.c"
			gchar** _tmp48_;
			gint _tmp48__length1;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			BookwormAppBook* _tmp51_;
			BookwormAppBook* _tmp52_;
#line 463 "../src/contentHandler.vala"
			_tmp48_ = bookworm_app_bookworm_commandLineArgs;
#line 463 "../src/contentHandler.vala"
			_tmp48__length1 = bookworm_app_bookworm_commandLineArgs_length1;
#line 463 "../src/contentHandler.vala"
			_tmp49_ = _tmp48_[1];
#line 463 "../src/contentHandler.vala"
			_tmp50_ = string_strip (_tmp49_);
#line 463 "../src/contentHandler.vala"
			_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 463 "../src/contentHandler.vala"
			bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp50_;
#line 465 "../src/contentHandler.vala"
			_tmp51_ = requestedBook;
#line 465 "../src/contentHandler.vala"
			_tmp52_ = _bookworm_app_book_ref0 (_tmp51_);
#line 465 "../src/contentHandler.vala"
			bookworm_app_bookworm_readSelectedBook (_tmp52_);
#line 3814 "contentHandler.c"
		}
#line 435 "../src/contentHandler.vala"
		_bookworm_app_book_unref0 (requestedBook);
#line 3818 "contentHandler.c"
	} else {
		gboolean _tmp53_ = FALSE;
		BookwormAppSettings* _tmp54_;
		gboolean _tmp55_;
		gboolean _tmp56_;
#line 469 "../src/contentHandler.vala"
		_tmp54_ = bookworm_app_bookworm_settings;
#line 469 "../src/contentHandler.vala"
		_tmp55_ = bookworm_app_settings_get_is_show_library_on_start (_tmp54_);
#line 469 "../src/contentHandler.vala"
		_tmp56_ = _tmp55_;
#line 469 "../src/contentHandler.vala"
		if (!_tmp56_) {
#line 3832 "contentHandler.c"
			BookwormAppSettings* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
#line 469 "../src/contentHandler.vala"
			_tmp57_ = bookworm_app_bookworm_settings;
#line 469 "../src/contentHandler.vala"
			_tmp58_ = bookworm_app_settings_get_book_being_read (_tmp57_);
#line 469 "../src/contentHandler.vala"
			_tmp59_ = _tmp58_;
#line 469 "../src/contentHandler.vala"
			_tmp53_ = g_strcmp0 (_tmp59_, "") != 0;
#line 3844 "contentHandler.c"
		} else {
#line 469 "../src/contentHandler.vala"
			_tmp53_ = FALSE;
#line 3848 "contentHandler.c"
		}
#line 469 "../src/contentHandler.vala"
		if (_tmp53_) {
#line 3852 "contentHandler.c"
			BookwormAppBook* lastReadBook = NULL;
			BookwormAppSettings* _tmp60_;
			const gchar* _tmp61_;
			const gchar* _tmp62_;
			BookwormAppBook* _tmp63_;
			gboolean _tmp64_ = FALSE;
			BookwormAppBook* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gboolean _tmp68_;
#line 471 "../src/contentHandler.vala"
			_tmp60_ = bookworm_app_bookworm_settings;
#line 471 "../src/contentHandler.vala"
			_tmp61_ = bookworm_app_settings_get_book_being_read (_tmp60_);
#line 471 "../src/contentHandler.vala"
			_tmp62_ = _tmp61_;
#line 471 "../src/contentHandler.vala"
			_tmp63_ = bookworm_app_db_getBookFromDB (_tmp62_);
#line 471 "../src/contentHandler.vala"
			lastReadBook = _tmp63_;
#line 472 "../src/contentHandler.vala"
			_tmp65_ = lastReadBook;
#line 472 "../src/contentHandler.vala"
			_tmp66_ = bookworm_app_book_getBookLocation (_tmp65_);
#line 472 "../src/contentHandler.vala"
			_tmp67_ = _tmp66_;
#line 472 "../src/contentHandler.vala"
			_tmp68_ = _tmp67_ != NULL;
#line 472 "../src/contentHandler.vala"
			_g_free0 (_tmp67_);
#line 472 "../src/contentHandler.vala"
			if (_tmp68_) {
#line 3885 "contentHandler.c"
				BookwormAppBook* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
#line 472 "../src/contentHandler.vala"
				_tmp69_ = lastReadBook;
#line 472 "../src/contentHandler.vala"
				_tmp70_ = bookworm_app_book_getBookLocation (_tmp69_);
#line 472 "../src/contentHandler.vala"
				_tmp71_ = _tmp70_;
#line 472 "../src/contentHandler.vala"
				_tmp72_ = strlen (_tmp71_);
#line 472 "../src/contentHandler.vala"
				_tmp73_ = _tmp72_;
#line 472 "../src/contentHandler.vala"
				_tmp64_ = _tmp73_ > 1;
#line 472 "../src/contentHandler.vala"
				_g_free0 (_tmp71_);
#line 3905 "contentHandler.c"
			} else {
#line 472 "../src/contentHandler.vala"
				_tmp64_ = FALSE;
#line 3909 "contentHandler.c"
			}
#line 472 "../src/contentHandler.vala"
			if (_tmp64_) {
#line 3913 "contentHandler.c"
				BookwormAppSettings* _tmp74_;
				const gchar* _tmp75_;
				const gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				BookwormAppSettings* _tmp81_;
				const gchar* _tmp82_;
				const gchar* _tmp83_;
				gchar* _tmp84_;
				BookwormAppBook* _tmp85_;
				BookwormAppBook* _tmp86_;
#line 473 "../src/contentHandler.vala"
				_tmp74_ = bookworm_app_bookworm_settings;
#line 473 "../src/contentHandler.vala"
				_tmp75_ = bookworm_app_settings_get_book_being_read (_tmp74_);
#line 473 "../src/contentHandler.vala"
				_tmp76_ = _tmp75_;
#line 473 "../src/contentHandler.vala"
				_tmp77_ = g_strconcat ("Opening the last read book [", _tmp76_, NULL);
#line 473 "../src/contentHandler.vala"
				_tmp78_ = _tmp77_;
#line 473 "../src/contentHandler.vala"
				_tmp79_ = g_strconcat (_tmp78_, "]", NULL);
#line 473 "../src/contentHandler.vala"
				_tmp80_ = _tmp79_;
#line 473 "../src/contentHandler.vala"
				g_debug ("contentHandler.vala:473: %s", _tmp80_);
#line 473 "../src/contentHandler.vala"
				_g_free0 (_tmp80_);
#line 473 "../src/contentHandler.vala"
				_g_free0 (_tmp78_);
#line 474 "../src/contentHandler.vala"
				_tmp81_ = bookworm_app_bookworm_settings;
#line 474 "../src/contentHandler.vala"
				_tmp82_ = bookworm_app_settings_get_book_being_read (_tmp81_);
#line 474 "../src/contentHandler.vala"
				_tmp83_ = _tmp82_;
#line 474 "../src/contentHandler.vala"
				_tmp84_ = g_strdup (_tmp83_);
#line 474 "../src/contentHandler.vala"
				_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 474 "../src/contentHandler.vala"
				bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp84_;
#line 476 "../src/contentHandler.vala"
				_tmp85_ = lastReadBook;
#line 476 "../src/contentHandler.vala"
				_tmp86_ = _bookworm_app_book_ref0 (_tmp85_);
#line 476 "../src/contentHandler.vala"
				bookworm_app_bookworm_readSelectedBook (_tmp86_);
#line 3965 "contentHandler.c"
			} else {
				BookwormAppSettings* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
#line 478 "../src/contentHandler.vala"
				_tmp87_ = bookworm_app_bookworm_settings;
#line 478 "../src/contentHandler.vala"
				_tmp88_ = bookworm_app_settings_get_book_being_read (_tmp87_);
#line 478 "../src/contentHandler.vala"
				_tmp89_ = _tmp88_;
#line 478 "../src/contentHandler.vala"
				_tmp90_ = g_strconcat ("The last read book [", _tmp89_, NULL);
#line 478 "../src/contentHandler.vala"
				_tmp91_ = _tmp90_;
#line 478 "../src/contentHandler.vala"
				_tmp92_ = g_strconcat (_tmp91_, "] was not found in the library, so showing the library view instead of" \
" opening the last read book", NULL);
#line 478 "../src/contentHandler.vala"
				_tmp93_ = _tmp92_;
#line 478 "../src/contentHandler.vala"
				g_warning ("contentHandler.vala:478: %s", _tmp93_);
#line 478 "../src/contentHandler.vala"
				_g_free0 (_tmp93_);
#line 478 "../src/contentHandler.vala"
				_g_free0 (_tmp91_);
#line 3994 "contentHandler.c"
			}
#line 469 "../src/contentHandler.vala"
			_bookworm_app_book_unref0 (lastReadBook);
#line 3998 "contentHandler.c"
		}
	}
#line 482 "../src/contentHandler.vala"
	g_debug ("contentHandler.vala:482: [END] [FUNCTION:performStartUpActions]");
#line 4003 "contentHandler.c"
}

BookwormAppcontentHandler*
bookworm_app_content_handler_construct (GType object_type)
{
	BookwormAppcontentHandler* self = NULL;
#line 22 "../src/contentHandler.vala"
	self = (BookwormAppcontentHandler*) g_type_create_instance (object_type);
#line 22 "../src/contentHandler.vala"
	return self;
#line 4014 "contentHandler.c"
}

BookwormAppcontentHandler*
bookworm_app_content_handler_new (void)
{
#line 22 "../src/contentHandler.vala"
	return bookworm_app_content_handler_construct (BOOKWORM_APP_TYPE_CONTENT_HANDLER);
#line 4022 "contentHandler.c"
}

static void
bookworm_app_value_content_handler_init (GValue* value)
{
#line 22 "../src/contentHandler.vala"
	value->data[0].v_pointer = NULL;
#line 4030 "contentHandler.c"
}

static void
bookworm_app_value_content_handler_free_value (GValue* value)
{
#line 22 "../src/contentHandler.vala"
	if (value->data[0].v_pointer) {
#line 22 "../src/contentHandler.vala"
		bookworm_app_content_handler_unref (value->data[0].v_pointer);
#line 4040 "contentHandler.c"
	}
}

static void
bookworm_app_value_content_handler_copy_value (const GValue* src_value,
                                               GValue* dest_value)
{
#line 22 "../src/contentHandler.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../src/contentHandler.vala"
		dest_value->data[0].v_pointer = bookworm_app_content_handler_ref (src_value->data[0].v_pointer);
#line 4052 "contentHandler.c"
	} else {
#line 22 "../src/contentHandler.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4056 "contentHandler.c"
	}
}

static gpointer
bookworm_app_value_content_handler_peek_pointer (const GValue* value)
{
#line 22 "../src/contentHandler.vala"
	return value->data[0].v_pointer;
#line 4065 "contentHandler.c"
}

static gchar*
bookworm_app_value_content_handler_collect_value (GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
#line 22 "../src/contentHandler.vala"
	if (collect_values[0].v_pointer) {
#line 4076 "contentHandler.c"
		BookwormAppcontentHandler * object;
		object = collect_values[0].v_pointer;
#line 22 "../src/contentHandler.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../src/contentHandler.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4083 "contentHandler.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../src/contentHandler.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4087 "contentHandler.c"
		}
#line 22 "../src/contentHandler.vala"
		value->data[0].v_pointer = bookworm_app_content_handler_ref (object);
#line 4091 "contentHandler.c"
	} else {
#line 22 "../src/contentHandler.vala"
		value->data[0].v_pointer = NULL;
#line 4095 "contentHandler.c"
	}
#line 22 "../src/contentHandler.vala"
	return NULL;
#line 4099 "contentHandler.c"
}

static gchar*
bookworm_app_value_content_handler_lcopy_value (const GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	BookwormAppcontentHandler ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../src/contentHandler.vala"
	if (!object_p) {
#line 22 "../src/contentHandler.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4114 "contentHandler.c"
	}
#line 22 "../src/contentHandler.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../src/contentHandler.vala"
		*object_p = NULL;
#line 4120 "contentHandler.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../src/contentHandler.vala"
		*object_p = value->data[0].v_pointer;
#line 4124 "contentHandler.c"
	} else {
#line 22 "../src/contentHandler.vala"
		*object_p = bookworm_app_content_handler_ref (value->data[0].v_pointer);
#line 4128 "contentHandler.c"
	}
#line 22 "../src/contentHandler.vala"
	return NULL;
#line 4132 "contentHandler.c"
}

GParamSpec*
bookworm_app_param_spec_content_handler (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags)
{
	BookwormAppParamSpeccontentHandler* spec;
#line 22 "../src/contentHandler.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_CONTENT_HANDLER), NULL);
#line 22 "../src/contentHandler.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../src/contentHandler.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../src/contentHandler.vala"
	return G_PARAM_SPEC (spec);
#line 4151 "contentHandler.c"
}

gpointer
bookworm_app_value_get_content_handler (const GValue* value)
{
#line 22 "../src/contentHandler.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_CONTENT_HANDLER), NULL);
#line 22 "../src/contentHandler.vala"
	return value->data[0].v_pointer;
#line 4161 "contentHandler.c"
}

void
bookworm_app_value_set_content_handler (GValue* value,
                                        gpointer v_object)
{
	BookwormAppcontentHandler * old;
#line 22 "../src/contentHandler.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_CONTENT_HANDLER));
#line 22 "../src/contentHandler.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/contentHandler.vala"
	if (v_object) {
#line 22 "../src/contentHandler.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_CONTENT_HANDLER));
#line 22 "../src/contentHandler.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/contentHandler.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../src/contentHandler.vala"
		bookworm_app_content_handler_ref (value->data[0].v_pointer);
#line 4183 "contentHandler.c"
	} else {
#line 22 "../src/contentHandler.vala"
		value->data[0].v_pointer = NULL;
#line 4187 "contentHandler.c"
	}
#line 22 "../src/contentHandler.vala"
	if (old) {
#line 22 "../src/contentHandler.vala"
		bookworm_app_content_handler_unref (old);
#line 4193 "contentHandler.c"
	}
}

void
bookworm_app_value_take_content_handler (GValue* value,
                                         gpointer v_object)
{
	BookwormAppcontentHandler * old;
#line 22 "../src/contentHandler.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_CONTENT_HANDLER));
#line 22 "../src/contentHandler.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/contentHandler.vala"
	if (v_object) {
#line 22 "../src/contentHandler.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_CONTENT_HANDLER));
#line 22 "../src/contentHandler.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/contentHandler.vala"
		value->data[0].v_pointer = v_object;
#line 4214 "contentHandler.c"
	} else {
#line 22 "../src/contentHandler.vala"
		value->data[0].v_pointer = NULL;
#line 4218 "contentHandler.c"
	}
#line 22 "../src/contentHandler.vala"
	if (old) {
#line 22 "../src/contentHandler.vala"
		bookworm_app_content_handler_unref (old);
#line 4224 "contentHandler.c"
	}
}

static void
bookworm_app_content_handler_class_init (BookwormAppcontentHandlerClass * klass,
                                         gpointer klass_data)
{
#line 22 "../src/contentHandler.vala"
	bookworm_app_content_handler_parent_class = g_type_class_peek_parent (klass);
#line 22 "../src/contentHandler.vala"
	((BookwormAppcontentHandlerClass *) klass)->finalize = bookworm_app_content_handler_finalize;
#line 4236 "contentHandler.c"
}

static void
bookworm_app_content_handler_instance_init (BookwormAppcontentHandler * self,
                                            gpointer klass)
{
#line 22 "../src/contentHandler.vala"
	self->ref_count = 1;
#line 4245 "contentHandler.c"
}

static void
bookworm_app_content_handler_finalize (BookwormAppcontentHandler * obj)
{
	BookwormAppcontentHandler * self;
#line 22 "../src/contentHandler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_CONTENT_HANDLER, BookwormAppcontentHandler);
#line 22 "../src/contentHandler.vala"
	g_signal_handlers_destroy (self);
#line 4256 "contentHandler.c"
}

static GType
bookworm_app_content_handler_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_content_handler_init, bookworm_app_value_content_handler_free_value, bookworm_app_value_content_handler_copy_value, bookworm_app_value_content_handler_peek_pointer, "p", bookworm_app_value_content_handler_collect_value, "p", bookworm_app_value_content_handler_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppcontentHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_content_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppcontentHandler), 0, (GInstanceInitFunc) bookworm_app_content_handler_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_content_handler_type_id;
	bookworm_app_content_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppcontentHandler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_content_handler_type_id;
}

GType
bookworm_app_content_handler_get_type (void)
{
	static volatile gsize bookworm_app_content_handler_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_content_handler_type_id__once)) {
		GType bookworm_app_content_handler_type_id;
		bookworm_app_content_handler_type_id = bookworm_app_content_handler_get_type_once ();
		g_once_init_leave (&bookworm_app_content_handler_type_id__once, bookworm_app_content_handler_type_id);
	}
	return bookworm_app_content_handler_type_id__once;
}

gpointer
bookworm_app_content_handler_ref (gpointer instance)
{
	BookwormAppcontentHandler * self;
	self = instance;
#line 22 "../src/contentHandler.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../src/contentHandler.vala"
	return instance;
#line 4291 "contentHandler.c"
}

void
bookworm_app_content_handler_unref (gpointer instance)
{
	BookwormAppcontentHandler * self;
	self = instance;
#line 22 "../src/contentHandler.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../src/contentHandler.vala"
		BOOKWORM_APP_CONTENT_HANDLER_GET_CLASS (self)->finalize (self);
#line 22 "../src/contentHandler.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4305 "contentHandler.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

