/* window.c generated by valac 0.56.17, the Vala compiler
 * generated from window.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *               2019 ~ 2020 Gary Wang
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 *             Gary Wang <wzc782970009@gmail.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <stdio.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <libwnck/libwnck.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;

#define WIDGETS_TYPE_WINDOW (widgets_window_get_type ())
#define WIDGETS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WINDOW, WidgetsWindow))
#define WIDGETS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WINDOW, WidgetsWindowClass))
#define WIDGETS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WINDOW))
#define WIDGETS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WINDOW))
#define WIDGETS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WINDOW, WidgetsWindowClass))

typedef struct _WidgetsWindow WidgetsWindow;
typedef struct _WidgetsWindowClass WidgetsWindowClass;
typedef struct _WidgetsWindowPrivate WidgetsWindowPrivate;

#define WIDGETS_TYPE_RESIZE_GRIP (widgets_resize_grip_get_type ())
#define WIDGETS_RESIZE_GRIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_RESIZE_GRIP, WidgetsResizeGrip))
#define WIDGETS_RESIZE_GRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_RESIZE_GRIP, WidgetsResizeGripClass))
#define WIDGETS_IS_RESIZE_GRIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_RESIZE_GRIP))
#define WIDGETS_IS_RESIZE_GRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_RESIZE_GRIP))
#define WIDGETS_RESIZE_GRIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_RESIZE_GRIP, WidgetsResizeGripClass))

typedef struct _WidgetsResizeGrip WidgetsResizeGrip;
typedef struct _WidgetsResizeGripClass WidgetsResizeGripClass;
enum  {
	WIDGETS_WINDOW_0_PROPERTY,
	WIDGETS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* widgets_window_properties[WIDGETS_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block49Data Block49Data;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))

#define WIDGETS_TYPE_APPBAR (widgets_appbar_get_type ())
#define WIDGETS_APPBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_APPBAR, WidgetsAppbar))
#define WIDGETS_APPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_APPBAR, WidgetsAppbarClass))
#define WIDGETS_IS_APPBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_APPBAR))
#define WIDGETS_IS_APPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_APPBAR))
#define WIDGETS_APPBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_APPBAR, WidgetsAppbarClass))

typedef struct _WidgetsAppbar WidgetsAppbar;
typedef struct _WidgetsAppbarClass WidgetsAppbarClass;
typedef struct _Block50Data Block50Data;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;

#define TYPE_TERMINAL_APP (terminal_app_get_type ())
#define TERMINAL_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TERMINAL_APP, TerminalApp))
#define TERMINAL_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TERMINAL_APP, TerminalAppClass))
#define IS_TERMINAL_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TERMINAL_APP))
#define IS_TERMINAL_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TERMINAL_APP))
#define TERMINAL_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TERMINAL_APP, TerminalAppClass))

typedef struct _TerminalApp TerminalApp;
typedef struct _TerminalAppClass TerminalAppClass;

#define WIDGETS_TYPE_TABBAR (widgets_tabbar_get_type ())
#define WIDGETS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbar))
#define WIDGETS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))
#define WIDGETS_IS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TABBAR))
#define WIDGETS_IS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TABBAR))
#define WIDGETS_TABBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))

typedef struct _WidgetsTabbar WidgetsTabbar;
typedef struct _WidgetsTabbarClass WidgetsTabbarClass;
typedef struct _Block51Data Block51Data;

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _WidgetsWindow {
	WidgetsConfigWindow parent_instance;
	WidgetsWindowPrivate * priv;
	GdkRGBA top_line_dark_color;
	GdkRGBA top_line_light_color;
	GtkBox* fullscreen_box;
	GtkBox* spacing_box;
	gboolean draw_tabbar_line;
	gdouble window_default_scale;
	gint window_frame_margin_bottom;
	gint window_frame_margin_end;
	gint window_frame_margin_start;
	gint window_frame_margin_top;
	gboolean tabbar_at_the_bottom;
	gint window_fullscreen_monitor_height;
	gint window_fullscreen_monitor_timeout;
	gint window_fullscreen_response_height;
	gint window_height;
	gint window_widget_margin_bottom;
	gint window_widget_margin_end;
	gint window_widget_margin_start;
	gint window_widget_margin_top;
	gint window_width;
};

struct _WidgetsWindowClass {
	WidgetsConfigWindowClass parent_class;
	void (*draw_window_below) (WidgetsWindow* self, cairo_t* cr);
};

struct _WidgetsWindowPrivate {
	WidgetsResizeGrip* resize_grip;
};

struct _Block49Data {
	int _ref_count_;
	WidgetsWindow* self;
	GdkRectangle rect;
	gchar* window_mode;
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

struct _Block50Data {
	int _ref_count_;
	WidgetsWindow* self;
	WidgetsAppbar* appbar;
};

struct _Block51Data {
	int _ref_count_;
	WidgetsWindow* self;
	WidgetsAppbar* appbar;
};

static gint WidgetsWindow_private_offset;
static gpointer widgets_window_parent_class = NULL;
VALA_EXTERN gint constant_TITLEBAR_HEIGHT;
VALA_EXTERN gint constant_RESPONSE_RADIUS;

VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWindow, g_object_unref)
VALA_EXTERN GType widgets_resize_grip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsResizeGrip, g_object_unref)
VALA_EXTERN void widgets_config_window_toggle_fullscreen (WidgetsConfigWindow* self);
VALA_EXTERN void widgets_config_window_update_frame (WidgetsConfigWindow* self);
VALA_EXTERN void widgets_window_draw_window_below (WidgetsWindow* self,
                                       cairo_t* cr);
VALA_EXTERN void widgets_config_window_window_save_before_quit (WidgetsConfigWindow* self);
VALA_EXTERN GdkCursorType* widgets_config_window_get_cursor_type (WidgetsConfigWindow* self,
                                                      gdouble x,
                                                      gdouble y);
VALA_EXTERN GdkCursorType* widgets_config_window_get_frame_cursor_type (WidgetsConfigWindow* self,
                                                            gdouble x,
                                                            gdouble y);
VALA_EXTERN WidgetsWindow* widgets_window_new (const gchar* window_mode);
VALA_EXTERN WidgetsWindow* widgets_window_construct (GType object_type,
                                         const gchar* window_mode);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
VALA_EXTERN WidgetsConfigWindow* widgets_config_window_new (void);
VALA_EXTERN WidgetsConfigWindow* widgets_config_window_construct (GType object_type);
VALA_EXTERN void widgets_window_transparent_window (WidgetsWindow* self);
VALA_EXTERN void widgets_window_init_window (WidgetsWindow* self);
VALA_EXTERN gint config_config_get_terminal_monitor (ConfigConfig* self);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN gboolean utils_is_tiling_wm (void);
static void __lambda73_ (Block49Data* _data49_,
                  GtkWidget* w);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void ___lambda73__gtk_widget_realize (GtkWidget* _sender,
                                      gpointer self);
VALA_EXTERN gchar* utils_get_image_path (const gchar* image_name);
static gboolean __lambda65_ (WidgetsWindow* self,
                      GdkEventFocus* w);
VALA_EXTERN void widgets_window_update_style (WidgetsWindow* self);
static gboolean ___lambda65__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                 GdkEventFocus* event,
                                                 gpointer self);
static gboolean __lambda66_ (WidgetsWindow* self,
                      GdkEventFocus* w);
static gboolean ___lambda66__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean __lambda67_ (WidgetsWindow* self,
                      GdkEventConfigure* w);
VALA_EXTERN gboolean widgets_config_window_window_is_fullscreen (WidgetsConfigWindow* self);
VALA_EXTERN gboolean widgets_config_window_window_is_max (WidgetsConfigWindow* self);
VALA_EXTERN void widgets_window_update_blur_status (WidgetsWindow* self,
                                        gboolean force_update);
static gboolean ___lambda67__gtk_widget_configure_event (GtkWidget* _sender,
                                                  GdkEventConfigure* event,
                                                  gpointer self);
static gboolean __lambda68_ (WidgetsWindow* self,
                      GtkWidget* w,
                      GdkEventWindowState* e);
static gboolean ___lambda68__gtk_widget_window_state_event (GtkWidget* _sender,
                                                     GdkEventWindowState* event,
                                                     gpointer self);
static gboolean __lambda69_ (WidgetsWindow* self,
                      GtkWidget* w,
                      GdkEventButton* e);
VALA_EXTERN gboolean widgets_config_window_window_is_normal (WidgetsConfigWindow* self);
VALA_EXTERN gboolean utils_resize_window (GtkWidget* widget,
                              GdkEventButton* event,
                              GdkCursorType cursor_type);
static gboolean ___lambda69__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda70_ (WidgetsWindow* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda70__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda71_ (WidgetsWindow* self,
                      GtkWidget* w,
                      cairo_t* cr);
VALA_EXTERN void widgets_window_draw_window_widgets (WidgetsWindow* self,
                                         cairo_t* cr);
VALA_EXTERN void widgets_window_draw_window_frame (WidgetsWindow* self,
                                       cairo_t* cr);
VALA_EXTERN void widgets_window_draw_window_above (WidgetsWindow* self,
                                       cairo_t* cr);
static gboolean ___lambda71__gtk_widget_draw (GtkWidget* _sender,
                                       cairo_t* cr,
                                       gpointer self);
static void __lambda72_ (WidgetsWindow* self,
                  ConfigConfig* w);
static void ___lambda72__config_config_update (ConfigConfig* _sender,
                                        gpointer self);
VALA_EXTERN void widgets_window_clean_style (WidgetsWindow* self);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN gdouble utils_get_default_monitor_scale (void);
VALA_EXTERN void utils_propagate_draw (GtkContainer* widget,
                           cairo_t* cr);
VALA_EXTERN void widgets_window_add_widget (WidgetsWindow* self,
                                GtkWidget* widget);
VALA_EXTERN gboolean widgets_window_have_terminal_at_same_workspace (WidgetsWindow* self);
VALA_EXTERN gchar* utils_get_proc_file_content (const gchar* proc_file_path);
static void widgets_window_real_toggle_fullscreen (WidgetsConfigWindow* base);
static void widgets_window_real_update_frame (WidgetsConfigWindow* base);
VALA_EXTERN gboolean widgets_config_window_window_is_tiled (WidgetsConfigWindow* self);
VALA_EXTERN void widgets_window_toggle_max (WidgetsWindow* self);
static void widgets_window_real_draw_window_below (WidgetsWindow* self,
                                            cairo_t* cr);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void widgets_config_window_draw_titlebar_underline (WidgetsConfigWindow* self,
                                                    cairo_t* cr,
                                                    gint x,
                                                    gint y,
                                                    gint width,
                                                    gint offset);
VALA_EXTERN void widgets_config_window_draw_active_tab_underline (WidgetsConfigWindow* self,
                                                      cairo_t* cr,
                                                      gint x,
                                                      gint y);
VALA_EXTERN GType widgets_appbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsAppbar, g_object_unref)
VALA_EXTERN void widgets_window_init_fullscreen_handler (WidgetsWindow* self,
                                             WidgetsAppbar* appbar);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static gboolean __lambda187_ (Block50Data* _data50_,
                       GdkEventConfigure* w);
VALA_EXTERN void utils_remove_all_children (GtkContainer* container);
VALA_EXTERN void widgets_appbar_hide_window_button (WidgetsAppbar* self);
VALA_EXTERN void widgets_appbar_show_window_button (WidgetsAppbar* self);
static gboolean ___lambda187__gtk_widget_configure_event (GtkWidget* _sender,
                                                   GdkEventConfigure* event,
                                                   gpointer self);
static gboolean __lambda188_ (Block50Data* _data50_,
                       GtkWidget* w,
                       GdkEventMotion* e);
static gboolean ____lambda189_ (Block50Data* _data50_);
VALA_EXTERN void utils_get_pointer_position (gint* x,
                                 gint* y);
VALA_EXTERN void widgets_config_window_redraw_window (WidgetsConfigWindow* self);
static gboolean _____lambda189__gsource_func (gpointer self);
static gboolean ___lambda188__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                       GdkEventMotion* event,
                                                       gpointer self);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, g_object_unref)
VALA_EXTERN GType terminal_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalApp, g_object_unref)
VALA_EXTERN guint terminal_app_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType widgets_tabbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTabbar, g_object_unref)
VALA_EXTERN void widgets_window_show_window (WidgetsWindow* self,
                                 TerminalApp* app,
                                 WidgetsWorkspaceManager* workspace_manager,
                                 WidgetsTabbar* tabbar,
                                 gboolean has_start);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
VALA_EXTERN WidgetsAppbar* widgets_appbar_new (TerminalApp* app,
                                   WidgetsWindow* win,
                                   WidgetsTabbar* tab_bar,
                                   WidgetsWorkspaceManager* manager,
                                   gboolean has_start);
VALA_EXTERN WidgetsAppbar* widgets_appbar_construct (GType object_type,
                                         TerminalApp* app,
                                         WidgetsWindow* win,
                                         WidgetsTabbar* tab_bar,
                                         WidgetsWorkspaceManager* manager,
                                         gboolean has_start);
static void __lambda190_ (WidgetsWindow* self,
                   WidgetsAppbar* w);
VALA_EXTERN void widgets_config_window_quit (WidgetsConfigWindow* self);
static void ___lambda190__widgets_appbar_close_window (WidgetsAppbar* _sender,
                                                gpointer self);
static void __lambda191_ (WidgetsWindow* self,
                   WidgetsAppbar* w);
static void ___lambda191__widgets_appbar_quit_fullscreen (WidgetsAppbar* _sender,
                                                   gpointer self);
VALA_EXTERN void widgets_config_window_init (WidgetsConfigWindow* self,
                                 WidgetsWorkspaceManager* manager,
                                 WidgetsTabbar* tabbar);
static gboolean __lambda224_ (Block51Data* _data51_,
                       GdkEventWindowState* w);
VALA_EXTERN void widgets_appbar_update_max_button (WidgetsAppbar* self);
static gboolean ___lambda224__gtk_widget_window_state_event (GtkWidget* _sender,
                                                      GdkEventWindowState* event,
                                                      gpointer self);
VALA_EXTERN WidgetsResizeGrip* widgets_resize_grip_new (WidgetsWindow* win);
VALA_EXTERN WidgetsResizeGrip* widgets_resize_grip_construct (GType object_type,
                                                  WidgetsWindow* win);
static void widgets_window_real_window_save_before_quit (WidgetsConfigWindow* base);
VALA_EXTERN void config_config_load_config (ConfigConfig* self);
VALA_EXTERN void config_config_save (ConfigConfig* self);
static GdkCursorType* widgets_window_real_get_cursor_type (WidgetsConfigWindow* base,
                                                    gdouble x,
                                                    gdouble y);
static GdkCursorType* _gdk_cursor_type_dup (GdkCursorType* self);
static GdkCursorType* widgets_window_real_get_frame_cursor_type (WidgetsConfigWindow* base,
                                                          gdouble x,
                                                          gdouble y);
static void widgets_window_finalize (GObject * obj);
static GType widgets_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
widgets_window_get_instance_private (WidgetsWindow* self)
{
	return G_STRUCT_MEMBER_P (self, WidgetsWindow_private_offset);
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		WidgetsWindow* self;
		self = _data49_->self;
		_g_free0 (_data49_->window_mode);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
__lambda73_ (Block49Data* _data49_,
             GtkWidget* w)
{
	WidgetsWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data49_->self;
	g_return_if_fail (w != NULL);
	{
		gchar* window_state = NULL;
		gchar* _tmp0_;
		gchar** window_modes = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint window_modes_length1;
		gint _window_modes_size_;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp13_;
		gint width = 0;
		ConfigConfig* _tmp20_;
		GKeyFile* _tmp21_;
		gint height = 0;
		ConfigConfig* _tmp22_;
		GKeyFile* _tmp23_;
		gboolean _tmp24_ = FALSE;
		_tmp0_ = g_strdup ("");
		window_state = _tmp0_;
		_tmp1_ = g_strdup ("normal");
		_tmp2_ = g_strdup ("maximize");
		_tmp3_ = g_strdup ("fullscreen");
		_tmp4_ = g_new0 (gchar*, 3 + 1);
		_tmp4_[0] = _tmp1_;
		_tmp4_[1] = _tmp2_;
		_tmp4_[2] = _tmp3_;
		window_modes = _tmp4_;
		window_modes_length1 = 3;
		_window_modes_size_ = window_modes_length1;
		if (_data49_->window_mode != NULL) {
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = window_modes;
			_tmp6__length1 = window_modes_length1;
			_tmp5_ = _vala_string_array_contains (_tmp6_, _tmp6__length1, _data49_->window_mode);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_data49_->window_mode);
			_g_free0 (window_state);
			window_state = _tmp7_;
		} else {
			gchar* _tmp8_ = NULL;
			ConfigConfig* _tmp9_;
			GKeyFile* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp9_ = ((WidgetsConfigWindow*) self)->config;
			_tmp10_ = _tmp9_->config_file;
			_tmp11_ = g_key_file_get_value (_tmp10_, "advanced", "use_on_starting", &_inner_error0_);
			_tmp8_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				window_modes = (_vala_array_free (window_modes, window_modes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (window_state);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp12_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 (window_state);
			window_state = _tmp12_;
			_g_free0 (_tmp8_);
		}
		_tmp13_ = window_state;
		if (g_strcmp0 (_tmp13_, "maximize") == 0) {
			GdkWindow* _tmp14_;
			gtk_window_maximize ((GtkWindow*) self);
			_tmp14_ = gtk_widget_get_window ((GtkWidget*) self);
			gdk_window_set_shadow_width (_tmp14_, 0, 0, 0, 0);
		} else {
			const gchar* _tmp15_;
			_tmp15_ = window_state;
			if (g_strcmp0 (_tmp15_, "fullscreen") == 0) {
				GdkWindow* _tmp16_;
				widgets_config_window_toggle_fullscreen ((WidgetsConfigWindow*) self);
				_tmp16_ = gtk_widget_get_window ((GtkWidget*) self);
				gdk_window_set_shadow_width (_tmp16_, 0, 0, 0, 0);
			} else {
				GdkScreen* _tmp17_;
				_tmp17_ = ((WidgetsConfigWindow*) self)->screen_monitor;
				if (gdk_screen_is_composited (_tmp17_)) {
					GdkWindow* _tmp18_;
					_tmp18_ = gtk_widget_get_window ((GtkWidget*) self);
					gdk_window_set_shadow_width (_tmp18_, self->window_frame_margin_start, self->window_frame_margin_end, self->window_frame_margin_top, self->window_frame_margin_bottom);
				} else {
					GdkWindow* _tmp19_;
					_tmp19_ = gtk_widget_get_window ((GtkWidget*) self);
					gdk_window_set_shadow_width (_tmp19_, 0, 0, 0, 0);
				}
			}
		}
		_tmp20_ = ((WidgetsConfigWindow*) self)->config;
		_tmp21_ = _tmp20_->config_file;
		width = g_key_file_get_integer (_tmp21_, "advanced", "window_width", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			window_modes = (_vala_array_free (window_modes, window_modes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (window_state);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp22_ = ((WidgetsConfigWindow*) self)->config;
		_tmp23_ = _tmp22_->config_file;
		height = g_key_file_get_integer (_tmp23_, "advanced", "window_height", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			window_modes = (_vala_array_free (window_modes, window_modes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (window_state);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (width == 0) {
			_tmp24_ = TRUE;
		} else {
			_tmp24_ = height == 0;
		}
		if (_tmp24_) {
			gboolean _tmp25_ = FALSE;
			GdkRectangle _tmp26_;
			_tmp26_ = _data49_->rect;
			if (_tmp26_.width == 0) {
				_tmp25_ = TRUE;
			} else {
				GdkRectangle _tmp27_;
				_tmp27_ = _data49_->rect;
				_tmp25_ = _tmp27_.height == 0;
			}
			if (_tmp25_) {
				gtk_window_set_default_size ((GtkWindow*) self, 800, 600);
			} else {
				GdkRectangle _tmp28_;
				GdkRectangle _tmp29_;
				_tmp28_ = _data49_->rect;
				_tmp29_ = _data49_->rect;
				gtk_window_set_default_size ((GtkWindow*) self, (gint) (_tmp28_.width * self->window_default_scale), (gint) (_tmp29_.height * self->window_default_scale));
			}
		} else {
			gtk_window_set_default_size ((GtkWindow*) self, width, height);
		}
		window_modes = (_vala_array_free (window_modes, window_modes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (window_state);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = stdout;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		fprintf (_tmp30_, "%s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda73__gtk_widget_realize (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda73_ (self, _sender);
}

WidgetsWindow*
widgets_window_construct (GType object_type,
                          const gchar* window_mode)
{
	WidgetsWindow * self = NULL;
	Block49Data* _data49_;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ConfigConfig* _tmp2_;
	GKeyFile* _tmp3_;
	gint monitor = 0;
	ConfigConfig* _tmp4_;
	GdkScreen* _tmp5_;
	GdkScreen* _tmp6_;
	GdkRectangle _tmp7_ = {0};
	GdkGeometry geo = {0};
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	GdkGeometry _tmp11_;
	GdkRGBA _tmp12_ = {0};
	GdkRGBA _tmp13_ = {0};
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GError* _inner_error0_ = NULL;
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_tmp0_ = g_strdup (window_mode);
	_g_free0 (_data49_->window_mode);
	_data49_->window_mode = _tmp0_;
	self = (WidgetsWindow*) widgets_config_window_construct (object_type);
	_data49_->self = g_object_ref (self);
	_tmp2_ = ((WidgetsConfigWindow*) self)->config;
	_tmp3_ = _tmp2_->config_file;
	_tmp1_ = g_key_file_get_boolean (_tmp3_, "advanced", "tabbar_at_the_bottom", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block49_data_unref (_data49_);
		_data49_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	self->tabbar_at_the_bottom = _tmp1_;
	widgets_window_transparent_window (self);
	widgets_window_init_window (self);
	_tmp4_ = ((WidgetsConfigWindow*) self)->config;
	monitor = config_config_get_terminal_monitor (_tmp4_);
	_tmp5_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp6_ = _tmp5_;
	gdk_screen_get_monitor_geometry (_tmp6_, monitor, &_tmp7_);
	_data49_->rect = _tmp7_;
	if (self->tabbar_at_the_bottom) {
		GdkRectangle _tmp8_;
		_tmp8_ = _data49_->rect;
		self->window_fullscreen_monitor_height = _tmp8_.height - self->window_fullscreen_monitor_height;
	}
	memset (&geo, 0, sizeof (GdkGeometry));
	_tmp9_ = _data49_->rect;
	geo.min_width = _tmp9_.width / 3;
	_tmp10_ = _data49_->rect;
	geo.min_height = _tmp10_.height / 3;
	_tmp11_ = geo;
	gtk_window_set_geometry_hints ((GtkWindow*) self, NULL, &_tmp11_, GDK_HINT_MIN_SIZE);
	utils_hex_to_rgba ("#000000", 0.2, &_tmp12_);
	self->top_line_dark_color = _tmp12_;
	utils_hex_to_rgba ("#ffffff", 0.2, &_tmp13_);
	self->top_line_light_color = _tmp13_;
	if (utils_is_tiling_wm ()) {
		self->window_frame_margin_top = 0;
		self->window_frame_margin_bottom = 0;
		self->window_frame_margin_start = 0;
		self->window_frame_margin_end = 0;
	}
	_tmp14_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp14_, self->window_frame_margin_top);
	_tmp15_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp15_, self->window_frame_margin_bottom);
	_tmp16_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, self->window_frame_margin_start);
	_tmp17_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, self->window_frame_margin_end);
	_tmp18_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, 2);
	_tmp19_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp19_, 2);
	_tmp20_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, 2);
	_tmp21_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp21_, 2);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) ___lambda73__gtk_widget_realize, block49_data_ref (_data49_), (GClosureNotify) block49_data_unref, 0);
	{
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = utils_get_image_path ("deepin-terminal-gtk.svg");
		_tmp23_ = _tmp22_;
		gtk_window_set_icon_from_file ((GtkWindow*) self, _tmp23_, &_inner_error0_);
		_g_free0 (_tmp23_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* er = NULL;
		FILE* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		er = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = stdout;
		_tmp25_ = er;
		_tmp26_ = _tmp25_->message;
		fprintf (_tmp24_, "%s", _tmp26_);
		_g_error_free0 (er);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block49_data_unref (_data49_);
		_data49_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	block49_data_unref (_data49_);
	_data49_ = NULL;
	return self;
}

WidgetsWindow*
widgets_window_new (const gchar* window_mode)
{
	return widgets_window_construct (WIDGETS_TYPE_WINDOW, window_mode);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
widgets_window_transparent_window (WidgetsWindow* self)
{
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	g_return_if_fail (self != NULL);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = gdk_screen_get_rgba_visual (screen);
	gtk_widget_set_visual ((GtkWidget*) self, _tmp2_);
	_g_object_unref0 (screen);
}

static gboolean
__lambda65_ (WidgetsWindow* self,
             GdkEventFocus* w)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	widgets_window_update_style (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda65__gtk_widget_focus_in_event (GtkWidget* _sender,
                                        GdkEventFocus* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda65_ ((WidgetsWindow*) self, event);
	return result;
}

static gboolean
__lambda66_ (WidgetsWindow* self,
             GdkEventFocus* w)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	widgets_window_update_style (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda66__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda66_ ((WidgetsWindow*) self, event);
	return result;
}

static gboolean
__lambda67_ (WidgetsWindow* self,
             GdkEventConfigure* w)
{
	cairo_rectangle_int_t rect = {0};
	GdkWindow* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	cairo_region_t* shape = NULL;
	cairo_rectangle_int_t _tmp23_;
	cairo_region_t* _tmp24_;
	GdkWindow* _tmp25_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_frame_extents (_tmp0_, &_tmp1_);
	rect = _tmp1_;
	rect.x = 0;
	rect.y = 0;
	if (!widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self)) {
		_tmp3_ = !widgets_config_window_window_is_max ((WidgetsConfigWindow*) self);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GdkScreen* _tmp4_;
		_tmp4_ = ((WidgetsConfigWindow*) self)->screen_monitor;
		_tmp2_ = gdk_screen_is_composited (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkBox* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GtkBox* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		GtkBox* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GtkBox* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GtkBox* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		GtkBox* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		_tmp6_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp5_);
		_tmp7_ = _tmp6_;
		rect.x = _tmp7_ - constant_RESPONSE_RADIUS;
		_tmp8_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		_tmp9_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp8_);
		_tmp10_ = _tmp9_;
		rect.y = _tmp10_ - constant_RESPONSE_RADIUS;
		_tmp11_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		_tmp12_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		_tmp15_ = gtk_widget_get_margin_end ((GtkWidget*) _tmp14_);
		_tmp16_ = _tmp15_;
		rect.width = rect.width + (((-_tmp13_) - _tmp16_) + (constant_RESPONSE_RADIUS * 2));
		_tmp17_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		_tmp18_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		_tmp21_ = gtk_widget_get_margin_bottom ((GtkWidget*) _tmp20_);
		_tmp22_ = _tmp21_;
		rect.height = rect.height + (((-_tmp19_) - _tmp22_) + (constant_RESPONSE_RADIUS * 2));
	}
	_tmp23_ = rect;
	_tmp24_ = cairo_region_create_rectangle (&_tmp23_);
	shape = _tmp24_;
	_tmp25_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_input_shape_combine_region (_tmp25_, shape, 0, 0);
	widgets_window_update_blur_status (self, FALSE);
	result = FALSE;
	_cairo_region_destroy0 (shape);
	return result;
}

static gboolean
___lambda67__gtk_widget_configure_event (GtkWidget* _sender,
                                         GdkEventConfigure* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda67_ ((WidgetsWindow*) self, event);
	return result;
}

static gboolean
__lambda68_ (WidgetsWindow* self,
             GtkWidget* w,
             GdkEventWindowState* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	widgets_config_window_update_frame ((WidgetsConfigWindow*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda68__gtk_widget_window_state_event (GtkWidget* _sender,
                                            GdkEventWindowState* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda68_ ((WidgetsWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda69_ (WidgetsWindow* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	GdkScreen* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = ((WidgetsConfigWindow*) self)->screen_monitor;
	if (!gdk_screen_is_composited (_tmp0_)) {
		if (widgets_config_window_window_is_normal ((WidgetsConfigWindow*) self)) {
			gint pointer_x = 0;
			gint pointer_y = 0;
			GdkDevice* _tmp1_;
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
			GdkCursorType* cursor_type = NULL;
			GdkCursorType* _tmp4_;
			GdkCursorType* _tmp5_;
			_tmp1_ = e->device;
			gdk_device_get_position (_tmp1_, NULL, &_tmp2_, &_tmp3_);
			pointer_x = _tmp2_;
			pointer_y = _tmp3_;
			_tmp4_ = widgets_config_window_get_frame_cursor_type ((WidgetsConfigWindow*) self, e->x_root, e->y_root);
			cursor_type = _tmp4_;
			_tmp5_ = cursor_type;
			if (_tmp5_ != NULL) {
				GdkCursorType* _tmp6_;
				_tmp6_ = cursor_type;
				utils_resize_window ((GtkWidget*) self, e, *_tmp6_);
				result = TRUE;
				_g_free0 (cursor_type);
				return result;
			}
			_g_free0 (cursor_type);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda69__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda69_ ((WidgetsWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda70_ (WidgetsWindow* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (widgets_config_window_window_is_normal ((WidgetsConfigWindow*) self)) {
		gint pointer_x = 0;
		gint pointer_y = 0;
		GdkDevice* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		GdkCursorType* cursor_type = NULL;
		GdkCursorType* _tmp3_;
		GdkCursorType* _tmp4_;
		_tmp0_ = e->device;
		gdk_device_get_position (_tmp0_, NULL, &_tmp1_, &_tmp2_);
		pointer_x = _tmp1_;
		pointer_y = _tmp2_;
		_tmp3_ = widgets_config_window_get_cursor_type ((WidgetsConfigWindow*) self, e->x_root, e->y_root);
		cursor_type = _tmp3_;
		_tmp4_ = cursor_type;
		if (_tmp4_ != NULL) {
			GdkCursorType* _tmp5_;
			_tmp5_ = cursor_type;
			utils_resize_window ((GtkWidget*) self, e, *_tmp5_);
			result = TRUE;
			_g_free0 (cursor_type);
			return result;
		}
		_g_free0 (cursor_type);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda70__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda70_ ((WidgetsWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda71_ (WidgetsWindow* self,
             GtkWidget* w,
             cairo_t* cr)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	widgets_window_draw_window_below (self, cr);
	widgets_window_draw_window_widgets (self, cr);
	widgets_window_draw_window_frame (self, cr);
	widgets_window_draw_window_above (self, cr);
	result = TRUE;
	return result;
}

static gboolean
___lambda71__gtk_widget_draw (GtkWidget* _sender,
                              cairo_t* cr,
                              gpointer self)
{
	gboolean result;
	result = __lambda71_ ((WidgetsWindow*) self, _sender, cr);
	return result;
}

static void
__lambda72_ (WidgetsWindow* self,
             ConfigConfig* w)
{
	g_return_if_fail (w != NULL);
	widgets_window_update_style (self);
	widgets_window_update_blur_status (self, TRUE);
}

static void
___lambda72__config_config_update (ConfigConfig* _sender,
                                   gpointer self)
{
	__lambda72_ ((WidgetsWindow*) self, _sender);
}

void
widgets_window_init_window (WidgetsWindow* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	ConfigConfig* _tmp6_;
	g_return_if_fail (self != NULL);
	if (utils_is_tiling_wm ()) {
		gtk_window_set_decorated ((GtkWindow*) self, TRUE);
	} else {
		gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	}
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (((WidgetsConfigWindow*) self)->window_frame_box);
	((WidgetsConfigWindow*) self)->window_frame_box = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (((WidgetsConfigWindow*) self)->window_widget_box);
	((WidgetsConfigWindow*) self)->window_widget_box = _tmp1_;
	_tmp2_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp4_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_box_pack_start (_tmp3_, (GtkWidget*) _tmp4_, TRUE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) ___lambda65__gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda66__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) ___lambda67__gtk_widget_configure_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) ___lambda68__gtk_widget_window_state_event, self, 0);
	_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "button-press-event", (GCallback) ___lambda69__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda70__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) ___lambda71__gtk_widget_draw, self, G_CONNECT_AFTER);
	_tmp6_ = ((WidgetsConfigWindow*) self)->config;
	g_signal_connect_object (_tmp6_, "update", (GCallback) ___lambda72__config_config_update, self, 0);
}

void
widgets_window_update_style (WidgetsWindow* self)
{
	gboolean is_light_theme = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	widgets_window_clean_style (self);
	is_light_theme = widgets_config_window_is_light_theme ((WidgetsConfigWindow*) self);
	g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (widgets_config_window_window_is_normal ((WidgetsConfigWindow*) self)) {
			if (is_light_theme) {
				GdkScreen* _tmp2_;
				_tmp2_ = ((WidgetsConfigWindow*) self)->screen_monitor;
				if (gdk_screen_is_composited (_tmp2_)) {
					GtkBox* _tmp3_;
					GtkStyleContext* _tmp4_;
					_tmp3_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
					gtk_style_context_add_class (_tmp4_, "window_light_shadow_active");
				} else {
					GtkBox* _tmp5_;
					GtkStyleContext* _tmp6_;
					_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
					gtk_style_context_add_class (_tmp6_, "window_light_noshadow_active");
				}
			} else {
				GdkScreen* _tmp7_;
				_tmp7_ = ((WidgetsConfigWindow*) self)->screen_monitor;
				if (gdk_screen_is_composited (_tmp7_)) {
					GtkBox* _tmp8_;
					GtkStyleContext* _tmp9_;
					_tmp8_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
					gtk_style_context_add_class (_tmp9_, "window_dark_shadow_active");
				} else {
					GtkBox* _tmp10_;
					GtkStyleContext* _tmp11_;
					_tmp10_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
					gtk_style_context_add_class (_tmp11_, "window_dark_noshadow_active");
				}
			}
		} else {
			GdkScreen* _tmp12_;
			_tmp12_ = ((WidgetsConfigWindow*) self)->screen_monitor;
			if (gdk_screen_is_composited (_tmp12_)) {
				GtkBox* _tmp13_;
				GtkStyleContext* _tmp14_;
				_tmp13_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
				gtk_style_context_add_class (_tmp14_, "window_noradius_shadow_active");
			} else {
				GtkBox* _tmp15_;
				GtkStyleContext* _tmp16_;
				_tmp15_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
				gtk_style_context_add_class (_tmp16_, "window_noradius_noshadow_active");
			}
		}
	} else {
		if (widgets_config_window_window_is_normal ((WidgetsConfigWindow*) self)) {
			if (is_light_theme) {
				GdkScreen* _tmp17_;
				_tmp17_ = ((WidgetsConfigWindow*) self)->screen_monitor;
				if (gdk_screen_is_composited (_tmp17_)) {
					GtkBox* _tmp18_;
					GtkStyleContext* _tmp19_;
					_tmp18_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
					gtk_style_context_add_class (_tmp19_, "window_light_shadow_inactive");
				} else {
					GtkBox* _tmp20_;
					GtkStyleContext* _tmp21_;
					_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
					gtk_style_context_add_class (_tmp21_, "window_light_noshadow_inactive");
				}
			} else {
				GdkScreen* _tmp22_;
				_tmp22_ = ((WidgetsConfigWindow*) self)->screen_monitor;
				if (gdk_screen_is_composited (_tmp22_)) {
					GtkBox* _tmp23_;
					GtkStyleContext* _tmp24_;
					_tmp23_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
					gtk_style_context_add_class (_tmp24_, "window_dark_shadow_inactive");
				} else {
					GtkBox* _tmp25_;
					GtkStyleContext* _tmp26_;
					_tmp25_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
					gtk_style_context_add_class (_tmp26_, "window_dark_noshadow_inactive");
				}
			}
		} else {
			GdkScreen* _tmp27_;
			_tmp27_ = ((WidgetsConfigWindow*) self)->screen_monitor;
			if (gdk_screen_is_composited (_tmp27_)) {
				GtkBox* _tmp28_;
				GtkStyleContext* _tmp29_;
				_tmp28_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp29_ = gtk_widget_get_style_context ((GtkWidget*) _tmp28_);
				gtk_style_context_add_class (_tmp29_, "window_noradius_shadow_inactive");
			} else {
				GtkBox* _tmp30_;
				GtkStyleContext* _tmp31_;
				_tmp30_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) _tmp30_);
				gtk_style_context_add_class (_tmp31_, "window_noradius_noshadow_inactive");
			}
		}
	}
}

void
widgets_window_clean_style (WidgetsWindow* self)
{
	GtkBox* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkBox* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkBox* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkBox* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkBox* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkBox* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkBox* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkBox* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkBox* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkBox* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkBox* _tmp22_;
	GtkStyleContext* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "window_light_shadow_inactive");
	_tmp2_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, "window_dark_shadow_inactive");
	_tmp4_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_remove_class (_tmp5_, "window_light_shadow_active");
	_tmp6_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_remove_class (_tmp7_, "window_dark_shadow_active");
	_tmp8_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_remove_class (_tmp9_, "window_noradius_shadow_inactive");
	_tmp10_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_remove_class (_tmp11_, "window_noradius_shadow_active");
	_tmp12_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_remove_class (_tmp13_, "window_light_noshadow_inactive");
	_tmp14_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_remove_class (_tmp15_, "window_dark_noshadow_inactive");
	_tmp16_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_remove_class (_tmp17_, "window_light_noshadow_active");
	_tmp18_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_remove_class (_tmp19_, "window_dark_noshadow_active");
	_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_remove_class (_tmp21_, "window_noradius_noshadow_inactive");
	_tmp22_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	gtk_style_context_remove_class (_tmp23_, "window_noradius_noshadow_active");
}

void
widgets_window_update_blur_status (WidgetsWindow* self,
                                   gboolean force_update)
{
	GdkDisplay* current_display = NULL;
	GdkWindow* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_window_get_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	current_display = _tmp2_;
	_tmp3_ = current_display;
	if ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp3_) : NULL) == NULL) {
		_g_object_unref0 (current_display);
		return;
	}
	{
		gint width = 0;
		gint height = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gtk_window_get_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
		width = _tmp4_;
		height = _tmp5_;
		if (width != ((WidgetsConfigWindow*) self)->resize_cache_width) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = height != ((WidgetsConfigWindow*) self)->resize_cache_height;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = force_update;
		}
		if (_tmp6_) {
			Display* xdisplay = NULL;
			GdkWindow* _tmp8_;
			GdkDisplay* _tmp9_;
			Display* _tmp10_;
			gint xid = 0;
			GdkWindow* _tmp11_;
			Atom atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED = {0};
			Display* _tmp12_;
			Atom atom_KDE_NET_WM_BLUR_BEHIND_REGION = {0};
			Display* _tmp13_;
			gboolean blur_background = FALSE;
			ConfigConfig* _tmp14_;
			GKeyFile* _tmp15_;
			((WidgetsConfigWindow*) self)->resize_cache_width = width;
			((WidgetsConfigWindow*) self)->resize_cache_height = height;
			_tmp8_ = gtk_widget_get_window ((GtkWidget*) self);
			_tmp9_ = gdk_window_get_display (_tmp8_);
			_tmp10_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp9_) : NULL);
			xdisplay = _tmp10_;
			_tmp11_ = gtk_widget_get_window ((GtkWidget*) self);
			xid = (gint) gdk_x11_window_get_xid (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gdk_x11_window_get_type (), GdkX11Window));
			_tmp12_ = xdisplay;
			atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED = XInternAtom (_tmp12_, "_NET_WM_DEEPIN_BLUR_REGION_ROUNDED", FALSE);
			_tmp13_ = xdisplay;
			atom_KDE_NET_WM_BLUR_BEHIND_REGION = XInternAtom (_tmp13_, "_KDE_NET_WM_BLUR_BEHIND_REGION", FALSE);
			_tmp14_ = ((WidgetsConfigWindow*) self)->config;
			_tmp15_ = _tmp14_->config_file;
			blur_background = g_key_file_get_boolean (_tmp15_, "advanced", "blur_background", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				_g_object_unref0 (current_display);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (blur_background) {
				cairo_rectangle_int_t blur_rect = {0};
				cairo_rectangle_int_t blur_rect_kwin = {0};
				GdkWindow* _tmp16_;
				GdkRectangle _tmp17_ = {0};
				GdkWindow* _tmp18_;
				GdkRectangle _tmp19_ = {0};
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				cairo_rectangle_int_t _tmp53_;
				cairo_rectangle_int_t _tmp59_;
				cairo_rectangle_int_t _tmp65_;
				cairo_rectangle_int_t _tmp66_;
				cairo_rectangle_int_t _tmp67_;
				cairo_rectangle_int_t _tmp68_;
				cairo_rectangle_int_t _tmp69_;
				cairo_rectangle_int_t _tmp70_;
				cairo_rectangle_int_t _tmp71_;
				cairo_rectangle_int_t _tmp72_;
				gulong* data = NULL;
				cairo_rectangle_int_t _tmp73_;
				cairo_rectangle_int_t _tmp74_;
				cairo_rectangle_int_t _tmp75_;
				cairo_rectangle_int_t _tmp76_;
				gulong* _tmp77_;
				gint data_length1;
				gint _data_size_;
				gulong* data_kwin = NULL;
				cairo_rectangle_int_t _tmp78_;
				cairo_rectangle_int_t _tmp79_;
				cairo_rectangle_int_t _tmp80_;
				cairo_rectangle_int_t _tmp81_;
				gulong* _tmp82_;
				gint data_kwin_length1;
				gint _data_kwin_size_;
				Display* _tmp83_;
				gulong* _tmp84_;
				gint _tmp84__length1;
				gulong* _tmp85_;
				gint _tmp85__length1;
				Display* _tmp86_;
				gulong* _tmp87_;
				gint _tmp87__length1;
				gulong* _tmp88_;
				gint _tmp88__length1;
				_tmp16_ = gtk_widget_get_window ((GtkWidget*) self);
				gdk_window_get_frame_extents (_tmp16_, &_tmp17_);
				blur_rect = _tmp17_;
				_tmp18_ = gtk_widget_get_window ((GtkWidget*) self);
				gdk_window_get_frame_extents (_tmp18_, &_tmp19_);
				blur_rect_kwin = _tmp19_;
				blur_rect.x = 0;
				blur_rect.y = 0;
				blur_rect_kwin.x = 0;
				blur_rect_kwin.y = 0;
				if (!widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self)) {
					_tmp21_ = !widgets_config_window_window_is_max ((WidgetsConfigWindow*) self);
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					GdkScreen* _tmp22_;
					_tmp22_ = ((WidgetsConfigWindow*) self)->screen_monitor;
					_tmp20_ = gdk_screen_is_composited (_tmp22_);
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					GtkBox* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					GtkBox* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					GtkBox* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					GtkBox* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					GtkBox* _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					GtkBox* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					GtkBox* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					GtkBox* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					GtkBox* _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					GtkBox* _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					_tmp23_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp24_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp23_);
					_tmp25_ = _tmp24_;
					blur_rect.x = _tmp25_;
					_tmp26_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp27_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp26_);
					_tmp28_ = _tmp27_;
					blur_rect.y = _tmp28_;
					_tmp29_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp30_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp33_ = gtk_widget_get_margin_end ((GtkWidget*) _tmp32_);
					_tmp34_ = _tmp33_;
					blur_rect.width = blur_rect.width + ((-_tmp31_) - _tmp34_);
					_tmp35_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp36_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp39_ = gtk_widget_get_margin_bottom ((GtkWidget*) _tmp38_);
					_tmp40_ = _tmp39_;
					blur_rect.height = blur_rect.height + ((-_tmp37_) - _tmp40_);
					_tmp41_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp42_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp45_ = gtk_widget_get_margin_end ((GtkWidget*) _tmp44_);
					_tmp46_ = _tmp45_;
					blur_rect_kwin.width = blur_rect_kwin.width + ((-_tmp43_) - _tmp46_);
					_tmp47_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp48_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp51_ = gtk_widget_get_margin_bottom ((GtkWidget*) _tmp50_);
					_tmp52_ = _tmp51_;
					blur_rect_kwin.height = blur_rect_kwin.height + ((-_tmp49_) - _tmp52_);
				}
				_tmp53_ = blur_rect;
				if (_tmp53_.width < 0) {
					cairo_rectangle_int_t _tmp54_;
					GtkBox* _tmp55_;
					GtkBox* _tmp56_;
					GtkBox* _tmp57_;
					GtkBox* _tmp58_;
					_tmp54_ = blur_rect;
					g_print ("[!!!] blur_rect calc result error! blur_rect.width = %d which is negat" \
"ive!\n", _tmp54_.width);
					_tmp55_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp56_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					blur_rect.width = (width - gtk_widget_get_margin_left ((GtkWidget*) _tmp55_)) - gtk_widget_get_margin_right ((GtkWidget*) _tmp56_);
					_tmp57_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp58_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					blur_rect.height = (height - gtk_widget_get_margin_top ((GtkWidget*) _tmp57_)) - gtk_widget_get_margin_bottom ((GtkWidget*) _tmp58_);
				}
				_tmp59_ = blur_rect_kwin;
				if (_tmp59_.width < 0) {
					cairo_rectangle_int_t _tmp60_;
					GtkBox* _tmp61_;
					GtkBox* _tmp62_;
					GtkBox* _tmp63_;
					GtkBox* _tmp64_;
					_tmp60_ = blur_rect_kwin;
					g_print ("[!!!] blur_rect_kwin calc result error! blur_rect_kwin.width = %d whic" \
"h is negative!\n", _tmp60_.width);
					_tmp61_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp62_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					blur_rect_kwin.width = (width - gtk_widget_get_margin_left ((GtkWidget*) _tmp61_)) - gtk_widget_get_margin_right ((GtkWidget*) _tmp62_);
					_tmp63_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp64_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					blur_rect_kwin.height = (height - gtk_widget_get_margin_top ((GtkWidget*) _tmp63_)) - gtk_widget_get_margin_bottom ((GtkWidget*) _tmp64_);
				}
				_tmp65_ = blur_rect;
				blur_rect.x = (gint) (_tmp65_.x * utils_get_default_monitor_scale ());
				_tmp66_ = blur_rect;
				blur_rect.y = (gint) (_tmp66_.y * utils_get_default_monitor_scale ());
				_tmp67_ = blur_rect;
				blur_rect.width = (gint) (_tmp67_.width * utils_get_default_monitor_scale ());
				_tmp68_ = blur_rect;
				blur_rect.height = (gint) (_tmp68_.height * utils_get_default_monitor_scale ());
				_tmp69_ = blur_rect_kwin;
				blur_rect_kwin.x = (gint) (_tmp69_.x * utils_get_default_monitor_scale ());
				_tmp70_ = blur_rect_kwin;
				blur_rect_kwin.y = (gint) (_tmp70_.y * utils_get_default_monitor_scale ());
				_tmp71_ = blur_rect_kwin;
				blur_rect_kwin.width = (gint) (_tmp71_.width * utils_get_default_monitor_scale ());
				_tmp72_ = blur_rect_kwin;
				blur_rect_kwin.height = (gint) (_tmp72_.height * utils_get_default_monitor_scale ());
				_tmp73_ = blur_rect;
				_tmp74_ = blur_rect;
				_tmp75_ = blur_rect;
				_tmp76_ = blur_rect;
				_tmp77_ = g_new0 (gulong, 6);
				_tmp77_[0] = (gulong) _tmp73_.x;
				_tmp77_[1] = (gulong) _tmp74_.y;
				_tmp77_[2] = (gulong) _tmp75_.width;
				_tmp77_[3] = (gulong) _tmp76_.height;
				_tmp77_[4] = (gulong) 8;
				_tmp77_[5] = (gulong) 8;
				data = _tmp77_;
				data_length1 = 6;
				_data_size_ = data_length1;
				_tmp78_ = blur_rect_kwin;
				_tmp79_ = blur_rect_kwin;
				_tmp80_ = blur_rect_kwin;
				_tmp81_ = blur_rect_kwin;
				_tmp82_ = g_new0 (gulong, 6);
				_tmp82_[0] = (gulong) _tmp78_.x;
				_tmp82_[1] = (gulong) _tmp79_.y;
				_tmp82_[2] = (gulong) _tmp80_.width;
				_tmp82_[3] = (gulong) _tmp81_.height;
				_tmp82_[4] = (gulong) 8;
				_tmp82_[5] = (gulong) 8;
				data_kwin = _tmp82_;
				data_kwin_length1 = 6;
				_data_kwin_size_ = data_kwin_length1;
				_tmp83_ = xdisplay;
				_tmp84_ = data;
				_tmp84__length1 = data_length1;
				_tmp85_ = data;
				_tmp85__length1 = data_length1;
				XChangeProperty (_tmp83_, (Window) xid, atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED, XA_CARDINAL, 32, (gint) PropModeReplace, (guchar*) _tmp84_, (_tmp85__length1 * sizeof (gulong)) / sizeof (gulong));
				_tmp86_ = xdisplay;
				_tmp87_ = data_kwin;
				_tmp87__length1 = data_kwin_length1;
				_tmp88_ = data_kwin;
				_tmp88__length1 = data_kwin_length1;
				XChangeProperty (_tmp86_, (Window) xid, atom_KDE_NET_WM_BLUR_BEHIND_REGION, XA_CARDINAL, 32, (gint) PropModeReplace, (guchar*) _tmp87_, ((_tmp88__length1 * sizeof (gulong)) / sizeof (gulong)) - 2);
				data_kwin = (g_free (data_kwin), NULL);
				data = (g_free (data), NULL);
			} else {
				Display* _tmp89_;
				Display* _tmp90_;
				_tmp89_ = xdisplay;
				XDeleteProperty (_tmp89_, (Window) xid, atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED);
				_tmp90_ = xdisplay;
				XDeleteProperty (_tmp90_, (Window) xid, atom_KDE_NET_WM_BLUR_BEHIND_REGION);
			}
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp91_;
		const gchar* _tmp92_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp91_ = e;
		_tmp92_ = _tmp91_->message;
		g_print ("%s\n", _tmp92_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (current_display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (current_display);
}

void
widgets_window_draw_window_widgets (WidgetsWindow* self,
                                    cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	utils_propagate_draw ((GtkContainer*) self, cr);
}

void
widgets_window_add_widget (WidgetsWindow* self,
                           GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_box_pack_start (_tmp0_, widget, TRUE, TRUE, (guint) 0);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gboolean
widgets_window_have_terminal_at_same_workspace (WidgetsWindow* self)
{
	WnckScreen* screen = NULL;
	WnckScreen* _tmp0_;
	WnckScreen* _tmp1_;
	WnckScreen* _tmp2_;
	WnckWorkspace* active_workspace = NULL;
	WnckScreen* _tmp3_;
	WnckWorkspace* _tmp4_;
	WnckWorkspace* _tmp5_;
	WnckScreen* _tmp6_;
	GList* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = wnck_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = screen;
	wnck_screen_force_update (_tmp2_);
	_tmp3_ = screen;
	_tmp4_ = wnck_screen_get_active_workspace (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	active_workspace = _tmp5_;
	_tmp6_ = screen;
	_tmp7_ = wnck_screen_get_windows (_tmp6_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp7_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* _tmp8_;
			WnckWindow* window = NULL;
			_tmp8_ = _g_object_ref0 ((WnckWindow*) window_it->data);
			window = _tmp8_;
			{
				WnckWorkspace* workspace = NULL;
				WnckWindow* _tmp9_;
				WnckWorkspace* _tmp10_;
				WnckWorkspace* _tmp11_;
				gboolean _tmp12_ = FALSE;
				WnckWorkspace* _tmp13_;
				_tmp9_ = window;
				_tmp10_ = wnck_window_get_workspace (_tmp9_);
				_tmp11_ = _g_object_ref0 (_tmp10_);
				workspace = _tmp11_;
				_tmp13_ = workspace;
				if (_tmp13_ != NULL) {
					WnckWorkspace* _tmp14_;
					WnckWorkspace* _tmp15_;
					_tmp14_ = workspace;
					_tmp15_ = active_workspace;
					_tmp12_ = wnck_workspace_get_number (_tmp14_) == wnck_workspace_get_number (_tmp15_);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					gint pid = 0;
					WnckWindow* _tmp16_;
					_tmp16_ = window;
					pid = wnck_window_get_pid (_tmp16_);
					if (pid != 0) {
						gchar* command = NULL;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						const gchar* _tmp23_;
						_tmp17_ = g_strdup_printf ("/proc/%i/comm", pid);
						_tmp18_ = _tmp17_;
						_tmp19_ = utils_get_proc_file_content (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = string_strip (_tmp20_);
						_tmp22_ = _tmp21_;
						_g_free0 (_tmp20_);
						_g_free0 (_tmp18_);
						command = _tmp22_;
						_tmp23_ = command;
						if (g_strcmp0 (_tmp23_, "deepin-terminal-gtk") == 0) {
							result = TRUE;
							_g_free0 (command);
							_g_object_unref0 (workspace);
							_g_object_unref0 (window);
							_g_object_unref0 (active_workspace);
							_g_object_unref0 (screen);
							return result;
						}
						_g_free0 (command);
					}
				}
				_g_object_unref0 (workspace);
				_g_object_unref0 (window);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (active_workspace);
	_g_object_unref0 (screen);
	return result;
}

static void
widgets_window_real_toggle_fullscreen (WidgetsConfigWindow* base)
{
	WidgetsWindow * self;
	self = (WidgetsWindow*) base;
	if (widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self)) {
		gtk_window_unfullscreen ((GtkWindow*) self);
	} else {
		gtk_window_fullscreen ((GtkWindow*) self);
	}
}

static void
widgets_window_real_update_frame (WidgetsConfigWindow* base)
{
	WidgetsWindow * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GdkScreen* _tmp16_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = (WidgetsWindow*) base;
	widgets_window_update_style (self);
	if (utils_is_tiling_wm ()) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = widgets_config_window_window_is_max ((WidgetsConfigWindow*) self);
	}
	if (_tmp0_) {
		GtkBox* _tmp2_;
		GtkBox* _tmp3_;
		GtkBox* _tmp4_;
		GtkBox* _tmp5_;
		_tmp2_ = ((WidgetsConfigWindow*) self)->window_widget_box;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp2_, 0);
		_tmp3_ = ((WidgetsConfigWindow*) self)->window_widget_box;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 0);
		_tmp4_ = ((WidgetsConfigWindow*) self)->window_widget_box;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 0);
		_tmp5_ = ((WidgetsConfigWindow*) self)->window_widget_box;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 0);
	} else {
		if (widgets_config_window_window_is_tiled ((WidgetsConfigWindow*) self)) {
			GtkBox* _tmp6_;
			GtkBox* _tmp7_;
			GtkBox* _tmp8_;
			GtkBox* _tmp9_;
			_tmp6_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 1);
			_tmp7_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_bottom ((GtkWidget*) _tmp7_, 1);
			_tmp8_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 1);
			_tmp9_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 1);
		} else {
			GtkBox* _tmp10_;
			GtkBox* _tmp11_;
			GtkBox* _tmp12_;
			GtkBox* _tmp13_;
			_tmp10_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 2);
			_tmp11_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 2);
			_tmp12_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_start ((GtkWidget*) _tmp12_, 2);
			_tmp13_ = ((WidgetsConfigWindow*) self)->window_widget_box;
			gtk_widget_set_margin_end ((GtkWidget*) _tmp13_, 2);
		}
	}
	_tmp16_ = ((WidgetsConfigWindow*) self)->screen_monitor;
	if (!gdk_screen_is_composited (_tmp16_)) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self);
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = widgets_config_window_window_is_max ((WidgetsConfigWindow*) self);
	}
	if (_tmp14_) {
		GtkBox* _tmp17_;
		GtkBox* _tmp18_;
		GtkBox* _tmp19_;
		GtkBox* _tmp20_;
		GdkWindow* _tmp21_;
		_tmp17_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp17_, 0);
		_tmp18_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp18_, 0);
		_tmp19_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp19_, 0);
		_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp20_, 0);
		_tmp21_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_shadow_width (_tmp21_, 0, 0, 0, 0);
	} else {
		GtkBox* _tmp22_;
		GtkBox* _tmp23_;
		GtkBox* _tmp24_;
		GtkBox* _tmp25_;
		GdkWindow* _tmp26_;
		_tmp22_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp22_, self->window_frame_margin_top);
		_tmp23_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp23_, self->window_frame_margin_bottom);
		_tmp24_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp24_, self->window_frame_margin_start);
		_tmp25_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp25_, self->window_frame_margin_end);
		_tmp26_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_shadow_width (_tmp26_, self->window_frame_margin_start, self->window_frame_margin_end, self->window_frame_margin_top, self->window_frame_margin_bottom);
	}
	if (utils_is_tiling_wm ()) {
		_tmp30_ = TRUE;
	} else {
		GdkScreen* _tmp31_;
		_tmp31_ = ((WidgetsConfigWindow*) self)->screen_monitor;
		_tmp30_ = gdk_screen_is_composited (_tmp31_);
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self);
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = widgets_config_window_window_is_max ((WidgetsConfigWindow*) self);
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		gboolean _tmp32_ = FALSE;
		ConfigConfig* _tmp33_;
		GKeyFile* _tmp34_;
		_tmp33_ = ((WidgetsConfigWindow*) self)->config;
		_tmp34_ = _tmp33_->config_file;
		_tmp32_ = g_key_file_get_boolean (_tmp34_, "advanced", "always_hide_resize_grip", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp27_ = _tmp32_;
	}
	if (_tmp27_) {
		WidgetsResizeGrip* _tmp35_;
		_tmp35_ = self->priv->resize_grip;
		gtk_widget_hide ((GtkWidget*) _tmp35_);
	} else {
		WidgetsResizeGrip* _tmp36_;
		_tmp36_ = self->priv->resize_grip;
		gtk_widget_show ((GtkWidget*) _tmp36_);
	}
}

void
widgets_window_toggle_max (WidgetsWindow* self)
{
	g_return_if_fail (self != NULL);
	if (widgets_config_window_window_is_max ((WidgetsConfigWindow*) self)) {
		gtk_window_unmaximize ((GtkWindow*) self);
	} else {
		gtk_window_maximize ((GtkWindow*) self);
	}
}

static void
widgets_window_real_draw_window_below (WidgetsWindow* self,
                                       cairo_t* cr)
{
	g_return_if_fail (cr != NULL);
}

void
widgets_window_draw_window_below (WidgetsWindow* self,
                                  cairo_t* cr)
{
	WidgetsWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WIDGETS_WINDOW_GET_CLASS (self);
	if (_klass_->draw_window_below) {
		_klass_->draw_window_below (self, cr);
	}
}

void
widgets_window_draw_window_frame (WidgetsWindow* self,
                                  cairo_t* cr)
{
	GtkAllocation window_frame_rect = {0};
	GtkBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gint x = 0;
	GtkBox* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint y = 0;
	GtkBox* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint width = 0;
	GtkAllocation _tmp8_;
	gint height = 0;
	GtkAllocation _tmp9_;
	GdkRGBA frame_color = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	window_frame_rect = _tmp1_;
	_tmp2_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp3_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	x = _tmp4_;
	_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp6_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp5_);
	_tmp7_ = _tmp6_;
	y = _tmp7_;
	_tmp8_ = window_frame_rect;
	width = _tmp8_.width;
	_tmp9_ = window_frame_rect;
	height = _tmp9_.height;
	{
		if (widgets_config_window_window_is_normal ((WidgetsConfigWindow*) self)) {
			gchar* _tmp10_ = NULL;
			ConfigConfig* _tmp11_;
			GKeyFile* _tmp12_;
			gchar* _tmp13_;
			GdkRGBA _tmp14_ = {0};
			GdkScreen* _tmp15_;
			_tmp11_ = ((WidgetsConfigWindow*) self)->config;
			_tmp12_ = _tmp11_->config_file;
			_tmp13_ = g_key_file_get_string (_tmp12_, "theme", "background", &_inner_error0_);
			_tmp10_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			utils_hex_to_rgba (_tmp10_, 1.0, &_tmp14_);
			frame_color = _tmp14_;
			_tmp15_ = ((WidgetsConfigWindow*) self)->screen_monitor;
			if (gdk_screen_is_composited (_tmp15_)) {
				gdouble _tmp16_ = 0.0;
				ConfigConfig* _tmp17_;
				GKeyFile* _tmp18_;
				GdkRGBA _tmp19_;
				GdkRGBA _tmp20_;
				GdkRGBA _tmp21_;
				cairo_save (cr);
				_tmp17_ = ((WidgetsConfigWindow*) self)->config;
				_tmp18_ = _tmp17_->config_file;
				_tmp16_ = g_key_file_get_double (_tmp18_, "general", "opacity", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (_tmp10_);
					goto __catch0_g_error;
				}
				_tmp19_ = frame_color;
				_tmp20_ = frame_color;
				_tmp21_ = frame_color;
				cairo_set_source_rgba (cr, _tmp19_.red, _tmp20_.green, _tmp21_.blue, _tmp16_);
				draw_draw_rectangle (cr, x + 2, (y + height) - 2, width - 4, 1, TRUE);
				if (self->tabbar_at_the_bottom) {
					draw_draw_rectangle (cr, x + 1, y + 2, 1, (height - constant_TITLEBAR_HEIGHT) - 4, TRUE);
				} else {
					draw_draw_rectangle (cr, x + 1, (y + constant_TITLEBAR_HEIGHT) + 2, 1, (height - constant_TITLEBAR_HEIGHT) - 4, TRUE);
				}
				if (self->tabbar_at_the_bottom) {
					draw_draw_rectangle (cr, (x + width) - 2, y + 2, 1, (height - constant_TITLEBAR_HEIGHT) - 4, TRUE);
				} else {
					draw_draw_rectangle (cr, (x + width) - 2, (y + constant_TITLEBAR_HEIGHT) + 2, 1, (height - constant_TITLEBAR_HEIGHT) - 4, TRUE);
				}
				cairo_restore (cr);
			} else {
				gdouble _tmp22_ = 0.0;
				ConfigConfig* _tmp23_;
				GKeyFile* _tmp24_;
				GdkRGBA _tmp25_;
				GdkRGBA _tmp26_;
				GdkRGBA _tmp27_;
				cairo_save (cr);
				_tmp23_ = ((WidgetsConfigWindow*) self)->config;
				_tmp24_ = _tmp23_->config_file;
				_tmp22_ = g_key_file_get_double (_tmp24_, "general", "opacity", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (_tmp10_);
					goto __catch0_g_error;
				}
				_tmp25_ = frame_color;
				_tmp26_ = frame_color;
				_tmp27_ = frame_color;
				cairo_set_source_rgba (cr, _tmp25_.red, _tmp26_.green, _tmp27_.blue, _tmp22_);
				draw_draw_rectangle (cr, x, y, width, height, FALSE);
				cairo_restore (cr);
			}
			_g_free0 (_tmp10_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_print ("Window draw_window_frame: %s\n", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
widgets_window_draw_window_above (WidgetsWindow* self,
                                  cairo_t* cr)
{
	GtkAllocation window_frame_rect = {0};
	GtkBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gint x = 0;
	GtkBox* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint y = 0;
	GtkBox* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint width = 0;
	GtkAllocation _tmp8_;
	gint height = 0;
	GtkAllocation _tmp9_;
	gint titlebar_y = 0;
	GdkRGBA frame_color = {0};
	gboolean is_light_theme = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	window_frame_rect = _tmp1_;
	_tmp2_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp3_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	x = _tmp4_;
	_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp6_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp5_);
	_tmp7_ = _tmp6_;
	y = _tmp7_;
	_tmp8_ = window_frame_rect;
	width = _tmp8_.width;
	_tmp9_ = window_frame_rect;
	height = _tmp9_.height;
	titlebar_y = y;
	if (self->tabbar_at_the_bottom) {
		titlebar_y += height - constant_TITLEBAR_HEIGHT;
	}
	if (gtk_widget_get_scale_factor ((GtkWidget*) self) > 1) {
		titlebar_y -= 1;
	}
	memset (&frame_color, 0, sizeof (GdkRGBA));
	is_light_theme = widgets_config_window_is_light_theme ((WidgetsConfigWindow*) self);
	{
		gchar* _tmp10_ = NULL;
		ConfigConfig* _tmp11_;
		GKeyFile* _tmp12_;
		gchar* _tmp13_;
		GdkRGBA _tmp14_ = {0};
		_tmp11_ = ((WidgetsConfigWindow*) self)->config;
		_tmp12_ = _tmp11_->config_file;
		_tmp13_ = g_key_file_get_string (_tmp12_, "theme", "background", &_inner_error0_);
		_tmp10_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		utils_hex_to_rgba (_tmp10_, 1.0, &_tmp14_);
		frame_color = _tmp14_;
		_g_free0 (_tmp10_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_print ("Window draw_window_above: %s\n", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		if (widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self)) {
			if (self->draw_tabbar_line) {
				if (self->tabbar_at_the_bottom) {
					GtkBox* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					widgets_config_window_draw_titlebar_underline ((WidgetsConfigWindow*) self, cr, x, titlebar_y, width, -1);
					_tmp17_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp18_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp17_);
					_tmp19_ = _tmp18_;
					widgets_config_window_draw_active_tab_underline ((WidgetsConfigWindow*) self, cr, (x + ((WidgetsConfigWindow*) self)->active_tab_underline_x) - _tmp19_, titlebar_y - 1);
				} else {
					GtkBox* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					widgets_config_window_draw_titlebar_underline ((WidgetsConfigWindow*) self, cr, x, titlebar_y + constant_TITLEBAR_HEIGHT, width, 1);
					_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp21_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp20_);
					_tmp22_ = _tmp21_;
					widgets_config_window_draw_active_tab_underline ((WidgetsConfigWindow*) self, cr, (x + ((WidgetsConfigWindow*) self)->active_tab_underline_x) - _tmp22_, (titlebar_y + constant_TITLEBAR_HEIGHT) - 1);
				}
			}
		} else {
			gboolean _tmp23_ = FALSE;
			if (widgets_config_window_window_is_max ((WidgetsConfigWindow*) self)) {
				_tmp23_ = TRUE;
			} else {
				_tmp23_ = widgets_config_window_window_is_tiled ((WidgetsConfigWindow*) self);
			}
			if (_tmp23_) {
				if (self->tabbar_at_the_bottom) {
					GtkBox* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					widgets_config_window_draw_titlebar_underline ((WidgetsConfigWindow*) self, cr, x + 1, titlebar_y, width - 2, -1);
					_tmp24_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp25_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp24_);
					_tmp26_ = _tmp25_;
					widgets_config_window_draw_active_tab_underline ((WidgetsConfigWindow*) self, cr, (x + ((WidgetsConfigWindow*) self)->active_tab_underline_x) - _tmp26_, titlebar_y - 1);
				} else {
					GtkBox* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					widgets_config_window_draw_titlebar_underline ((WidgetsConfigWindow*) self, cr, x + 1, titlebar_y + constant_TITLEBAR_HEIGHT, width - 2, 1);
					_tmp27_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp28_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp27_);
					_tmp29_ = _tmp28_;
					widgets_config_window_draw_active_tab_underline ((WidgetsConfigWindow*) self, cr, (x + ((WidgetsConfigWindow*) self)->active_tab_underline_x) - _tmp29_, (titlebar_y + constant_TITLEBAR_HEIGHT) - 1);
				}
			} else {
				gint titlebar_near_frame_y = 0;
				gint side_margin = 0;
				gdouble _tmp30_ = 0.0;
				ConfigConfig* _tmp31_;
				GKeyFile* _tmp32_;
				GdkRGBA _tmp33_;
				GdkRGBA _tmp34_;
				GdkRGBA _tmp35_;
				gdouble _tmp36_ = 0.0;
				ConfigConfig* _tmp37_;
				GKeyFile* _tmp38_;
				gdouble _tmp39_ = 0.0;
				ConfigConfig* _tmp40_;
				GKeyFile* _tmp41_;
				GdkRGBA _tmp42_;
				GdkRGBA _tmp43_;
				GdkRGBA _tmp44_;
				titlebar_near_frame_y = titlebar_y + 1;
				side_margin = 2;
				if (self->tabbar_at_the_bottom) {
					titlebar_near_frame_y = titlebar_y + constant_TITLEBAR_HEIGHT;
					side_margin = -2;
				}
				_tmp31_ = ((WidgetsConfigWindow*) self)->config;
				_tmp32_ = _tmp31_->config_file;
				_tmp30_ = g_key_file_get_double (_tmp32_, "general", "opacity", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp33_ = frame_color;
				_tmp34_ = frame_color;
				_tmp35_ = frame_color;
				cairo_set_source_rgba (cr, _tmp33_.red, _tmp34_.green, _tmp35_.blue, _tmp30_);
				draw_draw_rectangle (cr, x + 2, y + 1, width - 4, 1, TRUE);
				draw_draw_rectangle (cr, x + 2, y + 1, width - 4, 1, TRUE);
				_tmp37_ = ((WidgetsConfigWindow*) self)->config;
				_tmp38_ = _tmp37_->config_file;
				_tmp36_ = g_key_file_get_double (_tmp38_, "general", "opacity", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.0625 * _tmp36_);
				draw_draw_rectangle (cr, x + 2, y, width - 4, 1, TRUE);
				_tmp40_ = ((WidgetsConfigWindow*) self)->config;
				_tmp41_ = _tmp40_->config_file;
				_tmp39_ = g_key_file_get_double (_tmp41_, "general", "opacity", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp42_ = frame_color;
				_tmp43_ = frame_color;
				_tmp44_ = frame_color;
				cairo_set_source_rgba (cr, _tmp42_.red, _tmp43_.green, _tmp44_.blue, _tmp39_);
				draw_draw_rectangle (cr, x + 1, titlebar_y + side_margin, 1, constant_TITLEBAR_HEIGHT, TRUE);
				draw_draw_rectangle (cr, (x + width) - 2, titlebar_y + side_margin, 1, constant_TITLEBAR_HEIGHT, TRUE);
				draw_draw_rectangle (cr, x + 1, titlebar_y + side_margin, 1, constant_TITLEBAR_HEIGHT, TRUE);
				draw_draw_rectangle (cr, (x + width) - 2, titlebar_y + side_margin, 1, constant_TITLEBAR_HEIGHT, TRUE);
				if (self->tabbar_at_the_bottom) {
					GtkBox* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					widgets_config_window_draw_titlebar_underline ((WidgetsConfigWindow*) self, cr, x + 1, titlebar_y, width - 2, -1);
					_tmp45_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp46_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp45_);
					_tmp47_ = _tmp46_;
					widgets_config_window_draw_active_tab_underline ((WidgetsConfigWindow*) self, cr, (x + ((WidgetsConfigWindow*) self)->active_tab_underline_x) - _tmp47_, titlebar_y - 1);
				} else {
					GtkBox* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					widgets_config_window_draw_titlebar_underline ((WidgetsConfigWindow*) self, cr, x + 1, titlebar_y + constant_TITLEBAR_HEIGHT, width - 2, 1);
					_tmp48_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp49_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp48_);
					_tmp50_ = _tmp49_;
					widgets_config_window_draw_active_tab_underline ((WidgetsConfigWindow*) self, cr, (x + ((WidgetsConfigWindow*) self)->active_tab_underline_x) - _tmp50_, (titlebar_y + constant_TITLEBAR_HEIGHT) - 1);
				}
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		g_print ("Window draw_window_above: %s\n", _tmp52_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		WidgetsWindow* self;
		self = _data50_->self;
		_g_object_unref0 (_data50_->appbar);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static gboolean
__lambda187_ (Block50Data* _data50_,
              GdkEventConfigure* w)
{
	WidgetsWindow* self;
	gboolean result;
	self = _data50_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	if (widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self)) {
		GtkBox* _tmp0_;
		_tmp0_ = self->fullscreen_box;
		utils_remove_all_children ((GtkContainer*) _tmp0_);
		gtk_widget_hide ((GtkWidget*) _data50_->appbar);
		widgets_appbar_hide_window_button (_data50_->appbar);
		self->draw_tabbar_line = FALSE;
	} else {
		GtkWidget* parent = NULL;
		GtkBox* _tmp1_;
		GtkContainer* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp1_ = self->spacing_box;
		_tmp2_ = gtk_widget_get_parent ((GtkWidget*) _tmp1_);
		_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
		parent = _tmp3_;
		_tmp4_ = parent;
		if (_tmp4_ == NULL) {
			GtkBox* _tmp5_;
			GtkBox* _tmp6_;
			_tmp5_ = self->fullscreen_box;
			_tmp6_ = self->spacing_box;
			gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
			gtk_widget_show_all ((GtkWidget*) _data50_->appbar);
			widgets_appbar_show_window_button (_data50_->appbar);
			self->draw_tabbar_line = TRUE;
		}
		_g_object_unref0 (parent);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda187__gtk_widget_configure_event (GtkWidget* _sender,
                                          GdkEventConfigure* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda187_ (self, event);
	return result;
}

static gboolean
____lambda189_ (Block50Data* _data50_)
{
	WidgetsWindow* self;
	gint pointer_x = 0;
	gint pointer_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean showAll = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean hideAll = FALSE;
	gboolean result;
	self = _data50_->self;
	utils_get_pointer_position (&_tmp0_, &_tmp1_);
	pointer_x = _tmp0_;
	pointer_y = _tmp1_;
	if (self->tabbar_at_the_bottom) {
		_tmp2_ = pointer_y > (self->window_fullscreen_monitor_height + constant_TITLEBAR_HEIGHT);
	} else {
		_tmp2_ = pointer_y < self->window_fullscreen_response_height;
	}
	showAll = _tmp2_;
	if (self->tabbar_at_the_bottom) {
		_tmp3_ = pointer_y < (self->window_fullscreen_monitor_height + constant_TITLEBAR_HEIGHT);
	} else {
		_tmp3_ = pointer_y > constant_TITLEBAR_HEIGHT;
	}
	hideAll = _tmp3_;
	if (showAll) {
		gtk_widget_show_all ((GtkWidget*) _data50_->appbar);
		self->draw_tabbar_line = TRUE;
		widgets_config_window_redraw_window ((WidgetsConfigWindow*) self);
	} else {
		if (hideAll) {
			gtk_widget_hide ((GtkWidget*) _data50_->appbar);
			self->draw_tabbar_line = FALSE;
			widgets_config_window_redraw_window ((WidgetsConfigWindow*) self);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
_____lambda189__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda189_ (self);
	return result;
}

static gboolean
__lambda188_ (Block50Data* _data50_,
              GtkWidget* w,
              GdkEventMotion* e)
{
	WidgetsWindow* self;
	gboolean result;
	self = _data50_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) self)) {
		gboolean _tmp0_ = FALSE;
		gboolean receiveEvents = FALSE;
		if (self->tabbar_at_the_bottom) {
			_tmp0_ = e->y_root > ((gdouble) self->window_fullscreen_monitor_height);
		} else {
			_tmp0_ = e->y_root < ((gdouble) self->window_fullscreen_monitor_height);
		}
		receiveEvents = _tmp0_;
		if (receiveEvents) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->window_fullscreen_monitor_timeout, _____lambda189__gsource_func, block50_data_ref (_data50_), block50_data_unref);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda188__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                              GdkEventMotion* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda188_ (self, _sender, event);
	return result;
}

void
widgets_window_init_fullscreen_handler (WidgetsWindow* self,
                                        WidgetsAppbar* appbar)
{
	Block50Data* _data50_;
	WidgetsAppbar* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (appbar != NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (appbar);
	_g_object_unref0 (_data50_->appbar);
	_data50_->appbar = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->fullscreen_box);
	self->fullscreen_box = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->spacing_box);
	self->spacing_box = _tmp2_;
	_tmp3_ = self->spacing_box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, -1, constant_TITLEBAR_HEIGHT);
	_tmp4_ = self->fullscreen_box;
	_tmp5_ = self->spacing_box;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	g_signal_connect_data ((GtkWidget*) self, "configure-event", (GCallback) ___lambda187__gtk_widget_configure_event, block50_data_ref (_data50_), (GClosureNotify) block50_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) self, "motion-notify-event", (GCallback) ___lambda188__gtk_widget_motion_notify_event, block50_data_ref (_data50_), (GClosureNotify) block50_data_unref, 0);
	block50_data_unref (_data50_);
	_data50_ = NULL;
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		WidgetsWindow* self;
		self = _data51_->self;
		_g_object_unref0 (_data51_->appbar);
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static void
__lambda190_ (WidgetsWindow* self,
              WidgetsAppbar* w)
{
	g_return_if_fail (w != NULL);
	widgets_config_window_quit ((WidgetsConfigWindow*) self);
}

static void
___lambda190__widgets_appbar_close_window (WidgetsAppbar* _sender,
                                           gpointer self)
{
	__lambda190_ ((WidgetsWindow*) self, _sender);
}

static void
__lambda191_ (WidgetsWindow* self,
              WidgetsAppbar* w)
{
	g_return_if_fail (w != NULL);
	widgets_config_window_toggle_fullscreen ((WidgetsConfigWindow*) self);
}

static void
___lambda191__widgets_appbar_quit_fullscreen (WidgetsAppbar* _sender,
                                              gpointer self)
{
	__lambda191_ ((WidgetsWindow*) self, _sender);
}

static gboolean
__lambda224_ (Block51Data* _data51_,
              GdkEventWindowState* w)
{
	WidgetsWindow* self;
	WidgetsAppbar* _tmp0_;
	gboolean result;
	self = _data51_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	_tmp0_ = _data51_->appbar;
	widgets_appbar_update_max_button (_tmp0_);
	result = FALSE;
	return result;
}

static gboolean
___lambda224__gtk_widget_window_state_event (GtkWidget* _sender,
                                             GdkEventWindowState* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda224_ (self, event);
	return result;
}

void
widgets_window_show_window (WidgetsWindow* self,
                            TerminalApp* app,
                            WidgetsWorkspaceManager* workspace_manager,
                            WidgetsTabbar* tabbar,
                            gboolean has_start)
{
	Block51Data* _data51_;
	WidgetsAppbar* _tmp0_;
	WidgetsAppbar* _tmp3_;
	WidgetsAppbar* _tmp4_;
	WidgetsAppbar* _tmp5_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp6_;
	WidgetsResizeGrip* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkOverlay* _tmp18_;
	GtkBox* _tmp19_;
	GtkOverlay* _tmp20_;
	WidgetsAppbar* _tmp21_;
	GtkOverlay* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	g_return_if_fail (workspace_manager != NULL);
	g_return_if_fail (tabbar != NULL);
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_tmp0_ = widgets_appbar_new (app, self, tabbar, workspace_manager, has_start);
	g_object_ref_sink (_tmp0_);
	_data51_->appbar = _tmp0_;
	if (self->tabbar_at_the_bottom) {
		WidgetsAppbar* _tmp1_;
		_tmp1_ = _data51_->appbar;
		gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_END);
	} else {
		WidgetsAppbar* _tmp2_;
		_tmp2_ = _data51_->appbar;
		gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	}
	_tmp3_ = _data51_->appbar;
	g_signal_connect_object (_tmp3_, "close-window", (GCallback) ___lambda190__widgets_appbar_close_window, self, 0);
	_tmp4_ = _data51_->appbar;
	g_signal_connect_object (_tmp4_, "quit-fullscreen", (GCallback) ___lambda191__widgets_appbar_quit_fullscreen, self, 0);
	widgets_config_window_init ((WidgetsConfigWindow*) self, workspace_manager, tabbar);
	_tmp5_ = _data51_->appbar;
	widgets_window_init_fullscreen_handler (self, _tmp5_);
	g_signal_connect_data ((GtkWidget*) self, "window-state-event", (GCallback) ___lambda224__gtk_widget_window_state_event, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	if (!widgets_window_have_terminal_at_same_workspace (self)) {
		gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
	}
	_tmp6_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp6_);
	overlay = _tmp6_;
	_tmp7_ = widgets_resize_grip_new (self);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->resize_grip);
	self->priv->resize_grip = _tmp7_;
	_tmp8_ = ((WidgetsConfigWindow*) self)->top_box;
	_tmp9_ = self->fullscreen_box;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 0);
	if (self->tabbar_at_the_bottom) {
		GtkBox* _tmp10_;
		GtkBox* _tmp11_;
		GtkBox* _tmp12_;
		_tmp10_ = ((WidgetsConfigWindow*) self)->box;
		gtk_box_pack_start (_tmp10_, (GtkWidget*) workspace_manager, TRUE, TRUE, (guint) 0);
		_tmp11_ = ((WidgetsConfigWindow*) self)->box;
		_tmp12_ = ((WidgetsConfigWindow*) self)->top_box;
		gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 0);
	} else {
		GtkBox* _tmp13_;
		GtkBox* _tmp14_;
		GtkBox* _tmp15_;
		GtkBox* _tmp16_;
		WidgetsResizeGrip* _tmp17_;
		_tmp13_ = ((WidgetsConfigWindow*) self)->box;
		_tmp14_ = ((WidgetsConfigWindow*) self)->top_box;
		gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
		_tmp15_ = ((WidgetsConfigWindow*) self)->box;
		gtk_box_pack_start (_tmp15_, (GtkWidget*) workspace_manager, TRUE, TRUE, (guint) 0);
		_tmp16_ = ((WidgetsConfigWindow*) self)->box;
		_tmp17_ = self->priv->resize_grip;
		gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 0);
	}
	_tmp18_ = overlay;
	_tmp19_ = ((WidgetsConfigWindow*) self)->box;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = overlay;
	_tmp21_ = _data51_->appbar;
	gtk_overlay_add_overlay (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = overlay;
	widgets_window_add_widget (self, (GtkWidget*) _tmp22_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (overlay);
	block51_data_unref (_data51_);
	_data51_ = NULL;
}

static void
widgets_window_real_window_save_before_quit (WidgetsConfigWindow* base)
{
	WidgetsWindow * self;
	cairo_rectangle_int_t rect = {0};
	GdkWindow* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	self = (WidgetsWindow*) base;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_frame_extents (_tmp0_, &_tmp1_);
	rect = _tmp1_;
	if (widgets_config_window_window_is_normal ((WidgetsConfigWindow*) self)) {
		ConfigConfig* _tmp2_;
		ConfigConfig* _tmp3_;
		GKeyFile* _tmp4_;
		cairo_rectangle_int_t _tmp5_;
		ConfigConfig* _tmp6_;
		GKeyFile* _tmp7_;
		cairo_rectangle_int_t _tmp8_;
		ConfigConfig* _tmp9_;
		_tmp2_ = ((WidgetsConfigWindow*) self)->config;
		config_config_load_config (_tmp2_);
		_tmp3_ = ((WidgetsConfigWindow*) self)->config;
		_tmp4_ = _tmp3_->config_file;
		_tmp5_ = rect;
		g_key_file_set_integer (_tmp4_, "advanced", "window_width", _tmp5_.width);
		_tmp6_ = ((WidgetsConfigWindow*) self)->config;
		_tmp7_ = _tmp6_->config_file;
		_tmp8_ = rect;
		g_key_file_set_integer (_tmp7_, "advanced", "window_height", _tmp8_.height);
		_tmp9_ = ((WidgetsConfigWindow*) self)->config;
		config_config_save (_tmp9_);
	}
}

static GdkCursorType*
_gdk_cursor_type_dup (GdkCursorType* self)
{
	GdkCursorType* dup;
	dup = g_new0 (GdkCursorType, 1);
	memcpy (dup, self, sizeof (GdkCursorType));
	return dup;
}

static gpointer
__gdk_cursor_type_dup0 (gpointer self)
{
	return self ? _gdk_cursor_type_dup (self) : NULL;
}

static GdkCursorType*
widgets_window_real_get_cursor_type (WidgetsConfigWindow* base,
                                     gdouble x,
                                     gdouble y)
{
	WidgetsWindow * self;
	gint window_x = 0;
	gint window_y = 0;
	GdkWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint left_side_start = 0;
	gint left_side_end = 0;
	gint right_side_start = 0;
	gint right_side_end = 0;
	gint top_side_start = 0;
	gint top_side_end = 0;
	gint bottom_side_start = 0;
	gint bottom_side_end = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GdkCursorType* result;
	self = (WidgetsWindow*) base;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp0_, &_tmp1_, &_tmp2_);
	window_x = _tmp1_;
	window_y = _tmp2_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	width = _tmp3_;
	height = _tmp4_;
	left_side_start = (window_x + self->window_frame_margin_start) - constant_RESPONSE_RADIUS;
	left_side_end = window_x + self->window_frame_margin_start;
	right_side_start = (window_x + width) - self->window_frame_margin_end;
	right_side_end = ((window_x + width) - self->window_frame_margin_end) + constant_RESPONSE_RADIUS;
	top_side_start = (window_y + self->window_frame_margin_top) - constant_RESPONSE_RADIUS;
	top_side_end = window_y + self->window_frame_margin_top;
	bottom_side_start = (window_y + height) - self->window_frame_margin_bottom;
	bottom_side_end = ((window_y + height) - self->window_frame_margin_bottom) + constant_RESPONSE_RADIUS;
	if (x > ((gdouble) left_side_start)) {
		_tmp5_ = x < ((gdouble) left_side_end);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		if (y > ((gdouble) top_side_start)) {
			_tmp6_ = y < ((gdouble) top_side_end);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GdkCursorType _tmp7_;
			GdkCursorType* _tmp8_;
			_tmp7_ = GDK_TOP_LEFT_CORNER;
			_tmp8_ = __gdk_cursor_type_dup0 (&_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			gboolean _tmp9_ = FALSE;
			if (y > ((gdouble) bottom_side_start)) {
				_tmp9_ = y < ((gdouble) bottom_side_end);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GdkCursorType _tmp10_;
				GdkCursorType* _tmp11_;
				_tmp10_ = GDK_BOTTOM_LEFT_CORNER;
				_tmp11_ = __gdk_cursor_type_dup0 (&_tmp10_);
				result = _tmp11_;
				return result;
			}
		}
	} else {
		gboolean _tmp12_ = FALSE;
		if (x > ((gdouble) right_side_start)) {
			_tmp12_ = x < ((gdouble) right_side_end);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gboolean _tmp13_ = FALSE;
			if (y > ((gdouble) top_side_start)) {
				_tmp13_ = y < ((gdouble) top_side_end);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GdkCursorType _tmp14_;
				GdkCursorType* _tmp15_;
				_tmp14_ = GDK_TOP_RIGHT_CORNER;
				_tmp15_ = __gdk_cursor_type_dup0 (&_tmp14_);
				result = _tmp15_;
				return result;
			} else {
				gboolean _tmp16_ = FALSE;
				if (y > ((gdouble) bottom_side_start)) {
					_tmp16_ = y < ((gdouble) bottom_side_end);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					GdkCursorType _tmp17_;
					GdkCursorType* _tmp18_;
					_tmp17_ = GDK_BOTTOM_RIGHT_CORNER;
					_tmp18_ = __gdk_cursor_type_dup0 (&_tmp17_);
					result = _tmp18_;
					return result;
				}
			}
		}
	}
	if (x > ((gdouble) left_side_start)) {
		_tmp19_ = x < ((gdouble) left_side_end);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gboolean _tmp20_ = FALSE;
		if (y > ((gdouble) top_side_end)) {
			_tmp20_ = y < ((gdouble) bottom_side_start);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GdkCursorType _tmp21_;
			GdkCursorType* _tmp22_;
			_tmp21_ = GDK_LEFT_SIDE;
			_tmp22_ = __gdk_cursor_type_dup0 (&_tmp21_);
			result = _tmp22_;
			return result;
		}
	} else {
		gboolean _tmp23_ = FALSE;
		if (x > ((gdouble) right_side_start)) {
			_tmp23_ = x < ((gdouble) right_side_end);
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gboolean _tmp24_ = FALSE;
			if (y > ((gdouble) top_side_end)) {
				_tmp24_ = y < ((gdouble) bottom_side_start);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GdkCursorType _tmp25_;
				GdkCursorType* _tmp26_;
				_tmp25_ = GDK_RIGHT_SIDE;
				_tmp26_ = __gdk_cursor_type_dup0 (&_tmp25_);
				result = _tmp26_;
				return result;
			}
		} else {
			gboolean _tmp27_ = FALSE;
			if (y > ((gdouble) top_side_start)) {
				_tmp27_ = y < ((gdouble) top_side_end);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				GdkCursorType _tmp28_;
				GdkCursorType* _tmp29_;
				_tmp28_ = GDK_TOP_SIDE;
				_tmp29_ = __gdk_cursor_type_dup0 (&_tmp28_);
				result = _tmp29_;
				return result;
			} else {
				gboolean _tmp30_ = FALSE;
				if (y > ((gdouble) bottom_side_start)) {
					_tmp30_ = y < ((gdouble) bottom_side_end);
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					GdkCursorType _tmp31_;
					GdkCursorType* _tmp32_;
					_tmp31_ = GDK_BOTTOM_SIDE;
					_tmp32_ = __gdk_cursor_type_dup0 (&_tmp31_);
					result = _tmp32_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static GdkCursorType*
widgets_window_real_get_frame_cursor_type (WidgetsConfigWindow* base,
                                           gdouble x,
                                           gdouble y)
{
	WidgetsWindow * self;
	gint window_x = 0;
	gint window_y = 0;
	GdkWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint left_side_start = 0;
	gint left_side_end = 0;
	gint right_side_start = 0;
	gint right_side_end = 0;
	gint top_side_start = 0;
	gint top_side_end = 0;
	gint bottom_side_start = 0;
	gint bottom_side_end = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GdkCursorType* result;
	self = (WidgetsWindow*) base;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp0_, &_tmp1_, &_tmp2_);
	window_x = _tmp1_;
	window_y = _tmp2_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	width = _tmp3_;
	height = _tmp4_;
	left_side_start = window_x;
	left_side_end = window_x + constant_RESPONSE_RADIUS;
	right_side_start = (window_x + width) - constant_RESPONSE_RADIUS;
	right_side_end = window_x + width;
	top_side_start = window_y;
	top_side_end = window_y + constant_RESPONSE_RADIUS;
	bottom_side_start = (window_y + height) - constant_RESPONSE_RADIUS;
	bottom_side_end = window_y + height;
	if (x > ((gdouble) left_side_start)) {
		_tmp5_ = x < ((gdouble) left_side_end);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		if (y > ((gdouble) top_side_start)) {
			_tmp6_ = y < ((gdouble) top_side_end);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GdkCursorType _tmp7_;
			GdkCursorType* _tmp8_;
			_tmp7_ = GDK_TOP_LEFT_CORNER;
			_tmp8_ = __gdk_cursor_type_dup0 (&_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			gboolean _tmp9_ = FALSE;
			if (y > ((gdouble) bottom_side_start)) {
				_tmp9_ = y < ((gdouble) bottom_side_end);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GdkCursorType _tmp10_;
				GdkCursorType* _tmp11_;
				_tmp10_ = GDK_BOTTOM_LEFT_CORNER;
				_tmp11_ = __gdk_cursor_type_dup0 (&_tmp10_);
				result = _tmp11_;
				return result;
			}
		}
	} else {
		gboolean _tmp12_ = FALSE;
		if (x > ((gdouble) right_side_start)) {
			_tmp12_ = x < ((gdouble) right_side_end);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gboolean _tmp13_ = FALSE;
			if (y > ((gdouble) top_side_start)) {
				_tmp13_ = y < ((gdouble) top_side_end);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GdkCursorType _tmp14_;
				GdkCursorType* _tmp15_;
				_tmp14_ = GDK_TOP_RIGHT_CORNER;
				_tmp15_ = __gdk_cursor_type_dup0 (&_tmp14_);
				result = _tmp15_;
				return result;
			} else {
				gboolean _tmp16_ = FALSE;
				if (y > ((gdouble) bottom_side_start)) {
					_tmp16_ = y < ((gdouble) bottom_side_end);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					GdkCursorType _tmp17_;
					GdkCursorType* _tmp18_;
					_tmp17_ = GDK_BOTTOM_RIGHT_CORNER;
					_tmp18_ = __gdk_cursor_type_dup0 (&_tmp17_);
					result = _tmp18_;
					return result;
				}
			}
		}
	}
	if (x > ((gdouble) left_side_start)) {
		_tmp19_ = x < ((gdouble) left_side_end);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gboolean _tmp20_ = FALSE;
		if (y > ((gdouble) top_side_end)) {
			_tmp20_ = y < ((gdouble) bottom_side_start);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GdkCursorType _tmp21_;
			GdkCursorType* _tmp22_;
			_tmp21_ = GDK_LEFT_SIDE;
			_tmp22_ = __gdk_cursor_type_dup0 (&_tmp21_);
			result = _tmp22_;
			return result;
		}
	} else {
		gboolean _tmp23_ = FALSE;
		if (x > ((gdouble) right_side_start)) {
			_tmp23_ = x < ((gdouble) right_side_end);
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gboolean _tmp24_ = FALSE;
			if (y > ((gdouble) top_side_end)) {
				_tmp24_ = y < ((gdouble) bottom_side_start);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GdkCursorType _tmp25_;
				GdkCursorType* _tmp26_;
				_tmp25_ = GDK_RIGHT_SIDE;
				_tmp26_ = __gdk_cursor_type_dup0 (&_tmp25_);
				result = _tmp26_;
				return result;
			}
		} else {
			gboolean _tmp27_ = FALSE;
			if (y > ((gdouble) top_side_start)) {
				_tmp27_ = y < ((gdouble) top_side_end);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				GdkCursorType _tmp28_;
				GdkCursorType* _tmp29_;
				_tmp28_ = GDK_TOP_SIDE;
				_tmp29_ = __gdk_cursor_type_dup0 (&_tmp28_);
				result = _tmp29_;
				return result;
			} else {
				gboolean _tmp30_ = FALSE;
				if (y > ((gdouble) bottom_side_start)) {
					_tmp30_ = y < ((gdouble) bottom_side_end);
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					GdkCursorType _tmp31_;
					GdkCursorType* _tmp32_;
					_tmp31_ = GDK_BOTTOM_SIDE;
					_tmp32_ = __gdk_cursor_type_dup0 (&_tmp31_);
					result = _tmp32_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static void
widgets_window_class_init (WidgetsWindowClass * klass,
                           gpointer klass_data)
{
	widgets_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WidgetsWindow_private_offset);
	((WidgetsConfigWindowClass *) klass)->toggle_fullscreen = (void (*) (WidgetsConfigWindow*)) widgets_window_real_toggle_fullscreen;
	((WidgetsConfigWindowClass *) klass)->update_frame = (void (*) (WidgetsConfigWindow*)) widgets_window_real_update_frame;
	((WidgetsWindowClass *) klass)->draw_window_below = (void (*) (WidgetsWindow*, cairo_t*)) widgets_window_real_draw_window_below;
	((WidgetsConfigWindowClass *) klass)->window_save_before_quit = (void (*) (WidgetsConfigWindow*)) widgets_window_real_window_save_before_quit;
	((WidgetsConfigWindowClass *) klass)->get_cursor_type = (GdkCursorType* (*) (WidgetsConfigWindow*, gdouble, gdouble)) widgets_window_real_get_cursor_type;
	((WidgetsConfigWindowClass *) klass)->get_frame_cursor_type = (GdkCursorType* (*) (WidgetsConfigWindow*, gdouble, gdouble)) widgets_window_real_get_frame_cursor_type;
	G_OBJECT_CLASS (klass)->finalize = widgets_window_finalize;
}

static void
widgets_window_instance_init (WidgetsWindow * self,
                              gpointer klass)
{
	self->priv = widgets_window_get_instance_private (self);
	self->draw_tabbar_line = TRUE;
	self->window_default_scale = 0.618;
	self->window_frame_margin_bottom = 60;
	self->window_frame_margin_end = 50;
	self->window_frame_margin_start = 50;
	self->window_frame_margin_top = 50;
	self->tabbar_at_the_bottom = FALSE;
	self->window_fullscreen_monitor_height = constant_TITLEBAR_HEIGHT * 2;
	self->window_fullscreen_monitor_timeout = 150;
	self->window_fullscreen_response_height = 5;
	self->window_widget_margin_bottom = 2;
	self->window_widget_margin_end = 2;
	self->window_widget_margin_start = 2;
	self->window_widget_margin_top = 1;
}

static void
widgets_window_finalize (GObject * obj)
{
	WidgetsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_WINDOW, WidgetsWindow);
	_g_object_unref0 (self->fullscreen_box);
	_g_object_unref0 (self->spacing_box);
	_g_object_unref0 (self->priv->resize_grip);
	G_OBJECT_CLASS (widgets_window_parent_class)->finalize (obj);
}

static GType
widgets_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsWindow), 0, (GInstanceInitFunc) widgets_window_instance_init, NULL };
	GType widgets_window_type_id;
	widgets_window_type_id = g_type_register_static (WIDGETS_TYPE_CONFIG_WINDOW, "WidgetsWindow", &g_define_type_info, 0);
	WidgetsWindow_private_offset = g_type_add_instance_private (widgets_window_type_id, sizeof (WidgetsWindowPrivate));
	return widgets_window_type_id;
}

GType
widgets_window_get_type (void)
{
	static volatile gsize widgets_window_type_id__once = 0;
	if (g_once_init_enter (&widgets_window_type_id__once)) {
		GType widgets_window_type_id;
		widgets_window_type_id = widgets_window_get_type_once ();
		g_once_init_leave (&widgets_window_type_id__once, widgets_window_type_id);
	}
	return widgets_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

