/* MountManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MountManager.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DEJA_DUP_MOUNT_MANAGER_0_PROPERTY,
	DEJA_DUP_MOUNT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* deja_dup_mount_manager_properties[DEJA_DUP_MOUNT_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupMountManagerConfirmFusermountData DejaDupMountManagerConfirmFusermountData;
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _DejaDupMountManagerMountData DejaDupMountManagerMountData;
typedef struct _Block7Data Block7Data;
typedef struct _DejaDupMountManagerFixStaleMountpointData DejaDupMountManagerFixStaleMountpointData;
typedef struct _DejaDupMountManagerIsMountpointData DejaDupMountManagerIsMountpointData;
typedef struct _DejaDupMountManagerDescendRecurseData DejaDupMountManagerDescendRecurseData;
typedef struct _DejaDupMountManagerDescendData DejaDupMountManagerDescendData;

struct _DejaDupMountManagerPrivate {
	GHashTable* operations;
};

struct _DejaDupMountManagerConfirmFusermountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupMountManager* self;
	GSubprocess* process;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSubprocess* _tmp2_;
	GSubprocess* _tmp3_;
	GSubprocess* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	DejaDupMountManager* self;
	gchar* _error_;
	gpointer _async_data_;
};

struct _DejaDupMountManagerMountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupMountManager* self;
	DejaDupOperationState* state;
	gchar* tag;
	GCancellable* cancellable;
	gchar* result;
	Block6Data* _data6_;
	gchar* dir;
	DejaDupToolPlugin* _tmp0_;
	DejaDupBackend* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	DejaDupOperationMount* op;
	DejaDupOperationMount* _tmp8_;
	DejaDupOperationMount* _tmp9_;
	DejaDupOperationMount* _tmp10_;
	GHashTable* _tmp11_;
	DejaDupOperationMount* _tmp12_;
	DejaDupOperation* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	DejaDupOperationMount* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	DejaDupOperationMount* _tmp23_;
	GError* _inner_error0_;
};

struct _Block7Data {
	int _ref_count_;
	DejaDupMountManager* self;
	gboolean success;
};

struct _DejaDupMountManagerFixStaleMountpointData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupMountManager* self;
	gchar* dir;
	GFile* file;
	GFile* _tmp0_;
	GFileEnumerator* _tmp1_;
	GFileEnumerator* _tmp2_;
	GError* _inner_error0_;
};

struct _DejaDupMountManagerIsMountpointData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupMountManager* self;
	gchar* dir;
	gboolean result;
	GFile* file;
	GFile* _tmp0_;
	GFileInfo* info;
	GFileInfo* _tmp1_;
	GError* _inner_error0_;
};

struct _DejaDupMountManagerDescendRecurseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupMountManager* self;
	gchar* root;
	gchar* result;
	GFile* file;
	GFile* _tmp0_;
	GFileEnumerator* enumerator;
	GFile* _tmp1_;
	GFileEnumerator* _tmp2_;
	GList* infos;
	GFileEnumerator* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	gchar* _tmp6_;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	gchar* _tmp9_;
	GFile* full_child;
	GFile* _tmp10_;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _inner_error0_;
};

struct _DejaDupMountManagerDescendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupMountManager* self;
	gchar* root;
	gchar* tag;
	gchar* result;
	gchar* new_root;
	gchar* _tmp0_;
	gchar* _tmp1_;
};

static gint DejaDupMountManager_private_offset;
static gpointer deja_dup_mount_manager_parent_class = NULL;
static DejaDupMountManager* deja_dup_mount_manager_instance;
static DejaDupMountManager* deja_dup_mount_manager_instance = NULL;

static void deja_dup_mount_manager_confirm_fusermount_data_free (gpointer _data);
static void deja_dup_mount_manager_confirm_fusermount (DejaDupMountManager* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void deja_dup_mount_manager_confirm_fusermount_finish (DejaDupMountManager* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static gboolean deja_dup_mount_manager_confirm_fusermount_co (DejaDupMountManagerConfirmFusermountData* _data_);
static void deja_dup_mount_manager_confirm_fusermount_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void deja_dup_mount_manager_mount_data_free (gpointer _data);
static gboolean deja_dup_mount_manager_mount_co (DejaDupMountManagerMountData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void deja_dup_mount_manager_mount_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN gchar* deja_dup_mount_manager_get_mount_dir (DejaDupMountManager* self,
                                             DejaDupToolPlugin* tool,
                                             DejaDupBackend* backend);
static void deja_dup_mount_manager_fix_stale_mountpoint (DejaDupMountManager* self,
                                                  const gchar* dir,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void deja_dup_mount_manager_fix_stale_mountpoint_finish (DejaDupMountManager* self,
                                                         GAsyncResult* _res_);
static void deja_dup_mount_manager_is_mountpoint (DejaDupMountManager* self,
                                           const gchar* dir,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean deja_dup_mount_manager_is_mountpoint_finish (DejaDupMountManager* self,
                                                      GAsyncResult* _res_);
static void deja_dup_mount_manager_descend (DejaDupMountManager* self,
                                     const gchar* root,
                                     const gchar* tag,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gchar* deja_dup_mount_manager_descend_finish (DejaDupMountManager* self,
                                              GAsyncResult* _res_);
static void deja_dup_mount_manager_handle_operation_finished (DejaDupMountManager* self,
                                                       DejaDupOperation* op,
                                                       gboolean success,
                                                       gboolean canceled,
                                                       const gchar* detail);
static void _deja_dup_mount_manager_handle_operation_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                                                gboolean success,
                                                                                gboolean cancelled,
                                                                                const gchar* detail,
                                                                                gpointer self);
static void __lambda45_ (Block6Data* _data6_,
                  const gchar* errstr,
                  const gchar* detail);
static void ___lambda45__deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                                  const gchar* errstr,
                                                  const gchar* detail,
                                                  gpointer self);
VALA_EXTERN void deja_dup_wait (guint secs,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_);
VALA_EXTERN void deja_dup_wait_finish (GAsyncResult* _res_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda46_ (Block7Data* _data7_,
                  DejaDupOperation* op,
                  const gchar* dir);
static void ___lambda46__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void deja_dup_mount_manager_fix_stale_mountpoint_data_free (gpointer _data);
static gboolean deja_dup_mount_manager_fix_stale_mountpoint_co (DejaDupMountManagerFixStaleMountpointData* _data_);
static void deja_dup_mount_manager_fix_stale_mountpoint_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void deja_dup_mount_manager_is_mountpoint_data_free (gpointer _data);
static gboolean deja_dup_mount_manager_is_mountpoint_co (DejaDupMountManagerIsMountpointData* _data_);
static void deja_dup_mount_manager_is_mountpoint_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void deja_dup_mount_manager_descend_recurse_data_free (gpointer _data);
static void deja_dup_mount_manager_descend_recurse (DejaDupMountManager* self,
                                             const gchar* root,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gchar* deja_dup_mount_manager_descend_recurse_finish (DejaDupMountManager* self,
                                                      GAsyncResult* _res_);
static gboolean deja_dup_mount_manager_descend_recurse_co (DejaDupMountManagerDescendRecurseData* _data_);
static void deja_dup_mount_manager_descend_recurse_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_mount_manager_descend_data_free (gpointer _data);
static gboolean deja_dup_mount_manager_descend_co (DejaDupMountManagerDescendData* _data_);
static void deja_dup_mount_manager_descend_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static GObject * deja_dup_mount_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _g_object_unref_gdestroy_notify (void* data);
static void _g_free_gdestroy_notify (void* data);
static void deja_dup_mount_manager_finalize (GObject * obj);
static GType deja_dup_mount_manager_get_type_once (void);

GQuark
deja_dup_mount_error_quark (void)
{
	return g_quark_from_static_string ("deja-dup-mount-error-quark");
}

 G_GNUC_NO_INLINE static GType
deja_dup_mount_error_get_type_once (void)
{
	static const GEnumValue values[] = {{DEJA_DUP_MOUNT_ERROR_NO_FUSERMOUNT, "DEJA_DUP_MOUNT_ERROR_NO_FUSERMOUNT", "no-fusermount"}, {0, NULL, NULL}};
	GType deja_dup_mount_error_type_id;
	deja_dup_mount_error_type_id = g_enum_register_static ("DejaDupMountError", values);
	return deja_dup_mount_error_type_id;
}

GType
deja_dup_mount_error_get_type (void)
{
	static gsize deja_dup_mount_error_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_mount_error_type_id__once)) {
		GType deja_dup_mount_error_type_id;
		deja_dup_mount_error_type_id = deja_dup_mount_error_get_type_once ();
		g_once_init_leave (&deja_dup_mount_error_type_id__once, deja_dup_mount_error_type_id);
	}
	return deja_dup_mount_error_type_id__once;
}

static inline gpointer
deja_dup_mount_manager_get_instance_private (DejaDupMountManager* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupMountManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupMountManager*
deja_dup_mount_manager_get_instance (void)
{
	DejaDupMountManager* _tmp0_;
	DejaDupMountManager* _tmp2_;
	DejaDupMountManager* _tmp3_;
	DejaDupMountManager* result;
	_tmp0_ = deja_dup_mount_manager_instance;
	if (_tmp0_ == NULL) {
		DejaDupMountManager* _tmp1_;
		_tmp1_ = deja_dup_mount_manager_new ();
		_g_object_unref0 (deja_dup_mount_manager_instance);
		deja_dup_mount_manager_instance = _tmp1_;
	}
	_tmp2_ = deja_dup_mount_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
deja_dup_mount_manager_has_mounts (DejaDupMountManager* self)
{
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->operations;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > ((guint) 0);
	return result;
}

static void
deja_dup_mount_manager_confirm_fusermount_data_free (gpointer _data)
{
	DejaDupMountManagerConfirmFusermountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupMountManagerConfirmFusermountData, _data_);
}

static void
deja_dup_mount_manager_confirm_fusermount (DejaDupMountManager* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	DejaDupMountManagerConfirmFusermountData* _data_;
	DejaDupMountManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupMountManagerConfirmFusermountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_mount_manager_confirm_fusermount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_mount_manager_confirm_fusermount_co (_data_);
}

static void
deja_dup_mount_manager_confirm_fusermount_finish (DejaDupMountManager* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	DejaDupMountManagerConfirmFusermountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_mount_manager_confirm_fusermount_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	DejaDupMountManagerConfirmFusermountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_mount_manager_confirm_fusermount_co (_data_);
}

static gboolean
deja_dup_mount_manager_confirm_fusermount_co (DejaDupMountManagerConfirmFusermountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_build_filename (PKG_LIBEXEC_DIR, "deja-dup-find-fusermount", NULL);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = g_subprocess_new (G_SUBPROCESS_FLAGS_STDOUT_SILENCE | G_SUBPROCESS_FLAGS_STDERR_SILENCE, &_data_->_inner_error0_, _data_->_tmp1_, NULL);
		_data_->_tmp3_ = _data_->_tmp2_;
		_g_free0 (_data_->_tmp1_);
		_data_->process = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->process;
		_data_->_state_ = 1;
		g_subprocess_wait_check_async (_data_->_tmp4_, NULL, deja_dup_mount_manager_confirm_fusermount_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_check_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->process);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->process);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp5_ = g_error_new_literal (DEJA_DUP_MOUNT_ERROR, DEJA_DUP_MOUNT_ERROR_NO_FUSERMOUNT, _ ("The fusermount command is required, but was not found. Please install " \
"FUSE."));
		_data_->_inner_error0_ = _data_->_tmp5_;
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == DEJA_DUP_MOUNT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_mount_manager_mount_data_free (gpointer _data)
{
	DejaDupMountManagerMountData* _data_;
	_data_ = _data;
	_deja_dup_operation_state_unref0 (_data_->state);
	_g_free0 (_data_->tag);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupMountManagerMountData, _data_);
}

static gpointer
_deja_dup_operation_state_ref0 (gpointer self)
{
	return self ? deja_dup_operation_state_ref (self) : NULL;
}

void
deja_dup_mount_manager_mount (DejaDupMountManager* self,
                              DejaDupOperationState* state,
                              const gchar* tag,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	DejaDupMountManagerMountData* _data_;
	DejaDupMountManager* _tmp0_;
	DejaDupOperationState* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (DejaDupMountManagerMountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_mount_manager_mount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _deja_dup_operation_state_ref0 (state);
	_deja_dup_operation_state_unref0 (_data_->state);
	_data_->state = _tmp1_;
	_tmp2_ = g_strdup (tag);
	_g_free0 (_data_->tag);
	_data_->tag = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	deja_dup_mount_manager_mount_co (_data_);
}

gchar*
deja_dup_mount_manager_mount_finish (DejaDupMountManager* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gchar* result;
	DejaDupMountManagerMountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		DejaDupMountManager* self;
		self = _data6_->self;
		_g_free0 (_data6_->_error_);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
deja_dup_mount_manager_mount_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	DejaDupMountManagerMountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_mount_manager_mount_co (_data_);
}

static void
_deja_dup_mount_manager_handle_operation_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                                           gboolean success,
                                                                           gboolean cancelled,
                                                                           const gchar* detail,
                                                                           gpointer self)
{
	deja_dup_mount_manager_handle_operation_finished ((DejaDupMountManager*) self, _sender, success, cancelled, detail);
}

static void
__lambda45_ (Block6Data* _data6_,
             const gchar* errstr,
             const gchar* detail)
{
	DejaDupMountManager* self;
	gchar* _tmp0_;
	self = _data6_->self;
	g_return_if_fail (errstr != NULL);
	_tmp0_ = g_strdup (errstr);
	_g_free0 (_data6_->_error_);
	_data6_->_error_ = _tmp0_;
}

static void
___lambda45__deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                             const gchar* errstr,
                                             const gchar* detail,
                                             gpointer self)
{
	__lambda45_ (self, errstr, detail);
}

static gboolean
deja_dup_mount_manager_mount_co (DejaDupMountManagerMountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_data6_->_async_data_ = _data_;
	_data_->_state_ = 1;
	deja_dup_mount_manager_confirm_fusermount (_data_->self, deja_dup_mount_manager_mount_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_mount_manager_confirm_fusermount_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _data_->state->tool;
	_data_->_tmp1_ = _data_->state->backend;
	_data_->_tmp2_ = deja_dup_mount_manager_get_mount_dir (_data_->self, _data_->_tmp0_, _data_->_tmp1_);
	_data_->dir = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->dir;
	_data_->_state_ = 2;
	deja_dup_mount_manager_fix_stale_mountpoint (_data_->self, _data_->_tmp3_, deja_dup_mount_manager_mount_ready, _data_);
	return FALSE;
	_state_2:
	deja_dup_mount_manager_fix_stale_mountpoint_finish (_data_->self, _data_->_res_);
	_data_->_tmp4_ = _data_->dir;
	_data_->_state_ = 3;
	deja_dup_mount_manager_is_mountpoint (_data_->self, _data_->_tmp4_, deja_dup_mount_manager_mount_ready, _data_);
	return FALSE;
	_state_3:
	if (deja_dup_mount_manager_is_mountpoint_finish (_data_->self, _data_->_res_)) {
		_data_->_tmp5_ = _data_->dir;
		_data_->_state_ = 4;
		deja_dup_mount_manager_descend (_data_->self, _data_->_tmp5_, _data_->tag, deja_dup_mount_manager_mount_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp6_ = deja_dup_mount_manager_descend_finish (_data_->self, _data_->_res_);
		_data_->result = _data_->_tmp6_;
		_g_free0 (_data_->dir);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = g_strdup ("");
	_data_->_data6_->_error_ = _data_->_tmp7_;
	_data_->_tmp8_ = deja_dup_operation_mount_new (_data_->state);
	_data_->op = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->op;
	g_signal_connect_object ((DejaDupOperation*) _data_->_tmp9_, "done", (GCallback) _deja_dup_mount_manager_handle_operation_finished_deja_dup_operation_done, _data_->self, 0);
	_data_->_tmp10_ = _data_->op;
	g_signal_connect_data ((DejaDupOperation*) _data_->_tmp10_, "raise-error", (GCallback) ___lambda45__deja_dup_operation_raise_error, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
	_data_->_tmp11_ = _data_->self->priv->operations;
	_data_->_tmp12_ = _data_->op;
	_data_->_tmp13_ = _g_object_ref0 ((DejaDupOperation*) _data_->_tmp12_);
	_data_->_tmp14_ = _data_->dir;
	_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
	g_hash_table_insert (_data_->_tmp11_, _data_->_tmp13_, _data_->_tmp15_);
	_data_->_tmp16_ = _data_->op;
	deja_dup_operation_start ((DejaDupOperation*) _data_->_tmp16_, NULL, NULL);
	while (TRUE) {
		if (!(!g_cancellable_is_cancelled (_data_->cancellable))) {
			break;
		}
		_data_->_state_ = 5;
		deja_dup_wait ((guint) 1, deja_dup_mount_manager_mount_ready, _data_);
		return FALSE;
		_state_5:
		deja_dup_wait_finish (_data_->_res_);
		_data_->_tmp17_ = _data_->_data6_->_error_;
		if (g_strcmp0 (_data_->_tmp17_, "") != 0) {
			_data_->_tmp18_ = _data_->_data6_->_error_;
			_data_->_tmp19_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _data_->_tmp18_);
			_data_->_inner_error0_ = _data_->_tmp19_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->op);
			_g_free0 (_data_->dir);
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp20_ = _data_->dir;
		_data_->_state_ = 6;
		deja_dup_mount_manager_is_mountpoint (_data_->self, _data_->_tmp20_, deja_dup_mount_manager_mount_ready, _data_);
		return FALSE;
		_state_6:
		if (deja_dup_mount_manager_is_mountpoint_finish (_data_->self, _data_->_res_)) {
			_data_->_tmp21_ = _data_->dir;
			_data_->_state_ = 7;
			deja_dup_mount_manager_descend (_data_->self, _data_->_tmp21_, _data_->tag, deja_dup_mount_manager_mount_ready, _data_);
			return FALSE;
			_state_7:
			_data_->_tmp22_ = deja_dup_mount_manager_descend_finish (_data_->self, _data_->_res_);
			_data_->result = _data_->_tmp22_;
			_g_object_unref0 (_data_->op);
			_g_free0 (_data_->dir);
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp23_ = _data_->op;
	deja_dup_operation_stop ((DejaDupOperation*) _data_->_tmp23_);
	_data_->result = NULL;
	_g_object_unref0 (_data_->op);
	_g_free0 (_data_->dir);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		DejaDupMountManager* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda46_ (Block7Data* _data7_,
             DejaDupOperation* op,
             const gchar* dir)
{
	DejaDupMountManager* self;
	gboolean _tmp0_ = FALSE;
	self = _data7_->self;
	g_return_if_fail (op != NULL);
	g_return_if_fail (dir != NULL);
	if (_data7_->success) {
		_tmp0_ = deja_dup_mount_manager_unmount (self, dir);
	} else {
		_tmp0_ = FALSE;
	}
	_data7_->success = _tmp0_;
}

static void
___lambda46__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda46_ (self, (DejaDupOperation*) key, (const gchar*) value);
}

gboolean
deja_dup_mount_manager_unmount_all (DejaDupMountManager* self)
{
	Block7Data* _data7_;
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->success = TRUE;
	_tmp0_ = self->priv->operations;
	g_hash_table_foreach (_tmp0_, ___lambda46__gh_func, _data7_);
	result = _data7_->success;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

gboolean
deja_dup_mount_manager_unmount (DejaDupMountManager* self,
                                const gchar* dir)
{
	gchar* fusermount = NULL;
	gchar* _tmp0_;
	gboolean _tmp5_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	_tmp0_ = g_build_filename (PKG_LIBEXEC_DIR, "fusermount", NULL);
	fusermount = _tmp0_;
	{
		GSubprocess* process = NULL;
		const gchar* _tmp1_;
		GSubprocess* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GSubprocess* _tmp4_;
		_tmp1_ = fusermount;
		_tmp2_ = g_subprocess_new (G_SUBPROCESS_FLAGS_STDOUT_SILENCE | G_SUBPROCESS_FLAGS_STDERR_SILENCE, &_inner_error0_, _tmp1_, "-u", dir, NULL);
		process = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = process;
		_tmp3_ = g_subprocess_wait_check (_tmp4_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (process);
			goto __catch0_g_error;
		}
		result = _tmp3_;
		_g_object_unref0 (process);
		_g_free0 (fusermount);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_free0 (fusermount);
		return result;
	}
	__finally0:
	_g_free0 (fusermount);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp5_;
}

gchar*
deja_dup_mount_manager_get_mount_dir (DejaDupMountManager* self,
                                      DejaDupToolPlugin* tool,
                                      DejaDupBackend* backend)
{
	gchar* rundir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* id = NULL;
	gchar* _tmp2_;
	gchar* dir = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tool != NULL, NULL);
	g_return_val_if_fail (backend != NULL, NULL);
	_tmp0_ = g_get_user_runtime_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	rundir = _tmp1_;
	_tmp2_ = deja_dup_backend_get_unique_id (backend);
	id = _tmp2_;
	_tmp3_ = deja_dup_tool_plugin_get_name (tool);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_filename (rundir, "deja-dup", _tmp4_, id, NULL);
	dir = _tmp5_;
	g_mkdir_with_parents (dir, 0700);
	result = dir;
	_g_free0 (id);
	_g_free0 (rundir);
	return result;
}

static void
deja_dup_mount_manager_fix_stale_mountpoint_data_free (gpointer _data)
{
	DejaDupMountManagerFixStaleMountpointData* _data_;
	_data_ = _data;
	_g_free0 (_data_->dir);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupMountManagerFixStaleMountpointData, _data_);
}

static void
deja_dup_mount_manager_fix_stale_mountpoint (DejaDupMountManager* self,
                                             const gchar* dir,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	DejaDupMountManagerFixStaleMountpointData* _data_;
	DejaDupMountManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_data_ = g_slice_new0 (DejaDupMountManagerFixStaleMountpointData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_mount_manager_fix_stale_mountpoint_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (dir);
	_g_free0 (_data_->dir);
	_data_->dir = _tmp1_;
	deja_dup_mount_manager_fix_stale_mountpoint_co (_data_);
}

static void
deja_dup_mount_manager_fix_stale_mountpoint_finish (DejaDupMountManager* self,
                                                    GAsyncResult* _res_)
{
	DejaDupMountManagerFixStaleMountpointData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_mount_manager_fix_stale_mountpoint_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	DejaDupMountManagerFixStaleMountpointData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_mount_manager_fix_stale_mountpoint_co (_data_);
}

static gboolean
deja_dup_mount_manager_fix_stale_mountpoint_co (DejaDupMountManagerFixStaleMountpointData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->dir);
	_data_->file = _data_->_tmp0_;
	{
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, deja_dup_mount_manager_fix_stale_mountpoint_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_file_enumerate_children_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_g_object_unref0 (_data_->_tmp2_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		deja_dup_mount_manager_unmount (_data_->self, _data_->dir);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_mount_manager_is_mountpoint_data_free (gpointer _data)
{
	DejaDupMountManagerIsMountpointData* _data_;
	_data_ = _data;
	_g_free0 (_data_->dir);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupMountManagerIsMountpointData, _data_);
}

static void
deja_dup_mount_manager_is_mountpoint (DejaDupMountManager* self,
                                      const gchar* dir,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	DejaDupMountManagerIsMountpointData* _data_;
	DejaDupMountManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_data_ = g_slice_new0 (DejaDupMountManagerIsMountpointData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_mount_manager_is_mountpoint_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (dir);
	_g_free0 (_data_->dir);
	_data_->dir = _tmp1_;
	deja_dup_mount_manager_is_mountpoint_co (_data_);
}

static gboolean
deja_dup_mount_manager_is_mountpoint_finish (DejaDupMountManager* self,
                                             GAsyncResult* _res_)
{
	gboolean result;
	DejaDupMountManagerIsMountpointData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
deja_dup_mount_manager_is_mountpoint_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	DejaDupMountManagerIsMountpointData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_mount_manager_is_mountpoint_co (_data_);
}

static gboolean
deja_dup_mount_manager_is_mountpoint_co (DejaDupMountManagerIsMountpointData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->dir);
	_data_->file = _data_->_tmp0_;
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, deja_dup_mount_manager_is_mountpoint_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->result = g_file_info_get_attribute_boolean (_data_->info, G_FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_object_unref0 (_data_->file);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_mount_manager_descend_recurse_data_free (gpointer _data)
{
	DejaDupMountManagerDescendRecurseData* _data_;
	_data_ = _data;
	_g_free0 (_data_->root);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupMountManagerDescendRecurseData, _data_);
}

static void
deja_dup_mount_manager_descend_recurse (DejaDupMountManager* self,
                                        const gchar* root,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	DejaDupMountManagerDescendRecurseData* _data_;
	DejaDupMountManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	_data_ = g_slice_new0 (DejaDupMountManagerDescendRecurseData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_mount_manager_descend_recurse_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (root);
	_g_free0 (_data_->root);
	_data_->root = _tmp1_;
	deja_dup_mount_manager_descend_recurse_co (_data_);
}

static gchar*
deja_dup_mount_manager_descend_recurse_finish (DejaDupMountManager* self,
                                               GAsyncResult* _res_)
{
	gchar* result;
	DejaDupMountManagerDescendRecurseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_mount_manager_descend_recurse_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	DejaDupMountManagerDescendRecurseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_mount_manager_descend_recurse_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
deja_dup_mount_manager_descend_recurse_co (DejaDupMountManagerDescendRecurseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->root);
	_data_->file = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->file;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, deja_dup_mount_manager_descend_recurse_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_enumerate_children_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->enumerator = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->enumerator;
		_data_->_state_ = 2;
		g_file_enumerator_next_files_async (_data_->_tmp3_, 2, G_PRIORITY_LOW, NULL, deja_dup_mount_manager_descend_recurse_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = g_file_enumerator_next_files_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->infos = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->enumerator);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->infos;
		if (g_list_length (_data_->_tmp5_) != ((guint) 1)) {
			_data_->_tmp6_ = g_strdup (_data_->root);
			_data_->result = _data_->_tmp6_;
			(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
			_g_object_unref0 (_data_->enumerator);
			_g_object_unref0 (_data_->file);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp7_ = _data_->infos;
		_data_->_tmp8_ = _data_->_tmp7_->data;
		if (g_file_info_get_file_type ((GFileInfo*) _data_->_tmp8_) != G_FILE_TYPE_DIRECTORY) {
			_data_->_tmp9_ = g_strdup (_data_->root);
			_data_->result = _data_->_tmp9_;
			(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
			_g_object_unref0 (_data_->enumerator);
			_g_object_unref0 (_data_->file);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = _data_->file;
		_data_->_tmp11_ = _data_->infos;
		_data_->_tmp12_ = _data_->_tmp11_->data;
		_data_->_tmp13_ = g_file_info_get_name ((GFileInfo*) _data_->_tmp12_);
		_data_->_tmp14_ = g_file_get_child (_data_->_tmp10_, _data_->_tmp13_);
		_data_->full_child = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->full_child;
		_data_->_tmp16_ = g_file_get_path (_data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_state_ = 3;
		deja_dup_mount_manager_descend_recurse (_data_->self, _data_->_tmp17_, deja_dup_mount_manager_descend_recurse_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp18_ = deja_dup_mount_manager_descend_recurse_finish (_data_->self, _data_->_res_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_g_free0 (_data_->_tmp17_);
		_data_->result = _data_->_tmp19_;
		_g_object_unref0 (_data_->full_child);
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		_g_object_unref0 (_data_->enumerator);
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp20_ = g_strdup (_data_->root);
		_data_->result = _data_->_tmp20_;
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_object_unref0 (_data_->file);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_mount_manager_descend_data_free (gpointer _data)
{
	DejaDupMountManagerDescendData* _data_;
	_data_ = _data;
	_g_free0 (_data_->root);
	_g_free0 (_data_->tag);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupMountManagerDescendData, _data_);
}

static void
deja_dup_mount_manager_descend (DejaDupMountManager* self,
                                const gchar* root,
                                const gchar* tag,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	DejaDupMountManagerDescendData* _data_;
	DejaDupMountManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	g_return_if_fail (tag != NULL);
	_data_ = g_slice_new0 (DejaDupMountManagerDescendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_mount_manager_descend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (root);
	_g_free0 (_data_->root);
	_data_->root = _tmp1_;
	_tmp2_ = g_strdup (tag);
	_g_free0 (_data_->tag);
	_data_->tag = _tmp2_;
	deja_dup_mount_manager_descend_co (_data_);
}

static gchar*
deja_dup_mount_manager_descend_finish (DejaDupMountManager* self,
                                       GAsyncResult* _res_)
{
	gchar* result;
	DejaDupMountManagerDescendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_mount_manager_descend_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	DejaDupMountManagerDescendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_mount_manager_descend_co (_data_);
}

static gboolean
deja_dup_mount_manager_descend_co (DejaDupMountManagerDescendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_build_filename (_data_->root, "ids", _data_->tag, NULL);
	_data_->new_root = _data_->_tmp0_;
	_data_->_state_ = 1;
	deja_dup_mount_manager_descend_recurse (_data_->self, _data_->new_root, deja_dup_mount_manager_descend_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = deja_dup_mount_manager_descend_recurse_finish (_data_->self, _data_->_res_);
	_data_->result = _data_->_tmp1_;
	_g_free0 (_data_->new_root);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_mount_manager_handle_operation_finished (DejaDupMountManager* self,
                                                  DejaDupOperation* op,
                                                  gboolean success,
                                                  gboolean canceled,
                                                  const gchar* detail)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_tmp0_ = self->priv->operations;
	g_hash_table_remove (_tmp0_, op);
}

DejaDupMountManager*
deja_dup_mount_manager_construct (GType object_type)
{
	DejaDupMountManager * self = NULL;
	self = (DejaDupMountManager*) g_object_new (object_type, NULL);
	return self;
}

DejaDupMountManager*
deja_dup_mount_manager_new (void)
{
	return deja_dup_mount_manager_construct (DEJA_DUP_TYPE_MOUNT_MANAGER);
}

static void
_g_object_unref_gdestroy_notify (void* data)
{
	g_object_unref (data);
}

static void
_g_free_gdestroy_notify (void* data)
{
	g_free (data);
}

static GObject *
deja_dup_mount_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupMountManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (deja_dup_mount_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_MOUNT_MANAGER, DejaDupMountManager);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref_gdestroy_notify, _g_free_gdestroy_notify);
	_g_hash_table_unref0 (self->priv->operations);
	self->priv->operations = _tmp2_;
	return obj;
}

static void
deja_dup_mount_manager_class_init (DejaDupMountManagerClass * klass,
                                   gpointer klass_data)
{
	deja_dup_mount_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupMountManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = deja_dup_mount_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_mount_manager_finalize;
}

static void
deja_dup_mount_manager_instance_init (DejaDupMountManager * self,
                                      gpointer klass)
{
	self->priv = deja_dup_mount_manager_get_instance_private (self);
}

static void
deja_dup_mount_manager_finalize (GObject * obj)
{
	DejaDupMountManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_MOUNT_MANAGER, DejaDupMountManager);
	_g_hash_table_unref0 (self->priv->operations);
	G_OBJECT_CLASS (deja_dup_mount_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_mount_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupMountManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_mount_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupMountManager), 0, (GInstanceInitFunc) deja_dup_mount_manager_instance_init, NULL };
	GType deja_dup_mount_manager_type_id;
	deja_dup_mount_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupMountManager", &g_define_type_info, 0);
	DejaDupMountManager_private_offset = g_type_add_instance_private (deja_dup_mount_manager_type_id, sizeof (DejaDupMountManagerPrivate));
	return deja_dup_mount_manager_type_id;
}

GType
deja_dup_mount_manager_get_type (void)
{
	static gsize deja_dup_mount_manager_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_mount_manager_type_id__once)) {
		GType deja_dup_mount_manager_type_id;
		deja_dup_mount_manager_type_id = deja_dup_mount_manager_get_type_once ();
		g_once_init_leave (&deja_dup_mount_manager_type_id__once, deja_dup_mount_manager_type_id);
	}
	return deja_dup_mount_manager_type_id__once;
}

