// This file is generated by kconfig_compiler_kf6 from easyeffects_db_compressor.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_COMPRESSOR_H
#define DB_COMPRESSOR_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class Compressor : public KConfigBaseEE
{
  Q_OBJECT
  public:

    Compressor( const QString & masterGroup, const QString & instanceIndex );
    ~Compressor() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set dry
    */
    void setDry( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setDry: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 20)
      {
        qDebug() << "setDry: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mDry && !isDryImmutable()) {
        mDry = v;
        Q_EMIT dryChanged();
      }
    }

    Q_PROPERTY(double dry READ dry WRITE setDry NOTIFY dryChanged)
    Q_PROPERTY(bool isDryImmutable READ isDryImmutable CONSTANT)
    Q_PROPERTY(double defaultDryValue READ defaultDryValue CONSTANT)
    /**
      Get dry
    */
    double dry() const
    {
      return mDry;
    }

    /**
      Is dry Immutable
    */
    bool isDryImmutable() const
    {
      return isImmutable( QStringLiteral( "dry" ) );
    }

    /**
      Get dry default value
    */
    double defaultDryValue() const
    {
        return defaultDryValue_helper();
    }

    /**
      Set wet
    */
    void setWet( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setWet: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 20)
      {
        qDebug() << "setWet: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mWet && !isWetImmutable()) {
        mWet = v;
        Q_EMIT wetChanged();
      }
    }

    Q_PROPERTY(double wet READ wet WRITE setWet NOTIFY wetChanged)
    Q_PROPERTY(bool isWetImmutable READ isWetImmutable CONSTANT)
    Q_PROPERTY(double defaultWetValue READ defaultWetValue CONSTANT)
    /**
      Get wet
    */
    double wet() const
    {
      return mWet;
    }

    /**
      Is wet Immutable
    */
    bool isWetImmutable() const
    {
      return isImmutable( QStringLiteral( "wet" ) );
    }

    /**
      Get wet default value
    */
    double defaultWetValue() const
    {
        return defaultWetValue_helper();
    }

    /**
      Set modeLabels
    */
    void setModeLabels( const QStringList & v )
    {
      if (v != mModeLabels && !isModeLabelsImmutable()) {
        mModeLabels = v;
        Q_EMIT modeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList modeLabels READ modeLabels WRITE setModeLabels NOTIFY modeLabelsChanged)
    Q_PROPERTY(bool isModeLabelsImmutable READ isModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultModeLabelsValue READ defaultModeLabelsValue CONSTANT)
    /**
      Get modeLabels
    */
    QStringList modeLabels() const
    {
      return mModeLabels;
    }

    /**
      Is modeLabels Immutable
    */
    bool isModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "modeLabels" ) );
    }

    /**
      Get modeLabels default value
    */
    QStringList defaultModeLabelsValue() const
    {
        return defaultModeLabelsValue_helper();
    }

    /**
      Set Mode
    */
    void setMode( int v )
    {
      if (v != mMode && !isModeImmutable()) {
        mMode = v;
        Q_EMIT modeChanged();
      }
    }

    Q_PROPERTY(int mode READ mode WRITE setMode NOTIFY modeChanged)
    Q_PROPERTY(bool isModeImmutable READ isModeImmutable CONSTANT)
    Q_PROPERTY(int defaultModeValue READ defaultModeValue CONSTANT)
    /**
      Get Mode
    */
    int mode() const
    {
      return mMode;
    }

    /**
      Is Mode Immutable
    */
    bool isModeImmutable() const
    {
      return isImmutable( QStringLiteral( "mode" ) );
    }

    /**
      Get Mode default value
    */
    int defaultModeValue() const
    {
        return defaultModeValue_helper();
    }

    /**
      Set attack
    */
    void setAttack( double v )
    {
      if (v < 0)
      {
        qDebug() << "setAttack: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 2000)
      {
        qDebug() << "setAttack: value " << v << " is greater than the maximum value of 2000";
        v = 2000;
      }

      if (v != mAttack && !isAttackImmutable()) {
        mAttack = v;
        Q_EMIT attackChanged();
      }
    }

    Q_PROPERTY(double attack READ attack WRITE setAttack NOTIFY attackChanged)
    Q_PROPERTY(bool isAttackImmutable READ isAttackImmutable CONSTANT)
    Q_PROPERTY(double defaultAttackValue READ defaultAttackValue CONSTANT)
    /**
      Get attack
    */
    double attack() const
    {
      return mAttack;
    }

    /**
      Is attack Immutable
    */
    bool isAttackImmutable() const
    {
      return isImmutable( QStringLiteral( "attack" ) );
    }

    /**
      Get attack default value
    */
    double defaultAttackValue() const
    {
        return defaultAttackValue_helper();
    }

    /**
      Set release
    */
    void setRelease( double v )
    {
      if (v < 0)
      {
        qDebug() << "setRelease: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 5000)
      {
        qDebug() << "setRelease: value " << v << " is greater than the maximum value of 5000";
        v = 5000;
      }

      if (v != mRelease && !isReleaseImmutable()) {
        mRelease = v;
        Q_EMIT releaseChanged();
      }
    }

    Q_PROPERTY(double release READ release WRITE setRelease NOTIFY releaseChanged)
    Q_PROPERTY(bool isReleaseImmutable READ isReleaseImmutable CONSTANT)
    Q_PROPERTY(double defaultReleaseValue READ defaultReleaseValue CONSTANT)
    /**
      Get release
    */
    double release() const
    {
      return mRelease;
    }

    /**
      Is release Immutable
    */
    bool isReleaseImmutable() const
    {
      return isImmutable( QStringLiteral( "release" ) );
    }

    /**
      Get release default value
    */
    double defaultReleaseValue() const
    {
        return defaultReleaseValue_helper();
    }

    /**
      Set releaseThreshold
    */
    void setReleaseThreshold( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setReleaseThreshold: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 0)
      {
        qDebug() << "setReleaseThreshold: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mReleaseThreshold && !isReleaseThresholdImmutable()) {
        mReleaseThreshold = v;
        Q_EMIT releaseThresholdChanged();
      }
    }

    Q_PROPERTY(double releaseThreshold READ releaseThreshold WRITE setReleaseThreshold NOTIFY releaseThresholdChanged)
    Q_PROPERTY(bool isReleaseThresholdImmutable READ isReleaseThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultReleaseThresholdValue READ defaultReleaseThresholdValue CONSTANT)
    /**
      Get releaseThreshold
    */
    double releaseThreshold() const
    {
      return mReleaseThreshold;
    }

    /**
      Is releaseThreshold Immutable
    */
    bool isReleaseThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "releaseThreshold" ) );
    }

    /**
      Get releaseThreshold default value
    */
    double defaultReleaseThresholdValue() const
    {
        return defaultReleaseThresholdValue_helper();
    }

    /**
      Set threshold
    */
    void setThreshold( double v )
    {
      if (v < -60)
      {
        qDebug() << "setThreshold: value " << v << " is less than the minimum value of -60";
        v = -60;
      }

      if (v > 0)
      {
        qDebug() << "setThreshold: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mThreshold && !isThresholdImmutable()) {
        mThreshold = v;
        Q_EMIT thresholdChanged();
      }
    }

    Q_PROPERTY(double threshold READ threshold WRITE setThreshold NOTIFY thresholdChanged)
    Q_PROPERTY(bool isThresholdImmutable READ isThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultThresholdValue READ defaultThresholdValue CONSTANT)
    /**
      Get threshold
    */
    double threshold() const
    {
      return mThreshold;
    }

    /**
      Is threshold Immutable
    */
    bool isThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "threshold" ) );
    }

    /**
      Get threshold default value
    */
    double defaultThresholdValue() const
    {
        return defaultThresholdValue_helper();
    }

    /**
      Set ratio
    */
    void setRatio( double v )
    {
      if (v < 1)
      {
        qDebug() << "setRatio: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 100)
      {
        qDebug() << "setRatio: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (v != mRatio && !isRatioImmutable()) {
        mRatio = v;
        Q_EMIT ratioChanged();
      }
    }

    Q_PROPERTY(double ratio READ ratio WRITE setRatio NOTIFY ratioChanged)
    Q_PROPERTY(bool isRatioImmutable READ isRatioImmutable CONSTANT)
    Q_PROPERTY(double defaultRatioValue READ defaultRatioValue CONSTANT)
    /**
      Get ratio
    */
    double ratio() const
    {
      return mRatio;
    }

    /**
      Is ratio Immutable
    */
    bool isRatioImmutable() const
    {
      return isImmutable( QStringLiteral( "ratio" ) );
    }

    /**
      Get ratio default value
    */
    double defaultRatioValue() const
    {
        return defaultRatioValue_helper();
    }

    /**
      Set knee
    */
    void setKnee( double v )
    {
      if (v < -24)
      {
        qDebug() << "setKnee: value " << v << " is less than the minimum value of -24";
        v = -24;
      }

      if (v > 0)
      {
        qDebug() << "setKnee: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mKnee && !isKneeImmutable()) {
        mKnee = v;
        Q_EMIT kneeChanged();
      }
    }

    Q_PROPERTY(double knee READ knee WRITE setKnee NOTIFY kneeChanged)
    Q_PROPERTY(bool isKneeImmutable READ isKneeImmutable CONSTANT)
    Q_PROPERTY(double defaultKneeValue READ defaultKneeValue CONSTANT)
    /**
      Get knee
    */
    double knee() const
    {
      return mKnee;
    }

    /**
      Is knee Immutable
    */
    bool isKneeImmutable() const
    {
      return isImmutable( QStringLiteral( "knee" ) );
    }

    /**
      Get knee default value
    */
    double defaultKneeValue() const
    {
        return defaultKneeValue_helper();
    }

    /**
      Set makeup
    */
    void setMakeup( double v )
    {
      if (v < -60)
      {
        qDebug() << "setMakeup: value " << v << " is less than the minimum value of -60";
        v = -60;
      }

      if (v > 60)
      {
        qDebug() << "setMakeup: value " << v << " is greater than the maximum value of 60";
        v = 60;
      }

      if (v != mMakeup && !isMakeupImmutable()) {
        mMakeup = v;
        Q_EMIT makeupChanged();
      }
    }

    Q_PROPERTY(double makeup READ makeup WRITE setMakeup NOTIFY makeupChanged)
    Q_PROPERTY(bool isMakeupImmutable READ isMakeupImmutable CONSTANT)
    Q_PROPERTY(double defaultMakeupValue READ defaultMakeupValue CONSTANT)
    /**
      Get makeup
    */
    double makeup() const
    {
      return mMakeup;
    }

    /**
      Is makeup Immutable
    */
    bool isMakeupImmutable() const
    {
      return isImmutable( QStringLiteral( "makeup" ) );
    }

    /**
      Get makeup default value
    */
    double defaultMakeupValue() const
    {
        return defaultMakeupValue_helper();
    }

    /**
      Set boostAmount
    */
    void setBoostAmount( double v )
    {
      if (v < -72)
      {
        qDebug() << "setBoostAmount: value " << v << " is less than the minimum value of -72";
        v = -72;
      }

      if (v > 72)
      {
        qDebug() << "setBoostAmount: value " << v << " is greater than the maximum value of 72";
        v = 72;
      }

      if (v != mBoostAmount && !isBoostAmountImmutable()) {
        mBoostAmount = v;
        Q_EMIT boostAmountChanged();
      }
    }

    Q_PROPERTY(double boostAmount READ boostAmount WRITE setBoostAmount NOTIFY boostAmountChanged)
    Q_PROPERTY(bool isBoostAmountImmutable READ isBoostAmountImmutable CONSTANT)
    Q_PROPERTY(double defaultBoostAmountValue READ defaultBoostAmountValue CONSTANT)
    /**
      Get boostAmount
    */
    double boostAmount() const
    {
      return mBoostAmount;
    }

    /**
      Is boostAmount Immutable
    */
    bool isBoostAmountImmutable() const
    {
      return isImmutable( QStringLiteral( "boostAmount" ) );
    }

    /**
      Get boostAmount default value
    */
    double defaultBoostAmountValue() const
    {
        return defaultBoostAmountValue_helper();
    }

    /**
      Set boostThreshold
    */
    void setBoostThreshold( double v )
    {
      if (v < -120)
      {
        qDebug() << "setBoostThreshold: value " << v << " is less than the minimum value of -120";
        v = -120;
      }

      if (v > -60)
      {
        qDebug() << "setBoostThreshold: value " << v << " is greater than the maximum value of -60";
        v = -60;
      }

      if (v != mBoostThreshold && !isBoostThresholdImmutable()) {
        mBoostThreshold = v;
        Q_EMIT boostThresholdChanged();
      }
    }

    Q_PROPERTY(double boostThreshold READ boostThreshold WRITE setBoostThreshold NOTIFY boostThresholdChanged)
    Q_PROPERTY(bool isBoostThresholdImmutable READ isBoostThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultBoostThresholdValue READ defaultBoostThresholdValue CONSTANT)
    /**
      Get boostThreshold
    */
    double boostThreshold() const
    {
      return mBoostThreshold;
    }

    /**
      Is boostThreshold Immutable
    */
    bool isBoostThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "boostThreshold" ) );
    }

    /**
      Get boostThreshold default value
    */
    double defaultBoostThresholdValue() const
    {
        return defaultBoostThresholdValue_helper();
    }

    /**
      Set sidechainListen
    */
    void setSidechainListen( bool v )
    {
      if (v != mSidechainListen && !isSidechainListenImmutable()) {
        mSidechainListen = v;
        Q_EMIT sidechainListenChanged();
      }
    }

    Q_PROPERTY(bool sidechainListen READ sidechainListen WRITE setSidechainListen NOTIFY sidechainListenChanged)
    Q_PROPERTY(bool isSidechainListenImmutable READ isSidechainListenImmutable CONSTANT)
    Q_PROPERTY(bool defaultSidechainListenValue READ defaultSidechainListenValue CONSTANT)
    /**
      Get sidechainListen
    */
    bool sidechainListen() const
    {
      return mSidechainListen;
    }

    /**
      Is sidechainListen Immutable
    */
    bool isSidechainListenImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainListen" ) );
    }

    /**
      Get sidechainListen default value
    */
    bool defaultSidechainListenValue() const
    {
        return defaultSidechainListenValue_helper();
    }

    /**
      Set sidechainTypeLabels
    */
    void setSidechainTypeLabels( const QStringList & v )
    {
      if (v != mSidechainTypeLabels && !isSidechainTypeLabelsImmutable()) {
        mSidechainTypeLabels = v;
        Q_EMIT sidechainTypeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList sidechainTypeLabels READ sidechainTypeLabels WRITE setSidechainTypeLabels NOTIFY sidechainTypeLabelsChanged)
    Q_PROPERTY(bool isSidechainTypeLabelsImmutable READ isSidechainTypeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultSidechainTypeLabelsValue READ defaultSidechainTypeLabelsValue CONSTANT)
    /**
      Get sidechainTypeLabels
    */
    QStringList sidechainTypeLabels() const
    {
      return mSidechainTypeLabels;
    }

    /**
      Is sidechainTypeLabels Immutable
    */
    bool isSidechainTypeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainTypeLabels" ) );
    }

    /**
      Get sidechainTypeLabels default value
    */
    QStringList defaultSidechainTypeLabelsValue() const
    {
        return defaultSidechainTypeLabelsValue_helper();
    }

    /**
      Set Sidechain Type
    */
    void setSidechainType( int v )
    {
      if (v != mSidechainType && !isSidechainTypeImmutable()) {
        mSidechainType = v;
        Q_EMIT sidechainTypeChanged();
      }
    }

    Q_PROPERTY(int sidechainType READ sidechainType WRITE setSidechainType NOTIFY sidechainTypeChanged)
    Q_PROPERTY(bool isSidechainTypeImmutable READ isSidechainTypeImmutable CONSTANT)
    Q_PROPERTY(int defaultSidechainTypeValue READ defaultSidechainTypeValue CONSTANT)
    /**
      Get Sidechain Type
    */
    int sidechainType() const
    {
      return mSidechainType;
    }

    /**
      Is Sidechain Type Immutable
    */
    bool isSidechainTypeImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainType" ) );
    }

    /**
      Get Sidechain Type default value
    */
    int defaultSidechainTypeValue() const
    {
        return defaultSidechainTypeValue_helper();
    }

    /**
      Set sidechainModeLabels
    */
    void setSidechainModeLabels( const QStringList & v )
    {
      if (v != mSidechainModeLabels && !isSidechainModeLabelsImmutable()) {
        mSidechainModeLabels = v;
        Q_EMIT sidechainModeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList sidechainModeLabels READ sidechainModeLabels WRITE setSidechainModeLabels NOTIFY sidechainModeLabelsChanged)
    Q_PROPERTY(bool isSidechainModeLabelsImmutable READ isSidechainModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultSidechainModeLabelsValue READ defaultSidechainModeLabelsValue CONSTANT)
    /**
      Get sidechainModeLabels
    */
    QStringList sidechainModeLabels() const
    {
      return mSidechainModeLabels;
    }

    /**
      Is sidechainModeLabels Immutable
    */
    bool isSidechainModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainModeLabels" ) );
    }

    /**
      Get sidechainModeLabels default value
    */
    QStringList defaultSidechainModeLabelsValue() const
    {
        return defaultSidechainModeLabelsValue_helper();
    }

    /**
      Set Sidechain Mode
    */
    void setSidechainMode( int v )
    {
      if (v != mSidechainMode && !isSidechainModeImmutable()) {
        mSidechainMode = v;
        Q_EMIT sidechainModeChanged();
      }
    }

    Q_PROPERTY(int sidechainMode READ sidechainMode WRITE setSidechainMode NOTIFY sidechainModeChanged)
    Q_PROPERTY(bool isSidechainModeImmutable READ isSidechainModeImmutable CONSTANT)
    Q_PROPERTY(int defaultSidechainModeValue READ defaultSidechainModeValue CONSTANT)
    /**
      Get Sidechain Mode
    */
    int sidechainMode() const
    {
      return mSidechainMode;
    }

    /**
      Is Sidechain Mode Immutable
    */
    bool isSidechainModeImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainMode" ) );
    }

    /**
      Get Sidechain Mode default value
    */
    int defaultSidechainModeValue() const
    {
        return defaultSidechainModeValue_helper();
    }

    /**
      Set stereoSplit
    */
    void setStereoSplit( bool v )
    {
      if (v != mStereoSplit && !isStereoSplitImmutable()) {
        mStereoSplit = v;
        Q_EMIT stereoSplitChanged();
      }
    }

    Q_PROPERTY(bool stereoSplit READ stereoSplit WRITE setStereoSplit NOTIFY stereoSplitChanged)
    Q_PROPERTY(bool isStereoSplitImmutable READ isStereoSplitImmutable CONSTANT)
    Q_PROPERTY(bool defaultStereoSplitValue READ defaultStereoSplitValue CONSTANT)
    /**
      Get stereoSplit
    */
    bool stereoSplit() const
    {
      return mStereoSplit;
    }

    /**
      Is stereoSplit Immutable
    */
    bool isStereoSplitImmutable() const
    {
      return isImmutable( QStringLiteral( "stereoSplit" ) );
    }

    /**
      Get stereoSplit default value
    */
    bool defaultStereoSplitValue() const
    {
        return defaultStereoSplitValue_helper();
    }

    /**
      Set sidechainSourceLabels
    */
    void setSidechainSourceLabels( const QStringList & v )
    {
      if (v != mSidechainSourceLabels && !isSidechainSourceLabelsImmutable()) {
        mSidechainSourceLabels = v;
        Q_EMIT sidechainSourceLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList sidechainSourceLabels READ sidechainSourceLabels WRITE setSidechainSourceLabels NOTIFY sidechainSourceLabelsChanged)
    Q_PROPERTY(bool isSidechainSourceLabelsImmutable READ isSidechainSourceLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultSidechainSourceLabelsValue READ defaultSidechainSourceLabelsValue CONSTANT)
    /**
      Get sidechainSourceLabels
    */
    QStringList sidechainSourceLabels() const
    {
      return mSidechainSourceLabels;
    }

    /**
      Is sidechainSourceLabels Immutable
    */
    bool isSidechainSourceLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainSourceLabels" ) );
    }

    /**
      Get sidechainSourceLabels default value
    */
    QStringList defaultSidechainSourceLabelsValue() const
    {
        return defaultSidechainSourceLabelsValue_helper();
    }

    /**
      Set Sidechain Source
    */
    void setSidechainSource( int v )
    {
      if (v != mSidechainSource && !isSidechainSourceImmutable()) {
        mSidechainSource = v;
        Q_EMIT sidechainSourceChanged();
      }
    }

    Q_PROPERTY(int sidechainSource READ sidechainSource WRITE setSidechainSource NOTIFY sidechainSourceChanged)
    Q_PROPERTY(bool isSidechainSourceImmutable READ isSidechainSourceImmutable CONSTANT)
    Q_PROPERTY(int defaultSidechainSourceValue READ defaultSidechainSourceValue CONSTANT)
    /**
      Get Sidechain Source
    */
    int sidechainSource() const
    {
      return mSidechainSource;
    }

    /**
      Is Sidechain Source Immutable
    */
    bool isSidechainSourceImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainSource" ) );
    }

    /**
      Get Sidechain Source default value
    */
    int defaultSidechainSourceValue() const
    {
        return defaultSidechainSourceValue_helper();
    }

    /**
      Set stereoSplitSourceLabels
    */
    void setStereoSplitSourceLabels( const QStringList & v )
    {
      if (v != mStereoSplitSourceLabels && !isStereoSplitSourceLabelsImmutable()) {
        mStereoSplitSourceLabels = v;
        Q_EMIT stereoSplitSourceLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList stereoSplitSourceLabels READ stereoSplitSourceLabels WRITE setStereoSplitSourceLabels NOTIFY stereoSplitSourceLabelsChanged)
    Q_PROPERTY(bool isStereoSplitSourceLabelsImmutable READ isStereoSplitSourceLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultStereoSplitSourceLabelsValue READ defaultStereoSplitSourceLabelsValue CONSTANT)
    /**
      Get stereoSplitSourceLabels
    */
    QStringList stereoSplitSourceLabels() const
    {
      return mStereoSplitSourceLabels;
    }

    /**
      Is stereoSplitSourceLabels Immutable
    */
    bool isStereoSplitSourceLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "stereoSplitSourceLabels" ) );
    }

    /**
      Get stereoSplitSourceLabels default value
    */
    QStringList defaultStereoSplitSourceLabelsValue() const
    {
        return defaultStereoSplitSourceLabelsValue_helper();
    }

    /**
      Set Stereo Split Mode
    */
    void setStereoSplitSource( int v )
    {
      if (v != mStereoSplitSource && !isStereoSplitSourceImmutable()) {
        mStereoSplitSource = v;
        Q_EMIT stereoSplitSourceChanged();
      }
    }

    Q_PROPERTY(int stereoSplitSource READ stereoSplitSource WRITE setStereoSplitSource NOTIFY stereoSplitSourceChanged)
    Q_PROPERTY(bool isStereoSplitSourceImmutable READ isStereoSplitSourceImmutable CONSTANT)
    Q_PROPERTY(int defaultStereoSplitSourceValue READ defaultStereoSplitSourceValue CONSTANT)
    /**
      Get Stereo Split Mode
    */
    int stereoSplitSource() const
    {
      return mStereoSplitSource;
    }

    /**
      Is Stereo Split Mode Immutable
    */
    bool isStereoSplitSourceImmutable() const
    {
      return isImmutable( QStringLiteral( "stereoSplitSource" ) );
    }

    /**
      Get Stereo Split Mode default value
    */
    int defaultStereoSplitSourceValue() const
    {
        return defaultStereoSplitSourceValue_helper();
    }

    /**
      Set sidechainPreamp
    */
    void setSidechainPreamp( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setSidechainPreamp: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setSidechainPreamp: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mSidechainPreamp && !isSidechainPreampImmutable()) {
        mSidechainPreamp = v;
        Q_EMIT sidechainPreampChanged();
      }
    }

    Q_PROPERTY(double sidechainPreamp READ sidechainPreamp WRITE setSidechainPreamp NOTIFY sidechainPreampChanged)
    Q_PROPERTY(bool isSidechainPreampImmutable READ isSidechainPreampImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainPreampValue READ defaultSidechainPreampValue CONSTANT)
    /**
      Get sidechainPreamp
    */
    double sidechainPreamp() const
    {
      return mSidechainPreamp;
    }

    /**
      Is sidechainPreamp Immutable
    */
    bool isSidechainPreampImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainPreamp" ) );
    }

    /**
      Get sidechainPreamp default value
    */
    double defaultSidechainPreampValue() const
    {
        return defaultSidechainPreampValue_helper();
    }

    /**
      Set sidechainReactivity
    */
    void setSidechainReactivity( double v )
    {
      if (v < 0)
      {
        qDebug() << "setSidechainReactivity: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 250)
      {
        qDebug() << "setSidechainReactivity: value " << v << " is greater than the maximum value of 250";
        v = 250;
      }

      if (v != mSidechainReactivity && !isSidechainReactivityImmutable()) {
        mSidechainReactivity = v;
        Q_EMIT sidechainReactivityChanged();
      }
    }

    Q_PROPERTY(double sidechainReactivity READ sidechainReactivity WRITE setSidechainReactivity NOTIFY sidechainReactivityChanged)
    Q_PROPERTY(bool isSidechainReactivityImmutable READ isSidechainReactivityImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainReactivityValue READ defaultSidechainReactivityValue CONSTANT)
    /**
      Get sidechainReactivity
    */
    double sidechainReactivity() const
    {
      return mSidechainReactivity;
    }

    /**
      Is sidechainReactivity Immutable
    */
    bool isSidechainReactivityImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainReactivity" ) );
    }

    /**
      Get sidechainReactivity default value
    */
    double defaultSidechainReactivityValue() const
    {
        return defaultSidechainReactivityValue_helper();
    }

    /**
      Set sidechainLookahead
    */
    void setSidechainLookahead( double v )
    {
      if (v < 0)
      {
        qDebug() << "setSidechainLookahead: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 20)
      {
        qDebug() << "setSidechainLookahead: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mSidechainLookahead && !isSidechainLookaheadImmutable()) {
        mSidechainLookahead = v;
        Q_EMIT sidechainLookaheadChanged();
      }
    }

    Q_PROPERTY(double sidechainLookahead READ sidechainLookahead WRITE setSidechainLookahead NOTIFY sidechainLookaheadChanged)
    Q_PROPERTY(bool isSidechainLookaheadImmutable READ isSidechainLookaheadImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainLookaheadValue READ defaultSidechainLookaheadValue CONSTANT)
    /**
      Get sidechainLookahead
    */
    double sidechainLookahead() const
    {
      return mSidechainLookahead;
    }

    /**
      Is sidechainLookahead Immutable
    */
    bool isSidechainLookaheadImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainLookahead" ) );
    }

    /**
      Get sidechainLookahead default value
    */
    double defaultSidechainLookaheadValue() const
    {
        return defaultSidechainLookaheadValue_helper();
    }

    /**
      Set hpfModeLabels
    */
    void setHpfModeLabels( const QStringList & v )
    {
      if (v != mHpfModeLabels && !isHpfModeLabelsImmutable()) {
        mHpfModeLabels = v;
        Q_EMIT hpfModeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList hpfModeLabels READ hpfModeLabels WRITE setHpfModeLabels NOTIFY hpfModeLabelsChanged)
    Q_PROPERTY(bool isHpfModeLabelsImmutable READ isHpfModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultHpfModeLabelsValue READ defaultHpfModeLabelsValue CONSTANT)
    /**
      Get hpfModeLabels
    */
    QStringList hpfModeLabels() const
    {
      return mHpfModeLabels;
    }

    /**
      Is hpfModeLabels Immutable
    */
    bool isHpfModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "hpfModeLabels" ) );
    }

    /**
      Get hpfModeLabels default value
    */
    QStringList defaultHpfModeLabelsValue() const
    {
        return defaultHpfModeLabelsValue_helper();
    }

    /**
      Set High-pass Filter Mode
    */
    void setHpfMode( int v )
    {
      if (v != mHpfMode && !isHpfModeImmutable()) {
        mHpfMode = v;
        Q_EMIT hpfModeChanged();
      }
    }

    Q_PROPERTY(int hpfMode READ hpfMode WRITE setHpfMode NOTIFY hpfModeChanged)
    Q_PROPERTY(bool isHpfModeImmutable READ isHpfModeImmutable CONSTANT)
    Q_PROPERTY(int defaultHpfModeValue READ defaultHpfModeValue CONSTANT)
    /**
      Get High-pass Filter Mode
    */
    int hpfMode() const
    {
      return mHpfMode;
    }

    /**
      Is High-pass Filter Mode Immutable
    */
    bool isHpfModeImmutable() const
    {
      return isImmutable( QStringLiteral( "hpfMode" ) );
    }

    /**
      Get High-pass Filter Mode default value
    */
    int defaultHpfModeValue() const
    {
        return defaultHpfModeValue_helper();
    }

    /**
      Set hpfFrequency
    */
    void setHpfFrequency( double v )
    {
      if (v < 10)
      {
        qDebug() << "setHpfFrequency: value " << v << " is less than the minimum value of 10";
        v = 10;
      }

      if (v > 20000)
      {
        qDebug() << "setHpfFrequency: value " << v << " is greater than the maximum value of 20000";
        v = 20000;
      }

      if (v != mHpfFrequency && !isHpfFrequencyImmutable()) {
        mHpfFrequency = v;
        Q_EMIT hpfFrequencyChanged();
      }
    }

    Q_PROPERTY(double hpfFrequency READ hpfFrequency WRITE setHpfFrequency NOTIFY hpfFrequencyChanged)
    Q_PROPERTY(bool isHpfFrequencyImmutable READ isHpfFrequencyImmutable CONSTANT)
    Q_PROPERTY(double defaultHpfFrequencyValue READ defaultHpfFrequencyValue CONSTANT)
    /**
      Get hpfFrequency
    */
    double hpfFrequency() const
    {
      return mHpfFrequency;
    }

    /**
      Is hpfFrequency Immutable
    */
    bool isHpfFrequencyImmutable() const
    {
      return isImmutable( QStringLiteral( "hpfFrequency" ) );
    }

    /**
      Get hpfFrequency default value
    */
    double defaultHpfFrequencyValue() const
    {
        return defaultHpfFrequencyValue_helper();
    }

    /**
      Set lpfModeLabels
    */
    void setLpfModeLabels( const QStringList & v )
    {
      if (v != mLpfModeLabels && !isLpfModeLabelsImmutable()) {
        mLpfModeLabels = v;
        Q_EMIT lpfModeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList lpfModeLabels READ lpfModeLabels WRITE setLpfModeLabels NOTIFY lpfModeLabelsChanged)
    Q_PROPERTY(bool isLpfModeLabelsImmutable READ isLpfModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultLpfModeLabelsValue READ defaultLpfModeLabelsValue CONSTANT)
    /**
      Get lpfModeLabels
    */
    QStringList lpfModeLabels() const
    {
      return mLpfModeLabels;
    }

    /**
      Is lpfModeLabels Immutable
    */
    bool isLpfModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "lpfModeLabels" ) );
    }

    /**
      Get lpfModeLabels default value
    */
    QStringList defaultLpfModeLabelsValue() const
    {
        return defaultLpfModeLabelsValue_helper();
    }

    /**
      Set Low-pass Filter Mode
    */
    void setLpfMode( int v )
    {
      if (v != mLpfMode && !isLpfModeImmutable()) {
        mLpfMode = v;
        Q_EMIT lpfModeChanged();
      }
    }

    Q_PROPERTY(int lpfMode READ lpfMode WRITE setLpfMode NOTIFY lpfModeChanged)
    Q_PROPERTY(bool isLpfModeImmutable READ isLpfModeImmutable CONSTANT)
    Q_PROPERTY(int defaultLpfModeValue READ defaultLpfModeValue CONSTANT)
    /**
      Get Low-pass Filter Mode
    */
    int lpfMode() const
    {
      return mLpfMode;
    }

    /**
      Is Low-pass Filter Mode Immutable
    */
    bool isLpfModeImmutable() const
    {
      return isImmutable( QStringLiteral( "lpfMode" ) );
    }

    /**
      Get Low-pass Filter Mode default value
    */
    int defaultLpfModeValue() const
    {
        return defaultLpfModeValue_helper();
    }

    /**
      Set lpfFrequency
    */
    void setLpfFrequency( double v )
    {
      if (v < 10)
      {
        qDebug() << "setLpfFrequency: value " << v << " is less than the minimum value of 10";
        v = 10;
      }

      if (v > 20000)
      {
        qDebug() << "setLpfFrequency: value " << v << " is greater than the maximum value of 20000";
        v = 20000;
      }

      if (v != mLpfFrequency && !isLpfFrequencyImmutable()) {
        mLpfFrequency = v;
        Q_EMIT lpfFrequencyChanged();
      }
    }

    Q_PROPERTY(double lpfFrequency READ lpfFrequency WRITE setLpfFrequency NOTIFY lpfFrequencyChanged)
    Q_PROPERTY(bool isLpfFrequencyImmutable READ isLpfFrequencyImmutable CONSTANT)
    Q_PROPERTY(double defaultLpfFrequencyValue READ defaultLpfFrequencyValue CONSTANT)
    /**
      Get lpfFrequency
    */
    double lpfFrequency() const
    {
      return mLpfFrequency;
    }

    /**
      Is lpfFrequency Immutable
    */
    bool isLpfFrequencyImmutable() const
    {
      return isImmutable( QStringLiteral( "lpfFrequency" ) );
    }

    /**
      Get lpfFrequency default value
    */
    double defaultLpfFrequencyValue() const
    {
        return defaultLpfFrequencyValue_helper();
    }

    /**
      Set sidechainInputDevice
    */
    void setSidechainInputDevice( const QString & v )
    {
      if (v != mSidechainInputDevice && !isSidechainInputDeviceImmutable()) {
        mSidechainInputDevice = v;
        Q_EMIT sidechainInputDeviceChanged();
      }
    }

    Q_PROPERTY(QString sidechainInputDevice READ sidechainInputDevice WRITE setSidechainInputDevice NOTIFY sidechainInputDeviceChanged)
    Q_PROPERTY(bool isSidechainInputDeviceImmutable READ isSidechainInputDeviceImmutable CONSTANT)
    Q_PROPERTY(QString defaultSidechainInputDeviceValue READ defaultSidechainInputDeviceValue CONSTANT)
    /**
      Get sidechainInputDevice
    */
    QString sidechainInputDevice() const
    {
      return mSidechainInputDevice;
    }

    /**
      Is sidechainInputDevice Immutable
    */
    bool isSidechainInputDeviceImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainInputDevice" ) );
    }

    /**
      Get sidechainInputDevice default value
    */
    QString defaultSidechainInputDeviceValue() const
    {
        return defaultSidechainInputDeviceValue_helper();
    }

    /**
      Set inputToSidechain
    */
    void setInputToSidechain( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setInputToSidechain: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setInputToSidechain: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mInputToSidechain && !isInputToSidechainImmutable()) {
        mInputToSidechain = v;
        Q_EMIT inputToSidechainChanged();
      }
    }

    Q_PROPERTY(double inputToSidechain READ inputToSidechain WRITE setInputToSidechain NOTIFY inputToSidechainChanged)
    Q_PROPERTY(bool isInputToSidechainImmutable READ isInputToSidechainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputToSidechainValue READ defaultInputToSidechainValue CONSTANT)
    /**
      Get inputToSidechain
    */
    double inputToSidechain() const
    {
      return mInputToSidechain;
    }

    /**
      Is inputToSidechain Immutable
    */
    bool isInputToSidechainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputToSidechain" ) );
    }

    /**
      Get inputToSidechain default value
    */
    double defaultInputToSidechainValue() const
    {
        return defaultInputToSidechainValue_helper();
    }

    /**
      Set inputToLink
    */
    void setInputToLink( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setInputToLink: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setInputToLink: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mInputToLink && !isInputToLinkImmutable()) {
        mInputToLink = v;
        Q_EMIT inputToLinkChanged();
      }
    }

    Q_PROPERTY(double inputToLink READ inputToLink WRITE setInputToLink NOTIFY inputToLinkChanged)
    Q_PROPERTY(bool isInputToLinkImmutable READ isInputToLinkImmutable CONSTANT)
    Q_PROPERTY(double defaultInputToLinkValue READ defaultInputToLinkValue CONSTANT)
    /**
      Get inputToLink
    */
    double inputToLink() const
    {
      return mInputToLink;
    }

    /**
      Is inputToLink Immutable
    */
    bool isInputToLinkImmutable() const
    {
      return isImmutable( QStringLiteral( "inputToLink" ) );
    }

    /**
      Get inputToLink default value
    */
    double defaultInputToLinkValue() const
    {
        return defaultInputToLinkValue_helper();
    }

    /**
      Set sidechainToInput
    */
    void setSidechainToInput( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setSidechainToInput: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setSidechainToInput: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mSidechainToInput && !isSidechainToInputImmutable()) {
        mSidechainToInput = v;
        Q_EMIT sidechainToInputChanged();
      }
    }

    Q_PROPERTY(double sidechainToInput READ sidechainToInput WRITE setSidechainToInput NOTIFY sidechainToInputChanged)
    Q_PROPERTY(bool isSidechainToInputImmutable READ isSidechainToInputImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainToInputValue READ defaultSidechainToInputValue CONSTANT)
    /**
      Get sidechainToInput
    */
    double sidechainToInput() const
    {
      return mSidechainToInput;
    }

    /**
      Is sidechainToInput Immutable
    */
    bool isSidechainToInputImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainToInput" ) );
    }

    /**
      Get sidechainToInput default value
    */
    double defaultSidechainToInputValue() const
    {
        return defaultSidechainToInputValue_helper();
    }

    /**
      Set sidechainToLink
    */
    void setSidechainToLink( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setSidechainToLink: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setSidechainToLink: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mSidechainToLink && !isSidechainToLinkImmutable()) {
        mSidechainToLink = v;
        Q_EMIT sidechainToLinkChanged();
      }
    }

    Q_PROPERTY(double sidechainToLink READ sidechainToLink WRITE setSidechainToLink NOTIFY sidechainToLinkChanged)
    Q_PROPERTY(bool isSidechainToLinkImmutable READ isSidechainToLinkImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainToLinkValue READ defaultSidechainToLinkValue CONSTANT)
    /**
      Get sidechainToLink
    */
    double sidechainToLink() const
    {
      return mSidechainToLink;
    }

    /**
      Is sidechainToLink Immutable
    */
    bool isSidechainToLinkImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainToLink" ) );
    }

    /**
      Get sidechainToLink default value
    */
    double defaultSidechainToLinkValue() const
    {
        return defaultSidechainToLinkValue_helper();
    }

    /**
      Set linkToSidechain
    */
    void setLinkToSidechain( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setLinkToSidechain: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setLinkToSidechain: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mLinkToSidechain && !isLinkToSidechainImmutable()) {
        mLinkToSidechain = v;
        Q_EMIT linkToSidechainChanged();
      }
    }

    Q_PROPERTY(double linkToSidechain READ linkToSidechain WRITE setLinkToSidechain NOTIFY linkToSidechainChanged)
    Q_PROPERTY(bool isLinkToSidechainImmutable READ isLinkToSidechainImmutable CONSTANT)
    Q_PROPERTY(double defaultLinkToSidechainValue READ defaultLinkToSidechainValue CONSTANT)
    /**
      Get linkToSidechain
    */
    double linkToSidechain() const
    {
      return mLinkToSidechain;
    }

    /**
      Is linkToSidechain Immutable
    */
    bool isLinkToSidechainImmutable() const
    {
      return isImmutable( QStringLiteral( "linkToSidechain" ) );
    }

    /**
      Get linkToSidechain default value
    */
    double defaultLinkToSidechainValue() const
    {
        return defaultLinkToSidechainValue_helper();
    }

    /**
      Set linkToInput
    */
    void setLinkToInput( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setLinkToInput: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setLinkToInput: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mLinkToInput && !isLinkToInputImmutable()) {
        mLinkToInput = v;
        Q_EMIT linkToInputChanged();
      }
    }

    Q_PROPERTY(double linkToInput READ linkToInput WRITE setLinkToInput NOTIFY linkToInputChanged)
    Q_PROPERTY(bool isLinkToInputImmutable READ isLinkToInputImmutable CONSTANT)
    Q_PROPERTY(double defaultLinkToInputValue READ defaultLinkToInputValue CONSTANT)
    /**
      Get linkToInput
    */
    double linkToInput() const
    {
      return mLinkToInput;
    }

    /**
      Is linkToInput Immutable
    */
    bool isLinkToInputImmutable() const
    {
      return isImmutable( QStringLiteral( "linkToInput" ) );
    }

    /**
      Get linkToInput default value
    */
    double defaultLinkToInputValue() const
    {
        return defaultLinkToInputValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalDryChanged = 4,
      signalWetChanged = 5,
      signalModeLabelsChanged = 6,
      signalModeChanged = 7,
      signalAttackChanged = 8,
      signalReleaseChanged = 9,
      signalReleaseThresholdChanged = 10,
      signalThresholdChanged = 11,
      signalRatioChanged = 12,
      signalKneeChanged = 13,
      signalMakeupChanged = 14,
      signalBoostAmountChanged = 15,
      signalBoostThresholdChanged = 16,
      signalSidechainListenChanged = 17,
      signalSidechainTypeLabelsChanged = 18,
      signalSidechainTypeChanged = 19,
      signalSidechainModeLabelsChanged = 20,
      signalSidechainModeChanged = 21,
      signalStereoSplitChanged = 22,
      signalSidechainSourceLabelsChanged = 23,
      signalSidechainSourceChanged = 24,
      signalStereoSplitSourceLabelsChanged = 25,
      signalStereoSplitSourceChanged = 26,
      signalSidechainPreampChanged = 27,
      signalSidechainReactivityChanged = 28,
      signalSidechainLookaheadChanged = 29,
      signalHpfModeLabelsChanged = 30,
      signalHpfModeChanged = 31,
      signalHpfFrequencyChanged = 32,
      signalLpfModeLabelsChanged = 33,
      signalLpfModeChanged = 34,
      signalLpfFrequencyChanged = 35,
      signalSidechainInputDeviceChanged = 36,
      signalInputToSidechainChanged = 37,
      signalInputToLinkChanged = 38,
      signalSidechainToInputChanged = 39,
      signalSidechainToLinkChanged = 40,
      signalLinkToSidechainChanged = 41,
      signalLinkToInputChanged = 42
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void dryChanged();

    void wetChanged();

    void modeLabelsChanged();

    void modeChanged();

    void attackChanged();

    void releaseChanged();

    void releaseThresholdChanged();

    void thresholdChanged();

    void ratioChanged();

    void kneeChanged();

    void makeupChanged();

    void boostAmountChanged();

    void boostThresholdChanged();

    void sidechainListenChanged();

    void sidechainTypeLabelsChanged();

    void sidechainTypeChanged();

    void sidechainModeLabelsChanged();

    void sidechainModeChanged();

    void stereoSplitChanged();

    void sidechainSourceLabelsChanged();

    void sidechainSourceChanged();

    void stereoSplitSourceLabelsChanged();

    void stereoSplitSourceChanged();

    void sidechainPreampChanged();

    void sidechainReactivityChanged();

    void sidechainLookaheadChanged();

    void hpfModeLabelsChanged();

    void hpfModeChanged();

    void hpfFrequencyChanged();

    void lpfModeLabelsChanged();

    void lpfModeChanged();

    void lpfFrequencyChanged();

    void sidechainInputDeviceChanged();

    void inputToSidechainChanged();

    void inputToLinkChanged();

    void sidechainToInputChanged();

    void sidechainToLinkChanged();

    void linkToSidechainChanged();

    void linkToInputChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // Compressor#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    double mDry;
    double defaultDryValue_helper() const;
    double mWet;
    double defaultWetValue_helper() const;
    QStringList mModeLabels;
    QStringList defaultModeLabelsValue_helper() const;
    int mMode;
    int defaultModeValue_helper() const;
    double mAttack;
    double defaultAttackValue_helper() const;
    double mRelease;
    double defaultReleaseValue_helper() const;
    double mReleaseThreshold;
    double defaultReleaseThresholdValue_helper() const;
    double mThreshold;
    double defaultThresholdValue_helper() const;
    double mRatio;
    double defaultRatioValue_helper() const;
    double mKnee;
    double defaultKneeValue_helper() const;
    double mMakeup;
    double defaultMakeupValue_helper() const;
    double mBoostAmount;
    double defaultBoostAmountValue_helper() const;
    double mBoostThreshold;
    double defaultBoostThresholdValue_helper() const;
    bool mSidechainListen;
    bool defaultSidechainListenValue_helper() const;
    QStringList mSidechainTypeLabels;
    QStringList defaultSidechainTypeLabelsValue_helper() const;
    int mSidechainType;
    int defaultSidechainTypeValue_helper() const;
    QStringList mSidechainModeLabels;
    QStringList defaultSidechainModeLabelsValue_helper() const;
    int mSidechainMode;
    int defaultSidechainModeValue_helper() const;
    bool mStereoSplit;
    bool defaultStereoSplitValue_helper() const;
    QStringList mSidechainSourceLabels;
    QStringList defaultSidechainSourceLabelsValue_helper() const;
    int mSidechainSource;
    int defaultSidechainSourceValue_helper() const;
    QStringList mStereoSplitSourceLabels;
    QStringList defaultStereoSplitSourceLabelsValue_helper() const;
    int mStereoSplitSource;
    int defaultStereoSplitSourceValue_helper() const;
    double mSidechainPreamp;
    double defaultSidechainPreampValue_helper() const;
    double mSidechainReactivity;
    double defaultSidechainReactivityValue_helper() const;
    double mSidechainLookahead;
    double defaultSidechainLookaheadValue_helper() const;
    QStringList mHpfModeLabels;
    QStringList defaultHpfModeLabelsValue_helper() const;
    int mHpfMode;
    int defaultHpfModeValue_helper() const;
    double mHpfFrequency;
    double defaultHpfFrequencyValue_helper() const;
    QStringList mLpfModeLabels;
    QStringList defaultLpfModeLabelsValue_helper() const;
    int mLpfMode;
    int defaultLpfModeValue_helper() const;
    double mLpfFrequency;
    double defaultLpfFrequencyValue_helper() const;
    QString mSidechainInputDevice;
    QString defaultSidechainInputDeviceValue_helper() const;
    double mInputToSidechain;
    double defaultInputToSidechainValue_helper() const;
    double mInputToLink;
    double defaultInputToLinkValue_helper() const;
    double mSidechainToInput;
    double defaultSidechainToInputValue_helper() const;
    double mSidechainToLink;
    double defaultSidechainToLinkValue_helper() const;
    double mLinkToSidechain;
    double defaultLinkToSidechainValue_helper() const;
    double mLinkToInput;
    double defaultLinkToInputValue_helper() const;
};

}

#endif

