/* LanguageFilter.c generated by valac 0.56.18, the Vala compiler
 * generated from LanguageFilter.vala, do not modify */

/* LanguageFilter.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include "font-manager.h"
#include <gtk/gtk.h>
#include <locale.h>
#include <pango/pango.h>

#define SELECT_ON_LANGUAGE "\n" \
"SELECT DISTINCT Fonts.family, Fonts.description\n" \
"FROM Fonts, json_tree(Orthography.support, '$.%s')\n" \
"JOIN Orthography USING (filepath, findex)\n" \
"WHERE json_tree.key = 'coverage' AND json_tree.value > %f;\n"
#define DEFAULT_LANGUAGE_FILTER_COMMENT _ ("Filter based on supported orthographies")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_CACHEABLE (font_manager_cacheable_get_type ())
#define FONT_MANAGER_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheable))
#define FONT_MANAGER_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))
#define FONT_MANAGER_IS_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_IS_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_CACHEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))

typedef struct _FontManagerCacheable FontManagerCacheable;
typedef struct _FontManagerCacheableClass FontManagerCacheableClass;
typedef struct _FontManagerCacheablePrivate FontManagerCacheablePrivate;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER (font_manager_font_list_filter_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter))
#define FONT_MANAGER_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_FONT_LIST_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))

typedef struct _FontManagerFontListFilter FontManagerFontListFilter;
typedef struct _FontManagerFontListFilterClass FontManagerFontListFilterClass;
typedef struct _FontManagerFontListFilterPrivate FontManagerFontListFilterPrivate;

#define FONT_MANAGER_TYPE_CATEGORY (font_manager_category_get_type ())
#define FONT_MANAGER_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory))
#define FONT_MANAGER_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))
#define FONT_MANAGER_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))

typedef struct _FontManagerCategory FontManagerCategory;
typedef struct _FontManagerCategoryClass FontManagerCategoryClass;
typedef struct _FontManagerCategoryPrivate FontManagerCategoryPrivate;

#define FONT_MANAGER_TYPE_LANGUAGE_FILTER (font_manager_language_filter_get_type ())
#define FONT_MANAGER_LANGUAGE_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilter))
#define FONT_MANAGER_LANGUAGE_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilterClass))
#define FONT_MANAGER_IS_LANGUAGE_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER))
#define FONT_MANAGER_IS_LANGUAGE_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER))
#define FONT_MANAGER_LANGUAGE_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilterClass))

typedef struct _FontManagerLanguageFilter FontManagerLanguageFilter;
typedef struct _FontManagerLanguageFilterClass FontManagerLanguageFilterClass;
typedef struct _FontManagerLanguageFilterPrivate FontManagerLanguageFilterPrivate;

#define FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS (font_manager_language_filter_settings_get_type ())
#define FONT_MANAGER_LANGUAGE_FILTER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettings))
#define FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettingsClass))
#define FONT_MANAGER_IS_LANGUAGE_FILTER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS))
#define FONT_MANAGER_IS_LANGUAGE_FILTER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS))
#define FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettingsClass))

typedef struct _FontManagerLanguageFilterSettings FontManagerLanguageFilterSettings;
typedef struct _FontManagerLanguageFilterSettingsClass FontManagerLanguageFilterSettingsClass;
enum  {
	FONT_MANAGER_LANGUAGE_FILTER_0_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_COVERAGE_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_SELECTIONS_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_NUM_PROPERTIES
};
static GParamSpec* font_manager_language_filter_properties[FONT_MANAGER_LANGUAGE_FILTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	FONT_MANAGER_CATEGORY_INDEX_ALL,
	FONT_MANAGER_CATEGORY_INDEX_SYSTEM,
	FONT_MANAGER_CATEGORY_INDEX_USER,
	FONT_MANAGER_CATEGORY_INDEX_PANOSE,
	FONT_MANAGER_CATEGORY_INDEX_WIDTH,
	FONT_MANAGER_CATEGORY_INDEX_WEIGHT,
	FONT_MANAGER_CATEGORY_INDEX_SLANT,
	FONT_MANAGER_CATEGORY_INDEX_SPACING,
	FONT_MANAGER_CATEGORY_INDEX_LICENSE,
	FONT_MANAGER_CATEGORY_INDEX_VENDOR,
	FONT_MANAGER_CATEGORY_INDEX_FILETYPE,
	FONT_MANAGER_CATEGORY_INDEX_UNSORTED,
	FONT_MANAGER_CATEGORY_INDEX_DISABLED,
	FONT_MANAGER_CATEGORY_INDEX_LANGUAGE,
	FONT_MANAGER_CATEGORY_INDEX_N_CATEGORIES
} FontManagerCategoryIndex;

#define FONT_MANAGER_TYPE_CATEGORY_INDEX (font_manager_category_index_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FontManagerLanguageFilterUpdateData FontManagerLanguageFilterUpdateData;

#define FONT_MANAGER_TYPE_LIST_ITEM_ROW (font_manager_list_item_row_get_type ())
#define FONT_MANAGER_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRow))
#define FONT_MANAGER_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRowClass))
#define FONT_MANAGER_IS_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW))
#define FONT_MANAGER_IS_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LIST_ITEM_ROW))
#define FONT_MANAGER_LIST_ITEM_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRowClass))

typedef struct _FontManagerListItemRow FontManagerListItemRow;
typedef struct _FontManagerListItemRowClass FontManagerListItemRowClass;
typedef struct _FontManagerListItemRowPrivate FontManagerListItemRowPrivate;

#define FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW (font_manager_language_list_row_get_type ())
#define FONT_MANAGER_LANGUAGE_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRow))
#define FONT_MANAGER_LANGUAGE_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRowClass))
#define FONT_MANAGER_IS_LANGUAGE_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW))
#define FONT_MANAGER_IS_LANGUAGE_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW))
#define FONT_MANAGER_LANGUAGE_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRowClass))

typedef struct _FontManagerLanguageListRow FontManagerLanguageListRow;
typedef struct _FontManagerLanguageListRowClass FontManagerLanguageListRowClass;
typedef struct _FontManagerLanguageListRowPrivate FontManagerLanguageListRowPrivate;
enum  {
	FONT_MANAGER_LANGUAGE_LIST_ROW_0_PROPERTY,
	FONT_MANAGER_LANGUAGE_LIST_ROW_ACTIVE_PROPERTY,
	FONT_MANAGER_LANGUAGE_LIST_ROW_ORTHOGRAPHY_PROPERTY,
	FONT_MANAGER_LANGUAGE_LIST_ROW_LOCAL_NAME_PROPERTY,
	FONT_MANAGER_LANGUAGE_LIST_ROW_NATIVE_NAME_PROPERTY,
	FONT_MANAGER_LANGUAGE_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_BASE_ORTHOGRAPHY_DATA (font_manager_base_orthography_data_get_type ())
typedef struct _FontManagerBaseOrthographyData FontManagerBaseOrthographyData;
enum  {
	FONT_MANAGER_LANGUAGE_LIST_ROW_CHANGED_SIGNAL,
	FONT_MANAGER_LANGUAGE_LIST_ROW_NUM_SIGNALS
};
static guint font_manager_language_list_row_signals[FONT_MANAGER_LANGUAGE_LIST_ROW_NUM_SIGNALS] = {0};
typedef struct _FontManagerLanguageFilterSettingsPrivate FontManagerLanguageFilterSettingsPrivate;
enum  {
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_0_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_COVERAGE_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SELECTIONS_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_BAR_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_ENTRY_PROPERTY,
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* font_manager_language_filter_settings_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_NUM_PROPERTIES];
enum  {
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_CHANGED_SIGNAL,
	FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_NUM_SIGNALS
};
static guint font_manager_language_filter_settings_signals[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_NUM_SIGNALS] = {0};

struct _FontManagerCacheable {
	GObject parent_instance;
	FontManagerCacheablePrivate * priv;
};

struct _FontManagerCacheableClass {
	GObjectClass parent_class;
	gboolean (*deserialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec, JsonNode* node);
	JsonNode* (*serialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec);
};

struct _FontManagerFontListFilter {
	FontManagerCacheable parent_instance;
	FontManagerFontListFilterPrivate * priv;
};

struct _FontManagerFontListFilterClass {
	FontManagerCacheableClass parent_class;
	void (*update) (FontManagerFontListFilter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (FontManagerFontListFilter* self, GAsyncResult* _res_);
	gboolean (*matches) (FontManagerFontListFilter* self, GObject* item);
	gchar* (*get_name) (FontManagerFontListFilter* self);
	void (*set_name) (FontManagerFontListFilter* self, const gchar* value);
	gchar* (*get_icon) (FontManagerFontListFilter* self);
	void (*set_icon) (FontManagerFontListFilter* self, const gchar* value);
	gchar* (*get_comment) (FontManagerFontListFilter* self);
	void (*set_comment) (FontManagerFontListFilter* self, const gchar* value);
	gint (*get_index) (FontManagerFontListFilter* self);
	void (*set_index) (FontManagerFontListFilter* self, gint value);
	gint (*get_size) (FontManagerFontListFilter* self);
	gint (*get_depth) (FontManagerFontListFilter* self);
	void (*set_depth) (FontManagerFontListFilter* self, gint value);
};

struct _FontManagerCategory {
	FontManagerFontListFilter parent_instance;
	FontManagerCategoryPrivate * priv;
};

struct _FontManagerCategoryClass {
	FontManagerFontListFilterClass parent_class;
};

struct _FontManagerLanguageFilter {
	FontManagerCategory parent_instance;
	FontManagerLanguageFilterPrivate * priv;
};

struct _FontManagerLanguageFilterClass {
	FontManagerCategoryClass parent_class;
};

struct _FontManagerLanguageFilterPrivate {
	gdouble _coverage;
	FontManagerStringSet* _selections;
	GSettings* gsettings;
	FontManagerLanguageFilterSettings* filter_settings;
};

struct _FontManagerLanguageFilterUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FontManagerLanguageFilter* self;
	FontManagerStringSet* _tmp0_;
	FontManagerStringSet* _tmp1_;
	FontManagerStringSet* _tmp2_;
	FontManagerStringSet* _tmp3_;
	FontManagerDatabase* db;
	FontManagerDatabase* _tmp4_;
	FontManagerStringSet* _language_list;
	FontManagerStringSet* _tmp5_;
	guint _language_size;
	FontManagerStringSet* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	gint _language_index;
	gint _tmp9_;
	guint _tmp10_;
	gchar* language;
	FontManagerStringSet* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* pref_loc;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _sql_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gdouble _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	FontManagerDatabase* _tmp25_;
	FontManagerStringSet* _tmp26_;
	FontManagerStringSet* _tmp27_;
	FontManagerStringSet* _tmp28_;
	FontManagerStringSet* _tmp29_;
	const gchar* _tmp30_;
	GError* e;
	GError* _tmp31_;
	const gchar* _tmp32_;
	GError* _inner_error0_;
};

struct _FontManagerListItemRow {
	GtkBox parent_instance;
	FontManagerListItemRowPrivate * priv;
};

struct _FontManagerListItemRowClass {
	GtkBoxClass parent_class;
	void (*on_item_set) (FontManagerListItemRow* self);
	void (*reset) (FontManagerListItemRow* self);
};

struct _FontManagerLanguageListRow {
	FontManagerListItemRow parent_instance;
	FontManagerLanguageListRowPrivate * priv;
};

struct _FontManagerLanguageListRowClass {
	FontManagerListItemRowClass parent_class;
};

struct _FontManagerLanguageListRowPrivate {
	gboolean _active;
	gchar* _orthography;
	gchar* _local_name;
	gchar* _native_name;
};

struct _FontManagerBaseOrthographyData {
	gchar* name;
	gchar* native;
};

struct _FontManagerLanguageFilterSettings {
	GtkBox parent_instance;
	FontManagerLanguageFilterSettingsPrivate * priv;
};

struct _FontManagerLanguageFilterSettingsClass {
	GtkBoxClass parent_class;
};

struct _FontManagerLanguageFilterSettingsPrivate {
	gdouble _coverage;
	FontManagerStringSet* _selections;
	GtkSearchBar* _search_bar;
	GtkSearchEntry* _search_entry;
	GtkButton* clear_button;
	GtkListBox* listbox;
	GtkSpinButton* coverage_spin;
};

static gint FontManagerLanguageFilter_private_offset;
static gpointer font_manager_language_filter_parent_class = NULL;
static gint FontManagerLanguageListRow_private_offset;
static gpointer font_manager_language_list_row_parent_class = NULL;
static gint FontManagerLanguageFilterSettings_private_offset;
static gpointer font_manager_language_filter_settings_parent_class = NULL;

VALA_EXTERN GType font_manager_cacheable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCacheable, g_object_unref)
VALA_EXTERN GType font_manager_font_list_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilter, g_object_unref)
VALA_EXTERN GType font_manager_category_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategory, g_object_unref)
VALA_EXTERN GType font_manager_language_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLanguageFilter, g_object_unref)
VALA_EXTERN GType font_manager_language_filter_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLanguageFilterSettings, g_object_unref)
VALA_EXTERN void font_manager_font_list_filter_update (FontManagerFontListFilter* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void font_manager_font_list_filter_update_finish (FontManagerFontListFilter* self,
                                                  GAsyncResult* _res_);
VALA_EXTERN FontManagerLanguageFilter* font_manager_language_filter_new (void);
VALA_EXTERN FontManagerLanguageFilter* font_manager_language_filter_construct (GType object_type);
VALA_EXTERN GType font_manager_category_index_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerCategory* font_manager_category_new (const gchar* name,
                                                const gchar* comment,
                                                const gchar* icon,
                                                const gchar* sql,
                                                gint index);
VALA_EXTERN FontManagerCategory* font_manager_category_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* comment,
                                                      const gchar* icon,
                                                      const gchar* sql,
                                                      gint index);
VALA_EXTERN void font_manager_language_filter_restore_state (FontManagerLanguageFilter* self,
                                                 GSettings* settings);
VALA_EXTERN FontManagerStringSet* font_manager_language_filter_get_selections (FontManagerLanguageFilter* self);
static void font_manager_language_filter_on_change (FontManagerLanguageFilter* self);
static void _font_manager_language_filter_on_change_font_manager_string_set_changed (FontManagerStringSet* _sender,
                                                                              gpointer self);
VALA_EXTERN void font_manager_language_filter_save_state (FontManagerLanguageFilter* self,
                                              GSettings* settings);
static void __lambda31_ (FontManagerLanguageFilter* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda31__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void font_manager_language_filter_set_coverage (FontManagerLanguageFilter* self,
                                                gdouble value);
VALA_EXTERN gdouble font_manager_language_filter_get_coverage (FontManagerLanguageFilter* self);
static void font_manager_language_filter_real_update_data_free (gpointer _data);
static void font_manager_language_filter_real_update (FontManagerFontListFilter* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean font_manager_language_filter_real_update_co (FontManagerLanguageFilterUpdateData* _data_);
VALA_EXTERN FontManagerStringSet* font_manager_category_get_families (FontManagerCategory* self);
VALA_EXTERN FontManagerStringSet* font_manager_category_get_variations (FontManagerCategory* self);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
VALA_EXTERN const gchar* font_manager_category_get_sql (FontManagerCategory* self);
VALA_EXTERN void font_manager_language_filter_set_selections (FontManagerLanguageFilter* self,
                                                  FontManagerStringSet* value);
VALA_EXTERN FontManagerLanguageFilterSettings* font_manager_language_filter_get_settings (FontManagerLanguageFilter* self);
VALA_EXTERN FontManagerLanguageFilterSettings* font_manager_language_filter_settings_new (void);
VALA_EXTERN FontManagerLanguageFilterSettings* font_manager_language_filter_settings_construct (GType object_type);
VALA_EXTERN void font_manager_language_filter_settings_update (FontManagerLanguageFilterSettings* self);
static void _font_manager_language_filter_on_change_font_manager_language_filter_settings_changed (FontManagerLanguageFilterSettings* _sender,
                                                                                            gpointer self);
static void font_manager_language_filter_finalize (GObject * obj);
static GType font_manager_language_filter_get_type_once (void);
static void _vala_font_manager_language_filter_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_font_manager_language_filter_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
VALA_EXTERN GType font_manager_list_item_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerListItemRow, g_object_unref)
VALA_EXTERN GType font_manager_language_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLanguageListRow, g_object_unref)
VALA_EXTERN GType font_manager_base_orthography_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerBaseOrthographyData* font_manager_base_orthography_data_dup (const FontManagerBaseOrthographyData* self);
VALA_EXTERN void font_manager_base_orthography_data_free (FontManagerBaseOrthographyData* self);
VALA_EXTERN void font_manager_base_orthography_data_copy (const FontManagerBaseOrthographyData* self,
                                              FontManagerBaseOrthographyData* dest);
VALA_EXTERN void font_manager_base_orthography_data_destroy (FontManagerBaseOrthographyData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FontManagerBaseOrthographyData, font_manager_base_orthography_data_destroy)
VALA_EXTERN FontManagerLanguageListRow* font_manager_language_list_row_new (FontManagerBaseOrthographyData* data);
VALA_EXTERN FontManagerLanguageListRow* font_manager_language_list_row_construct (GType object_type,
                                                                      FontManagerBaseOrthographyData* data);
VALA_EXTERN FontManagerListItemRow* font_manager_list_item_row_new (void);
VALA_EXTERN FontManagerListItemRow* font_manager_list_item_row_construct (GType object_type);
static void font_manager_language_list_row_set_orthography (FontManagerLanguageListRow* self,
                                                     const gchar* value);
static void font_manager_language_list_row_set_local_name (FontManagerLanguageListRow* self,
                                                    const gchar* value);
static void font_manager_language_list_row_set_native_name (FontManagerLanguageListRow* self,
                                                     const gchar* value);
VALA_EXTERN GtkCheckButton* font_manager_list_item_row_get_item_state (FontManagerListItemRow* self);
VALA_EXTERN GtkLabel* font_manager_list_item_row_get_item_label (FontManagerListItemRow* self);
VALA_EXTERN const gchar* font_manager_language_list_row_get_native_name (FontManagerLanguageListRow* self);
VALA_EXTERN GtkLabel* font_manager_list_item_row_get_item_count (FontManagerListItemRow* self);
VALA_EXTERN const gchar* font_manager_language_list_row_get_local_name (FontManagerLanguageListRow* self);
static void __lambda30_ (FontManagerLanguageListRow* self);
static void ___lambda30__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
VALA_EXTERN gboolean font_manager_language_list_row_get_active (FontManagerLanguageListRow* self);
VALA_EXTERN void font_manager_language_list_row_set_active (FontManagerLanguageListRow* self,
                                                gboolean value);
VALA_EXTERN const gchar* font_manager_language_list_row_get_orthography (FontManagerLanguageListRow* self);
static void font_manager_language_list_row_finalize (GObject * obj);
static GType font_manager_language_list_row_get_type_once (void);
static void _vala_font_manager_language_list_row_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_font_manager_language_list_row_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static gboolean font_manager_language_filter_settings_matches_search (GtkListBoxRow* list_box_row,
                                                               FontManagerLanguageFilterSettings* self);
static void font_manager_language_filter_settings_populate_list_box (FontManagerLanguageFilterSettings* self);
VALA_EXTERN FontManagerStringSet* font_manager_language_filter_settings_get_selections (FontManagerLanguageFilterSettings* self);
static void font_manager_language_filter_settings_on_item_changed (FontManagerLanguageFilterSettings* self,
                                                            FontManagerLanguageListRow* item);
static void _font_manager_language_filter_settings_on_item_changed_font_manager_language_list_row_changed (FontManagerLanguageListRow* _sender,
                                                                                                    FontManagerLanguageListRow* item,
                                                                                                    gpointer self);
VALA_EXTERN GtkSearchEntry* font_manager_language_filter_settings_get_search_entry (FontManagerLanguageFilterSettings* self);
static void font_manager_language_filter_settings_on_search_changed (FontManagerLanguageFilterSettings* self,
                                                              GtkSearchEntry* entry);
static void _font_manager_language_filter_settings_on_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                               gpointer self);
static void font_manager_language_filter_settings_on_clear_button_clicked (FontManagerLanguageFilterSettings* self,
                                                                    GtkButton* button);
static void _font_manager_language_filter_settings_on_clear_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                        gpointer self);
static void font_manager_language_filter_settings_on_coverage_changed (FontManagerLanguageFilterSettings* self);
VALA_EXTERN gdouble font_manager_language_filter_settings_get_coverage (FontManagerLanguageFilterSettings* self);
static void _font_manager_language_filter_settings_on_coverage_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                                               gpointer self);
VALA_EXTERN void font_manager_language_filter_settings_set_coverage (FontManagerLanguageFilterSettings* self,
                                                         gdouble value);
VALA_EXTERN void font_manager_language_filter_settings_set_selections (FontManagerLanguageFilterSettings* self,
                                                           FontManagerStringSet* value);
VALA_EXTERN GtkSearchBar* font_manager_language_filter_settings_get_search_bar (FontManagerLanguageFilterSettings* self);
static void font_manager_language_filter_settings_finalize (GObject * obj);
static GType font_manager_language_filter_settings_get_type_once (void);
static void _vala_font_manager_language_filter_settings_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_font_manager_language_filter_settings_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

VALA_EXTERN const FontManagerBaseOrthographyData FONT_MANAGER_Orthographies[132];

static inline gpointer
font_manager_language_filter_get_instance_private (FontManagerLanguageFilter* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerLanguageFilter_private_offset);
}

static void
_font_manager_language_filter_on_change_font_manager_string_set_changed (FontManagerStringSet* _sender,
                                                                         gpointer self)
{
	font_manager_language_filter_on_change ((FontManagerLanguageFilter*) self);
}

FontManagerLanguageFilter*
font_manager_language_filter_construct (GType object_type)
{
	FontManagerLanguageFilter * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	FontManagerStringSet* _tmp2_;
	self = (FontManagerLanguageFilter*) font_manager_category_construct (object_type, _ ("Supported Orthographies"), DEFAULT_LANGUAGE_FILTER_COMMENT, "preferences-desktop-locale-symbolic", SELECT_ON_LANGUAGE, (gint) FONT_MANAGER_CATEGORY_INDEX_LANGUAGE);
	_tmp0_ = font_manager_get_gsettings (FONT_MANAGER_BUS_ID);
	_g_object_unref0 (self->priv->gsettings);
	self->priv->gsettings = _tmp0_;
	_tmp1_ = self->priv->gsettings;
	font_manager_language_filter_restore_state (self, _tmp1_);
	_tmp2_ = self->priv->_selections;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _font_manager_language_filter_on_change_font_manager_string_set_changed, self, G_CONNECT_AFTER);
	return self;
}

FontManagerLanguageFilter*
font_manager_language_filter_new (void)
{
	return font_manager_language_filter_construct (FONT_MANAGER_TYPE_LANGUAGE_FILTER);
}

static void
__lambda31_ (FontManagerLanguageFilter* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	font_manager_font_list_filter_update_finish ((FontManagerFontListFilter*) self, res);
	g_signal_emit_by_name ((FontManagerCacheable*) self, "changed");
}

static void
___lambda31__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda31_ ((FontManagerLanguageFilter*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_language_filter_on_change (FontManagerLanguageFilter* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gsettings;
	font_manager_language_filter_save_state (self, _tmp0_);
	font_manager_font_list_filter_update ((FontManagerFontListFilter*) self, ___lambda31__gasync_ready_callback, g_object_ref (self));
	return;
}

void
font_manager_language_filter_restore_state (FontManagerLanguageFilter* self,
                                            GSettings* settings)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp1_ = _tmp0_ = g_settings_get_strv (settings, "language-filter-list");
	{
		gchar** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp1_;
		entry_collection_length1 = _vala_array_length (_tmp0_);
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			gchar* _tmp2_;
			gchar* entry = NULL;
			_tmp2_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp2_;
			{
				FontManagerStringSet* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = self->priv->_selections;
				_tmp4_ = entry;
				font_manager_string_set_add (_tmp3_, _tmp4_);
				_g_free0 (entry);
			}
		}
		entry_collection = (_vala_array_free (entry_collection, entry_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	font_manager_language_filter_set_coverage (self, g_settings_get_double (settings, "language-filter-min-coverage"));
	font_manager_font_list_filter_update ((FontManagerFontListFilter*) self, NULL, NULL);
	return;
}

void
font_manager_language_filter_save_state (FontManagerLanguageFilter* self,
                                         GSettings* settings)
{
	FontManagerStringSet* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = self->priv->_selections;
	_tmp2_ = _tmp1_ = font_manager_string_set_to_strv (_tmp0_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	g_settings_set_strv (settings, "language-filter-list", _tmp3_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = self->priv->_coverage;
	g_settings_set_double (settings, "language-filter-min-coverage", _tmp4_);
	return;
}

static void
font_manager_language_filter_real_update_data_free (gpointer _data)
{
	FontManagerLanguageFilterUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FontManagerLanguageFilterUpdateData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
font_manager_language_filter_real_update (FontManagerFontListFilter* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	FontManagerLanguageFilter * self;
	FontManagerLanguageFilterUpdateData* _data_;
	FontManagerLanguageFilter* _tmp0_;
	self = (FontManagerLanguageFilter*) base;
	_data_ = g_slice_new0 (FontManagerLanguageFilterUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, font_manager_language_filter_real_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	font_manager_language_filter_real_update_co (_data_);
}

static void
font_manager_language_filter_update_finish (FontManagerFontListFilter* base,
                                            GAsyncResult* _res_)
{
	FontManagerLanguageFilterUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
font_manager_language_filter_real_update_co (FontManagerLanguageFilterUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = font_manager_category_get_families ((FontManagerCategory*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	font_manager_string_set_clear (_data_->_tmp1_);
	_data_->_tmp2_ = font_manager_category_get_variations ((FontManagerCategory*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	font_manager_string_set_clear (_data_->_tmp3_);
	{
		_data_->_tmp4_ = font_manager_database_proxy_get_default_db ();
		_data_->db = _data_->_tmp4_;
		{
			_data_->_tmp5_ = _data_->self->priv->_selections;
			_data_->_language_list = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->_language_list;
			g_object_get (_data_->_tmp6_, "size", &_data_->_tmp7_, NULL);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_language_size = _data_->_tmp8_;
			_data_->_language_index = -1;
			while (TRUE) {
				_data_->_language_index = _data_->_language_index + 1;
				_data_->_tmp9_ = _data_->_language_index;
				_data_->_tmp10_ = _data_->_language_size;
				if (!(((guint) _data_->_tmp9_) < _data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = _data_->_language_list;
				_data_->_tmp12_ = font_manager_string_set_get (_data_->_tmp11_, (guint) _data_->_language_index);
				_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
				_data_->language = _data_->_tmp13_;
				_data_->_tmp14_ = setlocale (LC_ALL, "");
				_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
				_data_->pref_loc = _data_->_tmp15_;
				setlocale (LC_ALL, "C");
				_data_->_tmp16_ = font_manager_category_get_sql ((FontManagerCategory*) _data_->self);
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp18_ = _data_->language;
				_data_->_tmp19_ = string_replace (_data_->_tmp18_, "'", "''");
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp21_ = _data_->self->priv->_coverage;
				_data_->_tmp22_ = g_strdup_printf (_data_->_tmp17_, _data_->_tmp20_, _data_->_tmp21_);
				_data_->_tmp23_ = _data_->_tmp22_;
				_g_free0 (_data_->_tmp20_);
				_data_->_sql_ = _data_->_tmp23_;
				_data_->_tmp24_ = _data_->pref_loc;
				setlocale (LC_ALL, _data_->_tmp24_);
				_data_->_tmp25_ = _data_->db;
				_data_->_tmp26_ = font_manager_category_get_families ((FontManagerCategory*) _data_->self);
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp28_ = font_manager_category_get_variations ((FontManagerCategory*) _data_->self);
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = _data_->_sql_;
				font_manager_get_matching_families_and_fonts (_data_->_tmp25_, _data_->_tmp27_, _data_->_tmp29_, _data_->_tmp30_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_free0 (_data_->_sql_);
					_g_free0 (_data_->pref_loc);
					_g_free0 (_data_->language);
					_g_object_unref0 (_data_->db);
					goto __catch0_g_error;
				}
				_g_free0 (_data_->_sql_);
				_g_free0 (_data_->pref_loc);
				_g_free0 (_data_->language);
			}
		}
		_g_object_unref0 (_data_->db);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp31_ = _data_->e;
		_data_->_tmp32_ = _data_->_tmp31_->message;
		g_warning ("LanguageFilter.vala:102: %s", _data_->_tmp32_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name ((FontManagerCacheable*) _data_->self, "changed");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gdouble
font_manager_language_filter_get_coverage (FontManagerLanguageFilter* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_coverage;
	return result;
}

void
font_manager_language_filter_set_coverage (FontManagerLanguageFilter* self,
                                           gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_filter_get_coverage (self);
	if (old_value != value) {
		self->priv->_coverage = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_filter_properties[FONT_MANAGER_LANGUAGE_FILTER_COVERAGE_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_language_filter_get_selections (FontManagerLanguageFilter* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selections;
	result = _tmp0_;
	return result;
}

void
font_manager_language_filter_set_selections (FontManagerLanguageFilter* self,
                                             FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_filter_get_selections (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selections);
		self->priv->_selections = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_filter_properties[FONT_MANAGER_LANGUAGE_FILTER_SELECTIONS_PROPERTY]);
	}
}

static void
_font_manager_language_filter_on_change_font_manager_language_filter_settings_changed (FontManagerLanguageFilterSettings* _sender,
                                                                                       gpointer self)
{
	font_manager_language_filter_on_change ((FontManagerLanguageFilter*) self);
}

FontManagerLanguageFilterSettings*
font_manager_language_filter_get_settings (FontManagerLanguageFilter* self)
{
	FontManagerLanguageFilterSettings* result;
	FontManagerLanguageFilterSettings* _tmp0_;
	FontManagerLanguageFilterSettings* _tmp2_;
	GBindingFlags flags = 0U;
	FontManagerLanguageFilterSettings* _tmp3_;
	FontManagerLanguageFilterSettings* _tmp4_;
	FontManagerLanguageFilterSettings* _tmp5_;
	FontManagerLanguageFilterSettings* _tmp6_;
	FontManagerLanguageFilterSettings* _tmp7_;
	FontManagerLanguageFilterSettings* _tmp8_;
	FontManagerLanguageFilterSettings* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filter_settings;
	if (_tmp0_ != NULL) {
		FontManagerLanguageFilterSettings* _tmp1_;
		_tmp1_ = self->priv->filter_settings;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = font_manager_language_filter_settings_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->filter_settings);
	self->priv->filter_settings = _tmp2_;
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp3_ = font_manager_language_filter_get_settings (self);
	_tmp4_ = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) self, "coverage", (GObject*) _tmp4_, "coverage", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = font_manager_language_filter_get_settings (self);
	_tmp6_ = _tmp5_;
	g_object_bind_property_with_closures ((GObject*) self, "selections", (GObject*) _tmp6_, "selections", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = self->priv->filter_settings;
	font_manager_language_filter_settings_update (_tmp7_);
	_tmp8_ = self->priv->filter_settings;
	g_signal_connect_object (_tmp8_, "changed", (GCallback) _font_manager_language_filter_on_change_font_manager_language_filter_settings_changed, self, 0);
	_tmp9_ = self->priv->filter_settings;
	result = _tmp9_;
	return result;
}

static void
font_manager_language_filter_class_init (FontManagerLanguageFilterClass * klass,
                                         gpointer klass_data)
{
	font_manager_language_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerLanguageFilter_private_offset);
	((FontManagerFontListFilterClass *) klass)->update = (void (*) (FontManagerFontListFilter*, GAsyncReadyCallback, gpointer)) font_manager_language_filter_real_update;
	((FontManagerFontListFilterClass *) klass)->update_finish = (void (*) (FontManagerFontListFilter*, GAsyncResult*)) font_manager_language_filter_update_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_language_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_language_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_language_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_FILTER_COVERAGE_PROPERTY, font_manager_language_filter_properties[FONT_MANAGER_LANGUAGE_FILTER_COVERAGE_PROPERTY] = g_param_spec_double ("coverage", "coverage", "coverage", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 90, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_FILTER_SELECTIONS_PROPERTY, font_manager_language_filter_properties[FONT_MANAGER_LANGUAGE_FILTER_SELECTIONS_PROPERTY] = g_param_spec_object ("selections", "selections", "selections", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_PROPERTY, font_manager_language_filter_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_language_filter_instance_init (FontManagerLanguageFilter * self,
                                            gpointer klass)
{
	FontManagerStringSet* _tmp0_;
	self->priv = font_manager_language_filter_get_instance_private (self);
	self->priv->_coverage = (gdouble) 90;
	_tmp0_ = font_manager_string_set_new ();
	self->priv->_selections = _tmp0_;
	self->priv->gsettings = NULL;
	self->priv->filter_settings = NULL;
}

static void
font_manager_language_filter_finalize (GObject * obj)
{
	FontManagerLanguageFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilter);
	_g_object_unref0 (self->priv->_selections);
	_g_object_unref0 (self->priv->gsettings);
	_g_object_unref0 (self->priv->filter_settings);
	G_OBJECT_CLASS (font_manager_language_filter_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_language_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerLanguageFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_language_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerLanguageFilter), 0, (GInstanceInitFunc) font_manager_language_filter_instance_init, NULL };
	GType font_manager_language_filter_type_id;
	font_manager_language_filter_type_id = g_type_register_static (FONT_MANAGER_TYPE_CATEGORY, "FontManagerLanguageFilter", &g_define_type_info, 0);
	FontManagerLanguageFilter_private_offset = g_type_add_instance_private (font_manager_language_filter_type_id, sizeof (FontManagerLanguageFilterPrivate));
	return font_manager_language_filter_type_id;
}

GType
font_manager_language_filter_get_type (void)
{
	static volatile gsize font_manager_language_filter_type_id__once = 0;
	if (g_once_init_enter (&font_manager_language_filter_type_id__once)) {
		GType font_manager_language_filter_type_id;
		font_manager_language_filter_type_id = font_manager_language_filter_get_type_once ();
		g_once_init_leave (&font_manager_language_filter_type_id__once, font_manager_language_filter_type_id);
	}
	return font_manager_language_filter_type_id__once;
}

static void
_vala_font_manager_language_filter_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerLanguageFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilter);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_FILTER_COVERAGE_PROPERTY:
		g_value_set_double (value, font_manager_language_filter_get_coverage (self));
		break;
		case FONT_MANAGER_LANGUAGE_FILTER_SELECTIONS_PROPERTY:
		g_value_set_object (value, font_manager_language_filter_get_selections (self));
		break;
		case FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_language_filter_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_language_filter_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerLanguageFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilter);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_FILTER_COVERAGE_PROPERTY:
		font_manager_language_filter_set_coverage (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_LANGUAGE_FILTER_SELECTIONS_PROPERTY:
		font_manager_language_filter_set_selections (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_language_list_row_get_instance_private (FontManagerLanguageListRow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerLanguageListRow_private_offset);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda30_ (FontManagerLanguageListRow* self)
{
	g_signal_emit (self, font_manager_language_list_row_signals[FONT_MANAGER_LANGUAGE_LIST_ROW_CHANGED_SIGNAL], 0, self);
}

static void
___lambda30__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	__lambda30_ ((FontManagerLanguageListRow*) self);
}

FontManagerLanguageListRow*
font_manager_language_list_row_construct (GType object_type,
                                          FontManagerBaseOrthographyData* data)
{
	FontManagerLanguageListRow * self = NULL;
	FontManagerBaseOrthographyData _tmp0_;
	const gchar* _tmp1_;
	FontManagerBaseOrthographyData _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FontManagerBaseOrthographyData _tmp6_;
	const gchar* _tmp7_;
	GtkCheckButton* _tmp8_;
	GtkCheckButton* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	const gchar* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	const gchar* _tmp31_;
	GBindingFlags flags = 0U;
	GtkCheckButton* _tmp32_;
	GtkCheckButton* _tmp33_;
	GtkCheckButton* _tmp34_;
	GtkCheckButton* _tmp35_;
	g_return_val_if_fail (data != NULL, NULL);
	self = (FontManagerLanguageListRow*) font_manager_list_item_row_construct (object_type);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.name;
	font_manager_language_list_row_set_orthography (self, _tmp1_);
	_tmp2_ = *data;
	_tmp3_ = _tmp2_.name;
	_tmp4_ = g_markup_escape_text (g_dgettext (NULL, _tmp3_), (gssize) -1);
	_tmp5_ = _tmp4_;
	font_manager_language_list_row_set_local_name (self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.native;
	font_manager_language_list_row_set_native_name (self, _tmp7_);
	_tmp8_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
	_tmp9_ = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_native_name;
	gtk_label_set_label (_tmp11_, _tmp12_);
	_tmp13_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
	_tmp14_ = _tmp13_;
	gtk_label_set_ellipsize (_tmp14_, PANGO_ELLIPSIZE_NONE);
	_tmp15_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp16_ = _tmp15_;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp16_, "count");
	_tmp17_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp18_ = _tmp17_;
	gtk_widget_add_css_class ((GtkWidget*) _tmp18_, "dim-label");
	_tmp19_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp20_ = _tmp19_;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, TRUE);
	_tmp21_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp22_ = _tmp21_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, TRUE);
	_tmp23_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->_local_name;
	_tmp26_ = string_to_string (_tmp25_);
	_tmp27_ = g_strconcat ("<span size=\"x-small\" font=\"mono\">", _tmp26_, "</span>", NULL);
	_tmp28_ = _tmp27_;
	gtk_label_set_markup (_tmp24_, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp30_ = _tmp29_;
	gtk_label_set_ellipsize (_tmp30_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp31_ = self->priv->_local_name;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp31_);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp32_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
	_tmp33_ = _tmp32_;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp33_, "active", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
	_tmp35_ = _tmp34_;
	g_signal_connect_object (_tmp35_, "toggled", (GCallback) ___lambda30__gtk_check_button_toggled, self, 0);
	return self;
}

FontManagerLanguageListRow*
font_manager_language_list_row_new (FontManagerBaseOrthographyData* data)
{
	return font_manager_language_list_row_construct (FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, data);
}

gboolean
font_manager_language_list_row_get_active (FontManagerLanguageListRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
font_manager_language_list_row_set_active (FontManagerLanguageListRow* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_list_row_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_ACTIVE_PROPERTY]);
	}
}

const gchar*
font_manager_language_list_row_get_orthography (FontManagerLanguageListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_orthography;
	result = _tmp0_;
	return result;
}

static void
font_manager_language_list_row_set_orthography (FontManagerLanguageListRow* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_list_row_get_orthography (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_orthography);
		self->priv->_orthography = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_ORTHOGRAPHY_PROPERTY]);
	}
}

const gchar*
font_manager_language_list_row_get_local_name (FontManagerLanguageListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_local_name;
	result = _tmp0_;
	return result;
}

static void
font_manager_language_list_row_set_local_name (FontManagerLanguageListRow* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_list_row_get_local_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_local_name);
		self->priv->_local_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_LOCAL_NAME_PROPERTY]);
	}
}

const gchar*
font_manager_language_list_row_get_native_name (FontManagerLanguageListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_native_name;
	result = _tmp0_;
	return result;
}

static void
font_manager_language_list_row_set_native_name (FontManagerLanguageListRow* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_list_row_get_native_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_native_name);
		self->priv->_native_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_NATIVE_NAME_PROPERTY]);
	}
}

static void
font_manager_language_list_row_class_init (FontManagerLanguageListRowClass * klass,
                                           gpointer klass_data)
{
	font_manager_language_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerLanguageListRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_language_list_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_language_list_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_language_list_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_LIST_ROW_ACTIVE_PROPERTY, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_LIST_ROW_ORTHOGRAPHY_PROPERTY, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_ORTHOGRAPHY_PROPERTY] = g_param_spec_string ("orthography", "orthography", "orthography", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_LIST_ROW_LOCAL_NAME_PROPERTY, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_LOCAL_NAME_PROPERTY] = g_param_spec_string ("local-name", "local-name", "local-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_LIST_ROW_NATIVE_NAME_PROPERTY, font_manager_language_list_row_properties[FONT_MANAGER_LANGUAGE_LIST_ROW_NATIVE_NAME_PROPERTY] = g_param_spec_string ("native-name", "native-name", "native-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	font_manager_language_list_row_signals[FONT_MANAGER_LANGUAGE_LIST_ROW_CHANGED_SIGNAL] = g_signal_new ("changed", FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW);
}

static void
font_manager_language_list_row_instance_init (FontManagerLanguageListRow * self,
                                              gpointer klass)
{
	self->priv = font_manager_language_list_row_get_instance_private (self);
	self->priv->_active = FALSE;
}

static void
font_manager_language_list_row_finalize (GObject * obj)
{
	FontManagerLanguageListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRow);
	_g_free0 (self->priv->_orthography);
	_g_free0 (self->priv->_local_name);
	_g_free0 (self->priv->_native_name);
	G_OBJECT_CLASS (font_manager_language_list_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_language_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerLanguageListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_language_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerLanguageListRow), 0, (GInstanceInitFunc) font_manager_language_list_row_instance_init, NULL };
	GType font_manager_language_list_row_type_id;
	font_manager_language_list_row_type_id = g_type_register_static (FONT_MANAGER_TYPE_LIST_ITEM_ROW, "FontManagerLanguageListRow", &g_define_type_info, 0);
	FontManagerLanguageListRow_private_offset = g_type_add_instance_private (font_manager_language_list_row_type_id, sizeof (FontManagerLanguageListRowPrivate));
	return font_manager_language_list_row_type_id;
}

GType
font_manager_language_list_row_get_type (void)
{
	static volatile gsize font_manager_language_list_row_type_id__once = 0;
	if (g_once_init_enter (&font_manager_language_list_row_type_id__once)) {
		GType font_manager_language_list_row_type_id;
		font_manager_language_list_row_type_id = font_manager_language_list_row_get_type_once ();
		g_once_init_leave (&font_manager_language_list_row_type_id__once, font_manager_language_list_row_type_id);
	}
	return font_manager_language_list_row_type_id__once;
}

static void
_vala_font_manager_language_list_row_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerLanguageListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRow);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_LIST_ROW_ACTIVE_PROPERTY:
		g_value_set_boolean (value, font_manager_language_list_row_get_active (self));
		break;
		case FONT_MANAGER_LANGUAGE_LIST_ROW_ORTHOGRAPHY_PROPERTY:
		g_value_set_string (value, font_manager_language_list_row_get_orthography (self));
		break;
		case FONT_MANAGER_LANGUAGE_LIST_ROW_LOCAL_NAME_PROPERTY:
		g_value_set_string (value, font_manager_language_list_row_get_local_name (self));
		break;
		case FONT_MANAGER_LANGUAGE_LIST_ROW_NATIVE_NAME_PROPERTY:
		g_value_set_string (value, font_manager_language_list_row_get_native_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_language_list_row_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerLanguageListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRow);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_LIST_ROW_ACTIVE_PROPERTY:
		font_manager_language_list_row_set_active (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_LANGUAGE_LIST_ROW_ORTHOGRAPHY_PROPERTY:
		font_manager_language_list_row_set_orthography (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_LANGUAGE_LIST_ROW_LOCAL_NAME_PROPERTY:
		font_manager_language_list_row_set_local_name (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_LANGUAGE_LIST_ROW_NATIVE_NAME_PROPERTY:
		font_manager_language_list_row_set_native_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_language_filter_settings_get_instance_private (FontManagerLanguageFilterSettings* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerLanguageFilterSettings_private_offset);
}

FontManagerLanguageFilterSettings*
font_manager_language_filter_settings_construct (GType object_type)
{
	FontManagerLanguageFilterSettings * self = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GBindingFlags flags = 0U;
	GtkSpinButton* _tmp2_;
	GtkButton* _tmp3_;
	FontManagerStringSet* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	self = (FontManagerLanguageFilterSettings*) g_object_new (object_type, NULL);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerLanguageFilterSettings");
	_tmp0_ = self->priv->listbox;
	gtk_list_box_set_filter_func (_tmp0_, (GtkListBoxFilterFunc) font_manager_language_filter_settings_matches_search, g_object_ref (self), g_object_unref);
	_tmp1_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp1_, GTK_SELECTION_NONE);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp2_ = self->priv->coverage_spin;
	g_object_bind_property_with_closures ((GObject*) self, "coverage", (GObject*) _tmp2_, "value", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	font_manager_language_filter_settings_populate_list_box (self);
	_tmp3_ = self->priv->clear_button;
	_tmp4_ = self->priv->_selections;
	g_object_get (_tmp4_, "size", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp6_ > ((guint) 0));
	return self;
}

FontManagerLanguageFilterSettings*
font_manager_language_filter_settings_new (void)
{
	return font_manager_language_filter_settings_construct (FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS);
}

static void
font_manager_language_filter_settings_on_item_changed (FontManagerLanguageFilterSettings* self,
                                                       FontManagerLanguageListRow* item)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkButton* _tmp8_;
	FontManagerStringSet* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = font_manager_language_list_row_get_active (item);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		FontManagerStringSet* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->_selections;
		_tmp3_ = font_manager_language_list_row_get_orthography (item);
		_tmp4_ = _tmp3_;
		font_manager_string_set_add (_tmp2_, _tmp4_);
	} else {
		FontManagerStringSet* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->_selections;
		_tmp6_ = font_manager_language_list_row_get_orthography (item);
		_tmp7_ = _tmp6_;
		font_manager_string_set_remove (_tmp5_, _tmp7_);
	}
	_tmp8_ = self->priv->clear_button;
	_tmp9_ = self->priv->_selections;
	g_object_get (_tmp9_, "size", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp11_ > ((guint) 0));
	_tmp13_ = font_manager_language_list_row_get_active (item);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		_tmp12_ = "added";
	} else {
		_tmp12_ = "removed";
	}
	_tmp16_ = font_manager_language_list_row_get_active (item);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		_tmp15_ = "to";
	} else {
		_tmp15_ = "from";
	}
	_tmp18_ = font_manager_language_list_row_get_orthography (item);
	_tmp19_ = _tmp18_;
	g_debug ("LanguageFilter.vala:173: LanguageFilterSettings : %s %s %s selected it" \
"ems", _tmp19_, _tmp12_, _tmp15_);
	return;
}

void
font_manager_language_filter_settings_update (FontManagerLanguageFilterSettings* self)
{
	gint i = 0;
	GtkListBoxRow* widget = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (self != NULL);
	i = 0;
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, i);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	widget = _tmp2_;
	while (TRUE) {
		GtkListBoxRow* _tmp3_;
		FontManagerLanguageListRow* row = NULL;
		GtkListBoxRow* _tmp4_;
		GtkWidget* _tmp5_;
		FontManagerLanguageListRow* _tmp6_;
		FontManagerLanguageListRow* _tmp7_;
		FontManagerStringSet* _tmp8_;
		FontManagerLanguageListRow* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		GtkListBox* _tmp13_;
		GtkListBoxRow* _tmp14_;
		GtkListBoxRow* _tmp15_;
		_tmp3_ = widget;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = widget;
		_tmp5_ = gtk_list_box_row_get_child (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRow));
		row = _tmp6_;
		_tmp7_ = row;
		_tmp8_ = self->priv->_selections;
		_tmp9_ = row;
		_tmp10_ = font_manager_language_list_row_get_orthography (_tmp9_);
		_tmp11_ = _tmp10_;
		font_manager_language_list_row_set_active (_tmp7_, font_manager_string_set_contains (_tmp8_, _tmp11_));
		_tmp12_ = i;
		i = _tmp12_ + 1;
		_tmp13_ = self->priv->listbox;
		_tmp14_ = gtk_list_box_get_row_at_index (_tmp13_, i);
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (widget);
		widget = _tmp15_;
		_g_object_unref0 (row);
	}
	_g_object_unref0 (widget);
	return;
}

static void
_font_manager_language_filter_settings_on_item_changed_font_manager_language_list_row_changed (FontManagerLanguageListRow* _sender,
                                                                                               FontManagerLanguageListRow* item,
                                                                                               gpointer self)
{
	font_manager_language_filter_settings_on_item_changed ((FontManagerLanguageFilterSettings*) self, item);
}

static void
font_manager_language_filter_settings_populate_list_box (FontManagerLanguageFilterSettings* self)
{
	g_return_if_fail (self != NULL);
	{
		FontManagerBaseOrthographyData* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = FONT_MANAGER_Orthographies;
		entry_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_Orthographies);
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			FontManagerBaseOrthographyData entry = {0};
			entry = entry_collection[entry_it];
			{
				FontManagerLanguageListRow* item = NULL;
				FontManagerBaseOrthographyData _tmp0_;
				FontManagerLanguageListRow* _tmp1_;
				GtkListBox* _tmp2_;
				FontManagerLanguageListRow* _tmp3_;
				FontManagerLanguageListRow* _tmp4_;
				FontManagerStringSet* _tmp5_;
				FontManagerLanguageListRow* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				FontManagerLanguageListRow* _tmp9_;
				_tmp0_ = entry;
				_tmp1_ = font_manager_language_list_row_new (&_tmp0_);
				g_object_ref_sink (_tmp1_);
				item = _tmp1_;
				_tmp2_ = self->priv->listbox;
				_tmp3_ = item;
				gtk_list_box_append (_tmp2_, (GtkWidget*) _tmp3_);
				_tmp4_ = item;
				_tmp5_ = self->priv->_selections;
				_tmp6_ = item;
				_tmp7_ = font_manager_language_list_row_get_orthography (_tmp6_);
				_tmp8_ = _tmp7_;
				font_manager_language_list_row_set_active (_tmp4_, font_manager_string_set_contains (_tmp5_, _tmp8_));
				_tmp9_ = item;
				g_signal_connect_object (_tmp9_, "changed", (GCallback) _font_manager_language_filter_settings_on_item_changed_font_manager_language_list_row_changed, self, 0);
				_g_object_unref0 (item);
			}
		}
	}
	return;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
font_manager_language_filter_settings_matches_search (GtkListBoxRow* list_box_row,
                                                      FontManagerLanguageFilterSettings* self)
{
	gboolean match = FALSE;
	gchar* search_term = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* needle = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	FontManagerLanguageListRow* row = NULL;
	GtkWidget* _tmp12_;
	FontManagerLanguageListRow* _tmp13_;
	FontManagerLanguageListRow* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (list_box_row != NULL, FALSE);
	match = TRUE;
	_tmp0_ = self->priv->_search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	search_term = _tmp2_;
	_tmp3_ = search_term;
	if (_tmp3_ == NULL) {
		result = match;
		_g_free0 (search_term);
		return result;
	}
	_tmp4_ = search_term;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	needle = _tmp8_;
	_tmp9_ = needle;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ < 1) {
		result = match;
		_g_free0 (needle);
		_g_free0 (search_term);
		return result;
	}
	_tmp12_ = gtk_list_box_row_get_child (list_box_row);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRow));
	row = _tmp13_;
	_tmp14_ = row;
	_tmp15_ = font_manager_language_list_row_get_native_name (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_utf8_casefold (_tmp16_, (gssize) -1);
	_tmp18_ = _tmp17_;
	_tmp19_ = needle;
	match = string_contains (_tmp18_, _tmp19_);
	_g_free0 (_tmp18_);
	if (!match) {
		FontManagerLanguageListRow* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp20_ = row;
		_tmp21_ = font_manager_language_list_row_get_local_name (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_utf8_casefold (_tmp22_, (gssize) -1);
		_tmp24_ = _tmp23_;
		_tmp25_ = needle;
		match = string_contains (_tmp24_, _tmp25_);
		_g_free0 (_tmp24_);
	}
	result = match;
	_g_object_unref0 (row);
	_g_free0 (needle);
	_g_free0 (search_term);
	return result;
}

static void
font_manager_language_filter_settings_on_search_changed (FontManagerLanguageFilterSettings* self,
                                                         GtkSearchEntry* entry)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_filter (_tmp0_);
	return;
}

static void
_font_manager_language_filter_settings_on_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                          gpointer self)
{
	font_manager_language_filter_settings_on_search_changed ((FontManagerLanguageFilterSettings*) self, _sender);
}

static void
font_manager_language_filter_settings_on_clear_button_clicked (FontManagerLanguageFilterSettings* self,
                                                               GtkButton* button)
{
	gint i = 0;
	GtkListBoxRow* widget = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	i = 0;
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, i);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	widget = _tmp2_;
	while (TRUE) {
		GtkListBoxRow* _tmp3_;
		FontManagerLanguageListRow* row = NULL;
		GtkListBoxRow* _tmp4_;
		GtkWidget* _tmp5_;
		FontManagerLanguageListRow* _tmp6_;
		FontManagerLanguageListRow* _tmp7_;
		gint _tmp8_;
		GtkListBox* _tmp9_;
		GtkListBoxRow* _tmp10_;
		GtkListBoxRow* _tmp11_;
		_tmp3_ = widget;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = widget;
		_tmp5_ = gtk_list_box_row_get_child (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FONT_MANAGER_TYPE_LANGUAGE_LIST_ROW, FontManagerLanguageListRow));
		row = _tmp6_;
		_tmp7_ = row;
		font_manager_language_list_row_set_active (_tmp7_, FALSE);
		_tmp8_ = i;
		i = _tmp8_ + 1;
		_tmp9_ = self->priv->listbox;
		_tmp10_ = gtk_list_box_get_row_at_index (_tmp9_, i);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (widget);
		widget = _tmp11_;
		_g_object_unref0 (row);
	}
	_g_object_unref0 (widget);
	return;
}

static void
_font_manager_language_filter_settings_on_clear_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self)
{
	font_manager_language_filter_settings_on_clear_button_clicked ((FontManagerLanguageFilterSettings*) self, _sender);
}

static void
font_manager_language_filter_settings_on_coverage_changed (FontManagerLanguageFilterSettings* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_signal_emit (self, font_manager_language_filter_settings_signals[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_CHANGED_SIGNAL], 0);
	_tmp0_ = gtk_widget_get_name ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_coverage;
	g_debug ("LanguageFilter.vala:241: %s::coverage : %0.1f", _tmp1_, _tmp2_);
	return;
}

static void
_font_manager_language_filter_settings_on_coverage_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                                          gpointer self)
{
	font_manager_language_filter_settings_on_coverage_changed ((FontManagerLanguageFilterSettings*) self);
}

gdouble
font_manager_language_filter_settings_get_coverage (FontManagerLanguageFilterSettings* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_coverage;
	return result;
}

void
font_manager_language_filter_settings_set_coverage (FontManagerLanguageFilterSettings* self,
                                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_filter_settings_get_coverage (self);
	if (old_value != value) {
		self->priv->_coverage = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_filter_settings_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_COVERAGE_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_language_filter_settings_get_selections (FontManagerLanguageFilterSettings* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selections;
	result = _tmp0_;
	return result;
}

void
font_manager_language_filter_settings_set_selections (FontManagerLanguageFilterSettings* self,
                                                      FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_filter_settings_get_selections (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selections);
		self->priv->_selections = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_filter_settings_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SELECTIONS_PROPERTY]);
	}
}

GtkSearchBar*
font_manager_language_filter_settings_get_search_bar (FontManagerLanguageFilterSettings* self)
{
	GtkSearchBar* result;
	GtkSearchBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_bar;
	result = _tmp0_;
	return result;
}

GtkSearchEntry*
font_manager_language_filter_settings_get_search_entry (FontManagerLanguageFilterSettings* self)
{
	GtkSearchEntry* result;
	GtkSearchEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_entry;
	result = _tmp0_;
	return result;
}

static void
font_manager_language_filter_settings_class_init (FontManagerLanguageFilterSettingsClass * klass,
                                                  gpointer klass_data)
{
	font_manager_language_filter_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerLanguageFilterSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_language_filter_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_language_filter_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_language_filter_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_COVERAGE_PROPERTY, font_manager_language_filter_settings_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_COVERAGE_PROPERTY] = g_param_spec_double ("coverage", "coverage", "coverage", -G_MAXDOUBLE, G_MAXDOUBLE, 90.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SELECTIONS_PROPERTY, font_manager_language_filter_settings_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SELECTIONS_PROPERTY] = g_param_spec_object ("selections", "selections", "selections", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_BAR_PROPERTY, font_manager_language_filter_settings_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_BAR_PROPERTY] = g_param_spec_object ("search-bar", "search-bar", "search-bar", gtk_search_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_ENTRY_PROPERTY, font_manager_language_filter_settings_properties[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_ENTRY_PROPERTY] = g_param_spec_object ("search-entry", "search-entry", "search-entry", gtk_search_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-language-filter-settings.ui");
	font_manager_language_filter_settings_signals[FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_CHANGED_SIGNAL] = g_signal_new ("changed", FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_bar", FALSE, FontManagerLanguageFilterSettings_private_offset + G_STRUCT_OFFSET (FontManagerLanguageFilterSettingsPrivate, _search_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, FontManagerLanguageFilterSettings_private_offset + G_STRUCT_OFFSET (FontManagerLanguageFilterSettingsPrivate, _search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clear_button", FALSE, FontManagerLanguageFilterSettings_private_offset + G_STRUCT_OFFSET (FontManagerLanguageFilterSettingsPrivate, clear_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, FontManagerLanguageFilterSettings_private_offset + G_STRUCT_OFFSET (FontManagerLanguageFilterSettingsPrivate, listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "coverage_spin", FALSE, FontManagerLanguageFilterSettings_private_offset + G_STRUCT_OFFSET (FontManagerLanguageFilterSettingsPrivate, coverage_spin));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_changed", G_CALLBACK(_font_manager_language_filter_settings_on_search_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clear_button_clicked", G_CALLBACK(_font_manager_language_filter_settings_on_clear_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_coverage_changed", G_CALLBACK(_font_manager_language_filter_settings_on_coverage_changed_gtk_spin_button_value_changed));
}

static void
font_manager_language_filter_settings_instance_init (FontManagerLanguageFilterSettings * self,
                                                     gpointer klass)
{
	FontManagerStringSet* _tmp0_;
	self->priv = font_manager_language_filter_settings_get_instance_private (self);
	self->priv->_coverage = 90.0;
	_tmp0_ = font_manager_string_set_new ();
	self->priv->_selections = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_language_filter_settings_finalize (GObject * obj)
{
	FontManagerLanguageFilterSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettings);
	_g_object_unref0 (self->priv->_selections);
	G_OBJECT_CLASS (font_manager_language_filter_settings_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_language_filter_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerLanguageFilterSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_language_filter_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerLanguageFilterSettings), 0, (GInstanceInitFunc) font_manager_language_filter_settings_instance_init, NULL };
	GType font_manager_language_filter_settings_type_id;
	font_manager_language_filter_settings_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerLanguageFilterSettings", &g_define_type_info, 0);
	FontManagerLanguageFilterSettings_private_offset = g_type_add_instance_private (font_manager_language_filter_settings_type_id, sizeof (FontManagerLanguageFilterSettingsPrivate));
	return font_manager_language_filter_settings_type_id;
}

GType
font_manager_language_filter_settings_get_type (void)
{
	static volatile gsize font_manager_language_filter_settings_type_id__once = 0;
	if (g_once_init_enter (&font_manager_language_filter_settings_type_id__once)) {
		GType font_manager_language_filter_settings_type_id;
		font_manager_language_filter_settings_type_id = font_manager_language_filter_settings_get_type_once ();
		g_once_init_leave (&font_manager_language_filter_settings_type_id__once, font_manager_language_filter_settings_type_id);
	}
	return font_manager_language_filter_settings_type_id__once;
}

static void
_vala_font_manager_language_filter_settings_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	FontManagerLanguageFilterSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettings);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_COVERAGE_PROPERTY:
		g_value_set_double (value, font_manager_language_filter_settings_get_coverage (self));
		break;
		case FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SELECTIONS_PROPERTY:
		g_value_set_object (value, font_manager_language_filter_settings_get_selections (self));
		break;
		case FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_BAR_PROPERTY:
		g_value_set_object (value, font_manager_language_filter_settings_get_search_bar (self));
		break;
		case FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SEARCH_ENTRY_PROPERTY:
		g_value_set_object (value, font_manager_language_filter_settings_get_search_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_language_filter_settings_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	FontManagerLanguageFilterSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettings);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_COVERAGE_PROPERTY:
		font_manager_language_filter_settings_set_coverage (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_SELECTIONS_PROPERTY:
		font_manager_language_filter_settings_set_selections (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

