/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-ifwi-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/**
 * fu_struct_ifwi_cpd_ref: (skip):
 **/
FuStructIfwiCpd *
fu_struct_ifwi_cpd_ref(FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ifwi_cpd_unref: (skip):
 **/
void
fu_struct_ifwi_cpd_unref(FuStructIfwiCpd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIfwiCpd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIfwiCpd *
fu_struct_ifwi_cpd_new_internal(void)
{
    FuStructIfwiCpd *st = g_new0(FuStructIfwiCpd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ifwi_cpd_get_header_marker: (skip):
 **/
static guint32
fu_struct_ifwi_cpd_get_header_marker(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_get_num_of_entries: (skip):
 **/
guint32
fu_struct_ifwi_cpd_get_num_of_entries(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_get_header_version: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_header_version(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_ifwi_cpd_get_entry_version: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_entry_version(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_ifwi_cpd_get_header_length: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_header_length(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_ifwi_cpd_get_checksum: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_checksum(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_ifwi_cpd_get_partition_name: (skip):
 **/
guint32
fu_struct_ifwi_cpd_get_partition_name(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_get_crc32: (skip):
 **/
guint32
fu_struct_ifwi_cpd_get_crc32(const FuStructIfwiCpd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_set_header_marker: (skip):
 **/
static void
fu_struct_ifwi_cpd_set_header_marker(FuStructIfwiCpd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_set_num_of_entries: (skip):
 **/
void
fu_struct_ifwi_cpd_set_num_of_entries(FuStructIfwiCpd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_set_header_version: (skip):
 **/
void
fu_struct_ifwi_cpd_set_header_version(FuStructIfwiCpd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_ifwi_cpd_set_entry_version: (skip):
 **/
void
fu_struct_ifwi_cpd_set_entry_version(FuStructIfwiCpd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[9] = value;
}
/**
 * fu_struct_ifwi_cpd_set_header_length: (skip):
 **/
void
fu_struct_ifwi_cpd_set_header_length(FuStructIfwiCpd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[10] = value;
}
/**
 * fu_struct_ifwi_cpd_set_checksum: (skip):
 **/
void
fu_struct_ifwi_cpd_set_checksum(FuStructIfwiCpd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[11] = value;
}
/**
 * fu_struct_ifwi_cpd_set_partition_name: (skip):
 **/
void
fu_struct_ifwi_cpd_set_partition_name(FuStructIfwiCpd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_set_crc32: (skip):
 **/
void
fu_struct_ifwi_cpd_set_crc32(FuStructIfwiCpd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_new: (skip):
 **/
FuStructIfwiCpd *
fu_struct_ifwi_cpd_new(void)
{
    FuStructIfwiCpd *st = fu_struct_ifwi_cpd_new_internal();
    st->buf = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st->buf, 20, 0x0);
    fu_struct_ifwi_cpd_set_header_marker(st, 0x44504324);
    fu_struct_ifwi_cpd_set_header_length(st, 20);
    return st;
}
/**
 * fu_struct_ifwi_cpd_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_to_string(const FuStructIfwiCpd *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfwiCpd:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  num_of_entries: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_num_of_entries(st));
    g_string_append_printf(str, "  header_version: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_header_version(st));
    g_string_append_printf(str, "  entry_version: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_entry_version(st));
    g_string_append_printf(str, "  header_length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_header_length(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_checksum(st));
    g_string_append_printf(str, "  partition_name: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_partition_name(st));
    g_string_append_printf(str, "  crc32: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_crc32(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifwi_cpd_validate_internal(FuStructIfwiCpd *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_ifwi_cpd_get_header_marker(st) != 0x44504324) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructIfwiCpd.header_marker was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x44504324,
                    (guint) fu_struct_ifwi_cpd_get_header_marker(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ifwi_cpd_validate_stream: (skip):
 **/
gboolean
fu_struct_ifwi_cpd_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiCpd) st = fu_struct_ifwi_cpd_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 20, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiCpd failed read of 0x%x: ", (guint) 20);
        return FALSE;
    }
    if (st->buf->len != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiCpd requested 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_ifwi_cpd_validate_internal(st, error);
}
static gboolean
fu_struct_ifwi_cpd_parse_internal(FuStructIfwiCpd *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifwi_cpd_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifwi_cpd_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifwi_cpd_parse_stream: (skip):
 **/
FuStructIfwiCpd *
fu_struct_ifwi_cpd_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiCpd) st = fu_struct_ifwi_cpd_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 20, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiCpd failed read of 0x%x: ", (guint) 20);
        return NULL;
    }
    if (st->buf->len != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiCpd requested 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ifwi_cpd_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_cpd_entry_ref: (skip):
 **/
FuStructIfwiCpdEntry *
fu_struct_ifwi_cpd_entry_ref(FuStructIfwiCpdEntry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ifwi_cpd_entry_unref: (skip):
 **/
void
fu_struct_ifwi_cpd_entry_unref(FuStructIfwiCpdEntry *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIfwiCpdEntry refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIfwiCpdEntry *
fu_struct_ifwi_cpd_entry_new_internal(void)
{
    FuStructIfwiCpdEntry *st = g_new0(FuStructIfwiCpdEntry, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ifwi_cpd_entry_get_name: (skip):
 **/
gchar *
fu_struct_ifwi_cpd_entry_get_name(const FuStructIfwiCpdEntry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 12, NULL);
}
/**
 * fu_struct_ifwi_cpd_entry_get_offset: (skip):
 **/
guint32
fu_struct_ifwi_cpd_entry_get_offset(const FuStructIfwiCpdEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_entry_get_length: (skip):
 **/
guint32
fu_struct_ifwi_cpd_entry_get_length(const FuStructIfwiCpdEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_entry_set_name: (skip):
 **/
gboolean
fu_struct_ifwi_cpd_entry_set_name(FuStructIfwiCpdEntry *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 12);
        return TRUE;
    }
    len = strlen(value);
    if (len > 12) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructIfwiCpdEntry.name (0x%x bytes)",
                    value, (guint) len, (guint) 12);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_ifwi_cpd_entry_set_offset: (skip):
 **/
void
fu_struct_ifwi_cpd_entry_set_offset(FuStructIfwiCpdEntry *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_entry_set_length: (skip):
 **/
void
fu_struct_ifwi_cpd_entry_set_length(FuStructIfwiCpdEntry *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_entry_new: (skip):
 **/
FuStructIfwiCpdEntry *
fu_struct_ifwi_cpd_entry_new(void)
{
    FuStructIfwiCpdEntry *st = fu_struct_ifwi_cpd_entry_new_internal();
    st->buf = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st->buf, 24, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_cpd_entry_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_entry_to_string(const FuStructIfwiCpdEntry *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfwiCpdEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_ifwi_cpd_entry_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_entry_get_offset(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_entry_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifwi_cpd_entry_validate_internal(FuStructIfwiCpdEntry *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ifwi_cpd_entry_parse_internal(FuStructIfwiCpdEntry *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifwi_cpd_entry_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifwi_cpd_entry_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifwi_cpd_entry_parse_stream: (skip):
 **/
FuStructIfwiCpdEntry *
fu_struct_ifwi_cpd_entry_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiCpdEntry) st = fu_struct_ifwi_cpd_entry_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 24, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiCpdEntry failed read of 0x%x: ", (guint) 24);
        return NULL;
    }
    if (st->buf->len != 24) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiCpdEntry requested 0x%x and got 0x%x",
                    (guint) 24,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ifwi_cpd_entry_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_cpd_manifest_ref: (skip):
 **/
FuStructIfwiCpdManifest *
fu_struct_ifwi_cpd_manifest_ref(FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ifwi_cpd_manifest_unref: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_unref(FuStructIfwiCpdManifest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIfwiCpdManifest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIfwiCpdManifest *
fu_struct_ifwi_cpd_manifest_new_internal(void)
{
    FuStructIfwiCpdManifest *st = g_new0(FuStructIfwiCpdManifest, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ifwi_cpd_manifest_get_header_type: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_header_type(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_header_length: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_header_length(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_header_version: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_header_version(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_flags: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_flags(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_vendor: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_vendor(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_date: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_date(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_size: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_size(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_id: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_id(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_rsvd: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_rsvd(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_version_major: (skip):
 **/
guint16
fu_struct_ifwi_cpd_manifest_get_version_major(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_version_minor: (skip):
 **/
guint16
fu_struct_ifwi_cpd_manifest_get_version_minor(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 38, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_version_hotfix: (skip):
 **/
guint16
fu_struct_ifwi_cpd_manifest_get_version_hotfix(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_version_build: (skip):
 **/
guint16
fu_struct_ifwi_cpd_manifest_get_version_build(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 42, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_svn: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_svn(const FuStructIfwiCpdManifest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 44, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_manifest_set_header_type: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_header_type(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_header_length: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_header_length(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_header_version: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_header_version(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_flags: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_flags(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_vendor: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_vendor(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_date: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_date(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_size: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_size(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_id: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_id(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_rsvd: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_rsvd(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_version_major: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_version_major(FuStructIfwiCpdManifest *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 36, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_version_minor: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_version_minor(FuStructIfwiCpdManifest *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 38, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_version_hotfix: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_version_hotfix(FuStructIfwiCpdManifest *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_version_build: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_version_build(FuStructIfwiCpdManifest *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 42, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_svn: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_svn(FuStructIfwiCpdManifest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 44, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_new: (skip):
 **/
FuStructIfwiCpdManifest *
fu_struct_ifwi_cpd_manifest_new(void)
{
    FuStructIfwiCpdManifest *st = fu_struct_ifwi_cpd_manifest_new_internal();
    st->buf = g_byte_array_sized_new(48);
    fu_byte_array_set_size(st->buf, 48, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_cpd_manifest_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_manifest_to_string(const FuStructIfwiCpdManifest *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfwiCpdManifest:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  header_type: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_header_type(st));
    g_string_append_printf(str, "  header_length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_header_length(st));
    g_string_append_printf(str, "  header_version: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_header_version(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_flags(st));
    g_string_append_printf(str, "  vendor: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_vendor(st));
    g_string_append_printf(str, "  date: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_date(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_size(st));
    g_string_append_printf(str, "  id: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_id(st));
    g_string_append_printf(str, "  rsvd: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_rsvd(st));
    g_string_append_printf(str, "  version_major: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_version_major(st));
    g_string_append_printf(str, "  version_minor: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_version_minor(st));
    g_string_append_printf(str, "  version_hotfix: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_version_hotfix(st));
    g_string_append_printf(str, "  version_build: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_version_build(st));
    g_string_append_printf(str, "  svn: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_svn(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifwi_cpd_manifest_validate_internal(FuStructIfwiCpdManifest *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ifwi_cpd_manifest_parse_internal(FuStructIfwiCpdManifest *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifwi_cpd_manifest_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifwi_cpd_manifest_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifwi_cpd_manifest_parse_stream: (skip):
 **/
FuStructIfwiCpdManifest *
fu_struct_ifwi_cpd_manifest_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiCpdManifest) st = fu_struct_ifwi_cpd_manifest_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 48, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiCpdManifest failed read of 0x%x: ", (guint) 48);
        return NULL;
    }
    if (st->buf->len != 48) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiCpdManifest requested 0x%x and got 0x%x",
                    (guint) 48,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ifwi_cpd_manifest_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_ref: (skip):
 **/
FuStructIfwiCpdManifestExt *
fu_struct_ifwi_cpd_manifest_ext_ref(FuStructIfwiCpdManifestExt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_unref: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_ext_unref(FuStructIfwiCpdManifestExt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIfwiCpdManifestExt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIfwiCpdManifestExt *
fu_struct_ifwi_cpd_manifest_ext_new_internal(void)
{
    FuStructIfwiCpdManifestExt *st = g_new0(FuStructIfwiCpdManifestExt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ifwi_cpd_manifest_ext_get_extension_type: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_ext_get_extension_type(const FuStructIfwiCpdManifestExt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_get_extension_length: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_ext_get_extension_length(const FuStructIfwiCpdManifestExt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_manifest_ext_set_extension_type: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_ext_set_extension_type(FuStructIfwiCpdManifestExt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_set_extension_length: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_ext_set_extension_length(FuStructIfwiCpdManifestExt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_new: (skip):
 **/
FuStructIfwiCpdManifestExt *
fu_struct_ifwi_cpd_manifest_ext_new(void)
{
    FuStructIfwiCpdManifestExt *st = fu_struct_ifwi_cpd_manifest_ext_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_manifest_ext_to_string(const FuStructIfwiCpdManifestExt *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfwiCpdManifestExt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  extension_type: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_ext_get_extension_type(st));
    g_string_append_printf(str, "  extension_length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_ext_get_extension_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifwi_cpd_manifest_ext_validate_internal(FuStructIfwiCpdManifestExt *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ifwi_cpd_manifest_ext_parse_internal(FuStructIfwiCpdManifestExt *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifwi_cpd_manifest_ext_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifwi_cpd_manifest_ext_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_parse_stream: (skip):
 **/
FuStructIfwiCpdManifestExt *
fu_struct_ifwi_cpd_manifest_ext_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiCpdManifestExt) st = fu_struct_ifwi_cpd_manifest_ext_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiCpdManifestExt failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiCpdManifestExt requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ifwi_cpd_manifest_ext_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_fpt_ref: (skip):
 **/
FuStructIfwiFpt *
fu_struct_ifwi_fpt_ref(FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ifwi_fpt_unref: (skip):
 **/
void
fu_struct_ifwi_fpt_unref(FuStructIfwiFpt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIfwiFpt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIfwiFpt *
fu_struct_ifwi_fpt_new_internal(void)
{
    FuStructIfwiFpt *st = g_new0(FuStructIfwiFpt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ifwi_fpt_get_header_marker: (skip):
 **/
static guint32
fu_struct_ifwi_fpt_get_header_marker(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_num_of_entries: (skip):
 **/
guint32
fu_struct_ifwi_fpt_get_num_of_entries(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_header_version: (skip):
 **/
guint8
fu_struct_ifwi_fpt_get_header_version(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_ifwi_fpt_get_entry_version: (skip):
 **/
static guint8
fu_struct_ifwi_fpt_get_entry_version(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_ifwi_fpt_get_header_length: (skip):
 **/
guint8
fu_struct_ifwi_fpt_get_header_length(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_ifwi_fpt_get_flags: (skip):
 **/
guint8
fu_struct_ifwi_fpt_get_flags(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_ifwi_fpt_get_ticks_to_add: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_ticks_to_add(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_tokens_to_add: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_tokens_to_add(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_uma_size: (skip):
 **/
guint32
fu_struct_ifwi_fpt_get_uma_size(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_crc32: (skip):
 **/
guint32
fu_struct_ifwi_fpt_get_crc32(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_major: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_major(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_minor: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_minor(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_hotfix: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_hotfix(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_build: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_build(const FuStructIfwiFpt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 30, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_fpt_set_header_marker: (skip):
 **/
static void
fu_struct_ifwi_fpt_set_header_marker(FuStructIfwiFpt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_num_of_entries: (skip):
 **/
void
fu_struct_ifwi_fpt_set_num_of_entries(FuStructIfwiFpt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_header_version: (skip):
 **/
void
fu_struct_ifwi_fpt_set_header_version(FuStructIfwiFpt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_ifwi_fpt_set_entry_version: (skip):
 **/
static void
fu_struct_ifwi_fpt_set_entry_version(FuStructIfwiFpt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[9] = value;
}
/**
 * fu_struct_ifwi_fpt_set_header_length: (skip):
 **/
void
fu_struct_ifwi_fpt_set_header_length(FuStructIfwiFpt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[10] = value;
}
/**
 * fu_struct_ifwi_fpt_set_flags: (skip):
 **/
void
fu_struct_ifwi_fpt_set_flags(FuStructIfwiFpt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[11] = value;
}
/**
 * fu_struct_ifwi_fpt_set_ticks_to_add: (skip):
 **/
void
fu_struct_ifwi_fpt_set_ticks_to_add(FuStructIfwiFpt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_tokens_to_add: (skip):
 **/
void
fu_struct_ifwi_fpt_set_tokens_to_add(FuStructIfwiFpt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_uma_size: (skip):
 **/
void
fu_struct_ifwi_fpt_set_uma_size(FuStructIfwiFpt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_crc32: (skip):
 **/
void
fu_struct_ifwi_fpt_set_crc32(FuStructIfwiFpt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_major: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_major(FuStructIfwiFpt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_minor: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_minor(FuStructIfwiFpt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_hotfix: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_hotfix(FuStructIfwiFpt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_build: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_build(FuStructIfwiFpt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 30, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_new: (skip):
 **/
FuStructIfwiFpt *
fu_struct_ifwi_fpt_new(void)
{
    FuStructIfwiFpt *st = fu_struct_ifwi_fpt_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    fu_struct_ifwi_fpt_set_header_marker(st, 0x54504624);
    fu_struct_ifwi_fpt_set_header_version(st, 0x20);
    fu_struct_ifwi_fpt_set_entry_version(st, 0x10);
    fu_struct_ifwi_fpt_set_header_length(st, 32);
    return st;
}
/**
 * fu_struct_ifwi_fpt_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_fpt_to_string(const FuStructIfwiFpt *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfwiFpt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  num_of_entries: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_num_of_entries(st));
    g_string_append_printf(str, "  header_version: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_header_version(st));
    g_string_append_printf(str, "  header_length: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_header_length(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_flags(st));
    g_string_append_printf(str, "  ticks_to_add: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_ticks_to_add(st));
    g_string_append_printf(str, "  tokens_to_add: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_tokens_to_add(st));
    g_string_append_printf(str, "  uma_size: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_uma_size(st));
    g_string_append_printf(str, "  crc32: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_crc32(st));
    g_string_append_printf(str, "  fitc_major: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_major(st));
    g_string_append_printf(str, "  fitc_minor: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_minor(st));
    g_string_append_printf(str, "  fitc_hotfix: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_hotfix(st));
    g_string_append_printf(str, "  fitc_build: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_build(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifwi_fpt_validate_internal(FuStructIfwiFpt *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_ifwi_fpt_get_header_marker(st) != 0x54504624) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructIfwiFpt.header_marker was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x54504624,
                    (guint) fu_struct_ifwi_fpt_get_header_marker(st));
        return FALSE;
    }
    if (fu_struct_ifwi_fpt_get_entry_version(st) != 0x10) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructIfwiFpt.entry_version was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ifwi_fpt_validate_stream: (skip):
 **/
gboolean
fu_struct_ifwi_fpt_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiFpt) st = fu_struct_ifwi_fpt_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiFpt failed read of 0x%x: ", (guint) 32);
        return FALSE;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiFpt requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_ifwi_fpt_validate_internal(st, error);
}
static gboolean
fu_struct_ifwi_fpt_parse_internal(FuStructIfwiFpt *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifwi_fpt_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifwi_fpt_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifwi_fpt_parse_stream: (skip):
 **/
FuStructIfwiFpt *
fu_struct_ifwi_fpt_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiFpt) st = fu_struct_ifwi_fpt_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiFpt failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiFpt requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ifwi_fpt_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_fpt_entry_ref: (skip):
 **/
FuStructIfwiFptEntry *
fu_struct_ifwi_fpt_entry_ref(FuStructIfwiFptEntry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ifwi_fpt_entry_unref: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_unref(FuStructIfwiFptEntry *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIfwiFptEntry refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIfwiFptEntry *
fu_struct_ifwi_fpt_entry_new_internal(void)
{
    FuStructIfwiFptEntry *st = g_new0(FuStructIfwiFptEntry, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ifwi_fpt_entry_get_partition_name: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_partition_name(const FuStructIfwiFptEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_get_offset: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_offset(const FuStructIfwiFptEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_get_length: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_length(const FuStructIfwiFptEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_get_partition_type: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_partition_type(const FuStructIfwiFptEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_fpt_entry_set_partition_name: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_partition_name(FuStructIfwiFptEntry *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_set_offset: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_offset(FuStructIfwiFptEntry *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_set_length: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_length(FuStructIfwiFptEntry *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_set_partition_type: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_partition_type(FuStructIfwiFptEntry *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_new: (skip):
 **/
FuStructIfwiFptEntry *
fu_struct_ifwi_fpt_entry_new(void)
{
    FuStructIfwiFptEntry *st = fu_struct_ifwi_fpt_entry_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_fpt_entry_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_fpt_entry_to_string(const FuStructIfwiFptEntry *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIfwiFptEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  partition_name: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_partition_name(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_offset(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_length(st));
    g_string_append_printf(str, "  partition_type: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_partition_type(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ifwi_fpt_entry_validate_internal(FuStructIfwiFptEntry *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ifwi_fpt_entry_parse_internal(FuStructIfwiFptEntry *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ifwi_fpt_entry_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ifwi_fpt_entry_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ifwi_fpt_entry_parse_stream: (skip):
 **/
FuStructIfwiFptEntry *
fu_struct_ifwi_fpt_entry_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIfwiFptEntry) st = fu_struct_ifwi_fpt_entry_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIfwiFptEntry failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIfwiFptEntry requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ifwi_fpt_entry_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
