/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-scsi-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_scsi_sense_key_to_string(FuScsiSenseKey val)
{
    if (val == FU_SCSI_SENSE_KEY_NO_SENSE)
        return "no-sense";
    if (val == FU_SCSI_SENSE_KEY_RECOVERED_ERROR)
        return "recovered-error";
    if (val == FU_SCSI_SENSE_KEY_NOT_READY)
        return "not-ready";
    if (val == FU_SCSI_SENSE_KEY_MEDIUM_ERROR)
        return "medium-error";
    if (val == FU_SCSI_SENSE_KEY_HARDWARE_ERROR)
        return "hardware-error";
    if (val == FU_SCSI_SENSE_KEY_ILLEGAL_REQUEST)
        return "illegal-request";
    if (val == FU_SCSI_SENSE_KEY_UNIT_ATTENTION)
        return "unit-attention";
    if (val == FU_SCSI_SENSE_KEY_DATA_PROTECT)
        return "data-protect";
    if (val == FU_SCSI_SENSE_KEY_BLANK_CHECK)
        return "blank-check";
    if (val == FU_SCSI_SENSE_KEY_VENDOR_SPECIFIC)
        return "vendor-specific";
    if (val == FU_SCSI_SENSE_KEY_COPY_ABORTED)
        return "copy-aborted";
    if (val == FU_SCSI_SENSE_KEY_ABORTED_COMMAND)
        return "aborted-command";
    if (val == FU_SCSI_SENSE_KEY_EQUAL)
        return "equal";
    if (val == FU_SCSI_SENSE_KEY_VOLUME_OVERFLOW)
        return "volume-overflow";
    if (val == FU_SCSI_SENSE_KEY_MISCOMPARE)
        return "miscompare";
    return NULL;
}
/**
 * fu_struct_scsi_inquiry_ref: (skip):
 **/
FuStructScsiInquiry *
fu_struct_scsi_inquiry_ref(FuStructScsiInquiry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_scsi_inquiry_unref: (skip):
 **/
void
fu_struct_scsi_inquiry_unref(FuStructScsiInquiry *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructScsiInquiry refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructScsiInquiry *
fu_struct_scsi_inquiry_new_internal(void)
{
    FuStructScsiInquiry *st = g_new0(FuStructScsiInquiry, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_scsi_inquiry_get_vendor_id: (skip):
 **/
gchar *
fu_struct_scsi_inquiry_get_vendor_id(const FuStructScsiInquiry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 8, NULL);
}
/**
 * fu_struct_scsi_inquiry_get_product_id: (skip):
 **/
gchar *
fu_struct_scsi_inquiry_get_product_id(const FuStructScsiInquiry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 16, 16, NULL);
}
/**
 * fu_struct_scsi_inquiry_get_product_rev: (skip):
 **/
gchar *
fu_struct_scsi_inquiry_get_product_rev(const FuStructScsiInquiry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 32, 4, NULL);
}

/* setters */
/**
 * fu_struct_scsi_inquiry_to_string: (skip):
 **/
static gchar *
fu_struct_scsi_inquiry_to_string(const FuStructScsiInquiry *st)
{
    g_autoptr(GString) str = g_string_new("FuStructScsiInquiry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_scsi_inquiry_get_vendor_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  vendor_id: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_scsi_inquiry_get_product_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  product_id: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_scsi_inquiry_get_product_rev(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  product_rev: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_scsi_inquiry_validate_internal(FuStructScsiInquiry *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_scsi_inquiry_parse_internal(FuStructScsiInquiry *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_scsi_inquiry_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_scsi_inquiry_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_scsi_inquiry_parse: (skip):
 **/
FuStructScsiInquiry *
fu_struct_scsi_inquiry_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructScsiInquiry) st = fu_struct_scsi_inquiry_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 36, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructScsiInquiry: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 36);
    if (!fu_struct_scsi_inquiry_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
