/* BackgroundSource.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundSource.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <meta/display.h>
#include <gio/gio.h>
#include <glib.h>
#include <meta/meta-monitor-manager.h>
#include <stdlib.h>
#include <string.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include "gala.h"
#include <glib/gstdio.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;
typedef struct _GalaBackgroundSourcePrivate GalaBackgroundSourcePrivate;

#define GALA_TYPE_BACKGROUND (gala_background_get_type ())
#define GALA_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND, GalaBackground))
#define GALA_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND, GalaBackgroundClass))
#define GALA_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND))
#define GALA_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND))
#define GALA_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND, GalaBackgroundClass))

typedef struct _GalaBackground GalaBackground;
typedef struct _GalaBackgroundClass GalaBackgroundClass;
enum  {
	GALA_BACKGROUND_SOURCE_0_PROPERTY,
	GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY,
	GALA_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY,
	GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY,
	GALA_BACKGROUND_SOURCE_SHOULD_DIM_PROPERTY,
	GALA_BACKGROUND_SOURCE_NUM_PROPERTIES
};
static GParamSpec* gala_background_source_properties[GALA_BACKGROUND_SOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block46Data Block46Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL,
	GALA_BACKGROUND_SOURCE_NUM_SIGNALS
};
static guint gala_background_source_signals[GALA_BACKGROUND_SOURCE_NUM_SIGNALS] = {0};

struct _GalaBackgroundSource {
	GObject parent_instance;
	GalaBackgroundSourcePrivate * priv;
};

struct _GalaBackgroundSourceClass {
	GObjectClass parent_class;
};

struct _GalaBackgroundSourcePrivate {
	MetaDisplay* _display;
	GSettings* _gnome_background_settings;
	gint _use_count;
	GHashTable* backgrounds;
	guint* hash_cache;
	gint hash_cache_length1;
	gint _hash_cache_size_;
	MetaMonitorManager* monitor_manager;
	GSettings* gala_background_settings;
};

struct _Block46Data {
	int _ref_count_;
	GalaBackgroundSource* self;
	gint n;
	gint i;
};

static gint GalaBackgroundSource_private_offset;
static gpointer gala_background_source_parent_class = NULL;

VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GType gala_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackground, g_object_unref)
VALA_EXTERN GalaBackgroundSource* gala_background_source_new (MetaDisplay* display);
VALA_EXTERN GalaBackgroundSource* gala_background_source_construct (GType object_type,
                                                        MetaDisplay* display);
static void gala_background_source_monitors_changed (GalaBackgroundSource* self);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
VALA_EXTERN MetaDisplay* gala_background_source_get_display (GalaBackgroundSource* self);
static gboolean __lambda22_ (Block46Data* _data46_,
                      gint hash,
                      GalaBackground* background);
VALA_EXTERN void gala_background_update_resolution (GalaBackground* self);
static void gala_background_source_background_changed (GalaBackgroundSource* self,
                                                GalaBackground* background);
static void _gala_background_source_background_changed_gala_background_changed (GalaBackground* _sender,
                                                                         gpointer self);
VALA_EXTERN void gala_background_destroy (GalaBackground* self);
static gboolean ___lambda22__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
VALA_EXTERN GalaBackground* gala_background_source_get_background (GalaBackgroundSource* self,
                                                       gint monitor_index);
VALA_EXTERN GSettings* gala_background_source_get_gnome_background_settings (GalaBackgroundSource* self);
static gchar* gala_background_source_get_background_path (GalaBackgroundSource* self);
VALA_EXTERN GalaBackground* gala_background_new (MetaDisplay* display,
                                     gint monitor_index,
                                     const gchar* filename,
                                     GalaBackgroundSource* background_source,
                                     GDesktopBackgroundStyle style);
VALA_EXTERN GalaBackground* gala_background_construct (GType object_type,
                                           MetaDisplay* display,
                                           gint monitor_index,
                                           const gchar* filename,
                                           GalaBackgroundSource* background_source,
                                           GDesktopBackgroundStyle style);
VALA_EXTERN gint gala_background_get_monitor_index (GalaBackground* self);
VALA_EXTERN void gala_background_source_destroy (GalaBackgroundSource* self);
static void _gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                     gpointer self);
static gboolean __lambda27_ (GalaBackgroundSource* self,
                      gint hash,
                      GalaBackground* background);
static gboolean ___lambda27__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static void gala_background_source_set_display (GalaBackgroundSource* self,
                                         MetaDisplay* value);
static void gala_background_source_set_gnome_background_settings (GalaBackgroundSource* self,
                                                           GSettings* value);
 G_GNUC_INTERNAL gint gala_background_source_get_use_count (GalaBackgroundSource* self);
 G_GNUC_INTERNAL void gala_background_source_set_use_count (GalaBackgroundSource* self,
                                           gint value);
VALA_EXTERN gboolean gala_background_source_get_should_dim (GalaBackgroundSource* self);
static GObject * gala_background_source_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _gala_background_source___lambda30_ (GalaBackgroundSource* self);
static void __gala_background_source___lambda30__g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static void _gala_background_source___lambda31_ (GalaBackgroundSource* self);
static void __gala_background_source___lambda31__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _gala_background_source___lambda32_ (GalaBackgroundSource* self,
                                          const gchar* key);
static void __gala_background_source___lambda32__g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static void gala_background_source_finalize (GObject * obj);
static GType gala_background_source_get_type_once (void);
static void _vala_gala_background_source_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_background_source_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static const gchar* GALA_BACKGROUND_SOURCE_OPTIONS[6] = {"color-shading-type", "picture-options", "picture-uri", "picture-uri-dark", "primary-color", "secondary-color"};

static inline gpointer
gala_background_source_get_instance_private (GalaBackgroundSource* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundSource_private_offset);
}

GalaBackgroundSource*
gala_background_source_construct (GType object_type,
                                  MetaDisplay* display)
{
	GalaBackgroundSource * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaBackgroundSource*) g_object_new (object_type, "display", display, NULL);
	return self;
}

GalaBackgroundSource*
gala_background_source_new (MetaDisplay* display)
{
	return gala_background_source_construct (GALA_TYPE_BACKGROUND_SOURCE, display);
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		GalaBackgroundSource* self;
		self = _data46_->self;
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}

static void
_gala_background_source_background_changed_gala_background_changed (GalaBackground* _sender,
                                                                    gpointer self)
{
	gala_background_source_background_changed ((GalaBackgroundSource*) self, _sender);
}

static gboolean
__lambda22_ (Block46Data* _data46_,
             gint hash,
             GalaBackground* background)
{
	GalaBackgroundSource* self;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	self = _data46_->self;
	g_return_val_if_fail (background != NULL, FALSE);
	_tmp0_ = _data46_->i;
	_data46_->i = _tmp0_ + 1;
	_tmp1_ = _data46_->n;
	if (_tmp0_ < _tmp1_) {
		gala_background_update_resolution (background);
		result = FALSE;
		return result;
	} else {
		guint _tmp2_;
		g_signal_parse_name ("changed", GALA_TYPE_BACKGROUND, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (background, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gala_background_source_background_changed_gala_background_changed, self);
		gala_background_destroy (background);
		result = TRUE;
		return result;
	}
}

static gboolean
___lambda22__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda22_ (self, (gint) ((gintptr) key), (GalaBackground*) value);
	return result;
}

static void
gala_background_source_monitors_changed (GalaBackgroundSource* self)
{
	Block46Data* _data46_;
	MetaDisplay* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->self = g_object_ref (self);
	_tmp0_ = self->priv->_display;
	_data46_->n = meta_display_get_n_monitors (_tmp0_);
	_data46_->i = 0;
	_tmp1_ = self->priv->backgrounds;
	g_hash_table_foreach_remove (_tmp1_, ___lambda22__ghr_func, _data46_);
	block46_data_unref (_data46_);
	_data46_ = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GalaBackground*
gala_background_source_get_background (GalaBackgroundSource* self,
                                       gint monitor_index)
{
	gchar* filename = NULL;
	gint style = 0;
	GSettings* _tmp0_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GalaBackground* background = NULL;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	GalaBackground* _tmp7_;
	GalaBackground* _tmp8_;
	GalaBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	filename = NULL;
	_tmp0_ = self->priv->_gnome_background_settings;
	style = g_settings_get_enum (_tmp0_, "picture-options");
	if (style != ((gint) G_DESKTOP_BACKGROUND_STYLE_NONE)) {
		gchar* _tmp1_;
		_tmp1_ = gala_background_source_get_background_path (self);
		_g_free0 (filename);
		filename = _tmp1_;
	}
	_tmp3_ = filename;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = filename;
		_tmp2_ = !g_str_has_suffix (_tmp4_, ".xml");
	}
	if (_tmp2_) {
		monitor_index = 0;
	}
	_tmp5_ = self->priv->backgrounds;
	_tmp6_ = g_hash_table_lookup (_tmp5_, (gpointer) ((gintptr) monitor_index));
	_tmp7_ = _g_object_ref0 ((GalaBackground*) _tmp6_);
	background = _tmp7_;
	_tmp8_ = background;
	if (_tmp8_ == NULL) {
		MetaDisplay* _tmp9_;
		const gchar* _tmp10_;
		GalaBackground* _tmp11_;
		GalaBackground* _tmp12_;
		GHashTable* _tmp13_;
		GalaBackground* _tmp14_;
		GalaBackground* _tmp15_;
		_tmp9_ = self->priv->_display;
		_tmp10_ = filename;
		_tmp11_ = gala_background_new (_tmp9_, monitor_index, _tmp10_, self, (GDesktopBackgroundStyle) style);
		_g_object_unref0 (background);
		background = _tmp11_;
		_tmp12_ = background;
		g_signal_connect_object (_tmp12_, "changed", (GCallback) _gala_background_source_background_changed_gala_background_changed, self, 0);
		_tmp13_ = self->priv->backgrounds;
		_tmp14_ = background;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		g_hash_table_insert (_tmp13_, (gpointer) ((gintptr) monitor_index), _tmp15_);
	}
	result = background;
	_g_free0 (filename);
	return result;
}

static gchar*
gala_background_source_get_background_path (GalaBackgroundSource* self)
{
	GalaDrawingStyleManager* _tmp0_;
	GalaDrawingStyleManager* _tmp1_;
	GalaDrawingStyleManagerColorScheme _tmp2_;
	GalaDrawingStyleManagerColorScheme _tmp3_;
	gboolean _tmp4_;
	gchar* uri = NULL;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	gchar* path = NULL;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gala_drawing_style_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gala_drawing_style_manager_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		gchar* uri = NULL;
		GSettings* _tmp5_;
		gchar* _tmp6_;
		gchar* path = NULL;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp5_ = self->priv->_gnome_background_settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "picture-uri-dark");
		uri = _tmp6_;
		_tmp7_ = uri;
		_tmp8_ = g_file_new_for_uri (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		path = _tmp11_;
		_tmp12_ = path;
		if (g_file_test (_tmp12_, G_FILE_TEST_EXISTS)) {
			result = path;
			_g_free0 (uri);
			return result;
		}
		_g_free0 (path);
		_g_free0 (uri);
	}
	_tmp13_ = self->priv->_gnome_background_settings;
	_tmp14_ = g_settings_get_string (_tmp13_, "picture-uri");
	uri = _tmp14_;
	_tmp15_ = uri;
	_tmp16_ = g_file_new_for_uri (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_get_path (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp17_);
	path = _tmp19_;
	_tmp20_ = path;
	if (g_file_test (_tmp20_, G_FILE_TEST_EXISTS)) {
		result = path;
		_g_free0 (uri);
		return result;
	}
	result = uri;
	_g_free0 (path);
	return result;
}

static void
gala_background_source_background_changed (GalaBackgroundSource* self,
                                           GalaBackground* background)
{
	guint _tmp0_;
	GHashTable* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background != NULL);
	g_signal_parse_name ("changed", GALA_TYPE_BACKGROUND, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (background, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gala_background_source_background_changed_gala_background_changed, self);
	gala_background_destroy (background);
	_tmp1_ = self->priv->backgrounds;
	_tmp2_ = gala_background_get_monitor_index (background);
	_tmp3_ = _tmp2_;
	g_hash_table_remove (_tmp1_, (gpointer) ((gintptr) _tmp3_));
}

static void
_gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                gpointer self)
{
	gala_background_source_monitors_changed ((GalaBackgroundSource*) self);
}

static gboolean
__lambda27_ (GalaBackgroundSource* self,
             gint hash,
             GalaBackground* background)
{
	guint _tmp0_;
	gboolean result;
	g_return_val_if_fail (background != NULL, FALSE);
	g_signal_parse_name ("changed", GALA_TYPE_BACKGROUND, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (background, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gala_background_source_background_changed_gala_background_changed, self);
	gala_background_destroy (background);
	result = TRUE;
	return result;
}

static gboolean
___lambda27__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda27_ ((GalaBackgroundSource*) self, (gint) ((gintptr) key), (GalaBackground*) value);
	return result;
}

void
gala_background_source_destroy (GalaBackgroundSource* self)
{
	MetaMonitorManager* _tmp0_;
	guint _tmp1_;
	GHashTable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor_manager;
	g_signal_parse_name ("monitors-changed", meta_monitor_manager_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed, self);
	_g_object_unref0 (self->priv->monitor_manager);
	self->priv->monitor_manager = NULL;
	_tmp2_ = self->priv->backgrounds;
	g_hash_table_foreach_remove (_tmp2_, ___lambda27__ghr_func, self);
}

MetaDisplay*
gala_background_source_get_display (GalaBackgroundSource* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_background_source_set_display (GalaBackgroundSource* self,
                                    MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_source_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_source_properties[GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY]);
	}
}

GSettings*
gala_background_source_get_gnome_background_settings (GalaBackgroundSource* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnome_background_settings;
	result = _tmp0_;
	return result;
}

static void
gala_background_source_set_gnome_background_settings (GalaBackgroundSource* self,
                                                      GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_source_get_gnome_background_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gnome_background_settings);
		self->priv->_gnome_background_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_source_properties[GALA_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY]);
	}
}

 G_GNUC_INTERNAL gint
gala_background_source_get_use_count (GalaBackgroundSource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_use_count;
	return result;
}

 G_GNUC_INTERNAL void
gala_background_source_set_use_count (GalaBackgroundSource* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_source_get_use_count (self);
	if (old_value != value) {
		self->priv->_use_count = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_source_properties[GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY]);
	}
}

gboolean
gala_background_source_get_should_dim (GalaBackgroundSource* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GalaDrawingStyleManager* _tmp1_;
	GalaDrawingStyleManager* _tmp2_;
	GalaDrawingStyleManagerColorScheme _tmp3_;
	GalaDrawingStyleManagerColorScheme _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gala_drawing_style_manager_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_drawing_style_manager_get_prefers_color_scheme (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GSettings* _tmp6_;
		_tmp6_ = self->priv->gala_background_settings;
		_tmp0_ = g_settings_get_boolean (_tmp6_, "dim-wallpaper-in-dark-style");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_gala_background_source___lambda30_ (GalaBackgroundSource* self)
{
	g_signal_emit (self, gala_background_source_signals[GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL], 0);
}

static void
__gala_background_source___lambda30__g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	_gala_background_source___lambda30_ ((GalaBackgroundSource*) self);
}

static void
_gala_background_source___lambda31_ (GalaBackgroundSource* self)
{
	g_signal_emit (self, gala_background_source_signals[GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL], 0);
}

static void
__gala_background_source___lambda31__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_gala_background_source___lambda31_ ((GalaBackgroundSource*) self);
}

static void
_gala_background_source___lambda32_ (GalaBackgroundSource* self,
                                     const gchar* key)
{
	g_return_if_fail (key != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS))) {
					break;
				}
				_tmp2_ = GALA_BACKGROUND_SOURCE_OPTIONS[i];
				if (g_strcmp0 (key, _tmp2_) == 0) {
					guint new_hash = 0U;
					GSettings* _tmp3_;
					GVariant* _tmp4_;
					GVariant* _tmp5_;
					guint _tmp6_;
					guint* _tmp7_;
					gint _tmp7__length1;
					guint _tmp8_;
					_tmp3_ = self->priv->_gnome_background_settings;
					_tmp4_ = g_settings_get_value (_tmp3_, key);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_variant_hash (_tmp5_);
					_g_variant_unref0 (_tmp5_);
					new_hash = _tmp6_;
					_tmp7_ = self->priv->hash_cache;
					_tmp7__length1 = self->priv->hash_cache_length1;
					_tmp8_ = _tmp7_[i];
					if (_tmp8_ != new_hash) {
						guint* _tmp9_;
						gint _tmp9__length1;
						_tmp9_ = self->priv->hash_cache;
						_tmp9__length1 = self->priv->hash_cache_length1;
						_tmp9_[i] = new_hash;
						g_signal_emit (self, gala_background_source_signals[GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL], 0);
						break;
					}
				}
			}
		}
	}
}

static void
__gala_background_source___lambda32__g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	_gala_background_source___lambda32_ ((GalaBackgroundSource*) self, key);
}

static GObject *
gala_background_source_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackgroundSource * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	guint* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaContext* _tmp5_;
	MetaBackend* _tmp6_;
	MetaMonitorManager* _tmp7_;
	MetaMonitorManager* _tmp8_;
	MetaMonitorManager* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GalaDrawingStyleManager* _tmp12_;
	GalaDrawingStyleManager* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp23_;
	parent_class = G_OBJECT_CLASS (gala_background_source_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->backgrounds);
	self->priv->backgrounds = _tmp2_;
	_tmp3_ = g_new0 (guint, G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS));
	self->priv->hash_cache = (g_free (self->priv->hash_cache), NULL);
	self->priv->hash_cache = _tmp3_;
	self->priv->hash_cache_length1 = G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS);
	self->priv->_hash_cache_size_ = self->priv->hash_cache_length1;
	_tmp4_ = self->priv->_display;
	_tmp5_ = meta_display_get_context (_tmp4_);
	_tmp6_ = meta_context_get_backend (_tmp5_);
	_tmp7_ = meta_backend_get_monitor_manager (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->monitor_manager);
	self->priv->monitor_manager = _tmp8_;
	_tmp9_ = self->priv->monitor_manager;
	g_signal_connect_object (_tmp9_, "monitors-changed", (GCallback) _gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed, self, 0);
	_tmp10_ = g_settings_new ("io.elementary.desktop.background");
	_g_object_unref0 (self->priv->gala_background_settings);
	self->priv->gala_background_settings = _tmp10_;
	_tmp11_ = self->priv->gala_background_settings;
	g_signal_connect_object (_tmp11_, "changed::dim-wallpaper-in-dark-style", (GCallback) __gala_background_source___lambda30__g_settings_changed, self, 0);
	_tmp12_ = gala_drawing_style_manager_get_instance ();
	_tmp13_ = _tmp12_;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::prefers-color-scheme", (GCallback) __gala_background_source___lambda31__g_object_notify, self, 0);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = g_settings_new ("org.gnome.desktop.background");
	_tmp15_ = _tmp14_;
	gala_background_source_set_gnome_background_settings (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				guint* _tmp18_;
				gint _tmp18__length1;
				GSettings* _tmp19_;
				const gchar* _tmp20_;
				GVariant* _tmp21_;
				GVariant* _tmp22_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				if (!(i < G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS))) {
					break;
				}
				_tmp18_ = self->priv->hash_cache;
				_tmp18__length1 = self->priv->hash_cache_length1;
				_tmp19_ = self->priv->_gnome_background_settings;
				_tmp20_ = GALA_BACKGROUND_SOURCE_OPTIONS[i];
				_tmp21_ = g_settings_get_value (_tmp19_, _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp18_[i] = g_variant_hash (_tmp22_);
				_g_variant_unref0 (_tmp22_);
			}
		}
	}
	_tmp23_ = self->priv->_gnome_background_settings;
	g_signal_connect_object (_tmp23_, "changed", (GCallback) __gala_background_source___lambda32__g_settings_changed, self, 0);
	return obj;
}

static void
gala_background_source_class_init (GalaBackgroundSourceClass * klass,
                                   gpointer klass_data)
{
	gala_background_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundSource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_background_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_background_source_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_background_source_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY, gala_background_source_properties[GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY, gala_background_source_properties[GALA_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY] = g_param_spec_object ("gnome-background-settings", "gnome-background-settings", "gnome-background-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY, gala_background_source_properties[GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY] = g_param_spec_int ("use-count", "use-count", "use-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_SOURCE_SHOULD_DIM_PROPERTY, gala_background_source_properties[GALA_BACKGROUND_SOURCE_SHOULD_DIM_PROPERTY] = g_param_spec_boolean ("should-dim", "should-dim", "should-dim", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_background_source_signals[GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL] = g_signal_new ("changed", GALA_TYPE_BACKGROUND_SOURCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_background_source_instance_init (GalaBackgroundSource * self,
                                      gpointer klass)
{
	self->priv = gala_background_source_get_instance_private (self);
	self->priv->_use_count = 0;
}

static void
gala_background_source_finalize (GObject * obj)
{
	GalaBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_gnome_background_settings);
	_g_hash_table_unref0 (self->priv->backgrounds);
	self->priv->hash_cache = (g_free (self->priv->hash_cache), NULL);
	_g_object_unref0 (self->priv->monitor_manager);
	_g_object_unref0 (self->priv->gala_background_settings);
	G_OBJECT_CLASS (gala_background_source_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_background_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundSource), 0, (GInstanceInitFunc) gala_background_source_instance_init, NULL };
	GType gala_background_source_type_id;
	gala_background_source_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaBackgroundSource", &g_define_type_info, 0);
	GalaBackgroundSource_private_offset = g_type_add_instance_private (gala_background_source_type_id, sizeof (GalaBackgroundSourcePrivate));
	return gala_background_source_type_id;
}

GType
gala_background_source_get_type (void)
{
	static gsize gala_background_source_type_id__once = 0;
	if (g_once_init_enter (&gala_background_source_type_id__once)) {
		GType gala_background_source_type_id;
		gala_background_source_type_id = gala_background_source_get_type_once ();
		g_once_init_leave (&gala_background_source_type_id__once, gala_background_source_type_id);
	}
	return gala_background_source_type_id__once;
}

static void
_vala_gala_background_source_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	switch (property_id) {
		case GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_background_source_get_display (self));
		break;
		case GALA_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY:
		g_value_set_object (value, gala_background_source_get_gnome_background_settings (self));
		break;
		case GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY:
		g_value_set_int (value, gala_background_source_get_use_count (self));
		break;
		case GALA_BACKGROUND_SOURCE_SHOULD_DIM_PROPERTY:
		g_value_set_boolean (value, gala_background_source_get_should_dim (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_background_source_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	switch (property_id) {
		case GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY:
		gala_background_source_set_display (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY:
		gala_background_source_set_gnome_background_settings (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY:
		gala_background_source_set_use_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

