/* PluginManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PluginManager.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <glib.h>
#include <X11/Xlib.h>
#include <stdlib.h>
#include <string.h>
#include "gala.h"
#include <gio/gio.h>
#include <gee.h>
#include <gmodule.h>
#include "config.h"
#include <mtk/mtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_PLUGIN_MANAGER (gala_plugin_manager_get_type ())
#define GALA_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManager))
#define GALA_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))
#define GALA_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))

typedef struct _GalaPluginManager GalaPluginManager;
typedef struct _GalaPluginManagerClass GalaPluginManagerClass;
typedef struct _GalaPluginManagerPrivate GalaPluginManagerPrivate;
enum  {
	GALA_PLUGIN_MANAGER_0_PROPERTY,
	GALA_PLUGIN_MANAGER_INITIALIZED_PROPERTY,
	GALA_PLUGIN_MANAGER_WINDOW_SWITCHER_PROVIDER_PROPERTY,
	GALA_PLUGIN_MANAGER_WINDOW_OVERVIEW_PROVIDER_PROPERTY,
	GALA_PLUGIN_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_plugin_manager_properties[GALA_PLUGIN_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef void (*GalaPluginManagerRegisterPluginFunction) (GalaPluginInfo* result, gpointer user_data);
#define __vala_GalaPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GalaPluginInfo_free (var), NULL)))
typedef struct _Block8Data Block8Data;
enum  {
	GALA_PLUGIN_MANAGER_REGIONS_CHANGED_SIGNAL,
	GALA_PLUGIN_MANAGER_NUM_SIGNALS
};
static guint gala_plugin_manager_signals[GALA_PLUGIN_MANAGER_NUM_SIGNALS] = {0};

struct _GalaPluginManager {
	GObject parent_instance;
	GalaPluginManagerPrivate * priv;
};

struct _GalaPluginManagerClass {
	GObjectClass parent_class;
};

struct _GalaPluginManagerPrivate {
	gboolean _initialized;
	XRectangle* _regions;
	gint _regions_length1;
	gint __regions_size_;
	gchar* _window_switcher_provider;
	gchar* _window_overview_provider;
	GHashTable* plugins;
	GFile* plugin_dir;
	GalaWindowManager* wm;
	GeeLinkedList* load_later_plugins;
};

struct _Block8Data {
	int _ref_count_;
	GalaPluginManager* self;
	XRectangle* regions;
	gint regions_length1;
	gint _regions_size_;
};

static gint GalaPluginManager_private_offset;
static gpointer gala_plugin_manager_parent_class = NULL;
static GalaPluginManager* gala_plugin_manager_instance;
static GalaPluginManager* gala_plugin_manager_instance = NULL;

VALA_EXTERN GType gala_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPluginManager, g_object_unref)
VALA_EXTERN GalaPluginManager* gala_plugin_manager_get_default (void);
static GalaPluginManager* gala_plugin_manager_new (void);
static GalaPluginManager* gala_plugin_manager_construct (GType object_type);
VALA_EXTERN XRectangle* gala_plugin_manager_get_regions (GalaPluginManager* self,
                                             gint* result_length1);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static GalaPluginInfo* _gala_plugin_info_dup (GalaPluginInfo* self);
static void _vala_GalaPluginInfo_free (GalaPluginInfo* self);
static gboolean gala_plugin_manager_load_module (GalaPluginManager* self,
                                          const gchar* plugin_name);
static void ___lambda14_ (GalaPluginManager* self,
                   GFile* file,
                   GFile* other_file,
                   GFileMonitorEvent type);
static void ____lambda14__g_file_monitor_changed (GFileMonitor* _sender,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type,
                                           gpointer self);
static gboolean gala_plugin_manager_check_provides (GalaPluginManager* self,
                                             const gchar* name,
                                             GalaPluginFunction provides);
VALA_EXTERN gboolean gala_plugin_manager_get_initialized (GalaPluginManager* self);
static void gala_plugin_manager_load_plugin_class (GalaPluginManager* self,
                                            GalaPluginInfo* info);
static void gala_plugin_manager_initialize_plugin (GalaPluginManager* self,
                                            const gchar* plugin_name,
                                            GalaPlugin* plugin);
static void gala_plugin_manager_recalculate_regions (GalaPluginManager* self);
static void _gala_plugin_manager_recalculate_regions_gala_plugin_region_changed (GalaPlugin* _sender,
                                                                          gpointer self);
VALA_EXTERN const gchar* gala_plugin_manager_get_window_overview_provider (GalaPluginManager* self);
static void gala_plugin_manager_set_window_overview_provider (GalaPluginManager* self,
                                                       const gchar* value);
VALA_EXTERN const gchar* gala_plugin_manager_get_window_switcher_provider (GalaPluginManager* self);
static void gala_plugin_manager_set_window_switcher_provider (GalaPluginManager* self,
                                                       const gchar* value);
VALA_EXTERN void gala_plugin_manager_initialize (GalaPluginManager* self,
                                     GalaWindowManager* _wm);
static void _gala_plugin_manager_initialize_plugin_gh_func (gconstpointer key,
                                                     gconstpointer value,
                                                     gpointer self);
static void gala_plugin_manager_set_initialized (GalaPluginManager* self,
                                          gboolean value);
VALA_EXTERN void gala_plugin_manager_load_waiting_plugins (GalaPluginManager* self);
VALA_EXTERN GalaPlugin* gala_plugin_manager_get_plugin (GalaPluginManager* self,
                                            const gchar* id);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda13_ (Block8Data* _data8_,
                  const gchar* name,
                  GalaPlugin* plugin);
static void _vala_array_add9 (XRectangle* * array,
                       gint* length,
                       gint* size,
                       XRectangle value);
static void ___lambda13__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static XRectangle* _vala_array_dup1 (XRectangle* self,
                              gssize length);
static void gala_plugin_manager_finalize (GObject * obj);
static GType gala_plugin_manager_get_type_once (void);
static void _vala_gala_plugin_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gala_plugin_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
gala_plugin_manager_get_instance_private (GalaPluginManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPluginManager_private_offset);
}

GalaPluginManager*
gala_plugin_manager_get_default (void)
{
	GalaPluginManager* _tmp0_;
	GalaPluginManager* _tmp2_;
	GalaPluginManager* result;
	_tmp0_ = gala_plugin_manager_instance;
	if (_tmp0_ == NULL) {
		GalaPluginManager* _tmp1_;
		_tmp1_ = gala_plugin_manager_new ();
		_g_object_unref0 (gala_plugin_manager_instance);
		gala_plugin_manager_instance = _tmp1_;
	}
	_tmp2_ = gala_plugin_manager_instance;
	result = _tmp2_;
	return result;
}

XRectangle*
gala_plugin_manager_get_regions (GalaPluginManager* self,
                                 gint* result_length1)
{
	XRectangle* _tmp0_;
	gint _tmp0__length1;
	XRectangle* _tmp1_;
	gint _tmp1__length1;
	XRectangle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_regions;
	_tmp0__length1 = self->priv->_regions_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GalaPluginInfo*
_gala_plugin_info_dup (GalaPluginInfo* self)
{
	GalaPluginInfo* dup;
	dup = g_new0 (GalaPluginInfo, 1);
	gala_plugin_info_copy (self, dup);
	return dup;
}

static void
_vala_GalaPluginInfo_free (GalaPluginInfo* self)
{
	gala_plugin_info_destroy (self);
	g_free (self);
}

static void
___lambda14_ (GalaPluginManager* self,
              GFile* file,
              GFile* other_file,
              GFileMonitorEvent type)
{
	g_return_if_fail (file != NULL);
	if (type == G_FILE_MONITOR_EVENT_CREATED) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_file_get_basename (file);
		_tmp1_ = _tmp0_;
		gala_plugin_manager_load_module (self, _tmp1_);
		_g_free0 (_tmp1_);
	}
}

static void
____lambda14__g_file_monitor_changed (GFileMonitor* _sender,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event_type,
                                      gpointer self)
{
	___lambda14_ ((GalaPluginManager*) self, file, other_file, event_type);
}

static GalaPluginManager*
gala_plugin_manager_construct (GType object_type)
{
	GalaPluginManager * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GeeLinkedList* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = (GalaPluginManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->plugins);
	self->priv->plugins = _tmp2_;
	_tmp3_ = gee_linked_list_new (GALA_TYPE_PLUGIN_INFO, (GBoxedCopyFunc) _gala_plugin_info_dup, (GDestroyNotify) _vala_GalaPluginInfo_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->load_later_plugins);
	self->priv->load_later_plugins = _tmp3_;
	if (!g_module_supported ()) {
		g_warning ("PluginManager.vala:42: Modules are not supported on this platform");
		return self;
	}
	_tmp4_ = g_file_new_for_path (PLUGINDIR);
	_g_object_unref0 (self->priv->plugin_dir);
	self->priv->plugin_dir = _tmp4_;
	_tmp5_ = self->priv->plugin_dir;
	if (!g_file_query_exists (_tmp5_, NULL)) {
		return self;
	}
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp6_;
		GFileEnumerator* _tmp7_;
		GFileInfo* info = NULL;
		_tmp6_ = self->priv->plugin_dir;
		_tmp7_ = g_file_enumerate_children (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error0_);
		enumerator = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp8_ = NULL;
			GFileEnumerator* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			GFileInfo* _tmp13_;
			const gchar* _tmp14_;
			_tmp9_ = enumerator;
			_tmp10_ = g_file_enumerator_next_file (_tmp9_, NULL, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_object_unref0 (info);
			info = _tmp11_;
			_tmp12_ = info;
			if (!(_tmp12_ != NULL)) {
				_g_object_unref0 (_tmp8_);
				break;
			}
			_tmp13_ = info;
			_tmp14_ = g_file_info_get_content_type (_tmp13_);
			if (g_strcmp0 (_tmp14_, "application/x-sharedlib") == 0) {
				GFileInfo* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = info;
				_tmp16_ = g_file_info_get_name (_tmp15_);
				gala_plugin_manager_load_module (self, _tmp16_);
			}
			_g_object_unref0 (_tmp8_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("PluginManager.vala:59: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GFileMonitor* _tmp19_ = NULL;
		GFile* _tmp20_;
		GFileMonitor* _tmp21_;
		_tmp20_ = self->priv->plugin_dir;
		_tmp21_ = g_file_monitor_directory (_tmp20_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp19_ = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		g_signal_connect_object (_tmp19_, "changed", (GCallback) ____lambda14__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp19_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("PluginManager.vala:69: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

static GalaPluginManager*
gala_plugin_manager_new (void)
{
	return gala_plugin_manager_construct (GALA_TYPE_PLUGIN_MANAGER);
}

static gboolean
gala_plugin_manager_load_module (GalaPluginManager* self,
                                 const gchar* plugin_name)
{
	gchar* path = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GModule* module = NULL;
	const gchar* _tmp5_;
	GModule* _tmp6_;
	GModule* _tmp7_;
	void* function = NULL;
	GModule* _tmp9_;
	void* _tmp10_ = NULL;
	void* _tmp11_;
	GalaPluginManagerRegisterPluginFunction _register_ = NULL;
	void* _tmp12_;
	gpointer _register__target;
	GalaPluginInfo info = {0};
	GalaPluginManagerRegisterPluginFunction _tmp13_;
	gpointer _tmp13__target;
	GalaPluginInfo _tmp14_ = {0};
	GalaPluginInfo _tmp15_;
	GalaPluginInfo _tmp16_;
	const gchar* _tmp17_;
	GalaPluginInfo _tmp18_;
	gchar* _tmp19_;
	GModule* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GalaPluginInfo _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (plugin_name != NULL, FALSE);
	_tmp0_ = self->priv->plugin_dir;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_module_build_path (_tmp2_, plugin_name);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	path = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = g_module_open (_tmp5_, G_MODULE_BIND_LOCAL);
	module = _tmp6_;
	_tmp7_ = module;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		_tmp8_ = g_module_error ();
		g_warning ("PluginManager.vala:77: %s", _tmp8_);
		result = FALSE;
		_g_module_close0 (module);
		_g_free0 (path);
		return result;
	}
	_tmp9_ = module;
	g_module_symbol (_tmp9_, "register_plugin", &_tmp10_);
	function = _tmp10_;
	_tmp11_ = function;
	if (_tmp11_ == NULL) {
		g_warning ("PluginManager.vala:84: %s failed to register: register_plugin() functi" \
"on not found", plugin_name);
		result = FALSE;
		_g_module_close0 (module);
		_g_free0 (path);
		return result;
	}
	_tmp12_ = function;
	_register_ = (GalaPluginManagerRegisterPluginFunction) _tmp12_;
	_register__target = NULL;
	_tmp13_ = _register_;
	_tmp13__target = _register__target;
	_tmp13_ (&_tmp14_, _tmp13__target);
	info = _tmp14_;
	_tmp15_ = info;
	if (g_type_is_a (_tmp15_.plugin_type, GALA_TYPE_PLUGIN) == FALSE) {
		g_warning ("PluginManager.vala:91: %s does not return a class of type Plugin", plugin_name);
		result = FALSE;
		gala_plugin_info_destroy (&info);
		_g_module_close0 (module);
		_g_free0 (path);
		return result;
	}
	_tmp16_ = info;
	_tmp17_ = _tmp16_.name;
	_tmp18_ = info;
	if (!gala_plugin_manager_check_provides (self, _tmp17_, _tmp18_.provides)) {
		result = FALSE;
		gala_plugin_info_destroy (&info);
		_g_module_close0 (module);
		_g_free0 (path);
		return result;
	}
	_tmp19_ = g_strdup (plugin_name);
	_g_free0 (info.module_name);
	info.module_name = _tmp19_;
	_tmp20_ = module;
	g_module_make_resident (_tmp20_);
	_tmp22_ = info;
	if (_tmp22_.load_priority == GALA_LOAD_PRIORITY_DEFERRED) {
		gboolean _tmp23_;
		_tmp23_ = self->priv->_initialized;
		_tmp21_ = !_tmp23_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GeeLinkedList* _tmp24_;
		GalaPluginInfo _tmp25_;
		_tmp24_ = self->priv->load_later_plugins;
		_tmp25_ = info;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, &_tmp25_);
	} else {
		GalaPluginInfo _tmp26_;
		_tmp26_ = info;
		gala_plugin_manager_load_plugin_class (self, &_tmp26_);
	}
	result = TRUE;
	gala_plugin_info_destroy (&info);
	_g_module_close0 (module);
	_g_free0 (path);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_plugin_manager_load_plugin_class (GalaPluginManager* self,
                                       GalaPluginInfo* info)
{
	GalaPlugin* plugin = NULL;
	GalaPluginInfo _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GHashTable* _tmp3_;
	GalaPluginInfo _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GalaPlugin* _tmp7_;
	GalaPlugin* _tmp8_;
	GalaPluginInfo _tmp9_;
	const gchar* _tmp10_;
	GalaPluginInfo _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = *info;
	_tmp1_ = g_object_new (_tmp0_.plugin_type, NULL);
	_tmp2_ = G_IS_INITIALLY_UNOWNED (_tmp1_) ? g_object_ref_sink (_tmp1_) : _tmp1_;
	plugin = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_PLUGIN, GalaPlugin);
	_tmp3_ = self->priv->plugins;
	_tmp4_ = *info;
	_tmp5_ = _tmp4_.module_name;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = plugin;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	g_hash_table_insert (_tmp3_, _tmp6_, _tmp8_);
	_tmp9_ = *info;
	_tmp10_ = _tmp9_.name;
	_tmp11_ = *info;
	_tmp12_ = _tmp11_.module_name;
	g_debug ("PluginManager.vala:115: Loaded plugin %s (%s)", _tmp10_, _tmp12_);
	_tmp13_ = self->priv->_initialized;
	if (_tmp13_) {
		GalaPluginInfo _tmp14_;
		const gchar* _tmp15_;
		GalaPlugin* _tmp16_;
		_tmp14_ = *info;
		_tmp15_ = _tmp14_.module_name;
		_tmp16_ = plugin;
		gala_plugin_manager_initialize_plugin (self, _tmp15_, _tmp16_);
		gala_plugin_manager_recalculate_regions (self);
	}
	_g_object_unref0 (plugin);
}

static void
_gala_plugin_manager_recalculate_regions_gala_plugin_region_changed (GalaPlugin* _sender,
                                                                     gpointer self)
{
	gala_plugin_manager_recalculate_regions ((GalaPluginManager*) self);
}

static void
gala_plugin_manager_initialize_plugin (GalaPluginManager* self,
                                       const gchar* plugin_name,
                                       GalaPlugin* plugin)
{
	GalaWindowManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = self->priv->wm;
	gala_plugin_initialize (plugin, _tmp0_);
	g_signal_connect_object (plugin, "region-changed", (GCallback) _gala_plugin_manager_recalculate_regions_gala_plugin_region_changed, self, 0);
}

static gboolean
gala_plugin_manager_check_provides (GalaPluginManager* self,
                                    const gchar* name,
                                    GalaPluginFunction provides)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_strdup ("Plugins %s and %s both provide %s functionality, using first one only");
	message = _tmp0_;
	switch (provides) {
		case GALA_PLUGIN_FUNCTION_WINDOW_OVERVIEW:
		{
			const gchar* _tmp1_;
			_tmp1_ = self->priv->_window_overview_provider;
			if (_tmp1_ != NULL) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = message;
				_tmp3_ = self->priv->_window_overview_provider;
				g_warning (_tmp2_, _tmp3_, name, "window overview");
				result = FALSE;
				_g_free0 (message);
				return result;
			}
			gala_plugin_manager_set_window_overview_provider (self, name);
			result = TRUE;
			_g_free0 (message);
			return result;
		}
		case GALA_PLUGIN_FUNCTION_WINDOW_SWITCHER:
		{
			const gchar* _tmp4_;
			_tmp4_ = self->priv->_window_switcher_provider;
			if (_tmp4_ != NULL) {
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = message;
				_tmp6_ = self->priv->_window_switcher_provider;
				g_warning (_tmp5_, _tmp6_, name, "window switcher");
				result = FALSE;
				_g_free0 (message);
				return result;
			}
			gala_plugin_manager_set_window_switcher_provider (self, name);
			result = TRUE;
			_g_free0 (message);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	_g_free0 (message);
	return result;
}

static void
_gala_plugin_manager_initialize_plugin_gh_func (gconstpointer key,
                                                gconstpointer value,
                                                gpointer self)
{
	gala_plugin_manager_initialize_plugin ((GalaPluginManager*) self, (const gchar*) key, (GalaPlugin*) value);
}

void
gala_plugin_manager_initialize (GalaPluginManager* self,
                                GalaWindowManager* _wm)
{
	GalaWindowManager* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_wm != NULL);
	_tmp0_ = _g_object_ref0 (_wm);
	_g_object_unref0 (self->priv->wm);
	self->priv->wm = _tmp0_;
	_tmp1_ = self->priv->plugins;
	g_hash_table_foreach (_tmp1_, _gala_plugin_manager_initialize_plugin_gh_func, self);
	gala_plugin_manager_recalculate_regions (self);
	gala_plugin_manager_set_initialized (self, TRUE);
}

void
gala_plugin_manager_load_waiting_plugins (GalaPluginManager* self)
{
	GeeLinkedList* _tmp10_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _info_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _info_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _info_index = 0;
		_tmp0_ = self->priv->load_later_plugins;
		_info_list = _tmp0_;
		_tmp1_ = _info_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_info_size = _tmp3_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GalaPluginInfo* info = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			GalaPluginInfo* _tmp8_;
			GalaPluginInfo _tmp9_;
			_info_index = _info_index + 1;
			_tmp4_ = _info_index;
			_tmp5_ = _info_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _info_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _info_index);
			info = (GalaPluginInfo*) _tmp7_;
			_tmp8_ = info;
			_tmp9_ = *_tmp8_;
			gala_plugin_manager_load_plugin_class (self, &_tmp9_);
			__vala_GalaPluginInfo_free0 (info);
		}
	}
	_tmp10_ = self->priv->load_later_plugins;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
}

GalaPlugin*
gala_plugin_manager_get_plugin (GalaPluginManager* self,
                                const gchar* id)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GalaPlugin* _tmp2_;
	GalaPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->plugins;
	_tmp1_ = g_hash_table_lookup (_tmp0_, id);
	_tmp2_ = _g_object_ref0 ((GalaPlugin*) _tmp1_);
	result = _tmp2_;
	return result;
}

/**
     * Iterate over all plugins and grab their regions, update the regions
     * array accordingly and emit the regions_changed signal.
     */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GalaPluginManager* self;
		self = _data8_->self;
		_data8_->regions = (g_free (_data8_->regions), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_vala_array_add9 (XRectangle* * array,
                  gint* length,
                  gint* size,
                  XRectangle value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XRectangle, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
__lambda13_ (Block8Data* _data8_,
             const gchar* name,
             GalaPlugin* plugin)
{
	GalaPluginManager* self;
	gint _tmp0_ = 0;
	MtkRectangle* _tmp1_;
	self = _data8_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp1_ = gala_plugin_get_region (plugin, &_tmp0_);
	{
		MtkRectangle* region_collection = NULL;
		gint region_collection_length1 = 0;
		gint _region_collection_size_ = 0;
		gint region_it = 0;
		region_collection = _tmp1_;
		region_collection_length1 = _tmp0_;
		for (region_it = 0; region_it < region_collection_length1; region_it = region_it + 1) {
			MtkRectangle region = {0};
			region = region_collection[region_it];
			{
				XRectangle rect = {0};
				MtkRectangle _tmp2_;
				MtkRectangle _tmp3_;
				MtkRectangle _tmp4_;
				MtkRectangle _tmp5_;
				XRectangle _tmp6_ = {0};
				_tmp2_ = region;
				_tmp3_ = region;
				_tmp4_ = region;
				_tmp5_ = region;
				_tmp6_.x = (gshort) _tmp2_.x;
				_tmp6_.y = (gshort) _tmp3_.y;
				_tmp6_.width = (gushort) _tmp4_.width;
				_tmp6_.height = (gushort) _tmp5_.height;
				rect = _tmp6_;
				_vala_array_add9 (&_data8_->regions, &_data8_->regions_length1, &_data8_->_regions_size_, rect);
			}
		}
	}
}

static void
___lambda13__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda13_ (self, (const gchar*) key, (GalaPlugin*) value);
}

static XRectangle*
_vala_array_dup1 (XRectangle* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (XRectangle));
	}
	return NULL;
}

static void
gala_plugin_manager_recalculate_regions (GalaPluginManager* self)
{
	Block8Data* _data8_;
	XRectangle* _tmp0_;
	GHashTable* _tmp1_;
	XRectangle* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_new0 (XRectangle, 0);
	_data8_->regions = _tmp0_;
	_data8_->regions_length1 = 0;
	_data8_->_regions_size_ = _data8_->regions_length1;
	_tmp1_ = self->priv->plugins;
	g_hash_table_foreach (_tmp1_, ___lambda13__gh_func, _data8_);
	_tmp2_ = (_data8_->regions != NULL) ? _vala_array_dup1 (_data8_->regions, _data8_->regions_length1) : _data8_->regions;
	_tmp2__length1 = _data8_->regions_length1;
	self->priv->_regions = (g_free (self->priv->_regions), NULL);
	self->priv->_regions = _tmp2_;
	self->priv->_regions_length1 = _tmp2__length1;
	self->priv->__regions_size_ = self->priv->_regions_length1;
	g_signal_emit (self, gala_plugin_manager_signals[GALA_PLUGIN_MANAGER_REGIONS_CHANGED_SIGNAL], 0);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

gboolean
gala_plugin_manager_get_initialized (GalaPluginManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_initialized;
	return result;
}

static void
gala_plugin_manager_set_initialized (GalaPluginManager* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugin_manager_get_initialized (self);
	if (old_value != value) {
		self->priv->_initialized = value;
		g_object_notify_by_pspec ((GObject *) self, gala_plugin_manager_properties[GALA_PLUGIN_MANAGER_INITIALIZED_PROPERTY]);
	}
}

const gchar*
gala_plugin_manager_get_window_switcher_provider (GalaPluginManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_switcher_provider;
	result = _tmp0_;
	return result;
}

static void
gala_plugin_manager_set_window_switcher_provider (GalaPluginManager* self,
                                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugin_manager_get_window_switcher_provider (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_window_switcher_provider);
		self->priv->_window_switcher_provider = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugin_manager_properties[GALA_PLUGIN_MANAGER_WINDOW_SWITCHER_PROVIDER_PROPERTY]);
	}
}

const gchar*
gala_plugin_manager_get_window_overview_provider (GalaPluginManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_overview_provider;
	result = _tmp0_;
	return result;
}

static void
gala_plugin_manager_set_window_overview_provider (GalaPluginManager* self,
                                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugin_manager_get_window_overview_provider (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_window_overview_provider);
		self->priv->_window_overview_provider = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugin_manager_properties[GALA_PLUGIN_MANAGER_WINDOW_OVERVIEW_PROVIDER_PROPERTY]);
	}
}

static void
gala_plugin_manager_class_init (GalaPluginManagerClass * klass,
                                gpointer klass_data)
{
	gala_plugin_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPluginManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_plugin_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_plugin_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_plugin_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGIN_MANAGER_INITIALIZED_PROPERTY, gala_plugin_manager_properties[GALA_PLUGIN_MANAGER_INITIALIZED_PROPERTY] = g_param_spec_boolean ("initialized", "initialized", "initialized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGIN_MANAGER_WINDOW_SWITCHER_PROVIDER_PROPERTY, gala_plugin_manager_properties[GALA_PLUGIN_MANAGER_WINDOW_SWITCHER_PROVIDER_PROPERTY] = g_param_spec_string ("window-switcher-provider", "window-switcher-provider", "window-switcher-provider", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGIN_MANAGER_WINDOW_OVERVIEW_PROVIDER_PROPERTY, gala_plugin_manager_properties[GALA_PLUGIN_MANAGER_WINDOW_OVERVIEW_PROVIDER_PROPERTY] = g_param_spec_string ("window-overview-provider", "window-overview-provider", "window-overview-provider", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_plugin_manager_signals[GALA_PLUGIN_MANAGER_REGIONS_CHANGED_SIGNAL] = g_signal_new ("regions-changed", GALA_TYPE_PLUGIN_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_plugin_manager_instance_init (GalaPluginManager * self,
                                   gpointer klass)
{
	XRectangle* _tmp0_;
	self->priv = gala_plugin_manager_get_instance_private (self);
	self->priv->_initialized = FALSE;
	_tmp0_ = g_new0 (XRectangle, 0);
	self->priv->_regions = _tmp0_;
	self->priv->_regions_length1 = 0;
	self->priv->__regions_size_ = self->priv->_regions_length1;
	self->priv->_window_switcher_provider = NULL;
	self->priv->_window_overview_provider = NULL;
	self->priv->wm = NULL;
}

static void
gala_plugin_manager_finalize (GObject * obj)
{
	GalaPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PLUGIN_MANAGER, GalaPluginManager);
	self->priv->_regions = (g_free (self->priv->_regions), NULL);
	_g_free0 (self->priv->_window_switcher_provider);
	_g_free0 (self->priv->_window_overview_provider);
	_g_hash_table_unref0 (self->priv->plugins);
	_g_object_unref0 (self->priv->plugin_dir);
	_g_object_unref0 (self->priv->wm);
	_g_object_unref0 (self->priv->load_later_plugins);
	G_OBJECT_CLASS (gala_plugin_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_plugin_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPluginManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_plugin_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPluginManager), 0, (GInstanceInitFunc) gala_plugin_manager_instance_init, NULL };
	GType gala_plugin_manager_type_id;
	gala_plugin_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaPluginManager", &g_define_type_info, 0);
	GalaPluginManager_private_offset = g_type_add_instance_private (gala_plugin_manager_type_id, sizeof (GalaPluginManagerPrivate));
	return gala_plugin_manager_type_id;
}

GType
gala_plugin_manager_get_type (void)
{
	static gsize gala_plugin_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_plugin_manager_type_id__once)) {
		GType gala_plugin_manager_type_id;
		gala_plugin_manager_type_id = gala_plugin_manager_get_type_once ();
		g_once_init_leave (&gala_plugin_manager_type_id__once, gala_plugin_manager_type_id);
	}
	return gala_plugin_manager_type_id__once;
}

static void
_vala_gala_plugin_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GalaPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PLUGIN_MANAGER, GalaPluginManager);
	switch (property_id) {
		case GALA_PLUGIN_MANAGER_INITIALIZED_PROPERTY:
		g_value_set_boolean (value, gala_plugin_manager_get_initialized (self));
		break;
		case GALA_PLUGIN_MANAGER_WINDOW_SWITCHER_PROVIDER_PROPERTY:
		g_value_set_string (value, gala_plugin_manager_get_window_switcher_provider (self));
		break;
		case GALA_PLUGIN_MANAGER_WINDOW_OVERVIEW_PROVIDER_PROPERTY:
		g_value_set_string (value, gala_plugin_manager_get_window_overview_provider (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_plugin_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GalaPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PLUGIN_MANAGER, GalaPluginManager);
	switch (property_id) {
		case GALA_PLUGIN_MANAGER_INITIALIZED_PROPERTY:
		gala_plugin_manager_set_initialized (self, g_value_get_boolean (value));
		break;
		case GALA_PLUGIN_MANAGER_WINDOW_SWITCHER_PROVIDER_PROPERTY:
		gala_plugin_manager_set_window_switcher_provider (self, g_value_get_string (value));
		break;
		case GALA_PLUGIN_MANAGER_WINDOW_OVERVIEW_PROVIDER_PROPERTY:
		gala_plugin_manager_set_window_overview_provider (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

