/* ManagedClient.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ManagedClient.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/display.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <meta/meta-wayland-client.h>
#include <gio/gio.h>
#include <meta/meta-context.h>
#include <meta/window.h>
#include <meta/util.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_MANAGED_CLIENT (gala_managed_client_get_type ())
#define GALA_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MANAGED_CLIENT, GalaManagedClient))
#define GALA_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MANAGED_CLIENT, GalaManagedClientClass))
#define GALA_IS_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MANAGED_CLIENT))
#define GALA_IS_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MANAGED_CLIENT))
#define GALA_MANAGED_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MANAGED_CLIENT, GalaManagedClientClass))

typedef struct _GalaManagedClient GalaManagedClient;
typedef struct _GalaManagedClientClass GalaManagedClientClass;
typedef struct _GalaManagedClientPrivate GalaManagedClientPrivate;
enum  {
	GALA_MANAGED_CLIENT_0_PROPERTY,
	GALA_MANAGED_CLIENT_DISPLAY_PROPERTY,
	GALA_MANAGED_CLIENT_ARGS_PROPERTY,
	GALA_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY,
	GALA_MANAGED_CLIENT_NUM_PROPERTIES
};
static GParamSpec* gala_managed_client_properties[GALA_MANAGED_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaManagedClientStartWaylandData GalaManagedClientStartWaylandData;
typedef struct _GalaManagedClientStartXData GalaManagedClientStartXData;
typedef struct _Block55Data Block55Data;
enum  {
	GALA_MANAGED_CLIENT_WINDOW_CREATED_SIGNAL,
	GALA_MANAGED_CLIENT_NUM_SIGNALS
};
static guint gala_managed_client_signals[GALA_MANAGED_CLIENT_NUM_SIGNALS] = {0};

struct _GalaManagedClient {
	GObject parent_instance;
	GalaManagedClientPrivate * priv;
};

struct _GalaManagedClientClass {
	GObjectClass parent_class;
};

struct _GalaManagedClientPrivate {
	MetaDisplay* _display;
	gchar** _args;
	gint _args_length1;
	gint __args_size_;
	MetaWaylandClient* _wayland_client;
	GSubprocess* subprocess;
};

struct _GalaManagedClientStartWaylandData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaManagedClient* self;
	GSubprocessLauncher* subprocess_launcher;
	GSubprocessLauncher* _tmp0_;
	MetaWaylandClient* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaContext* _tmp3_;
	GSubprocessLauncher* _tmp4_;
	MetaWaylandClient* _tmp5_;
	GSubprocess* _tmp6_;
	MetaWaylandClient* _tmp7_;
	MetaDisplay* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GSubprocess* _tmp12_;
	GSubprocess* _tmp13_;
	GSubprocess* _tmp14_;
	GError* e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _GalaManagedClientStartXData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaManagedClient* self;
	GSubprocess* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSubprocess* _tmp4_;
	GSubprocess* _tmp5_;
	GSubprocess* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_;
};

struct _Block55Data {
	int _ref_count_;
	GalaManagedClient* self;
	MetaWindow* window;
};

static gint GalaManagedClient_private_offset;
static gpointer gala_managed_client_parent_class = NULL;

VALA_EXTERN GType gala_managed_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaManagedClient, g_object_unref)
VALA_EXTERN GalaManagedClient* gala_managed_client_new (MetaDisplay* display,
                                            gchar** args,
                                            gint args_length1);
VALA_EXTERN GalaManagedClient* gala_managed_client_construct (GType object_type,
                                                  MetaDisplay* display,
                                                  gchar** args,
                                                  gint args_length1);
static void gala_managed_client_start_wayland_data_free (gpointer _data);
static void gala_managed_client_start_wayland (GalaManagedClient* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void gala_managed_client_start_wayland_finish (GalaManagedClient* self,
                                               GAsyncResult* _res_);
static gboolean gala_managed_client_start_wayland_co (GalaManagedClientStartWaylandData* _data_);
VALA_EXTERN MetaDisplay* gala_managed_client_get_display (GalaManagedClient* self);
static void gala_managed_client_set_wayland_client (GalaManagedClient* self,
                                             MetaWaylandClient* value);
VALA_EXTERN MetaWaylandClient* gala_managed_client_get_wayland_client (GalaManagedClient* self);
VALA_EXTERN gchar** gala_managed_client_get_args (GalaManagedClient* self,
                                      gint* result_length1);
static void gala_managed_client_start_wayland_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static gboolean ___lambda38_ (GalaManagedClient* self);
static gboolean ____lambda38__gsource_func (gpointer self);
static void gala_managed_client_start_x_data_free (gpointer _data);
static void gala_managed_client_start_x (GalaManagedClient* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void gala_managed_client_start_x_finish (GalaManagedClient* self,
                                         GAsyncResult* _res_);
static gboolean gala_managed_client_start_x_co (GalaManagedClientStartXData* _data_);
static void gala_managed_client_start_x_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static gboolean ___lambda39_ (GalaManagedClient* self);
static gboolean ____lambda39__gsource_func (gpointer self);
static void gala_managed_client_set_display (GalaManagedClient* self,
                                      MetaDisplay* value);
static void gala_managed_client_set_args (GalaManagedClient* self,
                                   gchar** value,
                                   gint value_length1);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static GObject * gala_managed_client_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _gala_managed_client____lambda40_ (GalaManagedClient* self,
                                        MetaWindow* window);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void ___lambda41_ (Block55Data* _data55_);
static void ____lambda41__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __gala_managed_client____lambda40__meta_display_window_created (MetaDisplay* _sender,
                                                                     MetaWindow* object,
                                                                     gpointer self);
static void gala_managed_client_finalize (GObject * obj);
static GType gala_managed_client_get_type_once (void);
static void _vala_gala_managed_client_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gala_managed_client_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gala_managed_client_get_instance_private (GalaManagedClient* self)
{
	return G_STRUCT_MEMBER_P (self, GalaManagedClient_private_offset);
}

GalaManagedClient*
gala_managed_client_construct (GType object_type,
                               MetaDisplay* display,
                               gchar** args,
                               gint args_length1)
{
	GalaManagedClient * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaManagedClient*) g_object_new (object_type, "display", display, "args", args, NULL);
	return self;
}

GalaManagedClient*
gala_managed_client_new (MetaDisplay* display,
                         gchar** args,
                         gint args_length1)
{
	return gala_managed_client_construct (GALA_TYPE_MANAGED_CLIENT, display, args, args_length1);
}

static void
gala_managed_client_start_wayland_data_free (gpointer _data)
{
	GalaManagedClientStartWaylandData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaManagedClientStartWaylandData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_managed_client_start_wayland (GalaManagedClient* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GalaManagedClientStartWaylandData* _data_;
	GalaManagedClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaManagedClientStartWaylandData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_managed_client_start_wayland_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_managed_client_start_wayland_co (_data_);
}

static void
gala_managed_client_start_wayland_finish (GalaManagedClient* self,
                                          GAsyncResult* _res_)
{
	GalaManagedClientStartWaylandData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_managed_client_start_wayland_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GalaManagedClientStartWaylandData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_managed_client_start_wayland_co (_data_);
}

static gboolean
___lambda38_ (GalaManagedClient* self)
{
	gboolean result;
	gala_managed_client_start_wayland (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda38_ ((GalaManagedClient*) self);
	return result;
}

static gboolean
gala_managed_client_start_wayland_co (GalaManagedClientStartWaylandData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_INHERIT_FDS);
	_data_->subprocess_launcher = _data_->_tmp0_;
	{
		_data_->_tmp2_ = _data_->self->priv->_display;
		_data_->_tmp3_ = meta_display_get_context (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->subprocess_launcher;
		_data_->_tmp5_ = meta_wayland_client_new (_data_->_tmp3_, _data_->_tmp4_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gala_managed_client_set_wayland_client (_data_->self, _data_->_tmp1_);
		_data_->_tmp7_ = _data_->self->priv->_wayland_client;
		_data_->_tmp8_ = _data_->self->priv->_display;
		_data_->_tmp10_ = 0;
		_data_->_tmp9_ = gala_managed_client_get_args (_data_->self, &_data_->_tmp10_);
		_data_->_tmp9__length1 = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->_tmp9_;
		_data_->_tmp11__length1 = _data_->_tmp9__length1;
		_data_->_tmp12_ = meta_wayland_client_spawnv (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp11_, &_data_->_inner_error0_);
		_data_->_tmp6_ = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp1_);
			goto __catch0_g_error;
		}
		_data_->_tmp13_ = _data_->_tmp6_;
		_data_->_tmp6_ = NULL;
		_g_object_unref0 (_data_->self->priv->subprocess);
		_data_->self->priv->subprocess = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->self->priv->subprocess;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp14_, NULL, gala_managed_client_start_wayland_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp6_);
			_g_object_unref0 (_data_->_tmp1_);
			goto __catch0_g_error;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda38__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_object_unref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_warning ("ManagedClient.vala:64: Failed to create dock client: %s", _data_->_tmp16_);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->subprocess_launcher);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->subprocess_launcher);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->subprocess_launcher);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gala_managed_client_start_x_data_free (gpointer _data)
{
	GalaManagedClientStartXData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaManagedClientStartXData, _data_);
}

static void
gala_managed_client_start_x (GalaManagedClient* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GalaManagedClientStartXData* _data_;
	GalaManagedClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaManagedClientStartXData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_managed_client_start_x_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_managed_client_start_x_co (_data_);
}

static void
gala_managed_client_start_x_finish (GalaManagedClient* self,
                                    GAsyncResult* _res_)
{
	GalaManagedClientStartXData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_managed_client_start_x_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	GalaManagedClientStartXData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_managed_client_start_x_co (_data_);
}

static gboolean
___lambda39_ (GalaManagedClient* self)
{
	gboolean result;
	gala_managed_client_start_x (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda39_ ((GalaManagedClient*) self);
	return result;
}

static gboolean
gala_managed_client_start_x_co (GalaManagedClientStartXData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp2_ = 0;
		_data_->_tmp1_ = gala_managed_client_get_args (_data_->self, &_data_->_tmp2_);
		_data_->_tmp1__length1 = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp3__length1 = _data_->_tmp1__length1;
		_data_->_tmp4_ = g_subprocess_newv (_data_->_tmp3_, G_SUBPROCESS_FLAGS_NONE, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->subprocess);
		_data_->self->priv->subprocess = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->self->priv->subprocess;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp6_, NULL, gala_managed_client_start_x_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda39__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning ("ManagedClient.vala:80: Failed to create daemon subprocess with x: %s", _data_->_tmp8_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

MetaDisplay*
gala_managed_client_get_display (GalaManagedClient* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_managed_client_set_display (GalaManagedClient* self,
                                 MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_managed_client_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_managed_client_properties[GALA_MANAGED_CLIENT_DISPLAY_PROPERTY]);
	}
}

gchar**
gala_managed_client_get_args (GalaManagedClient* self,
                              gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_args;
	_tmp0__length1 = self->priv->_args_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
gala_managed_client_set_args (GalaManagedClient* self,
                              gchar** value,
                              gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = gala_managed_client_get_args (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup5 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_args = _tmp0_;
		self->priv->_args_length1 = _tmp0__length1;
		self->priv->__args_size_ = self->priv->_args_length1;
		g_object_notify_by_pspec ((GObject *) self, gala_managed_client_properties[GALA_MANAGED_CLIENT_ARGS_PROPERTY]);
	}
}

MetaWaylandClient*
gala_managed_client_get_wayland_client (GalaManagedClient* self)
{
	MetaWaylandClient* result;
	MetaWaylandClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wayland_client;
	result = _tmp0_;
	return result;
}

static void
gala_managed_client_set_wayland_client (GalaManagedClient* self,
                                        MetaWaylandClient* value)
{
	MetaWaylandClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_managed_client_get_wayland_client (self);
	if (old_value != value) {
		MetaWaylandClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wayland_client);
		self->priv->_wayland_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_managed_client_properties[GALA_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY]);
	}
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		GalaManagedClient* self;
		self = _data55_->self;
		_g_object_unref0 (_data55_->window);
		_g_object_unref0 (self);
		g_slice_free (Block55Data, _data55_);
	}
}

static void
___lambda41_ (Block55Data* _data55_)
{
	GalaManagedClient* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data55_->self;
	g_object_get (_data55_->window, "is-alive", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GSubprocess* _tmp3_;
		_tmp3_ = self->priv->subprocess;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSubprocess* _tmp4_;
		_tmp4_ = self->priv->subprocess;
		g_subprocess_force_exit (_tmp4_);
		g_warning ("ManagedClient.vala:40: WaylandClient window became unresponsive, killi" \
"ng the client.");
	}
}

static void
____lambda41__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda41_ (self);
}

static void
_gala_managed_client____lambda40_ (GalaManagedClient* self,
                                   MetaWindow* window)
{
	Block55Data* _data55_;
	MetaWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWaylandClient* _tmp2_;
	g_return_if_fail (window != NULL);
	_data55_ = g_slice_new0 (Block55Data);
	_data55_->_ref_count_ = 1;
	_data55_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data55_->window);
	_data55_->window = _tmp0_;
	_tmp2_ = self->priv->_wayland_client;
	if (_tmp2_ != NULL) {
		MetaWaylandClient* _tmp3_;
		_tmp3_ = self->priv->_wayland_client;
		_tmp1_ = meta_wayland_client_owns_window (_tmp3_, _data55_->window);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		g_signal_emit (self, gala_managed_client_signals[GALA_MANAGED_CLIENT_WINDOW_CREATED_SIGNAL], 0, _data55_->window);
		g_signal_connect_data ((GObject*) _data55_->window, "notify::is-alive", (GCallback) ____lambda41__g_object_notify, block55_data_ref (_data55_), (GClosureNotify) block55_data_unref, 0);
	}
	block55_data_unref (_data55_);
	_data55_ = NULL;
}

static void
__gala_managed_client____lambda40__meta_display_window_created (MetaDisplay* _sender,
                                                                MetaWindow* object,
                                                                gpointer self)
{
	_gala_managed_client____lambda40_ ((GalaManagedClient*) self, object);
}

static GObject *
gala_managed_client_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaManagedClient * self;
	parent_class = G_OBJECT_CLASS (gala_managed_client_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MANAGED_CLIENT, GalaManagedClient);
	if (meta_is_wayland_compositor ()) {
		MetaDisplay* _tmp0_;
		gala_managed_client_start_wayland (self, NULL, NULL);
		_tmp0_ = self->priv->_display;
		g_signal_connect_object (_tmp0_, "window-created", (GCallback) __gala_managed_client____lambda40__meta_display_window_created, self, 0);
	} else {
		gala_managed_client_start_x (self, NULL, NULL);
	}
	return obj;
}

static void
gala_managed_client_class_init (GalaManagedClientClass * klass,
                                gpointer klass_data)
{
	gala_managed_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaManagedClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_managed_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_managed_client_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_managed_client_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_managed_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MANAGED_CLIENT_DISPLAY_PROPERTY, gala_managed_client_properties[GALA_MANAGED_CLIENT_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MANAGED_CLIENT_ARGS_PROPERTY, gala_managed_client_properties[GALA_MANAGED_CLIENT_ARGS_PROPERTY] = g_param_spec_boxed ("args", "args", "args", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY, gala_managed_client_properties[GALA_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY] = g_param_spec_object ("wayland-client", "wayland-client", "wayland-client", meta_wayland_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_managed_client_signals[GALA_MANAGED_CLIENT_WINDOW_CREATED_SIGNAL] = g_signal_new ("window-created", GALA_TYPE_MANAGED_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
}

static void
gala_managed_client_instance_init (GalaManagedClient * self,
                                   gpointer klass)
{
	self->priv = gala_managed_client_get_instance_private (self);
}

static void
gala_managed_client_finalize (GObject * obj)
{
	GalaManagedClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MANAGED_CLIENT, GalaManagedClient);
	_g_object_unref0 (self->priv->_display);
	self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_wayland_client);
	_g_object_unref0 (self->priv->subprocess);
	G_OBJECT_CLASS (gala_managed_client_parent_class)->finalize (obj);
}

/**
 * Utility class that takes care of launching and restarting a subprocess.
 * On wayland this uses a WaylandClient and emits window_created if a window for the client was created.
 * On X this just launches a normal subprocess and never emits window_created.
 */
 G_GNUC_NO_INLINE static GType
gala_managed_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaManagedClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_managed_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaManagedClient), 0, (GInstanceInitFunc) gala_managed_client_instance_init, NULL };
	GType gala_managed_client_type_id;
	gala_managed_client_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaManagedClient", &g_define_type_info, 0);
	GalaManagedClient_private_offset = g_type_add_instance_private (gala_managed_client_type_id, sizeof (GalaManagedClientPrivate));
	return gala_managed_client_type_id;
}

GType
gala_managed_client_get_type (void)
{
	static gsize gala_managed_client_type_id__once = 0;
	if (g_once_init_enter (&gala_managed_client_type_id__once)) {
		GType gala_managed_client_type_id;
		gala_managed_client_type_id = gala_managed_client_get_type_once ();
		g_once_init_leave (&gala_managed_client_type_id__once, gala_managed_client_type_id);
	}
	return gala_managed_client_type_id__once;
}

static void
_vala_gala_managed_client_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GalaManagedClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MANAGED_CLIENT, GalaManagedClient);
	switch (property_id) {
		case GALA_MANAGED_CLIENT_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_managed_client_get_display (self));
		break;
		case GALA_MANAGED_CLIENT_ARGS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, gala_managed_client_get_args (self, &length));
		}
		break;
		case GALA_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY:
		g_value_set_object (value, gala_managed_client_get_wayland_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_managed_client_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GalaManagedClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MANAGED_CLIENT, GalaManagedClient);
	switch (property_id) {
		case GALA_MANAGED_CLIENT_DISPLAY_PROPERTY:
		gala_managed_client_set_display (self, g_value_get_object (value));
		break;
		case GALA_MANAGED_CLIENT_ARGS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			gala_managed_client_set_args (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case GALA_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY:
		gala_managed_client_set_wayland_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

