/* ShellWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ShellWindow.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/meta-window-actor.h>
#include <meta/window.h>
#include <stdlib.h>
#include <string.h>
#include <meta/display.h>
#include <meta/compositor-mutter.h>
#include <meta/util.h>
#include <mtk/mtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;
typedef struct _GalaPositionedWindowPrivate GalaPositionedWindowPrivate;

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_SHELL_WINDOW (gala_shell_window_get_type ())
#define GALA_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindow))
#define GALA_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))
#define GALA_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_WINDOW))
#define GALA_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_WINDOW))
#define GALA_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))

typedef struct _GalaShellWindow GalaShellWindow;
typedef struct _GalaShellWindowClass GalaShellWindowClass;
typedef struct _GalaShellWindowPrivate GalaShellWindowPrivate;

#define GALA_TYPE_PROPERTY_TARGET (gala_property_target_get_type ())
#define GALA_PROPERTY_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTarget))
#define GALA_PROPERTY_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTargetClass))
#define GALA_IS_PROPERTY_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PROPERTY_TARGET))
#define GALA_IS_PROPERTY_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PROPERTY_TARGET))
#define GALA_PROPERTY_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTargetClass))

typedef struct _GalaPropertyTarget GalaPropertyTarget;
typedef struct _GalaPropertyTargetClass GalaPropertyTargetClass;
enum  {
	GALA_SHELL_WINDOW_0_PROPERTY,
	GALA_SHELL_WINDOW_ACTOR_PROPERTY,
	GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY,
	GALA_SHELL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_shell_window_properties[GALA_SHELL_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GALA_POSITIONED_WINDOW_POSITION_TOP,
	GALA_POSITIONED_WINDOW_POSITION_BOTTOM,
	GALA_POSITIONED_WINDOW_POSITION_CENTER
} GalaPositionedWindowPosition;

#define GALA_POSITIONED_WINDOW_TYPE_POSITION (gala_positioned_window_position_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_TYPE_SHELL_CLIENTS_MANAGER (gala_shell_clients_manager_get_type ())
#define GALA_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager))
#define GALA_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))
#define GALA_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))

typedef struct _GalaShellClientsManager GalaShellClientsManager;
typedef struct _GalaShellClientsManagerClass GalaShellClientsManagerClass;
typedef struct _Block57Data Block57Data;

struct _GalaPositionedWindow {
	GObject parent_instance;
	GalaPositionedWindowPrivate * priv;
};

struct _GalaPositionedWindowClass {
	GObjectClass parent_class;
};

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaShellWindow {
	GalaPositionedWindow parent_instance;
	GalaShellWindowPrivate * priv;
};

struct _GalaShellWindowClass {
	GalaPositionedWindowClass parent_class;
};

struct _GalaShellWindowPrivate {
	gboolean _restore_previous_x11_region;
	MetaWindowActor* window_actor;
	gdouble custom_progress;
	gdouble multitasking_view_progress;
	gint animations_ongoing;
	GalaPropertyTarget* property_target;
};

struct _Block57Data {
	int _ref_count_;
	GalaShellWindow* self;
	gboolean visible;
	gboolean animating;
	GalaShellClientsManager* manager;
};

static gint GalaShellWindow_private_offset;
static gpointer gala_shell_window_parent_class = NULL;
static GalaGestureTargetIface * gala_shell_window_gala_gesture_target_parent_iface = NULL;

VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellWindow, g_object_unref)
VALA_EXTERN GType gala_property_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPropertyTarget, g_object_unref)
VALA_EXTERN GType gala_positioned_window_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaShellWindow* gala_shell_window_new (MetaWindow* window,
                                        GalaPositionedWindowPosition position,
                                        GVariant* position_data);
VALA_EXTERN GalaShellWindow* gala_shell_window_construct (GType object_type,
                                              MetaWindow* window,
                                              GalaPositionedWindowPosition position,
                                              GVariant* position_data);
VALA_EXTERN GalaPositionedWindow* gala_positioned_window_new (MetaWindow* window,
                                                  GalaPositionedWindowPosition position,
                                                  GVariant* position_data);
VALA_EXTERN GalaPositionedWindow* gala_positioned_window_construct (GType object_type,
                                                        MetaWindow* window,
                                                        GalaPositionedWindowPosition position,
                                                        GVariant* position_data);
static void gala_shell_window_update_target (GalaShellWindow* self);
static gchar* gala_shell_window_get_animation_property (GalaShellWindow* self);
static GType gala_shell_window_get_property_type (GalaShellWindow* self);
static void gala_shell_window_calculate_value (GalaShellWindow* self,
                                        gboolean hidden,
                                        GValue* result);
VALA_EXTERN GalaPropertyTarget* gala_property_target_new (GalaGestureAction action,
                                              ClutterActor* actor,
                                              const gchar* property,
                                              GType value_type,
                                              GValue* from_value,
                                              GValue* to_value);
VALA_EXTERN GalaPropertyTarget* gala_property_target_construct (GType object_type,
                                                    GalaGestureAction action,
                                                    ClutterActor* actor,
                                                    const gchar* property,
                                                    GType value_type,
                                                    GValue* from_value,
                                                    GValue* to_value);
static void gala_shell_window_update_property (GalaShellWindow* self);
VALA_EXTERN void gala_gesture_target_propagate (GalaGestureTarget* self,
                                    GalaGestureTargetUpdateType update_type,
                                    GalaGestureAction action,
                                    gdouble progress);
static void gala_shell_window_real_propagate (GalaGestureTarget* base,
                                       GalaGestureTargetUpdateType update_type,
                                       GalaGestureAction action,
                                       gdouble progress);
static void gala_shell_window_update_visibility (GalaShellWindow* self);
static void gala_shell_window_on_update (GalaShellWindow* self,
                                  GalaGestureAction action,
                                  gdouble progress);
VALA_EXTERN GType gala_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellClientsManager, g_object_unref)
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
VALA_EXTERN MetaWindow* gala_positioned_window_get_window (GalaPositionedWindow* self);
static gboolean gala_shell_window_get_restore_previous_x11_region (GalaShellWindow* self);
VALA_EXTERN GalaShellClientsManager* gala_shell_clients_manager_get_instance (void);
static gboolean __lambda43_ (Block57Data* _data57_,
                      MetaWindow* transient);
VALA_EXTERN gboolean gala_shell_clients_manager_is_itself_positioned (GalaShellClientsManager* self,
                                                          MetaWindow* window);
static gboolean ___lambda43__meta_window_foreach_func (MetaWindow* window,
                                                gpointer self);
VALA_EXTERN GalaPositionedWindowPosition gala_positioned_window_get_position (GalaPositionedWindow* self);
VALA_EXTERN void gala_positioned_window_get_custom_window_rect (GalaPositionedWindow* self,
                                                    MtkRectangle* result);
static void gala_shell_window_update_clip (GalaShellWindow* self);
VALA_EXTERN void gala_shell_window_set_restore_previous_x11_region (GalaShellWindow* self,
                                                        gboolean value);
static GObject * gala_shell_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _gala_shell_window_update_clip_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void _gala_shell_window_update_target_meta_window_size_changed (MetaWindow* _sender,
                                                                gpointer self);
static void _gala_shell_window_update_target_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
VALA_EXTERN ClutterActor* gala_gesture_target_get_actor (GalaGestureTarget* self);
static void gala_shell_window_finalize (GObject * obj);
static GType gala_shell_window_get_type_once (void);
static void _vala_gala_shell_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_shell_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_shell_window_get_instance_private (GalaShellWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaShellWindow_private_offset);
}

GalaShellWindow*
gala_shell_window_construct (GType object_type,
                             MetaWindow* window,
                             GalaPositionedWindowPosition position,
                             GVariant* position_data)
{
	GalaShellWindow * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaShellWindow*) gala_positioned_window_construct (object_type, window, position, position_data);
	return self;
}

GalaShellWindow*
gala_shell_window_new (MetaWindow* window,
                       GalaPositionedWindowPosition position,
                       GVariant* position_data)
{
	return gala_shell_window_construct (GALA_TYPE_SHELL_WINDOW, window, position, position_data);
}

static void
gala_shell_window_update_target (GalaShellWindow* self)
{
	MetaWindowActor* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	GValue _tmp5_ = {0};
	GValue _tmp6_;
	GalaPropertyTarget* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_actor;
	_tmp1_ = gala_shell_window_get_animation_property (self);
	_tmp2_ = _tmp1_;
	gala_shell_window_calculate_value (self, FALSE, &_tmp3_);
	_tmp4_ = _tmp3_;
	gala_shell_window_calculate_value (self, TRUE, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gala_property_target_new (GALA_GESTURE_ACTION_DOCK, (ClutterActor*) _tmp0_, _tmp2_, gala_shell_window_get_property_type (self), &_tmp4_, &_tmp6_);
	_g_object_unref0 (self->priv->property_target);
	self->priv->property_target = _tmp7_;
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	_g_free0 (_tmp2_);
}

static void
gala_shell_window_update_property (GalaShellWindow* self)
{
	gdouble hidden_progress = 0.0;
	GalaPropertyTarget* _tmp0_;
	g_return_if_fail (self != NULL);
	hidden_progress = MAX (self->priv->custom_progress, self->priv->multitasking_view_progress);
	_tmp0_ = self->priv->property_target;
	gala_gesture_target_propagate ((GalaGestureTarget*) _tmp0_, GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE, GALA_GESTURE_ACTION_DOCK, hidden_progress);
}

static void
gala_shell_window_real_propagate (GalaGestureTarget* base,
                                  GalaGestureTargetUpdateType update_type,
                                  GalaGestureAction action,
                                  gdouble progress)
{
	GalaShellWindow * self;
	self = (GalaShellWindow*) base;
	switch (update_type) {
		case GALA_GESTURE_TARGET_UPDATE_TYPE_START:
		{
			gint _tmp0_;
			_tmp0_ = self->priv->animations_ongoing;
			self->priv->animations_ongoing = _tmp0_ + 1;
			gala_shell_window_update_visibility (self);
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE:
		{
			gala_shell_window_on_update (self, action, progress);
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_END:
		{
			gint _tmp1_;
			_tmp1_ = self->priv->animations_ongoing;
			self->priv->animations_ongoing = _tmp1_ - 1;
			gala_shell_window_update_visibility (self);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
gala_shell_window_on_update (GalaShellWindow* self,
                             GalaGestureAction action,
                             gdouble progress)
{
	g_return_if_fail (self != NULL);
	switch (action) {
		case GALA_GESTURE_ACTION_MULTITASKING_VIEW:
		{
			self->priv->multitasking_view_progress = progress;
			break;
		}
		case GALA_GESTURE_ACTION_DOCK:
		{
			self->priv->custom_progress = progress;
			break;
		}
		default:
		{
			break;
		}
	}
	gala_shell_window_update_property (self);
}

static Block57Data*
block57_data_ref (Block57Data* _data57_)
{
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}

static void
block57_data_unref (void * _userdata_)
{
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		GalaShellWindow* self;
		self = _data57_->self;
		_g_object_unref0 (self);
		g_slice_free (Block57Data, _data57_);
	}
}

static gboolean
__lambda43_ (Block57Data* _data57_,
             MetaWindow* transient)
{
	GalaShellWindow* self;
	MetaWindowActor* window_actor = NULL;
	GObject* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWindowActor* _tmp2_;
	gboolean result;
	self = _data57_->self;
	g_return_val_if_fail (transient != NULL, FALSE);
	if (gala_shell_clients_manager_is_itself_positioned (_data57_->manager, transient)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = meta_window_get_compositor_private (transient);
	window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, meta_window_actor_get_type (), MetaWindowActor);
	if (_data57_->visible) {
		_tmp1_ = !_data57_->animating;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp2_ = window_actor;
	g_object_set ((ClutterActor*) _tmp2_, "visible", _tmp1_, NULL);
	result = TRUE;
	return result;
}

static gboolean
___lambda43__meta_window_foreach_func (MetaWindow* window,
                                       gpointer self)
{
	gboolean result;
	result = __lambda43_ (self, window);
	return result;
}

static void
gala_shell_window_update_visibility (GalaShellWindow* self)
{
	Block57Data* _data57_;
	gboolean _tmp0_ = FALSE;
	MetaWindowActor* _tmp1_;
	MetaWindowActor* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GalaShellClientsManager* _tmp21_;
	MetaWindow* _tmp22_;
	MetaWindow* _tmp23_;
	g_return_if_fail (self != NULL);
	_data57_ = g_slice_new0 (Block57Data);
	_data57_->_ref_count_ = 1;
	_data57_->self = g_object_ref (self);
	_data57_->visible = MAX (self->priv->multitasking_view_progress, self->priv->custom_progress) < 0.1;
	_data57_->animating = self->priv->animations_ongoing > 0;
	if (_data57_->animating) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _data57_->visible;
	}
	_tmp1_ = self->priv->window_actor;
	g_object_set ((ClutterActor*) _tmp1_, "visible", _tmp0_, NULL);
	_tmp2_ = self->priv->window_actor;
	g_object_get ((ClutterActor*) _tmp2_, "visible", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		MetaWindow* _tmp5_;
		MetaWindow* _tmp6_;
		MetaDisplay* _tmp7_;
		MetaDisplay* _tmp8_;
		_tmp5_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = meta_window_get_display (_tmp6_);
		_tmp8_ = _tmp7_;
		meta_disable_unredirect_for_display (_tmp8_);
	} else {
		MetaWindow* _tmp9_;
		MetaWindow* _tmp10_;
		MetaDisplay* _tmp11_;
		MetaDisplay* _tmp12_;
		_tmp9_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = meta_window_get_display (_tmp10_);
		_tmp12_ = _tmp11_;
		meta_enable_unredirect_for_display (_tmp12_);
	}
	if (!meta_is_wayland_compositor ()) {
		MetaWindowActor* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = self->priv->window_actor;
		g_object_get ((ClutterActor*) _tmp13_, "visible", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		if (_tmp15_) {
			MetaWindow* _tmp16_;
			MetaWindow* _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->priv->_restore_previous_x11_region;
			gala_utils_x11_unset_window_pass_through (_tmp17_, _tmp18_);
		} else {
			MetaWindow* _tmp19_;
			MetaWindow* _tmp20_;
			_tmp19_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
			_tmp20_ = _tmp19_;
			gala_utils_x11_set_window_pass_through (_tmp20_);
		}
	}
	_tmp21_ = gala_shell_clients_manager_get_instance ();
	_data57_->manager = _tmp21_;
	_tmp22_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp23_ = _tmp22_;
	meta_window_foreach_transient (_tmp23_, ___lambda43__meta_window_foreach_func, _data57_);
	block57_data_unref (_data57_);
	_data57_ = NULL;
}

static gchar*
gala_shell_window_get_animation_property (GalaShellWindow* self)
{
	GalaPositionedWindowPosition _tmp0_;
	GalaPositionedWindowPosition _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gala_positioned_window_get_position ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GALA_POSITIONED_WINDOW_POSITION_TOP:
		case GALA_POSITIONED_WINDOW_POSITION_BOTTOM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("translation-y");
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("opacity");
			result = _tmp3_;
			return result;
		}
	}
}

static GType
gala_shell_window_get_property_type (GalaShellWindow* self)
{
	GalaPositionedWindowPosition _tmp0_;
	GalaPositionedWindowPosition _tmp1_;
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = gala_positioned_window_get_position ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GALA_POSITIONED_WINDOW_POSITION_TOP:
		case GALA_POSITIONED_WINDOW_POSITION_BOTTOM:
		{
			result = G_TYPE_FLOAT;
			return result;
		}
		default:
		{
			result = G_TYPE_UINT;
			return result;
		}
	}
}

static void
gala_shell_window_calculate_value (GalaShellWindow* self,
                                   gboolean hidden,
                                   GValue* result)
{
	MtkRectangle custom_rect = {0};
	MtkRectangle _tmp0_ = {0};
	GalaPositionedWindowPosition _tmp1_;
	GalaPositionedWindowPosition _tmp2_;
	g_return_if_fail (self != NULL);
	gala_positioned_window_get_custom_window_rect ((GalaPositionedWindow*) self, &_tmp0_);
	custom_rect = _tmp0_;
	_tmp1_ = gala_positioned_window_get_position ((GalaPositionedWindow*) self);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case GALA_POSITIONED_WINDOW_POSITION_TOP:
		{
			gfloat _tmp3_ = 0.0F;
			GValue _tmp5_ = {0};
			if (hidden) {
				MtkRectangle _tmp4_;
				_tmp4_ = custom_rect;
				_tmp3_ = (gfloat) (-_tmp4_.height);
			} else {
				_tmp3_ = 0.f;
			}
			g_value_init (&_tmp5_, G_TYPE_FLOAT);
			g_value_set_float (&_tmp5_, _tmp3_);
			*result = _tmp5_;
			return;
		}
		case GALA_POSITIONED_WINDOW_POSITION_BOTTOM:
		{
			gfloat _tmp6_ = 0.0F;
			GValue _tmp8_ = {0};
			if (hidden) {
				MtkRectangle _tmp7_;
				_tmp7_ = custom_rect;
				_tmp6_ = (gfloat) _tmp7_.height;
			} else {
				_tmp6_ = 0.f;
			}
			g_value_init (&_tmp8_, G_TYPE_FLOAT);
			g_value_set_float (&_tmp8_, _tmp6_);
			*result = _tmp8_;
			return;
		}
		default:
		{
			guint _tmp9_ = 0U;
			GValue _tmp10_ = {0};
			if (hidden) {
				_tmp9_ = 0U;
			} else {
				_tmp9_ = 255U;
			}
			g_value_init (&_tmp10_, G_TYPE_UINT);
			g_value_set_uint (&_tmp10_, _tmp9_);
			*result = _tmp10_;
			return;
		}
	}
}

static void
gala_shell_window_update_clip (GalaShellWindow* self)
{
	gboolean _tmp0_ = FALSE;
	GalaPositionedWindowPosition _tmp1_;
	GalaPositionedWindowPosition _tmp2_;
	MtkRectangle monitor_geom = {0};
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	MetaDisplay* _tmp8_;
	MetaDisplay* _tmp9_;
	MetaWindow* _tmp10_;
	MetaWindow* _tmp11_;
	MtkRectangle _tmp12_ = {0};
	gfloat y = 0.0F;
	MetaWindowActor* _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	MetaWindowActor* _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_;
	MetaWindowActor* _tmp19_;
	gfloat _tmp20_;
	gfloat _tmp21_;
	MtkRectangle _tmp22_;
	MtkRectangle _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp1_ = gala_positioned_window_get_position ((GalaPositionedWindow*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GALA_POSITIONED_WINDOW_POSITION_TOP) {
		GalaPositionedWindowPosition _tmp3_;
		GalaPositionedWindowPosition _tmp4_;
		_tmp3_ = gala_positioned_window_get_position ((GalaPositionedWindow*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != GALA_POSITIONED_WINDOW_POSITION_BOTTOM;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MetaWindowActor* _tmp5_;
		_tmp5_ = self->priv->window_actor;
		clutter_actor_remove_clip ((ClutterActor*) _tmp5_);
		return;
	}
	_tmp6_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = meta_window_get_display (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp11_ = _tmp10_;
	meta_display_get_monitor_geometry (_tmp9_, meta_window_get_monitor (_tmp11_), &_tmp12_);
	monitor_geom = _tmp12_;
	_tmp13_ = self->priv->window_actor;
	_tmp14_ = clutter_actor_get_y ((ClutterActor*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->window_actor;
	g_object_get ((ClutterActor*) _tmp16_, "translation-y", &_tmp17_, NULL);
	_tmp18_ = _tmp17_;
	y = _tmp15_ + _tmp18_;
	_tmp19_ = self->priv->window_actor;
	_tmp20_ = clutter_actor_get_height ((ClutterActor*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = monitor_geom;
	_tmp23_ = monitor_geom;
	if ((y + _tmp21_) > ((gfloat) (_tmp22_.y + _tmp23_.height))) {
		MetaWindowActor* _tmp24_;
		MetaWindowActor* _tmp25_;
		gfloat _tmp26_;
		gfloat _tmp27_;
		MtkRectangle _tmp28_;
		MtkRectangle _tmp29_;
		_tmp24_ = self->priv->window_actor;
		_tmp25_ = self->priv->window_actor;
		_tmp26_ = clutter_actor_get_width ((ClutterActor*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = monitor_geom;
		_tmp29_ = monitor_geom;
		clutter_actor_set_clip ((ClutterActor*) _tmp24_, (gfloat) 0, (gfloat) 0, _tmp27_, (_tmp28_.y + _tmp29_.height) - y);
	} else {
		MtkRectangle _tmp30_;
		_tmp30_ = monitor_geom;
		if (y < ((gfloat) _tmp30_.y)) {
			MetaWindowActor* _tmp31_;
			MtkRectangle _tmp32_;
			MetaWindowActor* _tmp33_;
			gfloat _tmp34_;
			gfloat _tmp35_;
			MetaWindowActor* _tmp36_;
			gfloat _tmp37_;
			gfloat _tmp38_;
			_tmp31_ = self->priv->window_actor;
			_tmp32_ = monitor_geom;
			_tmp33_ = self->priv->window_actor;
			_tmp34_ = clutter_actor_get_width ((ClutterActor*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = self->priv->window_actor;
			_tmp37_ = clutter_actor_get_height ((ClutterActor*) _tmp36_);
			_tmp38_ = _tmp37_;
			clutter_actor_set_clip ((ClutterActor*) _tmp31_, (gfloat) 0, _tmp32_.y - y, _tmp35_, _tmp38_);
		} else {
			MetaWindowActor* _tmp39_;
			_tmp39_ = self->priv->window_actor;
			clutter_actor_remove_clip ((ClutterActor*) _tmp39_);
		}
	}
}

static ClutterActor*
gala_shell_window_real_get_actor (GalaGestureTarget* base)
{
	ClutterActor* result;
	GalaShellWindow* self;
	MetaWindowActor* _tmp0_;
	self = (GalaShellWindow*) base;
	_tmp0_ = self->priv->window_actor;
	result = (ClutterActor*) _tmp0_;
	return result;
}

static gboolean
gala_shell_window_get_restore_previous_x11_region (GalaShellWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_restore_previous_x11_region;
	return result;
}

void
gala_shell_window_set_restore_previous_x11_region (GalaShellWindow* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shell_window_get_restore_previous_x11_region (self);
	if (old_value != value) {
		self->priv->_restore_previous_x11_region = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shell_window_properties[GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_shell_window_update_clip_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	gala_shell_window_update_clip ((GalaShellWindow*) self);
}

static void
_gala_shell_window_update_target_meta_window_size_changed (MetaWindow* _sender,
                                                           gpointer self)
{
	gala_shell_window_update_target ((GalaShellWindow*) self);
}

static void
_gala_shell_window_update_target_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	gala_shell_window_update_target ((GalaShellWindow*) self);
}

static GObject *
gala_shell_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaShellWindow * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	GObject* _tmp2_;
	MetaWindowActor* _tmp3_;
	MetaWindowActor* _tmp4_;
	MetaWindowActor* _tmp5_;
	MetaWindowActor* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	parent_class = G_OBJECT_CLASS (gala_shell_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHELL_WINDOW, GalaShellWindow);
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = meta_window_get_compositor_private (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, meta_window_actor_get_type (), MetaWindowActor));
	_g_object_unref0 (self->priv->window_actor);
	self->priv->window_actor = _tmp3_;
	_tmp4_ = self->priv->window_actor;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::width", (GCallback) _gala_shell_window_update_clip_g_object_notify, self, 0);
	_tmp5_ = self->priv->window_actor;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::height", (GCallback) _gala_shell_window_update_clip_g_object_notify, self, 0);
	_tmp6_ = self->priv->window_actor;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::translation-y", (GCallback) _gala_shell_window_update_clip_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::position", (GCallback) _gala_shell_window_update_clip_g_object_notify, self, 0);
	_tmp7_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "size-changed", (GCallback) _gala_shell_window_update_target_meta_window_size_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::position", (GCallback) _gala_shell_window_update_target_g_object_notify, self, 0);
	gala_shell_window_update_target (self);
	return obj;
}

static void
gala_shell_window_class_init (GalaShellWindowClass * klass,
                              gpointer klass_data)
{
	gala_shell_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaShellWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_shell_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_shell_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_shell_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_shell_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHELL_WINDOW_ACTOR_PROPERTY, gala_shell_window_properties[GALA_SHELL_WINDOW_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY, gala_shell_window_properties[GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY] = g_param_spec_boolean ("restore-previous-x11-region", "restore-previous-x11-region", "restore-previous-x11-region", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
gala_shell_window_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                                      gpointer iface_data)
{
	gala_shell_window_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_shell_window_real_propagate;
	iface->get_actor = gala_shell_window_real_get_actor;
}

static void
gala_shell_window_instance_init (GalaShellWindow * self,
                                 gpointer klass)
{
	self->priv = gala_shell_window_get_instance_private (self);
	self->priv->_restore_previous_x11_region = FALSE;
	self->priv->custom_progress = (gdouble) 0;
	self->priv->multitasking_view_progress = (gdouble) 0;
	self->priv->animations_ongoing = 0;
}

static void
gala_shell_window_finalize (GObject * obj)
{
	GalaShellWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHELL_WINDOW, GalaShellWindow);
	_g_object_unref0 (self->priv->window_actor);
	_g_object_unref0 (self->priv->property_target);
	G_OBJECT_CLASS (gala_shell_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_shell_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaShellWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_shell_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaShellWindow), 0, (GInstanceInitFunc) gala_shell_window_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_shell_window_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_shell_window_type_id;
	gala_shell_window_type_id = g_type_register_static (GALA_TYPE_POSITIONED_WINDOW, "GalaShellWindow", &g_define_type_info, 0);
	g_type_add_interface_static (gala_shell_window_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	GalaShellWindow_private_offset = g_type_add_instance_private (gala_shell_window_type_id, sizeof (GalaShellWindowPrivate));
	return gala_shell_window_type_id;
}

GType
gala_shell_window_get_type (void)
{
	static gsize gala_shell_window_type_id__once = 0;
	if (g_once_init_enter (&gala_shell_window_type_id__once)) {
		GType gala_shell_window_type_id;
		gala_shell_window_type_id = gala_shell_window_get_type_once ();
		g_once_init_leave (&gala_shell_window_type_id__once, gala_shell_window_type_id);
	}
	return gala_shell_window_type_id__once;
}

static void
_vala_gala_shell_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaShellWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHELL_WINDOW, GalaShellWindow);
	switch (property_id) {
		case GALA_SHELL_WINDOW_ACTOR_PROPERTY:
		g_value_set_object (value, gala_gesture_target_get_actor ((GalaGestureTarget*) self));
		break;
		case GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY:
		g_value_set_boolean (value, gala_shell_window_get_restore_previous_x11_region (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_shell_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaShellWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHELL_WINDOW, GalaShellWindow);
	switch (property_id) {
		case GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY:
		gala_shell_window_set_restore_previous_x11_region (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

