/* MonitorClone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MonitorClone.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/meta-background-group.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <meta/meta-window-actor.h>
#include <meta/compositor-mutter.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;
typedef struct _GalaActorTargetPrivate GalaActorTargetPrivate;

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;
typedef struct _GalaMonitorClonePrivate GalaMonitorClonePrivate;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
enum  {
	GALA_MONITOR_CLONE_0_PROPERTY,
	GALA_MONITOR_CLONE_WM_PROPERTY,
	GALA_MONITOR_CLONE_MONITOR_PROPERTY,
	GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY,
	GALA_MONITOR_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_monitor_clone_properties[GALA_MONITOR_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL,
	GALA_MONITOR_CLONE_NUM_SIGNALS
};
static guint gala_monitor_clone_signals[GALA_MONITOR_CLONE_NUM_SIGNALS] = {0};

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaActorTarget {
	ClutterActor parent_instance;
	GalaActorTargetPrivate * priv;
};

struct _GalaActorTargetClass {
	ClutterActorClass parent_class;
	void (*start_progress) (GalaActorTarget* self, GalaGestureAction action);
	void (*update_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble progress);
	void (*commit_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble to);
	void (*end_progress) (GalaActorTarget* self, GalaGestureAction action);
};

struct _GalaMonitorClone {
	GalaActorTarget parent_instance;
	GalaMonitorClonePrivate * priv;
};

struct _GalaMonitorCloneClass {
	GalaActorTargetClass parent_class;
};

struct _GalaMonitorClonePrivate {
	GalaWindowManager* _wm;
	gint _monitor;
	gfloat _monitor_scale;
	GalaWindowCloneContainer* window_container;
	GalaBackgroundManager* background;
};

static gint GalaMonitorClone_private_offset;
static gpointer gala_monitor_clone_parent_class = NULL;

VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN GalaWindowManager* gala_monitor_clone_get_wm (GalaMonitorClone* self);
static void gala_monitor_clone_window_entered (GalaMonitorClone* self,
                                        gint window_monitor,
                                        MetaWindow* window);
static void _gala_monitor_clone_window_entered_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                             gint object,
                                                                             MetaWindow* p0,
                                                                             gpointer self);
static void gala_monitor_clone_window_left (GalaMonitorClone* self,
                                     gint window_monitor,
                                     MetaWindow* window);
static void _gala_monitor_clone_window_left_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                       gint object,
                                                                       MetaWindow* p0,
                                                                       gpointer self);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_new (GalaWindowManager* wm,
                                          gint monitor);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_construct (GType object_type,
                                                GalaWindowManager* wm,
                                                gint monitor);
VALA_EXTERN void gala_monitor_clone_update_allocation (GalaMonitorClone* self);
VALA_EXTERN gint gala_monitor_clone_get_monitor (GalaMonitorClone* self);
VALA_EXTERN void gala_monitor_clone_set_monitor_scale (GalaMonitorClone* self,
                                           gfloat value);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
static void gala_monitor_clone_set_wm (GalaMonitorClone* self,
                                GalaWindowManager* value);
static void gala_monitor_clone_set_monitor (GalaMonitorClone* self,
                                     gint value);
VALA_EXTERN gfloat gala_monitor_clone_get_monitor_scale (GalaMonitorClone* self);
static GObject * gala_monitor_clone_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (MetaDisplay* display,
                                                    gint monitor_index,
                                                    gboolean control_position,
                                                    gboolean rounded_corners);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          MetaDisplay* display,
                                                          gint monitor_index,
                                                          gboolean control_position,
                                                          gboolean rounded_corners);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
static void _gala_monitor_clone___lambda81_ (GalaMonitorClone* self,
                                      MetaWindow* w);
static void __gala_monitor_clone___lambda81__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                   MetaWindow* window,
                                                                                   gpointer self);
static void gala_monitor_clone_finalize (GObject * obj);
static GType gala_monitor_clone_get_type_once (void);
static void _vala_gala_monitor_clone_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gala_monitor_clone_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
gala_monitor_clone_get_instance_private (GalaMonitorClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaMonitorClone_private_offset);
}

static void
_gala_monitor_clone_window_entered_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                        gint object,
                                                                        MetaWindow* p0,
                                                                        gpointer self)
{
	gala_monitor_clone_window_entered ((GalaMonitorClone*) self, object, p0);
}

static void
_gala_monitor_clone_window_left_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                  gint object,
                                                                  MetaWindow* p0,
                                                                  gpointer self)
{
	gala_monitor_clone_window_left ((GalaMonitorClone*) self, object, p0);
}

GalaMonitorClone*
gala_monitor_clone_construct (GType object_type,
                              GalaWindowManager* wm,
                              gint monitor)
{
	GalaMonitorClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaMonitorClone*) g_object_new (object_type, "wm", wm, "monitor", monitor, NULL);
	return self;
}

GalaMonitorClone*
gala_monitor_clone_new (GalaWindowManager* wm,
                        gint monitor)
{
	return gala_monitor_clone_construct (GALA_TYPE_MONITOR_CLONE, wm, monitor);
}

/**
     * Make sure the MonitorClone is at the location of the monitor on the stage
     */
void
gala_monitor_clone_update_allocation (GalaMonitorClone* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle monitor_geometry = {0};
	gint _tmp2_;
	MtkRectangle _tmp3_ = {0};
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	MtkRectangle _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = self->priv->_monitor;
	meta_display_get_monitor_geometry (display, _tmp2_, &_tmp3_);
	monitor_geometry = _tmp3_;
	_tmp4_ = monitor_geometry;
	_tmp5_ = monitor_geometry;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp4_.x, (gfloat) _tmp5_.y);
	_tmp6_ = monitor_geometry;
	_tmp7_ = monitor_geometry;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp6_.width, (gfloat) _tmp7_.height);
	_tmp8_ = self->priv->_monitor;
	gala_monitor_clone_set_monitor_scale (self, meta_display_get_monitor_scale (display, _tmp8_));
}

static void
gala_monitor_clone_window_left (GalaMonitorClone* self,
                                gint window_monitor,
                                MetaWindow* window)
{
	gint _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_monitor;
	if (window_monitor != _tmp0_) {
		return;
	}
	_tmp1_ = self->priv->window_container;
	gala_window_clone_container_remove_window (_tmp1_, window);
}

static void
gala_monitor_clone_window_entered (GalaMonitorClone* self,
                                   gint window_monitor,
                                   MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	GalaWindowCloneContainer* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp1_ = self->priv->_monitor;
	if (window_monitor != _tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MetaWindowType _tmp2_;
		MetaWindowType _tmp3_;
		_tmp2_ = meta_window_get_window_type (window);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ != META_WINDOW_NORMAL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->window_container;
	gala_window_clone_container_add_window (_tmp4_, window);
}

GalaWindowManager*
gala_monitor_clone_get_wm (GalaMonitorClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_monitor_clone_set_wm (GalaMonitorClone* self,
                           GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_WM_PROPERTY]);
	}
}

gint
gala_monitor_clone_get_monitor (GalaMonitorClone* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor;
	return result;
}

static void
gala_monitor_clone_set_monitor (GalaMonitorClone* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_monitor (self);
	if (old_value != value) {
		self->priv->_monitor = value;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_PROPERTY]);
	}
}

gfloat
gala_monitor_clone_get_monitor_scale (GalaMonitorClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_monitor_clone_set_monitor_scale (GalaMonitorClone* self,
                                      gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY]);
	}
}

static void
_gala_monitor_clone___lambda81_ (GalaMonitorClone* self,
                                 MetaWindow* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, gala_monitor_clone_signals[GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL], 0, w);
}

static void
__gala_monitor_clone___lambda81__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                              MetaWindow* window,
                                                                              gpointer self)
{
	_gala_monitor_clone___lambda81_ ((GalaMonitorClone*) self, window);
}

static GObject *
gala_monitor_clone_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaMonitorClone * self;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	gint _tmp3_;
	GalaBackgroundManager* _tmp4_;
	GalaWindowManager* _tmp5_;
	gfloat _tmp6_;
	GalaWindowCloneContainer* _tmp7_;
	GalaWindowCloneContainer* _tmp8_;
	ClutterBindConstraint* _tmp9_;
	ClutterBindConstraint* _tmp10_;
	GalaWindowCloneContainer* _tmp11_;
	GalaWindowCloneContainer* _tmp12_;
	MetaDisplay* _tmp13_;
	MetaDisplay* _tmp14_;
	GList* window_actors = NULL;
	MetaDisplay* _tmp15_;
	GList* _tmp16_;
	GList* _tmp17_;
	GalaBackgroundManager* _tmp25_;
	GalaWindowCloneContainer* _tmp26_;
	GalaDragDropAction* drop = NULL;
	GalaDragDropAction* _tmp27_;
	GalaDragDropAction* _tmp28_;
	parent_class = G_OBJECT_CLASS (gala_monitor_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	gala_monitor_clone_update_allocation (self);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = self->priv->_monitor;
	_tmp4_ = gala_background_manager_new (_tmp2_, _tmp3_, FALSE, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = _tmp4_;
	_tmp5_ = self->priv->_wm;
	_tmp6_ = self->priv->_monitor_scale;
	_tmp7_ = gala_window_clone_container_new (_tmp5_, _tmp6_, FALSE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->window_container);
	self->priv->window_container = _tmp7_;
	_tmp8_ = self->priv->window_container;
	_tmp9_ = (ClutterBindConstraint*) clutter_bind_constraint_new ((ClutterActor*) self, CLUTTER_BIND_SIZE, 0.0f);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp8_, (ClutterConstraint*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->window_container;
	g_signal_connect_object (_tmp11_, "window-selected", (GCallback) __gala_monitor_clone___lambda81__gala_window_clone_container_window_selected, self, 0);
	_tmp12_ = self->priv->window_container;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp12_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = display;
	g_signal_connect_object (_tmp13_, "window-entered-monitor", (GCallback) _gala_monitor_clone_window_entered_meta_display_window_entered_monitor, self, 0);
	_tmp14_ = display;
	g_signal_connect_object (_tmp14_, "window-left-monitor", (GCallback) _gala_monitor_clone_window_left_meta_display_window_left_monitor, self, 0);
	_tmp15_ = display;
	_tmp16_ = meta_get_window_actors (_tmp15_);
	window_actors = _tmp16_;
	_tmp17_ = window_actors;
	{
		GList* window_actor_collection = NULL;
		GList* window_actor_it = NULL;
		window_actor_collection = _tmp17_;
		for (window_actor_it = window_actor_collection; window_actor_it != NULL; window_actor_it = window_actor_it->next) {
			MetaWindowActor* window_actor = NULL;
			window_actor = (MetaWindowActor*) window_actor_it->data;
			{
				MetaWindowActor* _tmp18_;
				MetaWindow* window = NULL;
				MetaWindowActor* _tmp19_;
				MetaWindow* _tmp20_;
				MetaWindow* _tmp21_;
				gint _tmp22_;
				_tmp18_ = window_actor;
				if (meta_window_actor_is_destroyed (_tmp18_)) {
					continue;
				}
				_tmp19_ = window_actor;
				_tmp20_ = meta_window_actor_get_meta_window (_tmp19_);
				window = _tmp20_;
				_tmp21_ = window;
				_tmp22_ = self->priv->_monitor;
				if (meta_window_get_monitor (_tmp21_) == _tmp22_) {
					gint _tmp23_;
					MetaWindow* _tmp24_;
					_tmp23_ = self->priv->_monitor;
					_tmp24_ = window;
					gala_monitor_clone_window_entered (self, _tmp23_, _tmp24_);
				}
			}
		}
	}
	_tmp25_ = self->priv->background;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp25_);
	_tmp26_ = self->priv->window_container;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp26_);
	_tmp27_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp27_);
	drop = _tmp27_;
	_tmp28_ = drop;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp28_);
	_g_object_unref0 (drop);
	return obj;
}

static void
gala_monitor_clone_class_init (GalaMonitorCloneClass * klass,
                               gpointer klass_data)
{
	gala_monitor_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaMonitorClone_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_monitor_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_monitor_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_monitor_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_monitor_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_WM_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_MONITOR_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_PROPERTY] = g_param_spec_int ("monitor", "monitor", "monitor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gala_monitor_clone_signals[GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_MONITOR_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
}

static void
gala_monitor_clone_instance_init (GalaMonitorClone * self,
                                  gpointer klass)
{
	self->priv = gala_monitor_clone_get_instance_private (self);
}

static void
gala_monitor_clone_finalize (GObject * obj)
{
	GalaMonitorClone * self;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	guint _tmp3_;
	MetaDisplay* _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	g_signal_parse_name ("window-entered-monitor", meta_display_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gala_monitor_clone_window_entered_meta_display_window_entered_monitor, self);
	_tmp4_ = display;
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gala_monitor_clone_window_left_meta_display_window_left_monitor, self);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->window_container);
	_g_object_unref0 (self->priv->background);
	G_OBJECT_CLASS (gala_monitor_clone_parent_class)->finalize (obj);
}

/**
 * More or less utility class to contain a WindowCloneContainer for each
 * non-primary monitor. It's the pendant to the WorkspaceClone which is
 * only placed on the primary monitor. It also draws a wallpaper behind itself
 * as the WindowGroup is hidden while the view is active. Only used when
 * workspaces-only-on-primary is set to true.
 */
 G_GNUC_NO_INLINE static GType
gala_monitor_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaMonitorCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_monitor_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaMonitorClone), 0, (GInstanceInitFunc) gala_monitor_clone_instance_init, NULL };
	GType gala_monitor_clone_type_id;
	gala_monitor_clone_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaMonitorClone", &g_define_type_info, 0);
	GalaMonitorClone_private_offset = g_type_add_instance_private (gala_monitor_clone_type_id, sizeof (GalaMonitorClonePrivate));
	return gala_monitor_clone_type_id;
}

GType
gala_monitor_clone_get_type (void)
{
	static gsize gala_monitor_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_monitor_clone_type_id__once)) {
		GType gala_monitor_clone_type_id;
		gala_monitor_clone_type_id = gala_monitor_clone_get_type_once ();
		g_once_init_leave (&gala_monitor_clone_type_id__once, gala_monitor_clone_type_id);
	}
	return gala_monitor_clone_type_id__once;
}

static void
_vala_gala_monitor_clone_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GalaMonitorClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	switch (property_id) {
		case GALA_MONITOR_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_monitor_clone_get_wm (self));
		break;
		case GALA_MONITOR_CLONE_MONITOR_PROPERTY:
		g_value_set_int (value, gala_monitor_clone_get_monitor (self));
		break;
		case GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_monitor_clone_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_monitor_clone_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GalaMonitorClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	switch (property_id) {
		case GALA_MONITOR_CLONE_WM_PROPERTY:
		gala_monitor_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_MONITOR_CLONE_MONITOR_PROPERTY:
		gala_monitor_clone_set_monitor (self, g_value_get_int (value));
		break;
		case GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY:
		gala_monitor_clone_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

