/* PixelPicker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PixelPicker.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2020 elementary, Inc. (https://elementary.io)
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <graphene-gobject.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/common.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_PIXEL_PICKER (gala_pixel_picker_get_type ())
#define GALA_PIXEL_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PIXEL_PICKER, GalaPixelPicker))
#define GALA_PIXEL_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PIXEL_PICKER, GalaPixelPickerClass))
#define GALA_IS_PIXEL_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PIXEL_PICKER))
#define GALA_IS_PIXEL_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PIXEL_PICKER))
#define GALA_PIXEL_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PIXEL_PICKER, GalaPixelPickerClass))

typedef struct _GalaPixelPicker GalaPixelPicker;
typedef struct _GalaPixelPickerClass GalaPixelPickerClass;
typedef struct _GalaPixelPickerPrivate GalaPixelPickerPrivate;
enum  {
	GALA_PIXEL_PICKER_0_PROPERTY,
	GALA_PIXEL_PICKER_WM_PROPERTY,
	GALA_PIXEL_PICKER_CANCELLED_PROPERTY,
	GALA_PIXEL_PICKER_POINT_PROPERTY,
	GALA_PIXEL_PICKER_NUM_PROPERTIES
};
static GParamSpec* gala_pixel_picker_properties[GALA_PIXEL_PICKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_PIXEL_PICKER_CLOSED_SIGNAL,
	GALA_PIXEL_PICKER_NUM_SIGNALS
};
static guint gala_pixel_picker_signals[GALA_PIXEL_PICKER_NUM_SIGNALS] = {0};

struct _GalaPixelPicker {
	ClutterActor parent_instance;
	GalaPixelPickerPrivate * priv;
};

struct _GalaPixelPickerClass {
	ClutterActorClass parent_class;
};

struct _GalaPixelPickerPrivate {
	GalaWindowManager* _wm;
	gboolean _cancelled;
	graphene_point_t _point;
	GalaModalProxy* modal_proxy;
};

static gint GalaPixelPicker_private_offset;
static gpointer gala_pixel_picker_parent_class = NULL;

VALA_EXTERN GType gala_pixel_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPixelPicker, g_object_unref)
VALA_EXTERN GalaPixelPicker* gala_pixel_picker_new (GalaWindowManager* wm);
VALA_EXTERN GalaPixelPicker* gala_pixel_picker_construct (GType object_type,
                                              GalaWindowManager* wm);
static gboolean gala_pixel_picker_real_key_press_event (ClutterActor* base,
                                                 ClutterEvent* e);
static void gala_pixel_picker_set_cancelled (GalaPixelPicker* self,
                                      gboolean value);
static void gala_pixel_picker_close (GalaPixelPicker* self);
static gboolean gala_pixel_picker_real_button_release_event (ClutterActor* base,
                                                      ClutterEvent* e);
static void gala_pixel_picker_set_point (GalaPixelPicker* self,
                                  graphene_point_t * value);
VALA_EXTERN GalaWindowManager* gala_pixel_picker_get_wm (GalaPixelPicker* self);
VALA_EXTERN void gala_pixel_picker_start_selection (GalaPixelPicker* self);
static void gala_pixel_picker_set_wm (GalaPixelPicker* self,
                               GalaWindowManager* value);
VALA_EXTERN gboolean gala_pixel_picker_get_cancelled (GalaPixelPicker* self);
VALA_EXTERN void gala_pixel_picker_get_point (GalaPixelPicker* self,
                                  graphene_point_t * result);
static gboolean _graphene_point_equal (const graphene_point_t * s1,
                                const graphene_point_t * s2);
static GObject * gala_pixel_picker_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void gala_pixel_picker_finalize (GObject * obj);
static GType gala_pixel_picker_get_type_once (void);
static void _vala_gala_pixel_picker_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_pixel_picker_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_pixel_picker_get_instance_private (GalaPixelPicker* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPixelPicker_private_offset);
}

GalaPixelPicker*
gala_pixel_picker_construct (GType object_type,
                             GalaWindowManager* wm)
{
	GalaPixelPicker * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaPixelPicker*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaPixelPicker*
gala_pixel_picker_new (GalaWindowManager* wm)
{
	return gala_pixel_picker_construct (GALA_TYPE_PIXEL_PICKER, wm);
}

static gboolean
gala_pixel_picker_real_key_press_event (ClutterActor* base,
                                        ClutterEvent* e)
{
	GalaPixelPicker * self;
	gboolean result;
	self = (GalaPixelPicker*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (clutter_event_get_key_symbol (e) == CLUTTER_KEY_Escape) {
		gala_pixel_picker_set_cancelled (self, TRUE);
		gala_pixel_picker_close (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gala_pixel_picker_real_button_release_event (ClutterActor* base,
                                             ClutterEvent* e)
{
	GalaPixelPicker * self;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	graphene_point_t _tmp2_ = {0};
	gboolean result;
	self = (GalaPixelPicker*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (clutter_event_get_button (e) != CLUTTER_BUTTON_PRIMARY) {
		result = TRUE;
		return result;
	}
	clutter_event_get_coords (e, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	memset (&_tmp2_, 0, sizeof (graphene_point_t));
	_tmp2_.x = x;
	_tmp2_.y = y;
	gala_pixel_picker_set_point (self, &_tmp2_);
	clutter_actor_hide ((ClutterActor*) self);
	gala_pixel_picker_close (self);
	result = TRUE;
	return result;
}

static void
gala_pixel_picker_close (GalaPixelPicker* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaModalProxy* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_DEFAULT);
	_tmp2_ = self->priv->modal_proxy;
	if (_tmp2_ != NULL) {
		GalaWindowManager* _tmp3_;
		GalaModalProxy* _tmp4_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp3_, _tmp4_);
	}
	g_signal_emit (self, gala_pixel_picker_signals[GALA_PIXEL_PICKER_CLOSED_SIGNAL], 0);
}

void
gala_pixel_picker_start_selection (GalaPixelPicker* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowManager* _tmp2_;
	GalaModalProxy* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_CROSSHAIR);
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_window_manager_push_modal (_tmp2_, (ClutterActor*) self);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp3_;
}

GalaWindowManager*
gala_pixel_picker_get_wm (GalaPixelPicker* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_pixel_picker_set_wm (GalaPixelPicker* self,
                          GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_pixel_picker_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_pixel_picker_properties[GALA_PIXEL_PICKER_WM_PROPERTY]);
	}
}

gboolean
gala_pixel_picker_get_cancelled (GalaPixelPicker* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_cancelled;
	return result;
}

static void
gala_pixel_picker_set_cancelled (GalaPixelPicker* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_pixel_picker_get_cancelled (self);
	if (old_value != value) {
		self->priv->_cancelled = value;
		g_object_notify_by_pspec ((GObject *) self, gala_pixel_picker_properties[GALA_PIXEL_PICKER_CANCELLED_PROPERTY]);
	}
}

void
gala_pixel_picker_get_point (GalaPixelPicker* self,
                             graphene_point_t * result)
{
	graphene_point_t _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_point;
	*result = _tmp0_;
	return;
}

static gboolean
_graphene_point_equal (const graphene_point_t * s1,
                       const graphene_point_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	return TRUE;
}

static void
gala_pixel_picker_set_point (GalaPixelPicker* self,
                             graphene_point_t * value)
{
	graphene_point_t old_value;
	g_return_if_fail (self != NULL);
	gala_pixel_picker_get_point (self, &old_value);
	if (_graphene_point_equal (value, &old_value) != TRUE) {
		graphene_point_t _tmp0_;
		_tmp0_ = *value;
		self->priv->_point = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_pixel_picker_properties[GALA_PIXEL_PICKER_POINT_PROPERTY]);
	}
}

static GObject *
gala_pixel_picker_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPixelPicker * self;
	graphene_point_t _tmp0_;
	gint screen_width = 0;
	gint screen_height = 0;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	parent_class = G_OBJECT_CLASS (gala_pixel_picker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PIXEL_PICKER, GalaPixelPicker);
	_tmp0_ = self->priv->_point;
	graphene_point_init (&_tmp0_, (gfloat) 0, (gfloat) 0);
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	meta_display_get_size (_tmp2_, &_tmp3_, &_tmp4_);
	screen_width = _tmp3_;
	screen_height = _tmp4_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) screen_width);
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) screen_height);
	return obj;
}

static void
gala_pixel_picker_class_init (GalaPixelPickerClass * klass,
                              gpointer klass_data)
{
	gala_pixel_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPixelPicker_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_pixel_picker_real_key_press_event;
	((ClutterActorClass *) klass)->button_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_pixel_picker_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_pixel_picker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_pixel_picker_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_pixel_picker_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_pixel_picker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PIXEL_PICKER_WM_PROPERTY, gala_pixel_picker_properties[GALA_PIXEL_PICKER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PIXEL_PICKER_CANCELLED_PROPERTY, gala_pixel_picker_properties[GALA_PIXEL_PICKER_CANCELLED_PROPERTY] = g_param_spec_boolean ("cancelled", "cancelled", "cancelled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PIXEL_PICKER_POINT_PROPERTY, gala_pixel_picker_properties[GALA_PIXEL_PICKER_POINT_PROPERTY] = g_param_spec_boxed ("point", "point", "point", graphene_point_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_pixel_picker_signals[GALA_PIXEL_PICKER_CLOSED_SIGNAL] = g_signal_new ("closed", GALA_TYPE_PIXEL_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_pixel_picker_instance_init (GalaPixelPicker * self,
                                 gpointer klass)
{
	self->priv = gala_pixel_picker_get_instance_private (self);
}

static void
gala_pixel_picker_finalize (GObject * obj)
{
	GalaPixelPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PIXEL_PICKER, GalaPixelPicker);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->modal_proxy);
	G_OBJECT_CLASS (gala_pixel_picker_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_pixel_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPixelPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_pixel_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPixelPicker), 0, (GInstanceInitFunc) gala_pixel_picker_instance_init, NULL };
	GType gala_pixel_picker_type_id;
	gala_pixel_picker_type_id = g_type_register_static (clutter_actor_get_type (), "GalaPixelPicker", &g_define_type_info, 0);
	GalaPixelPicker_private_offset = g_type_add_instance_private (gala_pixel_picker_type_id, sizeof (GalaPixelPickerPrivate));
	return gala_pixel_picker_type_id;
}

GType
gala_pixel_picker_get_type (void)
{
	static gsize gala_pixel_picker_type_id__once = 0;
	if (g_once_init_enter (&gala_pixel_picker_type_id__once)) {
		GType gala_pixel_picker_type_id;
		gala_pixel_picker_type_id = gala_pixel_picker_get_type_once ();
		g_once_init_leave (&gala_pixel_picker_type_id__once, gala_pixel_picker_type_id);
	}
	return gala_pixel_picker_type_id__once;
}

static void
_vala_gala_pixel_picker_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaPixelPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PIXEL_PICKER, GalaPixelPicker);
	switch (property_id) {
		case GALA_PIXEL_PICKER_WM_PROPERTY:
		g_value_set_object (value, gala_pixel_picker_get_wm (self));
		break;
		case GALA_PIXEL_PICKER_CANCELLED_PROPERTY:
		g_value_set_boolean (value, gala_pixel_picker_get_cancelled (self));
		break;
		case GALA_PIXEL_PICKER_POINT_PROPERTY:
		{
			graphene_point_t boxed;
			gala_pixel_picker_get_point (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_pixel_picker_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaPixelPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PIXEL_PICKER, GalaPixelPicker);
	switch (property_id) {
		case GALA_PIXEL_PICKER_WM_PROPERTY:
		gala_pixel_picker_set_wm (self, g_value_get_object (value));
		break;
		case GALA_PIXEL_PICKER_CANCELLED_PROPERTY:
		gala_pixel_picker_set_cancelled (self, g_value_get_boolean (value));
		break;
		case GALA_PIXEL_PICKER_POINT_PROPERTY:
		gala_pixel_picker_set_point (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

