/* gitg-resource.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-resource.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GitgParamSpecResource GitgParamSpecResource;

struct _GitgParamSpecResource {
	GParamSpec parent_instance;
};

static gpointer gitg_resource_parent_class = NULL;

static void gitg_resource_finalize (GitgResource * obj);
static GType gitg_resource_get_type_once (void);

GtkCssProvider*
gitg_resource_load_css (const gchar* id)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GFile* f = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	GtkCssProvider* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	_tmp1_ = g_strconcat ("resource:///org/gnome/gitg/ui/", id, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	f = _tmp4_;
	{
		GtkCssProvider* _tmp5_;
		GFile* _tmp6_;
		_tmp5_ = provider;
		_tmp6_ = f;
		gtk_css_provider_load_from_file (_tmp5_, _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("gitg-resource.vala:33: Error while loading resource: %s", _tmp8_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (f);
		_g_object_unref0 (provider);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (f);
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = provider;
	_g_object_unref0 (f);
	return result;
}

GitgResource*
gitg_resource_construct (GType object_type)
{
	GitgResource* self = NULL;
	self = (GitgResource*) g_type_create_instance (object_type);
	return self;
}

GitgResource*
gitg_resource_new (void)
{
	return gitg_resource_construct (GITG_TYPE_RESOURCE);
}

static void
gitg_value_resource_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_value_resource_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_resource_unref (value->data[0].v_pointer);
	}
}

static void
gitg_value_resource_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_resource_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_value_resource_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_value_resource_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgResource * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_resource_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_value_resource_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	GitgResource ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_resource_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gitg_param_spec_resource (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	GitgParamSpecResource* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_RESOURCE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gitg_value_get_resource (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_RESOURCE), NULL);
	return value->data[0].v_pointer;
}

void
gitg_value_set_resource (GValue* value,
                         gpointer v_object)
{
	GitgResource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_RESOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_RESOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_resource_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_resource_unref (old);
	}
}

void
gitg_value_take_resource (GValue* value,
                          gpointer v_object)
{
	GitgResource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_RESOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_RESOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_resource_unref (old);
	}
}

static void
gitg_resource_class_init (GitgResourceClass * klass,
                          gpointer klass_data)
{
	gitg_resource_parent_class = g_type_class_peek_parent (klass);
	((GitgResourceClass *) klass)->finalize = gitg_resource_finalize;
}

static void
gitg_resource_instance_init (GitgResource * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_resource_finalize (GitgResource * obj)
{
	GitgResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_RESOURCE, GitgResource);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gitg_resource_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_value_resource_init, gitg_value_resource_free_value, gitg_value_resource_copy_value, gitg_value_resource_peek_pointer, "p", gitg_value_resource_collect_value, "p", gitg_value_resource_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgResource), 0, (GInstanceInitFunc) gitg_resource_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_resource_type_id;
	gitg_resource_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgResource", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_resource_type_id;
}

GType
gitg_resource_get_type (void)
{
	static gsize gitg_resource_type_id__once = 0;
	if (g_once_init_enter (&gitg_resource_type_id__once)) {
		GType gitg_resource_type_id;
		gitg_resource_type_id = gitg_resource_get_type_once ();
		g_once_init_leave (&gitg_resource_type_id__once, gitg_resource_type_id);
	}
	return gitg_resource_type_id__once;
}

gpointer
gitg_resource_ref (gpointer instance)
{
	GitgResource * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gitg_resource_unref (gpointer instance)
{
	GitgResource * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_RESOURCE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

