/* game-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-window.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <glib.h>
#include <libgnome-games-support.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>

#define GAME_WINDOW_WINDOW_MINIMUM_SIZE_HEIGHT 350
#define GAME_WINDOW_WINDOW_MINIMUM_SIZE_WIDTH 350
#define GAME_WINDOW_tiled_state ((((GDK_WINDOW_STATE_TILED | GDK_WINDOW_STATE_TOP_TILED) | GDK_WINDOW_STATE_BOTTOM_TILED) | GDK_WINDOW_STATE_LEFT_TILED) | GDK_WINDOW_STATE_RIGHT_TILED)
#define GAME_WINDOW_KEYCODE_W ((guint16) 25)
#define GAME_WINDOW_KEYCODE_A ((guint16) 38)
#define GAME_WINDOW_KEYCODE_S ((guint16) 39)
#define GAME_WINDOW_KEYCODE_D ((guint16) 40)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;

#define TYPE_GAME_HEADER_BAR (game_header_bar_get_type ())
#define GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBar))
#define GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))
#define IS_GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_HEADER_BAR))
#define IS_GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_HEADER_BAR))
#define GAME_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))

typedef struct _GameHeaderBar GameHeaderBar;
typedef struct _GameHeaderBarClass GameHeaderBarClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	GAME_WINDOW_0_PROPERTY,
	GAME_WINDOW_CLI_COLS_PROPERTY,
	GAME_WINDOW_CLI_ROWS_PROPERTY,
	GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* game_window_properties[GAME_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TWENTY_FORTY_EIGHT (twenty_forty_eight_get_type ())
#define TWENTY_FORTY_EIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEight))
#define TWENTY_FORTY_EIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEightClass))
#define IS_TWENTY_FORTY_EIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWENTY_FORTY_EIGHT))
#define IS_TWENTY_FORTY_EIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWENTY_FORTY_EIGHT))
#define TWENTY_FORTY_EIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEightClass))

typedef struct _TwentyFortyEight TwentyFortyEight;
typedef struct _TwentyFortyEightClass TwentyFortyEightClass;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef enum  {
	MOVE_REQUEST_UP,
	MOVE_REQUEST_RIGHT,
	MOVE_REQUEST_DOWN,
	MOVE_REQUEST_LEFT
} MoveRequest;

#define TYPE_MOVE_REQUEST (move_request_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GameWindowPrivate {
	GSettings* _settings;
	GameHeaderBar* _header_bar;
	GtkClutterEmbed* _embed;
	GtkButton* _unfullscreen_button;
	Game* _game;
	guint8 _cli_cols;
	guint8 _cli_rows;
	gint _window_width;
	gint _window_height;
	gboolean _window_is_maximized;
	gboolean _window_is_fullscreen;
	gboolean _window_is_tiled;
	GSimpleAction* undo_action;
	GtkEventControllerKey* key_controller;
	GtkGestureSwipe* gesture_swipe;
	GtkMessageDialog* _congrats_dialog;
	gboolean _should_create_congrats_dialog;
	GamesScoresContext* _scores_ctx;
	GamesScoresCategory* _grid4_cat;
	GamesScoresCategory* _grid3_cat;
	GamesScoresCategory* _grid5_cat;
};

static gint GameWindow_private_offset;
static gpointer game_window_parent_class = NULL;

VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType game_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHeaderBar, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
static void game_window_undo_cb (GameWindow* self);
static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_new_game_cb (GameWindow* self);
static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void game_window_new_game_sized_cb (GameWindow* self,
                                    GSimpleAction* action,
                                    GVariant* variant);
static void _game_window_new_game_sized_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void game_window_toggle_new_game_cb (GameWindow* self);
static void _game_window_toggle_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void game_window_toggle_hamburger_menu (GameWindow* self);
static void _game_window_toggle_hamburger_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static inline void game_window_scores_cb (GameWindow* self);
static void _game_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void game_window_about_cb (GameWindow* self);
static void _game_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void _gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
VALA_EXTERN GType twenty_forty_eight_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TwentyFortyEight, g_object_unref)
VALA_EXTERN GameWindow* game_window_new (TwentyFortyEight* application,
                             guint8 cols,
                             guint8 rows);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   TwentyFortyEight* application,
                                   guint8 cols,
                                   guint8 rows);
VALA_EXTERN gboolean game_restore_game (Game* self,
                            GSettings** settings);
static inline void _game_window_init_keyboard (GameWindow* self);
static inline void _game_window_init_gestures (GameWindow* self);
static void game_window_on_destroy (GameWindow* self);
VALA_EXTERN void game_save_game (Game* self);
static void _game_window_save_window_state (GameWindow* _this,
                                     GSettings** _settings);
static void _game_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                 gpointer self);
static void _game_window_init_game (GameWindow* self);
static guint8 game_window_get_cli_cols (GameWindow* self);
static guint8 game_window_get_cli_rows (GameWindow* self);
VALA_EXTERN Game* game_new (GSettings** settings);
VALA_EXTERN Game* game_construct (GType object_type,
                      GSettings** settings);
VALA_EXTERN void game_header_bar_set_score (GameHeaderBar* self,
                                GObject* game,
                                GParamSpec* unused);
static void _game_header_bar_set_score_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self);
static void __lambda4_ (GameWindow* self,
                 gboolean show_scores);
VALA_EXTERN void game_header_bar_finished (GameHeaderBar* self);
static inline void _game_window_show_best_scores (GameWindow* self);
static void ___lambda4__game_finished (Game* _sender,
                                gboolean show_scores,
                                gpointer self);
static inline void game_window_target_value_reached_cb (GameWindow* self,
                                          guint target_value);
static void _game_window_target_value_reached_cb_game_target_value_reached (Game* _sender,
                                                                     guint val,
                                                                     gpointer self);
static void __lambda8_ (GameWindow* self);
static void ___lambda8__game_undo_enabled (Game* _sender,
                                    gpointer self);
static void __lambda9_ (GameWindow* self);
static void ___lambda9__game_undo_disabled (Game* _sender,
                                     gpointer self);
static void _game_window_init_window (GameWindow* self);
static void _game_window_init_window_state (GameWindow* _this);
static void _game_window_load_window_state (GameWindow* _this,
                                     GSettings** _settings);
static void __lambda10_ (GameWindow* self);
static void ___lambda10__game_header_bar_popover_closed (GameHeaderBar* _sender,
                                                  gpointer self);
static void __lambda11_ (GameWindow* self,
                  GSettings* settings,
                  const gchar* key_name);
VALA_EXTERN void _game_header_bar_update_new_game_menu (GameHeaderBar* self,
                                            guint8 rows,
                                            guint8 cols);
VALA_EXTERN void _game_header_bar_update_hamburger_menu (GameHeaderBar* self,
                                             gboolean allow_undo);
VALA_EXTERN void game_load_settings (Game* self,
                         GSettings** settings);
static void ___lambda11__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
VALA_EXTERN void game_set_view (Game* self,
                    ClutterActor* value);
static gboolean game_window_state_event_cb (GtkWidget* widget,
                                     GdkEventWindowState* event);
static gboolean _game_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                    GdkEventWindowState* event,
                                                                    gpointer self);
static void game_window_size_allocate_cb (GtkWidget* widget,
                                   GtkAllocation* allocation);
static void _game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                             GtkAllocation* allocation,
                                                             gpointer self);
static gint* _int_dup (gint* self);
static void _game_window_install_ui_action_entries (GameWindow* self);
VALA_EXTERN void game_header_bar_clear_subtitle (GameHeaderBar* self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_new_game (Game* self,
                    GSettings** settings);
VALA_EXTERN void game_header_bar_toggle_new_game (GameHeaderBar* self);
VALA_EXTERN void game_header_bar_toggle_hamburger_menu (GameHeaderBar* self);
static inline gboolean game_window_on_key_pressed (GtkEventControllerKey* _key_controller,
                                     guint keyval,
                                     guint keycode,
                                     GdkModifierType state);
static gboolean _game_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self);
VALA_EXTERN gboolean game_header_bar_has_popover (GameHeaderBar* self);
VALA_EXTERN gboolean game_cannot_move (Game* self);
VALA_EXTERN GType move_request_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void game_move (Game* self,
                MoveRequest request);
static inline guint _game_window_upper_key (guint keyval);
static inline void _game_window_on_swipe (GameWindow* self,
                            GtkGestureSwipe* _gesture_swipe,
                            gdouble velocity_x,
                            gdouble velocity_y);
static void __game_window_on_swipe_gtk_gesture_swipe_swipe (GtkGestureSwipe* _sender,
                                                     gdouble velocity_x,
                                                     gdouble velocity_y,
                                                     gpointer self);
static inline void _game_window_create_congrats_dialog (GameWindow* self);
static void __lambda6_ (GameWindow* self,
                 gint response_id);
static void ___lambda6__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static gboolean __lambda7_ (GameWindow* self,
                     GdkEventAny* response_id);
static gboolean ___lambda7__gtk_widget_delete_event (GtkWidget* _sender,
                                              GdkEventAny* event,
                                              gpointer self);
static inline void _game_window_create_scores_dialog (GameWindow* self);
static inline GamesScoresCategory* game_window_category_request (GameWindow* self,
                                                   const gchar* key);
static GamesScoresCategory* _game_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                               gpointer self);
VALA_EXTERN glong game_get_score (Game* self);
static void __lambda5_ (GameWindow* self,
                 GObject* object,
                 GAsyncResult* _result_);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void game_window_set_cli_cols (GameWindow* self,
                               guint8 value);
static void game_window_set_cli_rows (GameWindow* self,
                               guint8 value);
static GObject * game_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _game_window___lambda12_ (GameWindow* self);
static void __game_window___lambda12__g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static void game_window_finalize (GObject * obj);
static GType game_window_get_type_once (void);
static void _vala_game_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_game_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry GAME_WINDOW__ui_action_entries[8] = {{"undo", _game_window_undo_cb_gsimple_action_activate_callback}, {"new-game", _game_window_new_game_cb_gsimple_action_activate_callback}, {"new-game-sized", _game_window_new_game_sized_cb_gsimple_action_activate_callback, "(yy)"}, {"toggle-new-game", _game_window_toggle_new_game_cb_gsimple_action_activate_callback}, {"toggle-hamburger", _game_window_toggle_hamburger_menu_gsimple_action_activate_callback}, {"scores", _game_window_scores_cb_gsimple_action_activate_callback}, {"about", _game_window_about_cb_gsimple_action_activate_callback}, {"unfullscreen", _gtk_window_unfullscreen_gsimple_action_activate_callback}};

static inline gpointer
game_window_get_instance_private (GameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GameWindow_private_offset);
}

static void
_game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_undo_cb ((GameWindow*) self);
}

static void
_game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	game_window_new_game_cb ((GameWindow*) self);
}

static void
_game_window_new_game_sized_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	game_window_new_game_sized_cb ((GameWindow*) self, action, parameter);
}

static void
_game_window_toggle_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	game_window_toggle_new_game_cb ((GameWindow*) self);
}

static void
_game_window_toggle_hamburger_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	game_window_toggle_hamburger_menu ((GameWindow*) self);
}

static void
_game_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	game_window_scores_cb ((GameWindow*) self);
}

static void
_game_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	game_window_about_cb ((GameWindow*) self);
}

static void
_gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	gtk_window_unfullscreen ((GtkWindow*) self);
}

GameWindow*
game_window_construct (GType object_type,
                       TwentyFortyEight* application,
                       guint8 cols,
                       guint8 rows)
{
	GameWindow * self = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (application != NULL, NULL);
	self = (GameWindow*) g_object_new (object_type, "application", application, "visible", TRUE, "cli-cols", cols, "cli-rows", rows, NULL);
	if (((gint) cols) != 0) {
		_tmp0_ = ((gint) rows) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		game_window_new_game_cb (self);
	} else {
		Game* _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = self->priv->_game;
		_tmp2_ = game_restore_game (_tmp1_, &self->priv->_settings);
		if (!_tmp2_) {
			game_window_new_game_cb (self);
		}
	}
	_game_window_init_keyboard (self);
	_game_window_init_gestures (self);
	return self;
}

GameWindow*
game_window_new (TwentyFortyEight* application,
                 guint8 cols,
                 guint8 rows)
{
	return game_window_construct (TYPE_GAME_WINDOW, application, cols, rows);
}

static void
game_window_on_destroy (GameWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	game_save_game (_tmp0_);
	_game_window_save_window_state (self, &self->priv->_settings);
	GTK_WIDGET_CLASS (game_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
}

static void
_game_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                            gpointer self)
{
	game_window_on_destroy ((GameWindow*) self);
}

static void
_game_header_bar_set_score_g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self)
{
	game_header_bar_set_score ((GameHeaderBar*) self, _sender, pspec);
}

static void
__lambda4_ (GameWindow* self,
            gboolean show_scores)
{
	GameHeaderBar* _tmp0_;
	_tmp0_ = self->priv->_header_bar;
	game_header_bar_finished (_tmp0_);
	if (show_scores) {
		_game_window_show_best_scores (self);
	}
	g_debug ("game-window.vala:98: finished");
}

static void
___lambda4__game_finished (Game* _sender,
                           gboolean show_scores,
                           gpointer self)
{
	__lambda4_ ((GameWindow*) self, show_scores);
}

static void
_game_window_target_value_reached_cb_game_target_value_reached (Game* _sender,
                                                                guint val,
                                                                gpointer self)
{
	game_window_target_value_reached_cb ((GameWindow*) self, val);
}

static void
__lambda8_ (GameWindow* self)
{
	GSimpleAction* _tmp0_;
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
}

static void
___lambda8__game_undo_enabled (Game* _sender,
                               gpointer self)
{
	__lambda8_ ((GameWindow*) self);
}

static void
__lambda9_ (GameWindow* self)
{
	GSimpleAction* _tmp0_;
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
}

static void
___lambda9__game_undo_disabled (Game* _sender,
                                gpointer self)
{
	__lambda9_ ((GameWindow*) self);
}

static void
_game_window_init_game (GameWindow* self)
{
	gboolean _tmp0_ = FALSE;
	guint8 _tmp1_;
	Game* _tmp9_;
	Game* _tmp10_;
	GameHeaderBar* _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	Game* _tmp14_;
	Game* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_cli_cols;
	if (((gint) _tmp1_) != 0) {
		guint8 _tmp2_;
		_tmp2_ = self->priv->_cli_rows;
		_tmp0_ = ((gint) _tmp2_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		guint8 _tmp5_;
		GSettings* _tmp6_;
		guint8 _tmp7_;
		GSettings* _tmp8_;
		_tmp3_ = self->priv->_settings;
		g_settings_delay (_tmp3_);
		_tmp4_ = self->priv->_settings;
		_tmp5_ = self->priv->_cli_cols;
		g_settings_set_int (_tmp4_, "cols", (gint) _tmp5_);
		_tmp6_ = self->priv->_settings;
		_tmp7_ = self->priv->_cli_rows;
		g_settings_set_int (_tmp6_, "rows", (gint) _tmp7_);
		_tmp8_ = self->priv->_settings;
		g_settings_apply (_tmp8_);
		g_settings_sync ();
	}
	_tmp9_ = game_new (&self->priv->_settings);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp9_;
	_tmp10_ = self->priv->_game;
	_tmp11_ = self->priv->_header_bar;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::score", (GCallback) _game_header_bar_set_score_g_object_notify, _tmp11_, 0);
	_tmp12_ = self->priv->_game;
	g_signal_connect_object (_tmp12_, "finished", (GCallback) ___lambda4__game_finished, self, 0);
	_tmp13_ = self->priv->_game;
	g_signal_connect_object (_tmp13_, "target-value-reached", (GCallback) _game_window_target_value_reached_cb_game_target_value_reached, self, 0);
	_tmp14_ = self->priv->_game;
	g_signal_connect_object (_tmp14_, "undo-enabled", (GCallback) ___lambda8__game_undo_enabled, self, 0);
	_tmp15_ = self->priv->_game;
	g_signal_connect_object (_tmp15_, "undo-disabled", (GCallback) ___lambda9__game_undo_disabled, self, 0);
}

static void
__lambda10_ (GameWindow* self)
{
	GtkClutterEmbed* _tmp0_;
	_tmp0_ = self->priv->_embed;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
___lambda10__game_header_bar_popover_closed (GameHeaderBar* _sender,
                                             gpointer self)
{
	__lambda10_ ((GameWindow*) self);
}

static void
__lambda11_ (GameWindow* self,
             GSettings* settings,
             const gchar* key_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key_name != NULL);
	_tmp0_ = key_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("cols")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("rows"))))) {
		switch (0) {
			default:
			{
				GameHeaderBar* _tmp3_;
				GSettings* _tmp4_;
				GSettings* _tmp5_;
				_tmp3_ = self->priv->_header_bar;
				_tmp4_ = self->priv->_settings;
				_tmp5_ = self->priv->_settings;
				_game_header_bar_update_new_game_menu (_tmp3_, (guint8) g_settings_get_int (_tmp4_, "rows"), (guint8) g_settings_get_int (_tmp5_, "cols"));
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("allow-undo")))) {
		switch (0) {
			default:
			{
				GameHeaderBar* _tmp6_;
				GSettings* _tmp7_;
				Game* _tmp8_;
				_tmp6_ = self->priv->_header_bar;
				_tmp7_ = self->priv->_settings;
				_game_header_bar_update_hamburger_menu (_tmp6_, g_settings_get_boolean (_tmp7_, "allow-undo"));
				_tmp8_ = self->priv->_game;
				game_load_settings (_tmp8_, &self->priv->_settings);
				return;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("allow-undo-max")))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("animations-speed"))))) {
		switch (0) {
			default:
			{
				Game* _tmp9_;
				_tmp9_ = self->priv->_game;
				game_load_settings (_tmp9_, &self->priv->_settings);
				return;
			}
		}
	}
}

static void
___lambda11__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda11_ ((GameWindow*) self, _sender, key);
}

static void
_game_window_init_window (GameWindow* self)
{
	GameHeaderBar* _tmp0_;
	GSettings* _tmp1_;
	GameHeaderBar* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GameHeaderBar* _tmp5_;
	GSettings* _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	GtkClutterEmbed* _tmp9_;
	ClutterActor* _tmp10_;
	g_return_if_fail (self != NULL);
	_game_window_init_window_state (self);
	_game_window_load_window_state (self, &self->priv->_settings);
	_tmp0_ = self->priv->_header_bar;
	g_signal_connect_object (_tmp0_, "popover-closed", (GCallback) ___lambda10__game_header_bar_popover_closed, self, 0);
	_tmp1_ = self->priv->_settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) ___lambda11__g_settings_changed, self, 0);
	_tmp2_ = self->priv->_header_bar;
	_tmp3_ = self->priv->_settings;
	_tmp4_ = self->priv->_settings;
	_game_header_bar_update_new_game_menu (_tmp2_, (guint8) g_settings_get_int (_tmp3_, "rows"), (guint8) g_settings_get_int (_tmp4_, "cols"));
	_tmp5_ = self->priv->_header_bar;
	_tmp6_ = self->priv->_settings;
	_game_header_bar_update_hamburger_menu (_tmp5_, g_settings_get_boolean (_tmp6_, "allow-undo"));
	_tmp7_ = self->priv->_game;
	game_load_settings (_tmp7_, &self->priv->_settings);
	_tmp8_ = self->priv->_game;
	_tmp9_ = self->priv->_embed;
	_tmp10_ = gtk_clutter_embed_get_stage (_tmp9_);
	game_set_view (_tmp8_, _tmp10_);
	gtk_widget_set_events ((GtkWidget*) self, ((gtk_widget_get_events ((GtkWidget*) self) | GDK_STRUCTURE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK);
}

static gboolean
_game_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                           GdkEventWindowState* event,
                                                           gpointer self)
{
	gboolean result;
	result = game_window_state_event_cb (_sender, event);
	return result;
}

static void
_game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                        GtkAllocation* allocation,
                                                        gpointer self)
{
	game_window_size_allocate_cb (_sender, allocation);
}

static void
_game_window_init_window_state (GameWindow* _this)
{
	GdkGeometry geom = {0};
	GdkGeometry _tmp0_;
	g_return_if_fail (_this != NULL);
	g_signal_connect ((GtkWidget*) _this, "window-state-event", (GCallback) _game_window_state_event_cb_gtk_widget_window_state_event, NULL);
	g_signal_connect ((GtkWidget*) _this, "size-allocate", (GCallback) _game_window_size_allocate_cb_gtk_widget_size_allocate, NULL);
	memset (&geom, 0, sizeof (GdkGeometry));
	geom.min_height = GAME_WINDOW_WINDOW_MINIMUM_SIZE_HEIGHT;
	geom.min_width = GAME_WINDOW_WINDOW_MINIMUM_SIZE_WIDTH;
	_tmp0_ = geom;
	gtk_window_set_geometry_hints ((GtkWindow*) _this, (GtkWidget*) _this, &_tmp0_, GDK_HINT_MIN_SIZE);
}

static void
_game_window_load_window_state (GameWindow* _this,
                                GSettings** _settings)
{
	g_return_if_fail (_this != NULL);
	g_return_if_fail (*_settings != NULL);
	gtk_window_set_default_size ((GtkWindow*) _this, g_settings_get_int (*_settings, "window-width"), g_settings_get_int (*_settings, "window-height"));
	if (g_settings_get_boolean (*_settings, "window-maximized")) {
		gtk_window_maximize ((GtkWindow*) _this);
	}
}

static void
_game_window_save_window_state (GameWindow* _this,
                                GSettings** _settings)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (_this != NULL);
	g_return_if_fail (*_settings != NULL);
	g_settings_delay (*_settings);
	g_settings_set_int (*_settings, "window-width", _this->priv->_window_width);
	g_settings_set_int (*_settings, "window-height", _this->priv->_window_height);
	if (_this->priv->_window_is_maximized) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _this->priv->_window_is_fullscreen;
	}
	g_settings_set_boolean (*_settings, "window-maximized", _tmp0_);
	g_settings_apply (*_settings);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
game_window_size_allocate_cb (GtkWidget* widget,
                              GtkAllocation* allocation)
{
	GameWindow* _this = NULL;
	GameWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GameWindow* _tmp3_;
	gint* window_width = NULL;
	gint* window_height = NULL;
	GameWindow* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_;
	gint* _tmp10_;
	gint _tmp11_;
	gint* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gint* _tmp14_;
	GameWindow* _tmp16_;
	gint* _tmp17_;
	GameWindow* _tmp18_;
	gint* _tmp19_;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, TYPE_GAME_WINDOW, GameWindow));
	_this = _tmp0_;
	_tmp3_ = _this;
	if (_tmp3_->priv->_window_is_maximized) {
		_tmp2_ = TRUE;
	} else {
		GameWindow* _tmp4_;
		_tmp4_ = _this;
		_tmp2_ = _tmp4_->priv->_window_is_tiled;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GameWindow* _tmp5_;
		_tmp5_ = _this;
		_tmp1_ = _tmp5_->priv->_window_is_fullscreen;
	}
	if (_tmp1_) {
		_g_object_unref0 (_this);
		return;
	}
	window_width = NULL;
	window_height = NULL;
	_tmp6_ = _this;
	gtk_window_get_size ((GtkWindow*) _tmp6_, &_tmp7_, &_tmp8_);
	_g_free0 (window_width);
	_tmp9_ = _tmp7_;
	_tmp10_ = __int_dup0 (&_tmp9_);
	window_width = _tmp10_;
	_g_free0 (window_height);
	_tmp11_ = _tmp8_;
	_tmp12_ = __int_dup0 (&_tmp11_);
	window_height = _tmp12_;
	_tmp14_ = window_width;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		gint* _tmp15_;
		_tmp15_ = window_height;
		_tmp13_ = _tmp15_ == NULL;
	}
	if (_tmp13_) {
		_g_free0 (window_height);
		_g_free0 (window_width);
		_g_object_unref0 (_this);
		return;
	}
	_tmp16_ = _this;
	_tmp17_ = window_width;
	_tmp16_->priv->_window_width = (gint) (*_tmp17_);
	_tmp18_ = _this;
	_tmp19_ = window_height;
	_tmp18_->priv->_window_height = (gint) (*_tmp19_);
	_g_free0 (window_height);
	_g_free0 (window_width);
	_g_object_unref0 (_this);
}

static gboolean
game_window_state_event_cb (GtkWidget* widget,
                            GdkEventWindowState* event)
{
	GameWindow* _this = NULL;
	GameWindow* _tmp0_;
	gboolean window_fullscreen = FALSE;
	GameWindow* _tmp2_;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, TYPE_GAME_WINDOW, GameWindow));
	_this = _tmp0_;
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GameWindow* _tmp1_;
		_tmp1_ = _this;
		_tmp1_->priv->_window_is_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp2_ = _this;
	window_fullscreen = _tmp2_->priv->_window_is_fullscreen;
	if ((event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GameWindow* _tmp3_;
		_tmp3_ = _this;
		_tmp3_->priv->_window_is_fullscreen = (event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	if (window_fullscreen) {
		GameWindow* _tmp5_;
		_tmp5_ = _this;
		_tmp4_ = !_tmp5_->priv->_window_is_fullscreen;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GameWindow* _tmp6_;
		GtkButton* _tmp7_;
		_tmp6_ = _this;
		_tmp7_ = _tmp6_->priv->_unfullscreen_button;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	} else {
		gboolean _tmp8_ = FALSE;
		if (!window_fullscreen) {
			GameWindow* _tmp9_;
			_tmp9_ = _this;
			_tmp8_ = _tmp9_->priv->_window_is_fullscreen;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GameWindow* _tmp10_;
			GtkButton* _tmp11_;
			_tmp10_ = _this;
			_tmp11_ = _tmp10_->priv->_unfullscreen_button;
			gtk_widget_show ((GtkWidget*) _tmp11_);
		}
	}
	if ((event->changed_mask & GAME_WINDOW_tiled_state) != 0) {
		GameWindow* _tmp12_;
		_tmp12_ = _this;
		_tmp12_->priv->_window_is_tiled = (event->new_window_state & GAME_WINDOW_tiled_state) != 0;
	}
	result = FALSE;
	_g_object_unref0 (_this);
	return result;
}

static void
_game_window_install_ui_action_entries (GameWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, GAME_WINDOW__ui_action_entries, (gint) G_N_ELEMENTS (GAME_WINDOW__ui_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "ui", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "undo");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp2_;
	_tmp3_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_g_object_unref0 (action_group);
}

static void
game_window_undo_cb (GameWindow* self)
{
	GSettings* _tmp0_;
	GameHeaderBar* _tmp1_;
	Game* _tmp2_;
	GtkClutterEmbed* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	if (!g_settings_get_boolean (_tmp0_, "allow-undo")) {
		return;
	}
	_tmp1_ = self->priv->_header_bar;
	game_header_bar_clear_subtitle (_tmp1_);
	_tmp2_ = self->priv->_game;
	game_undo (_tmp2_);
	_tmp3_ = self->priv->_embed;
	gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
}

static void
game_window_new_game_cb (GameWindow* self)
{
	GameHeaderBar* _tmp0_;
	Game* _tmp1_;
	GtkClutterEmbed* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_header_bar;
	game_header_bar_clear_subtitle (_tmp0_);
	_tmp1_ = self->priv->_game;
	game_new_game (_tmp1_, &self->priv->_settings);
	_tmp2_ = self->priv->_embed;
	gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
}

static void
game_window_new_game_sized_cb (GameWindow* self,
                               GSimpleAction* action,
                               GVariant* variant)
{
	guint8 rows = 0U;
	guint8 cols = 0U;
	guint8 _tmp0_ = 0U;
	guint8 _tmp1_ = 0U;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	g_variant_get ((GVariant*) variant, "(yy)", &_tmp0_, &_tmp1_, NULL);
	rows = _tmp0_;
	cols = _tmp1_;
	_tmp2_ = self->priv->_settings;
	g_settings_delay (_tmp2_);
	_tmp3_ = self->priv->_settings;
	g_settings_set_int (_tmp3_, "rows", (gint) rows);
	_tmp4_ = self->priv->_settings;
	g_settings_set_int (_tmp4_, "cols", (gint) cols);
	_tmp5_ = self->priv->_settings;
	g_settings_apply (_tmp5_);
	game_window_new_game_cb (self);
}

static void
game_window_toggle_new_game_cb (GameWindow* self)
{
	GameHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_header_bar;
	game_header_bar_toggle_new_game (_tmp0_);
}

static void
game_window_toggle_hamburger_menu (GameWindow* self)
{
	GameHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_header_bar;
	game_header_bar_toggle_hamburger_menu (_tmp0_);
}

static gboolean
_game_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                  guint keyval,
                                                                  guint keycode,
                                                                  GdkModifierType state,
                                                                  gpointer self)
{
	gboolean result;
	result = game_window_on_key_pressed (_sender, keyval, keycode, state);
	return result;
}

static inline void
_game_window_init_keyboard (GameWindow* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect (_tmp1_, "key-pressed", (GCallback) _game_window_on_key_pressed_gtk_event_controller_key_key_pressed, NULL);
}

static inline gboolean
game_window_on_key_pressed (GtkEventControllerKey* _key_controller,
                            guint keyval,
                            guint keycode,
                            GdkModifierType state)
{
	GameWindow* _this = NULL;
	GtkWidget* _tmp0_;
	GameWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GameWindow* _tmp3_;
	GameHeaderBar* _tmp4_;
	GameWindow* _tmp13_;
	Game* _tmp14_;
	gboolean result;
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	_tmp0_ = gtk_event_controller_get_widget ((GtkEventController*) _key_controller);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_GAME_WINDOW, GameWindow));
	_this = _tmp1_;
	_tmp3_ = _this;
	_tmp4_ = _tmp3_->priv->_header_bar;
	if (game_header_bar_has_popover (_tmp4_)) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		GameWindow* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = _this;
		_tmp7_ = gtk_window_get_focus_visible ((GtkWindow*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			GameWindow* _tmp9_;
			GtkClutterEmbed* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = _this;
			_tmp10_ = _tmp9_->priv->_embed;
			g_object_get ((GtkWidget*) _tmp10_, "is-focus", &_tmp11_, NULL);
			_tmp12_ = _tmp11_;
			_tmp5_ = !_tmp12_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp2_ = _tmp5_;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (_this);
		return result;
	}
	_tmp13_ = _this;
	_tmp14_ = _tmp13_->priv->_game;
	if (game_cannot_move (_tmp14_)) {
		result = FALSE;
		_g_object_unref0 (_this);
		return result;
	}
	switch (keycode) {
		case GAME_WINDOW_KEYCODE_W:
		{
			GameWindow* _tmp15_;
			Game* _tmp16_;
			_tmp15_ = _this;
			_tmp16_ = _tmp15_->priv->_game;
			game_move (_tmp16_, MOVE_REQUEST_UP);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		case GAME_WINDOW_KEYCODE_A:
		{
			GameWindow* _tmp17_;
			Game* _tmp18_;
			_tmp17_ = _this;
			_tmp18_ = _tmp17_->priv->_game;
			game_move (_tmp18_, MOVE_REQUEST_LEFT);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		case GAME_WINDOW_KEYCODE_S:
		{
			GameWindow* _tmp19_;
			Game* _tmp20_;
			_tmp19_ = _this;
			_tmp20_ = _tmp19_->priv->_game;
			game_move (_tmp20_, MOVE_REQUEST_DOWN);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		case GAME_WINDOW_KEYCODE_D:
		{
			GameWindow* _tmp21_;
			Game* _tmp22_;
			_tmp21_ = _this;
			_tmp22_ = _tmp21_->priv->_game;
			game_move (_tmp22_, MOVE_REQUEST_RIGHT);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		default:
		break;
	}
	switch (_game_window_upper_key (keyval)) {
		case GDK_KEY_Up:
		{
			GameWindow* _tmp23_;
			Game* _tmp24_;
			_tmp23_ = _this;
			_tmp24_ = _tmp23_->priv->_game;
			game_move (_tmp24_, MOVE_REQUEST_UP);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		case GDK_KEY_Left:
		{
			GameWindow* _tmp25_;
			Game* _tmp26_;
			_tmp25_ = _this;
			_tmp26_ = _tmp25_->priv->_game;
			game_move (_tmp26_, MOVE_REQUEST_LEFT);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		case GDK_KEY_Down:
		{
			GameWindow* _tmp27_;
			Game* _tmp28_;
			_tmp27_ = _this;
			_tmp28_ = _tmp27_->priv->_game;
			game_move (_tmp28_, MOVE_REQUEST_DOWN);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		case GDK_KEY_Right:
		{
			GameWindow* _tmp29_;
			Game* _tmp30_;
			_tmp29_ = _this;
			_tmp30_ = _tmp29_->priv->_game;
			game_move (_tmp30_, MOVE_REQUEST_RIGHT);
			result = TRUE;
			_g_object_unref0 (_this);
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	_g_object_unref0 (_this);
	return result;
}

static inline guint
_game_window_upper_key (guint keyval)
{
	guint _tmp0_ = 0U;
	guint result;
	if (keyval > ((guint) 255)) {
		_tmp0_ = keyval;
	} else {
		_tmp0_ = (guint) g_ascii_toupper ((gchar) keyval);
	}
	result = _tmp0_;
	return result;
}

static void
__game_window_on_swipe_gtk_gesture_swipe_swipe (GtkGestureSwipe* _sender,
                                                gdouble velocity_x,
                                                gdouble velocity_y,
                                                gpointer self)
{
	_game_window_on_swipe ((GameWindow*) self, _sender, velocity_x, velocity_y);
}

static inline void
_game_window_init_gestures (GameWindow* self)
{
	GtkClutterEmbed* _tmp0_;
	GtkGestureSwipe* _tmp1_;
	GtkGestureSwipe* _tmp2_;
	GtkGestureSwipe* _tmp3_;
	GtkGestureSwipe* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_embed;
	_tmp1_ = (GtkGestureSwipe*) gtk_gesture_swipe_new ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->gesture_swipe);
	self->priv->gesture_swipe = _tmp1_;
	_tmp2_ = self->priv->gesture_swipe;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp2_, GTK_PHASE_CAPTURE);
	_tmp3_ = self->priv->gesture_swipe;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp3_, (guint) 0);
	_tmp4_ = self->priv->gesture_swipe;
	g_signal_connect_object (_tmp4_, "swipe", (GCallback) __game_window_on_swipe_gtk_gesture_swipe_swipe, self, 0);
}

static inline void
_game_window_on_swipe (GameWindow* self,
                       GtkGestureSwipe* _gesture_swipe,
                       gdouble velocity_x,
                       gdouble velocity_y)
{
	guint button = 0U;
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	gdouble abs_x = 0.0;
	gdouble abs_y = 0.0;
	gboolean left_or_right = FALSE;
	gboolean up_or_down = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_gesture_swipe != NULL);
	button = gtk_gesture_single_get_current_button ((GtkGestureSingle*) _gesture_swipe);
	if (button != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = button != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_game;
	if (game_cannot_move (_tmp1_)) {
		return;
	}
	abs_x = fabs (velocity_x);
	abs_y = fabs (velocity_y);
	if (((abs_x * abs_x) + (abs_y * abs_y)) < 400.0) {
		return;
	}
	left_or_right = (abs_y * 4.0) < abs_x;
	up_or_down = (abs_x * 4.0) < abs_y;
	if (left_or_right) {
		if (velocity_x < (-10.0)) {
			Game* _tmp2_;
			_tmp2_ = self->priv->_game;
			game_move (_tmp2_, MOVE_REQUEST_LEFT);
		} else {
			if (velocity_x > 10.0) {
				Game* _tmp3_;
				_tmp3_ = self->priv->_game;
				game_move (_tmp3_, MOVE_REQUEST_RIGHT);
			}
		}
	} else {
		if (up_or_down) {
			if (velocity_y < (-10.0)) {
				Game* _tmp4_;
				_tmp4_ = self->priv->_game;
				game_move (_tmp4_, MOVE_REQUEST_UP);
			} else {
				if (velocity_y > 10.0) {
					Game* _tmp5_;
					_tmp5_ = self->priv->_game;
					game_move (_tmp5_, MOVE_REQUEST_DOWN);
				}
			}
		}
	}
}

static void
__lambda6_ (GameWindow* self,
            gint response_id)
{
	GtkMessageDialog* _tmp0_;
	if (response_id == 0) {
		game_window_new_game_cb (self);
	}
	_tmp0_ = self->priv->_congrats_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
___lambda6__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda6_ ((GameWindow*) self, response_id);
}

static gboolean
__lambda7_ (GameWindow* self,
            GdkEventAny* response_id)
{
	GtkMessageDialog* _tmp0_;
	gboolean result;
	g_return_val_if_fail (response_id != NULL, FALSE);
	_tmp0_ = self->priv->_congrats_dialog;
	result = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
	return result;
}

static gboolean
___lambda7__gtk_widget_delete_event (GtkWidget* _sender,
                                     GdkEventAny* event,
                                     gpointer self)
{
	gboolean result;
	result = __lambda7_ ((GameWindow*) self, event);
	return result;
}

static inline void
_game_window_create_congrats_dialog (GameWindow* self)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/TwentyFortyEight/ui/congrats.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "congratsdialog");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_message_dialog_get_type (), GtkMessageDialog));
	_g_object_unref0 (self->priv->_congrats_dialog);
	self->priv->_congrats_dialog = _tmp2_;
	_tmp3_ = self->priv->_congrats_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) self);
	_tmp4_ = self->priv->_congrats_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp4_, "response", (GCallback) ___lambda6__gtk_dialog_response, self, 0);
	_tmp5_ = self->priv->_congrats_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "delete-event", (GCallback) ___lambda7__gtk_widget_delete_event, self, 0);
	_g_object_unref0 (builder);
}

static inline void
game_window_target_value_reached_cb (GameWindow* self,
                                     guint target_value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	if (g_settings_get_boolean (_tmp0_, "do-congrat")) {
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* _tmp2_;
		GSettings* _tmp3_;
		if (self->priv->_should_create_congrats_dialog) {
			_game_window_create_congrats_dialog (self);
			self->priv->_should_create_congrats_dialog = FALSE;
		}
		_tmp1_ = self->priv->_congrats_dialog;
		gtk_message_dialog_format_secondary_text (_tmp1_, _ ("You have obtained the %u tile for the first time!"), target_value);
		_tmp2_ = self->priv->_congrats_dialog;
		gtk_window_present ((GtkWindow*) _tmp2_);
		_tmp3_ = self->priv->_settings;
		g_settings_set_boolean (_tmp3_, "do-congrat", FALSE);
	}
	g_debug ("game-window.vala:425: target value reached");
}

static GamesScoresCategory*
_game_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                          gpointer self)
{
	GamesScoresCategory* result;
	result = game_window_category_request ((GameWindow*) self, category_key);
	return result;
}

static inline void
_game_window_create_scores_dialog (GameWindow* self)
{
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresContext* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_category_new ("grid3", _ ("Grid 3 × 3"));
	_g_object_unref0 (self->priv->_grid3_cat);
	self->priv->_grid3_cat = _tmp0_;
	_tmp1_ = games_scores_category_new ("grid4", _ ("Grid 4 × 4"));
	_g_object_unref0 (self->priv->_grid4_cat);
	self->priv->_grid4_cat = _tmp1_;
	_tmp2_ = games_scores_category_new ("grid5", _ ("Grid 5 × 5"));
	_g_object_unref0 (self->priv->_grid5_cat);
	self->priv->_grid5_cat = _tmp2_;
	_tmp3_ = games_scores_context_new_with_icon_name ("gnome-2048", _ ("Grid Size:"), (GtkWindow*) self, _game_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "org.gnome.TwentyFortyEight");
	_g_object_unref0 (self->priv->_scores_ctx);
	self->priv->_scores_ctx = _tmp3_;
}

static inline GamesScoresCategory*
game_window_category_request (GameWindow* self,
                              const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("grid4")))) {
		switch (0) {
			default:
			{
				GamesScoresCategory* _tmp3_;
				GamesScoresCategory* _tmp4_;
				_tmp3_ = self->priv->_grid4_cat;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("grid3")))) {
		switch (0) {
			default:
			{
				GamesScoresCategory* _tmp5_;
				GamesScoresCategory* _tmp6_;
				_tmp5_ = self->priv->_grid3_cat;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("grid5")))) {
		switch (0) {
			default:
			{
				GamesScoresCategory* _tmp7_;
				GamesScoresCategory* _tmp8_;
				_tmp7_ = self->priv->_grid5_cat;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

static inline void
game_window_scores_cb (GameWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_scores_ctx;
	games_scores_context_run_dialog (_tmp0_);
}

static void
__lambda5_ (GameWindow* self,
            GObject* object,
            GAsyncResult* _result_)
{
	GamesScoresContext* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->_scores_ctx;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = self->priv->_scores_ctx;
	games_scores_context_run_dialog (_tmp4_);
	g_debug ("game-window.vala:488: score added");
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda5_ ((GameWindow*) self, source_object, res);
	g_object_unref (self);
}

static inline void
_game_window_show_best_scores (GameWindow* self)
{
	guint8 rows = 0U;
	GSettings* _tmp0_;
	guint8 cols = 0U;
	GSettings* _tmp1_;
	GamesScoresCategory* cat = NULL;
	GamesScoresContext* _tmp8_;
	Game* _tmp9_;
	glong _tmp10_;
	glong _tmp11_;
	GamesScoresCategory* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	rows = (guint8) g_settings_get_int (_tmp0_, "rows");
	_tmp1_ = self->priv->_settings;
	cols = (guint8) g_settings_get_int (_tmp1_, "cols");
	if (rows != cols) {
		return;
	}
	switch (rows) {
		case 4:
		{
			GamesScoresCategory* _tmp2_;
			GamesScoresCategory* _tmp3_;
			_tmp2_ = self->priv->_grid4_cat;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_g_object_unref0 (cat);
			cat = _tmp3_;
			break;
		}
		case 3:
		{
			GamesScoresCategory* _tmp4_;
			GamesScoresCategory* _tmp5_;
			_tmp4_ = self->priv->_grid3_cat;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (cat);
			cat = _tmp5_;
			break;
		}
		case 5:
		{
			GamesScoresCategory* _tmp6_;
			GamesScoresCategory* _tmp7_;
			_tmp6_ = self->priv->_grid5_cat;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (cat);
			cat = _tmp7_;
			break;
		}
		default:
		{
			_g_object_unref0 (cat);
			return;
		}
	}
	_tmp8_ = self->priv->_scores_ctx;
	_tmp9_ = self->priv->_game;
	_tmp10_ = game_get_score (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = cat;
	games_scores_context_add_score (_tmp8_, _tmp11_, _tmp12_, NULL, ___lambda5__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (cat);
}

static void
game_window_about_cb (GameWindow* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Juan R. García Blanco");
	_tmp1_ = g_strdup ("Arnaud Bonatti");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strconcat (_ ("Copyright \xc2\xa9 2014-2015 – Juan R. García Blanco"), "\n", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2016, (guint) 2020);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp4_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", _ ("2048"), "version", VERSION, "comments", _ ("A clone of 2048 for GNOME"), "license-type", GTK_LICENSE_GPL_3_0, "copyright", _tmp8_, "wrap-license", TRUE, "authors", authors, "translator-credits", _ ("translator-credits"), "logo-icon-name", "org.gnome.TwentyFortyEight", "website", "https://wiki.gnome.org/Apps/2048", "website-label", _ ("Page on GNOME wiki"), NULL, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static guint8
game_window_get_cli_cols (GameWindow* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_cli_cols;
	return result;
}

static void
game_window_set_cli_cols (GameWindow* self,
                          guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_cli_cols (self);
	if (old_value != value) {
		self->priv->_cli_cols = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_CLI_COLS_PROPERTY]);
	}
}

static guint8
game_window_get_cli_rows (GameWindow* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_cli_rows;
	return result;
}

static void
game_window_set_cli_rows (GameWindow* self,
                          guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_cli_rows (self);
	if (old_value != value) {
		self->priv->_cli_rows = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_CLI_ROWS_PROPERTY]);
	}
}

static void
_game_window___lambda12_ (GameWindow* self)
{
	GtkClutterEmbed* _tmp0_;
	_tmp0_ = self->priv->_embed;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
__game_window___lambda12__g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	_game_window___lambda12_ ((GameWindow*) self);
}

static GObject *
game_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameWindow * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (game_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_tmp0_ = g_settings_new ("org.gnome.TwentyFortyEight");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_game_window_install_ui_action_entries (self);
	_game_window_init_game (self);
	_game_window_init_window (self);
	_game_window_create_scores_dialog (self);
	g_signal_connect_object ((GObject*) self, "notify::has-toplevel-focus", (GCallback) __game_window___lambda12__g_object_notify, self, 0);
	return obj;
}

static void
game_window_class_init (GameWindowClass * klass,
                        gpointer klass_data)
{
	game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_CLI_COLS_PROPERTY, game_window_properties[GAME_WINDOW_CLI_COLS_PROPERTY] = g_param_spec_uchar ("cli-cols", "cli-cols", "cli-cols", 0, G_MAXUINT8, (guint8) 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_CLI_ROWS_PROPERTY, game_window_properties[GAME_WINDOW_CLI_ROWS_PROPERTY] = g_param_spec_uchar ("cli-rows", "cli-rows", "cli-rows", 0, G_MAXUINT8, (guint8) 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/TwentyFortyEight/ui/game-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_header_bar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_embed", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _embed));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_unfullscreen_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _unfullscreen_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_game_window_on_destroy_gtk_widget_destroy));
}

static void
game_window_instance_init (GameWindow * self,
                           gpointer klass)
{
	self->priv = game_window_get_instance_private (self);
	self->priv->_cli_cols = (guint8) 0;
	self->priv->_cli_rows = (guint8) 0;
	self->priv->_should_create_congrats_dialog = TRUE;
	g_type_ensure (TYPE_GAME_HEADER_BAR);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
game_window_finalize (GObject * obj)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_game);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->gesture_swipe);
	_g_object_unref0 (self->priv->_congrats_dialog);
	_g_object_unref0 (self->priv->_scores_ctx);
	_g_object_unref0 (self->priv->_grid4_cat);
	_g_object_unref0 (self->priv->_grid3_cat);
	_g_object_unref0 (self->priv->_grid5_cat);
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
}

static GType
game_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
	GType game_window_type_id;
	game_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GameWindow", &g_define_type_info, 0);
	GameWindow_private_offset = g_type_add_instance_private (game_window_type_id, sizeof (GameWindowPrivate));
	return game_window_type_id;
}

GType
game_window_get_type (void)
{
	static volatile gsize game_window_type_id__once = 0;
	if (g_once_init_enter (&game_window_type_id__once)) {
		GType game_window_type_id;
		game_window_type_id = game_window_get_type_once ();
		g_once_init_leave (&game_window_type_id__once, game_window_type_id);
	}
	return game_window_type_id__once;
}

static void
_vala_game_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_CLI_COLS_PROPERTY:
		g_value_set_uchar (value, game_window_get_cli_cols (self));
		break;
		case GAME_WINDOW_CLI_ROWS_PROPERTY:
		g_value_set_uchar (value, game_window_get_cli_rows (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_CLI_COLS_PROPERTY:
		game_window_set_cli_cols (self, g_value_get_uchar (value));
		break;
		case GAME_WINDOW_CLI_ROWS_PROPERTY:
		game_window_set_cli_rows (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

