{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Virtual table for handling properties and method calls for a D-Bus
-- interface.
-- 
-- Since 2.38, if you want to handle getting\/setting D-Bus properties
-- asynchronously, give 'P.Nothing' as your @/get_property()/@ or @/set_property()/@
-- function. The D-Bus call will be directed to your /@methodCall@/ function,
-- with the provided /@interfaceName@/ set to \"org.freedesktop.DBus.Properties\".
-- 
-- Ownership of the t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation' object passed to the
-- @/method_call()/@ function is transferred to your handler; you must
-- call one of the methods of t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation' to return a reply
-- (possibly empty), or an error. These functions also take ownership
-- of the passed-in invocation object, so unless the invocation
-- object has otherwise been referenced, it will be then be freed.
-- Calling one of these functions may be done within your
-- @/method_call()/@ implementation but it also can be done at a later
-- point to handle the method asynchronously.
-- 
-- The usual checks on the validity of the calls is performed. For
-- @Get@ calls, an error is automatically returned if the property does
-- not exist or the permissions do not allow access. The same checks are
-- performed for @Set@ calls, and the provided value is also checked for
-- being the correct type.
-- 
-- For both @Get@ and @Set@ calls, the t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation'
-- passed to the /@methodCall@/ handler can be queried with
-- 'GI.Gio.Objects.DBusMethodInvocation.dBusMethodInvocationGetPropertyInfo' to get a pointer
-- to the t'GI.Gio.Structs.DBusPropertyInfo.DBusPropertyInfo' of the property.
-- 
-- If you have readable properties specified in your interface info,
-- you must ensure that you either provide a non-'P.Nothing' /@getProperty@/()
-- function or provide implementations of both the @Get@ and @GetAll@
-- methods on org.freedesktop.DBus.Properties interface in your /@methodCall@/
-- function. Note that the required return type of the @Get@ call is
-- @(v)@, not the type of the property. @GetAll@ expects a return value
-- of type @a{sv}@.
-- 
-- If you have writable properties specified in your interface info,
-- you must ensure that you either provide a non-'P.Nothing' /@setProperty@/()
-- function or provide an implementation of the @Set@ call. If implementing
-- the call, you must return the value of type @/G_VARIANT_TYPE_UNIT/@.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusInterfaceVTable
    ( 

-- * Exported types
    DBusInterfaceVTable(..)                 ,
    newZeroDBusInterfaceVTable              ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveDBusInterfaceVTableMethod        ,
#endif



 -- * Properties


-- ** getProperty #attr:getProperty#
-- | Function for getting a property.

    clearDBusInterfaceVTableGetProperty     ,
#if defined(ENABLE_OVERLOADING)
    dBusInterfaceVTable_getProperty         ,
#endif
    getDBusInterfaceVTableGetProperty       ,
    setDBusInterfaceVTableGetProperty       ,


-- ** methodCall #attr:methodCall#
-- | Function for handling incoming method calls.

    clearDBusInterfaceVTableMethodCall      ,
#if defined(ENABLE_OVERLOADING)
    dBusInterfaceVTable_methodCall          ,
#endif
    getDBusInterfaceVTableMethodCall        ,
    setDBusInterfaceVTableMethodCall        ,


-- ** setProperty #attr:setProperty#
-- | Function for setting a property.

    clearDBusInterfaceVTableSetProperty     ,
#if defined(ENABLE_OVERLOADING)
    dBusInterfaceVTable_setProperty         ,
#endif
    getDBusInterfaceVTableSetProperty       ,
    setDBusInterfaceVTableSetProperty       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gio.Callbacks as Gio.Callbacks

#else
import qualified GI.Gio.Callbacks as Gio.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype DBusInterfaceVTable = DBusInterfaceVTable (SP.ManagedPtr DBusInterfaceVTable)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusInterfaceVTable where
    toManagedPtr (DBusInterfaceVTable p) = p

instance BoxedPtr DBusInterfaceVTable where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 88 >=> B.ManagedPtr.wrapPtr DBusInterfaceVTable)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr DBusInterfaceVTable where
    boxedPtrCalloc = callocBytes 88


-- | Construct a t'DBusInterfaceVTable' struct initialized to zero.
newZeroDBusInterfaceVTable :: MonadIO m => m DBusInterfaceVTable
newZeroDBusInterfaceVTable = liftIO $ boxedPtrCalloc >>= wrapPtr DBusInterfaceVTable

instance tag ~ 'AttrSet => Constructible DBusInterfaceVTable tag where
    new _ attrs = do
        o <- newZeroDBusInterfaceVTable
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@method_call@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusInterfaceVTable #methodCall
-- @
getDBusInterfaceVTableMethodCall :: MonadIO m => DBusInterfaceVTable -> m (Maybe Gio.Callbacks.DBusInterfaceMethodCallFunc_WithClosures)
getDBusInterfaceVTableMethodCall s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr Gio.Callbacks.C_DBusInterfaceMethodCallFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_DBusInterfaceMethodCallFunc val'
        return val''
    return result

-- | Set the value of the “@method_call@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusInterfaceVTable [ #methodCall 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusInterfaceVTableMethodCall :: MonadIO m => DBusInterfaceVTable -> FunPtr Gio.Callbacks.C_DBusInterfaceMethodCallFunc -> m ()
setDBusInterfaceVTableMethodCall s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr Gio.Callbacks.C_DBusInterfaceMethodCallFunc)

-- | Set the value of the “@method_call@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #methodCall
-- @
clearDBusInterfaceVTableMethodCall :: MonadIO m => DBusInterfaceVTable -> m ()
clearDBusInterfaceVTableMethodCall s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_DBusInterfaceMethodCallFunc)

#if defined(ENABLE_OVERLOADING)
data DBusInterfaceVTableMethodCallFieldInfo
instance AttrInfo DBusInterfaceVTableMethodCallFieldInfo where
    type AttrBaseTypeConstraint DBusInterfaceVTableMethodCallFieldInfo = (~) DBusInterfaceVTable
    type AttrAllowedOps DBusInterfaceVTableMethodCallFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusInterfaceVTableMethodCallFieldInfo = (~) (FunPtr Gio.Callbacks.C_DBusInterfaceMethodCallFunc)
    type AttrTransferTypeConstraint DBusInterfaceVTableMethodCallFieldInfo = (~)Gio.Callbacks.DBusInterfaceMethodCallFunc_WithClosures
    type AttrTransferType DBusInterfaceVTableMethodCallFieldInfo = (FunPtr Gio.Callbacks.C_DBusInterfaceMethodCallFunc)
    type AttrGetType DBusInterfaceVTableMethodCallFieldInfo = Maybe Gio.Callbacks.DBusInterfaceMethodCallFunc_WithClosures
    type AttrLabel DBusInterfaceVTableMethodCallFieldInfo = "method_call"
    type AttrOrigin DBusInterfaceVTableMethodCallFieldInfo = DBusInterfaceVTable
    attrGet = getDBusInterfaceVTableMethodCall
    attrSet = setDBusInterfaceVTableMethodCall
    attrConstruct = undefined
    attrClear = clearDBusInterfaceVTableMethodCall
    attrTransfer _ v = do
        Gio.Callbacks.mk_DBusInterfaceMethodCallFunc (Gio.Callbacks.wrap_DBusInterfaceMethodCallFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusInterfaceVTable.methodCall"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusInterfaceVTable.html#g:attr:methodCall"
        })

dBusInterfaceVTable_methodCall :: AttrLabelProxy "methodCall"
dBusInterfaceVTable_methodCall = AttrLabelProxy

#endif


-- | Get the value of the “@get_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusInterfaceVTable #getProperty
-- @
getDBusInterfaceVTableGetProperty :: MonadIO m => DBusInterfaceVTable -> m (Maybe Gio.Callbacks.DBusInterfaceGetPropertyFunc_WithClosures)
getDBusInterfaceVTableGetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr Gio.Callbacks.C_DBusInterfaceGetPropertyFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_DBusInterfaceGetPropertyFunc val'
        return val''
    return result

-- | Set the value of the “@get_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusInterfaceVTable [ #getProperty 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusInterfaceVTableGetProperty :: MonadIO m => DBusInterfaceVTable -> FunPtr Gio.Callbacks.C_DBusInterfaceGetPropertyFunc -> m ()
setDBusInterfaceVTableGetProperty s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr Gio.Callbacks.C_DBusInterfaceGetPropertyFunc)

-- | Set the value of the “@get_property@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getProperty
-- @
clearDBusInterfaceVTableGetProperty :: MonadIO m => DBusInterfaceVTable -> m ()
clearDBusInterfaceVTableGetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_DBusInterfaceGetPropertyFunc)

#if defined(ENABLE_OVERLOADING)
data DBusInterfaceVTableGetPropertyFieldInfo
instance AttrInfo DBusInterfaceVTableGetPropertyFieldInfo where
    type AttrBaseTypeConstraint DBusInterfaceVTableGetPropertyFieldInfo = (~) DBusInterfaceVTable
    type AttrAllowedOps DBusInterfaceVTableGetPropertyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusInterfaceVTableGetPropertyFieldInfo = (~) (FunPtr Gio.Callbacks.C_DBusInterfaceGetPropertyFunc)
    type AttrTransferTypeConstraint DBusInterfaceVTableGetPropertyFieldInfo = (~)Gio.Callbacks.DBusInterfaceGetPropertyFunc_WithClosures
    type AttrTransferType DBusInterfaceVTableGetPropertyFieldInfo = (FunPtr Gio.Callbacks.C_DBusInterfaceGetPropertyFunc)
    type AttrGetType DBusInterfaceVTableGetPropertyFieldInfo = Maybe Gio.Callbacks.DBusInterfaceGetPropertyFunc_WithClosures
    type AttrLabel DBusInterfaceVTableGetPropertyFieldInfo = "get_property"
    type AttrOrigin DBusInterfaceVTableGetPropertyFieldInfo = DBusInterfaceVTable
    attrGet = getDBusInterfaceVTableGetProperty
    attrSet = setDBusInterfaceVTableGetProperty
    attrConstruct = undefined
    attrClear = clearDBusInterfaceVTableGetProperty
    attrTransfer _ v = do
        Gio.Callbacks.mk_DBusInterfaceGetPropertyFunc (Gio.Callbacks.wrap_DBusInterfaceGetPropertyFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusInterfaceVTable.getProperty"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusInterfaceVTable.html#g:attr:getProperty"
        })

dBusInterfaceVTable_getProperty :: AttrLabelProxy "getProperty"
dBusInterfaceVTable_getProperty = AttrLabelProxy

#endif


-- | Get the value of the “@set_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusInterfaceVTable #setProperty
-- @
getDBusInterfaceVTableSetProperty :: MonadIO m => DBusInterfaceVTable -> m (Maybe Gio.Callbacks.DBusInterfaceSetPropertyFunc_WithClosures)
getDBusInterfaceVTableSetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr Gio.Callbacks.C_DBusInterfaceSetPropertyFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_DBusInterfaceSetPropertyFunc val'
        return val''
    return result

-- | Set the value of the “@set_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusInterfaceVTable [ #setProperty 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusInterfaceVTableSetProperty :: MonadIO m => DBusInterfaceVTable -> FunPtr Gio.Callbacks.C_DBusInterfaceSetPropertyFunc -> m ()
setDBusInterfaceVTableSetProperty s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr Gio.Callbacks.C_DBusInterfaceSetPropertyFunc)

-- | Set the value of the “@set_property@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #setProperty
-- @
clearDBusInterfaceVTableSetProperty :: MonadIO m => DBusInterfaceVTable -> m ()
clearDBusInterfaceVTableSetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_DBusInterfaceSetPropertyFunc)

#if defined(ENABLE_OVERLOADING)
data DBusInterfaceVTableSetPropertyFieldInfo
instance AttrInfo DBusInterfaceVTableSetPropertyFieldInfo where
    type AttrBaseTypeConstraint DBusInterfaceVTableSetPropertyFieldInfo = (~) DBusInterfaceVTable
    type AttrAllowedOps DBusInterfaceVTableSetPropertyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusInterfaceVTableSetPropertyFieldInfo = (~) (FunPtr Gio.Callbacks.C_DBusInterfaceSetPropertyFunc)
    type AttrTransferTypeConstraint DBusInterfaceVTableSetPropertyFieldInfo = (~)Gio.Callbacks.DBusInterfaceSetPropertyFunc_WithClosures
    type AttrTransferType DBusInterfaceVTableSetPropertyFieldInfo = (FunPtr Gio.Callbacks.C_DBusInterfaceSetPropertyFunc)
    type AttrGetType DBusInterfaceVTableSetPropertyFieldInfo = Maybe Gio.Callbacks.DBusInterfaceSetPropertyFunc_WithClosures
    type AttrLabel DBusInterfaceVTableSetPropertyFieldInfo = "set_property"
    type AttrOrigin DBusInterfaceVTableSetPropertyFieldInfo = DBusInterfaceVTable
    attrGet = getDBusInterfaceVTableSetProperty
    attrSet = setDBusInterfaceVTableSetProperty
    attrConstruct = undefined
    attrClear = clearDBusInterfaceVTableSetProperty
    attrTransfer _ v = do
        Gio.Callbacks.mk_DBusInterfaceSetPropertyFunc (Gio.Callbacks.wrap_DBusInterfaceSetPropertyFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusInterfaceVTable.setProperty"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusInterfaceVTable.html#g:attr:setProperty"
        })

dBusInterfaceVTable_setProperty :: AttrLabelProxy "setProperty"
dBusInterfaceVTable_setProperty = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusInterfaceVTable
type instance O.AttributeList DBusInterfaceVTable = DBusInterfaceVTableAttributeList
type DBusInterfaceVTableAttributeList = ('[ '("methodCall", DBusInterfaceVTableMethodCallFieldInfo), '("getProperty", DBusInterfaceVTableGetPropertyFieldInfo), '("setProperty", DBusInterfaceVTableSetPropertyFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusInterfaceVTableMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusInterfaceVTableMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusInterfaceVTableMethod t DBusInterfaceVTable, O.OverloadedMethod info DBusInterfaceVTable p) => OL.IsLabel t (DBusInterfaceVTable -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusInterfaceVTableMethod t DBusInterfaceVTable, O.OverloadedMethod info DBusInterfaceVTable p, R.HasField t DBusInterfaceVTable p) => R.HasField t DBusInterfaceVTable p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusInterfaceVTableMethod t DBusInterfaceVTable, O.OverloadedMethodInfo info DBusInterfaceVTable) => OL.IsLabel t (O.MethodProxy info DBusInterfaceVTable) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


