/* AnimatorScaleInPlace.c generated by valac 0.56.18, the Vala compiler
 * generated from AnimatorScaleInPlace.vala, do not modify */

/*
* Copyright (c) 2021 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Martin Sivak <mars@montik.net>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ANIMATOR_ACTION (animator_action_get_type ())
#define ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_ACTION, AnimatorAction))
#define ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_ACTION, AnimatorActionClass))
#define IS_ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_ACTION))
#define IS_ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_ACTION))
#define ANIMATOR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_ACTION, AnimatorActionClass))

typedef struct _AnimatorAction AnimatorAction;
typedef struct _AnimatorActionClass AnimatorActionClass;
typedef struct _AnimatorActionPrivate AnimatorActionPrivate;
typedef enum  {
	ANIMATION_TYPE_UNKNOWN = 0,
	ANIMATION_TYPE_NODES,
	ANIMATION_TYPE_NODE,
	ANIMATION_TYPE_FADE,
	ANIMATION_TYPE_PAN,
	ANIMATION_TYPE_SCALE,
	ANIMATION_TYPE_PANSCALE
} AnimationType;

#define TYPE_ANIMATION_TYPE (animation_type_get_type ())

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_ANIMATOR_SCALE_IN_PLACE (animator_scale_in_place_get_type ())
#define ANIMATOR_SCALE_IN_PLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_SCALE_IN_PLACE, AnimatorScaleInPlace))
#define ANIMATOR_SCALE_IN_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_SCALE_IN_PLACE, AnimatorScaleInPlaceClass))
#define IS_ANIMATOR_SCALE_IN_PLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_SCALE_IN_PLACE))
#define IS_ANIMATOR_SCALE_IN_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_SCALE_IN_PLACE))
#define ANIMATOR_SCALE_IN_PLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_SCALE_IN_PLACE, AnimatorScaleInPlaceClass))

typedef struct _AnimatorScaleInPlace AnimatorScaleInPlace;
typedef struct _AnimatorScaleInPlaceClass AnimatorScaleInPlaceClass;
typedef struct _AnimatorScaleInPlacePrivate AnimatorScaleInPlacePrivate;
enum  {
	ANIMATOR_SCALE_IN_PLACE_0_PROPERTY,
	ANIMATOR_SCALE_IN_PLACE_NUM_PROPERTIES
};
static GParamSpec* animator_scale_in_place_properties[ANIMATOR_SCALE_IN_PLACE_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _AnimatorAction {
	GObject parent_instance;
	AnimatorActionPrivate * priv;
	gchar* _name;
	gboolean _save;
	gint _id;
};

struct _AnimatorActionClass {
	GObjectClass parent_class;
	AnimationType (*type) (AnimatorAction* self);
	void (*capture) (AnimatorAction* self, DrawArea* da);
	void (*adjust) (AnimatorAction* self, DrawArea* da);
	void (*on_completion) (AnimatorAction* self, DrawArea* da);
};

struct _AnimatorScaleInPlace {
	AnimatorAction parent_instance;
	AnimatorScaleInPlacePrivate * priv;
};

struct _AnimatorScaleInPlaceClass {
	AnimatorActionClass parent_class;
};

struct _AnimatorScaleInPlacePrivate {
	gdouble* _sscale;
	gdouble* _escale;
	gdouble* _ssx;
	gdouble* _ssy;
};

static gint AnimatorScaleInPlace_private_offset;
static gpointer animator_scale_in_place_parent_class = NULL;

VALA_EXTERN GType animator_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorAction, g_object_unref)
VALA_EXTERN GType animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType animator_scale_in_place_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorScaleInPlace, g_object_unref)
VALA_EXTERN AnimationType animator_action_type (AnimatorAction* self);
VALA_EXTERN void animator_action_capture (AnimatorAction* self,
                              DrawArea* da);
VALA_EXTERN void animator_action_adjust (AnimatorAction* self,
                             DrawArea* da);
VALA_EXTERN AnimatorScaleInPlace* animator_scale_in_place_new (DrawArea* da,
                                                   const gchar* name,
                                                   gdouble ssx,
                                                   gdouble ssy);
VALA_EXTERN AnimatorScaleInPlace* animator_scale_in_place_construct (GType object_type,
                                                         DrawArea* da,
                                                         const gchar* name,
                                                         gdouble ssx,
                                                         gdouble ssy);
VALA_EXTERN AnimatorAction* animator_action_new (const gchar* name,
                                     gboolean save);
VALA_EXTERN AnimatorAction* animator_action_construct (GType object_type,
                                           const gchar* name,
                                           gboolean save);
VALA_EXTERN gdouble draw_area_get_sfactor (DrawArea* self);
static gdouble* _double_dup (gdouble* self);
static AnimationType animator_scale_in_place_real_type (AnimatorAction* base);
static void animator_scale_in_place_real_capture (AnimatorAction* base,
                                           DrawArea* da);
static void animator_scale_in_place_real_adjust (AnimatorAction* base,
                                          DrawArea* da);
VALA_EXTERN gint animator_action_get_index (AnimatorAction* self);
VALA_EXTERN gdouble animator_action_get_frames (AnimatorAction* self);
VALA_EXTERN void animator_action_set_index (AnimatorAction* self,
                                gint value);
VALA_EXTERN gboolean draw_area_set_scaling_factor_coord (DrawArea* self,
                                             gdouble sf,
                                             gdouble coord_x,
                                             gdouble coord_y);
static void animator_scale_in_place_finalize (GObject * obj);
static GType animator_scale_in_place_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
animator_scale_in_place_get_instance_private (AnimatorScaleInPlace* self)
{
	return G_STRUCT_MEMBER_P (self, AnimatorScaleInPlace_private_offset);
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

AnimatorScaleInPlace*
animator_scale_in_place_construct (GType object_type,
                                   DrawArea* da,
                                   const gchar* name,
                                   gdouble ssx,
                                   gdouble ssy)
{
	AnimatorScaleInPlace * self = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble* _tmp2_;
	gdouble* _tmp3_;
	gdouble* _tmp4_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (AnimatorScaleInPlace*) animator_action_construct (object_type, name, FALSE);
	_tmp0_ = draw_area_get_sfactor (da);
	_tmp1_ = _tmp0_;
	_tmp2_ = __double_dup0 (&_tmp1_);
	_g_free0 (self->priv->_sscale);
	self->priv->_sscale = _tmp2_;
	_tmp3_ = __double_dup0 (&ssx);
	_g_free0 (self->priv->_ssx);
	self->priv->_ssx = _tmp3_;
	_tmp4_ = __double_dup0 (&ssy);
	_g_free0 (self->priv->_ssy);
	self->priv->_ssy = _tmp4_;
	return self;
}

AnimatorScaleInPlace*
animator_scale_in_place_new (DrawArea* da,
                             const gchar* name,
                             gdouble ssx,
                             gdouble ssy)
{
	return animator_scale_in_place_construct (TYPE_ANIMATOR_SCALE_IN_PLACE, da, name, ssx, ssy);
}

static AnimationType
animator_scale_in_place_real_type (AnimatorAction* base)
{
	AnimatorScaleInPlace * self;
	AnimationType result;
	self = (AnimatorScaleInPlace*) base;
	result = ANIMATION_TYPE_PANSCALE;
	return result;
}

static void
animator_scale_in_place_real_capture (AnimatorAction* base,
                                      DrawArea* da)
{
	AnimatorScaleInPlace * self;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble* _tmp2_;
	self = (AnimatorScaleInPlace*) base;
	g_return_if_fail (da != NULL);
	_tmp0_ = draw_area_get_sfactor (da);
	_tmp1_ = _tmp0_;
	_tmp2_ = __double_dup0 (&_tmp1_);
	_g_free0 (self->priv->_escale);
	self->priv->_escale = _tmp2_;
}

static void
animator_scale_in_place_real_adjust (AnimatorAction* base,
                                     DrawArea* da)
{
	AnimatorScaleInPlace * self;
	gdouble divisor = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gdouble sf = 0.0;
	gdouble* _tmp6_;
	gdouble* _tmp7_;
	gdouble* _tmp8_;
	gdouble* _tmp9_;
	gdouble* _tmp10_;
	self = (AnimatorScaleInPlace*) base;
	g_return_if_fail (da != NULL);
	_tmp0_ = animator_action_get_index ((AnimatorAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = animator_action_get_frames ((AnimatorAction*) self);
	_tmp3_ = _tmp2_;
	divisor = _tmp1_ / _tmp3_;
	_tmp4_ = animator_action_get_index ((AnimatorAction*) self);
	_tmp5_ = _tmp4_;
	animator_action_set_index ((AnimatorAction*) self, _tmp5_ + 1);
	_tmp6_ = self->priv->_sscale;
	_tmp7_ = self->priv->_escale;
	_tmp8_ = self->priv->_sscale;
	sf = (*_tmp6_) + (((*_tmp7_) - (*_tmp8_)) * divisor);
	_tmp9_ = self->priv->_ssx;
	_tmp10_ = self->priv->_ssy;
	draw_area_set_scaling_factor_coord (da, sf, *_tmp9_, *_tmp10_);
}

static void
animator_scale_in_place_class_init (AnimatorScaleInPlaceClass * klass,
                                    gpointer klass_data)
{
	animator_scale_in_place_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AnimatorScaleInPlace_private_offset);
	((AnimatorActionClass *) klass)->type = (AnimationType (*) (AnimatorAction*)) animator_scale_in_place_real_type;
	((AnimatorActionClass *) klass)->capture = (void (*) (AnimatorAction*, DrawArea*)) animator_scale_in_place_real_capture;
	((AnimatorActionClass *) klass)->adjust = (void (*) (AnimatorAction*, DrawArea*)) animator_scale_in_place_real_adjust;
	G_OBJECT_CLASS (klass)->finalize = animator_scale_in_place_finalize;
}

static void
animator_scale_in_place_instance_init (AnimatorScaleInPlace * self,
                                       gpointer klass)
{
	self->priv = animator_scale_in_place_get_instance_private (self);
	self->priv->_sscale = NULL;
	self->priv->_escale = NULL;
	self->priv->_ssx = NULL;
	self->priv->_ssy = NULL;
}

static void
animator_scale_in_place_finalize (GObject * obj)
{
	AnimatorScaleInPlace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATOR_SCALE_IN_PLACE, AnimatorScaleInPlace);
	_g_free0 (self->priv->_sscale);
	_g_free0 (self->priv->_escale);
	_g_free0 (self->priv->_ssx);
	_g_free0 (self->priv->_ssy);
	G_OBJECT_CLASS (animator_scale_in_place_parent_class)->finalize (obj);
}

static GType
animator_scale_in_place_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AnimatorScaleInPlaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animator_scale_in_place_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimatorScaleInPlace), 0, (GInstanceInitFunc) animator_scale_in_place_instance_init, NULL };
	GType animator_scale_in_place_type_id;
	animator_scale_in_place_type_id = g_type_register_static (TYPE_ANIMATOR_ACTION, "AnimatorScaleInPlace", &g_define_type_info, 0);
	AnimatorScaleInPlace_private_offset = g_type_add_instance_private (animator_scale_in_place_type_id, sizeof (AnimatorScaleInPlacePrivate));
	return animator_scale_in_place_type_id;
}

GType
animator_scale_in_place_get_type (void)
{
	static volatile gsize animator_scale_in_place_type_id__once = 0;
	if (g_once_init_enter (&animator_scale_in_place_type_id__once)) {
		GType animator_scale_in_place_type_id;
		animator_scale_in_place_type_id = animator_scale_in_place_get_type_once ();
		g_once_init_leave (&animator_scale_in_place_type_id__once, animator_scale_in_place_type_id);
	}
	return animator_scale_in_place_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

