/* Slot.c generated by valac 0.56.18, the Vala compiler
 * generated from Slot.vala, do not modify */

#include "pantheon-files-core.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <handy.h>
#include <cairo-gobject.h>
#include <pango/pango.h>

#define FILES_VIEW_SLOT_EMPTY_MESSAGE _ ("This Folder Is Empty")
#define FILES_VIEW_SLOT_EMPTY_TRASH_MESSAGE _ ("Trash Is Empty")
#define FILES_VIEW_SLOT_EMPTY_RECENT_MESSAGE _ ("There Are No Recent Files")
#define FILES_VIEW_SLOT_DENIED_MESSAGE _ ("Access Denied")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_TYPE_SLOT (files_view_slot_get_type ())
#define FILES_VIEW_SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlot))
#define FILES_VIEW_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))
#define FILES_VIEW_IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))

typedef struct _FilesViewSlot FilesViewSlot;
typedef struct _FilesViewSlotClass FilesViewSlotClass;
typedef struct _FilesViewSlotPrivate FilesViewSlotPrivate;

#define FILES_VIEW_TYPE_VIEW_CONTAINER (files_view_view_container_get_type ())
#define FILES_VIEW_VIEW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer))
#define FILES_VIEW_VIEW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainerClass))
#define FILES_VIEW_IS_VIEW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER))
#define FILES_VIEW_IS_VIEW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_VIEW_CONTAINER))
#define FILES_VIEW_VIEW_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainerClass))

typedef struct _FilesViewViewContainer FilesViewViewContainer;
typedef struct _FilesViewViewContainerClass FilesViewViewContainerClass;

#define FILES_TYPE_ABSTRACT_DIRECTORY_VIEW (files_abstract_directory_view_get_type ())
#define FILES_ABSTRACT_DIRECTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryView))
#define FILES_ABSTRACT_DIRECTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryViewClass))
#define FILES_IS_ABSTRACT_DIRECTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW))
#define FILES_IS_ABSTRACT_DIRECTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW))
#define FILES_ABSTRACT_DIRECTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryViewClass))

typedef struct _FilesAbstractDirectoryView FilesAbstractDirectoryView;
typedef struct _FilesAbstractDirectoryViewClass FilesAbstractDirectoryViewClass;
enum  {
	FILES_VIEW_SLOT_0_PROPERTY,
	FILES_VIEW_SLOT_CTAB_PROPERTY,
	FILES_VIEW_SLOT_MODE_PROPERTY,
	FILES_VIEW_SLOT_IS_ACTIVE_PROPERTY,
	FILES_VIEW_SLOT_DISPLAYED_FILES_COUNT_PROPERTY,
	FILES_VIEW_SLOT_WINDOW_PROPERTY,
	FILES_VIEW_SLOT_IS_FROZEN_PROPERTY,
	FILES_VIEW_SLOT_LOCKED_FOCUS_PROPERTY,
	FILES_VIEW_SLOT_NUM_PROPERTIES
};
static GParamSpec* files_view_slot_properties[FILES_VIEW_SLOT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FILES_VIEW_TYPE_WINDOW (files_view_window_get_type ())
#define FILES_VIEW_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_WINDOW, FilesViewWindow))
#define FILES_VIEW_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_WINDOW, FilesViewWindowClass))
#define FILES_VIEW_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_WINDOW))
#define FILES_VIEW_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_WINDOW))
#define FILES_VIEW_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_WINDOW, FilesViewWindowClass))

typedef struct _FilesViewWindow FilesViewWindow;
typedef struct _FilesViewWindowClass FilesViewWindowClass;

#define FILES_TYPE_APPLICATION (files_application_get_type ())
#define FILES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_APPLICATION, FilesApplication))
#define FILES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_APPLICATION, FilesApplicationClass))
#define FILES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_APPLICATION))
#define FILES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_APPLICATION))
#define FILES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_APPLICATION, FilesApplicationClass))

typedef struct _FilesApplication FilesApplication;
typedef struct _FilesApplicationClass FilesApplicationClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FILES_TYPE_ABSTRACT_TREE_VIEW (files_abstract_tree_view_get_type ())
#define FILES_ABSTRACT_TREE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ABSTRACT_TREE_VIEW, FilesAbstractTreeView))
#define FILES_ABSTRACT_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ABSTRACT_TREE_VIEW, FilesAbstractTreeViewClass))
#define FILES_IS_ABSTRACT_TREE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ABSTRACT_TREE_VIEW))
#define FILES_IS_ABSTRACT_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ABSTRACT_TREE_VIEW))
#define FILES_ABSTRACT_TREE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ABSTRACT_TREE_VIEW, FilesAbstractTreeViewClass))

typedef struct _FilesAbstractTreeView FilesAbstractTreeView;
typedef struct _FilesAbstractTreeViewClass FilesAbstractTreeViewClass;

#define FILES_TYPE_COLUMN_VIEW (files_column_view_get_type ())
#define FILES_COLUMN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_COLUMN_VIEW, FilesColumnView))
#define FILES_COLUMN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_COLUMN_VIEW, FilesColumnViewClass))
#define FILES_IS_COLUMN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_COLUMN_VIEW))
#define FILES_IS_COLUMN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_COLUMN_VIEW))
#define FILES_COLUMN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_COLUMN_VIEW, FilesColumnViewClass))

typedef struct _FilesColumnView FilesColumnView;
typedef struct _FilesColumnViewClass FilesColumnViewClass;

#define FILES_TYPE_LIST_VIEW (files_list_view_get_type ())
#define FILES_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_LIST_VIEW, FilesListView))
#define FILES_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_LIST_VIEW, FilesListViewClass))
#define FILES_IS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_LIST_VIEW))
#define FILES_IS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_LIST_VIEW))
#define FILES_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_LIST_VIEW, FilesListViewClass))

typedef struct _FilesListView FilesListView;
typedef struct _FilesListViewClass FilesListViewClass;

#define FILES_TYPE_ICON_VIEW (files_icon_view_get_type ())
#define FILES_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ICON_VIEW, FilesIconView))
#define FILES_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ICON_VIEW, FilesIconViewClass))
#define FILES_IS_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ICON_VIEW))
#define FILES_IS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ICON_VIEW))
#define FILES_ICON_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ICON_VIEW, FilesIconViewClass))

typedef struct _FilesIconView FilesIconView;
typedef struct _FilesIconViewClass FilesIconViewClass;
enum  {
	FILES_VIEW_SLOT_FROZEN_CHANGED_SIGNAL,
	FILES_VIEW_SLOT_FOLDER_DELETED_SIGNAL,
	FILES_VIEW_SLOT_MILLER_SLOT_REQUEST_SIGNAL,
	FILES_VIEW_SLOT_SIZE_CHANGE_SIGNAL,
	FILES_VIEW_SLOT_NUM_SIGNALS
};
static guint files_view_slot_signals[FILES_VIEW_SLOT_NUM_SIGNALS] = {0};

struct _FilesViewSlot {
	FilesAbstractSlot parent_instance;
	FilesViewSlotPrivate * priv;
	GtkBox* colpane;
	GtkPaned* hpane;
};

struct _FilesViewSlotClass {
	FilesAbstractSlotClass parent_class;
};

struct _FilesViewSlotPrivate {
	FilesViewViewContainer* _ctab;
	FilesViewMode _mode;
	gint preferred_column_width;
	FilesAbstractDirectoryView* dir_view;
	guint reload_timeout_id;
	guint path_change_timeout_id;
	gboolean original_reload_request;
	gboolean _is_active;
};

static gint FilesViewSlot_private_offset;
static gpointer files_view_slot_parent_class = NULL;
VALA_EXTERN GSettings* files_column_view_settings;

VALA_EXTERN GType files_view_slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewSlot, g_object_unref)
VALA_EXTERN GType files_view_view_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewViewContainer, g_object_unref)
VALA_EXTERN GType files_abstract_directory_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAbstractDirectoryView, g_object_unref)
VALA_EXTERN FilesViewSlot* files_view_slot_new (GFile* _location,
                                    FilesViewViewContainer* _ctab,
                                    FilesViewMode _mode);
VALA_EXTERN FilesViewSlot* files_view_slot_construct (GType object_type,
                                          GFile* _location,
                                          FilesViewViewContainer* _ctab,
                                          FilesViewMode _mode);
static void files_view_slot_connect_slot_signals (FilesViewSlot* self);
static void __lambda41_ (FilesViewSlot* self);
VALA_EXTERN gboolean files_view_slot_get_is_active (FilesViewSlot* self);
VALA_EXTERN void files_view_slot_set_is_active (FilesViewSlot* self,
                                    gboolean value);
VALA_EXTERN void files_abstract_directory_view_grab_focus (FilesAbstractDirectoryView* self);
static void ___lambda41__files_abstract_slot_active (FilesAbstractSlot* _sender,
                                              gboolean scroll,
                                              gboolean animate,
                                              gpointer self);
static void __lambda42_ (FilesViewSlot* self);
static void ___lambda42__files_abstract_slot_inactive (FilesAbstractSlot* _sender,
                                                gpointer self);
static void __lambda43_ (FilesViewSlot* self,
                  FilesFile* file,
                  FilesDirectory* dir);
VALA_EXTERN GType files_view_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewWindow, g_object_unref)
VALA_EXTERN FilesViewWindow* files_view_slot_get_window (FilesViewSlot* self);
VALA_EXTERN GType files_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesApplication, g_object_unref)
VALA_EXTERN void files_application_folder_deleted (FilesApplication* self,
                                       GFile* file);
static void ___lambda43__files_view_slot_folder_deleted (FilesViewSlot* _sender,
                                                  FilesFile* file,
                                                  FilesDirectory* parent,
                                                  gpointer self);
static void files_view_slot_connect_dir_view_signals (FilesViewSlot* self);
static void files_view_slot_on_dir_view_path_change_request (FilesViewSlot* self,
                                                      GFile* loc,
                                                      FilesOpenFlag flag,
                                                      gboolean make_root);
static void _files_view_slot_on_dir_view_path_change_request_files_abstract_directory_view_path_change_request (FilesAbstractDirectoryView* _sender,
                                                                                                         GFile* location,
                                                                                                         FilesOpenFlag flag,
                                                                                                         gboolean new_root,
                                                                                                         gpointer self);
static void files_view_slot_on_dir_view_size_allocate (FilesViewSlot* self,
                                                GtkAllocation* alloc);
static void _files_view_slot_on_dir_view_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                          GtkAllocation* allocation,
                                                                          gpointer self);
static void files_view_slot_on_dir_view_selection_changed (FilesViewSlot* self,
                                                    GList* files);
static void _files_view_slot_on_dir_view_selection_changed_files_abstract_directory_view_selection_changed (FilesAbstractDirectoryView* _sender,
                                                                                                     GList* gof_file,
                                                                                                     gpointer self);
static void files_view_slot_disconnect_dir_view_signals (FilesViewSlot* self);
static void files_view_slot_connect_dir_signals (FilesViewSlot* self);
static void files_view_slot_on_directory_done_loading (FilesViewSlot* self,
                                                FilesDirectory* dir);
static void _files_view_slot_on_directory_done_loading_files_directory_done_loading (FilesDirectory* _sender,
                                                                              gpointer self);
static void files_view_slot_on_directory_need_reload (FilesViewSlot* self,
                                               FilesDirectory* dir,
                                               gboolean original_request);
static void _files_view_slot_on_directory_need_reload_files_directory_need_reload (FilesDirectory* _sender,
                                                                            gboolean original_request,
                                                                            gpointer self);
static void files_view_slot_disconnect_dir_signals (FilesViewSlot* self);
VALA_EXTERN FilesViewMode files_view_slot_get_mode (FilesViewSlot* self);
VALA_EXTERN gchar* files_view_slot_get_empty_message (FilesViewSlot* self);
VALA_EXTERN gint files_abstract_directory_view_get_icon_size (FilesAbstractDirectoryView* self);
VALA_EXTERN FilesViewViewContainer* files_view_slot_get_ctab (FilesViewSlot* self);
VALA_EXTERN FilesAbstractSlot* files_view_view_container_prepare_reload (FilesViewViewContainer* self);
VALA_EXTERN void files_abstract_directory_view_prepare_reload (FilesAbstractDirectoryView* self,
                                                   FilesDirectory* dir);
static void files_view_slot_schedule_reload (FilesViewSlot* self);
static gboolean __lambda58_ (FilesViewSlot* self);
static gboolean ___lambda58__gsource_func (gpointer self);
static void files_view_slot_real_user_path_change_request (FilesAbstractSlot* base,
                                                    GFile* loc,
                                                    gboolean make_root);
VALA_EXTERN void files_abstract_directory_view_change_directory (FilesAbstractDirectoryView* self,
                                                     FilesDirectory* old_dir,
                                                     FilesDirectory* new_dir);
static void files_view_slot_real_initialize_directory (FilesAbstractSlot* base);
static void files_view_slot_real_reload (FilesAbstractSlot* base,
                                  gboolean non_local_only);
static gboolean files_view_slot_real_set_all_selected (FilesAbstractSlot* base,
                                                gboolean select_all);
VALA_EXTERN void files_abstract_directory_view_select_all (FilesAbstractDirectoryView* self);
VALA_EXTERN void files_abstract_directory_view_unselect_all (FilesAbstractDirectoryView* self);
static GList* files_view_slot_real_get_selected_files (FilesAbstractSlot* base);
VALA_EXTERN GList* files_abstract_directory_view_get_selected_files (FilesAbstractDirectoryView* self);
static void files_view_slot_real_select_glib_files (FilesAbstractSlot* base,
                                             GList* files,
                                             GFile* focus_location);
VALA_EXTERN void files_abstract_directory_view_select_glib_files_when_thawed (FilesAbstractDirectoryView* self,
                                                                  GList* location_list,
                                                                  GFile* focus_location);
VALA_EXTERN void files_view_slot_select_gof_file (FilesViewSlot* self,
                                      FilesFile* gof);
VALA_EXTERN void files_abstract_directory_view_select_gof_file (FilesAbstractDirectoryView* self,
                                                    FilesFile* file);
static void files_view_slot_real_focus_first_for_empty_selection (FilesAbstractSlot* base,
                                                           gboolean select);
VALA_EXTERN void files_abstract_directory_view_focus_first_for_empty_selection (FilesAbstractDirectoryView* self,
                                                                    gboolean select);
static void files_view_slot_real_set_active_state (FilesAbstractSlot* base,
                                            gboolean set_active,
                                            gboolean animate);
static FilesAbstractSlot* files_view_slot_real_get_current_slot (FilesAbstractSlot* base);
VALA_EXTERN FilesAbstractDirectoryView* files_view_slot_get_directory_view (FilesViewSlot* self);
static void files_view_slot_real_grab_focus (FilesAbstractSlot* base);
static void files_view_slot_real_zoom_in (FilesAbstractSlot* base);
VALA_EXTERN void files_abstract_directory_view_zoom_in (FilesAbstractDirectoryView* self);
static void files_view_slot_real_zoom_out (FilesAbstractSlot* base);
VALA_EXTERN void files_abstract_directory_view_zoom_out (FilesAbstractDirectoryView* self);
static void files_view_slot_real_zoom_normal (FilesAbstractSlot* base);
VALA_EXTERN void files_abstract_directory_view_zoom_normal (FilesAbstractDirectoryView* self);
static void files_view_slot_real_close (FilesAbstractSlot* base);
static void files_view_slot_cancel_timeouts (FilesViewSlot* self);
VALA_EXTERN void files_abstract_directory_view_close (FilesAbstractDirectoryView* self);
VALA_EXTERN void files_view_slot_refresh_files (FilesViewSlot* self);
static GFileInfo* files_view_slot_real_lookup_file_info (FilesAbstractSlot* base,
                                                  GFile* loc);
static void files_view_slot_cancel_timeout (FilesViewSlot* self,
                                     guint* id);
static void files_view_slot_set_ctab (FilesViewSlot* self,
                               FilesViewViewContainer* value);
static void files_view_slot_set_mode (FilesViewSlot* self,
                               FilesViewMode value);
VALA_EXTERN gint files_view_slot_get_displayed_files_count (FilesViewSlot* self);
VALA_EXTERN FilesViewWindow* files_view_view_container_get_window (FilesViewViewContainer* self);
VALA_EXTERN gboolean files_abstract_directory_view_get_is_frozen (FilesAbstractDirectoryView* self);
VALA_EXTERN void files_abstract_directory_view_set_is_frozen (FilesAbstractDirectoryView* self,
                                                  gboolean value);
VALA_EXTERN gboolean files_abstract_directory_view_get_renaming (FilesAbstractDirectoryView* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GObject * files_view_slot_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
VALA_EXTERN FilesColumnView* files_column_view_new (FilesViewSlot* _slot);
VALA_EXTERN FilesColumnView* files_column_view_construct (GType object_type,
                                              FilesViewSlot* _slot);
VALA_EXTERN GType files_abstract_tree_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAbstractTreeView, g_object_unref)
VALA_EXTERN GType files_column_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesColumnView, g_object_unref)
VALA_EXTERN FilesListView* files_list_view_new (FilesViewSlot* _slot);
VALA_EXTERN FilesListView* files_list_view_construct (GType object_type,
                                          FilesViewSlot* _slot);
VALA_EXTERN GType files_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesListView, g_object_unref)
VALA_EXTERN FilesIconView* files_icon_view_new (FilesViewSlot* _slot);
VALA_EXTERN FilesIconView* files_icon_view_construct (GType object_type,
                                          FilesViewSlot* _slot);
VALA_EXTERN GType files_icon_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesIconView, g_object_unref)
static void files_view_slot_finalize (GObject * obj);
static GType files_view_slot_get_type_once (void);
static void _vala_files_view_slot_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_files_view_slot_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
files_view_slot_get_instance_private (FilesViewSlot* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewSlot_private_offset);
}

FilesViewSlot*
files_view_slot_construct (GType object_type,
                           GFile* _location,
                           FilesViewViewContainer* _ctab,
                           FilesViewMode _mode)
{
	FilesViewSlot * self = NULL;
	g_return_val_if_fail (_location != NULL, NULL);
	g_return_val_if_fail (_ctab != NULL, NULL);
	self = (FilesViewSlot*) g_object_new (object_type, "ctab", _ctab, "mode", _mode, "location", _location, NULL);
	return self;
}

FilesViewSlot*
files_view_slot_new (GFile* _location,
                     FilesViewViewContainer* _ctab,
                     FilesViewMode _mode)
{
	return files_view_slot_construct (FILES_VIEW_TYPE_SLOT, _location, _ctab, _mode);
}

static void
__lambda41_ (FilesViewSlot* self)
{
	gboolean _tmp0_;
	FilesAbstractDirectoryView* _tmp1_;
	_tmp0_ = self->priv->_is_active;
	if (_tmp0_) {
		return;
	}
	files_view_slot_set_is_active (self, TRUE);
	_tmp1_ = self->priv->dir_view;
	files_abstract_directory_view_grab_focus (_tmp1_);
}

static void
___lambda41__files_abstract_slot_active (FilesAbstractSlot* _sender,
                                         gboolean scroll,
                                         gboolean animate,
                                         gpointer self)
{
	__lambda41_ ((FilesViewSlot*) self);
}

static void
__lambda42_ (FilesViewSlot* self)
{
	files_view_slot_set_is_active (self, FALSE);
}

static void
___lambda42__files_abstract_slot_inactive (FilesAbstractSlot* _sender,
                                           gpointer self)
{
	__lambda42_ ((FilesViewSlot*) self);
}

static void
__lambda43_ (FilesViewSlot* self,
             FilesFile* file,
             FilesDirectory* dir)
{
	FilesViewWindow* _tmp0_;
	FilesViewWindow* _tmp1_;
	g_return_if_fail (file != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = files_view_slot_get_window (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FilesViewWindow* _tmp2_;
		FilesViewWindow* _tmp3_;
		GtkApplication* _tmp4_;
		GtkApplication* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp2_ = files_view_slot_get_window (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_window_get_application ((GtkWindow*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = files_file_get_location (file);
		_tmp7_ = _tmp6_;
		files_application_folder_deleted (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FILES_TYPE_APPLICATION, FilesApplication), _tmp7_);
	}
}

static void
___lambda43__files_view_slot_folder_deleted (FilesViewSlot* _sender,
                                             FilesFile* file,
                                             FilesDirectory* parent,
                                             gpointer self)
{
	__lambda43_ ((FilesViewSlot*) self, file, parent);
}

static void
files_view_slot_connect_slot_signals (FilesViewSlot* self)
{
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((FilesAbstractSlot*) self, "active", (GCallback) ___lambda41__files_abstract_slot_active, self, 0);
	g_signal_connect_object ((FilesAbstractSlot*) self, "inactive", (GCallback) ___lambda42__files_abstract_slot_inactive, self, 0);
	g_signal_connect_object (self, "folder-deleted", (GCallback) ___lambda43__files_view_slot_folder_deleted, self, 0);
}

static void
_files_view_slot_on_dir_view_path_change_request_files_abstract_directory_view_path_change_request (FilesAbstractDirectoryView* _sender,
                                                                                                    GFile* location,
                                                                                                    FilesOpenFlag flag,
                                                                                                    gboolean new_root,
                                                                                                    gpointer self)
{
	files_view_slot_on_dir_view_path_change_request ((FilesViewSlot*) self, location, flag, new_root);
}

static void
_files_view_slot_on_dir_view_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                     GtkAllocation* allocation,
                                                                     gpointer self)
{
	files_view_slot_on_dir_view_size_allocate ((FilesViewSlot*) self, allocation);
}

static void
_files_view_slot_on_dir_view_selection_changed_files_abstract_directory_view_selection_changed (FilesAbstractDirectoryView* _sender,
                                                                                                GList* gof_file,
                                                                                                gpointer self)
{
	files_view_slot_on_dir_view_selection_changed ((FilesViewSlot*) self, gof_file);
}

static void
files_view_slot_connect_dir_view_signals (FilesViewSlot* self)
{
	FilesAbstractDirectoryView* _tmp0_;
	FilesAbstractDirectoryView* _tmp1_;
	FilesAbstractDirectoryView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dir_view;
	g_signal_connect_object (_tmp0_, "path-change-request", (GCallback) _files_view_slot_on_dir_view_path_change_request_files_abstract_directory_view_path_change_request, self, 0);
	_tmp1_ = self->priv->dir_view;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "size-allocate", (GCallback) _files_view_slot_on_dir_view_size_allocate_gtk_widget_size_allocate, self, 0);
	_tmp2_ = self->priv->dir_view;
	g_signal_connect_object (_tmp2_, "selection-changed", (GCallback) _files_view_slot_on_dir_view_selection_changed_files_abstract_directory_view_selection_changed, self, 0);
}

static void
files_view_slot_disconnect_dir_view_signals (FilesViewSlot* self)
{
	FilesAbstractDirectoryView* _tmp0_;
	guint _tmp1_;
	FilesAbstractDirectoryView* _tmp2_;
	guint _tmp3_;
	FilesAbstractDirectoryView* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dir_view;
	g_signal_parse_name ("path-change-request", FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_view_slot_on_dir_view_path_change_request_files_abstract_directory_view_path_change_request, self);
	_tmp2_ = self->priv->dir_view;
	g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _files_view_slot_on_dir_view_size_allocate_gtk_widget_size_allocate, self);
	_tmp4_ = self->priv->dir_view;
	g_signal_parse_name ("selection-changed", FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _files_view_slot_on_dir_view_selection_changed_files_abstract_directory_view_selection_changed, self);
}

static void
files_view_slot_on_dir_view_size_allocate (FilesViewSlot* self,
                                           GtkAllocation* alloc)
{
	GtkAllocation _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alloc != NULL);
	_tmp0_ = *alloc;
	((FilesAbstractSlot*) self)->width = _tmp0_.width;
}

static void
files_view_slot_on_dir_view_selection_changed (FilesViewSlot* self,
                                               GList* files)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "selection-changed", files);
}

static void
_files_view_slot_on_directory_done_loading_files_directory_done_loading (FilesDirectory* _sender,
                                                                         gpointer self)
{
	files_view_slot_on_directory_done_loading ((FilesViewSlot*) self, _sender);
}

static void
_files_view_slot_on_directory_need_reload_files_directory_need_reload (FilesDirectory* _sender,
                                                                       gboolean original_request,
                                                                       gpointer self)
{
	files_view_slot_on_directory_need_reload ((FilesViewSlot*) self, _sender, original_request);
}

static void
files_view_slot_connect_dir_signals (FilesViewSlot* self)
{
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	FilesDirectory* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "done-loading", (GCallback) _files_view_slot_on_directory_done_loading_files_directory_done_loading, self, 0);
	_tmp2_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "need-reload", (GCallback) _files_view_slot_on_directory_need_reload_files_directory_need_reload, self, 0);
}

static void
files_view_slot_disconnect_dir_signals (FilesViewSlot* self)
{
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	guint _tmp2_;
	FilesDirectory* _tmp3_;
	FilesDirectory* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("done-loading", FILES_TYPE_DIRECTORY, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _files_view_slot_on_directory_done_loading_files_directory_done_loading, self);
	_tmp3_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("need-reload", FILES_TYPE_DIRECTORY, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _files_view_slot_on_directory_need_reload_files_directory_need_reload, self);
}

static void
files_view_slot_on_directory_done_loading (FilesViewSlot* self,
                                           FilesDirectory* dir)
{
	FilesViewMode _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "directory-loaded", dir);
	_tmp0_ = self->priv->_mode;
	if (_tmp0_ == FILES_VIEW_MODE_MILLER_COLUMNS) {
		FilesAbstractDirectoryView* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_ = FALSE;
		GtkPaned* _tmp13_;
		GtkBox* _tmp14_;
		GtkBox* _tmp15_;
		if (files_directory_is_empty (dir)) {
			PangoRectangle extents = {0};
			PangoLayout* layout = NULL;
			FilesAbstractDirectoryView* _tmp1_;
			PangoLayout* _tmp2_;
			PangoLayout* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			PangoLayout* _tmp6_;
			PangoRectangle _tmp7_ = {0};
			PangoRectangle _tmp8_;
			_tmp1_ = self->priv->dir_view;
			_tmp2_ = gtk_widget_create_pango_layout ((GtkWidget*) _tmp1_, NULL);
			layout = _tmp2_;
			_tmp3_ = layout;
			_tmp4_ = files_view_slot_get_empty_message (self);
			_tmp5_ = _tmp4_;
			pango_layout_set_markup (_tmp3_, _tmp5_, -1);
			_g_free0 (_tmp5_);
			_tmp6_ = layout;
			pango_layout_get_extents (_tmp6_, NULL, &_tmp7_);
			extents = _tmp7_;
			_tmp8_ = extents;
			((FilesAbstractSlot*) self)->width = (gint) pango_units_to_double (_tmp8_.width);
			_g_object_unref0 (layout);
		} else {
			((FilesAbstractSlot*) self)->width = self->priv->preferred_column_width;
		}
		_tmp9_ = self->priv->dir_view;
		_tmp10_ = files_abstract_directory_view_get_icon_size (_tmp9_);
		_tmp11_ = _tmp10_;
		((FilesAbstractSlot*) self)->width = ((FilesAbstractSlot*) self)->width + (_tmp11_ + 64);
		if (files_directory_is_empty (dir)) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = dir->permission_denied;
		}
		if (_tmp12_) {
			((FilesAbstractSlot*) self)->width = ((FilesAbstractSlot*) self)->width + ((FilesAbstractSlot*) self)->width;
		}
		g_signal_emit (self, files_view_slot_signals[FILES_VIEW_SLOT_SIZE_CHANGE_SIGNAL], 0);
		_tmp13_ = self->hpane;
		gtk_paned_set_position (_tmp13_, ((FilesAbstractSlot*) self)->width);
		_tmp14_ = self->colpane;
		gtk_widget_show_all ((GtkWidget*) _tmp14_);
		_tmp15_ = self->colpane;
		if (gtk_widget_get_realized ((GtkWidget*) _tmp15_)) {
			GtkBox* _tmp16_;
			_tmp16_ = self->colpane;
			gtk_widget_queue_draw ((GtkWidget*) _tmp16_);
		}
	}
	files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) self, FALSE);
}

static void
files_view_slot_on_directory_need_reload (FilesViewSlot* self,
                                          FilesDirectory* dir,
                                          gboolean original_request)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = files_abstract_slot_get_is_frozen ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		FilesViewViewContainer* _tmp2_;
		FilesAbstractSlot* _tmp3_;
		FilesAbstractSlot* _tmp4_;
		FilesAbstractDirectoryView* _tmp5_;
		_tmp2_ = self->priv->_ctab;
		_tmp3_ = files_view_view_container_prepare_reload (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		_tmp5_ = self->priv->dir_view;
		files_abstract_directory_view_prepare_reload (_tmp5_, dir);
		files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) self, TRUE);
		g_signal_emit_by_name ((FilesAbstractSlot*) self, "path-changed");
		if (original_request) {
			self->priv->original_reload_request = TRUE;
		}
		if (self->priv->original_reload_request) {
			files_view_slot_schedule_reload (self);
			self->priv->original_reload_request = FALSE;
		}
	}
}

static gboolean
__lambda58_ (FilesViewSlot* self)
{
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	gboolean result;
	_tmp0_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	files_directory_reload (_tmp1_);
	self->priv->reload_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda58__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda58_ ((FilesViewSlot*) self);
	return result;
}

static void
files_view_slot_schedule_reload (FilesViewSlot* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->reload_timeout_id > ((guint) 0)) {
		g_warning ("Slot.vala:234: Path change request received too rapidly");
		return;
	}
	self->priv->reload_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda58__gsource_func, g_object_ref (self), g_object_unref);
}

static void
files_view_slot_on_dir_view_path_change_request (FilesViewSlot* self,
                                                 GFile* loc,
                                                 FilesOpenFlag flag,
                                                 gboolean make_root)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (loc != NULL);
	if (flag == 0) {
		FilesViewMode _tmp0_;
		_tmp0_ = self->priv->_mode;
		if (_tmp0_ == FILES_VIEW_MODE_MILLER_COLUMNS) {
			g_signal_emit (self, files_view_slot_signals[FILES_VIEW_SLOT_MILLER_SLOT_REQUEST_SIGNAL], 0, loc, make_root);
		} else {
			files_abstract_slot_user_path_change_request ((FilesAbstractSlot*) self, loc, make_root);
		}
	} else {
		g_signal_emit_by_name ((FilesAbstractSlot*) self, "new-container-request", loc, flag);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
files_view_slot_real_user_path_change_request (FilesAbstractSlot* base,
                                               GFile* loc,
                                               gboolean make_root)
{
	FilesViewSlot * self;
	FilesDirectory* old_dir = NULL;
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	FilesDirectory* _tmp3_;
	FilesDirectory* _tmp4_;
	FilesAbstractDirectoryView* _tmp5_;
	FilesDirectory* _tmp6_;
	FilesDirectory* _tmp7_;
	FilesDirectory* _tmp8_;
	self = (FilesViewSlot*) base;
	g_return_if_fail (loc != NULL);
	_tmp0_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	old_dir = _tmp2_;
	_tmp3_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		files_view_slot_disconnect_dir_signals (self);
	}
	files_abstract_slot_set_location ((FilesAbstractSlot*) self, loc);
	files_view_slot_connect_dir_signals (self);
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "path-changed");
	_tmp5_ = self->priv->dir_view;
	_tmp6_ = old_dir;
	_tmp7_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp8_ = _tmp7_;
	files_abstract_directory_view_change_directory (_tmp5_, _tmp6_, _tmp8_);
	files_abstract_slot_initialize_directory ((FilesAbstractSlot*) self);
	_g_object_unref0 (old_dir);
}

static void
files_view_slot_real_initialize_directory (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	FilesDirectory* _tmp3_;
	self = (FilesViewSlot*) base;
	_tmp0_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	if (files_directory_is_loading (_tmp1_)) {
		g_debug ("Slot.vala:275: Slot.initialize_directory () called when directory alre" \
"ady loading - ignoring");
		return;
	}
	files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) self, TRUE);
	_tmp2_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp3_ = _tmp2_;
	files_directory_init (_tmp3_, NULL, NULL, NULL, NULL);
}

static void
files_view_slot_real_reload (FilesAbstractSlot* base,
                             gboolean non_local_only)
{
	FilesViewSlot * self;
	gboolean _tmp0_ = FALSE;
	self = (FilesViewSlot*) base;
	if (!non_local_only) {
		_tmp0_ = TRUE;
	} else {
		FilesDirectory* _tmp1_;
		FilesDirectory* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = files_directory_get_is_local (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (_tmp0_) {
		FilesDirectory* _tmp5_;
		FilesDirectory* _tmp6_;
		self->priv->original_reload_request = TRUE;
		_tmp5_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
		_tmp6_ = _tmp5_;
		g_signal_emit_by_name (_tmp6_, "need-reload", FALSE);
	}
}

static gboolean
files_view_slot_real_set_all_selected (FilesAbstractSlot* base,
                                       gboolean select_all)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	gboolean result;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		if (select_all) {
			FilesAbstractDirectoryView* _tmp1_;
			_tmp1_ = self->priv->dir_view;
			files_abstract_directory_view_select_all (_tmp1_);
		} else {
			FilesAbstractDirectoryView* _tmp2_;
			_tmp2_ = self->priv->dir_view;
			files_abstract_directory_view_unselect_all (_tmp2_);
		}
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static GList*
files_view_slot_real_get_selected_files (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	GList* result;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		GList* _tmp2_;
		_tmp1_ = self->priv->dir_view;
		_tmp2_ = files_abstract_directory_view_get_selected_files (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static void
files_view_slot_real_select_glib_files (FilesAbstractSlot* base,
                                        GList* files,
                                        GFile* focus_location)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		_tmp1_ = self->priv->dir_view;
		files_abstract_directory_view_select_glib_files_when_thawed (_tmp1_, files, focus_location);
	}
}

void
files_view_slot_select_gof_file (FilesViewSlot* self,
                                 FilesFile* gof)
{
	FilesAbstractDirectoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		_tmp1_ = self->priv->dir_view;
		files_abstract_directory_view_select_gof_file (_tmp1_, gof);
	}
}

static void
files_view_slot_real_focus_first_for_empty_selection (FilesAbstractSlot* base,
                                                      gboolean select)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		_tmp1_ = self->priv->dir_view;
		files_abstract_directory_view_focus_first_for_empty_selection (_tmp1_, select);
	}
}

static void
files_view_slot_real_set_active_state (FilesAbstractSlot* base,
                                       gboolean set_active,
                                       gboolean animate)
{
	FilesViewSlot * self;
	self = (FilesViewSlot*) base;
	if (set_active) {
		g_signal_emit_by_name ((FilesAbstractSlot*) self, "active", TRUE, animate);
	} else {
		g_signal_emit_by_name ((FilesAbstractSlot*) self, "inactive");
	}
}

static FilesAbstractSlot*
files_view_slot_real_get_current_slot (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	FilesAbstractSlot* result;
	self = (FilesViewSlot*) base;
	result = G_TYPE_CHECK_INSTANCE_TYPE (self, FILES_TYPE_ABSTRACT_SLOT) ? ((FilesAbstractSlot*) self) : NULL;
	return result;
}

FilesAbstractDirectoryView*
files_view_slot_get_directory_view (FilesViewSlot* self)
{
	FilesAbstractDirectoryView* _tmp0_;
	FilesAbstractDirectoryView* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dir_view;
	result = _tmp0_;
	return result;
}

static void
files_view_slot_real_grab_focus (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		_tmp1_ = self->priv->dir_view;
		files_abstract_directory_view_grab_focus (_tmp1_);
	}
}

static void
files_view_slot_real_zoom_in (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		_tmp1_ = self->priv->dir_view;
		files_abstract_directory_view_zoom_in (_tmp1_);
	}
}

static void
files_view_slot_real_zoom_out (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		_tmp1_ = self->priv->dir_view;
		files_abstract_directory_view_zoom_out (_tmp1_);
	}
}

static void
files_view_slot_real_zoom_normal (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	FilesAbstractDirectoryView* _tmp0_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	if (_tmp0_ != NULL) {
		FilesAbstractDirectoryView* _tmp1_;
		_tmp1_ = self->priv->dir_view;
		files_abstract_directory_view_zoom_normal (_tmp1_);
	}
}

static void
files_view_slot_real_close (FilesAbstractSlot* base)
{
	FilesViewSlot * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FilesDirectory* _tmp2_;
	FilesDirectory* _tmp3_;
	FilesAbstractDirectoryView* _tmp6_;
	self = (FilesViewSlot*) base;
	_tmp0_ = files_abstract_slot_get_uri ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	g_debug ("Slot.vala:372: SLOT close %s", _tmp1_);
	files_view_slot_cancel_timeouts (self);
	_tmp2_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		FilesDirectory* _tmp4_;
		FilesDirectory* _tmp5_;
		_tmp4_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
		_tmp5_ = _tmp4_;
		files_directory_cancel (_tmp5_);
		files_view_slot_disconnect_dir_signals (self);
	}
	_tmp6_ = self->priv->dir_view;
	if (_tmp6_ != NULL) {
		FilesAbstractDirectoryView* _tmp7_;
		_tmp7_ = self->priv->dir_view;
		files_abstract_directory_view_close (_tmp7_);
		files_view_slot_disconnect_dir_view_signals (self);
	}
}

void
files_view_slot_refresh_files (FilesViewSlot* self)
{
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FilesDirectory* _tmp2_;
		FilesDirectory* _tmp3_;
		_tmp2_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
		_tmp3_ = _tmp2_;
		files_directory_update_files (_tmp3_);
	}
}

static GFileInfo*
files_view_slot_real_lookup_file_info (FilesAbstractSlot* base,
                                       GFile* loc)
{
	FilesViewSlot * self;
	FilesFile* gof = NULL;
	FilesDirectory* _tmp0_;
	FilesDirectory* _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	GFileInfo* result;
	self = (FilesViewSlot*) base;
	g_return_val_if_fail (loc != NULL, NULL);
	_tmp0_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_directory_file_hash_lookup_location (_tmp1_, loc);
	gof = _tmp2_;
	_tmp3_ = gof;
	if (_tmp3_ != NULL) {
		FilesFile* _tmp4_;
		GFileInfo* _tmp5_;
		GFileInfo* _tmp6_;
		_tmp4_ = gof;
		_tmp5_ = _tmp4_->info;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		result = _tmp6_;
		_g_object_unref0 (gof);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (gof);
		return result;
	}
}

static void
files_view_slot_cancel_timeouts (FilesViewSlot* self)
{
	g_return_if_fail (self != NULL);
	files_view_slot_cancel_timeout (self, &self->priv->reload_timeout_id);
	files_view_slot_cancel_timeout (self, &self->priv->path_change_timeout_id);
}

static void
files_view_slot_cancel_timeout (FilesViewSlot* self,
                                guint* id)
{
	g_return_if_fail (self != NULL);
	if ((*id) > ((guint) 0)) {
		g_source_remove (*id);
		*id = (guint) 0;
	}
}

gchar*
files_view_slot_get_empty_message (FilesViewSlot* self)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (FILES_VIEW_SLOT_EMPTY_MESSAGE);
	msg = _tmp0_;
	_tmp1_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = files_directory_get_is_recent (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (FILES_VIEW_SLOT_EMPTY_RECENT_MESSAGE);
		_g_free0 (msg);
		msg = _tmp5_;
	} else {
		gboolean _tmp6_ = FALSE;
		FilesDirectory* _tmp7_;
		FilesDirectory* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = files_directory_get_is_trash (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = files_abstract_slot_get_uri ((FilesAbstractSlot*) self);
			_tmp12_ = _tmp11_;
			_tmp6_ = g_strcmp0 (_tmp12_, FILES_TRASH_URI G_DIR_SEPARATOR_S) == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup (FILES_VIEW_SLOT_EMPTY_TRASH_MESSAGE);
			_g_free0 (msg);
			msg = _tmp13_;
		} else {
			FilesDirectory* _tmp14_;
			FilesDirectory* _tmp15_;
			_tmp14_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
			_tmp15_ = _tmp14_;
			if (_tmp15_->permission_denied) {
				gchar* _tmp16_;
				_tmp16_ = g_strdup (FILES_VIEW_SLOT_DENIED_MESSAGE);
				_g_free0 (msg);
				msg = _tmp16_;
			}
		}
	}
	result = msg;
	return result;
}

FilesViewViewContainer*
files_view_slot_get_ctab (FilesViewSlot* self)
{
	FilesViewViewContainer* result;
	FilesViewViewContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ctab;
	result = _tmp0_;
	return result;
}

static void
files_view_slot_set_ctab (FilesViewSlot* self,
                          FilesViewViewContainer* value)
{
	FilesViewViewContainer* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_slot_get_ctab (self);
	if (old_value != value) {
		self->priv->_ctab = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_slot_properties[FILES_VIEW_SLOT_CTAB_PROPERTY]);
	}
}

FilesViewMode
files_view_slot_get_mode (FilesViewSlot* self)
{
	FilesViewMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

static void
files_view_slot_set_mode (FilesViewSlot* self,
                          FilesViewMode value)
{
	FilesViewMode old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_slot_get_mode (self);
	if (old_value != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_slot_properties[FILES_VIEW_SLOT_MODE_PROPERTY]);
	}
}

gboolean
files_view_slot_get_is_active (FilesViewSlot* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_active;
	return result;
}

void
files_view_slot_set_is_active (FilesViewSlot* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_slot_get_is_active (self);
	if (old_value != value) {
		self->priv->_is_active = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_slot_properties[FILES_VIEW_SLOT_IS_ACTIVE_PROPERTY]);
	}
}

gint
files_view_slot_get_displayed_files_count (FilesViewSlot* self)
{
	gint result;
	gboolean _tmp0_ = FALSE;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FilesDirectory* _tmp3_;
		FilesDirectory* _tmp4_;
		FilesDirectoryState _tmp5_;
		FilesDirectoryState _tmp6_;
		_tmp3_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = files_directory_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == FILES_DIRECTORY_STATE_LOADED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FilesDirectory* _tmp7_;
		FilesDirectory* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		_tmp7_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = files_directory_get_displayed_files_count (_tmp8_);
		_tmp10_ = _tmp9_;
		result = (gint) _tmp10_;
		return result;
	}
	result = -1;
	return result;
}

FilesViewWindow*
files_view_slot_get_window (FilesViewSlot* self)
{
	FilesViewWindow* result;
	FilesViewViewContainer* _tmp0_;
	FilesViewWindow* _tmp1_;
	FilesViewWindow* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ctab;
	_tmp1_ = files_view_view_container_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
files_view_slot_real_get_is_frozen (FilesAbstractSlot* base)
{
	gboolean result;
	FilesViewSlot* self;
	gboolean _tmp0_ = FALSE;
	FilesAbstractDirectoryView* _tmp1_;
	self = (FilesViewSlot*) base;
	_tmp1_ = self->priv->dir_view;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FilesAbstractDirectoryView* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->dir_view;
		_tmp3_ = files_abstract_directory_view_get_is_frozen (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static void
files_view_slot_real_set_is_frozen (FilesAbstractSlot* base,
                                    gboolean value)
{
	FilesViewSlot* self;
	FilesAbstractDirectoryView* _tmp0_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	files_abstract_directory_view_set_is_frozen (_tmp0_, value);
	g_signal_emit (self, files_view_slot_signals[FILES_VIEW_SLOT_FROZEN_CHANGED_SIGNAL], 0, value);
	g_object_notify_by_pspec ((GObject *) self, files_view_slot_properties[FILES_VIEW_SLOT_IS_FROZEN_PROPERTY]);
}

static gboolean
files_view_slot_real_get_locked_focus (FilesAbstractSlot* base)
{
	gboolean result;
	FilesViewSlot* self;
	FilesAbstractDirectoryView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (FilesViewSlot*) base;
	_tmp0_ = self->priv->dir_view;
	_tmp1_ = files_abstract_directory_view_get_renaming (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static GObject *
files_view_slot_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewSlot * self;
	FilesViewMode _tmp0_;
	FilesViewMode _tmp4_;
	GSettings* _tmp6_;
	parent_class = G_OBJECT_CLASS (files_view_slot_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_SLOT, FilesViewSlot);
	_tmp0_ = self->priv->_mode;
	switch (_tmp0_) {
		case FILES_VIEW_MODE_MILLER_COLUMNS:
		{
			FilesColumnView* _tmp1_;
			_tmp1_ = files_column_view_new (self);
			g_object_ref_sink (_tmp1_);
			_g_object_unref0 (self->priv->dir_view);
			self->priv->dir_view = (FilesAbstractDirectoryView*) _tmp1_;
			break;
		}
		case FILES_VIEW_MODE_LIST:
		{
			FilesListView* _tmp2_;
			_tmp2_ = files_list_view_new (self);
			g_object_ref_sink (_tmp2_);
			_g_object_unref0 (self->priv->dir_view);
			self->priv->dir_view = (FilesAbstractDirectoryView*) _tmp2_;
			break;
		}
		case FILES_VIEW_MODE_ICON:
		{
			FilesIconView* _tmp3_;
			_tmp3_ = files_icon_view_new (self);
			g_object_ref_sink (_tmp3_);
			_g_object_unref0 (self->priv->dir_view);
			self->priv->dir_view = (FilesAbstractDirectoryView*) _tmp3_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp4_ = self->priv->_mode;
	if (_tmp4_ != FILES_VIEW_MODE_MILLER_COLUMNS) {
		FilesAbstractDirectoryView* _tmp5_;
		_tmp5_ = self->priv->dir_view;
		files_abstract_slot_add_overlay ((FilesAbstractSlot*) self, (GtkWidget*) _tmp5_);
	}
	files_view_slot_connect_dir_signals (self);
	files_view_slot_connect_dir_view_signals (self);
	files_view_slot_connect_slot_signals (self);
	files_view_slot_set_is_active (self, FALSE);
	files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) self, TRUE);
	_tmp6_ = files_column_view_settings;
	self->priv->preferred_column_width = g_settings_get_int (_tmp6_, "preferred-column-width");
	((FilesAbstractSlot*) self)->width = self->priv->preferred_column_width;
	return obj;
}

static void
files_view_slot_class_init (FilesViewSlotClass * klass,
                            gpointer klass_data)
{
	files_view_slot_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewSlot_private_offset);
	((FilesAbstractSlotClass *) klass)->user_path_change_request = (void (*) (FilesAbstractSlot*, GFile*, gboolean)) files_view_slot_real_user_path_change_request;
	((FilesAbstractSlotClass *) klass)->initialize_directory = (void (*) (FilesAbstractSlot*)) files_view_slot_real_initialize_directory;
	((FilesAbstractSlotClass *) klass)->reload = (void (*) (FilesAbstractSlot*, gboolean)) files_view_slot_real_reload;
	((FilesAbstractSlotClass *) klass)->set_all_selected = (gboolean (*) (FilesAbstractSlot*, gboolean)) files_view_slot_real_set_all_selected;
	((FilesAbstractSlotClass *) klass)->get_selected_files = (GList* (*) (FilesAbstractSlot*)) files_view_slot_real_get_selected_files;
	((FilesAbstractSlotClass *) klass)->select_glib_files = (void (*) (FilesAbstractSlot*, GList*, GFile*)) files_view_slot_real_select_glib_files;
	((FilesAbstractSlotClass *) klass)->focus_first_for_empty_selection = (void (*) (FilesAbstractSlot*, gboolean)) files_view_slot_real_focus_first_for_empty_selection;
	((FilesAbstractSlotClass *) klass)->set_active_state = (void (*) (FilesAbstractSlot*, gboolean, gboolean)) files_view_slot_real_set_active_state;
	((FilesAbstractSlotClass *) klass)->get_current_slot = (FilesAbstractSlot* (*) (FilesAbstractSlot*)) files_view_slot_real_get_current_slot;
	((FilesAbstractSlotClass *) klass)->grab_focus = (void (*) (FilesAbstractSlot*)) files_view_slot_real_grab_focus;
	((FilesAbstractSlotClass *) klass)->zoom_in = (void (*) (FilesAbstractSlot*)) files_view_slot_real_zoom_in;
	((FilesAbstractSlotClass *) klass)->zoom_out = (void (*) (FilesAbstractSlot*)) files_view_slot_real_zoom_out;
	((FilesAbstractSlotClass *) klass)->zoom_normal = (void (*) (FilesAbstractSlot*)) files_view_slot_real_zoom_normal;
	((FilesAbstractSlotClass *) klass)->close = (void (*) (FilesAbstractSlot*)) files_view_slot_real_close;
	((FilesAbstractSlotClass *) klass)->lookup_file_info = (GFileInfo* (*) (FilesAbstractSlot*, GFile*)) files_view_slot_real_lookup_file_info;
	FILES_ABSTRACT_SLOT_CLASS (klass)->get_is_frozen = (gboolean (*) (FilesAbstractSlot*)) files_view_slot_real_get_is_frozen;
	FILES_ABSTRACT_SLOT_CLASS (klass)->set_is_frozen = (void (*) (FilesAbstractSlot*, gboolean)) files_view_slot_real_set_is_frozen;
	FILES_ABSTRACT_SLOT_CLASS (klass)->get_locked_focus = (gboolean (*) (FilesAbstractSlot*)) files_view_slot_real_get_locked_focus;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_slot_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_slot_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_view_slot_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_slot_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_SLOT_CTAB_PROPERTY, files_view_slot_properties[FILES_VIEW_SLOT_CTAB_PROPERTY] = g_param_spec_object ("ctab", "ctab", "ctab", FILES_VIEW_TYPE_VIEW_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_SLOT_MODE_PROPERTY, files_view_slot_properties[FILES_VIEW_SLOT_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", FILES_TYPE_VIEW_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_SLOT_IS_ACTIVE_PROPERTY, files_view_slot_properties[FILES_VIEW_SLOT_IS_ACTIVE_PROPERTY] = g_param_spec_boolean ("is-active", "is-active", "is-active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_SLOT_DISPLAYED_FILES_COUNT_PROPERTY, files_view_slot_properties[FILES_VIEW_SLOT_DISPLAYED_FILES_COUNT_PROPERTY] = g_param_spec_int ("displayed-files-count", "displayed-files-count", "displayed-files-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_SLOT_WINDOW_PROPERTY, files_view_slot_properties[FILES_VIEW_SLOT_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", FILES_VIEW_TYPE_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_SLOT_IS_FROZEN_PROPERTY, files_view_slot_properties[FILES_VIEW_SLOT_IS_FROZEN_PROPERTY] = g_param_spec_boolean ("is-frozen", "is-frozen", "is-frozen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_SLOT_LOCKED_FOCUS_PROPERTY, files_view_slot_properties[FILES_VIEW_SLOT_LOCKED_FOCUS_PROPERTY] = g_param_spec_boolean ("locked-focus", "locked-focus", "locked-focus", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	files_view_slot_signals[FILES_VIEW_SLOT_FROZEN_CHANGED_SIGNAL] = g_signal_new ("frozen-changed", FILES_VIEW_TYPE_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	files_view_slot_signals[FILES_VIEW_SLOT_FOLDER_DELETED_SIGNAL] = g_signal_new ("folder-deleted", FILES_VIEW_TYPE_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, FILES_TYPE_FILE, FILES_TYPE_DIRECTORY);
	files_view_slot_signals[FILES_VIEW_SLOT_MILLER_SLOT_REQUEST_SIGNAL] = g_signal_new ("miller-slot-request", FILES_VIEW_TYPE_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, g_file_get_type (), G_TYPE_BOOLEAN);
	files_view_slot_signals[FILES_VIEW_SLOT_SIZE_CHANGE_SIGNAL] = g_signal_new ("size-change", FILES_VIEW_TYPE_SLOT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
files_view_slot_instance_init (FilesViewSlot * self,
                               gpointer klass)
{
	self->priv = files_view_slot_get_instance_private (self);
	self->priv->dir_view = NULL;
	self->priv->reload_timeout_id = (guint) 0;
	self->priv->path_change_timeout_id = (guint) 0;
	self->priv->original_reload_request = FALSE;
}

static void
files_view_slot_finalize (GObject * obj)
{
	FilesViewSlot * self;
	gint _tmp0_;
	gint _tmp1_;
	FilesAbstractDirectoryView* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_SLOT, FilesViewSlot);
	_tmp0_ = files_abstract_slot_get_slot_number ((FilesAbstractSlot*) self);
	_tmp1_ = _tmp0_;
	g_debug ("Slot.vala:119: Slot %i destruct", _tmp1_);
	_tmp2_ = self->priv->dir_view;
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
	_g_object_unref0 (self->priv->dir_view);
	_g_object_unref0 (self->colpane);
	_g_object_unref0 (self->hpane);
	G_OBJECT_CLASS (files_view_slot_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_slot_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewSlotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_slot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewSlot), 0, (GInstanceInitFunc) files_view_slot_instance_init, NULL };
	GType files_view_slot_type_id;
	files_view_slot_type_id = g_type_register_static (FILES_TYPE_ABSTRACT_SLOT, "FilesViewSlot", &g_define_type_info, 0);
	FilesViewSlot_private_offset = g_type_add_instance_private (files_view_slot_type_id, sizeof (FilesViewSlotPrivate));
	return files_view_slot_type_id;
}

GType
files_view_slot_get_type (void)
{
	static volatile gsize files_view_slot_type_id__once = 0;
	if (g_once_init_enter (&files_view_slot_type_id__once)) {
		GType files_view_slot_type_id;
		files_view_slot_type_id = files_view_slot_get_type_once ();
		g_once_init_leave (&files_view_slot_type_id__once, files_view_slot_type_id);
	}
	return files_view_slot_type_id__once;
}

static void
_vala_files_view_slot_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	FilesViewSlot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_SLOT, FilesViewSlot);
	switch (property_id) {
		case FILES_VIEW_SLOT_CTAB_PROPERTY:
		g_value_set_object (value, files_view_slot_get_ctab (self));
		break;
		case FILES_VIEW_SLOT_MODE_PROPERTY:
		g_value_set_enum (value, files_view_slot_get_mode (self));
		break;
		case FILES_VIEW_SLOT_IS_ACTIVE_PROPERTY:
		g_value_set_boolean (value, files_view_slot_get_is_active (self));
		break;
		case FILES_VIEW_SLOT_DISPLAYED_FILES_COUNT_PROPERTY:
		g_value_set_int (value, files_view_slot_get_displayed_files_count (self));
		break;
		case FILES_VIEW_SLOT_WINDOW_PROPERTY:
		g_value_set_object (value, files_view_slot_get_window (self));
		break;
		case FILES_VIEW_SLOT_IS_FROZEN_PROPERTY:
		g_value_set_boolean (value, files_abstract_slot_get_is_frozen ((FilesAbstractSlot*) self));
		break;
		case FILES_VIEW_SLOT_LOCKED_FOCUS_PROPERTY:
		g_value_set_boolean (value, files_abstract_slot_get_locked_focus ((FilesAbstractSlot*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_slot_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	FilesViewSlot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_SLOT, FilesViewSlot);
	switch (property_id) {
		case FILES_VIEW_SLOT_CTAB_PROPERTY:
		files_view_slot_set_ctab (self, g_value_get_object (value));
		break;
		case FILES_VIEW_SLOT_MODE_PROPERTY:
		files_view_slot_set_mode (self, g_value_get_enum (value));
		break;
		case FILES_VIEW_SLOT_IS_ACTIVE_PROPERTY:
		files_view_slot_set_is_active (self, g_value_get_boolean (value));
		break;
		case FILES_VIEW_SLOT_IS_FROZEN_PROPERTY:
		files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

