/* ErrorView.c generated by valac 0.56.18, the Vala compiler
 * generated from ErrorView.vala, do not modify */

/*
 * Copyright 2019-2022 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <flatpak.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ABSTRACT_VIEW (abstract_view_get_type ())
#define ABSTRACT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_VIEW, AbstractView))
#define ABSTRACT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_VIEW, AbstractViewClass))
#define IS_ABSTRACT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_VIEW))
#define IS_ABSTRACT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_VIEW))
#define ABSTRACT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_VIEW, AbstractViewClass))

typedef struct _AbstractView AbstractView;
typedef struct _AbstractViewClass AbstractViewClass;
typedef struct _AbstractViewPrivate AbstractViewPrivate;

#define SIDELOAD_TYPE_ERROR_VIEW (sideload_error_view_get_type ())
#define SIDELOAD_ERROR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorView))
#define SIDELOAD_ERROR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorViewClass))
#define SIDELOAD_IS_ERROR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_ERROR_VIEW))
#define SIDELOAD_IS_ERROR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_ERROR_VIEW))
#define SIDELOAD_ERROR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorViewClass))

typedef struct _SideloadErrorView SideloadErrorView;
typedef struct _SideloadErrorViewClass SideloadErrorViewClass;
typedef struct _SideloadErrorViewPrivate SideloadErrorViewPrivate;
enum  {
	SIDELOAD_ERROR_VIEW_0_PROPERTY,
	SIDELOAD_ERROR_VIEW_ERROR_CODE_PROPERTY,
	SIDELOAD_ERROR_VIEW_ERROR_MESSAGE_PROPERTY,
	SIDELOAD_ERROR_VIEW_NUM_PROPERTIES
};
static GParamSpec* sideload_error_view_properties[SIDELOAD_ERROR_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _AbstractView {
	GtkBox parent_instance;
	AbstractViewPrivate * priv;
	GtkBox* button_box;
	GtkGrid* content_area;
	GtkImage* badge;
	GtkLabel* primary_label;
	GtkLabel* secondary_label;
};

struct _AbstractViewClass {
	GtkBoxClass parent_class;
};

struct _SideloadErrorView {
	AbstractView parent_instance;
	SideloadErrorViewPrivate * priv;
};

struct _SideloadErrorViewClass {
	AbstractViewClass parent_class;
};

struct _SideloadErrorViewPrivate {
	gint _error_code;
	gchar* _error_message;
};

static gint SideloadErrorView_private_offset;
static gpointer sideload_error_view_parent_class = NULL;

VALA_EXTERN GType abstract_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractView, g_object_unref)
VALA_EXTERN GType sideload_error_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadErrorView, g_object_unref)
VALA_EXTERN SideloadErrorView* sideload_error_view_new (gint error_code,
                                            const gchar* error_message);
VALA_EXTERN SideloadErrorView* sideload_error_view_construct (GType object_type,
                                                  gint error_code,
                                                  const gchar* error_message);
static gchar* sideload_error_view_prettify_flatpak_error (gint error_code,
                                                   const gchar* error_message);
VALA_EXTERN gint sideload_error_view_get_error_code (SideloadErrorView* self);
static void sideload_error_view_set_error_code (SideloadErrorView* self,
                                         gint value);
VALA_EXTERN const gchar* sideload_error_view_get_error_message (SideloadErrorView* self);
static void sideload_error_view_set_error_message (SideloadErrorView* self,
                                            const gchar* value);
static GObject * sideload_error_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void sideload_error_view_finalize (GObject * obj);
static GType sideload_error_view_get_type_once (void);
static void _vala_sideload_error_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_sideload_error_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
sideload_error_view_get_instance_private (SideloadErrorView* self)
{
	return G_STRUCT_MEMBER_P (self, SideloadErrorView_private_offset);
}

SideloadErrorView*
sideload_error_view_construct (GType object_type,
                               gint error_code,
                               const gchar* error_message)
{
	SideloadErrorView * self = NULL;
	self = (SideloadErrorView*) g_object_new (object_type, "error-code", error_code, "error-message", error_message, NULL);
	return self;
}

SideloadErrorView*
sideload_error_view_new (gint error_code,
                         const gchar* error_message)
{
	return sideload_error_view_construct (SIDELOAD_TYPE_ERROR_VIEW, error_code, error_message);
}

static gchar*
sideload_error_view_prettify_flatpak_error (gint error_code,
                                            const gchar* error_message)
{
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* result;
	if (error_code >= 0) {
		switch (error_code) {
			case FLATPAK_ERROR_ALREADY_INSTALLED:
			{
				gchar* _tmp0_;
				_tmp0_ = g_strdup (_ ("This app is already installed."));
				result = _tmp0_;
				return result;
			}
			case FLATPAK_ERROR_NEED_NEW_FLATPAK:
			{
				gchar* _tmp1_;
				_tmp1_ = g_strdup (_ ("A newer version of Flatpak is needed to install this app."));
				result = _tmp1_;
				return result;
			}
			case FLATPAK_ERROR_REMOTE_NOT_FOUND:
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup (_ ("A required Flatpak remote was not found."));
				result = _tmp2_;
				return result;
			}
			case FLATPAK_ERROR_RUNTIME_NOT_FOUND:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup (_ ("A required runtime dependency could not be found."));
				result = _tmp3_;
				return result;
			}
			case FLATPAK_ERROR_INVALID_REF:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (_ ("The supplied .flatpakref file does not seem to be valid."));
				result = _tmp4_;
				return result;
			}
			case FLATPAK_ERROR_UNTRUSTED:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (_ ("The app is not signed with a trusted signature."));
				result = _tmp5_;
				return result;
			}
			case FLATPAK_ERROR_INVALID_NAME:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup (_ ("The application, runtime, or remote name is invalid."));
				result = _tmp6_;
				return result;
			}
			default:
			break;
		}
	}
	_tmp7_ = error_message;
	if (_tmp7_ == NULL) {
		_tmp7_ = _ ("An unknown error occurred.");
	}
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	return result;
}

gint
sideload_error_view_get_error_code (SideloadErrorView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_error_code;
	return result;
}

static void
sideload_error_view_set_error_code (SideloadErrorView* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_error_view_get_error_code (self);
	if (old_value != value) {
		self->priv->_error_code = value;
		g_object_notify_by_pspec ((GObject *) self, sideload_error_view_properties[SIDELOAD_ERROR_VIEW_ERROR_CODE_PROPERTY]);
	}
}

const gchar*
sideload_error_view_get_error_message (SideloadErrorView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_message;
	result = _tmp0_;
	return result;
}

static void
sideload_error_view_set_error_message (SideloadErrorView* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_error_view_get_error_message (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_error_message);
		self->priv->_error_message = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sideload_error_view_properties[SIDELOAD_ERROR_VIEW_ERROR_MESSAGE_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
sideload_error_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SideloadErrorView * self;
	GtkImage* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkLabel* details_view = NULL;
	const gchar* _tmp9_;
	GtkLabel* _tmp10_ = NULL;
	GtkScrolledWindow* scroll_box = NULL;
	GtkLabel* _tmp11_;
	GtkWidget* _tmp12_;
	GtkScrolledWindow* _tmp13_ = NULL;
	GtkScrolledWindow* _tmp14_;
	GtkExpander* expander = NULL;
	GtkScrolledWindow* _tmp15_;
	GtkWidget* _tmp16_;
	GtkExpander* _tmp17_ = NULL;
	GtkButton* close_button = NULL;
	gchar* _tmp18_;
	GtkButton* _tmp19_ = NULL;
	GtkGrid* _tmp20_;
	GtkExpander* _tmp21_;
	GtkBox* _tmp22_;
	GtkButton* _tmp23_;
	parent_class = G_OBJECT_CLASS (sideload_error_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorView);
	_tmp0_ = ((AbstractView*) self)->badge;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "gicon", (GIcon*) _tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = ((AbstractView*) self)->primary_label;
	gtk_label_set_label (_tmp3_, _ ("Install failed"));
	_tmp4_ = ((AbstractView*) self)->secondary_label;
	_tmp5_ = self->priv->_error_code;
	_tmp6_ = self->priv->_error_message;
	_tmp7_ = sideload_error_view_prettify_flatpak_error (_tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->_error_message;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	gtk_label_set_selectable (_tmp10_, TRUE);
	gtk_label_set_wrap (_tmp10_, TRUE);
	gtk_label_set_xalign (_tmp10_, (gfloat) 0);
	gtk_label_set_yalign (_tmp10_, (gfloat) 0);
	g_object_ref_sink (_tmp10_);
	details_view = _tmp10_;
	_tmp11_ = details_view;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp13_, 12);
	gtk_scrolled_window_set_min_content_height (_tmp13_, 70);
	g_object_ref_sink (_tmp13_);
	scroll_box = _tmp13_;
	_tmp14_ = scroll_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp14_, GRANITE_STYLE_CLASS_TERMINAL);
	_tmp15_ = scroll_box;
	_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
	_tmp17_ = (GtkExpander*) gtk_expander_new (_ ("Details"));
	gtk_expander_set_child (_tmp17_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	expander = _tmp17_;
	_tmp18_ = g_strdup ("app.quit");
	_tmp19_ = (GtkButton*) gtk_button_new_with_label (_ ("Close"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp19_, _tmp18_);
	_g_free0 (_tmp18_);
	g_object_ref_sink (_tmp19_);
	close_button = _tmp19_;
	_tmp20_ = ((AbstractView*) self)->content_area;
	_tmp21_ = expander;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 0, 1, 1);
	_tmp22_ = ((AbstractView*) self)->button_box;
	_tmp23_ = close_button;
	gtk_box_append (_tmp22_, (GtkWidget*) _tmp23_);
	_g_object_unref0 (close_button);
	_g_object_unref0 (expander);
	_g_object_unref0 (scroll_box);
	_g_object_unref0 (details_view);
	return obj;
}

static void
sideload_error_view_class_init (SideloadErrorViewClass * klass,
                                gpointer klass_data)
{
	sideload_error_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SideloadErrorView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sideload_error_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sideload_error_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = sideload_error_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = sideload_error_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_ERROR_VIEW_ERROR_CODE_PROPERTY, sideload_error_view_properties[SIDELOAD_ERROR_VIEW_ERROR_CODE_PROPERTY] = g_param_spec_int ("error-code", "error-code", "error-code", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_ERROR_VIEW_ERROR_MESSAGE_PROPERTY, sideload_error_view_properties[SIDELOAD_ERROR_VIEW_ERROR_MESSAGE_PROPERTY] = g_param_spec_string ("error-message", "error-message", "error-message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
sideload_error_view_instance_init (SideloadErrorView * self,
                                   gpointer klass)
{
	self->priv = sideload_error_view_get_instance_private (self);
}

static void
sideload_error_view_finalize (GObject * obj)
{
	SideloadErrorView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorView);
	_g_free0 (self->priv->_error_message);
	G_OBJECT_CLASS (sideload_error_view_parent_class)->finalize (obj);
}

static GType
sideload_error_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SideloadErrorViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sideload_error_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SideloadErrorView), 0, (GInstanceInitFunc) sideload_error_view_instance_init, NULL };
	GType sideload_error_view_type_id;
	sideload_error_view_type_id = g_type_register_static (TYPE_ABSTRACT_VIEW, "SideloadErrorView", &g_define_type_info, 0);
	SideloadErrorView_private_offset = g_type_add_instance_private (sideload_error_view_type_id, sizeof (SideloadErrorViewPrivate));
	return sideload_error_view_type_id;
}

GType
sideload_error_view_get_type (void)
{
	static volatile gsize sideload_error_view_type_id__once = 0;
	if (g_once_init_enter (&sideload_error_view_type_id__once)) {
		GType sideload_error_view_type_id;
		sideload_error_view_type_id = sideload_error_view_get_type_once ();
		g_once_init_leave (&sideload_error_view_type_id__once, sideload_error_view_type_id);
	}
	return sideload_error_view_type_id__once;
}

static void
_vala_sideload_error_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SideloadErrorView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorView);
	switch (property_id) {
		case SIDELOAD_ERROR_VIEW_ERROR_CODE_PROPERTY:
		g_value_set_int (value, sideload_error_view_get_error_code (self));
		break;
		case SIDELOAD_ERROR_VIEW_ERROR_MESSAGE_PROPERTY:
		g_value_set_string (value, sideload_error_view_get_error_message (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sideload_error_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SideloadErrorView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorView);
	switch (property_id) {
		case SIDELOAD_ERROR_VIEW_ERROR_CODE_PROPERTY:
		sideload_error_view_set_error_code (self, g_value_get_int (value));
		break;
		case SIDELOAD_ERROR_VIEW_ERROR_MESSAGE_PROPERTY:
		sideload_error_view_set_error_message (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

