/* DataImportsInterfaces.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DataImportsInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-plugin-dev-1.0.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

/**
 * The error domain for alien databases
 */

static void spit_data_imports_data_importer_real_reserved0 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved1 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved2 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved3 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved4 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved5 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved6 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved7 (SpitDataImportsDataImporter* self);
static GType spit_data_imports_data_importer_get_type_once (void);
static GType spit_data_imports_importable_library_get_type_once (void);
static GType spit_data_imports_importable_media_item_get_type_once (void);
static GType spit_data_imports_importable_tag_get_type_once (void);
static GType spit_data_imports_importable_event_get_type_once (void);
static GType spit_data_imports_importable_rating_get_type_once (void);
static void spit_data_imports_dialog_pane_real_reserved0 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved1 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved2 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved3 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved4 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved5 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved6 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved7 (SpitDataImportsDialogPane* self);
static GType spit_data_imports_dialog_pane_get_type_once (void);
static void spit_data_imports_plugin_host_real_reserved0 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved1 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved2 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved3 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved4 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved5 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved6 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved7 (SpitDataImportsPluginHost* self);
static GType spit_data_imports_plugin_host_get_type_once (void);
static void spit_data_imports_service_real_reserved0 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved1 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved2 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved3 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved4 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved5 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved6 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved7 (SpitDataImportsService* self);
static GType spit_data_imports_service_get_type_once (void);

GQuark
spit_data_imports_data_import_error_quark (void)
{
	return g_quark_from_static_string ("spit-data-imports-data-import-error-quark");
}

static GType
spit_data_imports_data_import_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_DATA_IMPORTS_DATA_IMPORT_ERROR_UNSUPPORTED_VERSION, "SPIT_DATA_IMPORTS_DATA_IMPORT_ERROR_UNSUPPORTED_VERSION", "unsupported-version"}, {0, NULL, NULL}};
	GType spit_data_imports_data_import_error_type_id;
	spit_data_imports_data_import_error_type_id = g_enum_register_static ("SpitDataImportsDataImportError", values);
	return spit_data_imports_data_import_error_type_id;
}

GType
spit_data_imports_data_import_error_get_type (void)
{
	static volatile gsize spit_data_imports_data_import_error_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_data_import_error_type_id__once)) {
		GType spit_data_imports_data_import_error_type_id;
		spit_data_imports_data_import_error_type_id = spit_data_imports_data_import_error_get_type_once ();
		g_once_init_leave (&spit_data_imports_data_import_error_type_id__once, spit_data_imports_data_import_error_type_id);
	}
	return spit_data_imports_data_import_error_type_id__once;
}

/**
     * Returns a {@link Service} object describing the service to which this connects.
     */
SpitDataImportsService*
spit_data_imports_data_importer_get_service (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->get_service) {
		return _iface_->get_service (self);
	}
	return NULL;
}

/**
     * Makes this data importer enter the running state and endows it with exclusive access
     * to the shared services provided by the {@link PluginHost}. Through the host’s interface,
     * this data importer can install user interface panes and query configuration information.
     */
void
spit_data_imports_data_importer_start (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->start) {
		_iface_->start (self);
	}
}

/**
     * Returns true if this data importer is in the running state; false otherwise.
     */
gboolean
spit_data_imports_data_importer_is_running (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self), FALSE);
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->is_running) {
		return _iface_->is_running (self);
	}
	return FALSE;
}

/**
     * Causes this data importer to enter a non-running state. This data importer should stop all
     * data access operations and cease use of the shared services provided by the {@link PluginHost}.
     */
void
spit_data_imports_data_importer_stop (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->stop) {
		_iface_->stop (self);
	}
}

/**
     * Causes this data importer to enter start the import of a library.
     */
void
spit_data_imports_data_importer_on_library_selected (SpitDataImportsDataImporter* self,
                                                     SpitDataImportsImportableLibrary* library)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->on_library_selected) {
		_iface_->on_library_selected (self, library);
	}
}

/**
     * Causes this data importer to enter start the import of a library file.
     */
void
spit_data_imports_data_importer_on_file_selected (SpitDataImportsDataImporter* self,
                                                  GFile* file)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->on_file_selected) {
		_iface_->on_file_selected (self, file);
	}
}

static void
spit_data_imports_data_importer_real_reserved0 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved0 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_data_imports_data_importer_real_reserved1 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved1 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_data_imports_data_importer_real_reserved2 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved2 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_data_imports_data_importer_real_reserved3 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved3 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_data_imports_data_importer_real_reserved4 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved4 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_data_imports_data_importer_real_reserved5 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved5 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_data_imports_data_importer_real_reserved6 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved6 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_data_imports_data_importer_real_reserved7 (SpitDataImportsDataImporter* self)
{
}

void
spit_data_imports_data_importer_reserved7 (SpitDataImportsDataImporter* self)
{
	SpitDataImportsDataImporterIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
	_iface_ = SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_data_imports_data_importer_default_init (SpitDataImportsDataImporterIface * iface,
                                              gpointer iface_data)
{
	iface->reserved0 = spit_data_imports_data_importer_real_reserved0;
	iface->reserved1 = spit_data_imports_data_importer_real_reserved1;
	iface->reserved2 = spit_data_imports_data_importer_real_reserved2;
	iface->reserved3 = spit_data_imports_data_importer_real_reserved3;
	iface->reserved4 = spit_data_imports_data_importer_real_reserved4;
	iface->reserved5 = spit_data_imports_data_importer_real_reserved5;
	iface->reserved6 = spit_data_imports_data_importer_real_reserved6;
	iface->reserved7 = spit_data_imports_data_importer_real_reserved7;
}

/** 
 * Represents a module that is able to import data from a specific database format.
 *
 * Developers of data import plugins provide a class that implements this interface. At
 * any given time, only one DataImporter can be running. When a data importer is running, it
 * has exclusive use of the shared user-interface and
 * configuration services provided by the {@link PluginHost}. Data importers are created in
 * a non-running state and do not begin running until start( ) is invoked. Data importers
 * run until stop( ) is invoked.
 */
static GType
spit_data_imports_data_importer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsDataImporterIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_data_importer_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_data_importer_type_id;
	spit_data_imports_data_importer_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsDataImporter", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_data_importer_type_id, G_TYPE_OBJECT);
	return spit_data_imports_data_importer_type_id;
}

GType
spit_data_imports_data_importer_get_type (void)
{
	static volatile gsize spit_data_imports_data_importer_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_data_importer_type_id__once)) {
		GType spit_data_imports_data_importer_type_id;
		spit_data_imports_data_importer_type_id = spit_data_imports_data_importer_get_type_once ();
		g_once_init_leave (&spit_data_imports_data_importer_type_id__once, spit_data_imports_data_importer_type_id);
	}
	return spit_data_imports_data_importer_type_id__once;
}

gchar*
spit_data_imports_importable_library_get_display_name (SpitDataImportsImportableLibrary* self)
{
	SpitDataImportsImportableLibraryIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_LIBRARY (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_LIBRARY_GET_INTERFACE (self);
	if (_iface_->get_display_name) {
		return _iface_->get_display_name (self);
	}
	return NULL;
}

static void
spit_data_imports_importable_library_default_init (SpitDataImportsImportableLibraryIface * iface,
                                                   gpointer iface_data)
{
}

/**
 * Represents a library of importable media items.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
static GType
spit_data_imports_importable_library_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableLibraryIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_importable_library_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_importable_library_type_id;
	spit_data_imports_importable_library_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableLibrary", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_importable_library_type_id, G_TYPE_OBJECT);
	return spit_data_imports_importable_library_type_id;
}

GType
spit_data_imports_importable_library_get_type (void)
{
	static volatile gsize spit_data_imports_importable_library_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_importable_library_type_id__once)) {
		GType spit_data_imports_importable_library_type_id;
		spit_data_imports_importable_library_type_id = spit_data_imports_importable_library_get_type_once ();
		g_once_init_leave (&spit_data_imports_importable_library_type_id__once, spit_data_imports_importable_library_type_id);
	}
	return spit_data_imports_importable_library_type_id__once;
}

SpitDataImportsImportableTag**
spit_data_imports_importable_media_item_get_tags (SpitDataImportsImportableMediaItem* self,
                                                  gint* result_length1)
{
	SpitDataImportsImportableMediaItemIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self);
	if (_iface_->get_tags) {
		return _iface_->get_tags (self, result_length1);
	}
	return NULL;
}

SpitDataImportsImportableEvent*
spit_data_imports_importable_media_item_get_event (SpitDataImportsImportableMediaItem* self)
{
	SpitDataImportsImportableMediaItemIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self);
	if (_iface_->get_event) {
		return _iface_->get_event (self);
	}
	return NULL;
}

SpitDataImportsImportableRating*
spit_data_imports_importable_media_item_get_rating (SpitDataImportsImportableMediaItem* self)
{
	SpitDataImportsImportableMediaItemIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self);
	if (_iface_->get_rating) {
		return _iface_->get_rating (self);
	}
	return NULL;
}

gchar*
spit_data_imports_importable_media_item_get_title (SpitDataImportsImportableMediaItem* self)
{
	SpitDataImportsImportableMediaItemIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self);
	if (_iface_->get_title) {
		return _iface_->get_title (self);
	}
	return NULL;
}

gchar*
spit_data_imports_importable_media_item_get_folder_path (SpitDataImportsImportableMediaItem* self)
{
	SpitDataImportsImportableMediaItemIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self);
	if (_iface_->get_folder_path) {
		return _iface_->get_folder_path (self);
	}
	return NULL;
}

gchar*
spit_data_imports_importable_media_item_get_filename (SpitDataImportsImportableMediaItem* self)
{
	SpitDataImportsImportableMediaItemIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self);
	if (_iface_->get_filename) {
		return _iface_->get_filename (self);
	}
	return NULL;
}

GDateTime*
spit_data_imports_importable_media_item_get_exposure_time (SpitDataImportsImportableMediaItem* self)
{
	SpitDataImportsImportableMediaItemIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self);
	if (_iface_->get_exposure_time) {
		return _iface_->get_exposure_time (self);
	}
	return NULL;
}

static void
spit_data_imports_importable_media_item_default_init (SpitDataImportsImportableMediaItemIface * iface,
                                                      gpointer iface_data)
{
}

/**
 * Represents an importable media item such as a photo or a video file.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
static GType
spit_data_imports_importable_media_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableMediaItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_importable_media_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_importable_media_item_type_id;
	spit_data_imports_importable_media_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableMediaItem", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_importable_media_item_type_id, G_TYPE_OBJECT);
	return spit_data_imports_importable_media_item_type_id;
}

GType
spit_data_imports_importable_media_item_get_type (void)
{
	static volatile gsize spit_data_imports_importable_media_item_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_importable_media_item_type_id__once)) {
		GType spit_data_imports_importable_media_item_type_id;
		spit_data_imports_importable_media_item_type_id = spit_data_imports_importable_media_item_get_type_once ();
		g_once_init_leave (&spit_data_imports_importable_media_item_type_id__once, spit_data_imports_importable_media_item_type_id);
	}
	return spit_data_imports_importable_media_item_type_id__once;
}

gchar*
spit_data_imports_importable_tag_get_name (SpitDataImportsImportableTag* self)
{
	SpitDataImportsImportableTagIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_TAG (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_TAG_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

SpitDataImportsImportableTag*
spit_data_imports_importable_tag_get_parent (SpitDataImportsImportableTag* self)
{
	SpitDataImportsImportableTagIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_TAG (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_TAG_GET_INTERFACE (self);
	if (_iface_->get_parent) {
		return _iface_->get_parent (self);
	}
	return NULL;
}

static void
spit_data_imports_importable_tag_default_init (SpitDataImportsImportableTagIface * iface,
                                               gpointer iface_data)
{
}

/**
 * Represents an importable tag.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
static GType
spit_data_imports_importable_tag_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableTagIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_importable_tag_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_importable_tag_type_id;
	spit_data_imports_importable_tag_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableTag", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_importable_tag_type_id, G_TYPE_OBJECT);
	return spit_data_imports_importable_tag_type_id;
}

GType
spit_data_imports_importable_tag_get_type (void)
{
	static volatile gsize spit_data_imports_importable_tag_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_importable_tag_type_id__once)) {
		GType spit_data_imports_importable_tag_type_id;
		spit_data_imports_importable_tag_type_id = spit_data_imports_importable_tag_get_type_once ();
		g_once_init_leave (&spit_data_imports_importable_tag_type_id__once, spit_data_imports_importable_tag_type_id);
	}
	return spit_data_imports_importable_tag_type_id__once;
}

gchar*
spit_data_imports_importable_event_get_name (SpitDataImportsImportableEvent* self)
{
	SpitDataImportsImportableEventIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_EVENT (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_EVENT_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

static void
spit_data_imports_importable_event_default_init (SpitDataImportsImportableEventIface * iface,
                                                 gpointer iface_data)
{
}

/**
 * Represents an importable event.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
static GType
spit_data_imports_importable_event_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableEventIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_importable_event_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_importable_event_type_id;
	spit_data_imports_importable_event_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableEvent", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_importable_event_type_id, G_TYPE_OBJECT);
	return spit_data_imports_importable_event_type_id;
}

GType
spit_data_imports_importable_event_get_type (void)
{
	static volatile gsize spit_data_imports_importable_event_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_importable_event_type_id__once)) {
		GType spit_data_imports_importable_event_type_id;
		spit_data_imports_importable_event_type_id = spit_data_imports_importable_event_get_type_once ();
		g_once_init_leave (&spit_data_imports_importable_event_type_id__once, spit_data_imports_importable_event_type_id);
	}
	return spit_data_imports_importable_event_type_id__once;
}

gboolean
spit_data_imports_importable_rating_is_unrated (SpitDataImportsImportableRating* self)
{
	SpitDataImportsImportableRatingIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_RATING (self), FALSE);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_RATING_GET_INTERFACE (self);
	if (_iface_->is_unrated) {
		return _iface_->is_unrated (self);
	}
	return FALSE;
}

gboolean
spit_data_imports_importable_rating_is_rejected (SpitDataImportsImportableRating* self)
{
	SpitDataImportsImportableRatingIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_RATING (self), FALSE);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_RATING_GET_INTERFACE (self);
	if (_iface_->is_rejected) {
		return _iface_->is_rejected (self);
	}
	return FALSE;
}

gint
spit_data_imports_importable_rating_get_value (SpitDataImportsImportableRating* self)
{
	SpitDataImportsImportableRatingIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_RATING (self), 0);
	_iface_ = SPIT_DATA_IMPORTS_IMPORTABLE_RATING_GET_INTERFACE (self);
	if (_iface_->get_value) {
		return _iface_->get_value (self);
	}
	return -1;
}

static void
spit_data_imports_importable_rating_default_init (SpitDataImportsImportableRatingIface * iface,
                                                  gpointer iface_data)
{
}

/**
 * Represents an importable rating value.
 *
 * Developers of data import plugins provide a class that implements this interface.
 * Note that the value returned by the get_value method should be a value between
 * 1 and 5, unless the rating object is unrated or rejected, in which case the
 * value is unspecified.
 */
static GType
spit_data_imports_importable_rating_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableRatingIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_importable_rating_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_importable_rating_type_id;
	spit_data_imports_importable_rating_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableRating", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_importable_rating_type_id, G_TYPE_OBJECT);
	return spit_data_imports_importable_rating_type_id;
}

GType
spit_data_imports_importable_rating_get_type (void)
{
	static volatile gsize spit_data_imports_importable_rating_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_importable_rating_type_id__once)) {
		GType spit_data_imports_importable_rating_type_id;
		spit_data_imports_importable_rating_type_id = spit_data_imports_importable_rating_get_type_once ();
		g_once_init_leave (&spit_data_imports_importable_rating_type_id__once, spit_data_imports_importable_rating_type_id);
	}
	return spit_data_imports_importable_rating_type_id__once;
}

/**
     * Describes how the on-screen publishing dialog box should look and behave when an associated
     * pane is installed in the on-screen publishing dialog box.
     */
static GType
spit_data_imports_dialog_pane_geometry_options_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_NONE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_NONE", "none"}, {SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE", "extended-size"}, {SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE", "resizable"}, {SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE", "colossal-size"}, {0, NULL, NULL}};
	GType spit_data_imports_dialog_pane_geometry_options_type_id;
	spit_data_imports_dialog_pane_geometry_options_type_id = g_enum_register_static ("SpitDataImportsDialogPaneGeometryOptions", values);
	return spit_data_imports_dialog_pane_geometry_options_type_id;
}

GType
spit_data_imports_dialog_pane_geometry_options_get_type (void)
{
	static volatile gsize spit_data_imports_dialog_pane_geometry_options_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_dialog_pane_geometry_options_type_id__once)) {
		GType spit_data_imports_dialog_pane_geometry_options_type_id;
		spit_data_imports_dialog_pane_geometry_options_type_id = spit_data_imports_dialog_pane_geometry_options_get_type_once ();
		g_once_init_leave (&spit_data_imports_dialog_pane_geometry_options_type_id__once, spit_data_imports_dialog_pane_geometry_options_type_id);
	}
	return spit_data_imports_dialog_pane_geometry_options_type_id__once;
}

/**
     * Returns the Gtk.Widget that is this pane's on-screen representation.
     */
GtkWidget*
spit_data_imports_dialog_pane_get_widget (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->get_widget) {
		return _iface_->get_widget (self);
	}
	return NULL;
}

/**
     * Returns a {@link GeometryOptions} bitfield describing how the on-screen publishing dialog
     * box should look and behave when this pane is installed.
     */
SpitDataImportsDialogPaneGeometryOptions
spit_data_imports_dialog_pane_get_preferred_geometry (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self), 0);
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->get_preferred_geometry) {
		return _iface_->get_preferred_geometry (self);
	}
	return 0;
}

/**
     * Invoked automatically by Shotwell when this pane has been installed into the on-screen
     * publishing dialog box and become visible to the user.
     */
void
spit_data_imports_dialog_pane_on_pane_installed (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->on_pane_installed) {
		_iface_->on_pane_installed (self);
	}
}

/**
     * Invoked automatically by Shotwell when this pane has been removed from the on-screen
     * publishing dialog box and is no longer visible to the user.
     */
void
spit_data_imports_dialog_pane_on_pane_uninstalled (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->on_pane_uninstalled) {
		_iface_->on_pane_uninstalled (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved0 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved0 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved1 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved1 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved2 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved2 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved3 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved3 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved4 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved4 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved5 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved5 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved6 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved6 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_data_imports_dialog_pane_real_reserved7 (SpitDataImportsDialogPane* self)
{
}

void
spit_data_imports_dialog_pane_reserved7 (SpitDataImportsDialogPane* self)
{
	SpitDataImportsDialogPaneIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
	_iface_ = SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_data_imports_dialog_pane_default_init (SpitDataImportsDialogPaneIface * iface,
                                            gpointer iface_data)
{
	iface->reserved0 = spit_data_imports_dialog_pane_real_reserved0;
	iface->reserved1 = spit_data_imports_dialog_pane_real_reserved1;
	iface->reserved2 = spit_data_imports_dialog_pane_real_reserved2;
	iface->reserved3 = spit_data_imports_dialog_pane_real_reserved3;
	iface->reserved4 = spit_data_imports_dialog_pane_real_reserved4;
	iface->reserved5 = spit_data_imports_dialog_pane_real_reserved5;
	iface->reserved6 = spit_data_imports_dialog_pane_real_reserved6;
	iface->reserved7 = spit_data_imports_dialog_pane_real_reserved7;
}

/**
 * Encapsulates a pane that can be installed in the on-screen import dialog box to
 * communicate status to and to get information from the user.
 *
 */
static GType
spit_data_imports_dialog_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsDialogPaneIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_dialog_pane_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_dialog_pane_type_id;
	spit_data_imports_dialog_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsDialogPane", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_dialog_pane_type_id, G_TYPE_OBJECT);
	return spit_data_imports_dialog_pane_type_id;
}

GType
spit_data_imports_dialog_pane_get_type (void)
{
	static volatile gsize spit_data_imports_dialog_pane_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_dialog_pane_type_id__once)) {
		GType spit_data_imports_dialog_pane_type_id;
		spit_data_imports_dialog_pane_type_id = spit_data_imports_dialog_pane_get_type_once ();
		g_once_init_leave (&spit_data_imports_dialog_pane_type_id__once, spit_data_imports_dialog_pane_type_id);
	}
	return spit_data_imports_dialog_pane_type_id__once;
}

/**
     * Specifies the label text on the push button control that appears in the
     * lower-right-hand corner of the on-screen publishing dialog box.
     */
static GType
spit_data_imports_plugin_host_button_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CLOSE, "SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CLOSE", "close"}, {SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CANCEL, "SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CANCEL", "cancel"}, {0, NULL, NULL}};
	GType spit_data_imports_plugin_host_button_mode_type_id;
	spit_data_imports_plugin_host_button_mode_type_id = g_enum_register_static ("SpitDataImportsPluginHostButtonMode", values);
	return spit_data_imports_plugin_host_button_mode_type_id;
}

GType
spit_data_imports_plugin_host_button_mode_get_type (void)
{
	static volatile gsize spit_data_imports_plugin_host_button_mode_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_plugin_host_button_mode_type_id__once)) {
		GType spit_data_imports_plugin_host_button_mode_type_id;
		spit_data_imports_plugin_host_button_mode_type_id = spit_data_imports_plugin_host_button_mode_get_type_once ();
		g_once_init_leave (&spit_data_imports_plugin_host_button_mode_type_id__once, spit_data_imports_plugin_host_button_mode_type_id);
	}
	return spit_data_imports_plugin_host_button_mode_type_id__once;
}

/**
     * Notifies the user that an unrecoverable import error has occurred and halts
     * the import process.
     *
     * @param err An error object that describes the kind of error that occurred.
     */
void
spit_data_imports_plugin_host_post_error (SpitDataImportsPluginHost* self,
                                          GError* err)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->post_error) {
		_iface_->post_error (self, err);
	}
}

/**
     * Notifies the user that an unrecoverable import error has occurred and halts
     * the import process.
     *
     * @param msg A message that describes the kind of error that occurred.
     */
void
spit_data_imports_plugin_host_post_error_message (SpitDataImportsPluginHost* self,
                                                  const gchar* msg)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->post_error_message) {
		_iface_->post_error_message (self, msg);
	}
}

/**
     * Starts the import process.
     *
     * Calling this method starts the import activity for this host.
     */
void
spit_data_imports_plugin_host_start_importing (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->start_importing) {
		_iface_->start_importing (self);
	}
}

/**
     * Halts the import process.
     *
     * Calling this method stops all import activity and hides the on-screen import
     * dialog box.
     */
void
spit_data_imports_plugin_host_stop_importing (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->stop_importing) {
		_iface_->stop_importing (self);
	}
}

/**
     * Returns a reference to the {@link DataImporter} object that this is currently hosting.
     */
SpitDataImportsDataImporter*
spit_data_imports_plugin_host_get_data_importer (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->get_data_importer) {
		return _iface_->get_data_importer (self);
	}
	return NULL;
}

/**
     * Attempts to install a pane in the on-screen data import dialog box, making the pane visible
     * and allowing it to interact with the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param pane the pane to install
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen data import dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your importer is in the
     * middle of processing 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the processing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable actions have already
     * occurred.
     */
void
spit_data_imports_plugin_host_install_dialog_pane (SpitDataImportsPluginHost* self,
                                                   SpitDataImportsDialogPane* pane,
                                                   SpitDataImportsPluginHostButtonMode mode)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_dialog_pane) {
		_iface_->install_dialog_pane (self, pane, mode);
	}
}

/**
     * Attempts to install a pane in the on-screen data import dialog box that contains
     * static text.
     *
     * The text appears centered in the data import dialog box and is drawn in
     * the system font. This is a convenience method only; similar results could be
     * achieved by manually constructing a Gtk.Label widget, wrapping it inside a
     * {@link DialogPane}, and installing it manually with a call to
     * install_dialog_pane( ). To provide visual consistency across data import services,
     * however, always use this convenience method instead of constructing label panes when
     * you need to display static text to the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param message the text to show in the pane
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen data import dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your importer is in the
     * middle of processing 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the processing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable actions have already
     * occurred.
     */
void
spit_data_imports_plugin_host_install_static_message_pane (SpitDataImportsPluginHost* self,
                                                           const gchar* message,
                                                           SpitDataImportsPluginHostButtonMode mode)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_static_message_pane) {
		_iface_->install_static_message_pane (self, message, mode);
	}
}

/**
     * Attempts to install a library selection pane that presents a list of
     * discovered libraries to the user.
     *
     * When the user clicks the “OK” button, you’ll be notified of the user’s action through
     * the 'on_library_selected' callback if a discovered library was selected or through
     * the 'on_file_selected' callback if a file was selected.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param welcome_message the text to be displayed above the list of discovered
     * libraries.
     *
     * @param discovered_libraries the list of importable libraries that the plugin
     * has discovered in well known locations.
     *
     * @param file_select_label the label to display for the file selection
     * option. If this label is null, the
     * user will not be presented with a file selection option.
     */
void
spit_data_imports_plugin_host_install_library_selection_pane (SpitDataImportsPluginHost* self,
                                                              const gchar* welcome_message,
                                                              SpitDataImportsImportableLibrary** discovered_libraries,
                                                              gint discovered_libraries_length1,
                                                              const gchar* file_select_label)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_library_selection_pane) {
		_iface_->install_library_selection_pane (self, welcome_message, discovered_libraries, discovered_libraries_length1, file_select_label);
	}
}

/**
     * Attempts to install a progress pane that provides the user with feedback
     * on import preparation.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param message the text to be displayed above the progress bar.
     */
void
spit_data_imports_plugin_host_install_import_progress_pane (SpitDataImportsPluginHost* self,
                                                            const gchar* message)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->install_import_progress_pane) {
		_iface_->install_import_progress_pane (self, message);
	}
}

/**
     * Update the progress bar installed by install_import_progress_pane.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param progress a value between 0.0 and 1.0 identifying progress for the
     * plugin.
     *
     * @param progress_label the text to be displayed below the progress bar. If that
     * parameter is null, the message will be left unchanged.
     */
void
spit_data_imports_plugin_host_update_import_progress_pane (SpitDataImportsPluginHost* self,
                                                           gdouble progress,
                                                           const gchar* progress_message)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->update_import_progress_pane) {
		_iface_->update_import_progress_pane (self, progress, progress_message);
	}
}

/**
     * Sends an importable media item to the host in order to prepare it for import
     * and update the progress bar installed by install_import_progress_pane.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param item the importable media item to prepare for import.
     *
     * @param progress a value between 0.0 and 1.0 identifying progress for the
     * plugin.
     *
     * @param host_progress_delta the amount of progress the host should update
     * the progress bar during import preparation. Plugins should ensure that
     * a proportion of progress for each media item is set aside for the host
     * in order to ensure a smoother update to the progress bar.
     *
     * @param progress_message the text to be displayed below the progress bar. If that
     * parameter is null, the message will be left unchanged.
     */
void
spit_data_imports_plugin_host_prepare_media_items_for_import (SpitDataImportsPluginHost* self,
                                                              SpitDataImportsImportableMediaItem** items,
                                                              gint items_length1,
                                                              gdouble progress,
                                                              gdouble host_progress_delta,
                                                              const gchar* progress_message)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->prepare_media_items_for_import) {
		_iface_->prepare_media_items_for_import (self, items, items_length1, progress, host_progress_delta, progress_message);
	}
}

/**
     * Finalize the import sequence for the plugin. This tells the host that
     * all media items have been processed and that the plugin has finished all
     * import work. Once this method has been called, all resources used by the
     * plugin for import should be released and the plugin should be back to the
     * state it had just after running the start method. The host will then display
     * the final message and show progress as fully complete. In a standard import
     * scenario, the user is expected to click the Close button to dismiss the
     * dialog. On first run, the host may call the LibrarySelectedCallback again
     * to import another library handled by the same plugin.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param finalize_message the text to be displayed below the progress bar. If that
     * parameter is null, the message will be left unchanged.
     */
void
spit_data_imports_plugin_host_finalize_import (SpitDataImportsPluginHost* self,
                                               SpitDataImportsImportedItemsCountCallback report_imported_items_count,
                                               gpointer report_imported_items_count_target,
                                               const gchar* finalize_message)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->finalize_import) {
		_iface_->finalize_import (self, report_imported_items_count, report_imported_items_count_target, finalize_message);
	}
}

static void
spit_data_imports_plugin_host_real_reserved0 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved0 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_data_imports_plugin_host_real_reserved1 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved1 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_data_imports_plugin_host_real_reserved2 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved2 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_data_imports_plugin_host_real_reserved3 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved3 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_data_imports_plugin_host_real_reserved4 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved4 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_data_imports_plugin_host_real_reserved5 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved5 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_data_imports_plugin_host_real_reserved6 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved6 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_data_imports_plugin_host_real_reserved7 (SpitDataImportsPluginHost* self)
{
}

void
spit_data_imports_plugin_host_reserved7 (SpitDataImportsPluginHost* self)
{
	SpitDataImportsPluginHostIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
	_iface_ = SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_data_imports_plugin_host_default_init (SpitDataImportsPluginHostIface * iface,
                                            gpointer iface_data)
{
	iface->reserved0 = spit_data_imports_plugin_host_real_reserved0;
	iface->reserved1 = spit_data_imports_plugin_host_real_reserved1;
	iface->reserved2 = spit_data_imports_plugin_host_real_reserved2;
	iface->reserved3 = spit_data_imports_plugin_host_real_reserved3;
	iface->reserved4 = spit_data_imports_plugin_host_real_reserved4;
	iface->reserved5 = spit_data_imports_plugin_host_real_reserved5;
	iface->reserved6 = spit_data_imports_plugin_host_real_reserved6;
	iface->reserved7 = spit_data_imports_plugin_host_real_reserved7;
}

/**
 * Manages and provides services for data import plugins.
 *
 * Implemented inside Shotwell, the PluginHost provides an interface through which the
 * developers of data import plugins can query and make changes to the import
 * environment. Plugins can use the services of the PluginHost only when their
 * {@link DataImporter} is in the running state. This ensures that non-running data importers
 * don’t destructively interfere with the actively running importer.
 */
static GType
spit_data_imports_plugin_host_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsPluginHostIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_plugin_host_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_plugin_host_type_id;
	spit_data_imports_plugin_host_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsPluginHost", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_plugin_host_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (spit_data_imports_plugin_host_type_id, SPIT_TYPE_HOST_INTERFACE);
	return spit_data_imports_plugin_host_type_id;
}

GType
spit_data_imports_plugin_host_get_type (void)
{
	static volatile gsize spit_data_imports_plugin_host_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_plugin_host_type_id__once)) {
		GType spit_data_imports_plugin_host_type_id;
		spit_data_imports_plugin_host_type_id = spit_data_imports_plugin_host_get_type_once ();
		g_once_init_leave (&spit_data_imports_plugin_host_type_id__once, spit_data_imports_plugin_host_type_id);
	}
	return spit_data_imports_plugin_host_type_id__once;
}

/**
     * A factory method that instantiates and returns a new {@link DataImporter} object
     * that this Service describes.
     */
SpitDataImportsDataImporter*
spit_data_imports_service_create_data_importer (SpitDataImportsService* self,
                                                SpitDataImportsPluginHost* host)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self), NULL);
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->create_data_importer) {
		return _iface_->create_data_importer (self, host);
	}
	return NULL;
}

static void
spit_data_imports_service_real_reserved0 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved0 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved0) {
		_iface_->reserved0 (self);
	}
}

static void
spit_data_imports_service_real_reserved1 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved1 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved1) {
		_iface_->reserved1 (self);
	}
}

static void
spit_data_imports_service_real_reserved2 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved2 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved2) {
		_iface_->reserved2 (self);
	}
}

static void
spit_data_imports_service_real_reserved3 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved3 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved3) {
		_iface_->reserved3 (self);
	}
}

static void
spit_data_imports_service_real_reserved4 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved4 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved4) {
		_iface_->reserved4 (self);
	}
}

static void
spit_data_imports_service_real_reserved5 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved5 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved5) {
		_iface_->reserved5 (self);
	}
}

static void
spit_data_imports_service_real_reserved6 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved6 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved6) {
		_iface_->reserved6 (self);
	}
}

static void
spit_data_imports_service_real_reserved7 (SpitDataImportsService* self)
{
}

void
spit_data_imports_service_reserved7 (SpitDataImportsService* self)
{
	SpitDataImportsServiceIface* _iface_;
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
	_iface_ = SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->reserved7) {
		_iface_->reserved7 (self);
	}
}

static void
spit_data_imports_service_default_init (SpitDataImportsServiceIface * iface,
                                        gpointer iface_data)
{
	iface->reserved0 = spit_data_imports_service_real_reserved0;
	iface->reserved1 = spit_data_imports_service_real_reserved1;
	iface->reserved2 = spit_data_imports_service_real_reserved2;
	iface->reserved3 = spit_data_imports_service_real_reserved3;
	iface->reserved4 = spit_data_imports_service_real_reserved4;
	iface->reserved5 = spit_data_imports_service_real_reserved5;
	iface->reserved6 = spit_data_imports_service_real_reserved6;
	iface->reserved7 = spit_data_imports_service_real_reserved7;
}

/**
 * Describes the features and capabilities of a data import service.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
static GType
spit_data_imports_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType spit_data_imports_service_type_id;
	spit_data_imports_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (spit_data_imports_service_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (spit_data_imports_service_type_id, SPIT_TYPE_PLUGGABLE);
	return spit_data_imports_service_type_id;
}

GType
spit_data_imports_service_get_type (void)
{
	static volatile gsize spit_data_imports_service_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_service_type_id__once)) {
		GType spit_data_imports_service_type_id;
		spit_data_imports_service_type_id = spit_data_imports_service_get_type_once ();
		g_once_init_leave (&spit_data_imports_service_type_id__once, spit_data_imports_service_type_id);
	}
	return spit_data_imports_service_type_id__once;
}

