/*
** Copyright (C) University of Virginia, Massachusetts Institue of Technology 1994-2003.
** Copyright (C) Mihail Groza 2016-2017.
**
** See ../LICENSE for license information.
**
*/

# include "splintMacros.nf"
# include "basic.h"
# include "reservedNames.h"

/* TODO: should add missing names introduced by C99 */

/*@constant int NRESERVEDNAMES; @*/
# define NRESERVEDNAMES 200

bool
isStdReservedName (cstring name)
{
  /* 
  ** reservedStdNames
  **   taken from Linden, "Expert C Programming", p. 126-8. 
  **   invariant:  must be sorted (case-insensitive, lexicographically)
  */

  static /*@observer@*/ const char* reservedStdNames[NRESERVEDNAMES] = {
    "BUFSIZ",
    "CHAR_BIT",
    "CHAR_MAX",
    "CHAR_MIN",
    "CLOCKS_PER_SEC",
    "DBL_DIG",
    "DBL_EPSILON",
    "DBL_MANT_DIG",
    "DBL_MAX",
    "DBL_MAX_10_EXP",
    "DBL_MAX_EXP",
    "DBL_MIN",
    "DBL_MIN_10_EXP",
    "DBL_MIN_EXP",
    "EXIT_FAILURE",
    "EXIT_SUCCESS",
    "FILE",
    "FILENAME_MAX",
    "FLT_DIG",
    "FLT_EPSILON",
    "FLT_MANT_DIG",
    "FLT_MAX",
    "FLT_MAX_10_EXP",
    "FLT_MAX_EXP",
    "FLT_MIN",
    "FLT_MIN_10_EXP",
    "FLT_MIN_EXP",
    "FLT_RADIX",
    "FLT_ROUNDS",
    "FOPEN_MAX",
    "HUGE_VAL",
    "INT_MAX",
    "INT_MIN",
    "LDBL_DIG",
    "LDBL_EPSILON",
    "LDBL_MANT_DIG",
    "LDBL_MAX",
    "LDBL_MAX_10_EXP",
    "LDBL_MAX_EXP",
    "LDBL_MIN",
    "LDBL_MIN_10_EXP",
    "LDBL_MIN_EXP",
    "LONG_MAX",
    "LONG_MIN",
    "L_tmpnam",
    "MB_CUR_MAX",
    "MB_LEN_MAX",
    "NDEBUG",
    "NULL",
    "RAND_MAX",
    "SCHAR_MAX",
    "SCHAR_MIN",
    "SEEK_CUR",
    "SEEK_END",
    "SEEK_SET",
    "SHRT_MAX",
    "SHRT_MIN",
    "SIGABRT",
    "SIGFPE",
    "SIGILL",
    "SIGINT",
    "SIGSEGV",
    "SIGTERM",
    "SIG_DFL",
    "SIG_ERR",
    "SIG_IGN",
    "TMP_MAX",
    "UCHAR_MAX",
    "UINT_MAX",
    "ULONG_MAX",
    "USHRT_MAX",
    "abort",
    "abs",
    "asctime",
    "assert",
    "atexit",
    "atof",
    "atoi",
    "atol",
    "bsearch",
    "calloc",
    "clearerr",
    "clock",
    "clock_t",
    "ctime",
    "currency_symbol",
    "decimal_point",
    /* "defined", */
    "difftime",
    "div",
    "div_t",
    "errno",
    "exit",
    "fclose",
    "feof",
    "ferror",
    "fflush",
    "fgetc",
    "fgetpos",
    "fgets",
    "fopen",
    "fpos_t",
    "fprintf",
    "fputc",
    "fputs",
    "frac_digits",
    "fread",
    "free",
    "freopen",
    "fscanf",
    "fseek",
    "fsetpos",
    "ftell",
    "fwrite",
    "getc",
    "getchar",
    "getenv",
    "gets",
    "gmtime",
    "grouping",
    "int_curr_symbol",
    "int_frac_digits",
    "jmp_buf",
    "labs",
    "lconv",
    "ldiv",
    "ldiv_t",
    "localeconv",
    "localtime",
    "longjmp",
    "malloc",
    "mblen",
    "mbstowcs",
    "mbtowc",
    "mktime",
    "mon_decimal_point",
    "mon_grouping",
    "mon_thousands_sep",
    "n_cs_precedes",
    "n_sep_by_space",
    "n_sign_posn",
    "negative_sign",
    "offsetof",
    "p_cs_precedes",
    "p_sep_by_space",
    "p_sign_posn",
    "perror",
    "positive_sign",
    "printf",
    "ptrdiff_t",
    "putc",
    "putchar",
    "puts",
    "qsort",
    "raise",
    "rand",
    "realloc",
    "remove",
    "rename",
    "rewind",
    "scanf",
    "setbuf",
    "setjmp",
    "setlocale",
    "setvbuf",
    "sig_atomic_t",
    "signal",
    "size_t",
    "sprintf",
    "srand",
    "sscanf",
    "stderr",
    "stdin",
    "stdout",
    "system",
    "thousands_sep",
    "time",
    "time_t",
    "tm",
    "tm_hour",
    "tm_isdst",
    "tm_mday",
    "tm_min",
    "tm_mon",
    "tm_sec",
    "tm_wday",
    "tm_yday",
    "tm_year",
    "tmpfile",
    "tmpnam",
    "ungetc",
    "va_arg",
    "va_end",
    "va_list",
    "va_start",
    "vfprintf",
    "vprintf",
    "vsprintf",
    "wchar_t",
    "wcstombs",
    "wctomb"
  };

  return cstring_bsearch (name, reservedStdNames, NRESERVEDNAMES+1);
}

/*@constant int NCPPNAMES@*/
# define NCPPNAMES 39

bool
isCPlusPlusReservedName (cstring name)
{
  static /*@observer@*/ const char* reservedCPlusPlusNames[NCPPNAMES] = {
    "and",
    "and_eq",
    "asm", 
    "bitand",
    "bitor",
    "bool", /* gasp: "bool", is special for splint */
    "catch",
    "class",
    "compl",
    "const_class",
    "delete",
    "dynamic_cast",
    "false",
    "friend",
    "inline",
    "mutable",
    "namespace",
    "new",
    "not",
    "not_eq",
    "operator",
    "or",
    "or_eq",
    "overload",
    "private",
    "protected",
    "public",
    "reinterpret_cast",
    "static_cast",
    "template",
    "this",
    "throw",
    "true",
    "try",
    "typeid",
    "using",
    "virtual",
    "xor",
    "xor_eq"
  };

  return cstring_bsearch (name, reservedCPlusPlusNames, NCPPNAMES);
}
