/* Job.c generated by valac 0.56.17, the Vala compiler
 * generated from Job.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright 2015 - 2022 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <glib.h>
#include "cups/ipp.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "cups/cups.h"
#include <time.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_JOB_0_PROPERTY,
	PRINTERS_JOB_PRINTER_PROPERTY,
	PRINTERS_JOB_UID_PROPERTY,
	PRINTERS_JOB_STATE_PROPERTY,
	PRINTERS_JOB_TITLE_PROPERTY,
	PRINTERS_JOB_FORMAT_PROPERTY,
	PRINTERS_JOB_REASONS_PROPERTY,
	PRINTERS_JOB_CREATION_TIME_PROPERTY,
	PRINTERS_JOB_COMPLETED_TIME_PROPERTY,
	PRINTERS_JOB_IS_ONGOING_PROPERTY,
	PRINTERS_JOB_NUM_PROPERTIES
};
static GParamSpec* printers_job_properties[PRINTERS_JOB_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	PRINTERS_JOB_STATE_CHANGED_SIGNAL,
	PRINTERS_JOB_NUM_SIGNALS
};
static guint printers_job_signals[PRINTERS_JOB_NUM_SIGNALS] = {0};

struct _PrintersJobPrivate {
	PrintersPrinter* _printer;
	gint _uid;
	ipp_jstate_t _state;
	gchar* _title;
	gchar* _format;
	gchar* _reasons;
	GDateTime* _creation_time;
	GDateTime* _completed_time;
};

static gint PrintersJob_private_offset;
static gpointer printers_job_parent_class = NULL;

static void printers_job_on_job_state_changed (PrintersJob* self,
                                        const gchar* text,
                                        const gchar* printer_uri,
                                        const gchar* name,
                                        guint32 printer_state,
                                        const gchar* state_reasons,
                                        gboolean is_accepting_jobs,
                                        guint32 job_id,
                                        guint32 job_state,
                                        const gchar* job_state_reason,
                                        const gchar* job_name,
                                        guint32 job_impressions_completed);
static void _printers_job_on_job_state_changed_cups_notifier_job_progress (CupsNotifier* _sender,
                                                                    const gchar* text,
                                                                    const gchar* printer_uri,
                                                                    const gchar* name,
                                                                    guint32 state,
                                                                    const gchar* state_reasons,
                                                                    gboolean is_accepting_jobs,
                                                                    guint32 job_id,
                                                                    guint32 job_state,
                                                                    const gchar* job_state_reason,
                                                                    const gchar* job_name,
                                                                    guint32 job_impressions_completed,
                                                                    gpointer self);
static void _printers_job_on_job_state_changed_cups_notifier_job_completed (CupsNotifier* _sender,
                                                                     const gchar* text,
                                                                     const gchar* printer_uri,
                                                                     const gchar* name,
                                                                     guint32 state,
                                                                     const gchar* state_reasons,
                                                                     gboolean is_accepting_jobs,
                                                                     guint32 job_id,
                                                                     guint32 job_state,
                                                                     const gchar* job_state_reason,
                                                                     const gchar* job_name,
                                                                     guint32 job_impressions_completed,
                                                                     gpointer self);
static void _printers_job_on_job_state_changed_cups_notifier_job_state_changed (CupsNotifier* _sender,
                                                                         const gchar* text,
                                                                         const gchar* printer_uri,
                                                                         const gchar* name,
                                                                         guint32 state,
                                                                         const gchar* state_reasons,
                                                                         gboolean is_accepting_jobs,
                                                                         guint32 job_id,
                                                                         guint32 job_state,
                                                                         const gchar* job_state_reason,
                                                                         const gchar* job_name,
                                                                         guint32 job_impressions_completed,
                                                                         gpointer self);
static void printers_job_finalize (GObject * obj);
static GType printers_job_get_type_once (void);
static void _vala_printers_job_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_printers_job_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
printers_job_get_instance_private (PrintersJob* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersJob_private_offset);
}

static void
_printers_job_on_job_state_changed_cups_notifier_job_progress (CupsNotifier* _sender,
                                                               const gchar* text,
                                                               const gchar* printer_uri,
                                                               const gchar* name,
                                                               guint32 state,
                                                               const gchar* state_reasons,
                                                               gboolean is_accepting_jobs,
                                                               guint32 job_id,
                                                               guint32 job_state,
                                                               const gchar* job_state_reason,
                                                               const gchar* job_name,
                                                               guint32 job_impressions_completed,
                                                               gpointer self)
{
	printers_job_on_job_state_changed ((PrintersJob*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs, job_id, job_state, job_state_reason, job_name, job_impressions_completed);
}

static void
_printers_job_on_job_state_changed_cups_notifier_job_completed (CupsNotifier* _sender,
                                                                const gchar* text,
                                                                const gchar* printer_uri,
                                                                const gchar* name,
                                                                guint32 state,
                                                                const gchar* state_reasons,
                                                                gboolean is_accepting_jobs,
                                                                guint32 job_id,
                                                                guint32 job_state,
                                                                const gchar* job_state_reason,
                                                                const gchar* job_name,
                                                                guint32 job_impressions_completed,
                                                                gpointer self)
{
	printers_job_on_job_state_changed ((PrintersJob*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs, job_id, job_state, job_state_reason, job_name, job_impressions_completed);
}

static void
_printers_job_on_job_state_changed_cups_notifier_job_state_changed (CupsNotifier* _sender,
                                                                    const gchar* text,
                                                                    const gchar* printer_uri,
                                                                    const gchar* name,
                                                                    guint32 state,
                                                                    const gchar* state_reasons,
                                                                    gboolean is_accepting_jobs,
                                                                    guint32 job_id,
                                                                    guint32 job_state,
                                                                    const gchar* job_state_reason,
                                                                    const gchar* job_name,
                                                                    guint32 job_impressions_completed,
                                                                    gpointer self)
{
	printers_job_on_job_state_changed ((PrintersJob*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs, job_id, job_state, job_state_reason, job_name, job_impressions_completed);
}

PrintersJob*
printers_job_construct (GType object_type,
                        cups_job_t* cjob,
                        PrintersPrinter* printer)
{
	PrintersJob * self = NULL;
	GDateTime* _tmp0_ = NULL;
	cups_job_t _tmp1_;
	GDateTime* _tmp7_ = NULL;
	cups_job_t _tmp8_;
	cups_job_t _tmp11_;
	cups_job_t _tmp12_;
	const gchar* _tmp13_;
	cups_job_t _tmp14_;
	const gchar* _tmp15_;
	cups_job_t _tmp16_;
	CupsNotifier* notifier = NULL;
	CupsNotifier* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	ipp_jstate_t _tmp20_;
	g_return_val_if_fail (cjob != NULL, NULL);
	g_return_val_if_fail (printer != NULL, NULL);
	_tmp1_ = *cjob;
	if (_tmp1_.creation_time > ((time_t) 0)) {
		cups_job_t _tmp2_;
		GDateTime* _tmp3_;
		_tmp2_ = *cjob;
		_tmp3_ = g_date_time_new_from_unix_local ((gint64) _tmp2_.creation_time);
		_g_date_time_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		GTimeZone* _tmp4_;
		GTimeZone* _tmp5_;
		GDateTime* _tmp6_;
		_tmp4_ = g_time_zone_new_local ();
		_tmp5_ = _tmp4_;
		_tmp6_ = g_date_time_new_now (_tmp5_);
		_g_date_time_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_time_zone_unref0 (_tmp5_);
	}
	_tmp8_ = *cjob;
	if (_tmp8_.completed_time > ((time_t) 0)) {
		cups_job_t _tmp9_;
		GDateTime* _tmp10_;
		_tmp9_ = *cjob;
		_tmp10_ = g_date_time_new_from_unix_local ((gint64) _tmp9_.completed_time);
		_g_date_time_unref0 (_tmp7_);
		_tmp7_ = _tmp10_;
	} else {
		_g_date_time_unref0 (_tmp7_);
		_tmp7_ = NULL;
	}
	_tmp11_ = *cjob;
	_tmp12_ = *cjob;
	_tmp13_ = _tmp12_.title;
	_tmp14_ = *cjob;
	_tmp15_ = _tmp14_.format;
	_tmp16_ = *cjob;
	self = (PrintersJob*) g_object_new (object_type, "creation-time", _tmp0_, "completed-time", _tmp7_, "state", _tmp11_.state, "title", _tmp13_, "printer", printer, "format", _tmp15_, "uid", _tmp16_.id, NULL);
	_tmp17_ = cups_notifier_get_default ();
	notifier = _tmp17_;
	_tmp20_ = self->priv->_state;
	if (_tmp20_ != IPP_JOB_CANCELED) {
		ipp_jstate_t _tmp21_;
		_tmp21_ = self->priv->_state;
		_tmp19_ = _tmp21_ != IPP_JOB_ABORTED;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ipp_jstate_t _tmp22_;
		_tmp22_ = self->priv->_state;
		_tmp18_ = _tmp22_ != IPP_JOB_COMPLETED;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		CupsNotifier* _tmp23_;
		CupsNotifier* _tmp24_;
		CupsNotifier* _tmp25_;
		_tmp23_ = notifier;
		g_signal_connect_object (_tmp23_, "job-progress", (GCallback) _printers_job_on_job_state_changed_cups_notifier_job_progress, self, 0);
		_tmp24_ = notifier;
		g_signal_connect_object (_tmp24_, "job-completed", (GCallback) _printers_job_on_job_state_changed_cups_notifier_job_completed, self, 0);
		_tmp25_ = notifier;
		g_signal_connect_object (_tmp25_, "job-state-changed", (GCallback) _printers_job_on_job_state_changed_cups_notifier_job_state_changed, self, 0);
	}
	_g_date_time_unref0 (_tmp7_);
	_g_date_time_unref0 (_tmp0_);
	return self;
}

PrintersJob*
printers_job_new (cups_job_t* cjob,
                  PrintersPrinter* printer)
{
	return printers_job_construct (PRINTERS_TYPE_JOB, cjob, printer);
}

static void
printers_job_on_job_state_changed (PrintersJob* self,
                                   const gchar* text,
                                   const gchar* printer_uri,
                                   const gchar* name,
                                   guint32 printer_state,
                                   const gchar* state_reasons,
                                   gboolean is_accepting_jobs,
                                   guint32 job_id,
                                   guint32 job_state,
                                   const gchar* job_state_reason,
                                   const gchar* job_name,
                                   guint32 job_impressions_completed)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (printer_uri != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (state_reasons != NULL);
	g_return_if_fail (job_state_reason != NULL);
	g_return_if_fail (job_name != NULL);
	_tmp0_ = self->priv->_uid;
	if (job_id == ((guint32) _tmp0_)) {
		gboolean _tmp1_ = FALSE;
		ipp_jstate_t _tmp2_;
		printers_job_set_state (self, (ipp_jstate_t) job_state);
		_tmp2_ = self->priv->_state;
		if (_tmp2_ == IPP_JOB_COMPLETED) {
			GDateTime* _tmp3_;
			_tmp3_ = self->priv->_completed_time;
			_tmp1_ = _tmp3_ == NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GTimeZone* _tmp4_;
			GTimeZone* _tmp5_;
			GDateTime* _tmp6_;
			GDateTime* _tmp7_;
			_tmp4_ = g_time_zone_new_local ();
			_tmp5_ = _tmp4_;
			_tmp6_ = g_date_time_new_now (_tmp5_);
			_tmp7_ = _tmp6_;
			printers_job_set_completed_time (self, _tmp7_);
			_g_date_time_unref0 (_tmp7_);
			_g_time_zone_unref0 (_tmp5_);
		}
		g_signal_emit (self, printers_job_signals[PRINTERS_JOB_STATE_CHANGED_SIGNAL], 0);
	}
}

void
printers_job_pause (PrintersJob* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->priv->_uid;
		_tmp2_ = cups_pk_helper_job_set_hold_until (_tmp0_, _tmp1_, "indefinite", &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Job.vala:76: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
printers_job_stop (PrintersJob* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->priv->_uid;
		_tmp2_ = cups_pk_helper_job_cancel_purge (_tmp0_, _tmp1_, FALSE, &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Job.vala:84: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
printers_job_purge (PrintersJob* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->priv->_uid;
		_tmp2_ = cups_pk_helper_job_cancel_purge (_tmp0_, _tmp1_, TRUE, &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Job.vala:92: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
printers_job_resume (PrintersJob* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->priv->_uid;
		_tmp2_ = cups_pk_helper_job_set_hold_until (_tmp0_, _tmp1_, "no-hold", &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Job.vala:100: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

GDateTime*
printers_job_get_display_time (PrintersJob* self)
{
	ipp_jstate_t _tmp0_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case IPP_JOB_CANCELED:
		case IPP_JOB_ABORTED:
		{
			result = NULL;
			return result;
		}
		case IPP_JOB_COMPLETED:
		{
			GDateTime* _tmp1_;
			GDateTime* _tmp2_;
			_tmp1_ = self->priv->_completed_time;
			_tmp2_ = _g_date_time_ref0 (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case IPP_JOB_STOPPED:
		case IPP_JOB_PENDING:
		case IPP_JOB_PROCESSING:
		case IPP_JOB_HELD:
		{
			break;
		}
		default:
		break;
	}
	_tmp3_ = self->priv->_creation_time;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

gchar*
printers_job_translated_job_state (PrintersJob* self)
{
	ipp_jstate_t _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case IPP_JOB_PENDING:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (C_ ("Print Job", "Pending"));
			result = _tmp1_;
			return result;
		}
		case IPP_JOB_HELD:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (C_ ("Print Job", "On Hold"));
			result = _tmp2_;
			return result;
		}
		case IPP_JOB_PROCESSING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (C_ ("Print Job", "In Progress"));
			result = _tmp3_;
			return result;
		}
		case IPP_JOB_STOPPED:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (C_ ("Print Job", "Stopped"));
			result = _tmp4_;
			return result;
		}
		case IPP_JOB_CANCELED:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (C_ ("Print Job", "Canceled"));
			result = _tmp5_;
			return result;
		}
		case IPP_JOB_ABORTED:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (C_ ("Print Job", "Aborted"));
			result = _tmp6_;
			return result;
		}
		default:
		case IPP_JOB_COMPLETED:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (C_ ("Print Job", "Completed"));
			result = _tmp7_;
			return result;
		}
	}
}

GIcon*
printers_job_state_icon (PrintersJob* self)
{
	ipp_jstate_t _tmp0_;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case IPP_JOB_PENDING:
		case IPP_JOB_PROCESSING:
		{
			result = NULL;
			return result;
		}
		case IPP_JOB_HELD:
		{
			GThemedIcon* _tmp1_;
			_tmp1_ = (GThemedIcon*) g_themed_icon_new ("process-paused");
			result = (GIcon*) _tmp1_;
			return result;
		}
		case IPP_JOB_STOPPED:
		case IPP_JOB_CANCELED:
		{
			GThemedIcon* _tmp2_;
			_tmp2_ = (GThemedIcon*) g_themed_icon_new ("process-stop");
			result = (GIcon*) _tmp2_;
			return result;
		}
		case IPP_JOB_ABORTED:
		{
			GThemedIcon* _tmp3_;
			_tmp3_ = (GThemedIcon*) g_themed_icon_new ("process-error");
			result = (GIcon*) _tmp3_;
			return result;
		}
		case IPP_JOB_COMPLETED:
		{
			GThemedIcon* _tmp4_;
			_tmp4_ = (GThemedIcon*) g_themed_icon_new ("process-completed");
			result = (GIcon*) _tmp4_;
			return result;
		}
		default:
		break;
	}
	result = NULL;
	return result;
}

GIcon*
printers_job_get_file_icon (PrintersJob* self)
{
	gchar* content_type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result_uncertain = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp7_;
	GThemedIcon* _tmp10_;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_format;
	_tmp1_ = g_content_type_from_mime_type (_tmp0_);
	content_type = _tmp1_;
	_tmp2_ = content_type;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		GIcon* _tmp4_;
		_tmp3_ = content_type;
		_tmp4_ = g_content_type_get_icon (_tmp3_);
		result = _tmp4_;
		_g_free0 (content_type);
		return result;
	}
	_tmp5_ = self->priv->_title;
	_tmp7_ = g_content_type_guess (_tmp5_, NULL, (gsize) 0, &_tmp6_);
	result_uncertain = _tmp6_;
	_g_free0 (content_type);
	content_type = _tmp7_;
	if (!result_uncertain) {
		const gchar* _tmp8_;
		GIcon* _tmp9_;
		_tmp8_ = content_type;
		_tmp9_ = g_content_type_get_icon (_tmp8_);
		result = _tmp9_;
		_g_free0 (content_type);
		return result;
	}
	_tmp10_ = (GThemedIcon*) g_themed_icon_new ("unknown");
	result = (GIcon*) _tmp10_;
	_g_free0 (content_type);
	return result;
}

PrintersPrinter*
printers_job_get_printer (PrintersJob* self)
{
	PrintersPrinter* result;
	PrintersPrinter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_printer;
	result = _tmp0_;
	return result;
}

static void
printers_job_set_printer (PrintersJob* self,
                          PrintersPrinter* value)
{
	PrintersPrinter* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_printer (self);
	if (old_value != value) {
		self->priv->_printer = value;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_PRINTER_PROPERTY]);
	}
}

gint
printers_job_get_uid (PrintersJob* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_uid;
	return result;
}

static void
printers_job_set_uid (PrintersJob* self,
                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_uid (self);
	if (old_value != value) {
		self->priv->_uid = value;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_UID_PROPERTY]);
	}
}

ipp_jstate_t
printers_job_get_state (PrintersJob* self)
{
	ipp_jstate_t result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
printers_job_set_state (PrintersJob* self,
                        ipp_jstate_t value)
{
	ipp_jstate_t old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_STATE_PROPERTY]);
	}
}

const gchar*
printers_job_get_title (PrintersJob* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
printers_job_set_title (PrintersJob* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_TITLE_PROPERTY]);
	}
}

const gchar*
printers_job_get_format (PrintersJob* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_format;
	result = _tmp0_;
	return result;
}

static void
printers_job_set_format (PrintersJob* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_format (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_format);
		self->priv->_format = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_FORMAT_PROPERTY]);
	}
}

const gchar*
printers_job_get_reasons (PrintersJob* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reasons;
	result = _tmp0_;
	return result;
}

void
printers_job_set_reasons (PrintersJob* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_reasons (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_reasons);
		self->priv->_reasons = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_REASONS_PROPERTY]);
	}
}

GDateTime*
printers_job_get_creation_time (PrintersJob* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_creation_time;
	result = _tmp0_;
	return result;
}

static void
printers_job_set_creation_time (PrintersJob* self,
                                GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_creation_time (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_creation_time);
		self->priv->_creation_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_CREATION_TIME_PROPERTY]);
	}
}

GDateTime*
printers_job_get_completed_time (PrintersJob* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_completed_time;
	result = _tmp0_;
	return result;
}

void
printers_job_set_completed_time (PrintersJob* self,
                                 GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_job_get_completed_time (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_completed_time);
		self->priv->_completed_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_job_properties[PRINTERS_JOB_COMPLETED_TIME_PROPERTY]);
	}
}

gboolean
printers_job_get_is_ongoing (PrintersJob* self)
{
	gboolean result;
	ipp_jstate_t _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case IPP_JOB_PENDING:
		case IPP_JOB_HELD:
		case IPP_JOB_PROCESSING:
		case IPP_JOB_STOPPED:
		{
			result = TRUE;
			return result;
		}
		case IPP_JOB_CANCELED:
		case IPP_JOB_ABORTED:
		case IPP_JOB_COMPLETED:
		{
			result = FALSE;
			return result;
		}
		default:
		break;
	}
	g_assert_not_reached ();
}

static void
printers_job_class_init (PrintersJobClass * klass,
                         gpointer klass_data)
{
	printers_job_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersJob_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_job_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_job_set_property;
	G_OBJECT_CLASS (klass)->finalize = printers_job_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_PRINTER_PROPERTY, printers_job_properties[PRINTERS_JOB_PRINTER_PROPERTY] = g_param_spec_object ("printer", "printer", "printer", PRINTERS_TYPE_PRINTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_UID_PROPERTY, printers_job_properties[PRINTERS_JOB_UID_PROPERTY] = g_param_spec_int ("uid", "uid", "uid", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_STATE_PROPERTY, printers_job_properties[PRINTERS_JOB_STATE_PROPERTY] = g_param_spec_int ("state", "state", "state", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_TITLE_PROPERTY, printers_job_properties[PRINTERS_JOB_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_FORMAT_PROPERTY, printers_job_properties[PRINTERS_JOB_FORMAT_PROPERTY] = g_param_spec_string ("format", "format", "format", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_REASONS_PROPERTY, printers_job_properties[PRINTERS_JOB_REASONS_PROPERTY] = g_param_spec_string ("reasons", "reasons", "reasons", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_CREATION_TIME_PROPERTY, printers_job_properties[PRINTERS_JOB_CREATION_TIME_PROPERTY] = g_param_spec_boxed ("creation-time", "creation-time", "creation-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_COMPLETED_TIME_PROPERTY, printers_job_properties[PRINTERS_JOB_COMPLETED_TIME_PROPERTY] = g_param_spec_boxed ("completed-time", "completed-time", "completed-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOB_IS_ONGOING_PROPERTY, printers_job_properties[PRINTERS_JOB_IS_ONGOING_PROPERTY] = g_param_spec_boolean ("is-ongoing", "is-ongoing", "is-ongoing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	printers_job_signals[PRINTERS_JOB_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", PRINTERS_TYPE_JOB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
printers_job_instance_init (PrintersJob * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	self->priv = printers_job_get_instance_private (self);
	_tmp0_ = g_strdup ("None");
	self->priv->_reasons = _tmp0_;
	self->priv->_completed_time = NULL;
}

static void
printers_job_finalize (GObject * obj)
{
	PrintersJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_JOB, PrintersJob);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_format);
	_g_free0 (self->priv->_reasons);
	_g_date_time_unref0 (self->priv->_creation_time);
	_g_date_time_unref0 (self->priv->_completed_time);
	G_OBJECT_CLASS (printers_job_parent_class)->finalize (obj);
}

static GType
printers_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersJob), 0, (GInstanceInitFunc) printers_job_instance_init, NULL };
	GType printers_job_type_id;
	printers_job_type_id = g_type_register_static (G_TYPE_OBJECT, "PrintersJob", &g_define_type_info, 0);
	PrintersJob_private_offset = g_type_add_instance_private (printers_job_type_id, sizeof (PrintersJobPrivate));
	return printers_job_type_id;
}

GType
printers_job_get_type (void)
{
	static volatile gsize printers_job_type_id__once = 0;
	if (g_once_init_enter (&printers_job_type_id__once)) {
		GType printers_job_type_id;
		printers_job_type_id = printers_job_get_type_once ();
		g_once_init_leave (&printers_job_type_id__once, printers_job_type_id);
	}
	return printers_job_type_id__once;
}

static void
_vala_printers_job_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	PrintersJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_JOB, PrintersJob);
	switch (property_id) {
		case PRINTERS_JOB_PRINTER_PROPERTY:
		g_value_set_object (value, printers_job_get_printer (self));
		break;
		case PRINTERS_JOB_UID_PROPERTY:
		g_value_set_int (value, printers_job_get_uid (self));
		break;
		case PRINTERS_JOB_STATE_PROPERTY:
		g_value_set_int (value, printers_job_get_state (self));
		break;
		case PRINTERS_JOB_TITLE_PROPERTY:
		g_value_set_string (value, printers_job_get_title (self));
		break;
		case PRINTERS_JOB_FORMAT_PROPERTY:
		g_value_set_string (value, printers_job_get_format (self));
		break;
		case PRINTERS_JOB_REASONS_PROPERTY:
		g_value_set_string (value, printers_job_get_reasons (self));
		break;
		case PRINTERS_JOB_CREATION_TIME_PROPERTY:
		g_value_set_boxed (value, printers_job_get_creation_time (self));
		break;
		case PRINTERS_JOB_COMPLETED_TIME_PROPERTY:
		g_value_set_boxed (value, printers_job_get_completed_time (self));
		break;
		case PRINTERS_JOB_IS_ONGOING_PROPERTY:
		g_value_set_boolean (value, printers_job_get_is_ongoing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_job_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	PrintersJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_JOB, PrintersJob);
	switch (property_id) {
		case PRINTERS_JOB_PRINTER_PROPERTY:
		printers_job_set_printer (self, g_value_get_object (value));
		break;
		case PRINTERS_JOB_UID_PROPERTY:
		printers_job_set_uid (self, g_value_get_int (value));
		break;
		case PRINTERS_JOB_STATE_PROPERTY:
		printers_job_set_state (self, g_value_get_int (value));
		break;
		case PRINTERS_JOB_TITLE_PROPERTY:
		printers_job_set_title (self, g_value_get_string (value));
		break;
		case PRINTERS_JOB_FORMAT_PROPERTY:
		printers_job_set_format (self, g_value_get_string (value));
		break;
		case PRINTERS_JOB_REASONS_PROPERTY:
		printers_job_set_reasons (self, g_value_get_string (value));
		break;
		case PRINTERS_JOB_CREATION_TIME_PROPERTY:
		printers_job_set_creation_time (self, g_value_get_boxed (value));
		break;
		case PRINTERS_JOB_COMPLETED_TIME_PROPERTY:
		printers_job_set_completed_time (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

