/* umockdev-record.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from umockdev-record.vala, do not modify */

/*
 * Record Linux devices and their ancestors from sysfs/udev.
 * All attributes and properties are included, non-ASCII ones get printed in hex.
 * The record is written to the standard output.
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <glib-object.h>
#include "umockdev-utils.h"
#include "config.h"
#include <sys/wait.h>
#include <signal.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UMOCKDEV_TYPE_IOCTL_BASE (umockdev_ioctl_base_get_type ())
#define UMOCKDEV_IOCTL_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBase))
#define UMOCKDEV_IOCTL_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBaseClass))
#define UMOCKDEV_IS_IOCTL_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_BASE))
#define UMOCKDEV_IS_IOCTL_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_BASE))
#define UMOCKDEV_IOCTL_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBaseClass))

typedef struct _UMockdevIoctlBase UMockdevIoctlBase;
typedef struct _UMockdevIoctlBaseClass UMockdevIoctlBaseClass;

#define UMOCKDEV_TYPE_IOCTL_SPI_BASE (umockdev_ioctl_spi_base_get_type ())
#define UMOCKDEV_IOCTL_SPI_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBase))
#define UMOCKDEV_IOCTL_SPI_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBaseClass))
#define UMOCKDEV_IS_IOCTL_SPI_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE))
#define UMOCKDEV_IS_IOCTL_SPI_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_SPI_BASE))
#define UMOCKDEV_IOCTL_SPI_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBaseClass))

typedef struct _UMockdevIoctlSpiBase UMockdevIoctlSpiBase;
typedef struct _UMockdevIoctlSpiBaseClass UMockdevIoctlSpiBaseClass;

#define UMOCKDEV_TYPE_IOCTL_SPI_RECORDER (umockdev_ioctl_spi_recorder_get_type ())
#define UMOCKDEV_IOCTL_SPI_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, UMockdevIoctlSpiRecorder))
#define UMOCKDEV_IOCTL_SPI_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, UMockdevIoctlSpiRecorderClass))
#define UMOCKDEV_IS_IOCTL_SPI_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER))
#define UMOCKDEV_IS_IOCTL_SPI_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER))
#define UMOCKDEV_IOCTL_SPI_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, UMockdevIoctlSpiRecorderClass))

typedef struct _UMockdevIoctlSpiRecorder UMockdevIoctlSpiRecorder;
typedef struct _UMockdevIoctlSpiRecorderClass UMockdevIoctlSpiRecorderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UMOCKDEV_TYPE_IOCTL_TREE_RECORDER (umockdev_ioctl_tree_recorder_get_type ())
#define UMOCKDEV_IOCTL_TREE_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, UMockdevIoctlTreeRecorder))
#define UMOCKDEV_IOCTL_TREE_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, UMockdevIoctlTreeRecorderClass))
#define UMOCKDEV_IS_IOCTL_TREE_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER))
#define UMOCKDEV_IS_IOCTL_TREE_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER))
#define UMOCKDEV_IOCTL_TREE_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, UMockdevIoctlTreeRecorderClass))

typedef struct _UMockdevIoctlTreeRecorder UMockdevIoctlTreeRecorder;
typedef struct _UMockdevIoctlTreeRecorderClass UMockdevIoctlTreeRecorderClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

VALA_EXTERN guint record_script_counter;
guint record_script_counter = (guint) 0;
VALA_EXTERN gchar** opt_devices;
gchar** opt_devices = NULL;
VALA_EXTERN gboolean opt_all;
gboolean opt_all = FALSE;
VALA_EXTERN gchar* opt_ioctl;
gchar* opt_ioctl = NULL;
VALA_EXTERN gchar** opt_script;
gchar** opt_script = NULL;
VALA_EXTERN gchar** opt_evemu_events;
gchar** opt_evemu_events = NULL;
VALA_EXTERN gboolean opt_version;
gboolean opt_version = FALSE;
VALA_EXTERN GMainLoop* loop;
GMainLoop* loop = NULL;
VALA_EXTERN GPid child_pid;
GPid child_pid = 0;
VALA_EXTERN gint child_status;
gint child_status = 0;

VALA_EXTERN void devices_from_dir (const gchar* dir,
                       GPtrArray** devs);
VALA_EXTERN gchar** all_devices (void);
static void _g_free0_ (gpointer var);
VALA_EXTERN gchar* resolve (const gchar* dev);
VALA_EXTERN gchar* parent (const gchar* dev);
VALA_EXTERN gchar* format_hex (guint8* bytes,
                   gint bytes_length1,
                   gint len);
VALA_EXTERN void write_attr (const gchar* name,
                 guint8* val,
                 gint val_length1);
VALA_EXTERN gchar* dev_contents (const gchar* dev);
VALA_EXTERN void print_device_attributes (const gchar* devpath,
                              const gchar* subdir);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN void record_device (const gchar* dev);
VALA_EXTERN void dump_devices (gchar** devices,
                   gint devices_length1);
VALA_EXTERN void split_devfile_arg (const gchar* arg,
                        gchar** dev,
                        gchar** devnum,
                        gboolean* is_block,
                        gchar** fname);
VALA_EXTERN GType umockdev_ioctl_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlBase, g_object_unref)
VALA_EXTERN UMockdevIoctlBase* record_ioctl (const gchar* root_dir,
                                 const gchar* arg);
VALA_EXTERN UMockdevIoctlSpiRecorder* umockdev_ioctl_spi_recorder_new (const gchar* device,
                                                           const gchar* file);
VALA_EXTERN UMockdevIoctlSpiRecorder* umockdev_ioctl_spi_recorder_construct (GType object_type,
                                                                 const gchar* device,
                                                                 const gchar* file);
VALA_EXTERN GType umockdev_ioctl_spi_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlSpiBase, g_object_unref)
VALA_EXTERN GType umockdev_ioctl_spi_recorder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlSpiRecorder, g_object_unref)
VALA_EXTERN UMockdevIoctlTreeRecorder* umockdev_ioctl_tree_recorder_new (const gchar* device,
                                                             const gchar* file);
VALA_EXTERN UMockdevIoctlTreeRecorder* umockdev_ioctl_tree_recorder_construct (GType object_type,
                                                                   const gchar* device,
                                                                   const gchar* file);
VALA_EXTERN GType umockdev_ioctl_tree_recorder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlTreeRecorder, g_object_unref)
VALA_EXTERN void umockdev_ioctl_base_register_path (UMockdevIoctlBase* self,
                                        GMainContext* ctx,
                                        const gchar* devnode,
                                        const gchar* sockpath);
VALA_EXTERN void record_script (const gchar* arg,
                    const gchar* format);
VALA_EXTERN void child_watch_cb (GPid pid,
                     gint status);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _child_watch_cb_gchild_watch_func (GPid pid,
                                        gint wait_status,
                                        gpointer self);
VALA_EXTERN void umockdev_ioctl_base_unregister_all (UMockdevIoctlBase* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const GOptionEntry options[7] = {{"all", 'a', (gint) 0, G_OPTION_ARG_NONE, &opt_all, "Record all devices"}, {"ioctl", 'i', (gint) 0, G_OPTION_ARG_FILENAME, &opt_ioctl, "Trace ioctls on the device, record into given file. In this case, all " \
"positional arguments are a command (and its arguments) to run that get" \
"s traced.", "devname=FILE"}, {"script", 's', (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_script, "Trace reads and writes on the device, record into given file. In this " \
"case, all positional arguments are a command (and its arguments) to ru" \
"n that gets traced. Can be specified multiple times.", "devname=FILE"}, {"evemu-events", 'e', (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_evemu_events, "Trace evdev event reads on the device, record into given file in EVEMU" \
" event format. In this case, all positional arguments are a command (a" \
"nd its arguments) to run that gets traced. Can be specified multiple t" \
"imes.", "devname=FILE"}, {"", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &opt_devices, "Path of a device in /dev or /sys, or command and arguments with --ioct" \
"l.", "DEVICE [...]"}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &opt_version, "Output version information and exit"}, {NULL}};

void
devices_from_dir (const gchar* dir,
                  GPtrArray** devs)
{
	GDir* d = NULL;
	gboolean has_uevent = FALSE;
	gboolean has_subsystem = FALSE;
	gchar* entry = NULL;
	gboolean _tmp19_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dir != NULL);
	g_return_if_fail (*devs != NULL);
	{
		GDir* _tmp0_ = NULL;
		GDir* _tmp1_;
		GDir* _tmp2_;
		_tmp1_ = g_dir_open (dir, (guint) 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (d);
		d = _tmp2_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		_g_dir_close0 (d);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	has_uevent = FALSE;
	has_subsystem = FALSE;
	while (TRUE) {
		GDir* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = d;
		_tmp4_ = g_dir_read_name (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (entry);
		entry = _tmp5_;
		_tmp6_ = entry;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = entry;
		if (g_strcmp0 (_tmp7_, "uevent") == 0) {
			has_uevent = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = entry;
			if (g_strcmp0 (_tmp8_, "subsystem") == 0) {
				has_subsystem = TRUE;
			} else {
				gchar* p = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				struct stat st = {0};
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_;
				struct stat _tmp14_ = {0};
				gint _tmp15_;
				_tmp9_ = entry;
				_tmp10_ = g_build_filename (dir, _tmp9_, NULL);
				p = _tmp10_;
				_tmp13_ = p;
				_tmp15_ = lstat (_tmp13_, &_tmp14_);
				st = _tmp14_;
				if (_tmp15_ == 0) {
					struct stat _tmp16_;
					_tmp16_ = st;
					_tmp12_ = S_ISDIR (_tmp16_.st_mode);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					struct stat _tmp17_;
					_tmp17_ = st;
					_tmp11_ = !S_ISLNK (_tmp17_.st_mode);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					const gchar* _tmp18_;
					_tmp18_ = p;
					devices_from_dir (_tmp18_, devs);
				}
				_g_free0 (p);
			}
		}
	}
	if (has_uevent) {
		_tmp19_ = has_subsystem;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup (dir);
		g_ptr_array_add (*devs, _tmp20_);
	}
	_g_free0 (entry);
	_g_dir_close0 (d);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

gchar**
all_devices (void)
{
	GPtrArray* devs = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gsize _tmp2_ = 0;
	gpointer* _tmp3_;
	gchar** result;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	devs = _tmp0_;
	devices_from_dir ("/sys/devices", &devs);
	_tmp1_ = devs;
	_tmp3_ = g_ptr_array_steal (_tmp1_, &_tmp2_);
	result = _tmp3_;
	_g_ptr_array_unref0 (devs);
	return result;
}

gchar*
resolve (const gchar* dev)
{
	struct stat st = {0};
	struct stat _tmp0_ = {0};
	gint _tmp1_;
	guint maj = 0U;
	struct stat _tmp2_;
	guint min = 0U;
	struct stat _tmp3_;
	gchar* link = NULL;
	struct stat _tmp4_;
	gchar* real = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	gchar* result;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp1_ = stat (dev, &_tmp0_);
	st = _tmp0_;
	if (_tmp1_ != 0) {
		g_error ("umockdev-record.vala:73: Cannot access device %s: %m", dev);
	}
	_tmp2_ = st;
	maj = major (_tmp2_.st_rdev);
	_tmp3_ = st;
	min = minor (_tmp3_.st_rdev);
	_tmp4_ = st;
	if (S_ISCHR (_tmp4_.st_mode)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf ("/sys/dev/char/%u:%u", maj, min);
		_g_free0 (link);
		link = _tmp5_;
	} else {
		struct stat _tmp6_;
		_tmp6_ = st;
		if (S_ISBLK (_tmp6_.st_mode)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup_printf ("/sys/dev/block/%u:%u", maj, min);
			_g_free0 (link);
			link = _tmp7_;
		} else {
			gchar* _tmp8_;
			_tmp8_ = g_strdup (dev);
			_g_free0 (link);
			link = _tmp8_;
		}
	}
	_tmp9_ = link;
	_tmp10_ = realpath (_tmp9_, NULL);
	real = _tmp10_;
	_tmp11_ = real;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = link;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (real);
		real = _tmp13_;
	}
	_tmp14_ = real;
	_tmp15_ = g_build_filename (_tmp14_, "uevent", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = !g_file_test (_tmp16_, G_FILE_TEST_EXISTS);
	_g_free0 (_tmp16_);
	if (_tmp17_) {
		const gchar* _tmp18_;
		_tmp18_ = real;
		g_error ("umockdev-record.vala:94: Invalid device %s, has no uevent attribute", _tmp18_);
	}
	result = real;
	_g_free0 (link);
	return result;
}

gchar*
parent (const gchar* dev)
{
	gchar* p = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = g_path_get_dirname (dev);
	p = _tmp0_;
	_tmp1_ = p;
	if (!g_str_has_prefix (_tmp1_, "/sys")) {
		result = NULL;
		_g_free0 (p);
		return result;
	}
	_tmp3_ = p;
	_tmp4_ = g_build_filename (_tmp3_, "uevent", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_test (_tmp5_, G_FILE_TEST_EXISTS);
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = p;
		_tmp8_ = g_build_filename (_tmp7_, "subsystem", NULL);
		_tmp9_ = _tmp8_;
		_tmp2_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
		_g_free0 (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = p;
		return result;
	}
	_tmp10_ = p;
	_tmp11_ = parent (_tmp10_);
	result = _tmp11_;
	_g_free0 (p);
	return result;
}

gchar*
format_hex (guint8* bytes,
            gint bytes_length1,
            gint len)
{
	GString* _result_ = NULL;
	GString* _tmp0_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	if (len < 0) {
		len = bytes_length1;
	}
	_tmp0_ = g_string_new ("");
	_result_ = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GString* _tmp3_;
				guint8 _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					i = i + 1;
					_tmp2_ = i;
				}
				_tmp1_ = FALSE;
				if (!(i < len)) {
					break;
				}
				_tmp3_ = _result_;
				_tmp4_ = bytes[i];
				g_string_append_printf (_tmp3_, "%02X", (guint) _tmp4_);
			}
		}
	}
	_tmp5_ = _result_;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (_result_);
	return result;
}

void
write_attr (const gchar* name,
            guint8* val,
            gint val_length1)
{
	gchar* strval = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	FILE* _tmp13_;
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup ((const gchar*) val);
	strval = _tmp0_;
	_tmp2_ = strval;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (val_length1 == _tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = strval;
		_tmp1_ = g_utf8_validate (_tmp5_, (gssize) -1, NULL);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FILE* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = stdout;
		_tmp7_ = strval;
		_tmp8_ = g_strescape (_tmp7_, "");
		_tmp9_ = _tmp8_;
		fprintf (_tmp6_, "A: %s=%s", name, _tmp9_);
		_g_free0 (_tmp9_);
	} else {
		FILE* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = stdout;
		_tmp11_ = format_hex (val, (gint) val_length1, -1);
		_tmp12_ = _tmp11_;
		fprintf (_tmp10_, "H: %s=%s", name, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = stdout;
	fputc ('\n', _tmp13_);
	_g_free0 (strval);
}

gchar*
dev_contents (const gchar* dev)
{
	struct stat st = {0};
	struct stat _tmp0_ = {0};
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	struct stat _tmp4_;
	gint fd = 0;
	guint8* buffer = NULL;
	guint8* _tmp8_;
	gint buffer_length1;
	gint _buffer_size_;
	gssize len = 0L;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gchar* _result_ = NULL;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gchar* result;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp1_ = lstat (dev, &_tmp0_);
	st = _tmp0_;
	if (_tmp1_ != 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	_tmp4_ = st;
	if (!S_ISCHR (_tmp4_.st_mode)) {
		_tmp3_ = TRUE;
	} else {
		struct stat _tmp5_;
		_tmp5_ = st;
		_tmp3_ = major (_tmp5_.st_rdev) != ((guint) 189);
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		return result;
	}
	fd = open (dev, O_RDONLY | O_NONBLOCK, (mode_t) 0);
	if (fd < 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		return result;
	}
	_tmp8_ = g_new0 (guint8, 1025);
	buffer = _tmp8_;
	buffer_length1 = 1025;
	_buffer_size_ = buffer_length1;
	_tmp9_ = buffer;
	_tmp9__length1 = buffer_length1;
	len = read (fd, _tmp9_, (gsize) 1025);
	_tmp10_ = g_strdup ("");
	_result_ = _tmp10_;
	if (len > ((gssize) 0)) {
		_tmp11_ = len <= ((gssize) 1024);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		guint8* _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = buffer;
		_tmp12__length1 = buffer_length1;
		_tmp13_ = format_hex (_tmp12_, (gint) _tmp12__length1, (gint) len);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("=", _tmp14_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp15_;
		_g_free0 (_tmp14_);
	}
	close (fd);
	result = _result_;
	buffer = (g_free (buffer), NULL);
	return result;
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

void
print_device_attributes (const gchar* devpath,
                         const gchar* subdir)
{
	GDir* d = NULL;
	gchar* attr_dir = NULL;
	gchar* _tmp0_;
	GList* attributes = NULL;
	gchar* entry = NULL;
	GCompareFunc _tmp20_;
	GList* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (subdir != NULL);
	_tmp0_ = g_build_filename (devpath, subdir, NULL);
	attr_dir = _tmp0_;
	{
		GDir* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GDir* _tmp3_;
		GDir* _tmp4_;
		_tmp2_ = attr_dir;
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_dir_close0 (d);
		d = _tmp4_;
		_g_dir_close0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (g_strcmp0 (subdir, "") == 0) {
			const gchar* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = attr_dir;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_error ("umockdev-record.vala:173: Cannot open directory %s: %s", _tmp5_, _tmp7_);
		} else {
			const gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = attr_dir;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_debug ("umockdev-record.vala:177: Cannot open directory %s: %s", _tmp8_, _tmp10_);
		}
		_g_error_free0 (e);
		_g_free0 (attr_dir);
		_g_dir_close0 (d);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (attr_dir);
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	attributes = NULL;
	while (TRUE) {
		GDir* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_;
		_tmp11_ = d;
		_tmp12_ = g_dir_read_name (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (entry);
		entry = _tmp13_;
		_tmp14_ = entry;
		if (!(_tmp14_ != NULL)) {
			break;
		}
		_tmp16_ = entry;
		if (g_strcmp0 (_tmp16_, "subsystem") != 0) {
			const gchar* _tmp17_;
			_tmp17_ = entry;
			_tmp15_ = g_strcmp0 (_tmp17_, "uevent") != 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = entry;
			_tmp19_ = g_strdup (_tmp18_);
			attributes = g_list_append (attributes, _tmp19_);
		} else {
			if (g_strcmp0 (subdir, "") != 0) {
				_g_free0 (entry);
				(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
				_g_free0 (attr_dir);
				_g_dir_close0 (d);
				return;
			}
		}
	}
	_tmp20_ = ((GCompareFunc) g_strcmp0);
	attributes = g_list_sort (attributes, _tmp20_);
	_tmp21_ = attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp21_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			gchar* _tmp22_;
			gchar* attr = NULL;
			_tmp22_ = g_strdup ((const gchar*) attr_it->data);
			attr = _tmp22_;
			{
				gchar* attr_path = NULL;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* attr_name = NULL;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				_tmp23_ = attr_dir;
				_tmp24_ = attr;
				_tmp25_ = g_build_filename (_tmp23_, _tmp24_, NULL);
				attr_path = _tmp25_;
				_tmp26_ = attr;
				_tmp27_ = g_build_filename (subdir, _tmp26_, NULL);
				attr_name = _tmp27_;
				_tmp28_ = attr_path;
				if (g_file_test (_tmp28_, G_FILE_TEST_IS_SYMLINK)) {
					{
						gchar* _tmp29_ = NULL;
						const gchar* _tmp30_;
						gchar* _tmp31_;
						FILE* _tmp32_;
						const gchar* _tmp33_;
						_tmp30_ = attr_path;
						_tmp31_ = g_file_read_link (_tmp30_, &_inner_error0_);
						_tmp29_ = _tmp31_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp32_ = stdout;
						_tmp33_ = attr_name;
						fprintf (_tmp32_, "L: %s=%s\n", _tmp33_, _tmp29_);
						_g_free0 (_tmp29_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp34_ = attr_path;
						_tmp35_ = e->message;
						g_error ("umockdev-record.vala:202: Cannot read link %s: %s", _tmp34_, _tmp35_);
						_g_error_free0 (e);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (attr_name);
						_g_free0 (attr_path);
						_g_free0 (attr);
						_g_free0 (entry);
						(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
						_g_free0 (attr_dir);
						_g_dir_close0 (d);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				} else {
					const gchar* _tmp36_;
					_tmp36_ = attr_path;
					if (g_file_test (_tmp36_, G_FILE_TEST_IS_REGULAR)) {
						guint8* contents = NULL;
						gint contents_length1 = 0;
						gint _contents_size_ = 0;
						{
							const gchar* _tmp37_;
							guint8* _tmp38_ = NULL;
							gsize _tmp39_ = 0;
							const gchar* _tmp40_;
							guint8* _tmp41_;
							gint _tmp41__length1;
							_tmp37_ = attr_path;
							g_file_get_contents (_tmp37_, (gchar**) (&_tmp38_), &_tmp39_, &_inner_error0_);
							contents = (g_free (contents), NULL);
							contents = _tmp38_;
							contents_length1 = _tmp39_;
							_contents_size_ = contents_length1;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == G_FILE_ERROR) {
									goto __catch2_g_file_error;
								}
								contents = (g_free (contents), NULL);
								_g_free0 (attr_name);
								_g_free0 (attr_path);
								_g_free0 (attr);
								_g_free0 (entry);
								(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
								_g_free0 (attr_dir);
								_g_dir_close0 (d);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							_tmp40_ = attr_name;
							_tmp41_ = contents;
							_tmp41__length1 = contents_length1;
							write_attr (_tmp40_, _tmp41_, (gint) _tmp41__length1);
						}
						goto __finally2;
						__catch2_g_file_error:
						{
							g_clear_error (&_inner_error0_);
						}
						__finally2:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							contents = (g_free (contents), NULL);
							_g_free0 (attr_name);
							_g_free0 (attr_path);
							_g_free0 (attr);
							_g_free0 (entry);
							(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
							_g_free0 (attr_dir);
							_g_dir_close0 (d);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						contents = (g_free (contents), NULL);
					} else {
						const gchar* _tmp42_;
						_tmp42_ = attr_path;
						if (g_file_test (_tmp42_, G_FILE_TEST_IS_DIR)) {
							const gchar* _tmp43_;
							_tmp43_ = attr;
							print_device_attributes (devpath, _tmp43_);
						}
					}
				}
				_g_free0 (attr_name);
				_g_free0 (attr_path);
				_g_free0 (attr);
			}
		}
	}
	_g_free0 (entry);
	(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
	_g_free0 (attr_dir);
	_g_dir_close0 (d);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
record_device (const gchar* dev)
{
	gchar* u_out = NULL;
	gchar* u_err = NULL;
	gint exitcode = 0;
	GList* properties = NULL;
	const gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	GCompareFunc _tmp57_;
	GList* _tmp58_;
	FILE* _tmp64_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dev != NULL);
	g_debug ("umockdev-record.vala:219: recording device %s", dev);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp0_ = g_strdup ("udevadm");
		_tmp1_ = g_strdup ("info");
		_tmp2_ = g_strdup ("--query=all");
		_tmp3_ = g_strdup ("--path");
		_tmp4_ = g_strdup (dev);
		_tmp5_ = g_new0 (gchar*, 5 + 1);
		_tmp5_[0] = _tmp0_;
		_tmp5_[1] = _tmp1_;
		_tmp5_[2] = _tmp2_;
		_tmp5_[3] = _tmp3_;
		_tmp5_[4] = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 5;
		g_spawn_sync (NULL, _tmp6_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp7_, &_tmp8_, &_tmp9_, &_inner_error0_);
		_g_free0 (u_out);
		u_out = _tmp7_;
		_g_free0 (u_err);
		u_err = _tmp8_;
		exitcode = _tmp9_;
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (exitcode != 0) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GError* _tmp13_;
			GError* _tmp14_;
			_tmp10_ = u_err;
			_tmp11_ = g_strdup_printf ("udevadm exited with code %i\n%s", exitcode, _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_inner_error0_ = _tmp14_;
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e->message;
		g_error ("umockdev-record.vala:236: Cannot call udevadm: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (u_err);
		_g_free0 (u_out);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	properties = NULL;
	_tmp16_ = u_out;
	_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp18_;
		line_collection_length1 = _vala_array_length (_tmp17_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp19_;
			gchar* line = NULL;
			_tmp19_ = g_strdup (line_collection[line_it]);
			line = _tmp19_;
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				const gchar* _tmp31_;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gboolean _tmp36_ = FALSE;
				const gchar* _tmp37_;
				const gchar* _tmp41_;
				FILE* _tmp54_;
				const gchar* _tmp55_;
				FILE* _tmp56_;
				_tmp24_ = line;
				_tmp25_ = strlen (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_ == 0) {
					_tmp23_ = TRUE;
				} else {
					const gchar* _tmp27_;
					_tmp27_ = line;
					_tmp23_ = g_str_has_prefix (_tmp27_, "E: DEVPATH=");
				}
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					const gchar* _tmp28_;
					_tmp28_ = line;
					_tmp22_ = g_str_has_prefix (_tmp28_, "E: UDEV_LOG=");
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					const gchar* _tmp29_;
					_tmp29_ = line;
					_tmp21_ = g_str_has_prefix (_tmp29_, "E: USEC_INITIALIZED=");
				}
				if (_tmp21_) {
					_tmp20_ = TRUE;
				} else {
					const gchar* _tmp30_;
					_tmp30_ = line;
					_tmp20_ = g_str_has_prefix (_tmp30_, "L: ");
				}
				if (_tmp20_) {
					_g_free0 (line);
					continue;
				}
				_tmp31_ = line;
				if (g_str_has_prefix (_tmp31_, "E: ")) {
					const gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp32_ = line;
					_tmp33_ = g_strdup (_tmp32_);
					properties = g_list_append (properties, _tmp33_);
					_g_free0 (line);
					continue;
				}
				_tmp37_ = line;
				if (!g_str_has_prefix (_tmp37_, "P:")) {
					const gchar* _tmp38_;
					_tmp38_ = line;
					_tmp36_ = !g_str_has_prefix (_tmp38_, "A:");
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
					const gchar* _tmp39_;
					_tmp39_ = line;
					_tmp35_ = !g_str_has_prefix (_tmp39_, "N:");
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					const gchar* _tmp40_;
					_tmp40_ = line;
					_tmp34_ = !g_str_has_prefix (_tmp40_, "S:");
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					_g_free0 (line);
					continue;
				}
				_tmp41_ = line;
				if (g_str_has_prefix (_tmp41_, "N: ")) {
					gchar* devpath = NULL;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp42_ = line;
					_tmp43_ = string_substring (_tmp42_, (glong) 3, (glong) -1);
					_tmp44_ = _tmp43_;
					_tmp45_ = string_chomp (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = g_strconcat ("/dev/", _tmp46_, NULL);
					_tmp48_ = _tmp47_;
					_g_free0 (_tmp46_);
					_g_free0 (_tmp44_);
					devpath = _tmp48_;
					_tmp49_ = line;
					_tmp50_ = devpath;
					_tmp51_ = dev_contents (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = g_strconcat (_tmp49_, _tmp52_, NULL);
					_g_free0 (line);
					line = _tmp53_;
					_g_free0 (_tmp52_);
					_g_free0 (devpath);
				}
				_tmp54_ = stdout;
				_tmp55_ = line;
				fputs (_tmp55_, _tmp54_);
				_tmp56_ = stdout;
				fputc ('\n', _tmp56_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp57_ = ((GCompareFunc) g_strcmp0);
	properties = g_list_sort (properties, _tmp57_);
	_tmp58_ = properties;
	{
		GList* prop_collection = NULL;
		GList* prop_it = NULL;
		prop_collection = _tmp58_;
		for (prop_it = prop_collection; prop_it != NULL; prop_it = prop_it->next) {
			gchar* _tmp59_;
			gchar* prop = NULL;
			_tmp59_ = g_strdup ((const gchar*) prop_it->data);
			prop = _tmp59_;
			{
				FILE* _tmp60_;
				const gchar* _tmp61_;
				FILE* _tmp62_;
				_tmp60_ = stdout;
				_tmp61_ = prop;
				fputs (_tmp61_, _tmp60_);
				_tmp62_ = stdout;
				fputc ('\n', _tmp62_);
				_g_free0 (prop);
			}
		}
	}
	if (string_contains (dev, "tegra")) {
		FILE* _tmp63_;
		_tmp63_ = stdout;
		fputc ('\n', _tmp63_);
		(properties == NULL) ? NULL : (properties = (_g_list_free__g_free0_ (properties), NULL));
		_g_free0 (u_err);
		_g_free0 (u_out);
		return;
	}
	print_device_attributes (dev, "");
	_tmp64_ = stdout;
	fputc ('\n', _tmp64_);
	(properties == NULL) ? NULL : (properties = (_g_list_free__g_free0_ (properties), NULL));
	_g_free0 (u_err);
	_g_free0 (u_out);
}

void
dump_devices (gchar** devices,
              gint devices_length1)
{
	GHashTable* seen = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	seen = _tmp2_;
	{
		gchar** device_collection = NULL;
		gint device_collection_length1 = 0;
		gint _device_collection_size_ = 0;
		gint device_it = 0;
		device_collection = devices;
		device_collection_length1 = devices_length1;
		for (device_it = 0; device_it < device_collection_length1; device_it = device_it + 1) {
			gchar* _tmp3_;
			gchar* device = NULL;
			_tmp3_ = g_strdup (device_collection[device_it]);
			device = _tmp3_;
			{
				while (TRUE) {
					const gchar* _tmp4_;
					GHashTable* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp4_ = device;
					if (!(_tmp4_ != NULL)) {
						break;
					}
					_tmp5_ = seen;
					_tmp6_ = device;
					if (!g_hash_table_contains (_tmp5_, _tmp6_)) {
						GHashTable* _tmp7_;
						const gchar* _tmp8_;
						gchar* _tmp9_;
						const gchar* _tmp10_;
						_tmp7_ = seen;
						_tmp8_ = device;
						_tmp9_ = g_strdup (_tmp8_);
						g_hash_table_add (_tmp7_, _tmp9_);
						_tmp10_ = device;
						record_device (_tmp10_);
					}
					_tmp11_ = device;
					_tmp12_ = parent (_tmp11_);
					_g_free0 (device);
					device = _tmp12_;
				}
				_g_free0 (device);
			}
		}
	}
	_g_hash_table_unref0 (seen);
}

void
split_devfile_arg (const gchar* arg,
                   gchar** dev,
                   gchar** devnum,
                   gboolean* is_block,
                   gchar** fname)
{
	gchar* _vala_dev = NULL;
	gchar* _vala_devnum = NULL;
	gboolean _vala_is_block = FALSE;
	gchar* _vala_fname = NULL;
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	struct stat st = {0};
	struct stat _tmp6_ = {0};
	gint _tmp7_;
	struct stat _tmp8_;
	gboolean _tmp9_ = FALSE;
	struct stat _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (arg != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (arg, "=", 2);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	if (parts_length1 != 2) {
		g_error ("umockdev-record.vala:312: --ioctl argument must be devname=filename");
	}
	_tmp2_ = parts[0];
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_vala_dev);
	_vala_dev = _tmp3_;
	_tmp4_ = parts[1];
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_vala_fname);
	_vala_fname = _tmp5_;
	_tmp7_ = stat (_vala_dev, &_tmp6_);
	st = _tmp6_;
	if (_tmp7_ != 0) {
		g_error ("umockdev-record.vala:319: Cannot access device %s: %m", _vala_dev);
	}
	_tmp8_ = st;
	_vala_is_block = S_ISBLK (_tmp8_.st_mode);
	_tmp10_ = st;
	if (S_ISCHR (_tmp10_.st_mode)) {
		_tmp9_ = TRUE;
	} else {
		struct stat _tmp11_;
		_tmp11_ = st;
		_tmp9_ = S_ISBLK (_tmp11_.st_mode);
	}
	if (_tmp9_) {
		struct stat _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		struct stat _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp12_ = st;
		_tmp13_ = g_strdup_printf ("%u", major (_tmp12_.st_rdev));
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, ":", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = st;
		_tmp18_ = g_strdup_printf ("%u", minor (_tmp17_.st_rdev));
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
		_g_free0 (_vala_devnum);
		_vala_devnum = _tmp20_;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
	} else {
		struct stat _tmp21_;
		_tmp21_ = st;
		if (S_ISSOCK (_tmp21_.st_mode)) {
			gchar* _tmp22_;
			_tmp22_ = g_strdup (_vala_dev);
			_g_free0 (_vala_devnum);
			_vala_devnum = _tmp22_;
		} else {
			{
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_ = NULL;
				_tmp23_ = g_build_filename (_vala_dev, "dev", NULL);
				_tmp24_ = _tmp23_;
				g_file_get_contents (_tmp24_, &_tmp25_, NULL, &_inner_error0_);
				_g_free0 (_vala_devnum);
				_vala_devnum = _tmp25_;
				_g_free0 (_tmp24_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp26_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp26_ = e->message;
				g_error ("umockdev-record.vala:333: Cannot open %s/dev: %s", _vala_dev, _tmp26_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_vala_dev);
				_g_free0 (_vala_devnum);
				_g_free0 (_vala_fname);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (dev) {
		*dev = _vala_dev;
	} else {
		_g_free0 (_vala_dev);
	}
	if (devnum) {
		*devnum = _vala_devnum;
	} else {
		_g_free0 (_vala_devnum);
	}
	if (is_block) {
		*is_block = _vala_is_block;
	}
	if (fname) {
		*fname = _vala_fname;
	} else {
		_g_free0 (_vala_fname);
	}
}

UMockdevIoctlBase*
record_ioctl (const gchar* root_dir,
              const gchar* arg)
{
	UMockdevIoctlBase* handler = NULL;
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	gboolean is_block = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* sockpath = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	UMockdevIoctlBase* _tmp14_;
	const gchar* _tmp15_;
	UMockdevIoctlBase* result;
	g_return_val_if_fail (root_dir != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	split_devfile_arg (arg, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (dev);
	dev = _tmp0_;
	_g_free0 (devnum);
	devnum = _tmp1_;
	is_block = _tmp2_;
	_g_free0 (outfile);
	outfile = _tmp3_;
	if (!is_block) {
		const gchar* _tmp5_;
		_tmp5_ = devnum;
		_tmp4_ = g_str_has_prefix (_tmp5_, "153:");
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		UMockdevIoctlSpiRecorder* _tmp8_;
		_tmp6_ = dev;
		_tmp7_ = outfile;
		_tmp8_ = umockdev_ioctl_spi_recorder_new (_tmp6_, _tmp7_);
		_g_object_unref0 (handler);
		handler = (UMockdevIoctlBase*) _tmp8_;
	} else {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		UMockdevIoctlTreeRecorder* _tmp11_;
		_tmp9_ = dev;
		_tmp10_ = outfile;
		_tmp11_ = umockdev_ioctl_tree_recorder_new (_tmp9_, _tmp10_);
		_g_object_unref0 (handler);
		handler = (UMockdevIoctlBase*) _tmp11_;
	}
	_tmp12_ = dev;
	_tmp13_ = g_build_filename (root_dir, "ioctl", _tmp12_, NULL);
	sockpath = _tmp13_;
	_tmp14_ = handler;
	_tmp15_ = dev;
	umockdev_ioctl_base_register_path (_tmp14_, NULL, _tmp15_, sockpath);
	result = handler;
	_g_free0 (sockpath);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
	return result;
}

void
record_script (const gchar* arg,
               const gchar* format)
{
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	gboolean is_block = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* c = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	guint _tmp13_;
	g_return_if_fail (arg != NULL);
	g_return_if_fail (format != NULL);
	split_devfile_arg (arg, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (dev);
	dev = _tmp0_;
	_g_free0 (devnum);
	devnum = _tmp1_;
	is_block = _tmp2_;
	_g_free0 (outfile);
	outfile = _tmp3_;
	_tmp4_ = g_strdup_printf ("%u", record_script_counter);
	c = _tmp4_;
	_tmp5_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FILE_", c, NULL);
	_tmp6_ = _tmp5_;
	umockdev_utils_checked_setenv (_tmp6_, outfile);
	_g_free0 (_tmp6_);
	_tmp7_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEV_", c, NULL);
	_tmp8_ = _tmp7_;
	umockdev_utils_checked_setenv (_tmp8_, devnum);
	_g_free0 (_tmp8_);
	_tmp9_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEVICE_PATH_", c, NULL);
	_tmp10_ = _tmp9_;
	umockdev_utils_checked_setenv (_tmp10_, dev);
	_g_free0 (_tmp10_);
	_tmp11_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FORMAT_", c, NULL);
	_tmp12_ = _tmp11_;
	umockdev_utils_checked_setenv (_tmp12_, format);
	_g_free0 (_tmp12_);
	_tmp13_ = record_script_counter;
	record_script_counter = _tmp13_ + 1;
	_g_free0 (c);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
}

void
child_watch_cb (GPid pid,
                gint status)
{
	GMainLoop* _tmp0_;
	child_status = status;
	_tmp0_ = loop;
	g_main_loop_quit (_tmp0_);
}

static void
_child_watch_cb_gchild_watch_func (GPid pid,
                                   gint wait_status,
                                   gpointer self)
{
	child_watch_cb (pid, wait_status);
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	UMockdevIoctlBase* handler = NULL;
	gchar* root_dir = NULL;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	gchar* preload = NULL;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	FILE* _tmp54_;
	FILE* _tmp55_;
	const gchar* _tmp56_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar** _tmp63_;
	gint _tmp63__length1;
	GMainLoop* _tmp66_;
	GMainLoop* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	UMockdevIoctlBase* _tmp77_;
	GError* _inner_error0_ = NULL;
	gint result;
	handler = NULL;
	_tmp0_ = g_option_context_new ("");
	oc = _tmp0_;
	_tmp1_ = oc;
	g_option_context_set_summary (_tmp1_, "Record Linux devices and their ancestors from sysfs/udev, or record io" \
"ctls for a device.");
	_tmp2_ = oc;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	{
		GOptionContext* _tmp3_;
		_tmp3_ = oc;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e->message;
		_tmp5_ = args[0];
		g_error ("umockdev-record.vala:423: Error: %s\n" \
"Run %s --help for how to use this program", _tmp4_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp6_ = -1;
		_g_option_context_free0 (oc);
		_g_free0 (root_dir);
		_g_object_unref0 (handler);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	if (opt_version) {
		FILE* _tmp7_;
		_tmp7_ = stdout;
		fprintf (_tmp7_, "%s\n", VERSION);
		result = 0;
		_g_option_context_free0 (oc);
		_g_free0 (root_dir);
		_g_object_unref0 (handler);
		return result;
	}
	if (opt_all) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = opt_devices;
		_tmp9__length1 = _vala_array_length (opt_devices);
		_tmp8_ = _tmp9__length1 > 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		g_error ("umockdev-record.vala:432: Specifying a device list together with --all" \
" is invalid.");
	}
	if (!opt_all) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp11_ = opt_devices;
		_tmp11__length1 = _vala_array_length (opt_devices);
		_tmp10_ = _tmp11__length1 == 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		g_error ("umockdev-record.vala:434: Need to specify at least one device or --all" \
".");
	}
	_tmp15_ = opt_ioctl;
	if (_tmp15_ != NULL) {
		_tmp14_ = TRUE;
	} else {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = opt_script;
		_tmp16__length1 = _vala_array_length (opt_script);
		_tmp14_ = _tmp16__length1 > 0;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gchar** _tmp17_;
		gint _tmp17__length1;
		_tmp17_ = opt_evemu_events;
		_tmp17__length1 = _vala_array_length (opt_evemu_events);
		_tmp13_ = _tmp17__length1 > 0;
	}
	if (_tmp13_) {
		gboolean _tmp18_ = FALSE;
		if (opt_all) {
			_tmp18_ = TRUE;
		} else {
			gchar** _tmp19_;
			gint _tmp19__length1;
			_tmp19_ = opt_devices;
			_tmp19__length1 = _vala_array_length (opt_devices);
			_tmp18_ = _tmp19__length1 < 1;
		}
		_tmp12_ = _tmp18_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_error ("umockdev-record.vala:437: For recording ioctls or scripts you have to " \
"specify a command to run");
	}
	_tmp22_ = opt_ioctl;
	if (_tmp22_ == NULL) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp23_ = opt_script;
		_tmp23__length1 = _vala_array_length (opt_script);
		_tmp21_ = _tmp23__length1 == 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp24_ = opt_evemu_events;
		_tmp24__length1 = _vala_array_length (opt_evemu_events);
		_tmp20_ = _tmp24__length1 == 0;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gchar** _tmp34_;
		gint _tmp34__length1;
		if (opt_all) {
			gchar** _tmp25_;
			gchar** _tmp26_;
			_tmp26_ = _tmp25_ = all_devices ();
			opt_devices = (_vala_array_free (opt_devices, _vala_array_length (opt_devices), (GDestroyNotify) g_free), NULL);
			opt_devices = _tmp26_;
		} else {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp27_ = FALSE;
					_tmp27_ = TRUE;
					while (TRUE) {
						gchar** _tmp29_;
						gint _tmp29__length1;
						gchar** _tmp30_;
						gint _tmp30__length1;
						gchar** _tmp31_;
						gint _tmp31__length1;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						if (!_tmp27_) {
							gint _tmp28_;
							i = i + 1;
							_tmp28_ = i;
						}
						_tmp27_ = FALSE;
						_tmp29_ = opt_devices;
						_tmp29__length1 = _vala_array_length (opt_devices);
						if (!(i < _tmp29__length1)) {
							break;
						}
						_tmp30_ = opt_devices;
						_tmp30__length1 = _vala_array_length (opt_devices);
						_tmp31_ = opt_devices;
						_tmp31__length1 = _vala_array_length (opt_devices);
						_tmp32_ = _tmp31_[i];
						_tmp33_ = resolve (_tmp32_);
						_g_free0 (_tmp30_[i]);
						_tmp30_[i] = _tmp33_;
					}
				}
			}
		}
		_tmp34_ = opt_devices;
		_tmp34__length1 = _vala_array_length (opt_devices);
		dump_devices (_tmp34_, (gint) _tmp34__length1);
		result = 0;
		_g_option_context_free0 (oc);
		_g_free0 (root_dir);
		_g_object_unref0 (handler);
		return result;
	}
	_tmp35_ = g_getenv ("LD_PRELOAD");
	_tmp36_ = g_strdup (_tmp35_);
	preload = _tmp36_;
	_tmp37_ = preload;
	if (_tmp37_ == NULL) {
		gchar* _tmp38_;
		_tmp38_ = g_strdup ("");
		_g_free0 (preload);
		preload = _tmp38_;
	} else {
		const gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp39_ = preload;
		_tmp40_ = g_strconcat (_tmp39_, ":", NULL);
		_g_free0 (preload);
		preload = _tmp40_;
	}
	_tmp41_ = preload;
	_tmp42_ = g_strconcat (_tmp41_, "libumockdev-preload.so.0", NULL);
	_tmp43_ = _tmp42_;
	umockdev_utils_checked_setenv ("LD_PRELOAD", _tmp43_);
	_g_free0 (_tmp43_);
	{
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		_tmp45_ = g_dir_make_tmp ("umockdev.XXXXXX", &_inner_error0_);
		_tmp44_ = _tmp45_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp46_ = -1;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (preload);
			_g_option_context_free0 (oc);
			_g_free0 (root_dir);
			_g_object_unref0 (handler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp46_;
		}
		_tmp47_ = _tmp44_;
		_tmp44_ = NULL;
		_g_free0 (root_dir);
		root_dir = _tmp47_;
		_tmp48_ = root_dir;
		umockdev_utils_checked_setenv ("UMOCKDEV_DIR", _tmp48_);
		_g_free0 (_tmp44_);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp49_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp49_ = e->message;
		g_error ("umockdev-record.vala:465: Cannot create temporary directory: %s", _tmp49_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp50_ = -1;
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		_g_free0 (root_dir);
		_g_object_unref0 (handler);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp50_;
	}
	_tmp51_ = root_dir;
	_tmp52_ = g_build_filename (_tmp51_, "disabled", NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_fopen (_tmp53_, "w");
	_tmp55_ = _tmp54_;
	_fclose0 (_tmp55_);
	_g_free0 (_tmp53_);
	_tmp56_ = opt_ioctl;
	if (_tmp56_ != NULL) {
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		UMockdevIoctlBase* _tmp59_;
		_tmp57_ = root_dir;
		_tmp58_ = opt_ioctl;
		_tmp59_ = record_ioctl (_tmp57_, _tmp58_);
		_g_object_unref0 (handler);
		handler = _tmp59_;
	}
	_tmp60_ = opt_script;
	_tmp60__length1 = _vala_array_length (opt_script);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp60_;
		s_collection_length1 = _tmp60__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp61_;
			gchar* s = NULL;
			_tmp61_ = g_strdup (s_collection[s_it]);
			s = _tmp61_;
			{
				const gchar* _tmp62_;
				_tmp62_ = s;
				record_script (_tmp62_, "default");
				_g_free0 (s);
			}
		}
	}
	_tmp63_ = opt_evemu_events;
	_tmp63__length1 = _vala_array_length (opt_evemu_events);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp63_;
		s_collection_length1 = _tmp63__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp64_;
			gchar* s = NULL;
			_tmp64_ = g_strdup (s_collection[s_it]);
			s = _tmp64_;
			{
				const gchar* _tmp65_;
				_tmp65_ = s;
				record_script (_tmp65_, "evemu");
				_g_free0 (s);
			}
		}
	}
	_tmp66_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp66_;
	{
		GPid _tmp67_ = 0;
		gchar** _tmp68_;
		gint _tmp68__length1;
		_tmp68_ = opt_devices;
		_tmp68__length1 = _vala_array_length (opt_devices);
		_tmp67_ = umockdev_utils_spawn_process_under_test (_tmp68_, (gint) _tmp68__length1, _child_watch_cb_gchild_watch_func, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		child_pid = _tmp67_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp69_;
		gchar** _tmp70_;
		gint _tmp70__length1;
		const gchar* _tmp71_;
		const gchar* _tmp72_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp69_ = root_dir;
		umockdev_utils_remove_dir (_tmp69_, TRUE);
		_tmp70_ = opt_devices;
		_tmp70__length1 = _vala_array_length (opt_devices);
		_tmp71_ = _tmp70_[0];
		_tmp72_ = e->message;
		g_error ("umockdev-record.vala:486: Cannot run %s: %s", _tmp71_, _tmp72_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp73_ = -1;
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		_g_free0 (root_dir);
		_g_object_unref0 (handler);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp73_;
	}
	_tmp74_ = loop;
	g_main_loop_run (_tmp74_);
	_tmp75_ = root_dir;
	g_debug ("umockdev-record.vala:491: Removing recording directory %s", _tmp75_);
	_tmp76_ = root_dir;
	umockdev_utils_remove_dir (_tmp76_, TRUE);
	g_unsetenv ("UMOCKDEV_DIR");
	g_spawn_close_pid (child_pid);
	_tmp77_ = handler;
	if (_tmp77_ != NULL) {
		UMockdevIoctlBase* _tmp78_;
		_tmp78_ = handler;
		umockdev_ioctl_base_unregister_all (_tmp78_);
	}
	while (TRUE) {
		GMainContext* _tmp79_;
		_tmp79_ = g_main_context_default ();
		if (!g_main_context_iteration (_tmp79_, FALSE)) {
			break;
		}
	}
	if (WIFEXITED (child_status)) {
		result = WEXITSTATUS (child_status);
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		_g_free0 (root_dir);
		_g_object_unref0 (handler);
		return result;
	}
	if (WIFSIGNALED (child_status)) {
		raise (WTERMSIG (child_status));
	}
	result = child_status;
	_g_free0 (preload);
	_g_option_context_free0 (oc);
	_g_free0 (root_dir);
	_g_object_unref0 (handler);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

