//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICE_API_EXPORTS
#   define ICE_API_EXPORTS
#endif
#include <Ice/Locator.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit<::Ice::AdapterNotFoundException> iceC_Ice_AdapterNotFoundException_init("::Ice::AdapterNotFoundException");

const ::IceInternal::DefaultUserExceptionFactoryInit<::Ice::InvalidReplicaGroupIdException> iceC_Ice_InvalidReplicaGroupIdException_init("::Ice::InvalidReplicaGroupIdException");

const ::IceInternal::DefaultUserExceptionFactoryInit<::Ice::AdapterAlreadyActiveException> iceC_Ice_AdapterAlreadyActiveException_init("::Ice::AdapterAlreadyActiveException");

const ::IceInternal::DefaultUserExceptionFactoryInit<::Ice::ObjectNotFoundException> iceC_Ice_ObjectNotFoundException_init("::Ice::ObjectNotFoundException");

const ::IceInternal::DefaultUserExceptionFactoryInit<::Ice::ServerNotFoundException> iceC_Ice_ServerNotFoundException_init("::Ice::ServerNotFoundException");

const ::std::string iceC_Ice_Locator_ids[2] =
{
    "::Ice::Locator",
    "::Ice::Object"
};
const ::std::string iceC_Ice_Locator_ops[] =
{
    "findAdapterById",
    "findObjectById",
    "getRegistry",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_Ice_Locator_findObjectById_name = "findObjectById";
const ::std::string iceC_Ice_Locator_findAdapterById_name = "findAdapterById";
const ::std::string iceC_Ice_Locator_getRegistry_name = "getRegistry";

const ::std::string iceC_Ice_LocatorRegistry_ids[2] =
{
    "::Ice::LocatorRegistry",
    "::Ice::Object"
};
const ::std::string iceC_Ice_LocatorRegistry_ops[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "setAdapterDirectProxy",
    "setReplicatedAdapterDirectProxy",
    "setServerProcessProxy"
};
const ::std::string iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name = "setAdapterDirectProxy";
const ::std::string iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name = "setReplicatedAdapterDirectProxy";
const ::std::string iceC_Ice_LocatorRegistry_setServerProcessProxy_name = "setServerProcessProxy";

const ::std::string iceC_Ice_LocatorFinder_ids[2] =
{
    "::Ice::LocatorFinder",
    "::Ice::Object"
};
const ::std::string iceC_Ice_LocatorFinder_ops[] =
{
    "getLocator",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_Ice_LocatorFinder_getLocator_name = "getLocator";

}

Ice::AdapterNotFoundException::~AdapterNotFoundException()
{
}

const ::std::string&
Ice::AdapterNotFoundException::ice_staticId()
{
    static const ::std::string typeId = "::Ice::AdapterNotFoundException";
    return typeId;
}

Ice::InvalidReplicaGroupIdException::~InvalidReplicaGroupIdException()
{
}

const ::std::string&
Ice::InvalidReplicaGroupIdException::ice_staticId()
{
    static const ::std::string typeId = "::Ice::InvalidReplicaGroupIdException";
    return typeId;
}

Ice::AdapterAlreadyActiveException::~AdapterAlreadyActiveException()
{
}

const ::std::string&
Ice::AdapterAlreadyActiveException::ice_staticId()
{
    static const ::std::string typeId = "::Ice::AdapterAlreadyActiveException";
    return typeId;
}

Ice::ObjectNotFoundException::~ObjectNotFoundException()
{
}

const ::std::string&
Ice::ObjectNotFoundException::ice_staticId()
{
    static const ::std::string typeId = "::Ice::ObjectNotFoundException";
    return typeId;
}

Ice::ServerNotFoundException::~ServerNotFoundException()
{
}

const ::std::string&
Ice::ServerNotFoundException::ice_staticId()
{
    static const ::std::string typeId = "::Ice::ServerNotFoundException";
    return typeId;
}

bool
Ice::Locator::ice_isA(::std::string s, const Current&) const
{
    return ::std::binary_search(iceC_Ice_Locator_ids, iceC_Ice_Locator_ids + 2, s);
}

::std::vector<::std::string>
Ice::Locator::ice_ids(const Current&) const
{
    return ::std::vector<::std::string>(&iceC_Ice_Locator_ids[0], &iceC_Ice_Locator_ids[2]);
}

::std::string
Ice::Locator::ice_id(const Current&) const
{
    return ice_staticId();
}

const ::std::string&
Ice::Locator::ice_staticId()
{
    static const ::std::string typeId = "::Ice::Locator";
    return typeId;
}

/// \cond INTERNAL
bool
Ice::Locator::_iceD_findObjectById(::IceInternal::Incoming& inS, const Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    Identity iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::shared_ptr<ObjectPrx>& ret)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->findObjectByIdAsync(::std::move(iceP_id), responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::Locator::_iceD_findAdapterById(::IceInternal::Incoming& inS, const Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::shared_ptr<ObjectPrx>& ret)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->findAdapterByIdAsync(::std::move(iceP_id), responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::Locator::_iceD_getRegistry(::IceInternal::Incoming& inS, const Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<LocatorRegistryPrx> ret = this->getRegistry(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::Locator::_iceDispatch(::IceInternal::Incoming& in, const Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Ice_Locator_ops, iceC_Ice_Locator_ops + 7, current.operation);
    if(r.first == r.second)
    {
        throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Ice_Locator_ops)
    {
        case 0:
        {
            return _iceD_findAdapterById(in, current);
        }
        case 1:
        {
            return _iceD_findObjectById(in, current);
        }
        case 2:
        {
            return _iceD_getRegistry(in, current);
        }
        case 3:
        {
            return _iceD_ice_id(in, current);
        }
        case 4:
        {
            return _iceD_ice_ids(in, current);
        }
        case 5:
        {
            return _iceD_ice_isA(in, current);
        }
        case 6:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Ice::LocatorRegistry::ice_isA(::std::string s, const Current&) const
{
    return ::std::binary_search(iceC_Ice_LocatorRegistry_ids, iceC_Ice_LocatorRegistry_ids + 2, s);
}

::std::vector<::std::string>
Ice::LocatorRegistry::ice_ids(const Current&) const
{
    return ::std::vector<::std::string>(&iceC_Ice_LocatorRegistry_ids[0], &iceC_Ice_LocatorRegistry_ids[2]);
}

::std::string
Ice::LocatorRegistry::ice_id(const Current&) const
{
    return ice_staticId();
}

const ::std::string&
Ice::LocatorRegistry::ice_staticId()
{
    static const ::std::string typeId = "::Ice::LocatorRegistry";
    return typeId;
}

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceD_setAdapterDirectProxy(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    ::std::shared_ptr<ObjectPrx> iceP_proxy;
    istr->readAll(iceP_id, iceP_proxy);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->setAdapterDirectProxyAsync(::std::move(iceP_id), ::std::move(iceP_proxy), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceD_setReplicatedAdapterDirectProxy(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_adapterId;
    ::std::string iceP_replicaGroupId;
    ::std::shared_ptr<ObjectPrx> iceP_p;
    istr->readAll(iceP_adapterId, iceP_replicaGroupId, iceP_p);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->setReplicatedAdapterDirectProxyAsync(::std::move(iceP_adapterId), ::std::move(iceP_replicaGroupId), ::std::move(iceP_p), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceD_setServerProcessProxy(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    ::std::shared_ptr<ProcessPrx> iceP_proxy;
    istr->readAll(iceP_id, iceP_proxy);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->setServerProcessProxyAsync(::std::move(iceP_id), ::std::move(iceP_proxy), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceDispatch(::IceInternal::Incoming& in, const Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Ice_LocatorRegistry_ops, iceC_Ice_LocatorRegistry_ops + 7, current.operation);
    if(r.first == r.second)
    {
        throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Ice_LocatorRegistry_ops)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_setAdapterDirectProxy(in, current);
        }
        case 5:
        {
            return _iceD_setReplicatedAdapterDirectProxy(in, current);
        }
        case 6:
        {
            return _iceD_setServerProcessProxy(in, current);
        }
        default:
        {
            assert(false);
            throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Ice::LocatorFinder::ice_isA(::std::string s, const Current&) const
{
    return ::std::binary_search(iceC_Ice_LocatorFinder_ids, iceC_Ice_LocatorFinder_ids + 2, s);
}

::std::vector<::std::string>
Ice::LocatorFinder::ice_ids(const Current&) const
{
    return ::std::vector<::std::string>(&iceC_Ice_LocatorFinder_ids[0], &iceC_Ice_LocatorFinder_ids[2]);
}

::std::string
Ice::LocatorFinder::ice_id(const Current&) const
{
    return ice_staticId();
}

const ::std::string&
Ice::LocatorFinder::ice_staticId()
{
    static const ::std::string typeId = "::Ice::LocatorFinder";
    return typeId;
}

/// \cond INTERNAL
bool
Ice::LocatorFinder::_iceD_getLocator(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<LocatorPrx> ret = this->getLocator(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::LocatorFinder::_iceDispatch(::IceInternal::Incoming& in, const Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Ice_LocatorFinder_ops, iceC_Ice_LocatorFinder_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Ice_LocatorFinder_ops)
    {
        case 0:
        {
            return _iceD_getLocator(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
Ice::LocatorPrx::_iceI_findObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const Identity& iceP_id, const Context& context)
{
    _checkTwowayOnly(iceC_Ice_Locator_findObjectById_name);
    outAsync->invoke(iceC_Ice_Locator_findObjectById_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ObjectNotFoundException&)
            {
                throw;
            }
            catch(const UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Ice::LocatorPrx::_iceI_findAdapterById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::std::string& iceP_id, const Context& context)
{
    _checkTwowayOnly(iceC_Ice_Locator_findAdapterById_name);
    outAsync->invoke(iceC_Ice_Locator_findAdapterById_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterNotFoundException&)
            {
                throw;
            }
            catch(const UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Ice::LocatorPrx::_iceI_getRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::LocatorRegistryPrx>>>& outAsync, const Context& context)
{
    _checkTwowayOnly(iceC_Ice_Locator_getRegistry_name);
    outAsync->invoke(iceC_Ice_Locator_getRegistry_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Ice::LocatorPrx::_newInstance() const
{
    return ::IceInternal::createProxy<LocatorPrx>();
}
/// \endcond

const ::std::string&
Ice::LocatorPrx::ice_staticId()
{
    return Locator::ice_staticId();
}

/// \cond INTERNAL
void
Ice::LocatorRegistryPrx::_iceI_setAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, const ::std::shared_ptr<ObjectPrx>& iceP_proxy, const Context& context)
{
    _checkTwowayOnly(iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name);
    outAsync->invoke(iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_proxy);
        },
        [](const UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterAlreadyActiveException&)
            {
                throw;
            }
            catch(const AdapterNotFoundException&)
            {
                throw;
            }
            catch(const UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Ice::LocatorRegistryPrx::_iceI_setReplicatedAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::std::shared_ptr<ObjectPrx>& iceP_p, const Context& context)
{
    _checkTwowayOnly(iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name);
    outAsync->invoke(iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](OutputStream* ostr)
        {
            ostr->writeAll(iceP_adapterId, iceP_replicaGroupId, iceP_p);
        },
        [](const UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterAlreadyActiveException&)
            {
                throw;
            }
            catch(const AdapterNotFoundException&)
            {
                throw;
            }
            catch(const InvalidReplicaGroupIdException&)
            {
                throw;
            }
            catch(const UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
Ice::LocatorRegistryPrx::_iceI_setServerProcessProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, const ::std::shared_ptr<ProcessPrx>& iceP_proxy, const Context& context)
{
    _checkTwowayOnly(iceC_Ice_LocatorRegistry_setServerProcessProxy_name);
    outAsync->invoke(iceC_Ice_LocatorRegistry_setServerProcessProxy_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_proxy);
        },
        [](const UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ServerNotFoundException&)
            {
                throw;
            }
            catch(const UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Ice::LocatorRegistryPrx::_newInstance() const
{
    return ::IceInternal::createProxy<LocatorRegistryPrx>();
}
/// \endcond

const ::std::string&
Ice::LocatorRegistryPrx::ice_staticId()
{
    return LocatorRegistry::ice_staticId();
}

/// \cond INTERNAL
void
Ice::LocatorFinderPrx::_iceI_getLocator(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::LocatorPrx>>>& outAsync, const Context& context)
{
    _checkTwowayOnly(iceC_Ice_LocatorFinder_getLocator_name);
    outAsync->invoke(iceC_Ice_LocatorFinder_getLocator_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Ice::LocatorFinderPrx::_newInstance() const
{
    return ::IceInternal::createProxy<LocatorFinderPrx>();
}
/// \endcond

const ::std::string&
Ice::LocatorFinderPrx::ice_staticId()
{
    return LocatorFinder::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_Ice_Locator_findObjectById_name = "findObjectById";

const ::std::string iceC_Ice_Locator_findAdapterById_name = "findAdapterById";

const ::std::string iceC_Ice_Locator_getRegistry_name = "getRegistry";

const ::std::string iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name = "setAdapterDirectProxy";

const ::std::string iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name = "setReplicatedAdapterDirectProxy";

const ::std::string iceC_Ice_LocatorRegistry_setServerProcessProxy_name = "setServerProcessProxy";

const ::std::string iceC_Ice_LocatorFinder_getLocator_name = "getLocator";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::AdapterNotFoundException> iceC_Ice_AdapterNotFoundException_init("::Ice::AdapterNotFoundException");

}

#ifdef ICE_CPP11_COMPILER
Ice::AdapterNotFoundException::~AdapterNotFoundException()
{
}
#else
Ice::AdapterNotFoundException::~AdapterNotFoundException() throw()
{
}
#endif

::std::string
Ice::AdapterNotFoundException::ice_id() const
{
    return "::Ice::AdapterNotFoundException";
}

Ice::AdapterNotFoundException*
Ice::AdapterNotFoundException::ice_clone() const
{
    return new AdapterNotFoundException(*this);
}

void
Ice::AdapterNotFoundException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
Ice::AdapterNotFoundException::_writeImpl(OutputStream* ostr) const
{
    ostr->startSlice("::Ice::AdapterNotFoundException", -1, true);
    StreamWriter< AdapterNotFoundException, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::AdapterNotFoundException::_readImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< AdapterNotFoundException, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::InvalidReplicaGroupIdException> iceC_Ice_InvalidReplicaGroupIdException_init("::Ice::InvalidReplicaGroupIdException");

}

#ifdef ICE_CPP11_COMPILER
Ice::InvalidReplicaGroupIdException::~InvalidReplicaGroupIdException()
{
}
#else
Ice::InvalidReplicaGroupIdException::~InvalidReplicaGroupIdException() throw()
{
}
#endif

::std::string
Ice::InvalidReplicaGroupIdException::ice_id() const
{
    return "::Ice::InvalidReplicaGroupIdException";
}

Ice::InvalidReplicaGroupIdException*
Ice::InvalidReplicaGroupIdException::ice_clone() const
{
    return new InvalidReplicaGroupIdException(*this);
}

void
Ice::InvalidReplicaGroupIdException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
Ice::InvalidReplicaGroupIdException::_writeImpl(OutputStream* ostr) const
{
    ostr->startSlice("::Ice::InvalidReplicaGroupIdException", -1, true);
    StreamWriter< InvalidReplicaGroupIdException, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::InvalidReplicaGroupIdException::_readImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< InvalidReplicaGroupIdException, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::AdapterAlreadyActiveException> iceC_Ice_AdapterAlreadyActiveException_init("::Ice::AdapterAlreadyActiveException");

}

#ifdef ICE_CPP11_COMPILER
Ice::AdapterAlreadyActiveException::~AdapterAlreadyActiveException()
{
}
#else
Ice::AdapterAlreadyActiveException::~AdapterAlreadyActiveException() throw()
{
}
#endif

::std::string
Ice::AdapterAlreadyActiveException::ice_id() const
{
    return "::Ice::AdapterAlreadyActiveException";
}

Ice::AdapterAlreadyActiveException*
Ice::AdapterAlreadyActiveException::ice_clone() const
{
    return new AdapterAlreadyActiveException(*this);
}

void
Ice::AdapterAlreadyActiveException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
Ice::AdapterAlreadyActiveException::_writeImpl(OutputStream* ostr) const
{
    ostr->startSlice("::Ice::AdapterAlreadyActiveException", -1, true);
    StreamWriter< AdapterAlreadyActiveException, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::AdapterAlreadyActiveException::_readImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< AdapterAlreadyActiveException, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::ObjectNotFoundException> iceC_Ice_ObjectNotFoundException_init("::Ice::ObjectNotFoundException");

}

#ifdef ICE_CPP11_COMPILER
Ice::ObjectNotFoundException::~ObjectNotFoundException()
{
}
#else
Ice::ObjectNotFoundException::~ObjectNotFoundException() throw()
{
}
#endif

::std::string
Ice::ObjectNotFoundException::ice_id() const
{
    return "::Ice::ObjectNotFoundException";
}

Ice::ObjectNotFoundException*
Ice::ObjectNotFoundException::ice_clone() const
{
    return new ObjectNotFoundException(*this);
}

void
Ice::ObjectNotFoundException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
Ice::ObjectNotFoundException::_writeImpl(OutputStream* ostr) const
{
    ostr->startSlice("::Ice::ObjectNotFoundException", -1, true);
    StreamWriter< ObjectNotFoundException, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::ObjectNotFoundException::_readImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< ObjectNotFoundException, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::ServerNotFoundException> iceC_Ice_ServerNotFoundException_init("::Ice::ServerNotFoundException");

}

#ifdef ICE_CPP11_COMPILER
Ice::ServerNotFoundException::~ServerNotFoundException()
{
}
#else
Ice::ServerNotFoundException::~ServerNotFoundException() throw()
{
}
#endif

::std::string
Ice::ServerNotFoundException::ice_id() const
{
    return "::Ice::ServerNotFoundException";
}

Ice::ServerNotFoundException*
Ice::ServerNotFoundException::ice_clone() const
{
    return new ServerNotFoundException(*this);
}

void
Ice::ServerNotFoundException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
Ice::ServerNotFoundException::_writeImpl(OutputStream* ostr) const
{
    ostr->startSlice("::Ice::ServerNotFoundException", -1, true);
    StreamWriter< ServerNotFoundException, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::ServerNotFoundException::_readImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< ServerNotFoundException, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

Ice::AMD_Locator_findObjectById::~AMD_Locator_findObjectById()
{
}

Ice::AMD_Locator_findAdapterById::~AMD_Locator_findAdapterById()
{
}

Ice::AMD_LocatorRegistry_setAdapterDirectProxy::~AMD_LocatorRegistry_setAdapterDirectProxy()
{
}

Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy::~AMD_LocatorRegistry_setReplicatedAdapterDirectProxy()
{
}

Ice::AMD_LocatorRegistry_setServerProcessProxy::~AMD_LocatorRegistry_setServerProcessProxy()
{
}

/// \cond INTERNAL
IceAsync::Ice::AMD_Locator_findObjectById::AMD_Locator_findObjectById(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_Locator_findObjectById::ice_response(const ::Ice::ObjectPrx& ret)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::Ice::AMD_Locator_findAdapterById::AMD_Locator_findAdapterById(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_Locator_findAdapterById::ice_response(const ::Ice::ObjectPrx& ret)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::Ice::AMD_LocatorRegistry_setAdapterDirectProxy::AMD_LocatorRegistry_setAdapterDirectProxy(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_LocatorRegistry_setAdapterDirectProxy::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::Ice::AMD_LocatorRegistry_setServerProcessProxy::AMD_LocatorRegistry_setServerProcessProxy(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_LocatorRegistry_setServerProcessProxy::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(Locator* p) { return p; }

void
::IceProxy::Ice::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Locator>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Locator;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::_iceI_begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Ice_Locator_findObjectById_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Ice_Locator_findObjectById_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Ice_Locator_findObjectById_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_Ice_Locator_findObjectById_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::Ice::Locator::end_findObjectById(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Ice_Locator_findObjectById_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::ObjectNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::_iceI_begin_findAdapterById(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Ice_Locator_findAdapterById_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Ice_Locator_findAdapterById_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Ice_Locator_findAdapterById_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_Ice_Locator_findAdapterById_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::Ice::Locator::end_findAdapterById(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Ice_Locator_findAdapterById_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::_iceI_begin_getRegistry(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Ice_Locator_getRegistry_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Ice_Locator_getRegistry_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Ice_Locator_getRegistry_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_Ice_Locator_getRegistry_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::LocatorRegistryPrx
IceProxy::Ice::Locator::end_getRegistry(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Ice_Locator_getRegistry_name);
    ::Ice::LocatorRegistryPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Ice::Locator::_newInstance() const
{
    return new Locator;
}
/// \endcond

const ::std::string&
IceProxy::Ice::Locator::ice_staticId()
{
    return ::Ice::Locator::ice_staticId();
}

/// \cond INTERNAL
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(LocatorRegistry* p) { return p; }

void
::IceProxy::Ice::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< LocatorRegistry>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new LocatorRegistry;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::_iceI_begin_setAdapterDirectProxy(const ::std::string& iceP_id, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_proxy);
        result->endWriteParams();
        result->invoke(iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Ice::LocatorRegistry::end_setAdapterDirectProxy(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Ice_LocatorRegistry_setAdapterDirectProxy_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::AdapterAlreadyActiveException&)
        {
            throw;
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::_iceI_begin_setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_p, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_adapterId);
        ostr->write(iceP_replicaGroupId);
        ostr->write(iceP_p);
        result->endWriteParams();
        result->invoke(iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Ice::LocatorRegistry::end_setReplicatedAdapterDirectProxy(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Ice_LocatorRegistry_setReplicatedAdapterDirectProxy_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::AdapterAlreadyActiveException&)
        {
            throw;
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::InvalidReplicaGroupIdException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::_iceI_begin_setServerProcessProxy(const ::std::string& iceP_id, const ::Ice::ProcessPrx& iceP_proxy, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Ice_LocatorRegistry_setServerProcessProxy_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Ice_LocatorRegistry_setServerProcessProxy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Ice_LocatorRegistry_setServerProcessProxy_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_proxy);
        result->endWriteParams();
        result->invoke(iceC_Ice_LocatorRegistry_setServerProcessProxy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Ice::LocatorRegistry::end_setServerProcessProxy(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Ice_LocatorRegistry_setServerProcessProxy_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::ServerNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Ice::LocatorRegistry::_newInstance() const
{
    return new LocatorRegistry;
}
/// \endcond

const ::std::string&
IceProxy::Ice::LocatorRegistry::ice_staticId()
{
    return ::Ice::LocatorRegistry::ice_staticId();
}

/// \cond INTERNAL
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(LocatorFinder* p) { return p; }

void
::IceProxy::Ice::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< LocatorFinder>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new LocatorFinder;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorFinder::_iceI_begin_getLocator(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Ice_LocatorFinder_getLocator_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Ice_LocatorFinder_getLocator_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Ice_LocatorFinder_getLocator_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Ice_LocatorFinder_getLocator_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::LocatorPrx
IceProxy::Ice::LocatorFinder::end_getLocator(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Ice_LocatorFinder_getLocator_name);
    ::Ice::LocatorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Ice::LocatorFinder::_newInstance() const
{
    return new LocatorFinder;
}
/// \endcond

const ::std::string&
IceProxy::Ice::LocatorFinder::ice_staticId()
{
    return ::Ice::LocatorFinder::ice_staticId();
}

Ice::Locator::~Locator()
{
}

/// \cond INTERNAL
ICE_API ::Ice::Object* Ice::upCast(Locator* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Ice_Locator_ids[2] =
{
    "::Ice::Locator",
    "::Ice::Object"
};

}

bool
Ice::Locator::ice_isA(const ::std::string& s, const Current&) const
{
    return ::std::binary_search(iceC_Ice_Locator_ids, iceC_Ice_Locator_ids + 2, s);
}

::std::vector< ::std::string>
Ice::Locator::ice_ids(const Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Ice_Locator_ids[0], &iceC_Ice_Locator_ids[2]);
}

const ::std::string&
Ice::Locator::ice_id(const Current&) const
{
    return ice_staticId();
}

const ::std::string&
Ice::Locator::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::Locator";
    return typeId;
#else
    return iceC_Ice_Locator_ids[0];
#endif
}

/// \cond INTERNAL
bool
Ice::Locator::_iceD_findObjectById(::IceInternal::Incoming& inS, const Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    InputStream* istr = inS.startReadParams();
    Identity iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->findObjectById_async(new IceAsync::Ice::AMD_Locator_findObjectById(inS), iceP_id, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::Locator::_iceD_findAdapterById(::IceInternal::Incoming& inS, const Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->findAdapterById_async(new IceAsync::Ice::AMD_Locator_findAdapterById(inS), iceP_id, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::Locator::_iceD_getRegistry(::IceInternal::Incoming& inS, const Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    LocatorRegistryPrx ret = this->getRegistry(current);
    OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Ice_Locator_all[] =
{
    "findAdapterById",
    "findObjectById",
    "getRegistry",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
Ice::Locator::_iceDispatch(::IceInternal::Incoming& in, const Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Ice_Locator_all, iceC_Ice_Locator_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Ice_Locator_all)
    {
        case 0:
        {
            return _iceD_findAdapterById(in, current);
        }
        case 1:
        {
            return _iceD_findObjectById(in, current);
        }
        case 2:
        {
            return _iceD_getRegistry(in, current);
        }
        case 3:
        {
            return _iceD_ice_id(in, current);
        }
        case 4:
        {
            return _iceD_ice_ids(in, current);
        }
        case 5:
        {
            return _iceD_ice_isA(in, current);
        }
        case 6:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Ice::Locator::_iceWriteImpl(OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    StreamWriter< Locator, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::Locator::_iceReadImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< Locator, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Ice::_icePatchObjectPtr(LocatorPtr& handle, const ObjectPtr& v)
{
    handle = LocatorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Locator::ice_staticId(), v);
    }
}
/// \endcond

Ice::LocatorRegistry::~LocatorRegistry()
{
}

/// \cond INTERNAL
ICE_API ::Ice::Object* Ice::upCast(LocatorRegistry* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Ice_LocatorRegistry_ids[2] =
{
    "::Ice::LocatorRegistry",
    "::Ice::Object"
};

}

bool
Ice::LocatorRegistry::ice_isA(const ::std::string& s, const Current&) const
{
    return ::std::binary_search(iceC_Ice_LocatorRegistry_ids, iceC_Ice_LocatorRegistry_ids + 2, s);
}

::std::vector< ::std::string>
Ice::LocatorRegistry::ice_ids(const Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Ice_LocatorRegistry_ids[0], &iceC_Ice_LocatorRegistry_ids[2]);
}

const ::std::string&
Ice::LocatorRegistry::ice_id(const Current&) const
{
    return ice_staticId();
}

const ::std::string&
Ice::LocatorRegistry::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::LocatorRegistry";
    return typeId;
#else
    return iceC_Ice_LocatorRegistry_ids[0];
#endif
}

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceD_setAdapterDirectProxy(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    ObjectPrx iceP_proxy;
    istr->read(iceP_id);
    istr->read(iceP_proxy);
    inS.endReadParams();
    this->setAdapterDirectProxy_async(new IceAsync::Ice::AMD_LocatorRegistry_setAdapterDirectProxy(inS), iceP_id, iceP_proxy, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceD_setReplicatedAdapterDirectProxy(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    InputStream* istr = inS.startReadParams();
    ::std::string iceP_adapterId;
    ::std::string iceP_replicaGroupId;
    ObjectPrx iceP_p;
    istr->read(iceP_adapterId);
    istr->read(iceP_replicaGroupId);
    istr->read(iceP_p);
    inS.endReadParams();
    this->setReplicatedAdapterDirectProxy_async(new IceAsync::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy(inS), iceP_adapterId, iceP_replicaGroupId, iceP_p, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceD_setServerProcessProxy(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    ProcessPrx iceP_proxy;
    istr->read(iceP_id);
    istr->read(iceP_proxy);
    inS.endReadParams();
    this->setServerProcessProxy_async(new IceAsync::Ice::AMD_LocatorRegistry_setServerProcessProxy(inS), iceP_id, iceP_proxy, current);
    return false;
}
/// \endcond

namespace
{
const ::std::string iceC_Ice_LocatorRegistry_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "setAdapterDirectProxy",
    "setReplicatedAdapterDirectProxy",
    "setServerProcessProxy"
};

}

/// \cond INTERNAL
bool
Ice::LocatorRegistry::_iceDispatch(::IceInternal::Incoming& in, const Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Ice_LocatorRegistry_all, iceC_Ice_LocatorRegistry_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Ice_LocatorRegistry_all)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_setAdapterDirectProxy(in, current);
        }
        case 5:
        {
            return _iceD_setReplicatedAdapterDirectProxy(in, current);
        }
        case 6:
        {
            return _iceD_setServerProcessProxy(in, current);
        }
        default:
        {
            assert(false);
            throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Ice::LocatorRegistry::_iceWriteImpl(OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    StreamWriter< LocatorRegistry, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::LocatorRegistry::_iceReadImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< LocatorRegistry, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Ice::_icePatchObjectPtr(LocatorRegistryPtr& handle, const ObjectPtr& v)
{
    handle = LocatorRegistryPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(LocatorRegistry::ice_staticId(), v);
    }
}
/// \endcond

Ice::LocatorFinder::~LocatorFinder()
{
}

/// \cond INTERNAL
ICE_API ::Ice::Object* Ice::upCast(LocatorFinder* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Ice_LocatorFinder_ids[2] =
{
    "::Ice::LocatorFinder",
    "::Ice::Object"
};

}

bool
Ice::LocatorFinder::ice_isA(const ::std::string& s, const Current&) const
{
    return ::std::binary_search(iceC_Ice_LocatorFinder_ids, iceC_Ice_LocatorFinder_ids + 2, s);
}

::std::vector< ::std::string>
Ice::LocatorFinder::ice_ids(const Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Ice_LocatorFinder_ids[0], &iceC_Ice_LocatorFinder_ids[2]);
}

const ::std::string&
Ice::LocatorFinder::ice_id(const Current&) const
{
    return ice_staticId();
}

const ::std::string&
Ice::LocatorFinder::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::LocatorFinder";
    return typeId;
#else
    return iceC_Ice_LocatorFinder_ids[0];
#endif
}

/// \cond INTERNAL
bool
Ice::LocatorFinder::_iceD_getLocator(::IceInternal::Incoming& inS, const Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    LocatorPrx ret = this->getLocator(current);
    OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Ice_LocatorFinder_all[] =
{
    "getLocator",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
Ice::LocatorFinder::_iceDispatch(::IceInternal::Incoming& in, const Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Ice_LocatorFinder_all, iceC_Ice_LocatorFinder_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Ice_LocatorFinder_all)
    {
        case 0:
        {
            return _iceD_getLocator(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Ice::LocatorFinder::_iceWriteImpl(OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    StreamWriter< LocatorFinder, OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Ice::LocatorFinder::_iceReadImpl(InputStream* istr)
{
    istr->startSlice();
    StreamReader< LocatorFinder, InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Ice::_icePatchObjectPtr(LocatorFinderPtr& handle, const ObjectPtr& v)
{
    handle = LocatorFinderPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(LocatorFinder::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
