/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Keyword;
import org.jooq.OrderField;
import org.jooq.SQLDialect;
import org.jooq.WindowSpecificationFinalStep;
import org.jooq.WindowSpecificationOrderByStep;
import org.jooq.WindowSpecificationPartitionByStep;
import org.jooq.WindowSpecificationRowsAndStep;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Tools;

final class WindowSpecificationImpl
extends AbstractQueryPart
implements WindowSpecificationPartitionByStep,
WindowSpecificationRowsAndStep {
    private static final long serialVersionUID = 2996016924769376361L;
    private final QueryPartList<Field<?>> partitionBy = new QueryPartList();
    private final SortFieldList orderBy = new SortFieldList();
    private Integer frameStart;
    private Integer frameEnd;
    private FrameUnits frameUnits;
    private boolean partitionByOne;

    WindowSpecificationImpl() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        String glue = "";
        if (!(this.partitionBy.isEmpty() || this.partitionByOne && Arrays.asList(SQLDialect.CUBRID, SQLDialect.MYSQL).contains((Object)ctx.family()))) {
            ctx.sql(glue).visit(Keywords.K_PARTITION_BY).sql(' ').visit(this.partitionBy);
            glue = " ";
        }
        if (!this.orderBy.isEmpty()) {
            ctx.sql(glue).visit(Keywords.K_ORDER_BY).sql(' ').visit(this.orderBy);
            glue = " ";
        }
        if (this.frameStart != null) {
            ctx.sql(glue);
            ctx.visit(this.frameUnits.keyword).sql(' ');
            if (this.frameEnd != null) {
                ctx.visit(Keywords.K_BETWEEN).sql(' ');
                this.toSQLRows(ctx, this.frameStart);
                ctx.sql(' ').visit(Keywords.K_AND).sql(' ');
                this.toSQLRows(ctx, this.frameEnd);
            } else {
                this.toSQLRows(ctx, this.frameStart);
            }
            glue = " ";
        }
    }

    private final void toSQLRows(Context<?> ctx, Integer rows) {
        if (rows == Integer.MIN_VALUE) {
            ctx.visit(Keywords.K_UNBOUNDED_PRECEDING);
        } else if (rows == Integer.MAX_VALUE) {
            ctx.visit(Keywords.K_UNBOUNDED_FOLLOWING);
        } else if (rows < 0) {
            ctx.sql(-rows.intValue()).sql(' ').visit(Keywords.K_PRECEDING);
        } else if (rows > 0) {
            ctx.sql(rows).sql(' ').visit(Keywords.K_FOLLOWING);
        } else {
            ctx.visit(Keywords.K_CURRENT_ROW);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(Field<?> ... fields) {
        return this.partitionBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(Collection<? extends Field<?>> fields) {
        this.partitionBy.addAll((Collection<Field<?>>)fields);
        return this;
    }

    @Override
    @Deprecated
    public final WindowSpecificationOrderByStep partitionByOne() {
        this.partitionByOne = true;
        this.partitionBy.add((Field<?>)DSL.one());
        return null;
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(OrderField<?> ... fields) {
        return this.orderBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(Collection<? extends OrderField<?>> fields) {
        this.orderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsUnboundedPreceding() {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsPreceding(int number) {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsCurrentRow() {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsUnboundedFollowing() {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rowsFollowing(int number) {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedPreceding() {
        this.rowsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenPreceding(int number) {
        this.rowsPreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenCurrentRow() {
        this.rowsCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedFollowing() {
        this.rowsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenFollowing(int number) {
        this.rowsFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rangeUnboundedPreceding() {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rangePreceding(int number) {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rangeCurrentRow() {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rangeUnboundedFollowing() {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep rangeFollowing(int number) {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenUnboundedPreceding() {
        this.rangeUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenPreceding(int number) {
        this.rangePreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenCurrentRow() {
        this.rangeCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenUnboundedFollowing() {
        this.rangeUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenFollowing(int number) {
        this.rangeFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andUnboundedPreceding() {
        this.frameEnd = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andPreceding(int number) {
        this.frameEnd = -number;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andCurrentRow() {
        this.frameEnd = 0;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andUnboundedFollowing() {
        this.frameEnd = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep andFollowing(int number) {
        this.frameEnd = number;
        return this;
    }

    static enum FrameUnits {
        ROWS("rows"),
        RANGE("range");

        private final Keyword keyword;

        private FrameUnits(String keyword) {
            this.keyword = DSL.keyword(keyword);
        }
    }
}

