/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMessage;

public class VariantHeader
implements Variant {
    @Deprecated
    public static final String[] injectableHeaders = new String[]{"user-agent", "referer", "host"};
    private static final String[] injectablesTempArray = new String[]{"content-length".toLowerCase(Locale.ROOT), "pragma".toLowerCase(Locale.ROOT), "cache-control".toLowerCase(Locale.ROOT), "cookie".toLowerCase(Locale.ROOT), "authorization".toLowerCase(Locale.ROOT), "proxy-authorization".toLowerCase(Locale.ROOT), "connection".toLowerCase(Locale.ROOT), "proxy-connection".toLowerCase(Locale.ROOT), "if-modified-since".toLowerCase(Locale.ROOT), "if-none-match".toLowerCase(Locale.ROOT), "x-csrf-token".toLowerCase(Locale.ROOT), "x-csrftoken".toLowerCase(Locale.ROOT), "x-xsrf-token".toLowerCase(Locale.ROOT), "x-zap-scan-id".toLowerCase(Locale.ROOT), "x-zap-requestid".toLowerCase(Locale.ROOT), "x-security-proxy".toLowerCase(Locale.ROOT)};
    private static final HashSet<String> NON_INJECTABLE_HEADERS = new HashSet<String>(Arrays.asList(injectablesTempArray));
    private List<NameValuePair> params = Collections.emptyList();
    private static final String SHORT_NAME = "header";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void setMessage(HttpMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        ArrayList<NameValuePair> extractedParameters = new ArrayList<NameValuePair>();
        List<HttpHeaderField> httpHeaders = message.getRequestHeader().getHeaders();
        for (HttpHeaderField header : httpHeaders) {
            if (NON_INJECTABLE_HEADERS.contains(header.getName().toLowerCase(Locale.ROOT))) continue;
            extractedParameters.add(new NameValuePair(8, header.getName(), header.getValue(), extractedParameters.size()));
        }
        if (extractedParameters.isEmpty()) {
            this.params = Collections.emptyList();
        } else {
            extractedParameters.trimToSize();
            this.params = Collections.unmodifiableList(extractedParameters);
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        if ("host".equalsIgnoreCase(originalPair.getName())) {
            VariantHeader.getProperties(msg).put("host", value);
        }
        msg.getRequestHeader().setHeader(originalPair.getName(), value);
        if (value == null) {
            return "";
        }
        return originalPair.getName() + ": " + value;
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value);
    }

    private static Map<String, Object> getProperties(HttpMessage message) {
        HashMap userObject = message.getUserObject();
        if (!(userObject instanceof Map)) {
            userObject = new HashMap();
            message.setUserObject(userObject);
        }
        return userObject;
    }
}

