//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// Constants defining how long a credential will be kept around
///
///
///
///
/// Note: Whereas in Mac OS X any application can access any credential provided the user gives permission, on iOS an application can
/// access only its own credentials.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcredentialpersistence?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLCredentialPersistence(pub NSUInteger);
impl NSURLCredentialPersistence {
    #[doc(alias = "NSURLCredentialPersistenceNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSURLCredentialPersistenceForSession")]
    pub const ForSession: Self = Self(1);
    #[doc(alias = "NSURLCredentialPersistencePermanent")]
    pub const Permanent: Self = Self(2);
    #[doc(alias = "NSURLCredentialPersistenceSynchronizable")]
    pub const Synchronizable: Self = Self(3);
}

unsafe impl Encode for NSURLCredentialPersistence {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSURLCredentialPersistence {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// This class is an immutable object representing an authentication credential.  The actual type of the credential is determined by the constructor called in the categories declared below.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcredential?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLCredential;
);

unsafe impl Send for NSURLCredential {}

unsafe impl Sync for NSURLCredential {}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSURLCredential {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSURLCredential {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSURLCredential {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSURLCredential {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSURLCredential {}
);

impl NSURLCredential {
    extern_methods!(
        /// Determine whether this credential is or should be stored persistently
        ///
        /// Returns: A value indicating whether this credential is stored permanently, per session or not at all.
        #[unsafe(method(persistence))]
        #[unsafe(method_family = none)]
        pub fn persistence(&self) -> NSURLCredentialPersistence;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLCredential {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSURLCredential {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSInternetPassword.
///
/// This category defines the methods available to an NSURLCredential created to represent an internet password credential.  These are most commonly used for resources that require a username and password combination.
impl NSURLCredential {
    extern_methods!(
        #[cfg(feature = "NSString")]
        /// Initialize a NSURLCredential with a user and password
        ///
        /// Parameter `user`: the username
        ///
        /// Parameter `password`: the password
        ///
        /// Parameter `persistence`: enum that says to store per session, permanently or not at all
        ///
        /// Returns: The initialized NSURLCredential
        #[unsafe(method(initWithUser:password:persistence:))]
        #[unsafe(method_family = init)]
        pub fn initWithUser_password_persistence(
            this: Allocated<Self>,
            user: &NSString,
            password: &NSString,
            persistence: NSURLCredentialPersistence,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        /// Create a new NSURLCredential with a user and password
        ///
        /// Parameter `user`: the username
        ///
        /// Parameter `password`: the password
        ///
        /// Parameter `persistence`: enum that says to store per session, permanently or not at all
        ///
        /// Returns: The new autoreleased NSURLCredential
        #[unsafe(method(credentialWithUser:password:persistence:))]
        #[unsafe(method_family = none)]
        pub fn credentialWithUser_password_persistence(
            user: &NSString,
            password: &NSString,
            persistence: NSURLCredentialPersistence,
        ) -> Retained<NSURLCredential>;

        #[cfg(feature = "NSString")]
        /// Get the username
        ///
        /// Returns: The user string
        #[unsafe(method(user))]
        #[unsafe(method_family = none)]
        pub fn user(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Get the password
        ///
        /// Returns: The password string
        ///
        /// This method might actually attempt to retrieve the
        /// password from an external store, possible resulting in prompting,
        /// so do not call it unless needed.
        #[unsafe(method(password))]
        #[unsafe(method_family = none)]
        pub fn password(&self) -> Option<Retained<NSString>>;

        /// Find out if this credential has a password, without trying to get it
        ///
        /// Returns: YES if this credential has a password, otherwise NO
        ///
        /// If this credential's password is actually kept in an
        /// external store, the password method may return nil even if this
        /// method returns YES, since getting the password may fail, or the
        /// user may refuse access.
        #[unsafe(method(hasPassword))]
        #[unsafe(method_family = none)]
        pub fn hasPassword(&self) -> bool;
    );
}

/// NSClientCertificate.
///
/// This category defines the methods available to an NSURLCredential created to represent a client certificate credential.  Client certificates are commonly stored on the users computer in the keychain and must be presented to the server during a handshake.
impl NSURLCredential {
    extern_methods!(
        #[cfg(feature = "NSArray")]
        /// Returns an NSArray of SecCertificateRef objects representing the client certificate for this credential, if this credential was created with an identity and certificate.
        ///
        /// Returns: an NSArray of SecCertificateRef or NULL if this is a username/password credential
        #[unsafe(method(certificates))]
        #[unsafe(method_family = none)]
        pub fn certificates(&self) -> Retained<NSArray>;
    );
}

/// NSServerTrust.
impl NSURLCredential {
    extern_methods!();
}
