/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.about.AboutBundleGroupData;

class BundlePatternFilter
extends ViewerFilter {
    private StringMatcher matcher;

    BundlePatternFilter() {
    }

    public void setPattern(String searchPattern) {
        if (searchPattern == null || searchPattern.isEmpty()) {
            this.matcher = null;
        } else {
            String pattern = "*" + searchPattern + "*";
            this.matcher = new StringMatcher(pattern, true, false);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.matcher == null) {
            return true;
        }
        if (element instanceof AboutBundleData) {
            AboutBundleData data = (AboutBundleData)element;
            return this.matcher.matchWords(data.getName()) || this.matcher.matchWords(data.getProviderName()) || this.matcher.matchWords(data.getId());
        }
        if (element instanceof AboutBundleGroupData) {
            AboutBundleGroupData data = (AboutBundleGroupData)element;
            return this.matcher.matchWords(data.getName()) || this.matcher.matchWords(data.getProviderName()) || this.matcher.matchWords(data.getId());
        }
        return true;
    }
}

