package configurations

import (
	"fmt"
	"strings"
)

func uniqueAppendString(list []string, newItem string, ignoreCase bool) ([]string, bool) {
	found := false
	for _, temp := range list {
		if ignoreCase {
			if strings.EqualFold(strings.ToUpper(temp), strings.ToUpper(newItem)) {
				found = true
				break
			}
		} else {
			if strings.EqualFold(temp, newItem) {
				found = true
				break
			}
		}
	}
	if !found {
		list = append(list, newItem)
	}
	return list, !found
}

func getCharsetID(charset string) (int, error) {
	charsetMap := map[string]int{
		"US7ASCII":          0x1,
		"WE8DEC":            0x2,
		"WE8HP":             0x3,
		"US8PC437":          0x4,
		"WE8EBCDIC37":       0x5,
		"WE8EBCDIC500":      0x6,
		"WE8EBCDIC1140":     0x7,
		"WE8EBCDIC285":      0x8,
		"WE8EBCDIC1146":     0x9,
		"WE8PC850":          0xA,
		"D7DEC":             0xB,
		"F7DEC":             0xC,
		"S7DEC":             0xD,
		"E7DEC":             0xE,
		"SF7ASCII":          0xF,
		"NDK7DEC":           0x10,
		"I7DEC":             0x11,
		"NL7DEC":            0x12,
		"CH7DEC":            0x13,
		"YUG7ASCII":         0x14,
		"SF7DEC":            0x15,
		"TR7DEC":            0x16,
		"IW7IS960":          0x17,
		"IN8ISCII":          0x19,
		"WE8EBCDIC1148":     0x1b,
		"WE8PC858":          0x1c,
		"WE8ISO8859P1":      0x1f,
		"EE8ISO8859P2":      0x20,
		"SE8ISO8859P3":      0x21,
		"NEE8ISO8859P4":     0x22,
		"CL8ISO8859P5":      0x23,
		"AR8ISO8859P6":      0x24,
		"EL8ISO8859P7":      0x25,
		"IW8ISO8859P8":      0x26,
		"WE8ISO8859P9":      0x27,
		"NE8ISO8859P10":     0x28,
		"TH8TISASCII":       0x29,
		"TH8TISEBCDIC":      0x2a,
		"BN8BSCII":          0x2b,
		"VN8VN3":            0x2c,
		"VN8MSWIN1258":      0x2d,
		"WE8ISO8859P15":     0x2e,
		"BLT8ISO8859P13":    0x2f,
		"CEL8ISO8859P14":    0x30,
		"CL8ISOIR111":       0x31,
		"WE8NEXTSTEP":       0x32,
		"CL8KOI8U":          0x33,
		"AZ8ISO8859P9E":     0x34,
		"AR8ASMO708PLUS":    0x3d,
		"AR8EBCDICX":        0x46,
		"AR8XBASIC":         0x48,
		"EL8DEC":            0x51,
		"TR8DEC":            0x52,
		"WE8EBCDIC37C":      0x5a,
		"WE8EBCDIC500C":     0x5b,
		"IW8EBCDIC424":      0x5c,
		"TR8EBCDIC1026":     0x5d,
		"WE8EBCDIC871":      0x5e,
		"WE8EBCDIC284":      0x5f,
		"WE8EBCDIC1047":     0x60,
		"WE8EBCDIC1140C":    0x61,
		"WE8EBCDIC1145":     0x62,
		"WE8EBCDIC1148C":    0x63,
		"WE8EBCDIC1047E":    0x64,
		"WE8EBCDIC924":      0x65,
		"EEC8EUROASCI":      0x6e,
		"EEC8EUROPA3":       0x71,
		"LA8PASSPORT":       0x72,
		"BG8PC437S":         0x8c,
		"EE8PC852":          0x96,
		"RU8PC866":          0x98,
		"RU8BESTA":          0x99,
		"IW8PC1507":         0x9a,
		"RU8PC855":          0x9b,
		"TR8PC857":          0x9c,
		"CL8MACCYRILLIC":    0x9e,
		"CL8MACCYRILLICS":   0x9f,
		"WE8PC860":          0xa0,
		"IS8PC861":          0xa1,
		"EE8MACCES":         0xa2,
		"EE8MACCROATIANS":   0xa3,
		"TR8MACTURKISHS":    0xa4,
		"IS8MACICELANDICS":  0xa5,
		"EL8MACGREEKS":      0xa6,
		"IW8MACHEBREWS":     0xa7,
		"EE8MSWIN1250":      0xaa,
		"CL8MSWIN1251":      0xab,
		"ET8MSWIN923":       0xac,
		"BG8MSWIN":          0xad,
		"EL8MSWIN1253":      0xae,
		"IW8MSWIN1255":      0xaf,
		"LT8MSWIN921":       0xb0,
		"TR8MSWIN1254":      0xb1,
		"WE8MSWIN1252":      0xb2,
		"BLT8MSWIN1257":     0xb3,
		"D8EBCDIC273":       0xb4,
		"I8EBCDIC280":       0xb5,
		"DK8EBCDIC277":      0xb6,
		"S8EBCDIC278":       0xb7,
		"EE8EBCDIC870":      0xb8,
		"CL8EBCDIC1025":     0xb9,
		"F8EBCDIC297":       0xba,
		"IW8EBCDIC1086":     0xbb,
		"CL8EBCDIC1025X":    0xbc,
		"D8EBCDIC1141":      0xbd,
		"N8PC865":           0xbe,
		"BLT8CP921":         0xbf,
		"LV8PC1117":         0xc0,
		"LV8PC8LR":          0xc1,
		"BLT8EBCDIC1112":    0xc2,
		"LV8RST104090":      0xc3,
		"CL8KOI8R":          0xc4,
		"BLT8PC775":         0xc5,
		"DK8EBCDIC1142":     0xc6,
		"S8EBCDIC1143":      0xc7,
		"I8EBCDIC1144":      0xc8,
		"F7SIEMENS9780X":    0xc9,
		"E7SIEMENS9780X":    0xca,
		"S7SIEMENS9780X":    0xcb,
		"DK7SIEMENS9780X":   0xcc,
		"N7SIEMENS9780X":    0xcd,
		"I7SIEMENS9780X":    0xce,
		"D7SIEMENS9780X":    0xcf,
		"F8EBCDIC1147":      0xd0,
		"WE8GCOS7":          0xd2,
		"EL8GCOS7":          0xd3,
		"US8BS2000":         0xdd,
		"D8BS2000":          0xde,
		"F8BS2000":          0xdf,
		"E8BS2000":          0xe0,
		"DK8BS2000":         0xe1,
		"S8BS2000":          0xe2,
		"WE8BS2000E":        0xe6,
		"WE8BS2000":         0xe7,
		"EE8BS2000":         0xe8,
		"CE8BS2000":         0xe9,
		"CL8BS2000":         0xeb,
		"WE8BS2000L5":       0xef,
		"WE8DG":             0xf1,
		"WE8NCR4970":        0xfb,
		"WE8ROMAN8":         0x105,
		"EE8MACCE":          0x106,
		"EE8MACCROATIAN":    0x107,
		"TR8MACTURKISH":     0x108,
		"IS8MACICELANDIC":   0x109,
		"EL8MACGREEK":       0x10a,
		"IW8MACHEBREW":      0x10b,
		"US8ICL":            0x115,
		"WE8ICL":            0x116,
		"WE8ISOICLUK":       0x117,
		"EE8EBCDIC870C":     0x12d,
		"EL8EBCDIC875S":     0x137,
		"TR8EBCDIC1026S":    0x138,
		"BLT8EBCDIC1112S":   0x13a,
		"IW8EBCDIC424S":     0x13b,
		"EE8EBCDIC870S":     0x13c,
		"CL8EBCDIC1025S":    0x13d,
		"TH8TISEBCDICS":     0x13f,
		"AR8EBCDIC420S":     0x140,
		"CL8EBCDIC1025C":    0x142,
		"CL8EBCDIC1025R":    0x143,
		"EL8EBCDIC875R":     0x144,
		"CL8EBCDIC1158":     0x145,
		"CL8EBCDIC1158R":    0x146,
		"EL8EBCDIC423R":     0x147,
		"WE8MACROMAN8":      0x15f,
		"WE8MACROMAN8S":     0x160,
		"TH8MACTHAI":        0x161,
		"TH8MACTHAIS":       0x162,
		"HU8CWI2":           0x170,
		"EL8PC437S":         0x17c,
		"EL8EBCDIC875":      0x17d,
		"EL8PC737":          0x17e,
		"LT8PC772":          0x17f,
		"LT8PC774":          0x180,
		"EL8PC869":          0x181,
		"EL8PC851":          0x182,
		"CDN8PC863":         0x186,
		"HU8ABMOD":          0x191,
		"AR8ASMO8X":         0x1f4,
		"AR8NAFITHA711T":    0x1f8,
		"AR8SAKHR707T":      0x1f9,
		"AR8MUSSAD768T":     0x1fa,
		"AR8ADOS710T":       0x1fb,
		"AR8ADOS720T":       0x1fc,
		"AR8APTEC715T":      0x1fd,
		"AR8NAFITHA721T":    0x1ff,
		"AR8HPARABIC8T":     0x202,
		"AR8NAFITHA711":     0x22a,
		"AR8SAKHR707":       0x22b,
		"AR8MUSSAD768":      0x22c,
		"AR8ADOS710":        0x22d,
		"AR8ADOS720":        0x22e,
		"AR8APTEC715":       0x22F,
		"AR8MSWIN1256":      0x230,
		"AR8NAFITHA721":     0x231,
		"AR8SAKHR706":       0x233,
		"AR8ARABICMAC":      0x235,
		"AR8ARABICMACS":     0x236,
		"AR8ARABICMACT":     0x237,
		"LA8ISO6937":        0x24E,
		"JA16VMS":           0x33D,
		"JA16EUC":           0x33E,
		"JA16EUCYEN":        0x33F,
		"JA16SJIS":          0x340,
		"JA16DBCS":          0x341,
		"JA16SJISYEN":       0x342,
		"JA16EBCDIC930":     0x343,
		"JA16MACSJIS":       0x344,
		"JA16EUCTILDE":      0x345,
		"JA16SJISTILDE":     0x346,
		"KO16KSC5601":       0x348,
		"KO16DBCS":          0x34A,
		"KO16KSCCS":         0x34D,
		"KO16MSWIN949":      0x34E,
		"ZHS16CGB231280":    0x352,
		"ZHS16MACCGB231280": 0x353,
		"ZHS16GBK":          0x354,
		"ZHS16DBCS":         0x355,
		"ZHT32EUC":          0x35C,
		"ZHT32SOPS":         0x35D,
		"ZHT16DBT":          0x35E,
		"ZHT32TRIS":         0x35F,
		"ZHT16DBCS":         0x360,
		"ZHT16BIG5":         0x361,
		"ZHT16CCDC":         0x362,
		"ZHT16MSWIN950":     0x363,
		"ZHT16HKSCS":        0x364,
		"AL24UTFFSS":        0x366,
		"UTF8":              0x367,
		"UTFE":              0x368,
		"AL32UTF8":          0x369,
		"ZHT16HKSCS31":      0x3E0,
		// "ZHS32GB18030" : 854,
		// "JA16EUCFIXED" : 1830,
		// "JA16SJISFIXED" : 1832,
		// "JA16DBCSFIXED" : 1833,
		// "KO16KSC5601FIXED" : 1840,
		// "KO16DBCSFIXED" : 1842,
		// "ZHS16CGB231280FIXED" : 1850,
		// "ZHS16GBKFIXED" : 1852,
		// "ZHS16DBCSFIXED" : 1853,
		// "ZHT32EUCFIXED" : 1860,
		// "ZHT32TRISFIXED" : 1863,
		// "ZHT16DBCSFIXED" : 1864,
		// "ZHT16BIG5FIXED" : 1865,
		"AL16UTF16": 0x7D0,
	}
	id, found := charsetMap[strings.ToUpper(charset)]
	if !found {
		return 0, fmt.Errorf("charset %s is not supported by the driver", charset)
	}
	return id, nil
}
