/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.ODMGCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;

public class IdentifierBag
extends ODMGCollection
implements List {
    private List values;
    private Map identifiers;

    public IdentifierBag(SessionImplementor session) {
        super(session);
    }

    public IdentifierBag() {
    }

    public IdentifierBag(SessionImplementor session, Collection coll) {
        super(session);
        if (coll instanceof List) {
            this.values = (List)coll;
        } else {
            this.values = new ArrayList();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                this.values.add(iter.next());
            }
        }
        this.initialized = true;
        this.directlyAccessible = true;
        this.identifiers = new HashMap();
    }

    public IdentifierBag(SessionImplementor session, CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        super(session);
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        int i = 0;
        while (i < array.length) {
            Object value = persister.getElementType().assemble(array[i + 1], session, owner);
            this.identifiers.put(value, persister.getIdentifierType().assemble(array[i], session, owner));
            this.values.add(value);
            i += 2;
        }
        this.initialized = true;
    }

    public boolean add(Object o) {
        this.write();
        this.values.add(o);
        return true;
    }

    public void clear() {
        this.write();
        this.values.clear();
        this.identifiers.clear();
    }

    public boolean contains(Object o) {
        this.read();
        return this.values.contains(o);
    }

    public boolean containsAll(Collection c) {
        this.read();
        return this.values.containsAll(c);
    }

    public boolean isEmpty() {
        this.read();
        return this.values.isEmpty();
    }

    public Iterator iterator() {
        this.read();
        return this.values.iterator();
    }

    public boolean remove(Object o) {
        this.write();
        return this.values.remove(o);
    }

    public boolean removeAll(Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.values.removeAll(c);
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        this.write();
        return this.values.retainAll(c);
    }

    public int size() {
        this.read();
        return this.values.size();
    }

    public Object[] toArray() {
        this.read();
        return this.values.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.read();
        return this.values.toArray();
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.identifiers = new HashMap();
        this.values = new ArrayList();
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Serializable[] result = new Serializable[this.values.size() * 2];
        Iterator iter = this.values.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            result[i++] = persister.getIdentifierType().disassemble(this.identifiers.get(value), this.session);
            result[i++] = persister.getElementType().disassemble(value, this.session);
        }
        return result;
    }

    public Iterator elements() {
        return this.values.iterator();
    }

    public boolean empty() {
        return this.values.isEmpty();
    }

    public Iterator entries() {
        return this.values.iterator();
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        if (snap.size() != this.values.size()) {
            return false;
        }
        Iterator iter = this.values.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object id;
            Object value = iter.next();
            if ((id = this.identifiers.get(new Integer(i++))) == null) {
                return false;
            }
            Object old = snap.get(id);
            if (!elementType.isDirty(old, value, this.session)) continue;
            return false;
        }
        return true;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        ArrayList deletes = new ArrayList(snap.keySet());
        Iterator iter = this.values.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            deletes.remove(this.identifiers.get(new Integer(i++)));
        }
        return deletes.iterator();
    }

    public Object getIndex(Object entry, int i) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(new Integer(i));
        return entry != null && (id == null || snap.get(id) == null);
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        if (entry == null) {
            return false;
        }
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(new Integer(i));
        if (id == null) {
            return false;
        }
        Object old = snap.get(id);
        return entry != null && old != null && elemType.isDirty(old, entry, this.session);
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.session);
        this.values.add(element);
        this.identifiers.put(new Integer(this.values.size() - 1), persister.readIdentifier(rs, this.session));
        return element;
    }

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        HashMap map = new HashMap(this.values.size());
        Iterator iter = this.values.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            map.put(this.identifiers.get(new Integer(i++)), persister.getElementType().deepCopy(value));
        }
        return map;
    }

    public void preInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
        try {
            Serializable id = persister.getIdentifierGenerator().generate(this.session, entry);
            this.identifiers.put(new Integer(i), id);
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not generate collection row id", sqle);
        }
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
        persister.writeIdentifier(st, this.identifiers.get(new Integer(i)), writeOrder, this.session);
    }

    public void add(int index, Object element) {
        this.write();
        this.values.add(index, element);
    }

    public boolean addAll(int index, Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.values.addAll(index, c);
        }
        return false;
    }

    public Object get(int index) {
        this.read();
        return this.values.get(index);
    }

    public int indexOf(Object o) {
        this.read();
        return this.values.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        this.read();
        return this.values.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.read();
        return this.values.listIterator();
    }

    public ListIterator listIterator(int index) {
        this.read();
        return this.values.listIterator(index);
    }

    public Object remove(int index) {
        this.write();
        return this.values.remove(index);
    }

    public Object set(int index, Object element) {
        this.write();
        return this.values.set(index, element);
    }

    public List subList(int fromIndex, int toIndex) {
        this.read();
        return this.values.subList(fromIndex, toIndex);
    }

    public boolean addAll(Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.values.addAll(c);
        }
        return false;
    }
}

