/*
 *    This program written by Edward Der-Hua Liu,Taiwan for xcin-2.1b
 *              fix by Pa,Taiwan for zh-kcfonts-1.0x
 *                                                   PM5:30 12/16/1997
 *
 */

#include <stdio.h>

char bdfhead[]=
"STARTFONT 2.1\n"
"COMMENT X\n"
"FONT kc8x15\n"
"SIZE 15 100 100\n"
"FONTBOUNDINGBOX 8 15 0 -1\n"
"STARTPROPERTIES 19\n"
"FONTNAME_REGISTRY \"\"\n"
"FOUNDRY \"Kau Chauo\"\n"
"FAMILY_NAME \"Fixed\"\n"
"WEIGHT_NAME \"Medium\"\n"
"SLANT \"R\"\n"
"SETWIDTH_NAME \"Normal\"\n"
"ADD_STYLE_NAME \"\"\n"
"PIXEL_SIZE 15\n"
"POINT_SIZE 170\n"
"RESOLUTION_X 100\n"
"RESOLUTION_Y 100\n"
"SPACING \"C\"\n"
"AVERAGE_WIDTH 80\n"
"CHARSET_REGISTRY \"ISO8859\"\n"
"CHARSET_ENCODING \"1\"\n"
"DEFAULT_CHAR 32\n"
"FONT_DESCENT 1\n"
"FONT_ASCENT 14\n"
"COPYRIGHT \"Kau Chauo Business CO.\"\n"
"ENDPROPERTIES\n"
"CHARS 256\n";


void main( void )
{
	FILE *fr,*fw;
	int i,j;

	if ((fr=fopen("ascfont.15", "rb"))==NULL) {
		fprintf(stderr,"kc8x15 Error: can't open ascfont.15\n");
		exit(1);
	}

	fw=stdout;
	fputs(bdfhead,fw);

	for(i=0;i<256;i++) {
		fprintf(fw, "STARTCHAR C%03d\n", i);
		fprintf(fw, "ENCODING %d\n", i); 
		fprintf(fw, "SWIDTH 508 0\n");
		fprintf(fw, "DWIDTH 8 0\n");
		fprintf(fw, "BBX 8 15 0 -1\n");
		fprintf(fw, "BITMAP\n");
  
		for(j=0;j<15;j++) {
			unsigned char tt[2];
			fread(tt,1,1, fr);
			fprintf(fw, "%02x\n", tt[0]);
		}

		fprintf(fw, "ENDCHAR\n");

	}

	fprintf(fw, "ENDFONT\n");
}
