/*
   IPSec ESP and AH support.

   SPDX-FileCopyrightText: 2005 Maurice Massar
   SPDX-FileCopyrightText: 2023 Jolla Ltd.

   SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef VPNC_TUNIP_H
#define VPNC_TUNIP_H

#include "isakmp.h"

#include <time.h>
#include <net/if.h>

struct lifetime {
	time_t start;
	uint32_t seconds;
	uint32_t kbytes;
	uint32_t rx;
	uint32_t tx;
};

struct ike_sa {
	uint32_t spi;
	uint32_t seq_id;  /* for replay protection */
	uint32_t seq_backlog;

	uint8_t *key;
	uint8_t *key_cry;
	gcry_cipher_hd_t cry_ctx;
	uint8_t *key_md;

	/* Description of the packet being processed */
	unsigned char *buf;
	unsigned int bufsize, bufpayload, var_header_size;
	int buflen;
};

struct encap_method; /* private to tunip.c */

enum natt_active_mode_enum {
	NATT_ACTIVE_NONE,
	NATT_ACTIVE_CISCO_UDP, /* isakmp and esp on different ports => never encap */
	NATT_ACTIVE_DRAFT_OLD, /* as in natt-draft 0 and 1 */
	NATT_ACTIVE_RFC        /* draft 2 and RFC3947 / RFC3948 */
};

struct sa_block {
	const char *pidfile;

	int tun_fd; /* fd to host via tun/tap */
	char tun_name[IFNAMSIZ];
	uint8_t tun_hwaddr[ETH_ALEN];

	struct in_addr dst; /* ip of concentrator, must be set */
	struct in_addr src; /* local ip, from getsockname() */

	struct in_addr opt_src_ip; /* configured local ip, can be 0.0.0.0 */

	/* these sockets are connect()ed */
	int ike_fd; /* fd over isakmp traffic, and in case of NAT-T esp too */
	int esp_fd; /* raw socket for ip-esp or Cisco-UDP or ike_fd (NAT-T) */

	struct {
		int timeout;
		uint8_t *resend_hash;
		uint16_t src_port, dst_port;
		uint8_t i_cookie[ISAKMP_COOKIE_LENGTH];
		uint8_t r_cookie[ISAKMP_COOKIE_LENGTH];
		uint8_t *key; /* ike encryption key */
		size_t keylen;
		uint8_t *initial_iv;
		uint8_t *skeyid_a;
		uint8_t *skeyid_d;
		int auth_algo; /* PSK, PSK+Xauth, Hybrid ToDo: Cert/... */
		int cry_algo, md_algo;
		size_t ivlen, md_len;
		uint8_t current_iv_msgid[4];
		uint8_t *current_iv;
		struct lifetime life;
		int do_dpd;
		int dpd_idle;
		uint32_t dpd_seqno;
		uint32_t dpd_seqno_ack;
		time_t dpd_sent;
		unsigned int dpd_attempts;
		uint8_t *psk_hash;
		uint8_t *sa_f, *idi_f;
		size_t sa_size, idi_size;
		uint8_t *dh_public;
		struct group *dh_grp;
		uint8_t i_nonce[20];
		uint8_t *returned_hash;
		int natd_type;
		uint8_t *natd_us, *natd_them;
	} ike;
	struct in_addr our_address;
	struct {
		int do_pfs;
		int cry_algo, md_algo;
		size_t key_len, md_len;
		size_t blk_len, iv_len;
		uint16_t encap_mode;
		uint16_t peer_udpencap_port;
		enum natt_active_mode_enum natt_active_mode;
		struct lifetime life;
		struct ike_sa rx, tx;
		struct encap_method *em;
		uint16_t ip_id;
		uint8_t current_udp_tos;
	} ipsec;
};

extern int volatile do_kill;
extern void vpnc_doit(struct sa_block *s);

#endif /* VPNC_TUNIP_H */
