/*
 * Decompiled with CFR 0.152.
 */
package sjpp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.ListIterator;
import sjpp.Context;
import sjpp.ContextMode;
import sjpp.Directive;

public class JavaFile {
    private final Context context;
    private final List<String> lines;
    private final Path path;
    private String packageName;

    public JavaFile(Context context, Path path) throws IOException {
        this.path = path;
        this.context = context;
        this.lines = Files.readAllLines(path);
        for (String s : this.lines) {
            if (s.startsWith("package ")) {
                int x = s.indexOf(59);
                if (x == -1) continue;
                this.packageName = s.substring("package ".length(), x).trim();
                continue;
            }
            Directive dir = Directive.directiveInLine(s);
            switch (dir) {
                case IMPORT: {
                    break;
                }
                case REMOVE_CURRENT_FOLDER: {
                    if (!context.doesApplyOn(s)) break;
                    context.removeCurrentFolder(this.packageName);
                    break;
                }
                case REMOVE_FOLDER_AND_SUBFOLDERS: {
                    if (!context.doesApplyOn(s)) break;
                    context.removeFolderAndSubfolders(this.packageName);
                    break;
                }
                case REMOVE_FILE: {
                    if (!context.doesApplyOn(s)) break;
                    context.removeFile(this);
                }
            }
        }
        if (this.packageName == null) {
            throw new IllegalArgumentException(path.toString());
        }
    }

    public String toString() {
        return this.path.toString();
    }

    public void process() {
        if (this.context.getMode() == ContextMode.REGULAR) {
            this.removeFirstHeader();
        }
        if (this.context.getHeader() != null) {
            this.lines.addAll(0, this.context.getHeader().getLines());
        }
        ProcessMode mode = ProcessMode.NORMAL;
        ListIterator<String> it = this.lines.listIterator();
        while (it.hasNext()) {
            String line = it.next();
            Directive dir = Directive.directiveInLine(line);
            if (dir == Directive.IMPORT) {
                int x = line.indexOf(59);
                String importName = line.substring("import ".length(), x).trim();
                boolean removeImportLine = this.context.removeImportLine(importName);
                if (!removeImportLine) continue;
                this.commentThisLine(it, line);
                continue;
            }
            if (dir == Directive.UNCOMMENT && this.context.doesApplyOn(line)) {
                mode = ProcessMode.UNCOMMENT;
                this.removeLineIfRegularMode(it);
                continue;
            }
            if (dir == Directive.COMMENT && this.context.doesApplyOn(line)) {
                mode = ProcessMode.COMMENT;
                this.removeLineIfRegularMode(it);
                continue;
            }
            if (dir == Directive.REVERT && this.context.doesApplyOn(line)) {
                mode = ProcessMode.REVERT;
                this.removeLineIfRegularMode(it);
                continue;
            }
            if (dir == Directive.DONE) {
                mode = ProcessMode.NORMAL;
                this.removeLineIfRegularMode(it);
                continue;
            }
            if (mode == ProcessMode.COMMENT) {
                this.commentThisLine(it, line);
                continue;
            }
            if (mode == ProcessMode.UNCOMMENT) {
                this.uncommentThisLine(it, line);
                continue;
            }
            if (mode != ProcessMode.REVERT) continue;
            this.revertThisLine(it, line);
        }
    }

    private void revertThisLine(ListIterator<String> it, String line) {
        if (this.isCommented(line)) {
            this.uncommentThisLine(it, line);
        } else {
            this.commentThisLine(it, line);
        }
    }

    private boolean isCommented(String line) {
        return line.replaceAll("\\s+", "").startsWith("//");
    }

    private void uncommentThisLine(ListIterator<String> it, String line) {
        if (this.isCommented(line)) {
            it.set(line.replaceFirst("//", ""));
        }
    }

    protected void commentThisLine(ListIterator<String> it, String line) {
        if (this.context.getMode() == ContextMode.DEBUG) {
            it.set("// " + line);
        } else {
            it.remove();
        }
    }

    private void removeFirstHeader() {
        if (!this.lines.get(0).startsWith("/*")) {
            return;
        }
        ListIterator<String> it = this.lines.listIterator();
        while (it.hasNext()) {
            String line = it.next();
            it.remove();
            if (!line.endsWith("*/")) continue;
            return;
        }
    }

    protected void removeLineIfRegularMode(ListIterator<String> it) {
        if (this.context.getMode() == ContextMode.REGULAR) {
            it.remove();
        }
    }

    public boolean isItMe(String name) {
        String signature = this.path.toAbsolutePath().toFile().getAbsolutePath().replaceAll("[^-\\w]", ".");
        signature = signature.replaceAll("\\.java$", "");
        return signature.endsWith(name);
    }

    public Path getNewPath(Path out) {
        Path root = this.context.getRoot();
        if (!this.path.toString().startsWith(root.toString())) {
            throw new IllegalStateException();
        }
        String relative = this.path.toString().substring(root.toString().length());
        String newPath = out.toString() + relative;
        return Paths.get(newPath, new String[0]);
    }

    public void save(Path newPath) throws IOException {
        this.lines.add(0, "// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.");
        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
        Files.write(newPath, this.lines, new OpenOption[0]);
    }

    public final String getPackageName() {
        return this.packageName;
    }

    static enum ProcessMode {
        NORMAL,
        COMMENT,
        UNCOMMENT,
        REVERT;

    }
}

