#ifndef DYNAMITEhspscaninterfaceHEADERFILE
#define DYNAMITEhspscaninterfaceHEADERFILE
#ifdef _cplusplus
extern "C" {
#endif
#include "hsp.h"


struct Wise2_HSPScanInterfacePara {  
    int dynamite_hard_link;  
#ifdef PTHREAD   
    pthread_mutex_t dynamite_mutex;  
#endif   
    int min_score;   
    int max_results;     
    int flags;   
    boolean use_protein_heuristic;   
    } ;  
/* HSPScanInterfacePara defined */ 
#ifndef DYNAMITE_DEFINED_HSPScanInterfacePara
typedef struct Wise2_HSPScanInterfacePara Wise2_HSPScanInterfacePara;
#define HSPScanInterfacePara Wise2_HSPScanInterfacePara
#define DYNAMITE_DEFINED_HSPScanInterfacePara
#endif


struct Wise2_HSPScanInterface {  
    int dynamite_hard_link;  
#ifdef PTHREAD   
    pthread_mutex_t dynamite_mutex;  
#endif   
    LinearHSPmanager * (*scan_query)(void *,Sequence *,HSPScanInterfacePara * para); 
    void (*free_data)(void*);    
    void * data;     
    } ;  
/* HSPScanInterface defined */ 
#ifndef DYNAMITE_DEFINED_HSPScanInterface
typedef struct Wise2_HSPScanInterface Wise2_HSPScanInterface;
#define HSPScanInterface Wise2_HSPScanInterface
#define DYNAMITE_DEFINED_HSPScanInterface
#endif




    /***************************************************/
    /* Callable functions                              */
    /* These are the functions you are expected to use */
    /***************************************************/



/* Function:  free_HSPScanInterface(hsi)
 *
 * Descrip:    Frees overrides dynamite default
 *
 *
 * Arg:        hsi [UNKN ] Undocumented argument [HSPScanInterface *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterface *]
 *
 */
HSPScanInterface * Wise2_free_HSPScanInterface(HSPScanInterface * hsi);
#define free_HSPScanInterface Wise2_free_HSPScanInterface


/* Function:  hard_link_HSPScanInterfacePara(obj)
 *
 * Descrip:    Bumps up the reference count of the object
 *             Meaning that multiple pointers can 'own' it
 *
 *
 * Arg:        obj [UNKN ] Object to be hard linked [HSPScanInterfacePara *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterfacePara *]
 *
 */
HSPScanInterfacePara * Wise2_hard_link_HSPScanInterfacePara(HSPScanInterfacePara * obj);
#define hard_link_HSPScanInterfacePara Wise2_hard_link_HSPScanInterfacePara


/* Function:  HSPScanInterfacePara_alloc(void)
 *
 * Descrip:    Allocates structure: assigns defaults if given 
 *
 *
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterfacePara *]
 *
 */
HSPScanInterfacePara * Wise2_HSPScanInterfacePara_alloc(void);
#define HSPScanInterfacePara_alloc Wise2_HSPScanInterfacePara_alloc


/* Function:  free_HSPScanInterfacePara(obj)
 *
 * Descrip:    Free Function: removes the memory held by obj
 *             Will chain up to owned members and clear all lists
 *
 *
 * Arg:        obj [UNKN ] Object that is free'd [HSPScanInterfacePara *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterfacePara *]
 *
 */
HSPScanInterfacePara * Wise2_free_HSPScanInterfacePara(HSPScanInterfacePara * obj);
#define free_HSPScanInterfacePara Wise2_free_HSPScanInterfacePara


/* Function:  hard_link_HSPScanInterface(obj)
 *
 * Descrip:    Bumps up the reference count of the object
 *             Meaning that multiple pointers can 'own' it
 *
 *
 * Arg:        obj [UNKN ] Object to be hard linked [HSPScanInterface *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterface *]
 *
 */
HSPScanInterface * Wise2_hard_link_HSPScanInterface(HSPScanInterface * obj);
#define hard_link_HSPScanInterface Wise2_hard_link_HSPScanInterface


/* Function:  HSPScanInterface_alloc(void)
 *
 * Descrip:    Allocates structure: assigns defaults if given 
 *
 *
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterface *]
 *
 */
HSPScanInterface * Wise2_HSPScanInterface_alloc(void);
#define HSPScanInterface_alloc Wise2_HSPScanInterface_alloc


  /* Unplaced functions */
  /* There has been no indication of the use of these functions */


    /***************************************************/
    /* Internal functions                              */
    /* you are not expected to have to call these      */
    /***************************************************/

#ifdef _cplusplus
}
#endif

#endif
