# RabbitMQ Server

[RabbitMQ](https://www.rabbitmq.com) is a [feature rich](https://www.rabbitmq.com/docs), multi-protocol messaging broker. It supports:

 * AMQP 0-9-1
 * AMQP 1.0
 * MQTT 3.1.1
 * STOMP 1.0 through 1.2


## Installation

 * [Installation guides](https://www.rabbitmq.com/docs/download) for various platforms
 * [Kubernetes Cluster Operator](https://www.rabbitmq.com/kubernetes/operator/operator-overview)
 * [Releases](https://github.com/rabbitmq/rabbitmq-server/releases) on GitHub
 * [Supported and unsupported series](https://www.rabbitmq.com/release-information)
 * [Supported Erlang versions](https://www.rabbitmq.com/docs/which-erlang)


## Tutorials & Documentation

 * [RabbitMQ tutorials](https://www.rabbitmq.com/tutorials)
 * [All documentation guides](https://www.rabbitmq.com/docs)
 * [CLI tools guide](https://www.rabbitmq.com/docs/cli)
 * [Configuration guide](https://www.rabbitmq.com/docs/configure)
 * [Client libraries and tools](https://www.rabbitmq.com/client-libraries/devtools)
 * [Monitoring guide](https://www.rabbitmq.com/docs/monitoring)
 * [Production checklist](https://www.rabbitmq.com/docs/production-checklist)
 * [Runnable tutorials](https://github.com/rabbitmq/rabbitmq-tutorials/)
 * [Documentation source](https://github.com/rabbitmq/rabbitmq-website/)


## Getting Help

 * [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
 * [Commercial support](https://tanzu.vmware.com/rabbitmq/oss) from [Broadcom](https://tanzu.vmware.com) for open source RabbitMQ
 * [Community Discord](https://www.rabbitmq.com/discord)
 * [Community Slack](https://www.rabbitmq.com/slack)
 * `#rabbitmq` on Freenode


## Contributing

See [CONTRIBUTING.md](./CONTRIBUTING.md) and our [development process overview](https://www.rabbitmq.com/github).

Questions about contributing, internals and so on are very welcome on the [mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Licensing

RabbitMQ server is [licensed under the MPL 2.0](LICENSE-MPL-RabbitMQ).


## Building From Source and Packaging

 * [Building RabbitMQ from Source](https://www.rabbitmq.com/docs/build-server)
 * [Building RabbitMQ Distribution Packages](https://www.rabbitmq.com/docs/build-server)


## Copyright

(c) 2007-2024 Broadcom. The term “Broadcom” refers to Broadcom Inc. and/or its subsidiaries. All rights reserved.
